// content/public/common/window_container_type.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "content/public/common/window_container_type.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "content/public/common/window_container_type.mojom-params-data.h"
namespace content {
namespace mojom {

std::string WindowContainerTypeToString(WindowContainerType value) {
  switch(value) {
    case WindowContainerType::NORMAL:
      return "WindowContainerType::NORMAL";
    case WindowContainerType::BACKGROUND:
      return "WindowContainerType::BACKGROUND";
    case WindowContainerType::PERSISTENT:
      return "WindowContainerType::PERSISTENT";
    default:
      return base::StringPrintf("Unknown WindowContainerType value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, WindowContainerType value) {
  return os << WindowContainerTypeToString(value);
}

namespace internal {

}  // namespace internal
}  // namespace mojom
}  // namespace content

namespace perfetto {

// static
void TraceFormatTraits<::content::mojom::WindowContainerType>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::content::mojom::WindowContainerType value) {
  return std::move(context).WriteString(::content::mojom::WindowContainerTypeToString(value));
}

} // namespace perfetto
