// device/gamepad/public/mojom/gamepad.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "device/gamepad/public/mojom/gamepad.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "device/gamepad/public/mojom/gamepad.mojom-params-data.h"
#include "device/gamepad/public/mojom/gamepad.mojom-shared-message-ids.h"

#include "device/gamepad/public/mojom/gamepad.mojom-import-headers.h"


#ifndef DEVICE_GAMEPAD_PUBLIC_MOJOM_GAMEPAD_MOJOM_JUMBO_H_
#define DEVICE_GAMEPAD_PUBLIC_MOJOM_GAMEPAD_MOJOM_JUMBO_H_
#endif
namespace device {
namespace mojom {
GamepadQuaternion::GamepadQuaternion()
    : x(),
      y(),
      z(),
      w() {}

GamepadQuaternion::GamepadQuaternion(
    float x_in,
    float y_in,
    float z_in,
    float w_in)
    : x(std::move(x_in)),
      y(std::move(y_in)),
      z(std::move(z_in)),
      w(std::move(w_in)) {}

GamepadQuaternion::~GamepadQuaternion() = default;

void GamepadQuaternion::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "x"), this->x, 
      "<value of type float>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "y"), this->y, 
      "<value of type float>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "z"), this->z, 
      "<value of type float>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "w"), this->w, 
      "<value of type float>");
}

bool GamepadQuaternion::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
GamepadVector::GamepadVector()
    : x(),
      y(),
      z() {}

GamepadVector::GamepadVector(
    float x_in,
    float y_in,
    float z_in)
    : x(std::move(x_in)),
      y(std::move(y_in)),
      z(std::move(z_in)) {}

GamepadVector::~GamepadVector() = default;

void GamepadVector::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "x"), this->x, 
      "<value of type float>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "y"), this->y, 
      "<value of type float>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "z"), this->z, 
      "<value of type float>");
}

bool GamepadVector::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
GamepadButton::GamepadButton()
    : pressed(),
      touched(),
      value() {}

GamepadButton::GamepadButton(
    bool pressed_in,
    bool touched_in,
    double value_in)
    : pressed(std::move(pressed_in)),
      touched(std::move(touched_in)),
      value(std::move(value_in)) {}

GamepadButton::~GamepadButton() = default;

void GamepadButton::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pressed"), this->pressed, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "touched"), this->touched, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value, 
      "<value of type double>");
}

bool GamepadButton::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
GamepadPose::GamepadPose()
    : orientation(),
      position(),
      angular_velocity(),
      linear_velocity(),
      angular_acceleration(),
      linear_acceleration() {}

GamepadPose::GamepadPose(
    const ::device::GamepadQuaternion& orientation_in,
    const ::device::GamepadVector& position_in,
    const ::device::GamepadVector& angular_velocity_in,
    const ::device::GamepadVector& linear_velocity_in,
    const ::device::GamepadVector& angular_acceleration_in,
    const ::device::GamepadVector& linear_acceleration_in)
    : orientation(std::move(orientation_in)),
      position(std::move(position_in)),
      angular_velocity(std::move(angular_velocity_in)),
      linear_velocity(std::move(linear_velocity_in)),
      angular_acceleration(std::move(angular_acceleration_in)),
      linear_acceleration(std::move(linear_acceleration_in)) {}

GamepadPose::~GamepadPose() = default;

void GamepadPose::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "orientation"), this->orientation, 
      "<value of type const ::device::GamepadQuaternion&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "position"), this->position, 
      "<value of type const ::device::GamepadVector&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "angular_velocity"), this->angular_velocity, 
      "<value of type const ::device::GamepadVector&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "linear_velocity"), this->linear_velocity, 
      "<value of type const ::device::GamepadVector&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "angular_acceleration"), this->angular_acceleration, 
      "<value of type const ::device::GamepadVector&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "linear_acceleration"), this->linear_acceleration, 
      "<value of type const ::device::GamepadVector&>");
}

bool GamepadPose::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
GamepadHapticActuator::GamepadHapticActuator()
    : type() {}

GamepadHapticActuator::GamepadHapticActuator(
    ::device::GamepadHapticActuatorType type_in)
    : type(std::move(type_in)) {}

GamepadHapticActuator::~GamepadHapticActuator() = default;

void GamepadHapticActuator::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type, 
      "<value of type ::device::GamepadHapticActuatorType>");
}

bool GamepadHapticActuator::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Gamepad::Gamepad()
    : connected(),
      id(),
      timestamp(),
      axes(),
      buttons(),
      vibration_actuator(),
      mapping(),
      pose(),
      hand(),
      display_id() {}

Gamepad::Gamepad(
    bool connected_in,
    std::vector<uint16_t> id_in,
    int64_t timestamp_in,
    std::vector<double> axes_in,
    std::vector<::device::GamepadButton> buttons_in,
    const ::device::GamepadHapticActuator& vibration_actuator_in,
    ::device::GamepadMapping mapping_in,
    const ::device::GamepadPose& pose_in,
    ::device::GamepadHand hand_in,
    uint32_t display_id_in)
    : connected(std::move(connected_in)),
      id(std::move(id_in)),
      timestamp(std::move(timestamp_in)),
      axes(std::move(axes_in)),
      buttons(std::move(buttons_in)),
      vibration_actuator(std::move(vibration_actuator_in)),
      mapping(std::move(mapping_in)),
      pose(std::move(pose_in)),
      hand(std::move(hand_in)),
      display_id(std::move(display_id_in)) {}

Gamepad::~Gamepad() = default;

void Gamepad::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "connected"), this->connected, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id, 
      "<value of type const std::vector<uint16_t>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "timestamp"), this->timestamp, 
      "<value of type int64_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "axes"), this->axes, 
      "<value of type const std::vector<double>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "buttons"), this->buttons, 
      "<value of type const std::vector<::device::GamepadButton>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "vibration_actuator"), this->vibration_actuator, 
      "<value of type const ::device::GamepadHapticActuator&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mapping"), this->mapping, 
      "<value of type ::device::GamepadMapping>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pose"), this->pose, 
      "<value of type const ::device::GamepadPose&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hand"), this->hand, 
      "<value of type ::device::GamepadHand>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "display_id"), this->display_id, 
      "<value of type uint32_t>");
}

bool Gamepad::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
GamepadEffectParameters::GamepadEffectParameters()
    : duration(),
      start_delay(),
      strong_magnitude(),
      weak_magnitude() {}

GamepadEffectParameters::GamepadEffectParameters(
    double duration_in,
    double start_delay_in,
    double strong_magnitude_in,
    double weak_magnitude_in)
    : duration(std::move(duration_in)),
      start_delay(std::move(start_delay_in)),
      strong_magnitude(std::move(strong_magnitude_in)),
      weak_magnitude(std::move(weak_magnitude_in)) {}

GamepadEffectParameters::~GamepadEffectParameters() = default;
size_t GamepadEffectParameters::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->duration);
  seed = mojo::internal::Hash(seed, this->start_delay);
  seed = mojo::internal::Hash(seed, this->strong_magnitude);
  seed = mojo::internal::Hash(seed, this->weak_magnitude);
  return seed;
}

void GamepadEffectParameters::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "duration"), this->duration, 
      "<value of type double>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "start_delay"), this->start_delay, 
      "<value of type double>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "strong_magnitude"), this->strong_magnitude, 
      "<value of type double>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "weak_magnitude"), this->weak_magnitude, 
      "<value of type double>");
}

bool GamepadEffectParameters::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char GamepadObserver::Name_[] = "device.mojom.GamepadObserver";

GamepadObserverProxy::GamepadObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void GamepadObserverProxy::GamepadConnected(
    uint32_t in_index, const ::device::Gamepad& in_gamepad) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::GamepadObserver::GamepadConnected", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("index"), in_index, 
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("gamepad"), in_gamepad, 
                        "<value of type const ::device::Gamepad&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGamepadObserver_GamepadConnected_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::GamepadObserver_GamepadConnected_Params_Data> params(
          message);
  params.Allocate();
  params->index = in_index;
  mojo::internal::MessageFragment<
      typename decltype(params->gamepad)::BaseType> gamepad_fragment(
          params.message());
  mojo::internal::Serialize<::device::mojom::GamepadDataView>(
      in_gamepad, gamepad_fragment);
  params->gamepad.Set(
      gamepad_fragment.is_null() ? nullptr : gamepad_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->gamepad.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null gamepad in GamepadObserver.GamepadConnected request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GamepadObserver::Name_);
  message.set_method_name("GamepadConnected");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void GamepadObserverProxy::GamepadDisconnected(
    uint32_t in_index, const ::device::Gamepad& in_gamepad) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::GamepadObserver::GamepadDisconnected", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("index"), in_index, 
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("gamepad"), in_gamepad, 
                        "<value of type const ::device::Gamepad&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGamepadObserver_GamepadDisconnected_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::GamepadObserver_GamepadDisconnected_Params_Data> params(
          message);
  params.Allocate();
  params->index = in_index;
  mojo::internal::MessageFragment<
      typename decltype(params->gamepad)::BaseType> gamepad_fragment(
          params.message());
  mojo::internal::Serialize<::device::mojom::GamepadDataView>(
      in_gamepad, gamepad_fragment);
  params->gamepad.Set(
      gamepad_fragment.is_null() ? nullptr : gamepad_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->gamepad.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null gamepad in GamepadObserver.GamepadDisconnected request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GamepadObserver::Name_);
  message.set_method_name("GamepadDisconnected");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void GamepadObserverProxy::GamepadButtonOrAxisChanged(
    uint32_t in_index, const ::device::Gamepad& in_gamepad) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::GamepadObserver::GamepadButtonOrAxisChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("index"), in_index, 
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("gamepad"), in_gamepad, 
                        "<value of type const ::device::Gamepad&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGamepadObserver_GamepadButtonOrAxisChanged_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::GamepadObserver_GamepadButtonOrAxisChanged_Params_Data> params(
          message);
  params.Allocate();
  params->index = in_index;
  mojo::internal::MessageFragment<
      typename decltype(params->gamepad)::BaseType> gamepad_fragment(
          params.message());
  mojo::internal::Serialize<::device::mojom::GamepadDataView>(
      in_gamepad, gamepad_fragment);
  params->gamepad.Set(
      gamepad_fragment.is_null() ? nullptr : gamepad_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->gamepad.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null gamepad in GamepadObserver.GamepadButtonOrAxisChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GamepadObserver::Name_);
  message.set_method_name("GamepadButtonOrAxisChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool GamepadObserverStubDispatch::Accept(
    GamepadObserver* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kGamepadObserver_GamepadConnected_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::GamepadObserver::GamepadConnected",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::GamepadObserver::GamepadConnected");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::GamepadObserver_GamepadConnected_Params_Data* params =
          reinterpret_cast<internal::GamepadObserver_GamepadConnected_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      uint32_t p_index{};
      ::device::Gamepad p_gamepad{};
      GamepadObserver_GamepadConnected_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_index = input_data_view.index();
      if (success && !input_data_view.ReadGamepad(&p_gamepad))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GamepadObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GamepadConnected(
std::move(p_index), 
std::move(p_gamepad));
      return true;
    }
    case internal::kGamepadObserver_GamepadDisconnected_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::GamepadObserver::GamepadDisconnected",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::GamepadObserver::GamepadDisconnected");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::GamepadObserver_GamepadDisconnected_Params_Data* params =
          reinterpret_cast<internal::GamepadObserver_GamepadDisconnected_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      uint32_t p_index{};
      ::device::Gamepad p_gamepad{};
      GamepadObserver_GamepadDisconnected_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_index = input_data_view.index();
      if (success && !input_data_view.ReadGamepad(&p_gamepad))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GamepadObserver::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GamepadDisconnected(
std::move(p_index), 
std::move(p_gamepad));
      return true;
    }
    case internal::kGamepadObserver_GamepadButtonOrAxisChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::GamepadObserver::GamepadButtonOrAxisChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::GamepadObserver::GamepadButtonOrAxisChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::GamepadObserver_GamepadButtonOrAxisChanged_Params_Data* params =
          reinterpret_cast<internal::GamepadObserver_GamepadButtonOrAxisChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      uint32_t p_index{};
      ::device::Gamepad p_gamepad{};
      GamepadObserver_GamepadButtonOrAxisChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_index = input_data_view.index();
      if (success && !input_data_view.ReadGamepad(&p_gamepad))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GamepadObserver::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GamepadButtonOrAxisChanged(
std::move(p_index), 
std::move(p_gamepad));
      return true;
    }
  }
  return false;
}

// static
bool GamepadObserverStubDispatch::AcceptWithResponder(
    GamepadObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kGamepadObserver_GamepadConnected_Name: {
      break;
    }
    case internal::kGamepadObserver_GamepadDisconnected_Name: {
      break;
    }
    case internal::kGamepadObserver_GamepadButtonOrAxisChanged_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kGamepadObserverValidationInfo[] = {
    {internal::kGamepadObserver_GamepadConnected_Name,
     {&internal::GamepadObserver_GamepadConnected_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kGamepadObserver_GamepadDisconnected_Name,
     {&internal::GamepadObserver_GamepadDisconnected_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kGamepadObserver_GamepadButtonOrAxisChanged_Name,
     {&internal::GamepadObserver_GamepadButtonOrAxisChanged_Params_Data::Validate,
      nullptr /* no response */}},
};

bool GamepadObserverRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::GamepadObserver::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kGamepadObserverValidationInfo);
}

const char GamepadMonitor::Name_[] = "device.mojom.GamepadMonitor";
bool GamepadMonitor::GamepadStartPolling(::base::ReadOnlySharedMemoryRegion* out_memory_region) {
  NOTREACHED();
  return false;
}
bool GamepadMonitor::GamepadStopPolling() {
  NOTREACHED();
  return false;
}
class GamepadMonitor_GamepadStartPolling_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  GamepadMonitor_GamepadStartPolling_HandleSyncResponse(
      bool* result, ::base::ReadOnlySharedMemoryRegion* out_memory_region)
      : result_(result), out_memory_region_(out_memory_region) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::base::ReadOnlySharedMemoryRegion* out_memory_region_;DISALLOW_COPY_AND_ASSIGN(GamepadMonitor_GamepadStartPolling_HandleSyncResponse);
};

class GamepadMonitor_GamepadStartPolling_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  GamepadMonitor_GamepadStartPolling_ForwardToCallback(
      GamepadMonitor::GamepadStartPollingCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  GamepadMonitor::GamepadStartPollingCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(GamepadMonitor_GamepadStartPolling_ForwardToCallback);
};
class GamepadMonitor_GamepadStopPolling_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  GamepadMonitor_GamepadStopPolling_HandleSyncResponse(
      bool* result)
      : result_(result) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;DISALLOW_COPY_AND_ASSIGN(GamepadMonitor_GamepadStopPolling_HandleSyncResponse);
};

class GamepadMonitor_GamepadStopPolling_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  GamepadMonitor_GamepadStopPolling_ForwardToCallback(
      GamepadMonitor::GamepadStopPollingCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  GamepadMonitor::GamepadStopPollingCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(GamepadMonitor_GamepadStopPolling_ForwardToCallback);
};

GamepadMonitorProxy::GamepadMonitorProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}
bool GamepadMonitorProxy::GamepadStartPolling(
    ::base::ReadOnlySharedMemoryRegion* out_param_memory_region) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "device::mojom::GamepadMonitor::GamepadStartPolling");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGamepadMonitor_GamepadStartPolling_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::GamepadMonitor_GamepadStartPolling_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GamepadMonitor::Name_);
  message.set_method_name("GamepadStartPolling");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GamepadMonitor_GamepadStartPolling_HandleSyncResponse(
          &result, out_param_memory_region));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "device::mojom::GamepadMonitor::GamepadStartPolling", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("memory_region"), out_param_memory_region, 
                        "<value of type ::base::ReadOnlySharedMemoryRegion>");
   });
#endif
  return result;
}

void GamepadMonitorProxy::GamepadStartPolling(
    GamepadStartPollingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "device::mojom::GamepadMonitor::GamepadStartPolling");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGamepadMonitor_GamepadStartPolling_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::GamepadMonitor_GamepadStartPolling_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GamepadMonitor::Name_);
  message.set_method_name("GamepadStartPolling");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GamepadMonitor_GamepadStartPolling_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool GamepadMonitorProxy::GamepadStopPolling(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "device::mojom::GamepadMonitor::GamepadStopPolling");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGamepadMonitor_GamepadStopPolling_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::GamepadMonitor_GamepadStopPolling_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GamepadMonitor::Name_);
  message.set_method_name("GamepadStopPolling");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GamepadMonitor_GamepadStopPolling_HandleSyncResponse(
          &result));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END0("mojom", "device::mojom::GamepadMonitor::GamepadStopPolling");
#endif
  return result;
}

void GamepadMonitorProxy::GamepadStopPolling(
    GamepadStopPollingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "device::mojom::GamepadMonitor::GamepadStopPolling");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGamepadMonitor_GamepadStopPolling_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::GamepadMonitor_GamepadStopPolling_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GamepadMonitor::Name_);
  message.set_method_name("GamepadStopPolling");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GamepadMonitor_GamepadStopPolling_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void GamepadMonitorProxy::SetObserver(
    ::mojo::PendingRemote<GamepadObserver> in_gamepad_observer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::GamepadMonitor::SetObserver", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("gamepad_observer"), in_gamepad_observer, 
                        "<value of type ::mojo::PendingRemote<GamepadObserver>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGamepadMonitor_SetObserver_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::GamepadMonitor_SetObserver_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::device::mojom::GamepadObserverInterfaceBase>>(
      in_gamepad_observer, &params->gamepad_observer, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->gamepad_observer),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid gamepad_observer in GamepadMonitor.SetObserver request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GamepadMonitor::Name_);
  message.set_method_name("SetObserver");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class GamepadMonitor_GamepadStartPolling_ProxyToResponder {
 public:
  static GamepadMonitor::GamepadStartPollingCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<GamepadMonitor_GamepadStartPolling_ProxyToResponder> proxy(
        new GamepadMonitor_GamepadStartPolling_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&GamepadMonitor_GamepadStartPolling_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~GamepadMonitor_GamepadStartPolling_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  GamepadMonitor_GamepadStartPolling_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "GamepadMonitor::GamepadStartPollingCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::ReadOnlySharedMemoryRegion in_memory_region);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(GamepadMonitor_GamepadStartPolling_ProxyToResponder);
};

bool GamepadMonitor_GamepadStartPolling_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "device::mojom::GamepadMonitor::GamepadStartPollingCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::GamepadMonitor_GamepadStartPolling_ResponseParams_Data* params =
      reinterpret_cast<
          internal::GamepadMonitor_GamepadStartPolling_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::base::ReadOnlySharedMemoryRegion p_memory_region{};
  GamepadMonitor_GamepadStartPolling_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadMemoryRegion(&p_memory_region))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GamepadMonitor::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_memory_region));
  return true;
}

void GamepadMonitor_GamepadStartPolling_ProxyToResponder::Run(
    ::base::ReadOnlySharedMemoryRegion in_memory_region) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)device::mojom::GamepadMonitor::GamepadStartPollingCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("memory_region"), in_memory_region, 
                        "<value of type ::base::ReadOnlySharedMemoryRegion>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGamepadMonitor_GamepadStartPolling_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::GamepadMonitor_GamepadStartPolling_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->memory_region)::BaseType> memory_region_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
      in_memory_region, memory_region_fragment);
  params->memory_region.Set(
      memory_region_fragment.is_null() ? nullptr : memory_region_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->memory_region.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null memory_region in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)device::mojom::GamepadMonitor::GamepadStartPollingCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GamepadMonitor::Name_);
  message.set_method_name("GamepadStartPolling");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool GamepadMonitor_GamepadStartPolling_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::GamepadMonitor_GamepadStartPolling_ResponseParams_Data* params =
      reinterpret_cast<internal::GamepadMonitor_GamepadStartPolling_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  ::base::ReadOnlySharedMemoryRegion p_memory_region{};
  GamepadMonitor_GamepadStartPolling_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadMemoryRegion(&p_memory_region))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GamepadMonitor::Name_, 0, true);
    return false;
  }
  *out_memory_region_ = std::move(p_memory_region);
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}
class GamepadMonitor_GamepadStopPolling_ProxyToResponder {
 public:
  static GamepadMonitor::GamepadStopPollingCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<GamepadMonitor_GamepadStopPolling_ProxyToResponder> proxy(
        new GamepadMonitor_GamepadStopPolling_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&GamepadMonitor_GamepadStopPolling_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~GamepadMonitor_GamepadStopPolling_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  GamepadMonitor_GamepadStopPolling_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "GamepadMonitor::GamepadStopPollingCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(GamepadMonitor_GamepadStopPolling_ProxyToResponder);
};

bool GamepadMonitor_GamepadStopPolling_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "device::mojom::GamepadMonitor::GamepadStopPollingCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::GamepadMonitor_GamepadStopPolling_ResponseParams_Data* params =
      reinterpret_cast<
          internal::GamepadMonitor_GamepadStopPolling_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  GamepadMonitor_GamepadStopPolling_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GamepadMonitor::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void GamepadMonitor_GamepadStopPolling_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)device::mojom::GamepadMonitor::GamepadStopPollingCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGamepadMonitor_GamepadStopPolling_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::GamepadMonitor_GamepadStopPolling_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)device::mojom::GamepadMonitor::GamepadStopPollingCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GamepadMonitor::Name_);
  message.set_method_name("GamepadStopPolling");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool GamepadMonitor_GamepadStopPolling_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::GamepadMonitor_GamepadStopPolling_ResponseParams_Data* params =
      reinterpret_cast<internal::GamepadMonitor_GamepadStopPolling_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  GamepadMonitor_GamepadStopPolling_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GamepadMonitor::Name_, 1, true);
    return false;
  }
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}

// static
bool GamepadMonitorStubDispatch::Accept(
    GamepadMonitor* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kGamepadMonitor_GamepadStartPolling_Name: {
      break;
    }
    case internal::kGamepadMonitor_GamepadStopPolling_Name: {
      break;
    }
    case internal::kGamepadMonitor_SetObserver_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::GamepadMonitor::SetObserver",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::GamepadMonitor::SetObserver");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::GamepadMonitor_SetObserver_Params_Data* params =
          reinterpret_cast<internal::GamepadMonitor_SetObserver_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<GamepadObserver> p_gamepad_observer{};
      GamepadMonitor_SetObserver_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_gamepad_observer =
            input_data_view.TakeGamepadObserver<decltype(p_gamepad_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GamepadMonitor::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetObserver(
std::move(p_gamepad_observer));
      return true;
    }
  }
  return false;
}

// static
bool GamepadMonitorStubDispatch::AcceptWithResponder(
    GamepadMonitor* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kGamepadMonitor_GamepadStartPolling_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::GamepadMonitor::GamepadStartPolling",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::GamepadMonitor::GamepadStartPolling");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::GamepadMonitor_GamepadStartPolling_Params_Data* params =
          reinterpret_cast<
              internal::GamepadMonitor_GamepadStartPolling_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      GamepadMonitor_GamepadStartPolling_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GamepadMonitor::Name_, 0, false);
        return false;
      }
      GamepadMonitor::GamepadStartPollingCallback callback =
          GamepadMonitor_GamepadStartPolling_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GamepadStartPolling(std::move(callback));
      return true;
    }
    case internal::kGamepadMonitor_GamepadStopPolling_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::GamepadMonitor::GamepadStopPolling",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::GamepadMonitor::GamepadStopPolling");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::GamepadMonitor_GamepadStopPolling_Params_Data* params =
          reinterpret_cast<
              internal::GamepadMonitor_GamepadStopPolling_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      GamepadMonitor_GamepadStopPolling_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GamepadMonitor::Name_, 1, false);
        return false;
      }
      GamepadMonitor::GamepadStopPollingCallback callback =
          GamepadMonitor_GamepadStopPolling_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GamepadStopPolling(std::move(callback));
      return true;
    }
    case internal::kGamepadMonitor_SetObserver_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kGamepadMonitorValidationInfo[] = {
    {internal::kGamepadMonitor_GamepadStartPolling_Name,
     {&internal::GamepadMonitor_GamepadStartPolling_Params_Data::Validate,
      &internal::GamepadMonitor_GamepadStartPolling_ResponseParams_Data::Validate}},
    {internal::kGamepadMonitor_GamepadStopPolling_Name,
     {&internal::GamepadMonitor_GamepadStopPolling_Params_Data::Validate,
      &internal::GamepadMonitor_GamepadStopPolling_ResponseParams_Data::Validate}},
    {internal::kGamepadMonitor_SetObserver_Name,
     {&internal::GamepadMonitor_SetObserver_Params_Data::Validate,
      nullptr /* no response */}},
};

bool GamepadMonitorRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::GamepadMonitor::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kGamepadMonitorValidationInfo);
}

bool GamepadMonitorResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::GamepadMonitor::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kGamepadMonitorValidationInfo);

}
const char GamepadHapticsManager::Name_[] = "device.mojom.GamepadHapticsManager";

class GamepadHapticsManager_PlayVibrationEffectOnce_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  GamepadHapticsManager_PlayVibrationEffectOnce_ForwardToCallback(
      GamepadHapticsManager::PlayVibrationEffectOnceCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  GamepadHapticsManager::PlayVibrationEffectOnceCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(GamepadHapticsManager_PlayVibrationEffectOnce_ForwardToCallback);
};

class GamepadHapticsManager_ResetVibrationActuator_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  GamepadHapticsManager_ResetVibrationActuator_ForwardToCallback(
      GamepadHapticsManager::ResetVibrationActuatorCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  GamepadHapticsManager::ResetVibrationActuatorCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(GamepadHapticsManager_ResetVibrationActuator_ForwardToCallback);
};

GamepadHapticsManagerProxy::GamepadHapticsManagerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void GamepadHapticsManagerProxy::PlayVibrationEffectOnce(
    uint32_t in_pad_index, GamepadHapticEffectType in_type, GamepadEffectParametersPtr in_params, PlayVibrationEffectOnceCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::GamepadHapticsManager::PlayVibrationEffectOnce", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pad_index"), in_pad_index, 
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type, 
                        "<value of type GamepadHapticEffectType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params, 
                        "<value of type GamepadEffectParametersPtr>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGamepadHapticsManager_PlayVibrationEffectOnce_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::GamepadHapticsManager_PlayVibrationEffectOnce_Params_Data> params(
          message);
  params.Allocate();
  params->pad_index = in_pad_index;
  mojo::internal::Serialize<::device::mojom::GamepadHapticEffectType>(
      in_type, &params->type);
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::device::mojom::GamepadEffectParametersDataView>(
      in_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in GamepadHapticsManager.PlayVibrationEffectOnce request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GamepadHapticsManager::Name_);
  message.set_method_name("PlayVibrationEffectOnce");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GamepadHapticsManager_PlayVibrationEffectOnce_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void GamepadHapticsManagerProxy::ResetVibrationActuator(
    uint32_t in_pad_index, ResetVibrationActuatorCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::GamepadHapticsManager::ResetVibrationActuator", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pad_index"), in_pad_index, 
                        "<value of type uint32_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGamepadHapticsManager_ResetVibrationActuator_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::GamepadHapticsManager_ResetVibrationActuator_Params_Data> params(
          message);
  params.Allocate();
  params->pad_index = in_pad_index;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GamepadHapticsManager::Name_);
  message.set_method_name("ResetVibrationActuator");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GamepadHapticsManager_ResetVibrationActuator_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class GamepadHapticsManager_PlayVibrationEffectOnce_ProxyToResponder {
 public:
  static GamepadHapticsManager::PlayVibrationEffectOnceCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<GamepadHapticsManager_PlayVibrationEffectOnce_ProxyToResponder> proxy(
        new GamepadHapticsManager_PlayVibrationEffectOnce_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&GamepadHapticsManager_PlayVibrationEffectOnce_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~GamepadHapticsManager_PlayVibrationEffectOnce_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  GamepadHapticsManager_PlayVibrationEffectOnce_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "GamepadHapticsManager::PlayVibrationEffectOnceCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      GamepadHapticsResult in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(GamepadHapticsManager_PlayVibrationEffectOnce_ProxyToResponder);
};

bool GamepadHapticsManager_PlayVibrationEffectOnce_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "device::mojom::GamepadHapticsManager::PlayVibrationEffectOnceCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::GamepadHapticsManager_PlayVibrationEffectOnce_ResponseParams_Data* params =
      reinterpret_cast<
          internal::GamepadHapticsManager_PlayVibrationEffectOnce_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  GamepadHapticsResult p_result{};
  GamepadHapticsManager_PlayVibrationEffectOnce_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GamepadHapticsManager::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void GamepadHapticsManager_PlayVibrationEffectOnce_ProxyToResponder::Run(
    GamepadHapticsResult in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)device::mojom::GamepadHapticsManager::PlayVibrationEffectOnceCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result, 
                        "<value of type GamepadHapticsResult>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGamepadHapticsManager_PlayVibrationEffectOnce_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::GamepadHapticsManager_PlayVibrationEffectOnce_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::device::mojom::GamepadHapticsResult>(
      in_result, &params->result);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)device::mojom::GamepadHapticsManager::PlayVibrationEffectOnceCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GamepadHapticsManager::Name_);
  message.set_method_name("PlayVibrationEffectOnce");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class GamepadHapticsManager_ResetVibrationActuator_ProxyToResponder {
 public:
  static GamepadHapticsManager::ResetVibrationActuatorCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<GamepadHapticsManager_ResetVibrationActuator_ProxyToResponder> proxy(
        new GamepadHapticsManager_ResetVibrationActuator_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&GamepadHapticsManager_ResetVibrationActuator_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~GamepadHapticsManager_ResetVibrationActuator_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  GamepadHapticsManager_ResetVibrationActuator_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "GamepadHapticsManager::ResetVibrationActuatorCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      GamepadHapticsResult in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(GamepadHapticsManager_ResetVibrationActuator_ProxyToResponder);
};

bool GamepadHapticsManager_ResetVibrationActuator_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "device::mojom::GamepadHapticsManager::ResetVibrationActuatorCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::GamepadHapticsManager_ResetVibrationActuator_ResponseParams_Data* params =
      reinterpret_cast<
          internal::GamepadHapticsManager_ResetVibrationActuator_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  GamepadHapticsResult p_result{};
  GamepadHapticsManager_ResetVibrationActuator_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GamepadHapticsManager::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void GamepadHapticsManager_ResetVibrationActuator_ProxyToResponder::Run(
    GamepadHapticsResult in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)device::mojom::GamepadHapticsManager::ResetVibrationActuatorCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result, 
                        "<value of type GamepadHapticsResult>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGamepadHapticsManager_ResetVibrationActuator_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::GamepadHapticsManager_ResetVibrationActuator_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::device::mojom::GamepadHapticsResult>(
      in_result, &params->result);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)device::mojom::GamepadHapticsManager::ResetVibrationActuatorCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GamepadHapticsManager::Name_);
  message.set_method_name("ResetVibrationActuator");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool GamepadHapticsManagerStubDispatch::Accept(
    GamepadHapticsManager* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kGamepadHapticsManager_PlayVibrationEffectOnce_Name: {
      break;
    }
    case internal::kGamepadHapticsManager_ResetVibrationActuator_Name: {
      break;
    }
  }
  return false;
}

// static
bool GamepadHapticsManagerStubDispatch::AcceptWithResponder(
    GamepadHapticsManager* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kGamepadHapticsManager_PlayVibrationEffectOnce_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::GamepadHapticsManager::PlayVibrationEffectOnce",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::GamepadHapticsManager::PlayVibrationEffectOnce");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::GamepadHapticsManager_PlayVibrationEffectOnce_Params_Data* params =
          reinterpret_cast<
              internal::GamepadHapticsManager_PlayVibrationEffectOnce_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      uint32_t p_pad_index{};
      GamepadHapticEffectType p_type{};
      GamepadEffectParametersPtr p_params{};
      GamepadHapticsManager_PlayVibrationEffectOnce_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_pad_index = input_data_view.pad_index();
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GamepadHapticsManager::Name_, 0, false);
        return false;
      }
      GamepadHapticsManager::PlayVibrationEffectOnceCallback callback =
          GamepadHapticsManager_PlayVibrationEffectOnce_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PlayVibrationEffectOnce(
std::move(p_pad_index), 
std::move(p_type), 
std::move(p_params), std::move(callback));
      return true;
    }
    case internal::kGamepadHapticsManager_ResetVibrationActuator_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::GamepadHapticsManager::ResetVibrationActuator",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::GamepadHapticsManager::ResetVibrationActuator");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::GamepadHapticsManager_ResetVibrationActuator_Params_Data* params =
          reinterpret_cast<
              internal::GamepadHapticsManager_ResetVibrationActuator_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      uint32_t p_pad_index{};
      GamepadHapticsManager_ResetVibrationActuator_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_pad_index = input_data_view.pad_index();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GamepadHapticsManager::Name_, 1, false);
        return false;
      }
      GamepadHapticsManager::ResetVibrationActuatorCallback callback =
          GamepadHapticsManager_ResetVibrationActuator_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ResetVibrationActuator(
std::move(p_pad_index), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kGamepadHapticsManagerValidationInfo[] = {
    {internal::kGamepadHapticsManager_PlayVibrationEffectOnce_Name,
     {&internal::GamepadHapticsManager_PlayVibrationEffectOnce_Params_Data::Validate,
      &internal::GamepadHapticsManager_PlayVibrationEffectOnce_ResponseParams_Data::Validate}},
    {internal::kGamepadHapticsManager_ResetVibrationActuator_Name,
     {&internal::GamepadHapticsManager_ResetVibrationActuator_Params_Data::Validate,
      &internal::GamepadHapticsManager_ResetVibrationActuator_ResponseParams_Data::Validate}},
};

bool GamepadHapticsManagerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::GamepadHapticsManager::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kGamepadHapticsManagerValidationInfo);
}

bool GamepadHapticsManagerResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::GamepadHapticsManager::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kGamepadHapticsManagerValidationInfo);

}
}  // namespace mojom
}  // namespace device

namespace mojo {


// static
bool StructTraits<::device::mojom::GamepadQuaternion::DataView, ::device::mojom::GamepadQuaternionPtr>::Read(
    ::device::mojom::GamepadQuaternion::DataView input,
    ::device::mojom::GamepadQuaternionPtr* output) {
  bool success = true;
  ::device::mojom::GamepadQuaternionPtr result(::device::mojom::GamepadQuaternion::New());
  
      if (success)
        result->x = input.x();
      if (success)
        result->y = input.y();
      if (success)
        result->z = input.z();
      if (success)
        result->w = input.w();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::GamepadVector::DataView, ::device::mojom::GamepadVectorPtr>::Read(
    ::device::mojom::GamepadVector::DataView input,
    ::device::mojom::GamepadVectorPtr* output) {
  bool success = true;
  ::device::mojom::GamepadVectorPtr result(::device::mojom::GamepadVector::New());
  
      if (success)
        result->x = input.x();
      if (success)
        result->y = input.y();
      if (success)
        result->z = input.z();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::GamepadButton::DataView, ::device::mojom::GamepadButtonPtr>::Read(
    ::device::mojom::GamepadButton::DataView input,
    ::device::mojom::GamepadButtonPtr* output) {
  bool success = true;
  ::device::mojom::GamepadButtonPtr result(::device::mojom::GamepadButton::New());
  
      if (success)
        result->pressed = input.pressed();
      if (success)
        result->touched = input.touched();
      if (success)
        result->value = input.value();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::GamepadPose::DataView, ::device::mojom::GamepadPosePtr>::Read(
    ::device::mojom::GamepadPose::DataView input,
    ::device::mojom::GamepadPosePtr* output) {
  bool success = true;
  ::device::mojom::GamepadPosePtr result(::device::mojom::GamepadPose::New());
  
      if (success && !input.ReadOrientation(&result->orientation))
        success = false;
      if (success && !input.ReadPosition(&result->position))
        success = false;
      if (success && !input.ReadAngularVelocity(&result->angular_velocity))
        success = false;
      if (success && !input.ReadLinearVelocity(&result->linear_velocity))
        success = false;
      if (success && !input.ReadAngularAcceleration(&result->angular_acceleration))
        success = false;
      if (success && !input.ReadLinearAcceleration(&result->linear_acceleration))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::GamepadHapticActuator::DataView, ::device::mojom::GamepadHapticActuatorPtr>::Read(
    ::device::mojom::GamepadHapticActuator::DataView input,
    ::device::mojom::GamepadHapticActuatorPtr* output) {
  bool success = true;
  ::device::mojom::GamepadHapticActuatorPtr result(::device::mojom::GamepadHapticActuator::New());
  
      if (success && !input.ReadType(&result->type))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::Gamepad::DataView, ::device::mojom::GamepadPtr>::Read(
    ::device::mojom::Gamepad::DataView input,
    ::device::mojom::GamepadPtr* output) {
  bool success = true;
  ::device::mojom::GamepadPtr result(::device::mojom::Gamepad::New());
  
      if (success)
        result->connected = input.connected();
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success)
        result->timestamp = input.timestamp();
      if (success && !input.ReadAxes(&result->axes))
        success = false;
      if (success && !input.ReadButtons(&result->buttons))
        success = false;
      if (success && !input.ReadVibrationActuator(&result->vibration_actuator))
        success = false;
      if (success && !input.ReadMapping(&result->mapping))
        success = false;
      if (success && !input.ReadPose(&result->pose))
        success = false;
      if (success && !input.ReadHand(&result->hand))
        success = false;
      if (success)
        result->display_id = input.display_id();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::GamepadEffectParameters::DataView, ::device::mojom::GamepadEffectParametersPtr>::Read(
    ::device::mojom::GamepadEffectParameters::DataView input,
    ::device::mojom::GamepadEffectParametersPtr* output) {
  bool success = true;
  ::device::mojom::GamepadEffectParametersPtr result(::device::mojom::GamepadEffectParameters::New());
  
      if (success)
        result->duration = input.duration();
      if (success)
        result->start_delay = input.start_delay();
      if (success)
        result->strong_magnitude = input.strong_magnitude();
      if (success)
        result->weak_magnitude = input.weak_magnitude();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif