// device/vr/public/mojom/browser_test_interfaces.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "device/vr/public/mojom/browser_test_interfaces.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "device/vr/public/mojom/browser_test_interfaces.mojom-params-data.h"
namespace device_test {
namespace mojom {

std::string EyeToString(Eye value) {
  switch(value) {
    case Eye::LEFT:
      return "Eye::LEFT";
    case Eye::RIGHT:
      return "Eye::RIGHT";
    default:
      return base::StringPrintf("Unknown Eye value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, Eye value) {
  return os << EyeToString(value);
}

std::string TrackedDeviceClassToString(TrackedDeviceClass value) {
  switch(value) {
    case TrackedDeviceClass::kTrackedDeviceInvalid:
      return "TrackedDeviceClass::kTrackedDeviceInvalid";
    case TrackedDeviceClass::kTrackedDeviceHmd:
      return "TrackedDeviceClass::kTrackedDeviceHmd";
    case TrackedDeviceClass::kTrackedDeviceController:
      return "TrackedDeviceClass::kTrackedDeviceController";
    case TrackedDeviceClass::kTrackedDeviceGenericTracker:
      return "TrackedDeviceClass::kTrackedDeviceGenericTracker";
    case TrackedDeviceClass::kTrackedDeviceTrackingReference:
      return "TrackedDeviceClass::kTrackedDeviceTrackingReference";
    case TrackedDeviceClass::kTrackedDeviceDisplayRedirect:
      return "TrackedDeviceClass::kTrackedDeviceDisplayRedirect";
    default:
      return base::StringPrintf("Unknown TrackedDeviceClass value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, TrackedDeviceClass value) {
  return os << TrackedDeviceClassToString(value);
}

std::string ControllerRoleToString(ControllerRole value) {
  switch(value) {
    case ControllerRole::kControllerRoleInvalid:
      return "ControllerRole::kControllerRoleInvalid";
    case ControllerRole::kControllerRoleLeft:
      return "ControllerRole::kControllerRoleLeft";
    case ControllerRole::kControllerRoleRight:
      return "ControllerRole::kControllerRoleRight";
    case ControllerRole::kControllerRoleVoice:
      return "ControllerRole::kControllerRoleVoice";
    default:
      return base::StringPrintf("Unknown ControllerRole value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, ControllerRole value) {
  return os << ControllerRoleToString(value);
}

std::string EventTypeToString(EventType value) {
  switch(value) {
    case EventType::kSessionLost:
      return "EventType::kSessionLost";
    case EventType::kVisibilityVisibleBlurred:
      return "EventType::kVisibilityVisibleBlurred";
    case EventType::kInstanceLost:
      return "EventType::kInstanceLost";
    case EventType::kInteractionProfileChanged:
      return "EventType::kInteractionProfileChanged";
    case EventType::kNoEvent:
      return "EventType::kNoEvent";
    default:
      return base::StringPrintf("Unknown EventType value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, EventType value) {
  return os << EventTypeToString(value);
}

std::string InteractionProfileTypeToString(InteractionProfileType value) {
  switch(value) {
    case InteractionProfileType::kWMRMotion:
      return "InteractionProfileType::kWMRMotion";
    case InteractionProfileType::kKHRSimple:
      return "InteractionProfileType::kKHRSimple";
    case InteractionProfileType::kInvalid:
      return "InteractionProfileType::kInvalid";
    default:
      return base::StringPrintf("Unknown InteractionProfileType value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, InteractionProfileType value) {
  return os << InteractionProfileTypeToString(value);
}

namespace internal {


// static
bool Color_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Color_Data* object = static_cast<const Color_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

Color_Data::Color_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SubmittedFrameData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SubmittedFrameData_Data* object = static_cast<const SubmittedFrameData_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->color, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->color, validation_context))
    return false;


  if (!::device_test::mojom::internal::Eye_Data
        ::Validate(object->eye, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->viewport, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->viewport, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->image_size, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->image_size, validation_context))
    return false;

  return true;
}

SubmittedFrameData_Data::SubmittedFrameData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PoseFrameData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PoseFrameData_Data* object = static_cast<const PoseFrameData_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->device_to_origin, validation_context))
    return false;

  return true;
}

PoseFrameData_Data::PoseFrameData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProjectionRaw_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ProjectionRaw_Data* object = static_cast<const ProjectionRaw_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

ProjectionRaw_Data::ProjectionRaw_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DeviceConfig_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DeviceConfig_Data* object = static_cast<const DeviceConfig_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->projection_left, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->projection_left, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->projection_right, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->projection_right, validation_context))
    return false;

  return true;
}

DeviceConfig_Data::DeviceConfig_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ControllerAxisData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ControllerAxisData_Data* object = static_cast<const ControllerAxisData_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

ControllerAxisData_Data::ControllerAxisData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ControllerFrameData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ControllerFrameData_Data* object = static_cast<const ControllerFrameData_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->axis_data, 5, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams axis_data_validate_params(
      5, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->axis_data, validation_context,
                                         &axis_data_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->pose_data, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->pose_data, validation_context))
    return false;


  if (!::device_test::mojom::internal::ControllerRole_Data
        ::Validate(object->role, validation_context))
    return false;

  return true;
}

ControllerFrameData_Data::ControllerFrameData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool EventData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const EventData_Data* object = static_cast<const EventData_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::device_test::mojom::internal::EventType_Data
        ::Validate(object->type, validation_context))
    return false;


  if (!::device_test::mojom::internal::InteractionProfileType_Data
        ::Validate(object->interaction_profile, validation_context))
    return false;

  return true;
}

EventData_Data::EventData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRTestHook_OnFrameSubmitted_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRTestHook_OnFrameSubmitted_Params_Data* object = static_cast<const XRTestHook_OnFrameSubmitted_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_data, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame_data, validation_context))
    return false;

  return true;
}

XRTestHook_OnFrameSubmitted_Params_Data::XRTestHook_OnFrameSubmitted_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRTestHook_OnFrameSubmitted_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRTestHook_OnFrameSubmitted_ResponseParams_Data* object = static_cast<const XRTestHook_OnFrameSubmitted_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

XRTestHook_OnFrameSubmitted_ResponseParams_Data::XRTestHook_OnFrameSubmitted_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRTestHook_WaitGetDeviceConfig_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRTestHook_WaitGetDeviceConfig_Params_Data* object = static_cast<const XRTestHook_WaitGetDeviceConfig_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

XRTestHook_WaitGetDeviceConfig_Params_Data::XRTestHook_WaitGetDeviceConfig_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRTestHook_WaitGetDeviceConfig_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRTestHook_WaitGetDeviceConfig_ResponseParams_Data* object = static_cast<const XRTestHook_WaitGetDeviceConfig_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->config, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->config, validation_context))
    return false;

  return true;
}

XRTestHook_WaitGetDeviceConfig_ResponseParams_Data::XRTestHook_WaitGetDeviceConfig_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRTestHook_WaitGetPresentingPose_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRTestHook_WaitGetPresentingPose_Params_Data* object = static_cast<const XRTestHook_WaitGetPresentingPose_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

XRTestHook_WaitGetPresentingPose_Params_Data::XRTestHook_WaitGetPresentingPose_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRTestHook_WaitGetPresentingPose_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRTestHook_WaitGetPresentingPose_ResponseParams_Data* object = static_cast<const XRTestHook_WaitGetPresentingPose_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->data, validation_context))
    return false;

  return true;
}

XRTestHook_WaitGetPresentingPose_ResponseParams_Data::XRTestHook_WaitGetPresentingPose_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRTestHook_WaitGetMagicWindowPose_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRTestHook_WaitGetMagicWindowPose_Params_Data* object = static_cast<const XRTestHook_WaitGetMagicWindowPose_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

XRTestHook_WaitGetMagicWindowPose_Params_Data::XRTestHook_WaitGetMagicWindowPose_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRTestHook_WaitGetMagicWindowPose_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRTestHook_WaitGetMagicWindowPose_ResponseParams_Data* object = static_cast<const XRTestHook_WaitGetMagicWindowPose_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->data, validation_context))
    return false;

  return true;
}

XRTestHook_WaitGetMagicWindowPose_ResponseParams_Data::XRTestHook_WaitGetMagicWindowPose_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_Params_Data* object = static_cast<const XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_Params_Data::XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_ResponseParams_Data* object = static_cast<const XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::device_test::mojom::internal::ControllerRole_Data
        ::Validate(object->role, validation_context))
    return false;

  return true;
}

XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_ResponseParams_Data::XRTestHook_WaitGetControllerRoleForTrackedDeviceIndex_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRTestHook_WaitGetTrackedDeviceClass_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRTestHook_WaitGetTrackedDeviceClass_Params_Data* object = static_cast<const XRTestHook_WaitGetTrackedDeviceClass_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

XRTestHook_WaitGetTrackedDeviceClass_Params_Data::XRTestHook_WaitGetTrackedDeviceClass_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRTestHook_WaitGetTrackedDeviceClass_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRTestHook_WaitGetTrackedDeviceClass_ResponseParams_Data* object = static_cast<const XRTestHook_WaitGetTrackedDeviceClass_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::device_test::mojom::internal::TrackedDeviceClass_Data
        ::Validate(object->device_class, validation_context))
    return false;

  return true;
}

XRTestHook_WaitGetTrackedDeviceClass_ResponseParams_Data::XRTestHook_WaitGetTrackedDeviceClass_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRTestHook_WaitGetControllerData_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRTestHook_WaitGetControllerData_Params_Data* object = static_cast<const XRTestHook_WaitGetControllerData_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

XRTestHook_WaitGetControllerData_Params_Data::XRTestHook_WaitGetControllerData_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRTestHook_WaitGetControllerData_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRTestHook_WaitGetControllerData_ResponseParams_Data* object = static_cast<const XRTestHook_WaitGetControllerData_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->data, validation_context))
    return false;

  return true;
}

XRTestHook_WaitGetControllerData_ResponseParams_Data::XRTestHook_WaitGetControllerData_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRTestHook_WaitGetEventData_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRTestHook_WaitGetEventData_Params_Data* object = static_cast<const XRTestHook_WaitGetEventData_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

XRTestHook_WaitGetEventData_Params_Data::XRTestHook_WaitGetEventData_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRTestHook_WaitGetEventData_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRTestHook_WaitGetEventData_ResponseParams_Data* object = static_cast<const XRTestHook_WaitGetEventData_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->data, validation_context))
    return false;

  return true;
}

XRTestHook_WaitGetEventData_ResponseParams_Data::XRTestHook_WaitGetEventData_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRServiceTestHook_SetTestHook_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRServiceTestHook_SetTestHook_Params_Data* object = static_cast<const XRServiceTestHook_SetTestHook_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterface(object->hook,
                                                 validation_context)) {
    return false;
  }

  return true;
}

XRServiceTestHook_SetTestHook_Params_Data::XRServiceTestHook_SetTestHook_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRServiceTestHook_SetTestHook_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRServiceTestHook_SetTestHook_ResponseParams_Data* object = static_cast<const XRServiceTestHook_SetTestHook_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

XRServiceTestHook_SetTestHook_ResponseParams_Data::XRServiceTestHook_SetTestHook_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRServiceTestHook_TerminateDeviceServiceProcessForTesting_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRServiceTestHook_TerminateDeviceServiceProcessForTesting_Params_Data* object = static_cast<const XRServiceTestHook_TerminateDeviceServiceProcessForTesting_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

XRServiceTestHook_TerminateDeviceServiceProcessForTesting_Params_Data::XRServiceTestHook_TerminateDeviceServiceProcessForTesting_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRServiceTestHook_TerminateDeviceServiceProcessForTesting_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRServiceTestHook_TerminateDeviceServiceProcessForTesting_ResponseParams_Data* object = static_cast<const XRServiceTestHook_TerminateDeviceServiceProcessForTesting_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

XRServiceTestHook_TerminateDeviceServiceProcessForTesting_ResponseParams_Data::XRServiceTestHook_TerminateDeviceServiceProcessForTesting_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace device_test

namespace perfetto {

// static
void TraceFormatTraits<::device_test::mojom::Eye>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::device_test::mojom::Eye value) {
  return std::move(context).WriteString(::device_test::mojom::EyeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device_test::mojom::TrackedDeviceClass>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::device_test::mojom::TrackedDeviceClass value) {
  return std::move(context).WriteString(::device_test::mojom::TrackedDeviceClassToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device_test::mojom::ControllerRole>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::device_test::mojom::ControllerRole value) {
  return std::move(context).WriteString(::device_test::mojom::ControllerRoleToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device_test::mojom::EventType>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::device_test::mojom::EventType value) {
  return std::move(context).WriteString(::device_test::mojom::EventTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device_test::mojom::InteractionProfileType>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::device_test::mojom::InteractionProfileType value) {
  return std::move(context).WriteString(::device_test::mojom::InteractionProfileTypeToString(value));
}

} // namespace perfetto
