// device/vr/public/mojom/vr_service.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "device/vr/public/mojom/vr_service.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "device/vr/public/mojom/vr_service.mojom-params-data.h"
#include "device/vr/public/mojom/vr_service.mojom-shared-message-ids.h"

#include "device/vr/public/mojom/vr_service.mojom-import-headers.h"


#ifndef DEVICE_VR_PUBLIC_MOJOM_VR_SERVICE_MOJOM_JUMBO_H_
#define DEVICE_VR_PUBLIC_MOJOM_VR_SERVICE_MOJOM_JUMBO_H_
#endif
namespace device {
namespace mojom {
constexpr uint64_t XRCubeMap::kNumComponentsPerPixel;
XRTrackedImage::XRTrackedImage()
    : bitmap(),
      size_in_pixels(),
      width_in_meters() {}

XRTrackedImage::XRTrackedImage(
    const ::SkBitmap& bitmap_in,
    const ::gfx::Size& size_in_pixels_in,
    float width_in_meters_in)
    : bitmap(std::move(bitmap_in)),
      size_in_pixels(std::move(size_in_pixels_in)),
      width_in_meters(std::move(width_in_meters_in)) {}

XRTrackedImage::~XRTrackedImage() = default;

void XRTrackedImage::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bitmap"), this->bitmap, 
      "<value of type const ::SkBitmap&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "size_in_pixels"), this->size_in_pixels, 
      "<value of type const ::gfx::Size&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "width_in_meters"), this->width_in_meters, 
      "<value of type float>");
}

bool XRTrackedImage::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRDepthOptions::XRDepthOptions()
    : usage_preferences(),
      data_format_preferences() {}

XRDepthOptions::XRDepthOptions(
    std::vector<XRDepthUsage> usage_preferences_in,
    std::vector<XRDepthDataFormat> data_format_preferences_in)
    : usage_preferences(std::move(usage_preferences_in)),
      data_format_preferences(std::move(data_format_preferences_in)) {}

XRDepthOptions::~XRDepthOptions() = default;

void XRDepthOptions::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "usage_preferences"), this->usage_preferences, 
      "<value of type const std::vector<XRDepthUsage>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data_format_preferences"), this->data_format_preferences, 
      "<value of type const std::vector<XRDepthDataFormat>&>");
}

bool XRDepthOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRSessionOptions::XRSessionOptions()
    : mode(),
      required_features(),
      optional_features(),
      tracked_images(),
      depth_options() {}

XRSessionOptions::XRSessionOptions(
    XRSessionMode mode_in,
    std::vector<XRSessionFeature> required_features_in,
    std::vector<XRSessionFeature> optional_features_in,
    std::vector<XRTrackedImagePtr> tracked_images_in,
    XRDepthOptionsPtr depth_options_in)
    : mode(std::move(mode_in)),
      required_features(std::move(required_features_in)),
      optional_features(std::move(optional_features_in)),
      tracked_images(std::move(tracked_images_in)),
      depth_options(std::move(depth_options_in)) {}

XRSessionOptions::~XRSessionOptions() = default;

void XRSessionOptions::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mode"), this->mode, 
      "<value of type XRSessionMode>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "required_features"), this->required_features, 
      "<value of type const std::vector<XRSessionFeature>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "optional_features"), this->optional_features, 
      "<value of type const std::vector<XRSessionFeature>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tracked_images"), this->tracked_images, 
      "<value of type std::vector<XRTrackedImagePtr>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "depth_options"), this->depth_options, 
      "<value of type XRDepthOptionsPtr>");
}

bool XRSessionOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRDepthConfig::XRDepthConfig()
    : depth_usage(),
      depth_data_format() {}

XRDepthConfig::XRDepthConfig(
    XRDepthUsage depth_usage_in,
    XRDepthDataFormat depth_data_format_in)
    : depth_usage(std::move(depth_usage_in)),
      depth_data_format(std::move(depth_data_format_in)) {}

XRDepthConfig::~XRDepthConfig() = default;
size_t XRDepthConfig::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->depth_usage);
  seed = mojo::internal::Hash(seed, this->depth_data_format);
  return seed;
}

void XRDepthConfig::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "depth_usage"), this->depth_usage, 
      "<value of type XRDepthUsage>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "depth_data_format"), this->depth_data_format, 
      "<value of type XRDepthDataFormat>");
}

bool XRDepthConfig::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRSessionDeviceConfig::XRSessionDeviceConfig()
    : uses_input_eventing(),
      default_framebuffer_scale(1.0f),
      supports_viewport_scaling(),
      enable_anti_aliasing(true),
      depth_configuration() {}

XRSessionDeviceConfig::XRSessionDeviceConfig(
    bool uses_input_eventing_in,
    float default_framebuffer_scale_in,
    bool supports_viewport_scaling_in,
    bool enable_anti_aliasing_in,
    XRDepthConfigPtr depth_configuration_in)
    : uses_input_eventing(std::move(uses_input_eventing_in)),
      default_framebuffer_scale(std::move(default_framebuffer_scale_in)),
      supports_viewport_scaling(std::move(supports_viewport_scaling_in)),
      enable_anti_aliasing(std::move(enable_anti_aliasing_in)),
      depth_configuration(std::move(depth_configuration_in)) {}

XRSessionDeviceConfig::~XRSessionDeviceConfig() = default;

void XRSessionDeviceConfig::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "uses_input_eventing"), this->uses_input_eventing, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "default_framebuffer_scale"), this->default_framebuffer_scale, 
      "<value of type float>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "supports_viewport_scaling"), this->supports_viewport_scaling, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_anti_aliasing"), this->enable_anti_aliasing, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "depth_configuration"), this->depth_configuration, 
      "<value of type XRDepthConfigPtr>");
}

bool XRSessionDeviceConfig::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRSession::XRSession()
    : data_provider(),
      client_receiver(),
      display_info(),
      submit_frame_sink(),
      enabled_features(),
      device_config(),
      enviroment_blend_mode(),
      interaction_mode() {}

XRSession::XRSession(
    ::mojo::PendingRemote<XRFrameDataProvider> data_provider_in,
    ::mojo::PendingReceiver<XRSessionClient> client_receiver_in,
    VRDisplayInfoPtr display_info_in,
    XRPresentationConnectionPtr submit_frame_sink_in,
    std::vector<XRSessionFeature> enabled_features_in,
    XRSessionDeviceConfigPtr device_config_in,
    XREnvironmentBlendMode enviroment_blend_mode_in,
    XRInteractionMode interaction_mode_in)
    : data_provider(std::move(data_provider_in)),
      client_receiver(std::move(client_receiver_in)),
      display_info(std::move(display_info_in)),
      submit_frame_sink(std::move(submit_frame_sink_in)),
      enabled_features(std::move(enabled_features_in)),
      device_config(std::move(device_config_in)),
      enviroment_blend_mode(std::move(enviroment_blend_mode_in)),
      interaction_mode(std::move(interaction_mode_in)) {}

XRSession::~XRSession() = default;

void XRSession::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data_provider"), this->data_provider, 
      "<value of type ::mojo::PendingRemote<XRFrameDataProvider>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "client_receiver"), this->client_receiver, 
      "<value of type ::mojo::PendingReceiver<XRSessionClient>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "display_info"), this->display_info, 
      "<value of type VRDisplayInfoPtr>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "submit_frame_sink"), this->submit_frame_sink, 
      "<value of type XRPresentationConnectionPtr>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enabled_features"), this->enabled_features, 
      "<value of type const std::vector<XRSessionFeature>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "device_config"), this->device_config, 
      "<value of type XRSessionDeviceConfigPtr>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enviroment_blend_mode"), this->enviroment_blend_mode, 
      "<value of type XREnvironmentBlendMode>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "interaction_mode"), this->interaction_mode, 
      "<value of type XRInteractionMode>");
}

bool XRSession::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRPresentationConnection::XRPresentationConnection()
    : provider(),
      client_receiver(),
      transport_options() {}

XRPresentationConnection::XRPresentationConnection(
    ::mojo::PendingRemote<XRPresentationProvider> provider_in,
    ::mojo::PendingReceiver<XRPresentationClient> client_receiver_in,
    XRPresentationTransportOptionsPtr transport_options_in)
    : provider(std::move(provider_in)),
      client_receiver(std::move(client_receiver_in)),
      transport_options(std::move(transport_options_in)) {}

XRPresentationConnection::~XRPresentationConnection() = default;

void XRPresentationConnection::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "provider"), this->provider, 
      "<value of type ::mojo::PendingRemote<XRPresentationProvider>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "client_receiver"), this->client_receiver, 
      "<value of type ::mojo::PendingReceiver<XRPresentationClient>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "transport_options"), this->transport_options, 
      "<value of type XRPresentationTransportOptionsPtr>");
}

bool XRPresentationConnection::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRInputSourceDescription::XRInputSourceDescription()
    : target_ray_mode(),
      handedness(),
      input_from_pointer(),
      profiles() {}

XRInputSourceDescription::XRInputSourceDescription(
    XRTargetRayMode target_ray_mode_in,
    XRHandedness handedness_in,
    const base::Optional<::gfx::Transform>& input_from_pointer_in,
    std::vector<std::string> profiles_in)
    : target_ray_mode(std::move(target_ray_mode_in)),
      handedness(std::move(handedness_in)),
      input_from_pointer(std::move(input_from_pointer_in)),
      profiles(std::move(profiles_in)) {}

XRInputSourceDescription::~XRInputSourceDescription() = default;

void XRInputSourceDescription::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "target_ray_mode"), this->target_ray_mode, 
      "<value of type XRTargetRayMode>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "handedness"), this->handedness, 
      "<value of type XRHandedness>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_from_pointer"), this->input_from_pointer, 
      "<value of type const base::Optional<::gfx::Transform>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "profiles"), this->profiles, 
      "<value of type const std::vector<std::string>&>");
}

bool XRInputSourceDescription::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRHandJointData::XRHandJointData()
    : joint(),
      mojo_from_joint(),
      radius() {}

XRHandJointData::XRHandJointData(
    XRHandJoint joint_in,
    const ::gfx::Transform& mojo_from_joint_in,
    float radius_in)
    : joint(std::move(joint_in)),
      mojo_from_joint(std::move(mojo_from_joint_in)),
      radius(std::move(radius_in)) {}

XRHandJointData::~XRHandJointData() = default;

void XRHandJointData::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "joint"), this->joint, 
      "<value of type XRHandJoint>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mojo_from_joint"), this->mojo_from_joint, 
      "<value of type const ::gfx::Transform&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "radius"), this->radius, 
      "<value of type float>");
}

bool XRHandJointData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRHandTrackingData::XRHandTrackingData()
    : hand_joint_data() {}

XRHandTrackingData::XRHandTrackingData(
    std::vector<XRHandJointDataPtr> hand_joint_data_in)
    : hand_joint_data(std::move(hand_joint_data_in)) {}

XRHandTrackingData::~XRHandTrackingData() = default;

void XRHandTrackingData::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hand_joint_data"), this->hand_joint_data, 
      "<value of type std::vector<XRHandJointDataPtr>>");
}

bool XRHandTrackingData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRInputSourceState::XRInputSourceState()
    : source_id(),
      description(),
      mojo_from_input(),
      emulated_position(),
      is_auxiliary(),
      primary_input_pressed(),
      primary_input_clicked(),
      primary_squeeze_pressed(),
      primary_squeeze_clicked(),
      gamepad(),
      overlay_pointer_position(),
      hand_tracking_data() {}

XRInputSourceState::XRInputSourceState(
    uint32_t source_id_in,
    XRInputSourceDescriptionPtr description_in,
    const base::Optional<::gfx::Transform>& mojo_from_input_in,
    bool emulated_position_in,
    bool is_auxiliary_in,
    bool primary_input_pressed_in,
    bool primary_input_clicked_in,
    bool primary_squeeze_pressed_in,
    bool primary_squeeze_clicked_in,
    const base::Optional<::device::Gamepad>& gamepad_in,
    const base::Optional<::gfx::PointF>& overlay_pointer_position_in,
    XRHandTrackingDataPtr hand_tracking_data_in)
    : source_id(std::move(source_id_in)),
      description(std::move(description_in)),
      mojo_from_input(std::move(mojo_from_input_in)),
      emulated_position(std::move(emulated_position_in)),
      is_auxiliary(std::move(is_auxiliary_in)),
      primary_input_pressed(std::move(primary_input_pressed_in)),
      primary_input_clicked(std::move(primary_input_clicked_in)),
      primary_squeeze_pressed(std::move(primary_squeeze_pressed_in)),
      primary_squeeze_clicked(std::move(primary_squeeze_clicked_in)),
      gamepad(std::move(gamepad_in)),
      overlay_pointer_position(std::move(overlay_pointer_position_in)),
      hand_tracking_data(std::move(hand_tracking_data_in)) {}

XRInputSourceState::~XRInputSourceState() = default;

void XRInputSourceState::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source_id"), this->source_id, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "description"), this->description, 
      "<value of type XRInputSourceDescriptionPtr>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mojo_from_input"), this->mojo_from_input, 
      "<value of type const base::Optional<::gfx::Transform>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "emulated_position"), this->emulated_position, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_auxiliary"), this->is_auxiliary, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "primary_input_pressed"), this->primary_input_pressed, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "primary_input_clicked"), this->primary_input_clicked, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "primary_squeeze_pressed"), this->primary_squeeze_pressed, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "primary_squeeze_clicked"), this->primary_squeeze_clicked, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "gamepad"), this->gamepad, 
      "<value of type const base::Optional<::device::Gamepad>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "overlay_pointer_position"), this->overlay_pointer_position, 
      "<value of type const base::Optional<::gfx::PointF>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hand_tracking_data"), this->hand_tracking_data, 
      "<value of type XRHandTrackingDataPtr>");
}

bool XRInputSourceState::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VRFieldOfView::VRFieldOfView()
    : up_degrees(),
      down_degrees(),
      left_degrees(),
      right_degrees() {}

VRFieldOfView::VRFieldOfView(
    float up_degrees_in,
    float down_degrees_in,
    float left_degrees_in,
    float right_degrees_in)
    : up_degrees(std::move(up_degrees_in)),
      down_degrees(std::move(down_degrees_in)),
      left_degrees(std::move(left_degrees_in)),
      right_degrees(std::move(right_degrees_in)) {}

VRFieldOfView::~VRFieldOfView() = default;
size_t VRFieldOfView::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->up_degrees);
  seed = mojo::internal::Hash(seed, this->down_degrees);
  seed = mojo::internal::Hash(seed, this->left_degrees);
  seed = mojo::internal::Hash(seed, this->right_degrees);
  return seed;
}

void VRFieldOfView::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "up_degrees"), this->up_degrees, 
      "<value of type float>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "down_degrees"), this->down_degrees, 
      "<value of type float>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "left_degrees"), this->left_degrees, 
      "<value of type float>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "right_degrees"), this->right_degrees, 
      "<value of type float>");
}

bool VRFieldOfView::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VRPose::VRPose()
    : orientation(),
      position(),
      emulated_position() {}

VRPose::VRPose(
    const base::Optional<::gfx::Quaternion>& orientation_in,
    const base::Optional<::gfx::Point3F>& position_in,
    bool emulated_position_in)
    : orientation(std::move(orientation_in)),
      position(std::move(position_in)),
      emulated_position(std::move(emulated_position_in)) {}

VRPose::~VRPose() = default;

void VRPose::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "orientation"), this->orientation, 
      "<value of type const base::Optional<::gfx::Quaternion>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "position"), this->position, 
      "<value of type const base::Optional<::gfx::Point3F>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "emulated_position"), this->emulated_position, 
      "<value of type bool>");
}

bool VRPose::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Pose::Pose()
    : orientation(),
      position() {}

Pose::Pose(
    const ::gfx::Quaternion& orientation_in,
    const ::gfx::Point3F& position_in)
    : orientation(std::move(orientation_in)),
      position(std::move(position_in)) {}

Pose::~Pose() = default;

void Pose::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "orientation"), this->orientation, 
      "<value of type const ::gfx::Quaternion&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "position"), this->position, 
      "<value of type const ::gfx::Point3F&>");
}

bool Pose::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRRay::XRRay()
    : origin(),
      direction() {}

XRRay::XRRay(
    const ::gfx::Point3F& origin_in,
    const ::gfx::Vector3dF& direction_in)
    : origin(std::move(origin_in)),
      direction(std::move(direction_in)) {}

XRRay::~XRRay() = default;

void XRRay::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "origin"), this->origin, 
      "<value of type const ::gfx::Point3F&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "direction"), this->direction, 
      "<value of type const ::gfx::Vector3dF&>");
}

bool XRRay::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRHitResult::XRHitResult()
    : mojo_from_result(),
      plane_id() {}

XRHitResult::XRHitResult(
    const ::device::Pose& mojo_from_result_in,
    uint64_t plane_id_in)
    : mojo_from_result(std::move(mojo_from_result_in)),
      plane_id(std::move(plane_id_in)) {}

XRHitResult::~XRHitResult() = default;

void XRHitResult::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mojo_from_result"), this->mojo_from_result, 
      "<value of type const ::device::Pose&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "plane_id"), this->plane_id, 
      "<value of type uint64_t>");
}

bool XRHitResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VREyeParameters::VREyeParameters()
    : field_of_view(),
      head_from_eye(),
      render_width(),
      render_height() {}

VREyeParameters::VREyeParameters(
    VRFieldOfViewPtr field_of_view_in,
    const ::gfx::Transform& head_from_eye_in,
    uint32_t render_width_in,
    uint32_t render_height_in)
    : field_of_view(std::move(field_of_view_in)),
      head_from_eye(std::move(head_from_eye_in)),
      render_width(std::move(render_width_in)),
      render_height(std::move(render_height_in)) {}

VREyeParameters::~VREyeParameters() = default;

void VREyeParameters::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "field_of_view"), this->field_of_view, 
      "<value of type VRFieldOfViewPtr>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "head_from_eye"), this->head_from_eye, 
      "<value of type const ::gfx::Transform&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "render_width"), this->render_width, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "render_height"), this->render_height, 
      "<value of type uint32_t>");
}

bool VREyeParameters::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VRStageParameters::VRStageParameters()
    : mojo_from_floor(),
      bounds() {}

VRStageParameters::VRStageParameters(
    const ::gfx::Transform& mojo_from_floor_in,
    base::Optional<std::vector<::gfx::Point3F>> bounds_in)
    : mojo_from_floor(std::move(mojo_from_floor_in)),
      bounds(std::move(bounds_in)) {}

VRStageParameters::~VRStageParameters() = default;

void VRStageParameters::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mojo_from_floor"), this->mojo_from_floor, 
      "<value of type const ::gfx::Transform&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bounds"), this->bounds, 
      "<value of type const base::Optional<std::vector<::gfx::Point3F>>&>");
}

bool VRStageParameters::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VRDisplayInfo::VRDisplayInfo()
    : left_eye(),
      right_eye() {}

VRDisplayInfo::VRDisplayInfo(
    VREyeParametersPtr left_eye_in,
    VREyeParametersPtr right_eye_in)
    : left_eye(std::move(left_eye_in)),
      right_eye(std::move(right_eye_in)) {}

VRDisplayInfo::~VRDisplayInfo() = default;

void VRDisplayInfo::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "left_eye"), this->left_eye, 
      "<value of type VREyeParametersPtr>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "right_eye"), this->right_eye, 
      "<value of type VREyeParametersPtr>");
}

bool VRDisplayInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRPresentationTransportOptions::XRPresentationTransportOptions()
    : transport_method(),
      wait_for_transfer_notification(),
      wait_for_render_notification(),
      wait_for_gpu_fence() {}

XRPresentationTransportOptions::XRPresentationTransportOptions(
    XRPresentationTransportMethod transport_method_in,
    bool wait_for_transfer_notification_in,
    bool wait_for_render_notification_in,
    bool wait_for_gpu_fence_in)
    : transport_method(std::move(transport_method_in)),
      wait_for_transfer_notification(std::move(wait_for_transfer_notification_in)),
      wait_for_render_notification(std::move(wait_for_render_notification_in)),
      wait_for_gpu_fence(std::move(wait_for_gpu_fence_in)) {}

XRPresentationTransportOptions::~XRPresentationTransportOptions() = default;
size_t XRPresentationTransportOptions::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->transport_method);
  seed = mojo::internal::Hash(seed, this->wait_for_transfer_notification);
  seed = mojo::internal::Hash(seed, this->wait_for_render_notification);
  seed = mojo::internal::Hash(seed, this->wait_for_gpu_fence);
  return seed;
}

void XRPresentationTransportOptions::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "transport_method"), this->transport_method, 
      "<value of type XRPresentationTransportMethod>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "wait_for_transfer_notification"), this->wait_for_transfer_notification, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "wait_for_render_notification"), this->wait_for_render_notification, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "wait_for_gpu_fence"), this->wait_for_gpu_fence, 
      "<value of type bool>");
}

bool XRPresentationTransportOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRHandJointSpaceInfo::XRHandJointSpaceInfo()
    : handedness(),
      joint() {}

XRHandJointSpaceInfo::XRHandJointSpaceInfo(
    XRHandedness handedness_in,
    XRHandJoint joint_in)
    : handedness(std::move(handedness_in)),
      joint(std::move(joint_in)) {}

XRHandJointSpaceInfo::~XRHandJointSpaceInfo() = default;
size_t XRHandJointSpaceInfo::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->handedness);
  seed = mojo::internal::Hash(seed, this->joint);
  return seed;
}

void XRHandJointSpaceInfo::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "handedness"), this->handedness, 
      "<value of type XRHandedness>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "joint"), this->joint, 
      "<value of type XRHandJoint>");
}

bool XRHandJointSpaceInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRPlanePointData::XRPlanePointData()
    : x(),
      z() {}

XRPlanePointData::XRPlanePointData(
    float x_in,
    float z_in)
    : x(std::move(x_in)),
      z(std::move(z_in)) {}

XRPlanePointData::~XRPlanePointData() = default;
size_t XRPlanePointData::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->x);
  seed = mojo::internal::Hash(seed, this->z);
  return seed;
}

void XRPlanePointData::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "x"), this->x, 
      "<value of type float>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "z"), this->z, 
      "<value of type float>");
}

bool XRPlanePointData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRPlaneData::XRPlaneData()
    : id(),
      orientation(),
      mojo_from_plane(),
      polygon() {}

XRPlaneData::XRPlaneData(
    uint64_t id_in,
    XRPlaneOrientation orientation_in,
    const base::Optional<::device::Pose>& mojo_from_plane_in,
    std::vector<XRPlanePointDataPtr> polygon_in)
    : id(std::move(id_in)),
      orientation(std::move(orientation_in)),
      mojo_from_plane(std::move(mojo_from_plane_in)),
      polygon(std::move(polygon_in)) {}

XRPlaneData::~XRPlaneData() = default;

void XRPlaneData::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id, 
      "<value of type uint64_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "orientation"), this->orientation, 
      "<value of type XRPlaneOrientation>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mojo_from_plane"), this->mojo_from_plane, 
      "<value of type const base::Optional<::device::Pose>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "polygon"), this->polygon, 
      "<value of type std::vector<XRPlanePointDataPtr>>");
}

bool XRPlaneData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRPlaneDetectionData::XRPlaneDetectionData()
    : all_planes_ids(),
      updated_planes_data() {}

XRPlaneDetectionData::XRPlaneDetectionData(
    std::vector<uint64_t> all_planes_ids_in,
    std::vector<XRPlaneDataPtr> updated_planes_data_in)
    : all_planes_ids(std::move(all_planes_ids_in)),
      updated_planes_data(std::move(updated_planes_data_in)) {}

XRPlaneDetectionData::~XRPlaneDetectionData() = default;

void XRPlaneDetectionData::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "all_planes_ids"), this->all_planes_ids, 
      "<value of type const std::vector<uint64_t>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "updated_planes_data"), this->updated_planes_data, 
      "<value of type std::vector<XRPlaneDataPtr>>");
}

bool XRPlaneDetectionData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRAnchorData::XRAnchorData()
    : id(),
      mojo_from_anchor() {}

XRAnchorData::XRAnchorData(
    uint64_t id_in,
    const base::Optional<::device::Pose>& mojo_from_anchor_in)
    : id(std::move(id_in)),
      mojo_from_anchor(std::move(mojo_from_anchor_in)) {}

XRAnchorData::~XRAnchorData() = default;

void XRAnchorData::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id, 
      "<value of type uint64_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mojo_from_anchor"), this->mojo_from_anchor, 
      "<value of type const base::Optional<::device::Pose>&>");
}

bool XRAnchorData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRAnchorsData::XRAnchorsData()
    : all_anchors_ids(),
      updated_anchors_data() {}

XRAnchorsData::XRAnchorsData(
    std::vector<uint64_t> all_anchors_ids_in,
    std::vector<XRAnchorDataPtr> updated_anchors_data_in)
    : all_anchors_ids(std::move(all_anchors_ids_in)),
      updated_anchors_data(std::move(updated_anchors_data_in)) {}

XRAnchorsData::~XRAnchorsData() = default;

void XRAnchorsData::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "all_anchors_ids"), this->all_anchors_ids, 
      "<value of type const std::vector<uint64_t>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "updated_anchors_data"), this->updated_anchors_data, 
      "<value of type std::vector<XRAnchorDataPtr>>");
}

bool XRAnchorsData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRHitTestSubscriptionResultData::XRHitTestSubscriptionResultData()
    : subscription_id(),
      hit_test_results() {}

XRHitTestSubscriptionResultData::XRHitTestSubscriptionResultData(
    uint64_t subscription_id_in,
    std::vector<XRHitResultPtr> hit_test_results_in)
    : subscription_id(std::move(subscription_id_in)),
      hit_test_results(std::move(hit_test_results_in)) {}

XRHitTestSubscriptionResultData::~XRHitTestSubscriptionResultData() = default;

void XRHitTestSubscriptionResultData::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "subscription_id"), this->subscription_id, 
      "<value of type uint64_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hit_test_results"), this->hit_test_results, 
      "<value of type std::vector<XRHitResultPtr>>");
}

bool XRHitTestSubscriptionResultData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRHitTestTransientInputSubscriptionResultData::XRHitTestTransientInputSubscriptionResultData()
    : subscription_id(),
      input_source_id_to_hit_test_results() {}

XRHitTestTransientInputSubscriptionResultData::XRHitTestTransientInputSubscriptionResultData(
    uint64_t subscription_id_in,
    base::flat_map<uint32_t, std::vector<XRHitResultPtr>> input_source_id_to_hit_test_results_in)
    : subscription_id(std::move(subscription_id_in)),
      input_source_id_to_hit_test_results(std::move(input_source_id_to_hit_test_results_in)) {}

XRHitTestTransientInputSubscriptionResultData::~XRHitTestTransientInputSubscriptionResultData() = default;

void XRHitTestTransientInputSubscriptionResultData::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "subscription_id"), this->subscription_id, 
      "<value of type uint64_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_source_id_to_hit_test_results"), this->input_source_id_to_hit_test_results, 
      "<value of type base::flat_map<uint32_t, std::vector<XRHitResultPtr>>>");
}

bool XRHitTestTransientInputSubscriptionResultData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRHitTestSubscriptionResultsData::XRHitTestSubscriptionResultsData()
    : results(),
      transient_input_results() {}

XRHitTestSubscriptionResultsData::XRHitTestSubscriptionResultsData(
    std::vector<XRHitTestSubscriptionResultDataPtr> results_in,
    std::vector<XRHitTestTransientInputSubscriptionResultDataPtr> transient_input_results_in)
    : results(std::move(results_in)),
      transient_input_results(std::move(transient_input_results_in)) {}

XRHitTestSubscriptionResultsData::~XRHitTestSubscriptionResultsData() = default;

void XRHitTestSubscriptionResultsData::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "results"), this->results, 
      "<value of type std::vector<XRHitTestSubscriptionResultDataPtr>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "transient_input_results"), this->transient_input_results, 
      "<value of type std::vector<XRHitTestTransientInputSubscriptionResultDataPtr>>");
}

bool XRHitTestSubscriptionResultsData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
RgbTupleF32::RgbTupleF32()
    : red(),
      green(),
      blue() {}

RgbTupleF32::RgbTupleF32(
    float red_in,
    float green_in,
    float blue_in)
    : red(std::move(red_in)),
      green(std::move(green_in)),
      blue(std::move(blue_in)) {}

RgbTupleF32::~RgbTupleF32() = default;

void RgbTupleF32::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "red"), this->red, 
      "<value of type float>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "green"), this->green, 
      "<value of type float>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "blue"), this->blue, 
      "<value of type float>");
}

bool RgbTupleF32::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRSphericalHarmonics::XRSphericalHarmonics()
    : coefficients() {}

XRSphericalHarmonics::XRSphericalHarmonics(
    std::vector<::device::RgbTupleF32> coefficients_in)
    : coefficients(std::move(coefficients_in)) {}

XRSphericalHarmonics::~XRSphericalHarmonics() = default;

void XRSphericalHarmonics::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "coefficients"), this->coefficients, 
      "<value of type const std::vector<::device::RgbTupleF32>&>");
}

bool XRSphericalHarmonics::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
RgbaTupleF16::RgbaTupleF16()
    : red(),
      green(),
      blue(),
      alpha() {}

RgbaTupleF16::RgbaTupleF16(
    uint16_t red_in,
    uint16_t green_in,
    uint16_t blue_in,
    uint16_t alpha_in)
    : red(std::move(red_in)),
      green(std::move(green_in)),
      blue(std::move(blue_in)),
      alpha(std::move(alpha_in)) {}

RgbaTupleF16::~RgbaTupleF16() = default;

void RgbaTupleF16::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "red"), this->red, 
      "<value of type uint16_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "green"), this->green, 
      "<value of type uint16_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "blue"), this->blue, 
      "<value of type uint16_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "alpha"), this->alpha, 
      "<value of type uint16_t>");
}

bool RgbaTupleF16::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRCubeMap::XRCubeMap()
    : width_and_height(),
      positive_x(),
      negative_x(),
      positive_y(),
      negative_y(),
      positive_z(),
      negative_z() {}

XRCubeMap::XRCubeMap(
    uint32_t width_and_height_in,
    std::vector<::device::RgbaTupleF16> positive_x_in,
    std::vector<::device::RgbaTupleF16> negative_x_in,
    std::vector<::device::RgbaTupleF16> positive_y_in,
    std::vector<::device::RgbaTupleF16> negative_y_in,
    std::vector<::device::RgbaTupleF16> positive_z_in,
    std::vector<::device::RgbaTupleF16> negative_z_in)
    : width_and_height(std::move(width_and_height_in)),
      positive_x(std::move(positive_x_in)),
      negative_x(std::move(negative_x_in)),
      positive_y(std::move(positive_y_in)),
      negative_y(std::move(negative_y_in)),
      positive_z(std::move(positive_z_in)),
      negative_z(std::move(negative_z_in)) {}

XRCubeMap::~XRCubeMap() = default;

void XRCubeMap::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "width_and_height"), this->width_and_height, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "positive_x"), this->positive_x, 
      "<value of type const std::vector<::device::RgbaTupleF16>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "negative_x"), this->negative_x, 
      "<value of type const std::vector<::device::RgbaTupleF16>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "positive_y"), this->positive_y, 
      "<value of type const std::vector<::device::RgbaTupleF16>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "negative_y"), this->negative_y, 
      "<value of type const std::vector<::device::RgbaTupleF16>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "positive_z"), this->positive_z, 
      "<value of type const std::vector<::device::RgbaTupleF16>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "negative_z"), this->negative_z, 
      "<value of type const std::vector<::device::RgbaTupleF16>&>");
}

bool XRCubeMap::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRLightProbe::XRLightProbe()
    : spherical_harmonics(),
      main_light_direction(),
      main_light_intensity() {}

XRLightProbe::XRLightProbe(
    XRSphericalHarmonicsPtr spherical_harmonics_in,
    const ::gfx::Vector3dF& main_light_direction_in,
    const ::device::RgbTupleF32& main_light_intensity_in)
    : spherical_harmonics(std::move(spherical_harmonics_in)),
      main_light_direction(std::move(main_light_direction_in)),
      main_light_intensity(std::move(main_light_intensity_in)) {}

XRLightProbe::~XRLightProbe() = default;

void XRLightProbe::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "spherical_harmonics"), this->spherical_harmonics, 
      "<value of type XRSphericalHarmonicsPtr>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "main_light_direction"), this->main_light_direction, 
      "<value of type const ::gfx::Vector3dF&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "main_light_intensity"), this->main_light_intensity, 
      "<value of type const ::device::RgbTupleF32&>");
}

bool XRLightProbe::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRReflectionProbe::XRReflectionProbe()
    : cube_map() {}

XRReflectionProbe::XRReflectionProbe(
    XRCubeMapPtr cube_map_in)
    : cube_map(std::move(cube_map_in)) {}

XRReflectionProbe::~XRReflectionProbe() = default;

void XRReflectionProbe::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cube_map"), this->cube_map, 
      "<value of type XRCubeMapPtr>");
}

bool XRReflectionProbe::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRLightEstimationData::XRLightEstimationData()
    : light_probe(),
      reflection_probe() {}

XRLightEstimationData::XRLightEstimationData(
    XRLightProbePtr light_probe_in,
    XRReflectionProbePtr reflection_probe_in)
    : light_probe(std::move(light_probe_in)),
      reflection_probe(std::move(reflection_probe_in)) {}

XRLightEstimationData::~XRLightEstimationData() = default;

void XRLightEstimationData::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "light_probe"), this->light_probe, 
      "<value of type XRLightProbePtr>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reflection_probe"), this->reflection_probe, 
      "<value of type XRReflectionProbePtr>");
}

bool XRLightEstimationData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRDepthDataStillValid::XRDepthDataStillValid() {}

XRDepthDataStillValid::~XRDepthDataStillValid() = default;
size_t XRDepthDataStillValid::Hash(size_t seed) const {
  return seed;
}

void XRDepthDataStillValid::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
}

bool XRDepthDataStillValid::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRDepthDataUpdated::XRDepthDataUpdated()
    : time_delta(),
      pixel_data(),
      norm_texture_from_norm_view(),
      size(),
      raw_value_to_meters() {}

XRDepthDataUpdated::XRDepthDataUpdated(
    ::base::TimeDelta time_delta_in,
    ::mojo_base::BigBuffer pixel_data_in,
    const ::gfx::Transform& norm_texture_from_norm_view_in,
    const ::gfx::Size& size_in,
    float raw_value_to_meters_in)
    : time_delta(std::move(time_delta_in)),
      pixel_data(std::move(pixel_data_in)),
      norm_texture_from_norm_view(std::move(norm_texture_from_norm_view_in)),
      size(std::move(size_in)),
      raw_value_to_meters(std::move(raw_value_to_meters_in)) {}

XRDepthDataUpdated::~XRDepthDataUpdated() = default;

void XRDepthDataUpdated::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "time_delta"), this->time_delta, 
      "<value of type ::base::TimeDelta>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pixel_data"), this->pixel_data, 
      "<value of type ::mojo_base::BigBuffer>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "norm_texture_from_norm_view"), this->norm_texture_from_norm_view, 
      "<value of type const ::gfx::Transform&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "size"), this->size, 
      "<value of type const ::gfx::Size&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "raw_value_to_meters"), this->raw_value_to_meters, 
      "<value of type float>");
}

bool XRDepthDataUpdated::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRTrackedImageData::XRTrackedImageData()
    : index(),
      mojo_from_image(),
      actively_tracked(),
      width_in_meters() {}

XRTrackedImageData::XRTrackedImageData(
    uint32_t index_in,
    const ::device::Pose& mojo_from_image_in,
    bool actively_tracked_in,
    float width_in_meters_in)
    : index(std::move(index_in)),
      mojo_from_image(std::move(mojo_from_image_in)),
      actively_tracked(std::move(actively_tracked_in)),
      width_in_meters(std::move(width_in_meters_in)) {}

XRTrackedImageData::~XRTrackedImageData() = default;

void XRTrackedImageData::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "index"), this->index, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mojo_from_image"), this->mojo_from_image, 
      "<value of type const ::device::Pose&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "actively_tracked"), this->actively_tracked, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "width_in_meters"), this->width_in_meters, 
      "<value of type float>");
}

bool XRTrackedImageData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRTrackedImagesData::XRTrackedImagesData()
    : images_data(),
      image_trackable_scores() {}

XRTrackedImagesData::XRTrackedImagesData(
    std::vector<XRTrackedImageDataPtr> images_data_in,
    base::Optional<std::vector<bool>> image_trackable_scores_in)
    : images_data(std::move(images_data_in)),
      image_trackable_scores(std::move(image_trackable_scores_in)) {}

XRTrackedImagesData::~XRTrackedImagesData() = default;

void XRTrackedImagesData::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "images_data"), this->images_data, 
      "<value of type std::vector<XRTrackedImageDataPtr>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "image_trackable_scores"), this->image_trackable_scores, 
      "<value of type const base::Optional<std::vector<bool>>&>");
}

bool XRTrackedImagesData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRFrameData::XRFrameData()
    : pose(),
      time_delta(),
      buffer_holder(),
      camera_image_buffer_holder(),
      depth_data(),
      mojo_space_reset(),
      frame_id(),
      left_eye(),
      right_eye(),
      input_state(),
      stage_parameters_id(),
      stage_parameters(),
      detected_planes_data(),
      anchors_data(),
      light_estimation_data(),
      hit_test_subscription_results(),
      rendering_time_ratio(),
      tracked_images() {}

XRFrameData::XRFrameData(
    VRPosePtr pose_in,
    ::base::TimeDelta time_delta_in,
    const base::Optional<::gpu::MailboxHolder>& buffer_holder_in,
    const base::Optional<::gpu::MailboxHolder>& camera_image_buffer_holder_in,
    XRDepthDataPtr depth_data_in,
    bool mojo_space_reset_in,
    int16_t frame_id_in,
    VREyeParametersPtr left_eye_in,
    VREyeParametersPtr right_eye_in,
    base::Optional<std::vector<XRInputSourceStatePtr>> input_state_in,
    uint32_t stage_parameters_id_in,
    VRStageParametersPtr stage_parameters_in,
    XRPlaneDetectionDataPtr detected_planes_data_in,
    XRAnchorsDataPtr anchors_data_in,
    XRLightEstimationDataPtr light_estimation_data_in,
    XRHitTestSubscriptionResultsDataPtr hit_test_subscription_results_in,
    float rendering_time_ratio_in,
    XRTrackedImagesDataPtr tracked_images_in)
    : pose(std::move(pose_in)),
      time_delta(std::move(time_delta_in)),
      buffer_holder(std::move(buffer_holder_in)),
      camera_image_buffer_holder(std::move(camera_image_buffer_holder_in)),
      depth_data(std::move(depth_data_in)),
      mojo_space_reset(std::move(mojo_space_reset_in)),
      frame_id(std::move(frame_id_in)),
      left_eye(std::move(left_eye_in)),
      right_eye(std::move(right_eye_in)),
      input_state(std::move(input_state_in)),
      stage_parameters_id(std::move(stage_parameters_id_in)),
      stage_parameters(std::move(stage_parameters_in)),
      detected_planes_data(std::move(detected_planes_data_in)),
      anchors_data(std::move(anchors_data_in)),
      light_estimation_data(std::move(light_estimation_data_in)),
      hit_test_subscription_results(std::move(hit_test_subscription_results_in)),
      rendering_time_ratio(std::move(rendering_time_ratio_in)),
      tracked_images(std::move(tracked_images_in)) {}

XRFrameData::~XRFrameData() = default;

void XRFrameData::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pose"), this->pose, 
      "<value of type VRPosePtr>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "time_delta"), this->time_delta, 
      "<value of type ::base::TimeDelta>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "buffer_holder"), this->buffer_holder, 
      "<value of type const base::Optional<::gpu::MailboxHolder>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "camera_image_buffer_holder"), this->camera_image_buffer_holder, 
      "<value of type const base::Optional<::gpu::MailboxHolder>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "depth_data"), this->depth_data, 
      "<value of type XRDepthDataPtr>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mojo_space_reset"), this->mojo_space_reset, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_id"), this->frame_id, 
      "<value of type int16_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "left_eye"), this->left_eye, 
      "<value of type VREyeParametersPtr>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "right_eye"), this->right_eye, 
      "<value of type VREyeParametersPtr>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_state"), this->input_state, 
      "<value of type base::Optional<std::vector<XRInputSourceStatePtr>>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "stage_parameters_id"), this->stage_parameters_id, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "stage_parameters"), this->stage_parameters, 
      "<value of type VRStageParametersPtr>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "detected_planes_data"), this->detected_planes_data, 
      "<value of type XRPlaneDetectionDataPtr>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "anchors_data"), this->anchors_data, 
      "<value of type XRAnchorsDataPtr>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "light_estimation_data"), this->light_estimation_data, 
      "<value of type XRLightEstimationDataPtr>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hit_test_subscription_results"), this->hit_test_subscription_results, 
      "<value of type XRHitTestSubscriptionResultsDataPtr>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rendering_time_ratio"), this->rendering_time_ratio, 
      "<value of type float>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tracked_images"), this->tracked_images, 
      "<value of type XRTrackedImagesDataPtr>");
}

bool XRFrameData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
RequestSessionSuccess::RequestSessionSuccess()
    : session(),
      metrics_recorder() {}

RequestSessionSuccess::RequestSessionSuccess(
    XRSessionPtr session_in,
    ::mojo::PendingRemote<XRSessionMetricsRecorder> metrics_recorder_in)
    : session(std::move(session_in)),
      metrics_recorder(std::move(metrics_recorder_in)) {}

RequestSessionSuccess::~RequestSessionSuccess() = default;

void RequestSessionSuccess::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "session"), this->session, 
      "<value of type XRSessionPtr>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "metrics_recorder"), this->metrics_recorder, 
      "<value of type ::mojo::PendingRemote<XRSessionMetricsRecorder>>");
}

bool RequestSessionSuccess::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRFrameDataRequestOptions::XRFrameDataRequestOptions()
    : include_lighting_estimation_data(),
      stage_parameters_id() {}

XRFrameDataRequestOptions::XRFrameDataRequestOptions(
    bool include_lighting_estimation_data_in,
    uint32_t stage_parameters_id_in)
    : include_lighting_estimation_data(std::move(include_lighting_estimation_data_in)),
      stage_parameters_id(std::move(stage_parameters_id_in)) {}

XRFrameDataRequestOptions::~XRFrameDataRequestOptions() = default;
size_t XRFrameDataRequestOptions::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->include_lighting_estimation_data);
  seed = mojo::internal::Hash(seed, this->stage_parameters_id);
  return seed;
}

void XRFrameDataRequestOptions::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "include_lighting_estimation_data"), this->include_lighting_estimation_data, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "stage_parameters_id"), this->stage_parameters_id, 
      "<value of type uint32_t>");
}

bool XRFrameDataRequestOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRNativeOriginInformation::XRNativeOriginInformation() : tag_(Tag::INPUT_SOURCE_ID) {
  data_.input_source_id = uint32_t();
}

XRNativeOriginInformation::~XRNativeOriginInformation() {
  DestroyActive();
}


void XRNativeOriginInformation::set_input_source_id(
    uint32_t input_source_id) {
  if (tag_ != Tag::INPUT_SOURCE_ID) {
    DestroyActive();
    tag_ = Tag::INPUT_SOURCE_ID;
  }
  data_.input_source_id = input_source_id;
}
void XRNativeOriginInformation::set_plane_id(
    uint64_t plane_id) {
  if (tag_ != Tag::PLANE_ID) {
    DestroyActive();
    tag_ = Tag::PLANE_ID;
  }
  data_.plane_id = plane_id;
}
void XRNativeOriginInformation::set_anchor_id(
    uint64_t anchor_id) {
  if (tag_ != Tag::ANCHOR_ID) {
    DestroyActive();
    tag_ = Tag::ANCHOR_ID;
  }
  data_.anchor_id = anchor_id;
}
void XRNativeOriginInformation::set_reference_space_type(
    XRReferenceSpaceType reference_space_type) {
  if (tag_ != Tag::REFERENCE_SPACE_TYPE) {
    DestroyActive();
    tag_ = Tag::REFERENCE_SPACE_TYPE;
  }
  data_.reference_space_type = reference_space_type;
}
void XRNativeOriginInformation::set_hand_joint_space_info(
    XRHandJointSpaceInfoPtr hand_joint_space_info) {
  if (tag_ == Tag::HAND_JOINT_SPACE_INFO) {
    *(data_.hand_joint_space_info) = std::move(hand_joint_space_info);
  } else {
    DestroyActive();
    tag_ = Tag::HAND_JOINT_SPACE_INFO;
    data_.hand_joint_space_info = new XRHandJointSpaceInfoPtr(
        std::move(hand_joint_space_info));
  }
}

void XRNativeOriginInformation::DestroyActive() {
  switch (tag_) {

    case Tag::INPUT_SOURCE_ID:

      break;
    case Tag::PLANE_ID:

      break;
    case Tag::ANCHOR_ID:

      break;
    case Tag::REFERENCE_SPACE_TYPE:

      break;
    case Tag::HAND_JOINT_SPACE_INFO:

      delete data_.hand_joint_space_info;
      break;
  }
}
size_t XRNativeOriginInformation::Hash(size_t seed) const {
  seed = mojo::internal::HashCombine(seed, static_cast<uint32_t>(tag_));
  switch (tag_) {

    case Tag::INPUT_SOURCE_ID:
      return mojo::internal::Hash(seed, data_.input_source_id);
    case Tag::PLANE_ID:
      return mojo::internal::Hash(seed, data_.plane_id);
    case Tag::ANCHOR_ID:
      return mojo::internal::Hash(seed, data_.anchor_id);
    case Tag::REFERENCE_SPACE_TYPE:
      return mojo::internal::Hash(seed, data_.reference_space_type);
    case Tag::HAND_JOINT_SPACE_INFO:
      return mojo::internal::Hash(seed, data_.hand_joint_space_info);
    default:
      NOTREACHED();
      return seed;
  }
}

bool XRNativeOriginInformation::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
XRDepthData::XRDepthData() : tag_(Tag::DATA_STILL_VALID) {
  data_.data_still_valid = new XRDepthDataStillValidPtr;
}

XRDepthData::~XRDepthData() {
  DestroyActive();
}


void XRDepthData::set_data_still_valid(
    XRDepthDataStillValidPtr data_still_valid) {
  if (tag_ == Tag::DATA_STILL_VALID) {
    *(data_.data_still_valid) = std::move(data_still_valid);
  } else {
    DestroyActive();
    tag_ = Tag::DATA_STILL_VALID;
    data_.data_still_valid = new XRDepthDataStillValidPtr(
        std::move(data_still_valid));
  }
}
void XRDepthData::set_updated_depth_data(
    XRDepthDataUpdatedPtr updated_depth_data) {
  if (tag_ == Tag::UPDATED_DEPTH_DATA) {
    *(data_.updated_depth_data) = std::move(updated_depth_data);
  } else {
    DestroyActive();
    tag_ = Tag::UPDATED_DEPTH_DATA;
    data_.updated_depth_data = new XRDepthDataUpdatedPtr(
        std::move(updated_depth_data));
  }
}

void XRDepthData::DestroyActive() {
  switch (tag_) {

    case Tag::DATA_STILL_VALID:

      delete data_.data_still_valid;
      break;
    case Tag::UPDATED_DEPTH_DATA:

      delete data_.updated_depth_data;
      break;
  }
}

bool XRDepthData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
RequestSessionResult::RequestSessionResult() : tag_(Tag::SUCCESS) {
  data_.success = new RequestSessionSuccessPtr;
}

RequestSessionResult::~RequestSessionResult() {
  DestroyActive();
}


void RequestSessionResult::set_success(
    RequestSessionSuccessPtr success) {
  if (tag_ == Tag::SUCCESS) {
    *(data_.success) = std::move(success);
  } else {
    DestroyActive();
    tag_ = Tag::SUCCESS;
    data_.success = new RequestSessionSuccessPtr(
        std::move(success));
  }
}
void RequestSessionResult::set_failure_reason(
    RequestSessionError failure_reason) {
  if (tag_ != Tag::FAILURE_REASON) {
    DestroyActive();
    tag_ = Tag::FAILURE_REASON;
  }
  data_.failure_reason = failure_reason;
}

void RequestSessionResult::DestroyActive() {
  switch (tag_) {

    case Tag::SUCCESS:

      delete data_.success;
      break;
    case Tag::FAILURE_REASON:

      break;
  }
}

bool RequestSessionResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
const char VRService::Name_[] = "device.mojom.VRService";
bool VRService::MakeXrCompatible(XrCompatibleResult* out_xr_compatible_result) {
  NOTREACHED();
  return false;
}

class VRService_RequestSession_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  VRService_RequestSession_ForwardToCallback(
      VRService::RequestSessionCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  VRService::RequestSessionCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(VRService_RequestSession_ForwardToCallback);
};

class VRService_SupportsSession_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  VRService_SupportsSession_ForwardToCallback(
      VRService::SupportsSessionCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  VRService::SupportsSessionCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(VRService_SupportsSession_ForwardToCallback);
};

class VRService_ExitPresent_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  VRService_ExitPresent_ForwardToCallback(
      VRService::ExitPresentCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  VRService::ExitPresentCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(VRService_ExitPresent_ForwardToCallback);
};
class VRService_MakeXrCompatible_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  VRService_MakeXrCompatible_HandleSyncResponse(
      bool* result, XrCompatibleResult* out_xr_compatible_result)
      : result_(result), out_xr_compatible_result_(out_xr_compatible_result) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  XrCompatibleResult* out_xr_compatible_result_;DISALLOW_COPY_AND_ASSIGN(VRService_MakeXrCompatible_HandleSyncResponse);
};

class VRService_MakeXrCompatible_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  VRService_MakeXrCompatible_ForwardToCallback(
      VRService::MakeXrCompatibleCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  VRService::MakeXrCompatibleCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(VRService_MakeXrCompatible_ForwardToCallback);
};

VRServiceProxy::VRServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void VRServiceProxy::SetClient(
    ::mojo::PendingRemote<VRServiceClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::VRService::SetClient", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client, 
                        "<value of type ::mojo::PendingRemote<VRServiceClient>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVRService_SetClient_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::VRService_SetClient_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::device::mojom::VRServiceClientInterfaceBase>>(
      in_client, &params->client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid client in VRService.SetClient request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VRService::Name_);
  message.set_method_name("SetClient");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void VRServiceProxy::RequestSession(
    XRSessionOptionsPtr in_options, RequestSessionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::VRService::RequestSession", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options, 
                        "<value of type XRSessionOptionsPtr>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVRService_RequestSession_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::VRService_RequestSession_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  mojo::internal::Serialize<::device::mojom::XRSessionOptionsDataView>(
      in_options, options_fragment);
  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->options.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null options in VRService.RequestSession request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VRService::Name_);
  message.set_method_name("RequestSession");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new VRService_RequestSession_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void VRServiceProxy::SupportsSession(
    XRSessionOptionsPtr in_options, SupportsSessionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::VRService::SupportsSession", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options, 
                        "<value of type XRSessionOptionsPtr>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVRService_SupportsSession_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::VRService_SupportsSession_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  mojo::internal::Serialize<::device::mojom::XRSessionOptionsDataView>(
      in_options, options_fragment);
  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->options.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null options in VRService.SupportsSession request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VRService::Name_);
  message.set_method_name("SupportsSession");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new VRService_SupportsSession_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void VRServiceProxy::ExitPresent(
    ExitPresentCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "device::mojom::VRService::ExitPresent");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVRService_ExitPresent_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::VRService_ExitPresent_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VRService::Name_);
  message.set_method_name("ExitPresent");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new VRService_ExitPresent_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void VRServiceProxy::SetFramesThrottled(
    bool in_throttled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::VRService::SetFramesThrottled", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("throttled"), in_throttled, 
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVRService_SetFramesThrottled_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::VRService_SetFramesThrottled_Params_Data> params(
          message);
  params.Allocate();
  params->throttled = in_throttled;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VRService::Name_);
  message.set_method_name("SetFramesThrottled");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
bool VRServiceProxy::MakeXrCompatible(
    XrCompatibleResult* out_param_xr_compatible_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "device::mojom::VRService::MakeXrCompatible");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVRService_MakeXrCompatible_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::VRService_MakeXrCompatible_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VRService::Name_);
  message.set_method_name("MakeXrCompatible");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new VRService_MakeXrCompatible_HandleSyncResponse(
          &result, out_param_xr_compatible_result));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "device::mojom::VRService::MakeXrCompatible", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("xr_compatible_result"), out_param_xr_compatible_result, 
                        "<value of type XrCompatibleResult>");
   });
#endif
  return result;
}

void VRServiceProxy::MakeXrCompatible(
    MakeXrCompatibleCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "device::mojom::VRService::MakeXrCompatible");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVRService_MakeXrCompatible_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::VRService_MakeXrCompatible_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VRService::Name_);
  message.set_method_name("MakeXrCompatible");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new VRService_MakeXrCompatible_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class VRService_RequestSession_ProxyToResponder {
 public:
  static VRService::RequestSessionCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<VRService_RequestSession_ProxyToResponder> proxy(
        new VRService_RequestSession_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&VRService_RequestSession_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~VRService_RequestSession_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  VRService_RequestSession_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "VRService::RequestSessionCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      RequestSessionResultPtr in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(VRService_RequestSession_ProxyToResponder);
};

bool VRService_RequestSession_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "device::mojom::VRService::RequestSessionCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::VRService_RequestSession_ResponseParams_Data* params =
      reinterpret_cast<
          internal::VRService_RequestSession_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  RequestSessionResultPtr p_result{};
  VRService_RequestSession_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        VRService::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void VRService_RequestSession_ProxyToResponder::Run(
    RequestSessionResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)device::mojom::VRService::RequestSessionCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result, 
                        "<value of type RequestSessionResultPtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVRService_RequestSession_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::VRService_RequestSession_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  mojo::internal::Serialize<::device::mojom::RequestSessionResultDataView>(
      in_result, result_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)device::mojom::VRService::RequestSessionCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VRService::Name_);
  message.set_method_name("RequestSession");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class VRService_SupportsSession_ProxyToResponder {
 public:
  static VRService::SupportsSessionCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<VRService_SupportsSession_ProxyToResponder> proxy(
        new VRService_SupportsSession_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&VRService_SupportsSession_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~VRService_SupportsSession_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  VRService_SupportsSession_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "VRService::SupportsSessionCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_supports_session);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(VRService_SupportsSession_ProxyToResponder);
};

bool VRService_SupportsSession_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "device::mojom::VRService::SupportsSessionCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::VRService_SupportsSession_ResponseParams_Data* params =
      reinterpret_cast<
          internal::VRService_SupportsSession_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_supports_session{};
  VRService_SupportsSession_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_supports_session = input_data_view.supports_session();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        VRService::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_supports_session));
  return true;
}

void VRService_SupportsSession_ProxyToResponder::Run(
    bool in_supports_session) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)device::mojom::VRService::SupportsSessionCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("supports_session"), in_supports_session, 
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVRService_SupportsSession_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::VRService_SupportsSession_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->supports_session = in_supports_session;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)device::mojom::VRService::SupportsSessionCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VRService::Name_);
  message.set_method_name("SupportsSession");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class VRService_ExitPresent_ProxyToResponder {
 public:
  static VRService::ExitPresentCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<VRService_ExitPresent_ProxyToResponder> proxy(
        new VRService_ExitPresent_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&VRService_ExitPresent_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~VRService_ExitPresent_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  VRService_ExitPresent_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "VRService::ExitPresentCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(VRService_ExitPresent_ProxyToResponder);
};

bool VRService_ExitPresent_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "device::mojom::VRService::ExitPresentCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::VRService_ExitPresent_ResponseParams_Data* params =
      reinterpret_cast<
          internal::VRService_ExitPresent_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  VRService_ExitPresent_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        VRService::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void VRService_ExitPresent_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)device::mojom::VRService::ExitPresentCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVRService_ExitPresent_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::VRService_ExitPresent_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)device::mojom::VRService::ExitPresentCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VRService::Name_);
  message.set_method_name("ExitPresent");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class VRService_MakeXrCompatible_ProxyToResponder {
 public:
  static VRService::MakeXrCompatibleCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<VRService_MakeXrCompatible_ProxyToResponder> proxy(
        new VRService_MakeXrCompatible_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&VRService_MakeXrCompatible_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~VRService_MakeXrCompatible_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  VRService_MakeXrCompatible_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "VRService::MakeXrCompatibleCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      XrCompatibleResult in_xr_compatible_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(VRService_MakeXrCompatible_ProxyToResponder);
};

bool VRService_MakeXrCompatible_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "device::mojom::VRService::MakeXrCompatibleCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::VRService_MakeXrCompatible_ResponseParams_Data* params =
      reinterpret_cast<
          internal::VRService_MakeXrCompatible_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  XrCompatibleResult p_xr_compatible_result{};
  VRService_MakeXrCompatible_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadXrCompatibleResult(&p_xr_compatible_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        VRService::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_xr_compatible_result));
  return true;
}

void VRService_MakeXrCompatible_ProxyToResponder::Run(
    XrCompatibleResult in_xr_compatible_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)device::mojom::VRService::MakeXrCompatibleCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("xr_compatible_result"), in_xr_compatible_result, 
                        "<value of type XrCompatibleResult>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVRService_MakeXrCompatible_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::VRService_MakeXrCompatible_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::device::mojom::XrCompatibleResult>(
      in_xr_compatible_result, &params->xr_compatible_result);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)device::mojom::VRService::MakeXrCompatibleCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VRService::Name_);
  message.set_method_name("MakeXrCompatible");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool VRService_MakeXrCompatible_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::VRService_MakeXrCompatible_ResponseParams_Data* params =
      reinterpret_cast<internal::VRService_MakeXrCompatible_ResponseParams_Data*>(
          message->mutable_payload());
  
  bool success = true;
  XrCompatibleResult p_xr_compatible_result{};
  VRService_MakeXrCompatible_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadXrCompatibleResult(&p_xr_compatible_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        VRService::Name_, 5, true);
    return false;
  }
  *out_xr_compatible_result_ = std::move(p_xr_compatible_result);
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}

// static
bool VRServiceStubDispatch::Accept(
    VRService* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kVRService_SetClient_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::VRService::SetClient",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::VRService::SetClient");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::VRService_SetClient_Params_Data* params =
          reinterpret_cast<internal::VRService_SetClient_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<VRServiceClient> p_client{};
      VRService_SetClient_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VRService::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetClient(
std::move(p_client));
      return true;
    }
    case internal::kVRService_RequestSession_Name: {
      break;
    }
    case internal::kVRService_SupportsSession_Name: {
      break;
    }
    case internal::kVRService_ExitPresent_Name: {
      break;
    }
    case internal::kVRService_SetFramesThrottled_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::VRService::SetFramesThrottled",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::VRService::SetFramesThrottled");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::VRService_SetFramesThrottled_Params_Data* params =
          reinterpret_cast<internal::VRService_SetFramesThrottled_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_throttled{};
      VRService_SetFramesThrottled_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_throttled = input_data_view.throttled();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VRService::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetFramesThrottled(
std::move(p_throttled));
      return true;
    }
    case internal::kVRService_MakeXrCompatible_Name: {
      break;
    }
  }
  return false;
}

// static
bool VRServiceStubDispatch::AcceptWithResponder(
    VRService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kVRService_SetClient_Name: {
      break;
    }
    case internal::kVRService_RequestSession_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::VRService::RequestSession",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::VRService::RequestSession");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::VRService_RequestSession_Params_Data* params =
          reinterpret_cast<
              internal::VRService_RequestSession_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      XRSessionOptionsPtr p_options{};
      VRService_RequestSession_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VRService::Name_, 1, false);
        return false;
      }
      VRService::RequestSessionCallback callback =
          VRService_RequestSession_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestSession(
std::move(p_options), std::move(callback));
      return true;
    }
    case internal::kVRService_SupportsSession_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::VRService::SupportsSession",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::VRService::SupportsSession");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::VRService_SupportsSession_Params_Data* params =
          reinterpret_cast<
              internal::VRService_SupportsSession_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      XRSessionOptionsPtr p_options{};
      VRService_SupportsSession_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VRService::Name_, 2, false);
        return false;
      }
      VRService::SupportsSessionCallback callback =
          VRService_SupportsSession_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SupportsSession(
std::move(p_options), std::move(callback));
      return true;
    }
    case internal::kVRService_ExitPresent_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::VRService::ExitPresent",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::VRService::ExitPresent");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::VRService_ExitPresent_Params_Data* params =
          reinterpret_cast<
              internal::VRService_ExitPresent_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      VRService_ExitPresent_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VRService::Name_, 3, false);
        return false;
      }
      VRService::ExitPresentCallback callback =
          VRService_ExitPresent_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ExitPresent(std::move(callback));
      return true;
    }
    case internal::kVRService_SetFramesThrottled_Name: {
      break;
    }
    case internal::kVRService_MakeXrCompatible_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::VRService::MakeXrCompatible",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::VRService::MakeXrCompatible");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::VRService_MakeXrCompatible_Params_Data* params =
          reinterpret_cast<
              internal::VRService_MakeXrCompatible_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      VRService_MakeXrCompatible_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VRService::Name_, 5, false);
        return false;
      }
      VRService::MakeXrCompatibleCallback callback =
          VRService_MakeXrCompatible_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MakeXrCompatible(std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kVRServiceValidationInfo[] = {
    {internal::kVRService_SetClient_Name,
     {&internal::VRService_SetClient_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kVRService_RequestSession_Name,
     {&internal::VRService_RequestSession_Params_Data::Validate,
      &internal::VRService_RequestSession_ResponseParams_Data::Validate}},
    {internal::kVRService_SupportsSession_Name,
     {&internal::VRService_SupportsSession_Params_Data::Validate,
      &internal::VRService_SupportsSession_ResponseParams_Data::Validate}},
    {internal::kVRService_ExitPresent_Name,
     {&internal::VRService_ExitPresent_Params_Data::Validate,
      &internal::VRService_ExitPresent_ResponseParams_Data::Validate}},
    {internal::kVRService_SetFramesThrottled_Name,
     {&internal::VRService_SetFramesThrottled_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kVRService_MakeXrCompatible_Name,
     {&internal::VRService_MakeXrCompatible_Params_Data::Validate,
      &internal::VRService_MakeXrCompatible_ResponseParams_Data::Validate}},
};

bool VRServiceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::VRService::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kVRServiceValidationInfo);
}

bool VRServiceResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::VRService::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kVRServiceValidationInfo);

}
const char XRSessionMetricsRecorder::Name_[] = "device.mojom.XRSessionMetricsRecorder";

XRSessionMetricsRecorderProxy::XRSessionMetricsRecorderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void XRSessionMetricsRecorderProxy::ReportFeatureUsed(
    XRSessionFeature in_feature) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::XRSessionMetricsRecorder::ReportFeatureUsed", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("feature"), in_feature, 
                        "<value of type XRSessionFeature>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kXRSessionMetricsRecorder_ReportFeatureUsed_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XRSessionMetricsRecorder_ReportFeatureUsed_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::device::mojom::XRSessionFeature>(
      in_feature, &params->feature);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRSessionMetricsRecorder::Name_);
  message.set_method_name("ReportFeatureUsed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool XRSessionMetricsRecorderStubDispatch::Accept(
    XRSessionMetricsRecorder* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kXRSessionMetricsRecorder_ReportFeatureUsed_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::XRSessionMetricsRecorder::ReportFeatureUsed",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::XRSessionMetricsRecorder::ReportFeatureUsed");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::XRSessionMetricsRecorder_ReportFeatureUsed_Params_Data* params =
          reinterpret_cast<internal::XRSessionMetricsRecorder_ReportFeatureUsed_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      XRSessionFeature p_feature{};
      XRSessionMetricsRecorder_ReportFeatureUsed_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFeature(&p_feature))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRSessionMetricsRecorder::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReportFeatureUsed(
std::move(p_feature));
      return true;
    }
  }
  return false;
}

// static
bool XRSessionMetricsRecorderStubDispatch::AcceptWithResponder(
    XRSessionMetricsRecorder* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kXRSessionMetricsRecorder_ReportFeatureUsed_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kXRSessionMetricsRecorderValidationInfo[] = {
    {internal::kXRSessionMetricsRecorder_ReportFeatureUsed_Name,
     {&internal::XRSessionMetricsRecorder_ReportFeatureUsed_Params_Data::Validate,
      nullptr /* no response */}},
};

bool XRSessionMetricsRecorderRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::XRSessionMetricsRecorder::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kXRSessionMetricsRecorderValidationInfo);
}

const char VRServiceClient::Name_[] = "device.mojom.VRServiceClient";

VRServiceClientProxy::VRServiceClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void VRServiceClientProxy::OnDeviceChanged(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "device::mojom::VRServiceClient::OnDeviceChanged");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVRServiceClient_OnDeviceChanged_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::VRServiceClient_OnDeviceChanged_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VRServiceClient::Name_);
  message.set_method_name("OnDeviceChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool VRServiceClientStubDispatch::Accept(
    VRServiceClient* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kVRServiceClient_OnDeviceChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::VRServiceClient::OnDeviceChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::VRServiceClient::OnDeviceChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::VRServiceClient_OnDeviceChanged_Params_Data* params =
          reinterpret_cast<internal::VRServiceClient_OnDeviceChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      VRServiceClient_OnDeviceChanged_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VRServiceClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnDeviceChanged();
      return true;
    }
  }
  return false;
}

// static
bool VRServiceClientStubDispatch::AcceptWithResponder(
    VRServiceClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kVRServiceClient_OnDeviceChanged_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kVRServiceClientValidationInfo[] = {
    {internal::kVRServiceClient_OnDeviceChanged_Name,
     {&internal::VRServiceClient_OnDeviceChanged_Params_Data::Validate,
      nullptr /* no response */}},
};

bool VRServiceClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::VRServiceClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kVRServiceClientValidationInfo);
}

const char XREnvironmentIntegrationProvider::Name_[] = "device.mojom.XREnvironmentIntegrationProvider";

class XREnvironmentIntegrationProvider_SubscribeToHitTest_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  XREnvironmentIntegrationProvider_SubscribeToHitTest_ForwardToCallback(
      XREnvironmentIntegrationProvider::SubscribeToHitTestCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  XREnvironmentIntegrationProvider::SubscribeToHitTestCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(XREnvironmentIntegrationProvider_SubscribeToHitTest_ForwardToCallback);
};

class XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ForwardToCallback(
      XREnvironmentIntegrationProvider::SubscribeToHitTestForTransientInputCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  XREnvironmentIntegrationProvider::SubscribeToHitTestForTransientInputCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ForwardToCallback);
};

class XREnvironmentIntegrationProvider_CreateAnchor_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  XREnvironmentIntegrationProvider_CreateAnchor_ForwardToCallback(
      XREnvironmentIntegrationProvider::CreateAnchorCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  XREnvironmentIntegrationProvider::CreateAnchorCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(XREnvironmentIntegrationProvider_CreateAnchor_ForwardToCallback);
};

class XREnvironmentIntegrationProvider_CreatePlaneAnchor_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  XREnvironmentIntegrationProvider_CreatePlaneAnchor_ForwardToCallback(
      XREnvironmentIntegrationProvider::CreatePlaneAnchorCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  XREnvironmentIntegrationProvider::CreatePlaneAnchorCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(XREnvironmentIntegrationProvider_CreatePlaneAnchor_ForwardToCallback);
};

XREnvironmentIntegrationProviderProxy::XREnvironmentIntegrationProviderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void XREnvironmentIntegrationProviderProxy::SubscribeToHitTest(
    XRNativeOriginInformationPtr in_native_origin_information, const std::vector<EntityTypeForHitTest>& in_entity_types, XRRayPtr in_ray, SubscribeToHitTestCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::XREnvironmentIntegrationProvider::SubscribeToHitTest", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("native_origin_information"), in_native_origin_information, 
                        "<value of type XRNativeOriginInformationPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("entity_types"), in_entity_types, 
                        "<value of type const std::vector<EntityTypeForHitTest>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ray"), in_ray, 
                        "<value of type XRRayPtr>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kXREnvironmentIntegrationProvider_SubscribeToHitTest_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XREnvironmentIntegrationProvider_SubscribeToHitTest_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->native_origin_information)>
      native_origin_information_fragment(params.message());
  native_origin_information_fragment.Claim(&params->native_origin_information);
  mojo::internal::Serialize<::device::mojom::XRNativeOriginInformationDataView>(
      in_native_origin_information, native_origin_information_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->native_origin_information.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null native_origin_information in XREnvironmentIntegrationProvider.SubscribeToHitTest request");
  mojo::internal::MessageFragment<
      typename decltype(params->entity_types)::BaseType>
      entity_types_fragment(params.message());
  const mojo::internal::ContainerValidateParams entity_types_validate_params(
      0, ::device::mojom::internal::EntityTypeForHitTest_Data::Validate);
  mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::EntityTypeForHitTest>>(
      in_entity_types, entity_types_fragment, &entity_types_validate_params);
  params->entity_types.Set(
      entity_types_fragment.is_null() ? nullptr : entity_types_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->entity_types.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null entity_types in XREnvironmentIntegrationProvider.SubscribeToHitTest request");
  mojo::internal::MessageFragment<
      typename decltype(params->ray)::BaseType> ray_fragment(
          params.message());
  mojo::internal::Serialize<::device::mojom::XRRayDataView>(
      in_ray, ray_fragment);
  params->ray.Set(
      ray_fragment.is_null() ? nullptr : ray_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->ray.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null ray in XREnvironmentIntegrationProvider.SubscribeToHitTest request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XREnvironmentIntegrationProvider::Name_);
  message.set_method_name("SubscribeToHitTest");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new XREnvironmentIntegrationProvider_SubscribeToHitTest_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void XREnvironmentIntegrationProviderProxy::SubscribeToHitTestForTransientInput(
    const std::string& in_profile_name, const std::vector<EntityTypeForHitTest>& in_entity_types, XRRayPtr in_ray, SubscribeToHitTestForTransientInputCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::XREnvironmentIntegrationProvider::SubscribeToHitTestForTransientInput", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("profile_name"), in_profile_name, 
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("entity_types"), in_entity_types, 
                        "<value of type const std::vector<EntityTypeForHitTest>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ray"), in_ray, 
                        "<value of type XRRayPtr>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kXREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->profile_name)::BaseType> profile_name_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_profile_name, profile_name_fragment);
  params->profile_name.Set(
      profile_name_fragment.is_null() ? nullptr : profile_name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->profile_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null profile_name in XREnvironmentIntegrationProvider.SubscribeToHitTestForTransientInput request");
  mojo::internal::MessageFragment<
      typename decltype(params->entity_types)::BaseType>
      entity_types_fragment(params.message());
  const mojo::internal::ContainerValidateParams entity_types_validate_params(
      0, ::device::mojom::internal::EntityTypeForHitTest_Data::Validate);
  mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::EntityTypeForHitTest>>(
      in_entity_types, entity_types_fragment, &entity_types_validate_params);
  params->entity_types.Set(
      entity_types_fragment.is_null() ? nullptr : entity_types_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->entity_types.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null entity_types in XREnvironmentIntegrationProvider.SubscribeToHitTestForTransientInput request");
  mojo::internal::MessageFragment<
      typename decltype(params->ray)::BaseType> ray_fragment(
          params.message());
  mojo::internal::Serialize<::device::mojom::XRRayDataView>(
      in_ray, ray_fragment);
  params->ray.Set(
      ray_fragment.is_null() ? nullptr : ray_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->ray.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null ray in XREnvironmentIntegrationProvider.SubscribeToHitTestForTransientInput request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XREnvironmentIntegrationProvider::Name_);
  message.set_method_name("SubscribeToHitTestForTransientInput");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void XREnvironmentIntegrationProviderProxy::UnsubscribeFromHitTest(
    uint64_t in_subscription_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::XREnvironmentIntegrationProvider::UnsubscribeFromHitTest", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("subscription_id"), in_subscription_id, 
                        "<value of type uint64_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kXREnvironmentIntegrationProvider_UnsubscribeFromHitTest_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XREnvironmentIntegrationProvider_UnsubscribeFromHitTest_Params_Data> params(
          message);
  params.Allocate();
  params->subscription_id = in_subscription_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XREnvironmentIntegrationProvider::Name_);
  message.set_method_name("UnsubscribeFromHitTest");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void XREnvironmentIntegrationProviderProxy::CreateAnchor(
    XRNativeOriginInformationPtr in_native_origin_information, const ::device::Pose& in_native_origin_from_anchor, CreateAnchorCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::XREnvironmentIntegrationProvider::CreateAnchor", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("native_origin_information"), in_native_origin_information, 
                        "<value of type XRNativeOriginInformationPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("native_origin_from_anchor"), in_native_origin_from_anchor, 
                        "<value of type const ::device::Pose&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kXREnvironmentIntegrationProvider_CreateAnchor_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XREnvironmentIntegrationProvider_CreateAnchor_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->native_origin_information)>
      native_origin_information_fragment(params.message());
  native_origin_information_fragment.Claim(&params->native_origin_information);
  mojo::internal::Serialize<::device::mojom::XRNativeOriginInformationDataView>(
      in_native_origin_information, native_origin_information_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->native_origin_information.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null native_origin_information in XREnvironmentIntegrationProvider.CreateAnchor request");
  mojo::internal::MessageFragment<
      typename decltype(params->native_origin_from_anchor)::BaseType> native_origin_from_anchor_fragment(
          params.message());
  mojo::internal::Serialize<::device::mojom::PoseDataView>(
      in_native_origin_from_anchor, native_origin_from_anchor_fragment);
  params->native_origin_from_anchor.Set(
      native_origin_from_anchor_fragment.is_null() ? nullptr : native_origin_from_anchor_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->native_origin_from_anchor.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null native_origin_from_anchor in XREnvironmentIntegrationProvider.CreateAnchor request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XREnvironmentIntegrationProvider::Name_);
  message.set_method_name("CreateAnchor");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new XREnvironmentIntegrationProvider_CreateAnchor_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void XREnvironmentIntegrationProviderProxy::CreatePlaneAnchor(
    XRNativeOriginInformationPtr in_native_origin_information, const ::device::Pose& in_native_origin_from_anchor, uint64_t in_plane_id, CreatePlaneAnchorCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::XREnvironmentIntegrationProvider::CreatePlaneAnchor", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("native_origin_information"), in_native_origin_information, 
                        "<value of type XRNativeOriginInformationPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("native_origin_from_anchor"), in_native_origin_from_anchor, 
                        "<value of type const ::device::Pose&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("plane_id"), in_plane_id, 
                        "<value of type uint64_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kXREnvironmentIntegrationProvider_CreatePlaneAnchor_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XREnvironmentIntegrationProvider_CreatePlaneAnchor_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->native_origin_information)>
      native_origin_information_fragment(params.message());
  native_origin_information_fragment.Claim(&params->native_origin_information);
  mojo::internal::Serialize<::device::mojom::XRNativeOriginInformationDataView>(
      in_native_origin_information, native_origin_information_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->native_origin_information.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null native_origin_information in XREnvironmentIntegrationProvider.CreatePlaneAnchor request");
  mojo::internal::MessageFragment<
      typename decltype(params->native_origin_from_anchor)::BaseType> native_origin_from_anchor_fragment(
          params.message());
  mojo::internal::Serialize<::device::mojom::PoseDataView>(
      in_native_origin_from_anchor, native_origin_from_anchor_fragment);
  params->native_origin_from_anchor.Set(
      native_origin_from_anchor_fragment.is_null() ? nullptr : native_origin_from_anchor_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->native_origin_from_anchor.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null native_origin_from_anchor in XREnvironmentIntegrationProvider.CreatePlaneAnchor request");
  params->plane_id = in_plane_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XREnvironmentIntegrationProvider::Name_);
  message.set_method_name("CreatePlaneAnchor");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new XREnvironmentIntegrationProvider_CreatePlaneAnchor_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void XREnvironmentIntegrationProviderProxy::DetachAnchor(
    uint64_t in_anchor_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::XREnvironmentIntegrationProvider::DetachAnchor", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("anchor_id"), in_anchor_id, 
                        "<value of type uint64_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kXREnvironmentIntegrationProvider_DetachAnchor_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XREnvironmentIntegrationProvider_DetachAnchor_Params_Data> params(
          message);
  params.Allocate();
  params->anchor_id = in_anchor_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XREnvironmentIntegrationProvider::Name_);
  message.set_method_name("DetachAnchor");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class XREnvironmentIntegrationProvider_SubscribeToHitTest_ProxyToResponder {
 public:
  static XREnvironmentIntegrationProvider::SubscribeToHitTestCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<XREnvironmentIntegrationProvider_SubscribeToHitTest_ProxyToResponder> proxy(
        new XREnvironmentIntegrationProvider_SubscribeToHitTest_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&XREnvironmentIntegrationProvider_SubscribeToHitTest_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~XREnvironmentIntegrationProvider_SubscribeToHitTest_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  XREnvironmentIntegrationProvider_SubscribeToHitTest_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "XREnvironmentIntegrationProvider::SubscribeToHitTestCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      SubscribeToHitTestResult in_result, uint64_t in_subscription_id);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(XREnvironmentIntegrationProvider_SubscribeToHitTest_ProxyToResponder);
};

bool XREnvironmentIntegrationProvider_SubscribeToHitTest_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "device::mojom::XREnvironmentIntegrationProvider::SubscribeToHitTestCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::XREnvironmentIntegrationProvider_SubscribeToHitTest_ResponseParams_Data* params =
      reinterpret_cast<
          internal::XREnvironmentIntegrationProvider_SubscribeToHitTest_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  SubscribeToHitTestResult p_result{};
  uint64_t p_subscription_id{};
  XREnvironmentIntegrationProvider_SubscribeToHitTest_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success)
    p_subscription_id = input_data_view.subscription_id();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        XREnvironmentIntegrationProvider::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_subscription_id));
  return true;
}

void XREnvironmentIntegrationProvider_SubscribeToHitTest_ProxyToResponder::Run(
    SubscribeToHitTestResult in_result, uint64_t in_subscription_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)device::mojom::XREnvironmentIntegrationProvider::SubscribeToHitTestCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result, 
                        "<value of type SubscribeToHitTestResult>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("subscription_id"), in_subscription_id, 
                        "<value of type uint64_t>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kXREnvironmentIntegrationProvider_SubscribeToHitTest_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XREnvironmentIntegrationProvider_SubscribeToHitTest_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::device::mojom::SubscribeToHitTestResult>(
      in_result, &params->result);
  params->subscription_id = in_subscription_id;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)device::mojom::XREnvironmentIntegrationProvider::SubscribeToHitTestCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XREnvironmentIntegrationProvider::Name_);
  message.set_method_name("SubscribeToHitTest");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ProxyToResponder {
 public:
  static XREnvironmentIntegrationProvider::SubscribeToHitTestForTransientInputCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ProxyToResponder> proxy(
        new XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "XREnvironmentIntegrationProvider::SubscribeToHitTestForTransientInputCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      SubscribeToHitTestResult in_result, uint64_t in_subscription_id);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ProxyToResponder);
};

bool XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "device::mojom::XREnvironmentIntegrationProvider::SubscribeToHitTestForTransientInputCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ResponseParams_Data* params =
      reinterpret_cast<
          internal::XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  SubscribeToHitTestResult p_result{};
  uint64_t p_subscription_id{};
  XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success)
    p_subscription_id = input_data_view.subscription_id();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        XREnvironmentIntegrationProvider::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_subscription_id));
  return true;
}

void XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ProxyToResponder::Run(
    SubscribeToHitTestResult in_result, uint64_t in_subscription_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)device::mojom::XREnvironmentIntegrationProvider::SubscribeToHitTestForTransientInputCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result, 
                        "<value of type SubscribeToHitTestResult>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("subscription_id"), in_subscription_id, 
                        "<value of type uint64_t>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kXREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::device::mojom::SubscribeToHitTestResult>(
      in_result, &params->result);
  params->subscription_id = in_subscription_id;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)device::mojom::XREnvironmentIntegrationProvider::SubscribeToHitTestForTransientInputCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XREnvironmentIntegrationProvider::Name_);
  message.set_method_name("SubscribeToHitTestForTransientInput");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class XREnvironmentIntegrationProvider_CreateAnchor_ProxyToResponder {
 public:
  static XREnvironmentIntegrationProvider::CreateAnchorCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<XREnvironmentIntegrationProvider_CreateAnchor_ProxyToResponder> proxy(
        new XREnvironmentIntegrationProvider_CreateAnchor_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&XREnvironmentIntegrationProvider_CreateAnchor_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~XREnvironmentIntegrationProvider_CreateAnchor_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  XREnvironmentIntegrationProvider_CreateAnchor_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "XREnvironmentIntegrationProvider::CreateAnchorCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      CreateAnchorResult in_result, uint64_t in_anchor_id);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(XREnvironmentIntegrationProvider_CreateAnchor_ProxyToResponder);
};

bool XREnvironmentIntegrationProvider_CreateAnchor_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "device::mojom::XREnvironmentIntegrationProvider::CreateAnchorCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::XREnvironmentIntegrationProvider_CreateAnchor_ResponseParams_Data* params =
      reinterpret_cast<
          internal::XREnvironmentIntegrationProvider_CreateAnchor_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  CreateAnchorResult p_result{};
  uint64_t p_anchor_id{};
  XREnvironmentIntegrationProvider_CreateAnchor_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success)
    p_anchor_id = input_data_view.anchor_id();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        XREnvironmentIntegrationProvider::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_anchor_id));
  return true;
}

void XREnvironmentIntegrationProvider_CreateAnchor_ProxyToResponder::Run(
    CreateAnchorResult in_result, uint64_t in_anchor_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)device::mojom::XREnvironmentIntegrationProvider::CreateAnchorCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result, 
                        "<value of type CreateAnchorResult>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("anchor_id"), in_anchor_id, 
                        "<value of type uint64_t>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kXREnvironmentIntegrationProvider_CreateAnchor_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XREnvironmentIntegrationProvider_CreateAnchor_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::device::mojom::CreateAnchorResult>(
      in_result, &params->result);
  params->anchor_id = in_anchor_id;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)device::mojom::XREnvironmentIntegrationProvider::CreateAnchorCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XREnvironmentIntegrationProvider::Name_);
  message.set_method_name("CreateAnchor");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class XREnvironmentIntegrationProvider_CreatePlaneAnchor_ProxyToResponder {
 public:
  static XREnvironmentIntegrationProvider::CreatePlaneAnchorCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<XREnvironmentIntegrationProvider_CreatePlaneAnchor_ProxyToResponder> proxy(
        new XREnvironmentIntegrationProvider_CreatePlaneAnchor_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&XREnvironmentIntegrationProvider_CreatePlaneAnchor_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~XREnvironmentIntegrationProvider_CreatePlaneAnchor_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  XREnvironmentIntegrationProvider_CreatePlaneAnchor_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "XREnvironmentIntegrationProvider::CreatePlaneAnchorCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      CreateAnchorResult in_result, uint64_t in_anchor_id);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(XREnvironmentIntegrationProvider_CreatePlaneAnchor_ProxyToResponder);
};

bool XREnvironmentIntegrationProvider_CreatePlaneAnchor_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "device::mojom::XREnvironmentIntegrationProvider::CreatePlaneAnchorCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::XREnvironmentIntegrationProvider_CreatePlaneAnchor_ResponseParams_Data* params =
      reinterpret_cast<
          internal::XREnvironmentIntegrationProvider_CreatePlaneAnchor_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  CreateAnchorResult p_result{};
  uint64_t p_anchor_id{};
  XREnvironmentIntegrationProvider_CreatePlaneAnchor_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success)
    p_anchor_id = input_data_view.anchor_id();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        XREnvironmentIntegrationProvider::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_anchor_id));
  return true;
}

void XREnvironmentIntegrationProvider_CreatePlaneAnchor_ProxyToResponder::Run(
    CreateAnchorResult in_result, uint64_t in_anchor_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)device::mojom::XREnvironmentIntegrationProvider::CreatePlaneAnchorCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result, 
                        "<value of type CreateAnchorResult>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("anchor_id"), in_anchor_id, 
                        "<value of type uint64_t>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kXREnvironmentIntegrationProvider_CreatePlaneAnchor_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XREnvironmentIntegrationProvider_CreatePlaneAnchor_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::device::mojom::CreateAnchorResult>(
      in_result, &params->result);
  params->anchor_id = in_anchor_id;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)device::mojom::XREnvironmentIntegrationProvider::CreatePlaneAnchorCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XREnvironmentIntegrationProvider::Name_);
  message.set_method_name("CreatePlaneAnchor");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool XREnvironmentIntegrationProviderStubDispatch::Accept(
    XREnvironmentIntegrationProvider* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kXREnvironmentIntegrationProvider_SubscribeToHitTest_Name: {
      break;
    }
    case internal::kXREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_Name: {
      break;
    }
    case internal::kXREnvironmentIntegrationProvider_UnsubscribeFromHitTest_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::XREnvironmentIntegrationProvider::UnsubscribeFromHitTest",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::XREnvironmentIntegrationProvider::UnsubscribeFromHitTest");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::XREnvironmentIntegrationProvider_UnsubscribeFromHitTest_Params_Data* params =
          reinterpret_cast<internal::XREnvironmentIntegrationProvider_UnsubscribeFromHitTest_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      uint64_t p_subscription_id{};
      XREnvironmentIntegrationProvider_UnsubscribeFromHitTest_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_subscription_id = input_data_view.subscription_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XREnvironmentIntegrationProvider::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UnsubscribeFromHitTest(
std::move(p_subscription_id));
      return true;
    }
    case internal::kXREnvironmentIntegrationProvider_CreateAnchor_Name: {
      break;
    }
    case internal::kXREnvironmentIntegrationProvider_CreatePlaneAnchor_Name: {
      break;
    }
    case internal::kXREnvironmentIntegrationProvider_DetachAnchor_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::XREnvironmentIntegrationProvider::DetachAnchor",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::XREnvironmentIntegrationProvider::DetachAnchor");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::XREnvironmentIntegrationProvider_DetachAnchor_Params_Data* params =
          reinterpret_cast<internal::XREnvironmentIntegrationProvider_DetachAnchor_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      uint64_t p_anchor_id{};
      XREnvironmentIntegrationProvider_DetachAnchor_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_anchor_id = input_data_view.anchor_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XREnvironmentIntegrationProvider::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DetachAnchor(
std::move(p_anchor_id));
      return true;
    }
  }
  return false;
}

// static
bool XREnvironmentIntegrationProviderStubDispatch::AcceptWithResponder(
    XREnvironmentIntegrationProvider* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kXREnvironmentIntegrationProvider_SubscribeToHitTest_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::XREnvironmentIntegrationProvider::SubscribeToHitTest",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::XREnvironmentIntegrationProvider::SubscribeToHitTest");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::XREnvironmentIntegrationProvider_SubscribeToHitTest_Params_Data* params =
          reinterpret_cast<
              internal::XREnvironmentIntegrationProvider_SubscribeToHitTest_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      XRNativeOriginInformationPtr p_native_origin_information{};
      std::vector<EntityTypeForHitTest> p_entity_types{};
      XRRayPtr p_ray{};
      XREnvironmentIntegrationProvider_SubscribeToHitTest_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNativeOriginInformation(&p_native_origin_information))
        success = false;
      if (success && !input_data_view.ReadEntityTypes(&p_entity_types))
        success = false;
      if (success && !input_data_view.ReadRay(&p_ray))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XREnvironmentIntegrationProvider::Name_, 0, false);
        return false;
      }
      XREnvironmentIntegrationProvider::SubscribeToHitTestCallback callback =
          XREnvironmentIntegrationProvider_SubscribeToHitTest_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SubscribeToHitTest(
std::move(p_native_origin_information), 
std::move(p_entity_types), 
std::move(p_ray), std::move(callback));
      return true;
    }
    case internal::kXREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::XREnvironmentIntegrationProvider::SubscribeToHitTestForTransientInput",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::XREnvironmentIntegrationProvider::SubscribeToHitTestForTransientInput");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_Params_Data* params =
          reinterpret_cast<
              internal::XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::string p_profile_name{};
      std::vector<EntityTypeForHitTest> p_entity_types{};
      XRRayPtr p_ray{};
      XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadProfileName(&p_profile_name))
        success = false;
      if (success && !input_data_view.ReadEntityTypes(&p_entity_types))
        success = false;
      if (success && !input_data_view.ReadRay(&p_ray))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XREnvironmentIntegrationProvider::Name_, 1, false);
        return false;
      }
      XREnvironmentIntegrationProvider::SubscribeToHitTestForTransientInputCallback callback =
          XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SubscribeToHitTestForTransientInput(
std::move(p_profile_name), 
std::move(p_entity_types), 
std::move(p_ray), std::move(callback));
      return true;
    }
    case internal::kXREnvironmentIntegrationProvider_UnsubscribeFromHitTest_Name: {
      break;
    }
    case internal::kXREnvironmentIntegrationProvider_CreateAnchor_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::XREnvironmentIntegrationProvider::CreateAnchor",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::XREnvironmentIntegrationProvider::CreateAnchor");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::XREnvironmentIntegrationProvider_CreateAnchor_Params_Data* params =
          reinterpret_cast<
              internal::XREnvironmentIntegrationProvider_CreateAnchor_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      XRNativeOriginInformationPtr p_native_origin_information{};
      ::device::Pose p_native_origin_from_anchor{};
      XREnvironmentIntegrationProvider_CreateAnchor_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNativeOriginInformation(&p_native_origin_information))
        success = false;
      if (success && !input_data_view.ReadNativeOriginFromAnchor(&p_native_origin_from_anchor))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XREnvironmentIntegrationProvider::Name_, 3, false);
        return false;
      }
      XREnvironmentIntegrationProvider::CreateAnchorCallback callback =
          XREnvironmentIntegrationProvider_CreateAnchor_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateAnchor(
std::move(p_native_origin_information), 
std::move(p_native_origin_from_anchor), std::move(callback));
      return true;
    }
    case internal::kXREnvironmentIntegrationProvider_CreatePlaneAnchor_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::XREnvironmentIntegrationProvider::CreatePlaneAnchor",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::XREnvironmentIntegrationProvider::CreatePlaneAnchor");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::XREnvironmentIntegrationProvider_CreatePlaneAnchor_Params_Data* params =
          reinterpret_cast<
              internal::XREnvironmentIntegrationProvider_CreatePlaneAnchor_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      XRNativeOriginInformationPtr p_native_origin_information{};
      ::device::Pose p_native_origin_from_anchor{};
      uint64_t p_plane_id{};
      XREnvironmentIntegrationProvider_CreatePlaneAnchor_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNativeOriginInformation(&p_native_origin_information))
        success = false;
      if (success && !input_data_view.ReadNativeOriginFromAnchor(&p_native_origin_from_anchor))
        success = false;
      if (success)
        p_plane_id = input_data_view.plane_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XREnvironmentIntegrationProvider::Name_, 4, false);
        return false;
      }
      XREnvironmentIntegrationProvider::CreatePlaneAnchorCallback callback =
          XREnvironmentIntegrationProvider_CreatePlaneAnchor_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreatePlaneAnchor(
std::move(p_native_origin_information), 
std::move(p_native_origin_from_anchor), 
std::move(p_plane_id), std::move(callback));
      return true;
    }
    case internal::kXREnvironmentIntegrationProvider_DetachAnchor_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kXREnvironmentIntegrationProviderValidationInfo[] = {
    {internal::kXREnvironmentIntegrationProvider_SubscribeToHitTest_Name,
     {&internal::XREnvironmentIntegrationProvider_SubscribeToHitTest_Params_Data::Validate,
      &internal::XREnvironmentIntegrationProvider_SubscribeToHitTest_ResponseParams_Data::Validate}},
    {internal::kXREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_Name,
     {&internal::XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_Params_Data::Validate,
      &internal::XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ResponseParams_Data::Validate}},
    {internal::kXREnvironmentIntegrationProvider_UnsubscribeFromHitTest_Name,
     {&internal::XREnvironmentIntegrationProvider_UnsubscribeFromHitTest_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kXREnvironmentIntegrationProvider_CreateAnchor_Name,
     {&internal::XREnvironmentIntegrationProvider_CreateAnchor_Params_Data::Validate,
      &internal::XREnvironmentIntegrationProvider_CreateAnchor_ResponseParams_Data::Validate}},
    {internal::kXREnvironmentIntegrationProvider_CreatePlaneAnchor_Name,
     {&internal::XREnvironmentIntegrationProvider_CreatePlaneAnchor_Params_Data::Validate,
      &internal::XREnvironmentIntegrationProvider_CreatePlaneAnchor_ResponseParams_Data::Validate}},
    {internal::kXREnvironmentIntegrationProvider_DetachAnchor_Name,
     {&internal::XREnvironmentIntegrationProvider_DetachAnchor_Params_Data::Validate,
      nullptr /* no response */}},
};

bool XREnvironmentIntegrationProviderRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::XREnvironmentIntegrationProvider::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kXREnvironmentIntegrationProviderValidationInfo);
}

bool XREnvironmentIntegrationProviderResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::XREnvironmentIntegrationProvider::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kXREnvironmentIntegrationProviderValidationInfo);

}
const char XRInputSourceButtonListener::Name_[] = "device.mojom.XRInputSourceButtonListener";

XRInputSourceButtonListenerProxy::XRInputSourceButtonListenerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void XRInputSourceButtonListenerProxy::OnButtonEvent(
    XRInputSourceStatePtr in_input_source) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::XRInputSourceButtonListener::OnButtonEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("input_source"), in_input_source, 
                        "<value of type XRInputSourceStatePtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kXRInputSourceButtonListener_OnButtonEvent_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XRInputSourceButtonListener_OnButtonEvent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->input_source)::BaseType> input_source_fragment(
          params.message());
  mojo::internal::Serialize<::device::mojom::XRInputSourceStateDataView>(
      in_input_source, input_source_fragment);
  params->input_source.Set(
      input_source_fragment.is_null() ? nullptr : input_source_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->input_source.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null input_source in XRInputSourceButtonListener.OnButtonEvent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRInputSourceButtonListener::Name_);
  message.set_method_name("OnButtonEvent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool XRInputSourceButtonListenerStubDispatch::Accept(
    XRInputSourceButtonListener* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kXRInputSourceButtonListener_OnButtonEvent_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::XRInputSourceButtonListener::OnButtonEvent",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::XRInputSourceButtonListener::OnButtonEvent");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::XRInputSourceButtonListener_OnButtonEvent_Params_Data* params =
          reinterpret_cast<internal::XRInputSourceButtonListener_OnButtonEvent_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      XRInputSourceStatePtr p_input_source{};
      XRInputSourceButtonListener_OnButtonEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadInputSource(&p_input_source))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRInputSourceButtonListener::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnButtonEvent(
std::move(p_input_source));
      return true;
    }
  }
  return false;
}

// static
bool XRInputSourceButtonListenerStubDispatch::AcceptWithResponder(
    XRInputSourceButtonListener* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kXRInputSourceButtonListener_OnButtonEvent_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kXRInputSourceButtonListenerValidationInfo[] = {
    {internal::kXRInputSourceButtonListener_OnButtonEvent_Name,
     {&internal::XRInputSourceButtonListener_OnButtonEvent_Params_Data::Validate,
      nullptr /* no response */}},
};

bool XRInputSourceButtonListenerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::XRInputSourceButtonListener::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kXRInputSourceButtonListenerValidationInfo);
}

const char XRFrameDataProvider::Name_[] = "device.mojom.XRFrameDataProvider";

class XRFrameDataProvider_GetFrameData_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  XRFrameDataProvider_GetFrameData_ForwardToCallback(
      XRFrameDataProvider::GetFrameDataCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  XRFrameDataProvider::GetFrameDataCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(XRFrameDataProvider_GetFrameData_ForwardToCallback);
};

XRFrameDataProviderProxy::XRFrameDataProviderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void XRFrameDataProviderProxy::GetFrameData(
    XRFrameDataRequestOptionsPtr in_options, GetFrameDataCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::XRFrameDataProvider::GetFrameData", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options, 
                        "<value of type XRFrameDataRequestOptionsPtr>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kXRFrameDataProvider_GetFrameData_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XRFrameDataProvider_GetFrameData_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  mojo::internal::Serialize<::device::mojom::XRFrameDataRequestOptionsDataView>(
      in_options, options_fragment);
  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRFrameDataProvider::Name_);
  message.set_method_name("GetFrameData");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new XRFrameDataProvider_GetFrameData_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void XRFrameDataProviderProxy::GetEnvironmentIntegrationProvider(
    ::mojo::PendingAssociatedReceiver<XREnvironmentIntegrationProvider> in_environment_provider) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::XRFrameDataProvider::GetEnvironmentIntegrationProvider", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("environment_provider"), in_environment_provider, 
                        "<value of type ::mojo::PendingAssociatedReceiver<XREnvironmentIntegrationProvider>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kXRFrameDataProvider_GetEnvironmentIntegrationProvider_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XRFrameDataProvider_GetEnvironmentIntegrationProvider_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::device::mojom::XREnvironmentIntegrationProviderAssociatedRequestDataView>(
      in_environment_provider, &params->environment_provider, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->environment_provider),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid environment_provider in XRFrameDataProvider.GetEnvironmentIntegrationProvider request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRFrameDataProvider::Name_);
  message.set_method_name("GetEnvironmentIntegrationProvider");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void XRFrameDataProviderProxy::SetInputSourceButtonListener(
    ::mojo::PendingAssociatedRemote<XRInputSourceButtonListener> in_event_listener) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::XRFrameDataProvider::SetInputSourceButtonListener", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event_listener"), in_event_listener, 
                        "<value of type ::mojo::PendingAssociatedRemote<XRInputSourceButtonListener>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kXRFrameDataProvider_SetInputSourceButtonListener_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XRFrameDataProvider_SetInputSourceButtonListener_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::device::mojom::XRInputSourceButtonListenerAssociatedPtrInfoDataView>(
      in_event_listener, &params->event_listener, &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRFrameDataProvider::Name_);
  message.set_method_name("SetInputSourceButtonListener");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class XRFrameDataProvider_GetFrameData_ProxyToResponder {
 public:
  static XRFrameDataProvider::GetFrameDataCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<XRFrameDataProvider_GetFrameData_ProxyToResponder> proxy(
        new XRFrameDataProvider_GetFrameData_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&XRFrameDataProvider_GetFrameData_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~XRFrameDataProvider_GetFrameData_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  XRFrameDataProvider_GetFrameData_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "XRFrameDataProvider::GetFrameDataCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      XRFrameDataPtr in_frame_data);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(XRFrameDataProvider_GetFrameData_ProxyToResponder);
};

bool XRFrameDataProvider_GetFrameData_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "device::mojom::XRFrameDataProvider::GetFrameDataCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::XRFrameDataProvider_GetFrameData_ResponseParams_Data* params =
      reinterpret_cast<
          internal::XRFrameDataProvider_GetFrameData_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  XRFrameDataPtr p_frame_data{};
  XRFrameDataProvider_GetFrameData_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadFrameData(&p_frame_data))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        XRFrameDataProvider::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_frame_data));
  return true;
}

void XRFrameDataProvider_GetFrameData_ProxyToResponder::Run(
    XRFrameDataPtr in_frame_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)device::mojom::XRFrameDataProvider::GetFrameDataCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_data"), in_frame_data, 
                        "<value of type XRFrameDataPtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kXRFrameDataProvider_GetFrameData_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XRFrameDataProvider_GetFrameData_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->frame_data)::BaseType> frame_data_fragment(
          params.message());
  mojo::internal::Serialize<::device::mojom::XRFrameDataDataView>(
      in_frame_data, frame_data_fragment);
  params->frame_data.Set(
      frame_data_fragment.is_null() ? nullptr : frame_data_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)device::mojom::XRFrameDataProvider::GetFrameDataCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRFrameDataProvider::Name_);
  message.set_method_name("GetFrameData");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool XRFrameDataProviderStubDispatch::Accept(
    XRFrameDataProvider* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kXRFrameDataProvider_GetFrameData_Name: {
      break;
    }
    case internal::kXRFrameDataProvider_GetEnvironmentIntegrationProvider_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::XRFrameDataProvider::GetEnvironmentIntegrationProvider",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::XRFrameDataProvider::GetEnvironmentIntegrationProvider");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::XRFrameDataProvider_GetEnvironmentIntegrationProvider_Params_Data* params =
          reinterpret_cast<internal::XRFrameDataProvider_GetEnvironmentIntegrationProvider_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingAssociatedReceiver<XREnvironmentIntegrationProvider> p_environment_provider{};
      XRFrameDataProvider_GetEnvironmentIntegrationProvider_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_environment_provider =
            input_data_view.TakeEnvironmentProvider<decltype(p_environment_provider)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRFrameDataProvider::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetEnvironmentIntegrationProvider(
std::move(p_environment_provider));
      return true;
    }
    case internal::kXRFrameDataProvider_SetInputSourceButtonListener_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::XRFrameDataProvider::SetInputSourceButtonListener",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::XRFrameDataProvider::SetInputSourceButtonListener");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::XRFrameDataProvider_SetInputSourceButtonListener_Params_Data* params =
          reinterpret_cast<internal::XRFrameDataProvider_SetInputSourceButtonListener_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingAssociatedRemote<XRInputSourceButtonListener> p_event_listener{};
      XRFrameDataProvider_SetInputSourceButtonListener_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_event_listener =
            input_data_view.TakeEventListener<decltype(p_event_listener)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRFrameDataProvider::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetInputSourceButtonListener(
std::move(p_event_listener));
      return true;
    }
  }
  return false;
}

// static
bool XRFrameDataProviderStubDispatch::AcceptWithResponder(
    XRFrameDataProvider* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kXRFrameDataProvider_GetFrameData_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::XRFrameDataProvider::GetFrameData",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::XRFrameDataProvider::GetFrameData");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::XRFrameDataProvider_GetFrameData_Params_Data* params =
          reinterpret_cast<
              internal::XRFrameDataProvider_GetFrameData_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      XRFrameDataRequestOptionsPtr p_options{};
      XRFrameDataProvider_GetFrameData_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRFrameDataProvider::Name_, 0, false);
        return false;
      }
      XRFrameDataProvider::GetFrameDataCallback callback =
          XRFrameDataProvider_GetFrameData_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetFrameData(
std::move(p_options), std::move(callback));
      return true;
    }
    case internal::kXRFrameDataProvider_GetEnvironmentIntegrationProvider_Name: {
      break;
    }
    case internal::kXRFrameDataProvider_SetInputSourceButtonListener_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kXRFrameDataProviderValidationInfo[] = {
    {internal::kXRFrameDataProvider_GetFrameData_Name,
     {&internal::XRFrameDataProvider_GetFrameData_Params_Data::Validate,
      &internal::XRFrameDataProvider_GetFrameData_ResponseParams_Data::Validate}},
    {internal::kXRFrameDataProvider_GetEnvironmentIntegrationProvider_Name,
     {&internal::XRFrameDataProvider_GetEnvironmentIntegrationProvider_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kXRFrameDataProvider_SetInputSourceButtonListener_Name,
     {&internal::XRFrameDataProvider_SetInputSourceButtonListener_Params_Data::Validate,
      nullptr /* no response */}},
};

bool XRFrameDataProviderRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::XRFrameDataProvider::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kXRFrameDataProviderValidationInfo);
}

bool XRFrameDataProviderResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::XRFrameDataProvider::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kXRFrameDataProviderValidationInfo);

}
const char XRPresentationProvider::Name_[] = "device.mojom.XRPresentationProvider";

XRPresentationProviderProxy::XRPresentationProviderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void XRPresentationProviderProxy::UpdateLayerBounds(
    int16_t in_frame_id, const ::gfx::RectF& in_left_bounds, const ::gfx::RectF& in_right_bounds, const ::gfx::Size& in_source_size) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::XRPresentationProvider::UpdateLayerBounds", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_id"), in_frame_id, 
                        "<value of type int16_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("left_bounds"), in_left_bounds, 
                        "<value of type const ::gfx::RectF&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("right_bounds"), in_right_bounds, 
                        "<value of type const ::gfx::RectF&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_size"), in_source_size, 
                        "<value of type const ::gfx::Size&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kXRPresentationProvider_UpdateLayerBounds_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XRPresentationProvider_UpdateLayerBounds_Params_Data> params(
          message);
  params.Allocate();
  params->frame_id = in_frame_id;
  mojo::internal::MessageFragment<
      typename decltype(params->left_bounds)::BaseType> left_bounds_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::RectFDataView>(
      in_left_bounds, left_bounds_fragment);
  params->left_bounds.Set(
      left_bounds_fragment.is_null() ? nullptr : left_bounds_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->left_bounds.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null left_bounds in XRPresentationProvider.UpdateLayerBounds request");
  mojo::internal::MessageFragment<
      typename decltype(params->right_bounds)::BaseType> right_bounds_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::RectFDataView>(
      in_right_bounds, right_bounds_fragment);
  params->right_bounds.Set(
      right_bounds_fragment.is_null() ? nullptr : right_bounds_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->right_bounds.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null right_bounds in XRPresentationProvider.UpdateLayerBounds request");
  mojo::internal::MessageFragment<
      typename decltype(params->source_size)::BaseType> source_size_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_source_size, source_size_fragment);
  params->source_size.Set(
      source_size_fragment.is_null() ? nullptr : source_size_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->source_size.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null source_size in XRPresentationProvider.UpdateLayerBounds request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRPresentationProvider::Name_);
  message.set_method_name("UpdateLayerBounds");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void XRPresentationProviderProxy::SubmitFrameMissing(
    int16_t in_frame_id, const ::gpu::SyncToken& in_sync_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::XRPresentationProvider::SubmitFrameMissing", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_id"), in_frame_id, 
                        "<value of type int16_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sync_token"), in_sync_token, 
                        "<value of type const ::gpu::SyncToken&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kXRPresentationProvider_SubmitFrameMissing_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XRPresentationProvider_SubmitFrameMissing_Params_Data> params(
          message);
  params.Allocate();
  params->frame_id = in_frame_id;
  mojo::internal::MessageFragment<
      typename decltype(params->sync_token)::BaseType> sync_token_fragment(
          params.message());
  mojo::internal::Serialize<::gpu::mojom::SyncTokenDataView>(
      in_sync_token, sync_token_fragment);
  params->sync_token.Set(
      sync_token_fragment.is_null() ? nullptr : sync_token_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->sync_token.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null sync_token in XRPresentationProvider.SubmitFrameMissing request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRPresentationProvider::Name_);
  message.set_method_name("SubmitFrameMissing");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void XRPresentationProviderProxy::SubmitFrame(
    int16_t in_frame_id, const ::gpu::MailboxHolder& in_mailbox_holder, ::base::TimeDelta in_time_waited) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::XRPresentationProvider::SubmitFrame", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_id"), in_frame_id, 
                        "<value of type int16_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("mailbox_holder"), in_mailbox_holder, 
                        "<value of type const ::gpu::MailboxHolder&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("time_waited"), in_time_waited, 
                        "<value of type ::base::TimeDelta>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kXRPresentationProvider_SubmitFrame_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XRPresentationProvider_SubmitFrame_Params_Data> params(
          message);
  params.Allocate();
  params->frame_id = in_frame_id;
  mojo::internal::MessageFragment<
      typename decltype(params->mailbox_holder)::BaseType> mailbox_holder_fragment(
          params.message());
  mojo::internal::Serialize<::gpu::mojom::MailboxHolderDataView>(
      in_mailbox_holder, mailbox_holder_fragment);
  params->mailbox_holder.Set(
      mailbox_holder_fragment.is_null() ? nullptr : mailbox_holder_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->mailbox_holder.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null mailbox_holder in XRPresentationProvider.SubmitFrame request");
  mojo::internal::MessageFragment<
      typename decltype(params->time_waited)::BaseType> time_waited_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_time_waited, time_waited_fragment);
  params->time_waited.Set(
      time_waited_fragment.is_null() ? nullptr : time_waited_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->time_waited.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null time_waited in XRPresentationProvider.SubmitFrame request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRPresentationProvider::Name_);
  message.set_method_name("SubmitFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void XRPresentationProviderProxy::SubmitFrameWithTextureHandle(
    int16_t in_frameId, ::mojo::PlatformHandle in_texture) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::XRPresentationProvider::SubmitFrameWithTextureHandle", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frameId"), in_frameId, 
                        "<value of type int16_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("texture"), in_texture, 
                        "<value of type ::mojo::PlatformHandle>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kXRPresentationProvider_SubmitFrameWithTextureHandle_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XRPresentationProvider_SubmitFrameWithTextureHandle_Params_Data> params(
          message);
  params.Allocate();
  params->frameId = in_frameId;
  mojo::internal::Serialize<mojo::PlatformHandle>(
      in_texture, &params->texture, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->texture),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid texture in XRPresentationProvider.SubmitFrameWithTextureHandle request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRPresentationProvider::Name_);
  message.set_method_name("SubmitFrameWithTextureHandle");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void XRPresentationProviderProxy::SubmitFrameDrawnIntoTexture(
    int16_t in_frameId, const ::gpu::SyncToken& in_sync_token, ::base::TimeDelta in_time_waited) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::XRPresentationProvider::SubmitFrameDrawnIntoTexture", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frameId"), in_frameId, 
                        "<value of type int16_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sync_token"), in_sync_token, 
                        "<value of type const ::gpu::SyncToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("time_waited"), in_time_waited, 
                        "<value of type ::base::TimeDelta>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kXRPresentationProvider_SubmitFrameDrawnIntoTexture_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XRPresentationProvider_SubmitFrameDrawnIntoTexture_Params_Data> params(
          message);
  params.Allocate();
  params->frameId = in_frameId;
  mojo::internal::MessageFragment<
      typename decltype(params->sync_token)::BaseType> sync_token_fragment(
          params.message());
  mojo::internal::Serialize<::gpu::mojom::SyncTokenDataView>(
      in_sync_token, sync_token_fragment);
  params->sync_token.Set(
      sync_token_fragment.is_null() ? nullptr : sync_token_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->sync_token.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null sync_token in XRPresentationProvider.SubmitFrameDrawnIntoTexture request");
  mojo::internal::MessageFragment<
      typename decltype(params->time_waited)::BaseType> time_waited_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_time_waited, time_waited_fragment);
  params->time_waited.Set(
      time_waited_fragment.is_null() ? nullptr : time_waited_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->time_waited.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null time_waited in XRPresentationProvider.SubmitFrameDrawnIntoTexture request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRPresentationProvider::Name_);
  message.set_method_name("SubmitFrameDrawnIntoTexture");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool XRPresentationProviderStubDispatch::Accept(
    XRPresentationProvider* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kXRPresentationProvider_UpdateLayerBounds_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::XRPresentationProvider::UpdateLayerBounds",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::XRPresentationProvider::UpdateLayerBounds");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::XRPresentationProvider_UpdateLayerBounds_Params_Data* params =
          reinterpret_cast<internal::XRPresentationProvider_UpdateLayerBounds_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int16_t p_frame_id{};
      ::gfx::RectF p_left_bounds{};
      ::gfx::RectF p_right_bounds{};
      ::gfx::Size p_source_size{};
      XRPresentationProvider_UpdateLayerBounds_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_frame_id = input_data_view.frame_id();
      if (success && !input_data_view.ReadLeftBounds(&p_left_bounds))
        success = false;
      if (success && !input_data_view.ReadRightBounds(&p_right_bounds))
        success = false;
      if (success && !input_data_view.ReadSourceSize(&p_source_size))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRPresentationProvider::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateLayerBounds(
std::move(p_frame_id), 
std::move(p_left_bounds), 
std::move(p_right_bounds), 
std::move(p_source_size));
      return true;
    }
    case internal::kXRPresentationProvider_SubmitFrameMissing_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::XRPresentationProvider::SubmitFrameMissing",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::XRPresentationProvider::SubmitFrameMissing");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::XRPresentationProvider_SubmitFrameMissing_Params_Data* params =
          reinterpret_cast<internal::XRPresentationProvider_SubmitFrameMissing_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int16_t p_frame_id{};
      ::gpu::SyncToken p_sync_token{};
      XRPresentationProvider_SubmitFrameMissing_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_frame_id = input_data_view.frame_id();
      if (success && !input_data_view.ReadSyncToken(&p_sync_token))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRPresentationProvider::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SubmitFrameMissing(
std::move(p_frame_id), 
std::move(p_sync_token));
      return true;
    }
    case internal::kXRPresentationProvider_SubmitFrame_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::XRPresentationProvider::SubmitFrame",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::XRPresentationProvider::SubmitFrame");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::XRPresentationProvider_SubmitFrame_Params_Data* params =
          reinterpret_cast<internal::XRPresentationProvider_SubmitFrame_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int16_t p_frame_id{};
      ::gpu::MailboxHolder p_mailbox_holder{};
      ::base::TimeDelta p_time_waited{};
      XRPresentationProvider_SubmitFrame_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_frame_id = input_data_view.frame_id();
      if (success && !input_data_view.ReadMailboxHolder(&p_mailbox_holder))
        success = false;
      if (success && !input_data_view.ReadTimeWaited(&p_time_waited))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRPresentationProvider::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SubmitFrame(
std::move(p_frame_id), 
std::move(p_mailbox_holder), 
std::move(p_time_waited));
      return true;
    }
    case internal::kXRPresentationProvider_SubmitFrameWithTextureHandle_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::XRPresentationProvider::SubmitFrameWithTextureHandle",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::XRPresentationProvider::SubmitFrameWithTextureHandle");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::XRPresentationProvider_SubmitFrameWithTextureHandle_Params_Data* params =
          reinterpret_cast<internal::XRPresentationProvider_SubmitFrameWithTextureHandle_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int16_t p_frameId{};
      ::mojo::PlatformHandle p_texture{};
      XRPresentationProvider_SubmitFrameWithTextureHandle_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_frameId = input_data_view.frameId();
      if (success)
        p_texture = input_data_view.TakeTexture();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRPresentationProvider::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SubmitFrameWithTextureHandle(
std::move(p_frameId), 
std::move(p_texture));
      return true;
    }
    case internal::kXRPresentationProvider_SubmitFrameDrawnIntoTexture_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::XRPresentationProvider::SubmitFrameDrawnIntoTexture",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::XRPresentationProvider::SubmitFrameDrawnIntoTexture");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::XRPresentationProvider_SubmitFrameDrawnIntoTexture_Params_Data* params =
          reinterpret_cast<internal::XRPresentationProvider_SubmitFrameDrawnIntoTexture_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int16_t p_frameId{};
      ::gpu::SyncToken p_sync_token{};
      ::base::TimeDelta p_time_waited{};
      XRPresentationProvider_SubmitFrameDrawnIntoTexture_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_frameId = input_data_view.frameId();
      if (success && !input_data_view.ReadSyncToken(&p_sync_token))
        success = false;
      if (success && !input_data_view.ReadTimeWaited(&p_time_waited))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRPresentationProvider::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SubmitFrameDrawnIntoTexture(
std::move(p_frameId), 
std::move(p_sync_token), 
std::move(p_time_waited));
      return true;
    }
  }
  return false;
}

// static
bool XRPresentationProviderStubDispatch::AcceptWithResponder(
    XRPresentationProvider* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kXRPresentationProvider_UpdateLayerBounds_Name: {
      break;
    }
    case internal::kXRPresentationProvider_SubmitFrameMissing_Name: {
      break;
    }
    case internal::kXRPresentationProvider_SubmitFrame_Name: {
      break;
    }
    case internal::kXRPresentationProvider_SubmitFrameWithTextureHandle_Name: {
      break;
    }
    case internal::kXRPresentationProvider_SubmitFrameDrawnIntoTexture_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kXRPresentationProviderValidationInfo[] = {
    {internal::kXRPresentationProvider_UpdateLayerBounds_Name,
     {&internal::XRPresentationProvider_UpdateLayerBounds_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kXRPresentationProvider_SubmitFrameMissing_Name,
     {&internal::XRPresentationProvider_SubmitFrameMissing_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kXRPresentationProvider_SubmitFrame_Name,
     {&internal::XRPresentationProvider_SubmitFrame_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kXRPresentationProvider_SubmitFrameWithTextureHandle_Name,
     {&internal::XRPresentationProvider_SubmitFrameWithTextureHandle_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kXRPresentationProvider_SubmitFrameDrawnIntoTexture_Name,
     {&internal::XRPresentationProvider_SubmitFrameDrawnIntoTexture_Params_Data::Validate,
      nullptr /* no response */}},
};

bool XRPresentationProviderRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::XRPresentationProvider::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kXRPresentationProviderValidationInfo);
}

const char XRPresentationClient::Name_[] = "device.mojom.XRPresentationClient";

XRPresentationClientProxy::XRPresentationClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void XRPresentationClientProxy::OnSubmitFrameTransferred(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::XRPresentationClient::OnSubmitFrameTransferred", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success, 
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kXRPresentationClient_OnSubmitFrameTransferred_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XRPresentationClient_OnSubmitFrameTransferred_Params_Data> params(
          message);
  params.Allocate();
  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRPresentationClient::Name_);
  message.set_method_name("OnSubmitFrameTransferred");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void XRPresentationClientProxy::OnSubmitFrameRendered(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "device::mojom::XRPresentationClient::OnSubmitFrameRendered");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kXRPresentationClient_OnSubmitFrameRendered_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XRPresentationClient_OnSubmitFrameRendered_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRPresentationClient::Name_);
  message.set_method_name("OnSubmitFrameRendered");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void XRPresentationClientProxy::OnSubmitFrameGpuFence(
    ::gfx::GpuFenceHandle in_gpu_fence_handle) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::XRPresentationClient::OnSubmitFrameGpuFence", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("gpu_fence_handle"), in_gpu_fence_handle, 
                        "<value of type ::gfx::GpuFenceHandle>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kXRPresentationClient_OnSubmitFrameGpuFence_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XRPresentationClient_OnSubmitFrameGpuFence_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->gpu_fence_handle)::BaseType> gpu_fence_handle_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::GpuFenceHandleDataView>(
      in_gpu_fence_handle, gpu_fence_handle_fragment);
  params->gpu_fence_handle.Set(
      gpu_fence_handle_fragment.is_null() ? nullptr : gpu_fence_handle_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->gpu_fence_handle.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null gpu_fence_handle in XRPresentationClient.OnSubmitFrameGpuFence request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRPresentationClient::Name_);
  message.set_method_name("OnSubmitFrameGpuFence");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool XRPresentationClientStubDispatch::Accept(
    XRPresentationClient* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kXRPresentationClient_OnSubmitFrameTransferred_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::XRPresentationClient::OnSubmitFrameTransferred",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::XRPresentationClient::OnSubmitFrameTransferred");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::XRPresentationClient_OnSubmitFrameTransferred_Params_Data* params =
          reinterpret_cast<internal::XRPresentationClient_OnSubmitFrameTransferred_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_success{};
      XRPresentationClient_OnSubmitFrameTransferred_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_success = input_data_view.success();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRPresentationClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSubmitFrameTransferred(
std::move(p_success));
      return true;
    }
    case internal::kXRPresentationClient_OnSubmitFrameRendered_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::XRPresentationClient::OnSubmitFrameRendered",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::XRPresentationClient::OnSubmitFrameRendered");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::XRPresentationClient_OnSubmitFrameRendered_Params_Data* params =
          reinterpret_cast<internal::XRPresentationClient_OnSubmitFrameRendered_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      XRPresentationClient_OnSubmitFrameRendered_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRPresentationClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSubmitFrameRendered();
      return true;
    }
    case internal::kXRPresentationClient_OnSubmitFrameGpuFence_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::XRPresentationClient::OnSubmitFrameGpuFence",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::XRPresentationClient::OnSubmitFrameGpuFence");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::XRPresentationClient_OnSubmitFrameGpuFence_Params_Data* params =
          reinterpret_cast<internal::XRPresentationClient_OnSubmitFrameGpuFence_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gfx::GpuFenceHandle p_gpu_fence_handle{};
      XRPresentationClient_OnSubmitFrameGpuFence_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadGpuFenceHandle(&p_gpu_fence_handle))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRPresentationClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSubmitFrameGpuFence(
std::move(p_gpu_fence_handle));
      return true;
    }
  }
  return false;
}

// static
bool XRPresentationClientStubDispatch::AcceptWithResponder(
    XRPresentationClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kXRPresentationClient_OnSubmitFrameTransferred_Name: {
      break;
    }
    case internal::kXRPresentationClient_OnSubmitFrameRendered_Name: {
      break;
    }
    case internal::kXRPresentationClient_OnSubmitFrameGpuFence_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kXRPresentationClientValidationInfo[] = {
    {internal::kXRPresentationClient_OnSubmitFrameTransferred_Name,
     {&internal::XRPresentationClient_OnSubmitFrameTransferred_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kXRPresentationClient_OnSubmitFrameRendered_Name,
     {&internal::XRPresentationClient_OnSubmitFrameRendered_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kXRPresentationClient_OnSubmitFrameGpuFence_Name,
     {&internal::XRPresentationClient_OnSubmitFrameGpuFence_Params_Data::Validate,
      nullptr /* no response */}},
};

bool XRPresentationClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::XRPresentationClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kXRPresentationClientValidationInfo);
}

const char XRSessionClient::Name_[] = "device.mojom.XRSessionClient";

XRSessionClientProxy::XRSessionClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void XRSessionClientProxy::OnChanged(
    VRDisplayInfoPtr in_display) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::XRSessionClient::OnChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("display"), in_display, 
                        "<value of type VRDisplayInfoPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kXRSessionClient_OnChanged_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XRSessionClient_OnChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->display)::BaseType> display_fragment(
          params.message());
  mojo::internal::Serialize<::device::mojom::VRDisplayInfoDataView>(
      in_display, display_fragment);
  params->display.Set(
      display_fragment.is_null() ? nullptr : display_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->display.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null display in XRSessionClient.OnChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRSessionClient::Name_);
  message.set_method_name("OnChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void XRSessionClientProxy::OnExitPresent(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "device::mojom::XRSessionClient::OnExitPresent");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kXRSessionClient_OnExitPresent_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XRSessionClient_OnExitPresent_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRSessionClient::Name_);
  message.set_method_name("OnExitPresent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void XRSessionClientProxy::OnVisibilityStateChanged(
    XRVisibilityState in_visibility_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::XRSessionClient::OnVisibilityStateChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("visibility_state"), in_visibility_state, 
                        "<value of type XRVisibilityState>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kXRSessionClient_OnVisibilityStateChanged_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::XRSessionClient_OnVisibilityStateChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::device::mojom::XRVisibilityState>(
      in_visibility_state, &params->visibility_state);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(XRSessionClient::Name_);
  message.set_method_name("OnVisibilityStateChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool XRSessionClientStubDispatch::Accept(
    XRSessionClient* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kXRSessionClient_OnChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::XRSessionClient::OnChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::XRSessionClient::OnChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::XRSessionClient_OnChanged_Params_Data* params =
          reinterpret_cast<internal::XRSessionClient_OnChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      VRDisplayInfoPtr p_display{};
      XRSessionClient_OnChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDisplay(&p_display))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRSessionClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnChanged(
std::move(p_display));
      return true;
    }
    case internal::kXRSessionClient_OnExitPresent_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::XRSessionClient::OnExitPresent",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::XRSessionClient::OnExitPresent");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::XRSessionClient_OnExitPresent_Params_Data* params =
          reinterpret_cast<internal::XRSessionClient_OnExitPresent_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      XRSessionClient_OnExitPresent_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRSessionClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnExitPresent();
      return true;
    }
    case internal::kXRSessionClient_OnVisibilityStateChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::XRSessionClient::OnVisibilityStateChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::XRSessionClient::OnVisibilityStateChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::XRSessionClient_OnVisibilityStateChanged_Params_Data* params =
          reinterpret_cast<internal::XRSessionClient_OnVisibilityStateChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      XRVisibilityState p_visibility_state{};
      XRSessionClient_OnVisibilityStateChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadVisibilityState(&p_visibility_state))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            XRSessionClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnVisibilityStateChanged(
std::move(p_visibility_state));
      return true;
    }
  }
  return false;
}

// static
bool XRSessionClientStubDispatch::AcceptWithResponder(
    XRSessionClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kXRSessionClient_OnChanged_Name: {
      break;
    }
    case internal::kXRSessionClient_OnExitPresent_Name: {
      break;
    }
    case internal::kXRSessionClient_OnVisibilityStateChanged_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kXRSessionClientValidationInfo[] = {
    {internal::kXRSessionClient_OnChanged_Name,
     {&internal::XRSessionClient_OnChanged_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kXRSessionClient_OnExitPresent_Name,
     {&internal::XRSessionClient_OnExitPresent_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kXRSessionClient_OnVisibilityStateChanged_Name,
     {&internal::XRSessionClient_OnVisibilityStateChanged_Params_Data::Validate,
      nullptr /* no response */}},
};

bool XRSessionClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::XRSessionClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kXRSessionClientValidationInfo);
}

}  // namespace mojom
}  // namespace device

namespace mojo {


// static
bool StructTraits<::device::mojom::XRTrackedImage::DataView, ::device::mojom::XRTrackedImagePtr>::Read(
    ::device::mojom::XRTrackedImage::DataView input,
    ::device::mojom::XRTrackedImagePtr* output) {
  bool success = true;
  ::device::mojom::XRTrackedImagePtr result(::device::mojom::XRTrackedImage::New());
  
      if (success && !input.ReadBitmap(&result->bitmap))
        success = false;
      if (success && !input.ReadSizeInPixels(&result->size_in_pixels))
        success = false;
      if (success)
        result->width_in_meters = input.width_in_meters();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::XRDepthOptions::DataView, ::device::mojom::XRDepthOptionsPtr>::Read(
    ::device::mojom::XRDepthOptions::DataView input,
    ::device::mojom::XRDepthOptionsPtr* output) {
  bool success = true;
  ::device::mojom::XRDepthOptionsPtr result(::device::mojom::XRDepthOptions::New());
  
      if (success && !input.ReadUsagePreferences(&result->usage_preferences))
        success = false;
      if (success && !input.ReadDataFormatPreferences(&result->data_format_preferences))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::XRSessionOptions::DataView, ::device::mojom::XRSessionOptionsPtr>::Read(
    ::device::mojom::XRSessionOptions::DataView input,
    ::device::mojom::XRSessionOptionsPtr* output) {
  bool success = true;
  ::device::mojom::XRSessionOptionsPtr result(::device::mojom::XRSessionOptions::New());
  
      if (success && !input.ReadMode(&result->mode))
        success = false;
      if (success && !input.ReadRequiredFeatures(&result->required_features))
        success = false;
      if (success && !input.ReadOptionalFeatures(&result->optional_features))
        success = false;
      if (success && !input.ReadTrackedImages(&result->tracked_images))
        success = false;
      if (success && !input.ReadDepthOptions(&result->depth_options))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::XRDepthConfig::DataView, ::device::mojom::XRDepthConfigPtr>::Read(
    ::device::mojom::XRDepthConfig::DataView input,
    ::device::mojom::XRDepthConfigPtr* output) {
  bool success = true;
  ::device::mojom::XRDepthConfigPtr result(::device::mojom::XRDepthConfig::New());
  
      if (success && !input.ReadDepthUsage(&result->depth_usage))
        success = false;
      if (success && !input.ReadDepthDataFormat(&result->depth_data_format))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::XRSessionDeviceConfig::DataView, ::device::mojom::XRSessionDeviceConfigPtr>::Read(
    ::device::mojom::XRSessionDeviceConfig::DataView input,
    ::device::mojom::XRSessionDeviceConfigPtr* output) {
  bool success = true;
  ::device::mojom::XRSessionDeviceConfigPtr result(::device::mojom::XRSessionDeviceConfig::New());
  
      if (success)
        result->uses_input_eventing = input.uses_input_eventing();
      if (success)
        result->default_framebuffer_scale = input.default_framebuffer_scale();
      if (success)
        result->supports_viewport_scaling = input.supports_viewport_scaling();
      if (success)
        result->enable_anti_aliasing = input.enable_anti_aliasing();
      if (success && !input.ReadDepthConfiguration(&result->depth_configuration))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::XRSession::DataView, ::device::mojom::XRSessionPtr>::Read(
    ::device::mojom::XRSession::DataView input,
    ::device::mojom::XRSessionPtr* output) {
  bool success = true;
  ::device::mojom::XRSessionPtr result(::device::mojom::XRSession::New());
  
      if (success) {
        result->data_provider =
            input.TakeDataProvider<decltype(result->data_provider)>();
      }
      if (success) {
        result->client_receiver =
            input.TakeClientReceiver<decltype(result->client_receiver)>();
      }
      if (success && !input.ReadDisplayInfo(&result->display_info))
        success = false;
      if (success && !input.ReadSubmitFrameSink(&result->submit_frame_sink))
        success = false;
      if (success && !input.ReadEnabledFeatures(&result->enabled_features))
        success = false;
      if (success && !input.ReadDeviceConfig(&result->device_config))
        success = false;
      if (success && !input.ReadEnviromentBlendMode(&result->enviroment_blend_mode))
        success = false;
      if (success && !input.ReadInteractionMode(&result->interaction_mode))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::XRPresentationConnection::DataView, ::device::mojom::XRPresentationConnectionPtr>::Read(
    ::device::mojom::XRPresentationConnection::DataView input,
    ::device::mojom::XRPresentationConnectionPtr* output) {
  bool success = true;
  ::device::mojom::XRPresentationConnectionPtr result(::device::mojom::XRPresentationConnection::New());
  
      if (success) {
        result->provider =
            input.TakeProvider<decltype(result->provider)>();
      }
      if (success) {
        result->client_receiver =
            input.TakeClientReceiver<decltype(result->client_receiver)>();
      }
      if (success && !input.ReadTransportOptions(&result->transport_options))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::XRInputSourceDescription::DataView, ::device::mojom::XRInputSourceDescriptionPtr>::Read(
    ::device::mojom::XRInputSourceDescription::DataView input,
    ::device::mojom::XRInputSourceDescriptionPtr* output) {
  bool success = true;
  ::device::mojom::XRInputSourceDescriptionPtr result(::device::mojom::XRInputSourceDescription::New());
  
      if (success && !input.ReadTargetRayMode(&result->target_ray_mode))
        success = false;
      if (success && !input.ReadHandedness(&result->handedness))
        success = false;
      if (success && !input.ReadInputFromPointer(&result->input_from_pointer))
        success = false;
      if (success && !input.ReadProfiles(&result->profiles))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::XRHandJointData::DataView, ::device::mojom::XRHandJointDataPtr>::Read(
    ::device::mojom::XRHandJointData::DataView input,
    ::device::mojom::XRHandJointDataPtr* output) {
  bool success = true;
  ::device::mojom::XRHandJointDataPtr result(::device::mojom::XRHandJointData::New());
  
      if (success && !input.ReadJoint(&result->joint))
        success = false;
      if (success && !input.ReadMojoFromJoint(&result->mojo_from_joint))
        success = false;
      if (success)
        result->radius = input.radius();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::XRHandTrackingData::DataView, ::device::mojom::XRHandTrackingDataPtr>::Read(
    ::device::mojom::XRHandTrackingData::DataView input,
    ::device::mojom::XRHandTrackingDataPtr* output) {
  bool success = true;
  ::device::mojom::XRHandTrackingDataPtr result(::device::mojom::XRHandTrackingData::New());
  
      if (success && !input.ReadHandJointData(&result->hand_joint_data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::XRInputSourceState::DataView, ::device::mojom::XRInputSourceStatePtr>::Read(
    ::device::mojom::XRInputSourceState::DataView input,
    ::device::mojom::XRInputSourceStatePtr* output) {
  bool success = true;
  ::device::mojom::XRInputSourceStatePtr result(::device::mojom::XRInputSourceState::New());
  
      if (success)
        result->source_id = input.source_id();
      if (success && !input.ReadDescription(&result->description))
        success = false;
      if (success && !input.ReadMojoFromInput(&result->mojo_from_input))
        success = false;
      if (success)
        result->emulated_position = input.emulated_position();
      if (success)
        result->is_auxiliary = input.is_auxiliary();
      if (success)
        result->primary_input_pressed = input.primary_input_pressed();
      if (success)
        result->primary_input_clicked = input.primary_input_clicked();
      if (success)
        result->primary_squeeze_pressed = input.primary_squeeze_pressed();
      if (success)
        result->primary_squeeze_clicked = input.primary_squeeze_clicked();
      if (success && !input.ReadGamepad(&result->gamepad))
        success = false;
      if (success && !input.ReadOverlayPointerPosition(&result->overlay_pointer_position))
        success = false;
      if (success && !input.ReadHandTrackingData(&result->hand_tracking_data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::VRFieldOfView::DataView, ::device::mojom::VRFieldOfViewPtr>::Read(
    ::device::mojom::VRFieldOfView::DataView input,
    ::device::mojom::VRFieldOfViewPtr* output) {
  bool success = true;
  ::device::mojom::VRFieldOfViewPtr result(::device::mojom::VRFieldOfView::New());
  
      if (success)
        result->up_degrees = input.up_degrees();
      if (success)
        result->down_degrees = input.down_degrees();
      if (success)
        result->left_degrees = input.left_degrees();
      if (success)
        result->right_degrees = input.right_degrees();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::VRPose::DataView, ::device::mojom::VRPosePtr>::Read(
    ::device::mojom::VRPose::DataView input,
    ::device::mojom::VRPosePtr* output) {
  bool success = true;
  ::device::mojom::VRPosePtr result(::device::mojom::VRPose::New());
  
      if (success && !input.ReadOrientation(&result->orientation))
        success = false;
      if (success && !input.ReadPosition(&result->position))
        success = false;
      if (success)
        result->emulated_position = input.emulated_position();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::Pose::DataView, ::device::mojom::PosePtr>::Read(
    ::device::mojom::Pose::DataView input,
    ::device::mojom::PosePtr* output) {
  bool success = true;
  ::device::mojom::PosePtr result(::device::mojom::Pose::New());
  
      if (success && !input.ReadOrientation(&result->orientation))
        success = false;
      if (success && !input.ReadPosition(&result->position))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::XRRay::DataView, ::device::mojom::XRRayPtr>::Read(
    ::device::mojom::XRRay::DataView input,
    ::device::mojom::XRRayPtr* output) {
  bool success = true;
  ::device::mojom::XRRayPtr result(::device::mojom::XRRay::New());
  
      if (success && !input.ReadOrigin(&result->origin))
        success = false;
      if (success && !input.ReadDirection(&result->direction))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::XRHitResult::DataView, ::device::mojom::XRHitResultPtr>::Read(
    ::device::mojom::XRHitResult::DataView input,
    ::device::mojom::XRHitResultPtr* output) {
  bool success = true;
  ::device::mojom::XRHitResultPtr result(::device::mojom::XRHitResult::New());
  
      if (success && !input.ReadMojoFromResult(&result->mojo_from_result))
        success = false;
      if (success)
        result->plane_id = input.plane_id();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::VREyeParameters::DataView, ::device::mojom::VREyeParametersPtr>::Read(
    ::device::mojom::VREyeParameters::DataView input,
    ::device::mojom::VREyeParametersPtr* output) {
  bool success = true;
  ::device::mojom::VREyeParametersPtr result(::device::mojom::VREyeParameters::New());
  
      if (success && !input.ReadFieldOfView(&result->field_of_view))
        success = false;
      if (success && !input.ReadHeadFromEye(&result->head_from_eye))
        success = false;
      if (success)
        result->render_width = input.render_width();
      if (success)
        result->render_height = input.render_height();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::VRStageParameters::DataView, ::device::mojom::VRStageParametersPtr>::Read(
    ::device::mojom::VRStageParameters::DataView input,
    ::device::mojom::VRStageParametersPtr* output) {
  bool success = true;
  ::device::mojom::VRStageParametersPtr result(::device::mojom::VRStageParameters::New());
  
      if (success && !input.ReadMojoFromFloor(&result->mojo_from_floor))
        success = false;
      if (success && !input.ReadBounds(&result->bounds))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::VRDisplayInfo::DataView, ::device::mojom::VRDisplayInfoPtr>::Read(
    ::device::mojom::VRDisplayInfo::DataView input,
    ::device::mojom::VRDisplayInfoPtr* output) {
  bool success = true;
  ::device::mojom::VRDisplayInfoPtr result(::device::mojom::VRDisplayInfo::New());
  
      if (success && !input.ReadLeftEye(&result->left_eye))
        success = false;
      if (success && !input.ReadRightEye(&result->right_eye))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::XRPresentationTransportOptions::DataView, ::device::mojom::XRPresentationTransportOptionsPtr>::Read(
    ::device::mojom::XRPresentationTransportOptions::DataView input,
    ::device::mojom::XRPresentationTransportOptionsPtr* output) {
  bool success = true;
  ::device::mojom::XRPresentationTransportOptionsPtr result(::device::mojom::XRPresentationTransportOptions::New());
  
      if (success && !input.ReadTransportMethod(&result->transport_method))
        success = false;
      if (success)
        result->wait_for_transfer_notification = input.wait_for_transfer_notification();
      if (success)
        result->wait_for_render_notification = input.wait_for_render_notification();
      if (success)
        result->wait_for_gpu_fence = input.wait_for_gpu_fence();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::XRHandJointSpaceInfo::DataView, ::device::mojom::XRHandJointSpaceInfoPtr>::Read(
    ::device::mojom::XRHandJointSpaceInfo::DataView input,
    ::device::mojom::XRHandJointSpaceInfoPtr* output) {
  bool success = true;
  ::device::mojom::XRHandJointSpaceInfoPtr result(::device::mojom::XRHandJointSpaceInfo::New());
  
      if (success && !input.ReadHandedness(&result->handedness))
        success = false;
      if (success && !input.ReadJoint(&result->joint))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::XRPlanePointData::DataView, ::device::mojom::XRPlanePointDataPtr>::Read(
    ::device::mojom::XRPlanePointData::DataView input,
    ::device::mojom::XRPlanePointDataPtr* output) {
  bool success = true;
  ::device::mojom::XRPlanePointDataPtr result(::device::mojom::XRPlanePointData::New());
  
      if (success)
        result->x = input.x();
      if (success)
        result->z = input.z();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::XRPlaneData::DataView, ::device::mojom::XRPlaneDataPtr>::Read(
    ::device::mojom::XRPlaneData::DataView input,
    ::device::mojom::XRPlaneDataPtr* output) {
  bool success = true;
  ::device::mojom::XRPlaneDataPtr result(::device::mojom::XRPlaneData::New());
  
      if (success)
        result->id = input.id();
      if (success && !input.ReadOrientation(&result->orientation))
        success = false;
      if (success && !input.ReadMojoFromPlane(&result->mojo_from_plane))
        success = false;
      if (success && !input.ReadPolygon(&result->polygon))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::XRPlaneDetectionData::DataView, ::device::mojom::XRPlaneDetectionDataPtr>::Read(
    ::device::mojom::XRPlaneDetectionData::DataView input,
    ::device::mojom::XRPlaneDetectionDataPtr* output) {
  bool success = true;
  ::device::mojom::XRPlaneDetectionDataPtr result(::device::mojom::XRPlaneDetectionData::New());
  
      if (success && !input.ReadAllPlanesIds(&result->all_planes_ids))
        success = false;
      if (success && !input.ReadUpdatedPlanesData(&result->updated_planes_data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::XRAnchorData::DataView, ::device::mojom::XRAnchorDataPtr>::Read(
    ::device::mojom::XRAnchorData::DataView input,
    ::device::mojom::XRAnchorDataPtr* output) {
  bool success = true;
  ::device::mojom::XRAnchorDataPtr result(::device::mojom::XRAnchorData::New());
  
      if (success)
        result->id = input.id();
      if (success && !input.ReadMojoFromAnchor(&result->mojo_from_anchor))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::XRAnchorsData::DataView, ::device::mojom::XRAnchorsDataPtr>::Read(
    ::device::mojom::XRAnchorsData::DataView input,
    ::device::mojom::XRAnchorsDataPtr* output) {
  bool success = true;
  ::device::mojom::XRAnchorsDataPtr result(::device::mojom::XRAnchorsData::New());
  
      if (success && !input.ReadAllAnchorsIds(&result->all_anchors_ids))
        success = false;
      if (success && !input.ReadUpdatedAnchorsData(&result->updated_anchors_data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::XRHitTestSubscriptionResultData::DataView, ::device::mojom::XRHitTestSubscriptionResultDataPtr>::Read(
    ::device::mojom::XRHitTestSubscriptionResultData::DataView input,
    ::device::mojom::XRHitTestSubscriptionResultDataPtr* output) {
  bool success = true;
  ::device::mojom::XRHitTestSubscriptionResultDataPtr result(::device::mojom::XRHitTestSubscriptionResultData::New());
  
      if (success)
        result->subscription_id = input.subscription_id();
      if (success && !input.ReadHitTestResults(&result->hit_test_results))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::XRHitTestTransientInputSubscriptionResultData::DataView, ::device::mojom::XRHitTestTransientInputSubscriptionResultDataPtr>::Read(
    ::device::mojom::XRHitTestTransientInputSubscriptionResultData::DataView input,
    ::device::mojom::XRHitTestTransientInputSubscriptionResultDataPtr* output) {
  bool success = true;
  ::device::mojom::XRHitTestTransientInputSubscriptionResultDataPtr result(::device::mojom::XRHitTestTransientInputSubscriptionResultData::New());
  
      if (success)
        result->subscription_id = input.subscription_id();
      if (success && !input.ReadInputSourceIdToHitTestResults(&result->input_source_id_to_hit_test_results))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::XRHitTestSubscriptionResultsData::DataView, ::device::mojom::XRHitTestSubscriptionResultsDataPtr>::Read(
    ::device::mojom::XRHitTestSubscriptionResultsData::DataView input,
    ::device::mojom::XRHitTestSubscriptionResultsDataPtr* output) {
  bool success = true;
  ::device::mojom::XRHitTestSubscriptionResultsDataPtr result(::device::mojom::XRHitTestSubscriptionResultsData::New());
  
      if (success && !input.ReadResults(&result->results))
        success = false;
      if (success && !input.ReadTransientInputResults(&result->transient_input_results))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::RgbTupleF32::DataView, ::device::mojom::RgbTupleF32Ptr>::Read(
    ::device::mojom::RgbTupleF32::DataView input,
    ::device::mojom::RgbTupleF32Ptr* output) {
  bool success = true;
  ::device::mojom::RgbTupleF32Ptr result(::device::mojom::RgbTupleF32::New());
  
      if (success)
        result->red = input.red();
      if (success)
        result->green = input.green();
      if (success)
        result->blue = input.blue();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::XRSphericalHarmonics::DataView, ::device::mojom::XRSphericalHarmonicsPtr>::Read(
    ::device::mojom::XRSphericalHarmonics::DataView input,
    ::device::mojom::XRSphericalHarmonicsPtr* output) {
  bool success = true;
  ::device::mojom::XRSphericalHarmonicsPtr result(::device::mojom::XRSphericalHarmonics::New());
  
      if (success && !input.ReadCoefficients(&result->coefficients))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::RgbaTupleF16::DataView, ::device::mojom::RgbaTupleF16Ptr>::Read(
    ::device::mojom::RgbaTupleF16::DataView input,
    ::device::mojom::RgbaTupleF16Ptr* output) {
  bool success = true;
  ::device::mojom::RgbaTupleF16Ptr result(::device::mojom::RgbaTupleF16::New());
  
      if (success)
        result->red = input.red();
      if (success)
        result->green = input.green();
      if (success)
        result->blue = input.blue();
      if (success)
        result->alpha = input.alpha();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::XRCubeMap::DataView, ::device::mojom::XRCubeMapPtr>::Read(
    ::device::mojom::XRCubeMap::DataView input,
    ::device::mojom::XRCubeMapPtr* output) {
  bool success = true;
  ::device::mojom::XRCubeMapPtr result(::device::mojom::XRCubeMap::New());
  
      if (success)
        result->width_and_height = input.width_and_height();
      if (success && !input.ReadPositiveX(&result->positive_x))
        success = false;
      if (success && !input.ReadNegativeX(&result->negative_x))
        success = false;
      if (success && !input.ReadPositiveY(&result->positive_y))
        success = false;
      if (success && !input.ReadNegativeY(&result->negative_y))
        success = false;
      if (success && !input.ReadPositiveZ(&result->positive_z))
        success = false;
      if (success && !input.ReadNegativeZ(&result->negative_z))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::XRLightProbe::DataView, ::device::mojom::XRLightProbePtr>::Read(
    ::device::mojom::XRLightProbe::DataView input,
    ::device::mojom::XRLightProbePtr* output) {
  bool success = true;
  ::device::mojom::XRLightProbePtr result(::device::mojom::XRLightProbe::New());
  
      if (success && !input.ReadSphericalHarmonics(&result->spherical_harmonics))
        success = false;
      if (success && !input.ReadMainLightDirection(&result->main_light_direction))
        success = false;
      if (success && !input.ReadMainLightIntensity(&result->main_light_intensity))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::XRReflectionProbe::DataView, ::device::mojom::XRReflectionProbePtr>::Read(
    ::device::mojom::XRReflectionProbe::DataView input,
    ::device::mojom::XRReflectionProbePtr* output) {
  bool success = true;
  ::device::mojom::XRReflectionProbePtr result(::device::mojom::XRReflectionProbe::New());
  
      if (success && !input.ReadCubeMap(&result->cube_map))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::XRLightEstimationData::DataView, ::device::mojom::XRLightEstimationDataPtr>::Read(
    ::device::mojom::XRLightEstimationData::DataView input,
    ::device::mojom::XRLightEstimationDataPtr* output) {
  bool success = true;
  ::device::mojom::XRLightEstimationDataPtr result(::device::mojom::XRLightEstimationData::New());
  
      if (success && !input.ReadLightProbe(&result->light_probe))
        success = false;
      if (success && !input.ReadReflectionProbe(&result->reflection_probe))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::XRDepthDataStillValid::DataView, ::device::mojom::XRDepthDataStillValidPtr>::Read(
    ::device::mojom::XRDepthDataStillValid::DataView input,
    ::device::mojom::XRDepthDataStillValidPtr* output) {
  bool success = true;
  ::device::mojom::XRDepthDataStillValidPtr result(::device::mojom::XRDepthDataStillValid::New());
  
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::XRDepthDataUpdated::DataView, ::device::mojom::XRDepthDataUpdatedPtr>::Read(
    ::device::mojom::XRDepthDataUpdated::DataView input,
    ::device::mojom::XRDepthDataUpdatedPtr* output) {
  bool success = true;
  ::device::mojom::XRDepthDataUpdatedPtr result(::device::mojom::XRDepthDataUpdated::New());
  
      if (success && !input.ReadTimeDelta(&result->time_delta))
        success = false;
      if (success && !input.ReadPixelData(&result->pixel_data))
        success = false;
      if (success && !input.ReadNormTextureFromNormView(&result->norm_texture_from_norm_view))
        success = false;
      if (success && !input.ReadSize(&result->size))
        success = false;
      if (success)
        result->raw_value_to_meters = input.raw_value_to_meters();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::XRTrackedImageData::DataView, ::device::mojom::XRTrackedImageDataPtr>::Read(
    ::device::mojom::XRTrackedImageData::DataView input,
    ::device::mojom::XRTrackedImageDataPtr* output) {
  bool success = true;
  ::device::mojom::XRTrackedImageDataPtr result(::device::mojom::XRTrackedImageData::New());
  
      if (success)
        result->index = input.index();
      if (success && !input.ReadMojoFromImage(&result->mojo_from_image))
        success = false;
      if (success)
        result->actively_tracked = input.actively_tracked();
      if (success)
        result->width_in_meters = input.width_in_meters();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::XRTrackedImagesData::DataView, ::device::mojom::XRTrackedImagesDataPtr>::Read(
    ::device::mojom::XRTrackedImagesData::DataView input,
    ::device::mojom::XRTrackedImagesDataPtr* output) {
  bool success = true;
  ::device::mojom::XRTrackedImagesDataPtr result(::device::mojom::XRTrackedImagesData::New());
  
      if (success && !input.ReadImagesData(&result->images_data))
        success = false;
      if (success && !input.ReadImageTrackableScores(&result->image_trackable_scores))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::XRFrameData::DataView, ::device::mojom::XRFrameDataPtr>::Read(
    ::device::mojom::XRFrameData::DataView input,
    ::device::mojom::XRFrameDataPtr* output) {
  bool success = true;
  ::device::mojom::XRFrameDataPtr result(::device::mojom::XRFrameData::New());
  
      if (success && !input.ReadPose(&result->pose))
        success = false;
      if (success && !input.ReadTimeDelta(&result->time_delta))
        success = false;
      if (success && !input.ReadBufferHolder(&result->buffer_holder))
        success = false;
      if (success && !input.ReadCameraImageBufferHolder(&result->camera_image_buffer_holder))
        success = false;
      if (success && !input.ReadDepthData(&result->depth_data))
        success = false;
      if (success)
        result->mojo_space_reset = input.mojo_space_reset();
      if (success)
        result->frame_id = input.frame_id();
      if (success && !input.ReadLeftEye(&result->left_eye))
        success = false;
      if (success && !input.ReadRightEye(&result->right_eye))
        success = false;
      if (success && !input.ReadInputState(&result->input_state))
        success = false;
      if (success)
        result->stage_parameters_id = input.stage_parameters_id();
      if (success && !input.ReadStageParameters(&result->stage_parameters))
        success = false;
      if (success && !input.ReadDetectedPlanesData(&result->detected_planes_data))
        success = false;
      if (success && !input.ReadAnchorsData(&result->anchors_data))
        success = false;
      if (success && !input.ReadLightEstimationData(&result->light_estimation_data))
        success = false;
      if (success && !input.ReadHitTestSubscriptionResults(&result->hit_test_subscription_results))
        success = false;
      if (success)
        result->rendering_time_ratio = input.rendering_time_ratio();
      if (success && !input.ReadTrackedImages(&result->tracked_images))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::RequestSessionSuccess::DataView, ::device::mojom::RequestSessionSuccessPtr>::Read(
    ::device::mojom::RequestSessionSuccess::DataView input,
    ::device::mojom::RequestSessionSuccessPtr* output) {
  bool success = true;
  ::device::mojom::RequestSessionSuccessPtr result(::device::mojom::RequestSessionSuccess::New());
  
      if (success && !input.ReadSession(&result->session))
        success = false;
      if (success) {
        result->metrics_recorder =
            input.TakeMetricsRecorder<decltype(result->metrics_recorder)>();
      }
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::XRFrameDataRequestOptions::DataView, ::device::mojom::XRFrameDataRequestOptionsPtr>::Read(
    ::device::mojom::XRFrameDataRequestOptions::DataView input,
    ::device::mojom::XRFrameDataRequestOptionsPtr* output) {
  bool success = true;
  ::device::mojom::XRFrameDataRequestOptionsPtr result(::device::mojom::XRFrameDataRequestOptions::New());
  
      if (success)
        result->include_lighting_estimation_data = input.include_lighting_estimation_data();
      if (success)
        result->stage_parameters_id = input.stage_parameters_id();
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::device::mojom::XRNativeOriginInformation::DataView, ::device::mojom::XRNativeOriginInformationPtr>::Read(
    ::device::mojom::XRNativeOriginInformation::DataView input,
    ::device::mojom::XRNativeOriginInformationPtr* output) {
  using UnionType = ::device::mojom::XRNativeOriginInformation;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::INPUT_SOURCE_ID: {
      *output = UnionType::NewInputSourceId(input.input_source_id());
      break;
    }
    case Tag::PLANE_ID: {
      *output = UnionType::NewPlaneId(input.plane_id());
      break;
    }
    case Tag::ANCHOR_ID: {
      *output = UnionType::NewAnchorId(input.anchor_id());
      break;
    }
    case Tag::REFERENCE_SPACE_TYPE: {
      ::device::mojom::XRReferenceSpaceType result_reference_space_type;
      if (!input.ReadReferenceSpaceType(&result_reference_space_type))
        return false;

      *output = UnionType::NewReferenceSpaceType(result_reference_space_type);
      break;
    }
    case Tag::HAND_JOINT_SPACE_INFO: {
      ::device::mojom::XRHandJointSpaceInfoPtr result_hand_joint_space_info;
      if (!input.ReadHandJointSpaceInfo(&result_hand_joint_space_info))
        return false;

      *output = UnionType::NewHandJointSpaceInfo(
          std::move(result_hand_joint_space_info));
      break;
    }
    default:
      return false;
  }
  return true;
}

// static
bool UnionTraits<::device::mojom::XRDepthData::DataView, ::device::mojom::XRDepthDataPtr>::Read(
    ::device::mojom::XRDepthData::DataView input,
    ::device::mojom::XRDepthDataPtr* output) {
  using UnionType = ::device::mojom::XRDepthData;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::DATA_STILL_VALID: {
      ::device::mojom::XRDepthDataStillValidPtr result_data_still_valid;
      if (!input.ReadDataStillValid(&result_data_still_valid))
        return false;

      *output = UnionType::NewDataStillValid(
          std::move(result_data_still_valid));
      break;
    }
    case Tag::UPDATED_DEPTH_DATA: {
      ::device::mojom::XRDepthDataUpdatedPtr result_updated_depth_data;
      if (!input.ReadUpdatedDepthData(&result_updated_depth_data))
        return false;

      *output = UnionType::NewUpdatedDepthData(
          std::move(result_updated_depth_data));
      break;
    }
    default:
      return false;
  }
  return true;
}

// static
bool UnionTraits<::device::mojom::RequestSessionResult::DataView, ::device::mojom::RequestSessionResultPtr>::Read(
    ::device::mojom::RequestSessionResult::DataView input,
    ::device::mojom::RequestSessionResultPtr* output) {
  using UnionType = ::device::mojom::RequestSessionResult;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::SUCCESS: {
      ::device::mojom::RequestSessionSuccessPtr result_success;
      if (!input.ReadSuccess(&result_success))
        return false;

      *output = UnionType::NewSuccess(
          std::move(result_success));
      break;
    }
    case Tag::FAILURE_REASON: {
      ::device::mojom::RequestSessionError result_failure_reason;
      if (!input.ReadFailureReason(&result_failure_reason))
        return false;

      *output = UnionType::NewFailureReason(result_failure_reason);
      break;
    }
    default:
      return false;
  }
  return true;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif