// Copyright 2022 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// GENERATED FROM THE API DEFINITION IN
//   extensions/common/api/automation_internal.idl
// DO NOT EDIT.

#include "tools/json_schema_compiler/util.h"
#include "base/check.h"
#include "base/check_op.h"
#include "base/notreached.h"
#include "base/strings/string_number_conversions.h"
#include "base/strings/utf_string_conversions.h"
#include "base/values.h"
#include "extensions/common/api/automation_internal.h"
#include <set>
#include <utility>

using base::UTF8ToUTF16;

namespace extensions {
namespace api {
namespace automation_internal {
//
// Types
//

AXEventParams::AXEventParams()
 {}

AXEventParams::~AXEventParams() = default;
AXEventParams::AXEventParams(AXEventParams&& rhs) = default;
AXEventParams& AXEventParams::operator=(AXEventParams&& rhs) = default;
// static
bool AXEventParams::Populate(
    const base::Value& value, AXEventParams* out) {
  if (!value.is_dict()) {
    return false;
  }
  return true;
}

// static
std::unique_ptr<AXEventParams> AXEventParams::FromValue(const base::Value& value) {
  auto out = std::make_unique<AXEventParams>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> AXEventParams::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();


  return to_value_result;
}


AXTextLocationParams::AXTextLocationParams()
: node_id(0),
result(false),
left(0),
top(0),
width(0),
height(0),
request_id(0) {}

AXTextLocationParams::~AXTextLocationParams() = default;
AXTextLocationParams::AXTextLocationParams(AXTextLocationParams&& rhs) = default;
AXTextLocationParams& AXTextLocationParams::operator=(AXTextLocationParams&& rhs) = default;
// static
bool AXTextLocationParams::Populate(
    const base::Value& value, AXTextLocationParams* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* tree_id_value = nullptr;
  if (!dict->GetWithoutPathExpansion("treeID", &tree_id_value)) {
    return false;
  }
  {
    if (!tree_id_value->GetAsString(&out->tree_id)) {
      return false;
    }
  }

  const base::Value* node_id_value = nullptr;
  if (!dict->GetWithoutPathExpansion("nodeID", &node_id_value)) {
    return false;
  }
  {
    if (!node_id_value->GetAsInteger(&out->node_id)) {
      return false;
    }
  }

  const base::Value* result_value = nullptr;
  if (!dict->GetWithoutPathExpansion("result", &result_value)) {
    return false;
  }
  {
    if (!result_value->GetAsBoolean(&out->result)) {
      return false;
    }
  }

  const base::Value* left_value = nullptr;
  if (!dict->GetWithoutPathExpansion("left", &left_value)) {
    return false;
  }
  {
    if (!left_value->GetAsInteger(&out->left)) {
      return false;
    }
  }

  const base::Value* top_value = nullptr;
  if (!dict->GetWithoutPathExpansion("top", &top_value)) {
    return false;
  }
  {
    if (!top_value->GetAsInteger(&out->top)) {
      return false;
    }
  }

  const base::Value* width_value = nullptr;
  if (!dict->GetWithoutPathExpansion("width", &width_value)) {
    return false;
  }
  {
    if (!width_value->GetAsInteger(&out->width)) {
      return false;
    }
  }

  const base::Value* height_value = nullptr;
  if (!dict->GetWithoutPathExpansion("height", &height_value)) {
    return false;
  }
  {
    if (!height_value->GetAsInteger(&out->height)) {
      return false;
    }
  }

  const base::Value* request_id_value = nullptr;
  if (!dict->GetWithoutPathExpansion("requestID", &request_id_value)) {
    return false;
  }
  {
    if (!request_id_value->GetAsInteger(&out->request_id)) {
      return false;
    }
  }

  return true;
}

// static
std::unique_ptr<AXTextLocationParams> AXTextLocationParams::FromValue(const base::Value& value) {
  auto out = std::make_unique<AXTextLocationParams>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> AXTextLocationParams::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("treeID", std::make_unique<base::Value>(this->tree_id));

  to_value_result->SetWithoutPathExpansion("nodeID", std::make_unique<base::Value>(this->node_id));

  to_value_result->SetWithoutPathExpansion("result", std::make_unique<base::Value>(this->result));

  to_value_result->SetWithoutPathExpansion("left", std::make_unique<base::Value>(this->left));

  to_value_result->SetWithoutPathExpansion("top", std::make_unique<base::Value>(this->top));

  to_value_result->SetWithoutPathExpansion("width", std::make_unique<base::Value>(this->width));

  to_value_result->SetWithoutPathExpansion("height", std::make_unique<base::Value>(this->height));

  to_value_result->SetWithoutPathExpansion("requestID", std::make_unique<base::Value>(this->request_id));


  return to_value_result;
}


const char* ToString(ActionTypePrivate enum_param) {
  switch (enum_param) {
    case ACTION_TYPE_PRIVATE_RESUMEMEDIA:
      return "resumeMedia";
    case ACTION_TYPE_PRIVATE_STARTDUCKINGMEDIA:
      return "startDuckingMedia";
    case ACTION_TYPE_PRIVATE_STOPDUCKINGMEDIA:
      return "stopDuckingMedia";
    case ACTION_TYPE_PRIVATE_SUSPENDMEDIA:
      return "suspendMedia";
    case ACTION_TYPE_PRIVATE_NONE:
      return "";
  }
  NOTREACHED();
  return "";
}

ActionTypePrivate ParseActionTypePrivate(const std::string& enum_string) {
  if (enum_string == "resumeMedia")
    return ACTION_TYPE_PRIVATE_RESUMEMEDIA;
  if (enum_string == "startDuckingMedia")
    return ACTION_TYPE_PRIVATE_STARTDUCKINGMEDIA;
  if (enum_string == "stopDuckingMedia")
    return ACTION_TYPE_PRIVATE_STOPDUCKINGMEDIA;
  if (enum_string == "suspendMedia")
    return ACTION_TYPE_PRIVATE_SUSPENDMEDIA;
  return ACTION_TYPE_PRIVATE_NONE;
}


PerformActionRequiredParams::PerformActionRequiredParams()
: automation_node_id(0) {}

PerformActionRequiredParams::~PerformActionRequiredParams() = default;
PerformActionRequiredParams::PerformActionRequiredParams(PerformActionRequiredParams&& rhs) = default;
PerformActionRequiredParams& PerformActionRequiredParams::operator=(PerformActionRequiredParams&& rhs) = default;
// static
bool PerformActionRequiredParams::Populate(
    const base::Value& value, PerformActionRequiredParams* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* tree_id_value = nullptr;
  if (!dict->GetWithoutPathExpansion("treeID", &tree_id_value)) {
    return false;
  }
  {
    if (!tree_id_value->GetAsString(&out->tree_id)) {
      return false;
    }
  }

  const base::Value* automation_node_id_value = nullptr;
  if (!dict->GetWithoutPathExpansion("automationNodeID", &automation_node_id_value)) {
    return false;
  }
  {
    if (!automation_node_id_value->GetAsInteger(&out->automation_node_id)) {
      return false;
    }
  }

  const base::Value* action_type_value = nullptr;
  if (!dict->GetWithoutPathExpansion("actionType", &action_type_value)) {
    return false;
  }
  {
    if (!action_type_value->GetAsString(&out->action_type)) {
      return false;
    }
  }

  const base::Value* request_id_value = nullptr;
  if (dict->GetWithoutPathExpansion("requestID", &request_id_value)) {
    {
      int temp;
      if (!request_id_value->GetAsInteger(&temp)) {
        out->request_id.reset();
        return false;
      }
      else
        out->request_id = std::make_unique<int>(temp);
    }
  }

  return true;
}

// static
std::unique_ptr<PerformActionRequiredParams> PerformActionRequiredParams::FromValue(const base::Value& value) {
  auto out = std::make_unique<PerformActionRequiredParams>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> PerformActionRequiredParams::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("treeID", std::make_unique<base::Value>(this->tree_id));

  to_value_result->SetWithoutPathExpansion("automationNodeID", std::make_unique<base::Value>(this->automation_node_id));

  to_value_result->SetWithoutPathExpansion("actionType", std::make_unique<base::Value>(this->action_type));

  if (this->request_id.get()) {
    to_value_result->SetWithoutPathExpansion("requestID", std::make_unique<base::Value>(*this->request_id));

  }

  return to_value_result;
}


PerformCustomActionParams::PerformCustomActionParams()
: custom_action_id(0) {}

PerformCustomActionParams::~PerformCustomActionParams() = default;
PerformCustomActionParams::PerformCustomActionParams(PerformCustomActionParams&& rhs) = default;
PerformCustomActionParams& PerformCustomActionParams::operator=(PerformCustomActionParams&& rhs) = default;
// static
bool PerformCustomActionParams::Populate(
    const base::Value& value, PerformCustomActionParams* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* custom_action_id_value = nullptr;
  if (!dict->GetWithoutPathExpansion("customActionID", &custom_action_id_value)) {
    return false;
  }
  {
    if (!custom_action_id_value->GetAsInteger(&out->custom_action_id)) {
      return false;
    }
  }

  return true;
}

// static
std::unique_ptr<PerformCustomActionParams> PerformCustomActionParams::FromValue(const base::Value& value) {
  auto out = std::make_unique<PerformCustomActionParams>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> PerformCustomActionParams::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("customActionID", std::make_unique<base::Value>(this->custom_action_id));


  return to_value_result;
}


SetSelectionParams::SetSelectionParams()
: focus_node_id(0),
anchor_offset(0),
focus_offset(0) {}

SetSelectionParams::~SetSelectionParams() = default;
SetSelectionParams::SetSelectionParams(SetSelectionParams&& rhs) = default;
SetSelectionParams& SetSelectionParams::operator=(SetSelectionParams&& rhs) = default;
// static
bool SetSelectionParams::Populate(
    const base::Value& value, SetSelectionParams* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* focus_node_id_value = nullptr;
  if (!dict->GetWithoutPathExpansion("focusNodeID", &focus_node_id_value)) {
    return false;
  }
  {
    if (!focus_node_id_value->GetAsInteger(&out->focus_node_id)) {
      return false;
    }
  }

  const base::Value* anchor_offset_value = nullptr;
  if (!dict->GetWithoutPathExpansion("anchorOffset", &anchor_offset_value)) {
    return false;
  }
  {
    if (!anchor_offset_value->GetAsInteger(&out->anchor_offset)) {
      return false;
    }
  }

  const base::Value* focus_offset_value = nullptr;
  if (!dict->GetWithoutPathExpansion("focusOffset", &focus_offset_value)) {
    return false;
  }
  {
    if (!focus_offset_value->GetAsInteger(&out->focus_offset)) {
      return false;
    }
  }

  return true;
}

// static
std::unique_ptr<SetSelectionParams> SetSelectionParams::FromValue(const base::Value& value) {
  auto out = std::make_unique<SetSelectionParams>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> SetSelectionParams::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("focusNodeID", std::make_unique<base::Value>(this->focus_node_id));

  to_value_result->SetWithoutPathExpansion("anchorOffset", std::make_unique<base::Value>(this->anchor_offset));

  to_value_result->SetWithoutPathExpansion("focusOffset", std::make_unique<base::Value>(this->focus_offset));


  return to_value_result;
}


ReplaceSelectedTextParams::ReplaceSelectedTextParams()
 {}

ReplaceSelectedTextParams::~ReplaceSelectedTextParams() = default;
ReplaceSelectedTextParams::ReplaceSelectedTextParams(ReplaceSelectedTextParams&& rhs) = default;
ReplaceSelectedTextParams& ReplaceSelectedTextParams::operator=(ReplaceSelectedTextParams&& rhs) = default;
// static
bool ReplaceSelectedTextParams::Populate(
    const base::Value& value, ReplaceSelectedTextParams* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* value_value = nullptr;
  if (!dict->GetWithoutPathExpansion("value", &value_value)) {
    return false;
  }
  {
    if (!value_value->GetAsString(&out->value)) {
      return false;
    }
  }

  return true;
}

// static
std::unique_ptr<ReplaceSelectedTextParams> ReplaceSelectedTextParams::FromValue(const base::Value& value) {
  auto out = std::make_unique<ReplaceSelectedTextParams>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> ReplaceSelectedTextParams::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("value", std::make_unique<base::Value>(this->value));


  return to_value_result;
}


SetValueParams::SetValueParams()
 {}

SetValueParams::~SetValueParams() = default;
SetValueParams::SetValueParams(SetValueParams&& rhs) = default;
SetValueParams& SetValueParams::operator=(SetValueParams&& rhs) = default;
// static
bool SetValueParams::Populate(
    const base::Value& value, SetValueParams* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* value_value = nullptr;
  if (!dict->GetWithoutPathExpansion("value", &value_value)) {
    return false;
  }
  {
    if (!value_value->GetAsString(&out->value)) {
      return false;
    }
  }

  return true;
}

// static
std::unique_ptr<SetValueParams> SetValueParams::FromValue(const base::Value& value) {
  auto out = std::make_unique<SetValueParams>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> SetValueParams::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("value", std::make_unique<base::Value>(this->value));


  return to_value_result;
}


ScrollToPointParams::ScrollToPointParams()
: x(0),
y(0) {}

ScrollToPointParams::~ScrollToPointParams() = default;
ScrollToPointParams::ScrollToPointParams(ScrollToPointParams&& rhs) = default;
ScrollToPointParams& ScrollToPointParams::operator=(ScrollToPointParams&& rhs) = default;
// static
bool ScrollToPointParams::Populate(
    const base::Value& value, ScrollToPointParams* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* x_value = nullptr;
  if (!dict->GetWithoutPathExpansion("x", &x_value)) {
    return false;
  }
  {
    if (!x_value->GetAsInteger(&out->x)) {
      return false;
    }
  }

  const base::Value* y_value = nullptr;
  if (!dict->GetWithoutPathExpansion("y", &y_value)) {
    return false;
  }
  {
    if (!y_value->GetAsInteger(&out->y)) {
      return false;
    }
  }

  return true;
}

// static
std::unique_ptr<ScrollToPointParams> ScrollToPointParams::FromValue(const base::Value& value) {
  auto out = std::make_unique<ScrollToPointParams>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> ScrollToPointParams::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("x", std::make_unique<base::Value>(this->x));

  to_value_result->SetWithoutPathExpansion("y", std::make_unique<base::Value>(this->y));


  return to_value_result;
}


SetScrollOffsetParams::SetScrollOffsetParams()
: x(0),
y(0) {}

SetScrollOffsetParams::~SetScrollOffsetParams() = default;
SetScrollOffsetParams::SetScrollOffsetParams(SetScrollOffsetParams&& rhs) = default;
SetScrollOffsetParams& SetScrollOffsetParams::operator=(SetScrollOffsetParams&& rhs) = default;
// static
bool SetScrollOffsetParams::Populate(
    const base::Value& value, SetScrollOffsetParams* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* x_value = nullptr;
  if (!dict->GetWithoutPathExpansion("x", &x_value)) {
    return false;
  }
  {
    if (!x_value->GetAsInteger(&out->x)) {
      return false;
    }
  }

  const base::Value* y_value = nullptr;
  if (!dict->GetWithoutPathExpansion("y", &y_value)) {
    return false;
  }
  {
    if (!y_value->GetAsInteger(&out->y)) {
      return false;
    }
  }

  return true;
}

// static
std::unique_ptr<SetScrollOffsetParams> SetScrollOffsetParams::FromValue(const base::Value& value) {
  auto out = std::make_unique<SetScrollOffsetParams>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> SetScrollOffsetParams::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("x", std::make_unique<base::Value>(this->x));

  to_value_result->SetWithoutPathExpansion("y", std::make_unique<base::Value>(this->y));


  return to_value_result;
}


QuerySelectorRequiredParams::QuerySelectorRequiredParams()
: automation_node_id(0) {}

QuerySelectorRequiredParams::~QuerySelectorRequiredParams() = default;
QuerySelectorRequiredParams::QuerySelectorRequiredParams(QuerySelectorRequiredParams&& rhs) = default;
QuerySelectorRequiredParams& QuerySelectorRequiredParams::operator=(QuerySelectorRequiredParams&& rhs) = default;
// static
bool QuerySelectorRequiredParams::Populate(
    const base::Value& value, QuerySelectorRequiredParams* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* tree_id_value = nullptr;
  if (!dict->GetWithoutPathExpansion("treeID", &tree_id_value)) {
    return false;
  }
  {
    if (!tree_id_value->GetAsString(&out->tree_id)) {
      return false;
    }
  }

  const base::Value* automation_node_id_value = nullptr;
  if (!dict->GetWithoutPathExpansion("automationNodeID", &automation_node_id_value)) {
    return false;
  }
  {
    if (!automation_node_id_value->GetAsInteger(&out->automation_node_id)) {
      return false;
    }
  }

  const base::Value* selector_value = nullptr;
  if (!dict->GetWithoutPathExpansion("selector", &selector_value)) {
    return false;
  }
  {
    if (!selector_value->GetAsString(&out->selector)) {
      return false;
    }
  }

  return true;
}

// static
std::unique_ptr<QuerySelectorRequiredParams> QuerySelectorRequiredParams::FromValue(const base::Value& value) {
  auto out = std::make_unique<QuerySelectorRequiredParams>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> QuerySelectorRequiredParams::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("treeID", std::make_unique<base::Value>(this->tree_id));

  to_value_result->SetWithoutPathExpansion("automationNodeID", std::make_unique<base::Value>(this->automation_node_id));

  to_value_result->SetWithoutPathExpansion("selector", std::make_unique<base::Value>(this->selector));


  return to_value_result;
}


EnableTabParams::EnableTabParams()
 {}

EnableTabParams::~EnableTabParams() = default;
EnableTabParams::EnableTabParams(EnableTabParams&& rhs) = default;
EnableTabParams& EnableTabParams::operator=(EnableTabParams&& rhs) = default;
// static
bool EnableTabParams::Populate(
    const base::Value& value, EnableTabParams* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* tab_id_value = nullptr;
  if (dict->GetWithoutPathExpansion("tabID", &tab_id_value)) {
    {
      int temp;
      if (!tab_id_value->GetAsInteger(&temp)) {
        out->tab_id.reset();
        return false;
      }
      else
        out->tab_id = std::make_unique<int>(temp);
    }
  }

  return true;
}

// static
std::unique_ptr<EnableTabParams> EnableTabParams::FromValue(const base::Value& value) {
  auto out = std::make_unique<EnableTabParams>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> EnableTabParams::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->tab_id.get()) {
    to_value_result->SetWithoutPathExpansion("tabID", std::make_unique<base::Value>(*this->tab_id));

  }

  return to_value_result;
}


GetImageDataParams::GetImageDataParams()
: max_width(0),
max_height(0) {}

GetImageDataParams::~GetImageDataParams() = default;
GetImageDataParams::GetImageDataParams(GetImageDataParams&& rhs) = default;
GetImageDataParams& GetImageDataParams::operator=(GetImageDataParams&& rhs) = default;
// static
bool GetImageDataParams::Populate(
    const base::Value& value, GetImageDataParams* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* max_width_value = nullptr;
  if (!dict->GetWithoutPathExpansion("maxWidth", &max_width_value)) {
    return false;
  }
  {
    if (!max_width_value->GetAsInteger(&out->max_width)) {
      return false;
    }
  }

  const base::Value* max_height_value = nullptr;
  if (!dict->GetWithoutPathExpansion("maxHeight", &max_height_value)) {
    return false;
  }
  {
    if (!max_height_value->GetAsInteger(&out->max_height)) {
      return false;
    }
  }

  return true;
}

// static
std::unique_ptr<GetImageDataParams> GetImageDataParams::FromValue(const base::Value& value) {
  auto out = std::make_unique<GetImageDataParams>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> GetImageDataParams::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("maxWidth", std::make_unique<base::Value>(this->max_width));

  to_value_result->SetWithoutPathExpansion("maxHeight", std::make_unique<base::Value>(this->max_height));


  return to_value_result;
}


HitTestParams::HitTestParams()
: x(0),
y(0) {}

HitTestParams::~HitTestParams() = default;
HitTestParams::HitTestParams(HitTestParams&& rhs) = default;
HitTestParams& HitTestParams::operator=(HitTestParams&& rhs) = default;
// static
bool HitTestParams::Populate(
    const base::Value& value, HitTestParams* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* x_value = nullptr;
  if (!dict->GetWithoutPathExpansion("x", &x_value)) {
    return false;
  }
  {
    if (!x_value->GetAsInteger(&out->x)) {
      return false;
    }
  }

  const base::Value* y_value = nullptr;
  if (!dict->GetWithoutPathExpansion("y", &y_value)) {
    return false;
  }
  {
    if (!y_value->GetAsInteger(&out->y)) {
      return false;
    }
  }

  const base::Value* event_to_fire_value = nullptr;
  if (!dict->GetWithoutPathExpansion("eventToFire", &event_to_fire_value)) {
    return false;
  }
  {
    if (!event_to_fire_value->GetAsString(&out->event_to_fire)) {
      return false;
    }
  }

  return true;
}

// static
std::unique_ptr<HitTestParams> HitTestParams::FromValue(const base::Value& value) {
  auto out = std::make_unique<HitTestParams>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> HitTestParams::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("x", std::make_unique<base::Value>(this->x));

  to_value_result->SetWithoutPathExpansion("y", std::make_unique<base::Value>(this->y));

  to_value_result->SetWithoutPathExpansion("eventToFire", std::make_unique<base::Value>(this->event_to_fire));


  return to_value_result;
}


GetTextLocationDataParams::GetTextLocationDataParams()
: start_index(0),
end_index(0) {}

GetTextLocationDataParams::~GetTextLocationDataParams() = default;
GetTextLocationDataParams::GetTextLocationDataParams(GetTextLocationDataParams&& rhs) = default;
GetTextLocationDataParams& GetTextLocationDataParams::operator=(GetTextLocationDataParams&& rhs) = default;
// static
bool GetTextLocationDataParams::Populate(
    const base::Value& value, GetTextLocationDataParams* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* start_index_value = nullptr;
  if (!dict->GetWithoutPathExpansion("startIndex", &start_index_value)) {
    return false;
  }
  {
    if (!start_index_value->GetAsInteger(&out->start_index)) {
      return false;
    }
  }

  const base::Value* end_index_value = nullptr;
  if (!dict->GetWithoutPathExpansion("endIndex", &end_index_value)) {
    return false;
  }
  {
    if (!end_index_value->GetAsInteger(&out->end_index)) {
      return false;
    }
  }

  return true;
}

// static
std::unique_ptr<GetTextLocationDataParams> GetTextLocationDataParams::FromValue(const base::Value& value) {
  auto out = std::make_unique<GetTextLocationDataParams>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> GetTextLocationDataParams::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("startIndex", std::make_unique<base::Value>(this->start_index));

  to_value_result->SetWithoutPathExpansion("endIndex", std::make_unique<base::Value>(this->end_index));


  return to_value_result;
}



//
// Functions
//

namespace EnableTab {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* args_value = nullptr;
  if (args.Get(0, &args_value) &&
      !args_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!args_value->GetAsDictionary(&dictionary)) {
        return std::unique_ptr<Params>();
      }
      if (!EnableTabParams::Populate(*dictionary, &params->args)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::unique_ptr<base::ListValue> Results::Create(const std::string& tree_id, int tab_id) {
  auto create_results = std::make_unique<base::ListValue>();
  create_results->Append(std::make_unique<base::Value>(tree_id));

  create_results->Append(std::make_unique<base::Value>(tab_id));

  return create_results;
}
}  // namespace EnableTab

namespace EnableTree {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* tree_id_value = nullptr;
  if (args.Get(0, &tree_id_value) &&
      !tree_id_value->is_none()) {
    {
      if (!tree_id_value->GetAsString(&params->tree_id)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


}  // namespace EnableTree

namespace EnableDesktop {

std::unique_ptr<base::ListValue> Results::Create(const std::string& tree_id) {
  auto create_results = std::make_unique<base::ListValue>();
  create_results->Append(std::make_unique<base::Value>(tree_id));

  return create_results;
}
}  // namespace EnableDesktop

namespace PerformAction {

Params::OptArgs::OptArgs()
 {}

Params::OptArgs::~OptArgs() = default;
Params::OptArgs::OptArgs(OptArgs&& rhs) = default;
Params::OptArgs& Params::OptArgs::operator=(OptArgs&& rhs) = default;
// static
bool Params::OptArgs::Populate(
    const base::Value& value, OptArgs* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  out->additional_properties.MergeDictionary(dict);
  return true;
}


Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* args_value = nullptr;
  if (args.Get(0, &args_value) &&
      !args_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!args_value->GetAsDictionary(&dictionary)) {
        return std::unique_ptr<Params>();
      }
      if (!PerformActionRequiredParams::Populate(*dictionary, &params->args)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* opt_args_value = nullptr;
  if (args.Get(1, &opt_args_value) &&
      !opt_args_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!opt_args_value->GetAsDictionary(&dictionary)) {
        return std::unique_ptr<Params>();
      }
      if (!OptArgs::Populate(*dictionary, &params->opt_args)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


}  // namespace PerformAction

namespace QuerySelector {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* args_value = nullptr;
  if (args.Get(0, &args_value) &&
      !args_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!args_value->GetAsDictionary(&dictionary)) {
        return std::unique_ptr<Params>();
      }
      if (!QuerySelectorRequiredParams::Populate(*dictionary, &params->args)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::unique_ptr<base::ListValue> Results::Create(int result_automation_node_id) {
  auto create_results = std::make_unique<base::ListValue>();
  create_results->Append(std::make_unique<base::Value>(result_automation_node_id));

  return create_results;
}
}  // namespace QuerySelector

//
// Events
//

namespace OnAccessibilityEvent {

const char kEventName[] = "automationInternal.onAccessibilityEvent";

std::unique_ptr<base::ListValue> Create(const AXEventParams& update) {
  auto create_results = std::make_unique<base::ListValue>();
  create_results->Append((update).ToValue());

  return create_results;
}

}  // namespace OnAccessibilityEvent

namespace OnAccessibilityTreeDestroyed {

const char kEventName[] = "automationInternal.onAccessibilityTreeDestroyed";

std::unique_ptr<base::ListValue> Create(const std::string& tree_id) {
  auto create_results = std::make_unique<base::ListValue>();
  create_results->Append(std::make_unique<base::Value>(tree_id));

  return create_results;
}

}  // namespace OnAccessibilityTreeDestroyed

namespace OnGetTextLocationResult {

const char kEventName[] = "automationInternal.onGetTextLocationResult";

std::unique_ptr<base::ListValue> Create(const AXTextLocationParams& params) {
  auto create_results = std::make_unique<base::ListValue>();
  create_results->Append((params).ToValue());

  return create_results;
}

}  // namespace OnGetTextLocationResult

namespace OnTreeChange {

const char kEventName[] = "automationInternal.onTreeChange";

std::unique_ptr<base::ListValue> Create(int observer_id, const std::string& tree_id, int node_id, const std::string& change_type) {
  auto create_results = std::make_unique<base::ListValue>();
  create_results->Append(std::make_unique<base::Value>(observer_id));

  create_results->Append(std::make_unique<base::Value>(tree_id));

  create_results->Append(std::make_unique<base::Value>(node_id));

  create_results->Append(std::make_unique<base::Value>(change_type));

  return create_results;
}

}  // namespace OnTreeChange

namespace OnChildTreeID {

const char kEventName[] = "automationInternal.onChildTreeID";

std::unique_ptr<base::ListValue> Create(const std::string& tree_id) {
  auto create_results = std::make_unique<base::ListValue>();
  create_results->Append(std::make_unique<base::Value>(tree_id));

  return create_results;
}

}  // namespace OnChildTreeID

namespace OnNodesRemoved {

const char kEventName[] = "automationInternal.onNodesRemoved";

std::unique_ptr<base::ListValue> Create(const std::string& tree_id, const std::vector<int>& node_i_ds) {
  auto create_results = std::make_unique<base::ListValue>();
  create_results->Append(std::make_unique<base::Value>(tree_id));

  create_results->Append(json_schema_compiler::util::CreateValueFromArray(node_i_ds));

  return create_results;
}

}  // namespace OnNodesRemoved

namespace OnAccessibilityTreeSerializationError {

const char kEventName[] = "automationInternal.onAccessibilityTreeSerializationError";

std::unique_ptr<base::ListValue> Create(const std::string& tree_id) {
  auto create_results = std::make_unique<base::ListValue>();
  create_results->Append(std::make_unique<base::Value>(tree_id));

  return create_results;
}

}  // namespace OnAccessibilityTreeSerializationError

namespace OnActionResult {

const char kEventName[] = "automationInternal.onActionResult";

std::unique_ptr<base::ListValue> Create(const std::string& tree_id, int request_id, bool result) {
  auto create_results = std::make_unique<base::ListValue>();
  create_results->Append(std::make_unique<base::Value>(tree_id));

  create_results->Append(std::make_unique<base::Value>(request_id));

  create_results->Append(std::make_unique<base::Value>(result));

  return create_results;
}

}  // namespace OnActionResult

}  // namespace automation_internal
}  // namespace api
}  // namespace extensions

