// Copyright 2022 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// GENERATED FROM THE API DEFINITION IN
//   extensions/common/api/content_scripts.idl
// DO NOT EDIT.

#include "tools/json_schema_compiler/util.h"
#include "base/check.h"
#include "base/check_op.h"
#include "base/notreached.h"
#include "base/strings/string_number_conversions.h"
#include "base/strings/utf_string_conversions.h"
#include "base/values.h"
#include "extensions/common/api/content_scripts.h"
#include <set>
#include <utility>
#include "tools/json_schema_compiler/manifest_parse_util.h"

#include "base/strings/string_piece.h"


using base::UTF8ToUTF16;

namespace extensions {
namespace api {
namespace content_scripts {
//
// Types
//

const char* ToString(RunAt enum_param) {
  switch (enum_param) {
    case RUN_AT_DOCUMENT_IDLE:
      return "document_idle";
    case RUN_AT_DOCUMENT_START:
      return "document_start";
    case RUN_AT_DOCUMENT_END:
      return "document_end";
    case RUN_AT_NONE:
      return "";
  }
  NOTREACHED();
  return "";
}

RunAt ParseRunAt(const std::string& enum_string) {
  if (enum_string == "document_idle")
    return RUN_AT_DOCUMENT_IDLE;
  if (enum_string == "document_start")
    return RUN_AT_DOCUMENT_START;
  if (enum_string == "document_end")
    return RUN_AT_DOCUMENT_END;
  return RUN_AT_NONE;
}


ContentScript::ContentScript()
: run_at(RUN_AT_NONE) {}

ContentScript::~ContentScript() = default;
ContentScript::ContentScript(ContentScript&& rhs) = default;
ContentScript& ContentScript::operator=(ContentScript&& rhs) = default;
// static
constexpr char ContentScript::kMatches[];
// static
constexpr char ContentScript::kExcludeMatches[];
// static
constexpr char ContentScript::kCss[];
// static
constexpr char ContentScript::kJs[];
// static
constexpr char ContentScript::kAllFrames[];
// static
constexpr char ContentScript::kMatchOriginAsFallback[];
// static
constexpr char ContentScript::kMatchAboutBlank[];
// static
constexpr char ContentScript::kIncludeGlobs[];
// static
constexpr char ContentScript::kExcludeGlobs[];
// static
constexpr char ContentScript::kRunAt[];

// static
bool ContentScript::Populate(
    const base::Value& value, ContentScript* out, base::string16* error) {
  DCHECK(error);
  if (!value.is_dict()) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("expected dictionary, got " + std::string(base::Value::GetTypeName(value.type())));
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  out->run_at = RUN_AT_NONE;
  const base::Value* matches_value = nullptr;
  if (!dict->GetWithoutPathExpansion("matches", &matches_value)) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("'matches' is required");
    return false;
  }
  {
    const base::ListValue* list = nullptr;
    if (!matches_value->GetAsList(&list)) {
      DCHECK(error->empty());
      *error = UTF8ToUTF16("'matches': expected list, got " + std::string(base::Value::GetTypeName(matches_value->type())));
      return false;
    }
    else {
      base::string16 array_parse_error;
      if (!json_schema_compiler::util::PopulateArrayFromList(*list, &out->matches, &array_parse_error)) {
        array_parse_error = base::UTF8ToUTF16("Error at key 'matches': ") + array_parse_error;
        DCHECK(error->empty());
        *error = array_parse_error;
        return false;
      }
    }
  }

  const base::Value* exclude_matches_value = nullptr;
  if (dict->GetWithoutPathExpansion("exclude_matches", &exclude_matches_value)) {
    {
      const base::ListValue* list = nullptr;
      if (!exclude_matches_value->GetAsList(&list)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'exclude_matches': expected list, got " + std::string(base::Value::GetTypeName(exclude_matches_value->type())));
        return false;
      }
      else {
        base::string16 array_parse_error;
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->exclude_matches, &array_parse_error)) {
          array_parse_error = base::UTF8ToUTF16("Error at key 'exclude_matches': ") + array_parse_error;
          DCHECK(error->empty());
          *error = array_parse_error;
          return false;
        }
      }
    }
  }

  const base::Value* css_value = nullptr;
  if (dict->GetWithoutPathExpansion("css", &css_value)) {
    {
      const base::ListValue* list = nullptr;
      if (!css_value->GetAsList(&list)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'css': expected list, got " + std::string(base::Value::GetTypeName(css_value->type())));
        return false;
      }
      else {
        base::string16 array_parse_error;
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->css, &array_parse_error)) {
          array_parse_error = base::UTF8ToUTF16("Error at key 'css': ") + array_parse_error;
          DCHECK(error->empty());
          *error = array_parse_error;
          return false;
        }
      }
    }
  }

  const base::Value* js_value = nullptr;
  if (dict->GetWithoutPathExpansion("js", &js_value)) {
    {
      const base::ListValue* list = nullptr;
      if (!js_value->GetAsList(&list)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'js': expected list, got " + std::string(base::Value::GetTypeName(js_value->type())));
        return false;
      }
      else {
        base::string16 array_parse_error;
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->js, &array_parse_error)) {
          array_parse_error = base::UTF8ToUTF16("Error at key 'js': ") + array_parse_error;
          DCHECK(error->empty());
          *error = array_parse_error;
          return false;
        }
      }
    }
  }

  const base::Value* all_frames_value = nullptr;
  if (dict->GetWithoutPathExpansion("all_frames", &all_frames_value)) {
    {
      bool temp;
      if (!all_frames_value->GetAsBoolean(&temp)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'all_frames': expected all_frames, got " + std::string(base::Value::GetTypeName(all_frames_value->type())));
        out->all_frames.reset();
        return false;
      }
      else
        out->all_frames = std::make_unique<bool>(temp);
    }
  }

  const base::Value* match_origin_as_fallback_value = nullptr;
  if (dict->GetWithoutPathExpansion("match_origin_as_fallback", &match_origin_as_fallback_value)) {
    {
      bool temp;
      if (!match_origin_as_fallback_value->GetAsBoolean(&temp)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'match_origin_as_fallback': expected match_origin_as_fallback, got " + std::string(base::Value::GetTypeName(match_origin_as_fallback_value->type())));
        out->match_origin_as_fallback.reset();
        return false;
      }
      else
        out->match_origin_as_fallback = std::make_unique<bool>(temp);
    }
  }

  const base::Value* match_about_blank_value = nullptr;
  if (dict->GetWithoutPathExpansion("match_about_blank", &match_about_blank_value)) {
    {
      bool temp;
      if (!match_about_blank_value->GetAsBoolean(&temp)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'match_about_blank': expected match_about_blank, got " + std::string(base::Value::GetTypeName(match_about_blank_value->type())));
        out->match_about_blank.reset();
        return false;
      }
      else
        out->match_about_blank = std::make_unique<bool>(temp);
    }
  }

  const base::Value* include_globs_value = nullptr;
  if (dict->GetWithoutPathExpansion("include_globs", &include_globs_value)) {
    {
      const base::ListValue* list = nullptr;
      if (!include_globs_value->GetAsList(&list)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'include_globs': expected list, got " + std::string(base::Value::GetTypeName(include_globs_value->type())));
        return false;
      }
      else {
        base::string16 array_parse_error;
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->include_globs, &array_parse_error)) {
          array_parse_error = base::UTF8ToUTF16("Error at key 'include_globs': ") + array_parse_error;
          DCHECK(error->empty());
          *error = array_parse_error;
          return false;
        }
      }
    }
  }

  const base::Value* exclude_globs_value = nullptr;
  if (dict->GetWithoutPathExpansion("exclude_globs", &exclude_globs_value)) {
    {
      const base::ListValue* list = nullptr;
      if (!exclude_globs_value->GetAsList(&list)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'exclude_globs': expected list, got " + std::string(base::Value::GetTypeName(exclude_globs_value->type())));
        return false;
      }
      else {
        base::string16 array_parse_error;
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->exclude_globs, &array_parse_error)) {
          array_parse_error = base::UTF8ToUTF16("Error at key 'exclude_globs': ") + array_parse_error;
          DCHECK(error->empty());
          *error = array_parse_error;
          return false;
        }
      }
    }
  }

  const base::Value* run_at_value = nullptr;
  if (dict->GetWithoutPathExpansion("run_at", &run_at_value)) {
    {
      std::string run_at_as_string;
      if (!run_at_value->GetAsString(&run_at_as_string)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'RunAt': expected string, got " + std::string(base::Value::GetTypeName(run_at_value->type())));
        return false;
      }
      out->run_at = ParseRunAt(run_at_as_string);
      if (out->run_at == RUN_AT_NONE) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'RunAt': expected \"document_idle\" or \"document_start\" or \"document_end\", got \"" + run_at_as_string + "\"");
        return false;
      }
    }
    } else {
    out->run_at = RUN_AT_NONE;
  }

  return true;
}

// static
std::unique_ptr<ContentScript> ContentScript::FromValue(const base::Value& value, base::string16* error) {
  DCHECK(error);
  auto out = std::make_unique<ContentScript>();
  bool result = Populate(value, out.get(), error);
  DCHECK_EQ(result, error->empty());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> ContentScript::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("matches", json_schema_compiler::util::CreateValueFromArray(this->matches));

  if (this->exclude_matches.get()) {
    to_value_result->SetWithoutPathExpansion("exclude_matches", json_schema_compiler::util::CreateValueFromOptionalArray(this->exclude_matches));

  }
  if (this->css.get()) {
    to_value_result->SetWithoutPathExpansion("css", json_schema_compiler::util::CreateValueFromOptionalArray(this->css));

  }
  if (this->js.get()) {
    to_value_result->SetWithoutPathExpansion("js", json_schema_compiler::util::CreateValueFromOptionalArray(this->js));

  }
  if (this->all_frames.get()) {
    to_value_result->SetWithoutPathExpansion("all_frames", std::make_unique<base::Value>(*this->all_frames));

  }
  if (this->match_origin_as_fallback.get()) {
    to_value_result->SetWithoutPathExpansion("match_origin_as_fallback", std::make_unique<base::Value>(*this->match_origin_as_fallback));

  }
  if (this->match_about_blank.get()) {
    to_value_result->SetWithoutPathExpansion("match_about_blank", std::make_unique<base::Value>(*this->match_about_blank));

  }
  if (this->include_globs.get()) {
    to_value_result->SetWithoutPathExpansion("include_globs", json_schema_compiler::util::CreateValueFromOptionalArray(this->include_globs));

  }
  if (this->exclude_globs.get()) {
    to_value_result->SetWithoutPathExpansion("exclude_globs", json_schema_compiler::util::CreateValueFromOptionalArray(this->exclude_globs));

  }
  if (this->run_at != RUN_AT_NONE) {
    to_value_result->SetWithoutPathExpansion("run_at", std::make_unique<base::Value>(content_scripts::ToString(this->run_at)));

  }

  return to_value_result;
}

//static
bool ContentScript::ParseFromDictionary(
const base::DictionaryValue& root_dict, base::StringPiece key, ContentScript* out, base::string16* error, std::vector<base::StringPiece>* error_path_reversed) {
  DCHECK(out);
  DCHECK(error);
  DCHECK(error_path_reversed);

  const base::Value* value = ::json_schema_compiler::manifest_parse_util::FindKeyOfType(root_dict, key, base::Value::Type::DICTIONARY, error, error_path_reversed);
  if (!value)
    return false;
  const base::DictionaryValue& dict = base::Value::AsDictionaryValue(*value);
  out->run_at = RUN_AT_NONE;
  if (!::json_schema_compiler::manifest_parse_util::ParseFromDictionary(dict, kMatches, &out->matches, error, error_path_reversed)) {
    error_path_reversed->push_back(key);
    return false;
  }

  if (!::json_schema_compiler::manifest_parse_util::ParseFromDictionary(dict, kExcludeMatches, &out->exclude_matches, error, error_path_reversed)) {
    error_path_reversed->push_back(key);
    return false;
  }

  if (!::json_schema_compiler::manifest_parse_util::ParseFromDictionary(dict, kCss, &out->css, error, error_path_reversed)) {
    error_path_reversed->push_back(key);
    return false;
  }

  if (!::json_schema_compiler::manifest_parse_util::ParseFromDictionary(dict, kJs, &out->js, error, error_path_reversed)) {
    error_path_reversed->push_back(key);
    return false;
  }

  if (!::json_schema_compiler::manifest_parse_util::ParseFromDictionary(dict, kAllFrames, &out->all_frames, error, error_path_reversed)) {
    error_path_reversed->push_back(key);
    return false;
  }

  if (!::json_schema_compiler::manifest_parse_util::ParseFromDictionary(dict, kMatchOriginAsFallback, &out->match_origin_as_fallback, error, error_path_reversed)) {
    error_path_reversed->push_back(key);
    return false;
  }

  if (!::json_schema_compiler::manifest_parse_util::ParseFromDictionary(dict, kMatchAboutBlank, &out->match_about_blank, error, error_path_reversed)) {
    error_path_reversed->push_back(key);
    return false;
  }

  if (!::json_schema_compiler::manifest_parse_util::ParseFromDictionary(dict, kIncludeGlobs, &out->include_globs, error, error_path_reversed)) {
    error_path_reversed->push_back(key);
    return false;
  }

  if (!::json_schema_compiler::manifest_parse_util::ParseFromDictionary(dict, kExcludeGlobs, &out->exclude_globs, error, error_path_reversed)) {
    error_path_reversed->push_back(key);
    return false;
  }

  if (!::json_schema_compiler::manifest_parse_util::ParseEnumFromDictionary(dict, kRunAt, &ParseRunAt, true, RUN_AT_NONE, &out->run_at, error, error_path_reversed)) {
    error_path_reversed->push_back(key);
    return false;
  }

  return true;
}



//
// Manifest Keys
//

ManifestKeys::ManifestKeys()
 {}

ManifestKeys::~ManifestKeys() = default;
ManifestKeys::ManifestKeys(ManifestKeys&& rhs) = default;
ManifestKeys& ManifestKeys::operator=(ManifestKeys&& rhs) = default;
// static
constexpr char ManifestKeys::kContentScripts[];

//static
bool ManifestKeys::ParseFromDictionary(
const base::DictionaryValue& root_dict, ManifestKeys* out, base::string16* error) {
  DCHECK(out);
  DCHECK(error);

  std::vector<base::StringPiece> error_path_reversed_vec;
  auto* error_path_reversed = &error_path_reversed_vec;
  const base::DictionaryValue& dict = root_dict;
  if (!::json_schema_compiler::manifest_parse_util::ParseFromDictionary(dict, kContentScripts, &out->content_scripts, error, error_path_reversed)) {
    ::json_schema_compiler::manifest_parse_util::PopulateFinalError(error, error_path_reversed);
    return false;
  }

  return true;
}


}  // namespace content_scripts
}  // namespace api
}  // namespace extensions

