// Copyright 2022 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// GENERATED FROM THE API DEFINITION IN
//   extensions/common/api/declarative_net_request.idl
// DO NOT EDIT.

#include "tools/json_schema_compiler/util.h"
#include "base/check.h"
#include "base/check_op.h"
#include "base/notreached.h"
#include "base/strings/string_number_conversions.h"
#include "base/strings/utf_string_conversions.h"
#include "base/values.h"
#include "extensions/common/api/declarative_net_request.h"
#include <set>
#include <utility>
#include "tools/json_schema_compiler/manifest_parse_util.h"

#include "base/strings/string_piece.h"


using base::UTF8ToUTF16;

namespace extensions {
namespace api {
namespace declarative_net_request {
//
// Properties
//

const int GUARANTEED_MINIMUM_STATIC_RULES = 30000;

const int MAX_NUMBER_OF_DYNAMIC_RULES = 5000;

const int MAX_NUMBER_OF_DYNAMIC_AND_SESSION_RULES = 5000;

const int GETMATCHEDRULES_QUOTA_INTERVAL = 10;

const int MAX_GETMATCHEDRULES_CALLS_PER_INTERVAL = 20;

const int MAX_NUMBER_OF_REGEX_RULES = 1000;

const int MAX_NUMBER_OF_STATIC_RULESETS = 10;

const char DYNAMIC_RULESET_ID[] = "_dynamic";

const char SESSION_RULESET_ID[] = "_session";

//
// Types
//

const char* ToString(ResourceType enum_param) {
  switch (enum_param) {
    case RESOURCE_TYPE_MAIN_FRAME:
      return "main_frame";
    case RESOURCE_TYPE_SUB_FRAME:
      return "sub_frame";
    case RESOURCE_TYPE_STYLESHEET:
      return "stylesheet";
    case RESOURCE_TYPE_SCRIPT:
      return "script";
    case RESOURCE_TYPE_IMAGE:
      return "image";
    case RESOURCE_TYPE_FONT:
      return "font";
    case RESOURCE_TYPE_OBJECT:
      return "object";
    case RESOURCE_TYPE_XMLHTTPREQUEST:
      return "xmlhttprequest";
    case RESOURCE_TYPE_PING:
      return "ping";
    case RESOURCE_TYPE_CSP_REPORT:
      return "csp_report";
    case RESOURCE_TYPE_MEDIA:
      return "media";
    case RESOURCE_TYPE_WEBSOCKET:
      return "websocket";
    case RESOURCE_TYPE_OTHER:
      return "other";
    case RESOURCE_TYPE_NONE:
      return "";
  }
  NOTREACHED();
  return "";
}

ResourceType ParseResourceType(const std::string& enum_string) {
  if (enum_string == "main_frame")
    return RESOURCE_TYPE_MAIN_FRAME;
  if (enum_string == "sub_frame")
    return RESOURCE_TYPE_SUB_FRAME;
  if (enum_string == "stylesheet")
    return RESOURCE_TYPE_STYLESHEET;
  if (enum_string == "script")
    return RESOURCE_TYPE_SCRIPT;
  if (enum_string == "image")
    return RESOURCE_TYPE_IMAGE;
  if (enum_string == "font")
    return RESOURCE_TYPE_FONT;
  if (enum_string == "object")
    return RESOURCE_TYPE_OBJECT;
  if (enum_string == "xmlhttprequest")
    return RESOURCE_TYPE_XMLHTTPREQUEST;
  if (enum_string == "ping")
    return RESOURCE_TYPE_PING;
  if (enum_string == "csp_report")
    return RESOURCE_TYPE_CSP_REPORT;
  if (enum_string == "media")
    return RESOURCE_TYPE_MEDIA;
  if (enum_string == "websocket")
    return RESOURCE_TYPE_WEBSOCKET;
  if (enum_string == "other")
    return RESOURCE_TYPE_OTHER;
  return RESOURCE_TYPE_NONE;
}


const char* ToString(DomainType enum_param) {
  switch (enum_param) {
    case DOMAIN_TYPE_FIRSTPARTY:
      return "firstParty";
    case DOMAIN_TYPE_THIRDPARTY:
      return "thirdParty";
    case DOMAIN_TYPE_NONE:
      return "";
  }
  NOTREACHED();
  return "";
}

DomainType ParseDomainType(const std::string& enum_string) {
  if (enum_string == "firstParty")
    return DOMAIN_TYPE_FIRSTPARTY;
  if (enum_string == "thirdParty")
    return DOMAIN_TYPE_THIRDPARTY;
  return DOMAIN_TYPE_NONE;
}


const char* ToString(HeaderOperation enum_param) {
  switch (enum_param) {
    case HEADER_OPERATION_APPEND:
      return "append";
    case HEADER_OPERATION_SET:
      return "set";
    case HEADER_OPERATION_REMOVE:
      return "remove";
    case HEADER_OPERATION_NONE:
      return "";
  }
  NOTREACHED();
  return "";
}

HeaderOperation ParseHeaderOperation(const std::string& enum_string) {
  if (enum_string == "append")
    return HEADER_OPERATION_APPEND;
  if (enum_string == "set")
    return HEADER_OPERATION_SET;
  if (enum_string == "remove")
    return HEADER_OPERATION_REMOVE;
  return HEADER_OPERATION_NONE;
}


const char* ToString(RuleActionType enum_param) {
  switch (enum_param) {
    case RULE_ACTION_TYPE_BLOCK:
      return "block";
    case RULE_ACTION_TYPE_REDIRECT:
      return "redirect";
    case RULE_ACTION_TYPE_ALLOW:
      return "allow";
    case RULE_ACTION_TYPE_UPGRADESCHEME:
      return "upgradeScheme";
    case RULE_ACTION_TYPE_MODIFYHEADERS:
      return "modifyHeaders";
    case RULE_ACTION_TYPE_ALLOWALLREQUESTS:
      return "allowAllRequests";
    case RULE_ACTION_TYPE_NONE:
      return "";
  }
  NOTREACHED();
  return "";
}

RuleActionType ParseRuleActionType(const std::string& enum_string) {
  if (enum_string == "block")
    return RULE_ACTION_TYPE_BLOCK;
  if (enum_string == "redirect")
    return RULE_ACTION_TYPE_REDIRECT;
  if (enum_string == "allow")
    return RULE_ACTION_TYPE_ALLOW;
  if (enum_string == "upgradeScheme")
    return RULE_ACTION_TYPE_UPGRADESCHEME;
  if (enum_string == "modifyHeaders")
    return RULE_ACTION_TYPE_MODIFYHEADERS;
  if (enum_string == "allowAllRequests")
    return RULE_ACTION_TYPE_ALLOWALLREQUESTS;
  return RULE_ACTION_TYPE_NONE;
}


const char* ToString(UnsupportedRegexReason enum_param) {
  switch (enum_param) {
    case UNSUPPORTED_REGEX_REASON_SYNTAXERROR:
      return "syntaxError";
    case UNSUPPORTED_REGEX_REASON_MEMORYLIMITEXCEEDED:
      return "memoryLimitExceeded";
    case UNSUPPORTED_REGEX_REASON_NONE:
      return "";
  }
  NOTREACHED();
  return "";
}

UnsupportedRegexReason ParseUnsupportedRegexReason(const std::string& enum_string) {
  if (enum_string == "syntaxError")
    return UNSUPPORTED_REGEX_REASON_SYNTAXERROR;
  if (enum_string == "memoryLimitExceeded")
    return UNSUPPORTED_REGEX_REASON_MEMORYLIMITEXCEEDED;
  return UNSUPPORTED_REGEX_REASON_NONE;
}


Ruleset::Ruleset()
: enabled(false) {}

Ruleset::~Ruleset() = default;
Ruleset::Ruleset(Ruleset&& rhs) = default;
Ruleset& Ruleset::operator=(Ruleset&& rhs) = default;
// static
bool Ruleset::Populate(
    const base::Value& value, Ruleset* out, base::string16* error) {
  DCHECK(error);
  if (!value.is_dict()) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("expected dictionary, got " + std::string(base::Value::GetTypeName(value.type())));
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* id_value = nullptr;
  if (!dict->GetWithoutPathExpansion("id", &id_value)) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("'id' is required");
    return false;
  }
  {
    if (!id_value->GetAsString(&out->id)) {
      DCHECK(error->empty());
      *error = UTF8ToUTF16("'id': expected id, got " + std::string(base::Value::GetTypeName(id_value->type())));
      return false;
    }
  }

  const base::Value* path_value = nullptr;
  if (!dict->GetWithoutPathExpansion("path", &path_value)) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("'path' is required");
    return false;
  }
  {
    if (!path_value->GetAsString(&out->path)) {
      DCHECK(error->empty());
      *error = UTF8ToUTF16("'path': expected path, got " + std::string(base::Value::GetTypeName(path_value->type())));
      return false;
    }
  }

  const base::Value* enabled_value = nullptr;
  if (!dict->GetWithoutPathExpansion("enabled", &enabled_value)) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("'enabled' is required");
    return false;
  }
  {
    if (!enabled_value->GetAsBoolean(&out->enabled)) {
      DCHECK(error->empty());
      *error = UTF8ToUTF16("'enabled': expected enabled, got " + std::string(base::Value::GetTypeName(enabled_value->type())));
      return false;
    }
  }

  return true;
}

// static
std::unique_ptr<Ruleset> Ruleset::FromValue(const base::Value& value, base::string16* error) {
  DCHECK(error);
  auto out = std::make_unique<Ruleset>();
  bool result = Populate(value, out.get(), error);
  DCHECK_EQ(result, error->empty());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> Ruleset::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("id", std::make_unique<base::Value>(this->id));

  to_value_result->SetWithoutPathExpansion("path", std::make_unique<base::Value>(this->path));

  to_value_result->SetWithoutPathExpansion("enabled", std::make_unique<base::Value>(this->enabled));


  return to_value_result;
}


QueryKeyValue::QueryKeyValue()
 {}

QueryKeyValue::~QueryKeyValue() = default;
QueryKeyValue::QueryKeyValue(QueryKeyValue&& rhs) = default;
QueryKeyValue& QueryKeyValue::operator=(QueryKeyValue&& rhs) = default;
// static
bool QueryKeyValue::Populate(
    const base::Value& value, QueryKeyValue* out, base::string16* error) {
  DCHECK(error);
  if (!value.is_dict()) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("expected dictionary, got " + std::string(base::Value::GetTypeName(value.type())));
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* key_value = nullptr;
  if (!dict->GetWithoutPathExpansion("key", &key_value)) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("'key' is required");
    return false;
  }
  {
    if (!key_value->GetAsString(&out->key)) {
      DCHECK(error->empty());
      *error = UTF8ToUTF16("'key': expected key, got " + std::string(base::Value::GetTypeName(key_value->type())));
      return false;
    }
  }

  const base::Value* value_value = nullptr;
  if (!dict->GetWithoutPathExpansion("value", &value_value)) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("'value' is required");
    return false;
  }
  {
    if (!value_value->GetAsString(&out->value)) {
      DCHECK(error->empty());
      *error = UTF8ToUTF16("'value': expected value, got " + std::string(base::Value::GetTypeName(value_value->type())));
      return false;
    }
  }

  return true;
}

// static
std::unique_ptr<QueryKeyValue> QueryKeyValue::FromValue(const base::Value& value, base::string16* error) {
  DCHECK(error);
  auto out = std::make_unique<QueryKeyValue>();
  bool result = Populate(value, out.get(), error);
  DCHECK_EQ(result, error->empty());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> QueryKeyValue::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("key", std::make_unique<base::Value>(this->key));

  to_value_result->SetWithoutPathExpansion("value", std::make_unique<base::Value>(this->value));


  return to_value_result;
}


QueryTransform::QueryTransform()
 {}

QueryTransform::~QueryTransform() = default;
QueryTransform::QueryTransform(QueryTransform&& rhs) = default;
QueryTransform& QueryTransform::operator=(QueryTransform&& rhs) = default;
// static
bool QueryTransform::Populate(
    const base::Value& value, QueryTransform* out, base::string16* error) {
  DCHECK(error);
  if (!value.is_dict()) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("expected dictionary, got " + std::string(base::Value::GetTypeName(value.type())));
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* remove_params_value = nullptr;
  if (dict->GetWithoutPathExpansion("removeParams", &remove_params_value)) {
    {
      const base::ListValue* list = nullptr;
      if (!remove_params_value->GetAsList(&list)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'removeParams': expected list, got " + std::string(base::Value::GetTypeName(remove_params_value->type())));
        return false;
      }
      else {
        base::string16 array_parse_error;
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->remove_params, &array_parse_error)) {
          array_parse_error = base::UTF8ToUTF16("Error at key 'removeParams': ") + array_parse_error;
          DCHECK(error->empty());
          *error = array_parse_error;
          return false;
        }
      }
    }
  }

  const base::Value* add_or_replace_params_value = nullptr;
  if (dict->GetWithoutPathExpansion("addOrReplaceParams", &add_or_replace_params_value)) {
    {
      const base::ListValue* list = nullptr;
      if (!add_or_replace_params_value->GetAsList(&list)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'addOrReplaceParams': expected list, got " + std::string(base::Value::GetTypeName(add_or_replace_params_value->type())));
        return false;
      }
      else {
        base::string16 array_parse_error;
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->add_or_replace_params, &array_parse_error)) {
          array_parse_error = base::UTF8ToUTF16("Error at key 'addOrReplaceParams': ") + array_parse_error;
          DCHECK(error->empty());
          *error = array_parse_error;
          return false;
        }
      }
    }
  }

  return true;
}

// static
std::unique_ptr<QueryTransform> QueryTransform::FromValue(const base::Value& value, base::string16* error) {
  DCHECK(error);
  auto out = std::make_unique<QueryTransform>();
  bool result = Populate(value, out.get(), error);
  DCHECK_EQ(result, error->empty());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> QueryTransform::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->remove_params.get()) {
    to_value_result->SetWithoutPathExpansion("removeParams", json_schema_compiler::util::CreateValueFromOptionalArray(this->remove_params));

  }
  if (this->add_or_replace_params.get()) {
    to_value_result->SetWithoutPathExpansion("addOrReplaceParams", json_schema_compiler::util::CreateValueFromOptionalArray(this->add_or_replace_params));

  }

  return to_value_result;
}


URLTransform::URLTransform()
 {}

URLTransform::~URLTransform() = default;
URLTransform::URLTransform(URLTransform&& rhs) = default;
URLTransform& URLTransform::operator=(URLTransform&& rhs) = default;
// static
bool URLTransform::Populate(
    const base::Value& value, URLTransform* out, base::string16* error) {
  DCHECK(error);
  if (!value.is_dict()) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("expected dictionary, got " + std::string(base::Value::GetTypeName(value.type())));
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* scheme_value = nullptr;
  if (dict->GetWithoutPathExpansion("scheme", &scheme_value)) {
    {
      std::string temp;
      if (!scheme_value->GetAsString(&temp)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'scheme': expected scheme, got " + std::string(base::Value::GetTypeName(scheme_value->type())));
        out->scheme.reset();
        return false;
      }
      else
        out->scheme = std::make_unique<std::string>(temp);
    }
  }

  const base::Value* host_value = nullptr;
  if (dict->GetWithoutPathExpansion("host", &host_value)) {
    {
      std::string temp;
      if (!host_value->GetAsString(&temp)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'host': expected host, got " + std::string(base::Value::GetTypeName(host_value->type())));
        out->host.reset();
        return false;
      }
      else
        out->host = std::make_unique<std::string>(temp);
    }
  }

  const base::Value* port_value = nullptr;
  if (dict->GetWithoutPathExpansion("port", &port_value)) {
    {
      std::string temp;
      if (!port_value->GetAsString(&temp)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'port': expected port, got " + std::string(base::Value::GetTypeName(port_value->type())));
        out->port.reset();
        return false;
      }
      else
        out->port = std::make_unique<std::string>(temp);
    }
  }

  const base::Value* path_value = nullptr;
  if (dict->GetWithoutPathExpansion("path", &path_value)) {
    {
      std::string temp;
      if (!path_value->GetAsString(&temp)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'path': expected path, got " + std::string(base::Value::GetTypeName(path_value->type())));
        out->path.reset();
        return false;
      }
      else
        out->path = std::make_unique<std::string>(temp);
    }
  }

  const base::Value* query_value = nullptr;
  if (dict->GetWithoutPathExpansion("query", &query_value)) {
    {
      std::string temp;
      if (!query_value->GetAsString(&temp)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'query': expected query, got " + std::string(base::Value::GetTypeName(query_value->type())));
        out->query.reset();
        return false;
      }
      else
        out->query = std::make_unique<std::string>(temp);
    }
  }

  const base::Value* query_transform_value = nullptr;
  if (dict->GetWithoutPathExpansion("queryTransform", &query_transform_value)) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!query_transform_value->GetAsDictionary(&dictionary)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'queryTransform': expected dictionary, got " + std::string(base::Value::GetTypeName(query_transform_value->type())));
        return false;
      }
      else {
        auto temp = std::make_unique<QueryTransform>();
        if (!QueryTransform::Populate(*dictionary, temp.get(), error)) {
          return false;
        }
        else
          out->query_transform = std::move(temp);
      }
    }
  }

  const base::Value* fragment_value = nullptr;
  if (dict->GetWithoutPathExpansion("fragment", &fragment_value)) {
    {
      std::string temp;
      if (!fragment_value->GetAsString(&temp)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'fragment': expected fragment, got " + std::string(base::Value::GetTypeName(fragment_value->type())));
        out->fragment.reset();
        return false;
      }
      else
        out->fragment = std::make_unique<std::string>(temp);
    }
  }

  const base::Value* username_value = nullptr;
  if (dict->GetWithoutPathExpansion("username", &username_value)) {
    {
      std::string temp;
      if (!username_value->GetAsString(&temp)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'username': expected username, got " + std::string(base::Value::GetTypeName(username_value->type())));
        out->username.reset();
        return false;
      }
      else
        out->username = std::make_unique<std::string>(temp);
    }
  }

  const base::Value* password_value = nullptr;
  if (dict->GetWithoutPathExpansion("password", &password_value)) {
    {
      std::string temp;
      if (!password_value->GetAsString(&temp)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'password': expected password, got " + std::string(base::Value::GetTypeName(password_value->type())));
        out->password.reset();
        return false;
      }
      else
        out->password = std::make_unique<std::string>(temp);
    }
  }

  return true;
}

// static
std::unique_ptr<URLTransform> URLTransform::FromValue(const base::Value& value, base::string16* error) {
  DCHECK(error);
  auto out = std::make_unique<URLTransform>();
  bool result = Populate(value, out.get(), error);
  DCHECK_EQ(result, error->empty());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> URLTransform::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->scheme.get()) {
    to_value_result->SetWithoutPathExpansion("scheme", std::make_unique<base::Value>(*this->scheme));

  }
  if (this->host.get()) {
    to_value_result->SetWithoutPathExpansion("host", std::make_unique<base::Value>(*this->host));

  }
  if (this->port.get()) {
    to_value_result->SetWithoutPathExpansion("port", std::make_unique<base::Value>(*this->port));

  }
  if (this->path.get()) {
    to_value_result->SetWithoutPathExpansion("path", std::make_unique<base::Value>(*this->path));

  }
  if (this->query.get()) {
    to_value_result->SetWithoutPathExpansion("query", std::make_unique<base::Value>(*this->query));

  }
  if (this->query_transform.get()) {
    to_value_result->SetWithoutPathExpansion("queryTransform", (this->query_transform)->ToValue());

  }
  if (this->fragment.get()) {
    to_value_result->SetWithoutPathExpansion("fragment", std::make_unique<base::Value>(*this->fragment));

  }
  if (this->username.get()) {
    to_value_result->SetWithoutPathExpansion("username", std::make_unique<base::Value>(*this->username));

  }
  if (this->password.get()) {
    to_value_result->SetWithoutPathExpansion("password", std::make_unique<base::Value>(*this->password));

  }

  return to_value_result;
}


Redirect::Redirect()
 {}

Redirect::~Redirect() = default;
Redirect::Redirect(Redirect&& rhs) = default;
Redirect& Redirect::operator=(Redirect&& rhs) = default;
// static
bool Redirect::Populate(
    const base::Value& value, Redirect* out, base::string16* error) {
  DCHECK(error);
  if (!value.is_dict()) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("expected dictionary, got " + std::string(base::Value::GetTypeName(value.type())));
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* extension_path_value = nullptr;
  if (dict->GetWithoutPathExpansion("extensionPath", &extension_path_value)) {
    {
      std::string temp;
      if (!extension_path_value->GetAsString(&temp)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'extensionPath': expected extensionPath, got " + std::string(base::Value::GetTypeName(extension_path_value->type())));
        out->extension_path.reset();
        return false;
      }
      else
        out->extension_path = std::make_unique<std::string>(temp);
    }
  }

  const base::Value* transform_value = nullptr;
  if (dict->GetWithoutPathExpansion("transform", &transform_value)) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!transform_value->GetAsDictionary(&dictionary)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'transform': expected dictionary, got " + std::string(base::Value::GetTypeName(transform_value->type())));
        return false;
      }
      else {
        auto temp = std::make_unique<URLTransform>();
        if (!URLTransform::Populate(*dictionary, temp.get(), error)) {
          return false;
        }
        else
          out->transform = std::move(temp);
      }
    }
  }

  const base::Value* url_value = nullptr;
  if (dict->GetWithoutPathExpansion("url", &url_value)) {
    {
      std::string temp;
      if (!url_value->GetAsString(&temp)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'url': expected url, got " + std::string(base::Value::GetTypeName(url_value->type())));
        out->url.reset();
        return false;
      }
      else
        out->url = std::make_unique<std::string>(temp);
    }
  }

  const base::Value* regex_substitution_value = nullptr;
  if (dict->GetWithoutPathExpansion("regexSubstitution", &regex_substitution_value)) {
    {
      std::string temp;
      if (!regex_substitution_value->GetAsString(&temp)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'regexSubstitution': expected regexSubstitution, got " + std::string(base::Value::GetTypeName(regex_substitution_value->type())));
        out->regex_substitution.reset();
        return false;
      }
      else
        out->regex_substitution = std::make_unique<std::string>(temp);
    }
  }

  return true;
}

// static
std::unique_ptr<Redirect> Redirect::FromValue(const base::Value& value, base::string16* error) {
  DCHECK(error);
  auto out = std::make_unique<Redirect>();
  bool result = Populate(value, out.get(), error);
  DCHECK_EQ(result, error->empty());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> Redirect::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->extension_path.get()) {
    to_value_result->SetWithoutPathExpansion("extensionPath", std::make_unique<base::Value>(*this->extension_path));

  }
  if (this->transform.get()) {
    to_value_result->SetWithoutPathExpansion("transform", (this->transform)->ToValue());

  }
  if (this->url.get()) {
    to_value_result->SetWithoutPathExpansion("url", std::make_unique<base::Value>(*this->url));

  }
  if (this->regex_substitution.get()) {
    to_value_result->SetWithoutPathExpansion("regexSubstitution", std::make_unique<base::Value>(*this->regex_substitution));

  }

  return to_value_result;
}


RuleCondition::RuleCondition()
: domain_type(DOMAIN_TYPE_NONE) {}

RuleCondition::~RuleCondition() = default;
RuleCondition::RuleCondition(RuleCondition&& rhs) = default;
RuleCondition& RuleCondition::operator=(RuleCondition&& rhs) = default;
// static
bool RuleCondition::Populate(
    const base::Value& value, RuleCondition* out, base::string16* error) {
  DCHECK(error);
  if (!value.is_dict()) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("expected dictionary, got " + std::string(base::Value::GetTypeName(value.type())));
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  out->domain_type = DOMAIN_TYPE_NONE;
  const base::Value* url_filter_value = nullptr;
  if (dict->GetWithoutPathExpansion("urlFilter", &url_filter_value)) {
    {
      std::string temp;
      if (!url_filter_value->GetAsString(&temp)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'urlFilter': expected urlFilter, got " + std::string(base::Value::GetTypeName(url_filter_value->type())));
        out->url_filter.reset();
        return false;
      }
      else
        out->url_filter = std::make_unique<std::string>(temp);
    }
  }

  const base::Value* regex_filter_value = nullptr;
  if (dict->GetWithoutPathExpansion("regexFilter", &regex_filter_value)) {
    {
      std::string temp;
      if (!regex_filter_value->GetAsString(&temp)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'regexFilter': expected regexFilter, got " + std::string(base::Value::GetTypeName(regex_filter_value->type())));
        out->regex_filter.reset();
        return false;
      }
      else
        out->regex_filter = std::make_unique<std::string>(temp);
    }
  }

  const base::Value* is_url_filter_case_sensitive_value = nullptr;
  if (dict->GetWithoutPathExpansion("isUrlFilterCaseSensitive", &is_url_filter_case_sensitive_value)) {
    {
      bool temp;
      if (!is_url_filter_case_sensitive_value->GetAsBoolean(&temp)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'isUrlFilterCaseSensitive': expected isUrlFilterCaseSensitive, got " + std::string(base::Value::GetTypeName(is_url_filter_case_sensitive_value->type())));
        out->is_url_filter_case_sensitive.reset();
        return false;
      }
      else
        out->is_url_filter_case_sensitive = std::make_unique<bool>(temp);
    }
  }

  const base::Value* domains_value = nullptr;
  if (dict->GetWithoutPathExpansion("domains", &domains_value)) {
    {
      const base::ListValue* list = nullptr;
      if (!domains_value->GetAsList(&list)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'domains': expected list, got " + std::string(base::Value::GetTypeName(domains_value->type())));
        return false;
      }
      else {
        base::string16 array_parse_error;
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->domains, &array_parse_error)) {
          array_parse_error = base::UTF8ToUTF16("Error at key 'domains': ") + array_parse_error;
          DCHECK(error->empty());
          *error = array_parse_error;
          return false;
        }
      }
    }
  }

  const base::Value* excluded_domains_value = nullptr;
  if (dict->GetWithoutPathExpansion("excludedDomains", &excluded_domains_value)) {
    {
      const base::ListValue* list = nullptr;
      if (!excluded_domains_value->GetAsList(&list)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'excludedDomains': expected list, got " + std::string(base::Value::GetTypeName(excluded_domains_value->type())));
        return false;
      }
      else {
        base::string16 array_parse_error;
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->excluded_domains, &array_parse_error)) {
          array_parse_error = base::UTF8ToUTF16("Error at key 'excludedDomains': ") + array_parse_error;
          DCHECK(error->empty());
          *error = array_parse_error;
          return false;
        }
      }
    }
  }

  const base::Value* resource_types_value = nullptr;
  if (dict->GetWithoutPathExpansion("resourceTypes", &resource_types_value)) {
    {
      const base::ListValue* list = nullptr;
      if (!resource_types_value->GetAsList(&list)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'resourceTypes': expected list, got " + std::string(base::Value::GetTypeName(resource_types_value->type())));
        return false;
      }
      else {
        out->resource_types = std::make_unique<std::vector<ResourceType>>();
        for (const auto& it : *(list)) {
          ResourceType tmp;
          std::string resource_type_as_string;
          if (!(it).GetAsString(&resource_type_as_string)) {
            DCHECK(error->empty());
            *error = UTF8ToUTF16("'ResourceType': expected string, got " + std::string(base::Value::GetTypeName((it).type())));
            return false;
          }
          tmp = ParseResourceType(resource_type_as_string);
          if (tmp == RESOURCE_TYPE_NONE) {
            DCHECK(error->empty());
            *error = UTF8ToUTF16("'ResourceType': expected \"main_frame\" or \"sub_frame\" or \"stylesheet\" or \"script\" or \"image\" or \"font\" or \"object\" or \"xmlhttprequest\" or \"ping\" or \"csp_report\" or \"media\" or \"websocket\" or \"other\", got \"" + resource_type_as_string + "\"");
            return false;
          }
          out->resource_types->push_back(tmp);
        }
      }
    }
  }

  const base::Value* excluded_resource_types_value = nullptr;
  if (dict->GetWithoutPathExpansion("excludedResourceTypes", &excluded_resource_types_value)) {
    {
      const base::ListValue* list = nullptr;
      if (!excluded_resource_types_value->GetAsList(&list)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'excludedResourceTypes': expected list, got " + std::string(base::Value::GetTypeName(excluded_resource_types_value->type())));
        return false;
      }
      else {
        out->excluded_resource_types = std::make_unique<std::vector<ResourceType>>();
        for (const auto& it : *(list)) {
          ResourceType tmp;
          std::string resource_type_as_string;
          if (!(it).GetAsString(&resource_type_as_string)) {
            DCHECK(error->empty());
            *error = UTF8ToUTF16("'ResourceType': expected string, got " + std::string(base::Value::GetTypeName((it).type())));
            return false;
          }
          tmp = ParseResourceType(resource_type_as_string);
          if (tmp == RESOURCE_TYPE_NONE) {
            DCHECK(error->empty());
            *error = UTF8ToUTF16("'ResourceType': expected \"main_frame\" or \"sub_frame\" or \"stylesheet\" or \"script\" or \"image\" or \"font\" or \"object\" or \"xmlhttprequest\" or \"ping\" or \"csp_report\" or \"media\" or \"websocket\" or \"other\", got \"" + resource_type_as_string + "\"");
            return false;
          }
          out->excluded_resource_types->push_back(tmp);
        }
      }
    }
  }

  const base::Value* domain_type_value = nullptr;
  if (dict->GetWithoutPathExpansion("domainType", &domain_type_value)) {
    {
      std::string domain_type_as_string;
      if (!domain_type_value->GetAsString(&domain_type_as_string)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'DomainType': expected string, got " + std::string(base::Value::GetTypeName(domain_type_value->type())));
        return false;
      }
      out->domain_type = ParseDomainType(domain_type_as_string);
      if (out->domain_type == DOMAIN_TYPE_NONE) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'DomainType': expected \"firstParty\" or \"thirdParty\", got \"" + domain_type_as_string + "\"");
        return false;
      }
    }
    } else {
    out->domain_type = DOMAIN_TYPE_NONE;
  }

  return true;
}

// static
std::unique_ptr<RuleCondition> RuleCondition::FromValue(const base::Value& value, base::string16* error) {
  DCHECK(error);
  auto out = std::make_unique<RuleCondition>();
  bool result = Populate(value, out.get(), error);
  DCHECK_EQ(result, error->empty());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> RuleCondition::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->url_filter.get()) {
    to_value_result->SetWithoutPathExpansion("urlFilter", std::make_unique<base::Value>(*this->url_filter));

  }
  if (this->regex_filter.get()) {
    to_value_result->SetWithoutPathExpansion("regexFilter", std::make_unique<base::Value>(*this->regex_filter));

  }
  if (this->is_url_filter_case_sensitive.get()) {
    to_value_result->SetWithoutPathExpansion("isUrlFilterCaseSensitive", std::make_unique<base::Value>(*this->is_url_filter_case_sensitive));

  }
  if (this->domains.get()) {
    to_value_result->SetWithoutPathExpansion("domains", json_schema_compiler::util::CreateValueFromOptionalArray(this->domains));

  }
  if (this->excluded_domains.get()) {
    to_value_result->SetWithoutPathExpansion("excludedDomains", json_schema_compiler::util::CreateValueFromOptionalArray(this->excluded_domains));

  }
  if (this->resource_types.get()) {
    {
      std::vector<std::string> resourceTypes_list;
      for (const auto& it : *(this->resource_types)) {
      resourceTypes_list.push_back(declarative_net_request::ToString(it));
    }
    to_value_result->SetWithoutPathExpansion("resourceTypes", json_schema_compiler::util::CreateValueFromArray(resourceTypes_list));
    }

  }
  if (this->excluded_resource_types.get()) {
    {
      std::vector<std::string> excludedResourceTypes_list;
      for (const auto& it : *(this->excluded_resource_types)) {
      excludedResourceTypes_list.push_back(declarative_net_request::ToString(it));
    }
    to_value_result->SetWithoutPathExpansion("excludedResourceTypes", json_schema_compiler::util::CreateValueFromArray(excludedResourceTypes_list));
    }

  }
  if (this->domain_type != DOMAIN_TYPE_NONE) {
    to_value_result->SetWithoutPathExpansion("domainType", std::make_unique<base::Value>(declarative_net_request::ToString(this->domain_type)));

  }

  return to_value_result;
}


ModifyHeaderInfo::ModifyHeaderInfo()
: operation(HEADER_OPERATION_NONE) {}

ModifyHeaderInfo::~ModifyHeaderInfo() = default;
ModifyHeaderInfo::ModifyHeaderInfo(ModifyHeaderInfo&& rhs) = default;
ModifyHeaderInfo& ModifyHeaderInfo::operator=(ModifyHeaderInfo&& rhs) = default;
// static
bool ModifyHeaderInfo::Populate(
    const base::Value& value, ModifyHeaderInfo* out, base::string16* error) {
  DCHECK(error);
  if (!value.is_dict()) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("expected dictionary, got " + std::string(base::Value::GetTypeName(value.type())));
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* header_value = nullptr;
  if (!dict->GetWithoutPathExpansion("header", &header_value)) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("'header' is required");
    return false;
  }
  {
    if (!header_value->GetAsString(&out->header)) {
      DCHECK(error->empty());
      *error = UTF8ToUTF16("'header': expected header, got " + std::string(base::Value::GetTypeName(header_value->type())));
      return false;
    }
  }

  const base::Value* operation_value = nullptr;
  if (!dict->GetWithoutPathExpansion("operation", &operation_value)) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("'operation' is required");
    return false;
  }
  {
    std::string header_operation_as_string;
    if (!operation_value->GetAsString(&header_operation_as_string)) {
      DCHECK(error->empty());
      *error = UTF8ToUTF16("'HeaderOperation': expected string, got " + std::string(base::Value::GetTypeName(operation_value->type())));
      return false;
    }
    out->operation = ParseHeaderOperation(header_operation_as_string);
    if (out->operation == HEADER_OPERATION_NONE) {
      DCHECK(error->empty());
      *error = UTF8ToUTF16("'HeaderOperation': expected \"append\" or \"set\" or \"remove\", got \"" + header_operation_as_string + "\"");
      return false;
    }
  }

  const base::Value* value_value = nullptr;
  if (dict->GetWithoutPathExpansion("value", &value_value)) {
    {
      std::string temp;
      if (!value_value->GetAsString(&temp)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'value': expected value, got " + std::string(base::Value::GetTypeName(value_value->type())));
        out->value.reset();
        return false;
      }
      else
        out->value = std::make_unique<std::string>(temp);
    }
  }

  return true;
}

// static
std::unique_ptr<ModifyHeaderInfo> ModifyHeaderInfo::FromValue(const base::Value& value, base::string16* error) {
  DCHECK(error);
  auto out = std::make_unique<ModifyHeaderInfo>();
  bool result = Populate(value, out.get(), error);
  DCHECK_EQ(result, error->empty());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> ModifyHeaderInfo::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("header", std::make_unique<base::Value>(this->header));

  to_value_result->SetWithoutPathExpansion("operation", std::make_unique<base::Value>(declarative_net_request::ToString(this->operation)));

  if (this->value.get()) {
    to_value_result->SetWithoutPathExpansion("value", std::make_unique<base::Value>(*this->value));

  }

  return to_value_result;
}


RuleAction::RuleAction()
: type(RULE_ACTION_TYPE_NONE) {}

RuleAction::~RuleAction() = default;
RuleAction::RuleAction(RuleAction&& rhs) = default;
RuleAction& RuleAction::operator=(RuleAction&& rhs) = default;
// static
bool RuleAction::Populate(
    const base::Value& value, RuleAction* out, base::string16* error) {
  DCHECK(error);
  if (!value.is_dict()) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("expected dictionary, got " + std::string(base::Value::GetTypeName(value.type())));
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* type_value = nullptr;
  if (!dict->GetWithoutPathExpansion("type", &type_value)) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("'type' is required");
    return false;
  }
  {
    std::string rule_action_type_as_string;
    if (!type_value->GetAsString(&rule_action_type_as_string)) {
      DCHECK(error->empty());
      *error = UTF8ToUTF16("'RuleActionType': expected string, got " + std::string(base::Value::GetTypeName(type_value->type())));
      return false;
    }
    out->type = ParseRuleActionType(rule_action_type_as_string);
    if (out->type == RULE_ACTION_TYPE_NONE) {
      DCHECK(error->empty());
      *error = UTF8ToUTF16("'RuleActionType': expected \"block\" or \"redirect\" or \"allow\" or \"upgradeScheme\" or \"modifyHeaders\" or \"allowAllRequests\", got \"" + rule_action_type_as_string + "\"");
      return false;
    }
  }

  const base::Value* redirect_value = nullptr;
  if (dict->GetWithoutPathExpansion("redirect", &redirect_value)) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!redirect_value->GetAsDictionary(&dictionary)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'redirect': expected dictionary, got " + std::string(base::Value::GetTypeName(redirect_value->type())));
        return false;
      }
      else {
        auto temp = std::make_unique<Redirect>();
        if (!Redirect::Populate(*dictionary, temp.get(), error)) {
          return false;
        }
        else
          out->redirect = std::move(temp);
      }
    }
  }

  const base::Value* request_headers_value = nullptr;
  if (dict->GetWithoutPathExpansion("requestHeaders", &request_headers_value)) {
    {
      const base::ListValue* list = nullptr;
      if (!request_headers_value->GetAsList(&list)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'requestHeaders': expected list, got " + std::string(base::Value::GetTypeName(request_headers_value->type())));
        return false;
      }
      else {
        base::string16 array_parse_error;
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->request_headers, &array_parse_error)) {
          array_parse_error = base::UTF8ToUTF16("Error at key 'requestHeaders': ") + array_parse_error;
          DCHECK(error->empty());
          *error = array_parse_error;
          return false;
        }
      }
    }
  }

  const base::Value* response_headers_value = nullptr;
  if (dict->GetWithoutPathExpansion("responseHeaders", &response_headers_value)) {
    {
      const base::ListValue* list = nullptr;
      if (!response_headers_value->GetAsList(&list)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'responseHeaders': expected list, got " + std::string(base::Value::GetTypeName(response_headers_value->type())));
        return false;
      }
      else {
        base::string16 array_parse_error;
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->response_headers, &array_parse_error)) {
          array_parse_error = base::UTF8ToUTF16("Error at key 'responseHeaders': ") + array_parse_error;
          DCHECK(error->empty());
          *error = array_parse_error;
          return false;
        }
      }
    }
  }

  return true;
}

// static
std::unique_ptr<RuleAction> RuleAction::FromValue(const base::Value& value, base::string16* error) {
  DCHECK(error);
  auto out = std::make_unique<RuleAction>();
  bool result = Populate(value, out.get(), error);
  DCHECK_EQ(result, error->empty());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> RuleAction::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("type", std::make_unique<base::Value>(declarative_net_request::ToString(this->type)));

  if (this->redirect.get()) {
    to_value_result->SetWithoutPathExpansion("redirect", (this->redirect)->ToValue());

  }
  if (this->request_headers.get()) {
    to_value_result->SetWithoutPathExpansion("requestHeaders", json_schema_compiler::util::CreateValueFromOptionalArray(this->request_headers));

  }
  if (this->response_headers.get()) {
    to_value_result->SetWithoutPathExpansion("responseHeaders", json_schema_compiler::util::CreateValueFromOptionalArray(this->response_headers));

  }

  return to_value_result;
}


Rule::Rule()
: id(0) {}

Rule::~Rule() = default;
Rule::Rule(Rule&& rhs) = default;
Rule& Rule::operator=(Rule&& rhs) = default;
// static
bool Rule::Populate(
    const base::Value& value, Rule* out, base::string16* error) {
  DCHECK(error);
  if (!value.is_dict()) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("expected dictionary, got " + std::string(base::Value::GetTypeName(value.type())));
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* id_value = nullptr;
  if (!dict->GetWithoutPathExpansion("id", &id_value)) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("'id' is required");
    return false;
  }
  {
    if (!id_value->GetAsInteger(&out->id)) {
      DCHECK(error->empty());
      *error = UTF8ToUTF16("'id': expected id, got " + std::string(base::Value::GetTypeName(id_value->type())));
      return false;
    }
  }

  const base::Value* priority_value = nullptr;
  if (dict->GetWithoutPathExpansion("priority", &priority_value)) {
    {
      int temp;
      if (!priority_value->GetAsInteger(&temp)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'priority': expected priority, got " + std::string(base::Value::GetTypeName(priority_value->type())));
        out->priority.reset();
        return false;
      }
      else
        out->priority = std::make_unique<int>(temp);
    }
  }

  const base::Value* condition_value = nullptr;
  if (!dict->GetWithoutPathExpansion("condition", &condition_value)) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("'condition' is required");
    return false;
  }
  {
    const base::DictionaryValue* dictionary = nullptr;
    if (!condition_value->GetAsDictionary(&dictionary)) {
      DCHECK(error->empty());
      *error = UTF8ToUTF16("'condition': expected dictionary, got " + std::string(base::Value::GetTypeName(condition_value->type())));
      return false;
    }
    if (!RuleCondition::Populate(*dictionary, &out->condition, error)) {
      return false;
    }
  }

  const base::Value* action_value = nullptr;
  if (!dict->GetWithoutPathExpansion("action", &action_value)) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("'action' is required");
    return false;
  }
  {
    const base::DictionaryValue* dictionary = nullptr;
    if (!action_value->GetAsDictionary(&dictionary)) {
      DCHECK(error->empty());
      *error = UTF8ToUTF16("'action': expected dictionary, got " + std::string(base::Value::GetTypeName(action_value->type())));
      return false;
    }
    if (!RuleAction::Populate(*dictionary, &out->action, error)) {
      return false;
    }
  }

  return true;
}

// static
std::unique_ptr<Rule> Rule::FromValue(const base::Value& value, base::string16* error) {
  DCHECK(error);
  auto out = std::make_unique<Rule>();
  bool result = Populate(value, out.get(), error);
  DCHECK_EQ(result, error->empty());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> Rule::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("id", std::make_unique<base::Value>(this->id));

  if (this->priority.get()) {
    to_value_result->SetWithoutPathExpansion("priority", std::make_unique<base::Value>(*this->priority));

  }
  to_value_result->SetWithoutPathExpansion("condition", (this->condition).ToValue());

  to_value_result->SetWithoutPathExpansion("action", (this->action).ToValue());


  return to_value_result;
}


MatchedRule::MatchedRule()
: rule_id(0) {}

MatchedRule::~MatchedRule() = default;
MatchedRule::MatchedRule(MatchedRule&& rhs) = default;
MatchedRule& MatchedRule::operator=(MatchedRule&& rhs) = default;
// static
bool MatchedRule::Populate(
    const base::Value& value, MatchedRule* out, base::string16* error) {
  DCHECK(error);
  if (!value.is_dict()) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("expected dictionary, got " + std::string(base::Value::GetTypeName(value.type())));
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* rule_id_value = nullptr;
  if (!dict->GetWithoutPathExpansion("ruleId", &rule_id_value)) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("'ruleId' is required");
    return false;
  }
  {
    if (!rule_id_value->GetAsInteger(&out->rule_id)) {
      DCHECK(error->empty());
      *error = UTF8ToUTF16("'ruleId': expected ruleId, got " + std::string(base::Value::GetTypeName(rule_id_value->type())));
      return false;
    }
  }

  const base::Value* ruleset_id_value = nullptr;
  if (!dict->GetWithoutPathExpansion("rulesetId", &ruleset_id_value)) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("'rulesetId' is required");
    return false;
  }
  {
    if (!ruleset_id_value->GetAsString(&out->ruleset_id)) {
      DCHECK(error->empty());
      *error = UTF8ToUTF16("'rulesetId': expected rulesetId, got " + std::string(base::Value::GetTypeName(ruleset_id_value->type())));
      return false;
    }
  }

  return true;
}

// static
std::unique_ptr<MatchedRule> MatchedRule::FromValue(const base::Value& value, base::string16* error) {
  DCHECK(error);
  auto out = std::make_unique<MatchedRule>();
  bool result = Populate(value, out.get(), error);
  DCHECK_EQ(result, error->empty());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> MatchedRule::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("ruleId", std::make_unique<base::Value>(this->rule_id));

  to_value_result->SetWithoutPathExpansion("rulesetId", std::make_unique<base::Value>(this->ruleset_id));


  return to_value_result;
}


MatchedRuleInfo::MatchedRuleInfo()
: time_stamp(0.0),
tab_id(0) {}

MatchedRuleInfo::~MatchedRuleInfo() = default;
MatchedRuleInfo::MatchedRuleInfo(MatchedRuleInfo&& rhs) = default;
MatchedRuleInfo& MatchedRuleInfo::operator=(MatchedRuleInfo&& rhs) = default;
// static
bool MatchedRuleInfo::Populate(
    const base::Value& value, MatchedRuleInfo* out, base::string16* error) {
  DCHECK(error);
  if (!value.is_dict()) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("expected dictionary, got " + std::string(base::Value::GetTypeName(value.type())));
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* rule_value = nullptr;
  if (!dict->GetWithoutPathExpansion("rule", &rule_value)) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("'rule' is required");
    return false;
  }
  {
    const base::DictionaryValue* dictionary = nullptr;
    if (!rule_value->GetAsDictionary(&dictionary)) {
      DCHECK(error->empty());
      *error = UTF8ToUTF16("'rule': expected dictionary, got " + std::string(base::Value::GetTypeName(rule_value->type())));
      return false;
    }
    if (!MatchedRule::Populate(*dictionary, &out->rule, error)) {
      return false;
    }
  }

  const base::Value* time_stamp_value = nullptr;
  if (!dict->GetWithoutPathExpansion("timeStamp", &time_stamp_value)) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("'timeStamp' is required");
    return false;
  }
  {
    if (!time_stamp_value->GetAsDouble(&out->time_stamp)) {
      DCHECK(error->empty());
      *error = UTF8ToUTF16("'timeStamp': expected timeStamp, got " + std::string(base::Value::GetTypeName(time_stamp_value->type())));
      return false;
    }
  }

  const base::Value* tab_id_value = nullptr;
  if (!dict->GetWithoutPathExpansion("tabId", &tab_id_value)) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("'tabId' is required");
    return false;
  }
  {
    if (!tab_id_value->GetAsInteger(&out->tab_id)) {
      DCHECK(error->empty());
      *error = UTF8ToUTF16("'tabId': expected tabId, got " + std::string(base::Value::GetTypeName(tab_id_value->type())));
      return false;
    }
  }

  return true;
}

// static
std::unique_ptr<MatchedRuleInfo> MatchedRuleInfo::FromValue(const base::Value& value, base::string16* error) {
  DCHECK(error);
  auto out = std::make_unique<MatchedRuleInfo>();
  bool result = Populate(value, out.get(), error);
  DCHECK_EQ(result, error->empty());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> MatchedRuleInfo::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("rule", (this->rule).ToValue());

  to_value_result->SetWithoutPathExpansion("timeStamp", std::make_unique<base::Value>(this->time_stamp));

  to_value_result->SetWithoutPathExpansion("tabId", std::make_unique<base::Value>(this->tab_id));


  return to_value_result;
}


MatchedRulesFilter::MatchedRulesFilter()
 {}

MatchedRulesFilter::~MatchedRulesFilter() = default;
MatchedRulesFilter::MatchedRulesFilter(MatchedRulesFilter&& rhs) = default;
MatchedRulesFilter& MatchedRulesFilter::operator=(MatchedRulesFilter&& rhs) = default;
// static
bool MatchedRulesFilter::Populate(
    const base::Value& value, MatchedRulesFilter* out, base::string16* error) {
  DCHECK(error);
  if (!value.is_dict()) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("expected dictionary, got " + std::string(base::Value::GetTypeName(value.type())));
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* tab_id_value = nullptr;
  if (dict->GetWithoutPathExpansion("tabId", &tab_id_value)) {
    {
      int temp;
      if (!tab_id_value->GetAsInteger(&temp)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'tabId': expected tabId, got " + std::string(base::Value::GetTypeName(tab_id_value->type())));
        out->tab_id.reset();
        return false;
      }
      else
        out->tab_id = std::make_unique<int>(temp);
    }
  }

  const base::Value* min_time_stamp_value = nullptr;
  if (dict->GetWithoutPathExpansion("minTimeStamp", &min_time_stamp_value)) {
    {
      double temp;
      if (!min_time_stamp_value->GetAsDouble(&temp)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'minTimeStamp': expected minTimeStamp, got " + std::string(base::Value::GetTypeName(min_time_stamp_value->type())));
        out->min_time_stamp.reset();
        return false;
      }
      else
        out->min_time_stamp = std::make_unique<double>(temp);
    }
  }

  return true;
}

// static
std::unique_ptr<MatchedRulesFilter> MatchedRulesFilter::FromValue(const base::Value& value, base::string16* error) {
  DCHECK(error);
  auto out = std::make_unique<MatchedRulesFilter>();
  bool result = Populate(value, out.get(), error);
  DCHECK_EQ(result, error->empty());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> MatchedRulesFilter::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->tab_id.get()) {
    to_value_result->SetWithoutPathExpansion("tabId", std::make_unique<base::Value>(*this->tab_id));

  }
  if (this->min_time_stamp.get()) {
    to_value_result->SetWithoutPathExpansion("minTimeStamp", std::make_unique<base::Value>(*this->min_time_stamp));

  }

  return to_value_result;
}


RulesMatchedDetails::RulesMatchedDetails()
 {}

RulesMatchedDetails::~RulesMatchedDetails() = default;
RulesMatchedDetails::RulesMatchedDetails(RulesMatchedDetails&& rhs) = default;
RulesMatchedDetails& RulesMatchedDetails::operator=(RulesMatchedDetails&& rhs) = default;
// static
bool RulesMatchedDetails::Populate(
    const base::Value& value, RulesMatchedDetails* out, base::string16* error) {
  DCHECK(error);
  if (!value.is_dict()) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("expected dictionary, got " + std::string(base::Value::GetTypeName(value.type())));
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* rules_matched_info_value = nullptr;
  if (!dict->GetWithoutPathExpansion("rulesMatchedInfo", &rules_matched_info_value)) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("'rulesMatchedInfo' is required");
    return false;
  }
  {
    const base::ListValue* list = nullptr;
    if (!rules_matched_info_value->GetAsList(&list)) {
      DCHECK(error->empty());
      *error = UTF8ToUTF16("'rulesMatchedInfo': expected list, got " + std::string(base::Value::GetTypeName(rules_matched_info_value->type())));
      return false;
    }
    else {
      base::string16 array_parse_error;
      if (!json_schema_compiler::util::PopulateArrayFromList(*list, &out->rules_matched_info, &array_parse_error)) {
        array_parse_error = base::UTF8ToUTF16("Error at key 'rulesMatchedInfo': ") + array_parse_error;
        DCHECK(error->empty());
        *error = array_parse_error;
        return false;
      }
    }
  }

  return true;
}

// static
std::unique_ptr<RulesMatchedDetails> RulesMatchedDetails::FromValue(const base::Value& value, base::string16* error) {
  DCHECK(error);
  auto out = std::make_unique<RulesMatchedDetails>();
  bool result = Populate(value, out.get(), error);
  DCHECK_EQ(result, error->empty());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> RulesMatchedDetails::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("rulesMatchedInfo", json_schema_compiler::util::CreateValueFromArray(this->rules_matched_info));


  return to_value_result;
}


RequestDetails::RequestDetails()
: frame_id(0),
parent_frame_id(0),
tab_id(0),
type(RESOURCE_TYPE_NONE) {}

RequestDetails::~RequestDetails() = default;
RequestDetails::RequestDetails(RequestDetails&& rhs) = default;
RequestDetails& RequestDetails::operator=(RequestDetails&& rhs) = default;
// static
bool RequestDetails::Populate(
    const base::Value& value, RequestDetails* out, base::string16* error) {
  DCHECK(error);
  if (!value.is_dict()) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("expected dictionary, got " + std::string(base::Value::GetTypeName(value.type())));
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* request_id_value = nullptr;
  if (!dict->GetWithoutPathExpansion("requestId", &request_id_value)) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("'requestId' is required");
    return false;
  }
  {
    if (!request_id_value->GetAsString(&out->request_id)) {
      DCHECK(error->empty());
      *error = UTF8ToUTF16("'requestId': expected requestId, got " + std::string(base::Value::GetTypeName(request_id_value->type())));
      return false;
    }
  }

  const base::Value* url_value = nullptr;
  if (!dict->GetWithoutPathExpansion("url", &url_value)) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("'url' is required");
    return false;
  }
  {
    if (!url_value->GetAsString(&out->url)) {
      DCHECK(error->empty());
      *error = UTF8ToUTF16("'url': expected url, got " + std::string(base::Value::GetTypeName(url_value->type())));
      return false;
    }
  }

  const base::Value* initiator_value = nullptr;
  if (dict->GetWithoutPathExpansion("initiator", &initiator_value)) {
    {
      std::string temp;
      if (!initiator_value->GetAsString(&temp)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'initiator': expected initiator, got " + std::string(base::Value::GetTypeName(initiator_value->type())));
        out->initiator.reset();
        return false;
      }
      else
        out->initiator = std::make_unique<std::string>(temp);
    }
  }

  const base::Value* method_value = nullptr;
  if (!dict->GetWithoutPathExpansion("method", &method_value)) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("'method' is required");
    return false;
  }
  {
    if (!method_value->GetAsString(&out->method)) {
      DCHECK(error->empty());
      *error = UTF8ToUTF16("'method': expected method, got " + std::string(base::Value::GetTypeName(method_value->type())));
      return false;
    }
  }

  const base::Value* frame_id_value = nullptr;
  if (!dict->GetWithoutPathExpansion("frameId", &frame_id_value)) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("'frameId' is required");
    return false;
  }
  {
    if (!frame_id_value->GetAsInteger(&out->frame_id)) {
      DCHECK(error->empty());
      *error = UTF8ToUTF16("'frameId': expected frameId, got " + std::string(base::Value::GetTypeName(frame_id_value->type())));
      return false;
    }
  }

  const base::Value* parent_frame_id_value = nullptr;
  if (!dict->GetWithoutPathExpansion("parentFrameId", &parent_frame_id_value)) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("'parentFrameId' is required");
    return false;
  }
  {
    if (!parent_frame_id_value->GetAsInteger(&out->parent_frame_id)) {
      DCHECK(error->empty());
      *error = UTF8ToUTF16("'parentFrameId': expected parentFrameId, got " + std::string(base::Value::GetTypeName(parent_frame_id_value->type())));
      return false;
    }
  }

  const base::Value* tab_id_value = nullptr;
  if (!dict->GetWithoutPathExpansion("tabId", &tab_id_value)) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("'tabId' is required");
    return false;
  }
  {
    if (!tab_id_value->GetAsInteger(&out->tab_id)) {
      DCHECK(error->empty());
      *error = UTF8ToUTF16("'tabId': expected tabId, got " + std::string(base::Value::GetTypeName(tab_id_value->type())));
      return false;
    }
  }

  const base::Value* type_value = nullptr;
  if (!dict->GetWithoutPathExpansion("type", &type_value)) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("'type' is required");
    return false;
  }
  {
    std::string resource_type_as_string;
    if (!type_value->GetAsString(&resource_type_as_string)) {
      DCHECK(error->empty());
      *error = UTF8ToUTF16("'ResourceType': expected string, got " + std::string(base::Value::GetTypeName(type_value->type())));
      return false;
    }
    out->type = ParseResourceType(resource_type_as_string);
    if (out->type == RESOURCE_TYPE_NONE) {
      DCHECK(error->empty());
      *error = UTF8ToUTF16("'ResourceType': expected \"main_frame\" or \"sub_frame\" or \"stylesheet\" or \"script\" or \"image\" or \"font\" or \"object\" or \"xmlhttprequest\" or \"ping\" or \"csp_report\" or \"media\" or \"websocket\" or \"other\", got \"" + resource_type_as_string + "\"");
      return false;
    }
  }

  return true;
}

// static
std::unique_ptr<RequestDetails> RequestDetails::FromValue(const base::Value& value, base::string16* error) {
  DCHECK(error);
  auto out = std::make_unique<RequestDetails>();
  bool result = Populate(value, out.get(), error);
  DCHECK_EQ(result, error->empty());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> RequestDetails::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("requestId", std::make_unique<base::Value>(this->request_id));

  to_value_result->SetWithoutPathExpansion("url", std::make_unique<base::Value>(this->url));

  if (this->initiator.get()) {
    to_value_result->SetWithoutPathExpansion("initiator", std::make_unique<base::Value>(*this->initiator));

  }
  to_value_result->SetWithoutPathExpansion("method", std::make_unique<base::Value>(this->method));

  to_value_result->SetWithoutPathExpansion("frameId", std::make_unique<base::Value>(this->frame_id));

  to_value_result->SetWithoutPathExpansion("parentFrameId", std::make_unique<base::Value>(this->parent_frame_id));

  to_value_result->SetWithoutPathExpansion("tabId", std::make_unique<base::Value>(this->tab_id));

  to_value_result->SetWithoutPathExpansion("type", std::make_unique<base::Value>(declarative_net_request::ToString(this->type)));


  return to_value_result;
}


MatchedRuleInfoDebug::MatchedRuleInfoDebug()
 {}

MatchedRuleInfoDebug::~MatchedRuleInfoDebug() = default;
MatchedRuleInfoDebug::MatchedRuleInfoDebug(MatchedRuleInfoDebug&& rhs) = default;
MatchedRuleInfoDebug& MatchedRuleInfoDebug::operator=(MatchedRuleInfoDebug&& rhs) = default;
// static
bool MatchedRuleInfoDebug::Populate(
    const base::Value& value, MatchedRuleInfoDebug* out, base::string16* error) {
  DCHECK(error);
  if (!value.is_dict()) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("expected dictionary, got " + std::string(base::Value::GetTypeName(value.type())));
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* rule_value = nullptr;
  if (!dict->GetWithoutPathExpansion("rule", &rule_value)) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("'rule' is required");
    return false;
  }
  {
    const base::DictionaryValue* dictionary = nullptr;
    if (!rule_value->GetAsDictionary(&dictionary)) {
      DCHECK(error->empty());
      *error = UTF8ToUTF16("'rule': expected dictionary, got " + std::string(base::Value::GetTypeName(rule_value->type())));
      return false;
    }
    if (!MatchedRule::Populate(*dictionary, &out->rule, error)) {
      return false;
    }
  }

  const base::Value* request_value = nullptr;
  if (!dict->GetWithoutPathExpansion("request", &request_value)) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("'request' is required");
    return false;
  }
  {
    const base::DictionaryValue* dictionary = nullptr;
    if (!request_value->GetAsDictionary(&dictionary)) {
      DCHECK(error->empty());
      *error = UTF8ToUTF16("'request': expected dictionary, got " + std::string(base::Value::GetTypeName(request_value->type())));
      return false;
    }
    if (!RequestDetails::Populate(*dictionary, &out->request, error)) {
      return false;
    }
  }

  return true;
}

// static
std::unique_ptr<MatchedRuleInfoDebug> MatchedRuleInfoDebug::FromValue(const base::Value& value, base::string16* error) {
  DCHECK(error);
  auto out = std::make_unique<MatchedRuleInfoDebug>();
  bool result = Populate(value, out.get(), error);
  DCHECK_EQ(result, error->empty());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> MatchedRuleInfoDebug::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("rule", (this->rule).ToValue());

  to_value_result->SetWithoutPathExpansion("request", (this->request).ToValue());


  return to_value_result;
}


DNRInfo::DNRInfo()
 {}

DNRInfo::~DNRInfo() = default;
DNRInfo::DNRInfo(DNRInfo&& rhs) = default;
DNRInfo& DNRInfo::operator=(DNRInfo&& rhs) = default;
// static
constexpr char DNRInfo::kRuleResources[];

// static
bool DNRInfo::Populate(
    const base::Value& value, DNRInfo* out, base::string16* error) {
  DCHECK(error);
  if (!value.is_dict()) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("expected dictionary, got " + std::string(base::Value::GetTypeName(value.type())));
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* rule_resources_value = nullptr;
  if (!dict->GetWithoutPathExpansion("rule_resources", &rule_resources_value)) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("'rule_resources' is required");
    return false;
  }
  {
    const base::ListValue* list = nullptr;
    if (!rule_resources_value->GetAsList(&list)) {
      DCHECK(error->empty());
      *error = UTF8ToUTF16("'rule_resources': expected list, got " + std::string(base::Value::GetTypeName(rule_resources_value->type())));
      return false;
    }
    else {
      base::string16 array_parse_error;
      if (!json_schema_compiler::util::PopulateArrayFromList(*list, &out->rule_resources, &array_parse_error)) {
        array_parse_error = base::UTF8ToUTF16("Error at key 'rule_resources': ") + array_parse_error;
        DCHECK(error->empty());
        *error = array_parse_error;
        return false;
      }
    }
  }

  return true;
}

// static
std::unique_ptr<DNRInfo> DNRInfo::FromValue(const base::Value& value, base::string16* error) {
  DCHECK(error);
  auto out = std::make_unique<DNRInfo>();
  bool result = Populate(value, out.get(), error);
  DCHECK_EQ(result, error->empty());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> DNRInfo::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("rule_resources", json_schema_compiler::util::CreateValueFromArray(this->rule_resources));


  return to_value_result;
}

//static
bool DNRInfo::ParseFromDictionary(
const base::DictionaryValue& root_dict, base::StringPiece key, DNRInfo* out, base::string16* error, std::vector<base::StringPiece>* error_path_reversed) {
  DCHECK(out);
  DCHECK(error);
  DCHECK(error_path_reversed);

  const base::Value* value = ::json_schema_compiler::manifest_parse_util::FindKeyOfType(root_dict, key, base::Value::Type::DICTIONARY, error, error_path_reversed);
  if (!value)
    return false;
  const base::DictionaryValue& dict = base::Value::AsDictionaryValue(*value);
  if (!::json_schema_compiler::manifest_parse_util::ParseFromDictionary(dict, kRuleResources, &out->rule_resources, error, error_path_reversed)) {
    error_path_reversed->push_back(key);
    return false;
  }

  return true;
}


RegexOptions::RegexOptions()
 {}

RegexOptions::~RegexOptions() = default;
RegexOptions::RegexOptions(RegexOptions&& rhs) = default;
RegexOptions& RegexOptions::operator=(RegexOptions&& rhs) = default;
// static
bool RegexOptions::Populate(
    const base::Value& value, RegexOptions* out, base::string16* error) {
  DCHECK(error);
  if (!value.is_dict()) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("expected dictionary, got " + std::string(base::Value::GetTypeName(value.type())));
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* regex_value = nullptr;
  if (!dict->GetWithoutPathExpansion("regex", &regex_value)) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("'regex' is required");
    return false;
  }
  {
    if (!regex_value->GetAsString(&out->regex)) {
      DCHECK(error->empty());
      *error = UTF8ToUTF16("'regex': expected regex, got " + std::string(base::Value::GetTypeName(regex_value->type())));
      return false;
    }
  }

  const base::Value* is_case_sensitive_value = nullptr;
  if (dict->GetWithoutPathExpansion("isCaseSensitive", &is_case_sensitive_value)) {
    {
      bool temp;
      if (!is_case_sensitive_value->GetAsBoolean(&temp)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'isCaseSensitive': expected isCaseSensitive, got " + std::string(base::Value::GetTypeName(is_case_sensitive_value->type())));
        out->is_case_sensitive.reset();
        return false;
      }
      else
        out->is_case_sensitive = std::make_unique<bool>(temp);
    }
  }

  const base::Value* require_capturing_value = nullptr;
  if (dict->GetWithoutPathExpansion("requireCapturing", &require_capturing_value)) {
    {
      bool temp;
      if (!require_capturing_value->GetAsBoolean(&temp)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'requireCapturing': expected requireCapturing, got " + std::string(base::Value::GetTypeName(require_capturing_value->type())));
        out->require_capturing.reset();
        return false;
      }
      else
        out->require_capturing = std::make_unique<bool>(temp);
    }
  }

  return true;
}

// static
std::unique_ptr<RegexOptions> RegexOptions::FromValue(const base::Value& value, base::string16* error) {
  DCHECK(error);
  auto out = std::make_unique<RegexOptions>();
  bool result = Populate(value, out.get(), error);
  DCHECK_EQ(result, error->empty());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> RegexOptions::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("regex", std::make_unique<base::Value>(this->regex));

  if (this->is_case_sensitive.get()) {
    to_value_result->SetWithoutPathExpansion("isCaseSensitive", std::make_unique<base::Value>(*this->is_case_sensitive));

  }
  if (this->require_capturing.get()) {
    to_value_result->SetWithoutPathExpansion("requireCapturing", std::make_unique<base::Value>(*this->require_capturing));

  }

  return to_value_result;
}


IsRegexSupportedResult::IsRegexSupportedResult()
: is_supported(false),
reason(UNSUPPORTED_REGEX_REASON_NONE) {}

IsRegexSupportedResult::~IsRegexSupportedResult() = default;
IsRegexSupportedResult::IsRegexSupportedResult(IsRegexSupportedResult&& rhs) = default;
IsRegexSupportedResult& IsRegexSupportedResult::operator=(IsRegexSupportedResult&& rhs) = default;
// static
bool IsRegexSupportedResult::Populate(
    const base::Value& value, IsRegexSupportedResult* out, base::string16* error) {
  DCHECK(error);
  if (!value.is_dict()) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("expected dictionary, got " + std::string(base::Value::GetTypeName(value.type())));
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  out->reason = UNSUPPORTED_REGEX_REASON_NONE;
  const base::Value* is_supported_value = nullptr;
  if (!dict->GetWithoutPathExpansion("isSupported", &is_supported_value)) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("'isSupported' is required");
    return false;
  }
  {
    if (!is_supported_value->GetAsBoolean(&out->is_supported)) {
      DCHECK(error->empty());
      *error = UTF8ToUTF16("'isSupported': expected isSupported, got " + std::string(base::Value::GetTypeName(is_supported_value->type())));
      return false;
    }
  }

  const base::Value* reason_value = nullptr;
  if (dict->GetWithoutPathExpansion("reason", &reason_value)) {
    {
      std::string unsupported_regex_reason_as_string;
      if (!reason_value->GetAsString(&unsupported_regex_reason_as_string)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'UnsupportedRegexReason': expected string, got " + std::string(base::Value::GetTypeName(reason_value->type())));
        return false;
      }
      out->reason = ParseUnsupportedRegexReason(unsupported_regex_reason_as_string);
      if (out->reason == UNSUPPORTED_REGEX_REASON_NONE) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'UnsupportedRegexReason': expected \"syntaxError\" or \"memoryLimitExceeded\", got \"" + unsupported_regex_reason_as_string + "\"");
        return false;
      }
    }
    } else {
    out->reason = UNSUPPORTED_REGEX_REASON_NONE;
  }

  return true;
}

// static
std::unique_ptr<IsRegexSupportedResult> IsRegexSupportedResult::FromValue(const base::Value& value, base::string16* error) {
  DCHECK(error);
  auto out = std::make_unique<IsRegexSupportedResult>();
  bool result = Populate(value, out.get(), error);
  DCHECK_EQ(result, error->empty());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> IsRegexSupportedResult::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("isSupported", std::make_unique<base::Value>(this->is_supported));

  if (this->reason != UNSUPPORTED_REGEX_REASON_NONE) {
    to_value_result->SetWithoutPathExpansion("reason", std::make_unique<base::Value>(declarative_net_request::ToString(this->reason)));

  }

  return to_value_result;
}


UpdateRuleOptions::UpdateRuleOptions()
 {}

UpdateRuleOptions::~UpdateRuleOptions() = default;
UpdateRuleOptions::UpdateRuleOptions(UpdateRuleOptions&& rhs) = default;
UpdateRuleOptions& UpdateRuleOptions::operator=(UpdateRuleOptions&& rhs) = default;
// static
bool UpdateRuleOptions::Populate(
    const base::Value& value, UpdateRuleOptions* out, base::string16* error) {
  DCHECK(error);
  if (!value.is_dict()) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("expected dictionary, got " + std::string(base::Value::GetTypeName(value.type())));
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* remove_rule_ids_value = nullptr;
  if (dict->GetWithoutPathExpansion("removeRuleIds", &remove_rule_ids_value)) {
    {
      const base::ListValue* list = nullptr;
      if (!remove_rule_ids_value->GetAsList(&list)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'removeRuleIds': expected list, got " + std::string(base::Value::GetTypeName(remove_rule_ids_value->type())));
        return false;
      }
      else {
        base::string16 array_parse_error;
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->remove_rule_ids, &array_parse_error)) {
          array_parse_error = base::UTF8ToUTF16("Error at key 'removeRuleIds': ") + array_parse_error;
          DCHECK(error->empty());
          *error = array_parse_error;
          return false;
        }
      }
    }
  }

  const base::Value* add_rules_value = nullptr;
  if (dict->GetWithoutPathExpansion("addRules", &add_rules_value)) {
    {
      const base::ListValue* list = nullptr;
      if (!add_rules_value->GetAsList(&list)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'addRules': expected list, got " + std::string(base::Value::GetTypeName(add_rules_value->type())));
        return false;
      }
      else {
        base::string16 array_parse_error;
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->add_rules, &array_parse_error)) {
          array_parse_error = base::UTF8ToUTF16("Error at key 'addRules': ") + array_parse_error;
          DCHECK(error->empty());
          *error = array_parse_error;
          return false;
        }
      }
    }
  }

  return true;
}

// static
std::unique_ptr<UpdateRuleOptions> UpdateRuleOptions::FromValue(const base::Value& value, base::string16* error) {
  DCHECK(error);
  auto out = std::make_unique<UpdateRuleOptions>();
  bool result = Populate(value, out.get(), error);
  DCHECK_EQ(result, error->empty());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> UpdateRuleOptions::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->remove_rule_ids.get()) {
    to_value_result->SetWithoutPathExpansion("removeRuleIds", json_schema_compiler::util::CreateValueFromOptionalArray(this->remove_rule_ids));

  }
  if (this->add_rules.get()) {
    to_value_result->SetWithoutPathExpansion("addRules", json_schema_compiler::util::CreateValueFromOptionalArray(this->add_rules));

  }

  return to_value_result;
}


UpdateRulesetOptions::UpdateRulesetOptions()
 {}

UpdateRulesetOptions::~UpdateRulesetOptions() = default;
UpdateRulesetOptions::UpdateRulesetOptions(UpdateRulesetOptions&& rhs) = default;
UpdateRulesetOptions& UpdateRulesetOptions::operator=(UpdateRulesetOptions&& rhs) = default;
// static
bool UpdateRulesetOptions::Populate(
    const base::Value& value, UpdateRulesetOptions* out, base::string16* error) {
  DCHECK(error);
  if (!value.is_dict()) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("expected dictionary, got " + std::string(base::Value::GetTypeName(value.type())));
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* disable_ruleset_ids_value = nullptr;
  if (dict->GetWithoutPathExpansion("disableRulesetIds", &disable_ruleset_ids_value)) {
    {
      const base::ListValue* list = nullptr;
      if (!disable_ruleset_ids_value->GetAsList(&list)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'disableRulesetIds': expected list, got " + std::string(base::Value::GetTypeName(disable_ruleset_ids_value->type())));
        return false;
      }
      else {
        base::string16 array_parse_error;
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->disable_ruleset_ids, &array_parse_error)) {
          array_parse_error = base::UTF8ToUTF16("Error at key 'disableRulesetIds': ") + array_parse_error;
          DCHECK(error->empty());
          *error = array_parse_error;
          return false;
        }
      }
    }
  }

  const base::Value* enable_ruleset_ids_value = nullptr;
  if (dict->GetWithoutPathExpansion("enableRulesetIds", &enable_ruleset_ids_value)) {
    {
      const base::ListValue* list = nullptr;
      if (!enable_ruleset_ids_value->GetAsList(&list)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'enableRulesetIds': expected list, got " + std::string(base::Value::GetTypeName(enable_ruleset_ids_value->type())));
        return false;
      }
      else {
        base::string16 array_parse_error;
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->enable_ruleset_ids, &array_parse_error)) {
          array_parse_error = base::UTF8ToUTF16("Error at key 'enableRulesetIds': ") + array_parse_error;
          DCHECK(error->empty());
          *error = array_parse_error;
          return false;
        }
      }
    }
  }

  return true;
}

// static
std::unique_ptr<UpdateRulesetOptions> UpdateRulesetOptions::FromValue(const base::Value& value, base::string16* error) {
  DCHECK(error);
  auto out = std::make_unique<UpdateRulesetOptions>();
  bool result = Populate(value, out.get(), error);
  DCHECK_EQ(result, error->empty());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> UpdateRulesetOptions::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->disable_ruleset_ids.get()) {
    to_value_result->SetWithoutPathExpansion("disableRulesetIds", json_schema_compiler::util::CreateValueFromOptionalArray(this->disable_ruleset_ids));

  }
  if (this->enable_ruleset_ids.get()) {
    to_value_result->SetWithoutPathExpansion("enableRulesetIds", json_schema_compiler::util::CreateValueFromOptionalArray(this->enable_ruleset_ids));

  }

  return to_value_result;
}


TabActionCountUpdate::TabActionCountUpdate()
: tab_id(0),
increment(0) {}

TabActionCountUpdate::~TabActionCountUpdate() = default;
TabActionCountUpdate::TabActionCountUpdate(TabActionCountUpdate&& rhs) = default;
TabActionCountUpdate& TabActionCountUpdate::operator=(TabActionCountUpdate&& rhs) = default;
// static
bool TabActionCountUpdate::Populate(
    const base::Value& value, TabActionCountUpdate* out, base::string16* error) {
  DCHECK(error);
  if (!value.is_dict()) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("expected dictionary, got " + std::string(base::Value::GetTypeName(value.type())));
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* tab_id_value = nullptr;
  if (!dict->GetWithoutPathExpansion("tabId", &tab_id_value)) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("'tabId' is required");
    return false;
  }
  {
    if (!tab_id_value->GetAsInteger(&out->tab_id)) {
      DCHECK(error->empty());
      *error = UTF8ToUTF16("'tabId': expected tabId, got " + std::string(base::Value::GetTypeName(tab_id_value->type())));
      return false;
    }
  }

  const base::Value* increment_value = nullptr;
  if (!dict->GetWithoutPathExpansion("increment", &increment_value)) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("'increment' is required");
    return false;
  }
  {
    if (!increment_value->GetAsInteger(&out->increment)) {
      DCHECK(error->empty());
      *error = UTF8ToUTF16("'increment': expected increment, got " + std::string(base::Value::GetTypeName(increment_value->type())));
      return false;
    }
  }

  return true;
}

// static
std::unique_ptr<TabActionCountUpdate> TabActionCountUpdate::FromValue(const base::Value& value, base::string16* error) {
  DCHECK(error);
  auto out = std::make_unique<TabActionCountUpdate>();
  bool result = Populate(value, out.get(), error);
  DCHECK_EQ(result, error->empty());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> TabActionCountUpdate::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("tabId", std::make_unique<base::Value>(this->tab_id));

  to_value_result->SetWithoutPathExpansion("increment", std::make_unique<base::Value>(this->increment));


  return to_value_result;
}


ExtensionActionOptions::ExtensionActionOptions()
 {}

ExtensionActionOptions::~ExtensionActionOptions() = default;
ExtensionActionOptions::ExtensionActionOptions(ExtensionActionOptions&& rhs) = default;
ExtensionActionOptions& ExtensionActionOptions::operator=(ExtensionActionOptions&& rhs) = default;
// static
bool ExtensionActionOptions::Populate(
    const base::Value& value, ExtensionActionOptions* out, base::string16* error) {
  DCHECK(error);
  if (!value.is_dict()) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("expected dictionary, got " + std::string(base::Value::GetTypeName(value.type())));
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* display_action_count_as_badge_text_value = nullptr;
  if (dict->GetWithoutPathExpansion("displayActionCountAsBadgeText", &display_action_count_as_badge_text_value)) {
    {
      bool temp;
      if (!display_action_count_as_badge_text_value->GetAsBoolean(&temp)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'displayActionCountAsBadgeText': expected displayActionCountAsBadgeText, got " + std::string(base::Value::GetTypeName(display_action_count_as_badge_text_value->type())));
        out->display_action_count_as_badge_text.reset();
        return false;
      }
      else
        out->display_action_count_as_badge_text = std::make_unique<bool>(temp);
    }
  }

  const base::Value* tab_update_value = nullptr;
  if (dict->GetWithoutPathExpansion("tabUpdate", &tab_update_value)) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!tab_update_value->GetAsDictionary(&dictionary)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'tabUpdate': expected dictionary, got " + std::string(base::Value::GetTypeName(tab_update_value->type())));
        return false;
      }
      else {
        auto temp = std::make_unique<TabActionCountUpdate>();
        if (!TabActionCountUpdate::Populate(*dictionary, temp.get(), error)) {
          return false;
        }
        else
          out->tab_update = std::move(temp);
      }
    }
  }

  return true;
}

// static
std::unique_ptr<ExtensionActionOptions> ExtensionActionOptions::FromValue(const base::Value& value, base::string16* error) {
  DCHECK(error);
  auto out = std::make_unique<ExtensionActionOptions>();
  bool result = Populate(value, out.get(), error);
  DCHECK_EQ(result, error->empty());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> ExtensionActionOptions::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->display_action_count_as_badge_text.get()) {
    to_value_result->SetWithoutPathExpansion("displayActionCountAsBadgeText", std::make_unique<base::Value>(*this->display_action_count_as_badge_text));

  }
  if (this->tab_update.get()) {
    to_value_result->SetWithoutPathExpansion("tabUpdate", (this->tab_update)->ToValue());

  }

  return to_value_result;
}



//
// Manifest Keys
//

ManifestKeys::ManifestKeys()
 {}

ManifestKeys::~ManifestKeys() = default;
ManifestKeys::ManifestKeys(ManifestKeys&& rhs) = default;
ManifestKeys& ManifestKeys::operator=(ManifestKeys&& rhs) = default;
// static
constexpr char ManifestKeys::kDeclarativeNetRequest[];

//static
bool ManifestKeys::ParseFromDictionary(
const base::DictionaryValue& root_dict, ManifestKeys* out, base::string16* error) {
  DCHECK(out);
  DCHECK(error);

  std::vector<base::StringPiece> error_path_reversed_vec;
  auto* error_path_reversed = &error_path_reversed_vec;
  const base::DictionaryValue& dict = root_dict;
  if (!::json_schema_compiler::manifest_parse_util::ParseFromDictionary(dict, kDeclarativeNetRequest, &out->declarative_net_request, error, error_path_reversed)) {
    ::json_schema_compiler::manifest_parse_util::PopulateFinalError(error, error_path_reversed);
    return false;
  }

  return true;
}


//
// Functions
//

namespace UpdateDynamicRules {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args, base::string16* error) {
  DCHECK(error);
  if (args.GetSize() != 1) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("expected 1 arguments, got " + base::NumberToString(args.GetSize()));
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* options_value = nullptr;
  if (args.Get(0, &options_value) &&
      !options_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!options_value->GetAsDictionary(&dictionary)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'options': expected dictionary, got " + std::string(base::Value::GetTypeName(options_value->type())));
        return std::unique_ptr<Params>();
      }
      if (!UpdateRuleOptions::Populate(*dictionary, &params->options, error)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("'options' is required");
    return std::unique_ptr<Params>();
  }

  return params;
}


std::unique_ptr<base::ListValue> Results::Create() {
  auto create_results = std::make_unique<base::ListValue>();
  return create_results;
}
}  // namespace UpdateDynamicRules

namespace GetDynamicRules {

std::unique_ptr<base::ListValue> Results::Create(const std::vector<Rule>& rules) {
  auto create_results = std::make_unique<base::ListValue>();
  create_results->Append(json_schema_compiler::util::CreateValueFromArray(rules));

  return create_results;
}
}  // namespace GetDynamicRules

namespace UpdateSessionRules {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args, base::string16* error) {
  DCHECK(error);
  if (args.GetSize() != 1) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("expected 1 arguments, got " + base::NumberToString(args.GetSize()));
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* options_value = nullptr;
  if (args.Get(0, &options_value) &&
      !options_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!options_value->GetAsDictionary(&dictionary)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'options': expected dictionary, got " + std::string(base::Value::GetTypeName(options_value->type())));
        return std::unique_ptr<Params>();
      }
      if (!UpdateRuleOptions::Populate(*dictionary, &params->options, error)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("'options' is required");
    return std::unique_ptr<Params>();
  }

  return params;
}


std::unique_ptr<base::ListValue> Results::Create() {
  auto create_results = std::make_unique<base::ListValue>();
  return create_results;
}
}  // namespace UpdateSessionRules

namespace GetSessionRules {

std::unique_ptr<base::ListValue> Results::Create(const std::vector<Rule>& rules) {
  auto create_results = std::make_unique<base::ListValue>();
  create_results->Append(json_schema_compiler::util::CreateValueFromArray(rules));

  return create_results;
}
}  // namespace GetSessionRules

namespace UpdateEnabledRulesets {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args, base::string16* error) {
  DCHECK(error);
  if (args.GetSize() != 1) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("expected 1 arguments, got " + base::NumberToString(args.GetSize()));
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* options_value = nullptr;
  if (args.Get(0, &options_value) &&
      !options_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!options_value->GetAsDictionary(&dictionary)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'options': expected dictionary, got " + std::string(base::Value::GetTypeName(options_value->type())));
        return std::unique_ptr<Params>();
      }
      if (!UpdateRulesetOptions::Populate(*dictionary, &params->options, error)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("'options' is required");
    return std::unique_ptr<Params>();
  }

  return params;
}


std::unique_ptr<base::ListValue> Results::Create() {
  auto create_results = std::make_unique<base::ListValue>();
  return create_results;
}
}  // namespace UpdateEnabledRulesets

namespace GetEnabledRulesets {

std::unique_ptr<base::ListValue> Results::Create(const std::vector<std::string>& ruleset_ids) {
  auto create_results = std::make_unique<base::ListValue>();
  create_results->Append(json_schema_compiler::util::CreateValueFromArray(ruleset_ids));

  return create_results;
}
}  // namespace GetEnabledRulesets

namespace GetMatchedRules {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args, base::string16* error) {
  DCHECK(error);
  if (args.GetSize() > 1) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("expected 1 arguments, got " + base::NumberToString(args.GetSize()));
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* filter_value = nullptr;
  if (args.Get(0, &filter_value) &&
      !filter_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!filter_value->GetAsDictionary(&dictionary)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'filter': expected dictionary, got " + std::string(base::Value::GetTypeName(filter_value->type())));
        return std::unique_ptr<Params>();
      }
      else {
        auto temp = std::make_unique<MatchedRulesFilter>();
        if (!MatchedRulesFilter::Populate(*dictionary, temp.get(), error)) {
          return std::unique_ptr<Params>();
        }
        else
          params->filter = std::move(temp);
      }
    }
  }

  return params;
}


std::unique_ptr<base::ListValue> Results::Create(const RulesMatchedDetails& details) {
  auto create_results = std::make_unique<base::ListValue>();
  create_results->Append((details).ToValue());

  return create_results;
}
}  // namespace GetMatchedRules

namespace SetExtensionActionOptions {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args, base::string16* error) {
  DCHECK(error);
  if (args.GetSize() != 1) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("expected 1 arguments, got " + base::NumberToString(args.GetSize()));
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* options_value = nullptr;
  if (args.Get(0, &options_value) &&
      !options_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!options_value->GetAsDictionary(&dictionary)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'options': expected dictionary, got " + std::string(base::Value::GetTypeName(options_value->type())));
        return std::unique_ptr<Params>();
      }
      if (!ExtensionActionOptions::Populate(*dictionary, &params->options, error)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("'options' is required");
    return std::unique_ptr<Params>();
  }

  return params;
}


std::unique_ptr<base::ListValue> Results::Create() {
  auto create_results = std::make_unique<base::ListValue>();
  return create_results;
}
}  // namespace SetExtensionActionOptions

namespace IsRegexSupported {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args, base::string16* error) {
  DCHECK(error);
  if (args.GetSize() != 1) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("expected 1 arguments, got " + base::NumberToString(args.GetSize()));
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* regex_options_value = nullptr;
  if (args.Get(0, &regex_options_value) &&
      !regex_options_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!regex_options_value->GetAsDictionary(&dictionary)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'regexOptions': expected dictionary, got " + std::string(base::Value::GetTypeName(regex_options_value->type())));
        return std::unique_ptr<Params>();
      }
      if (!RegexOptions::Populate(*dictionary, &params->regex_options, error)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("'regexOptions' is required");
    return std::unique_ptr<Params>();
  }

  return params;
}


std::unique_ptr<base::ListValue> Results::Create(const IsRegexSupportedResult& result) {
  auto create_results = std::make_unique<base::ListValue>();
  create_results->Append((result).ToValue());

  return create_results;
}
}  // namespace IsRegexSupported

namespace GetAvailableStaticRuleCount {

std::unique_ptr<base::ListValue> Results::Create(int count) {
  auto create_results = std::make_unique<base::ListValue>();
  create_results->Append(std::make_unique<base::Value>(count));

  return create_results;
}
}  // namespace GetAvailableStaticRuleCount

//
// Events
//

namespace OnRuleMatchedDebug {

const char kEventName[] = "declarativeNetRequest.onRuleMatchedDebug";

std::unique_ptr<base::ListValue> Create(const MatchedRuleInfoDebug& info) {
  auto create_results = std::make_unique<base::ListValue>();
  create_results->Append((info).ToValue());

  return create_results;
}

}  // namespace OnRuleMatchedDebug

}  // namespace declarative_net_request
}  // namespace api
}  // namespace extensions

