// Copyright 2022 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// GENERATED FROM THE API DEFINITION IN
//   extensions/common/api/extensions_manifest_types.json
// DO NOT EDIT.

#include "tools/json_schema_compiler/util.h"
#include "base/check.h"
#include "base/check_op.h"
#include "base/notreached.h"
#include "base/strings/string_number_conversions.h"
#include "base/strings/utf_string_conversions.h"
#include "base/values.h"
#include "extensions/common/api/extensions_manifest_types.h"
#include <set>
#include <utility>

using base::UTF8ToUTF16;

namespace extensions {
namespace api {
namespace extensions_manifest_types {
//
// Types
//

Automation::Object::Object()
 {}

Automation::Object::~Object() = default;
Automation::Object::Object(Object&& rhs) = default;
Automation::Object& Automation::Object::operator=(Object&& rhs) = default;
// static
bool Automation::Object::Populate(
    const base::Value& value, Object* out, base::string16* error) {
  DCHECK(error);
  if (!value.is_dict()) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("expected dictionary, got " + std::string(base::Value::GetTypeName(value.type())));
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* desktop_value = nullptr;
  if (dict->GetWithoutPathExpansion("desktop", &desktop_value)) {
    {
      bool temp;
      if (!desktop_value->GetAsBoolean(&temp)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'desktop': expected desktop, got " + std::string(base::Value::GetTypeName(desktop_value->type())));
        out->desktop.reset();
        return false;
      }
      else
        out->desktop = std::make_unique<bool>(temp);
    }
  }

  const base::Value* matches_value = nullptr;
  if (dict->GetWithoutPathExpansion("matches", &matches_value)) {
    {
      const base::ListValue* list = nullptr;
      if (!matches_value->GetAsList(&list)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'matches': expected list, got " + std::string(base::Value::GetTypeName(matches_value->type())));
        return false;
      }
      else {
        base::string16 array_parse_error;
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->matches, &array_parse_error)) {
          array_parse_error = base::UTF8ToUTF16("Error at key 'matches': ") + array_parse_error;
          DCHECK(error->empty());
          *error = array_parse_error;
          return false;
        }
      }
    }
  }

  const base::Value* interact_value = nullptr;
  if (dict->GetWithoutPathExpansion("interact", &interact_value)) {
    {
      bool temp;
      if (!interact_value->GetAsBoolean(&temp)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'interact': expected interact, got " + std::string(base::Value::GetTypeName(interact_value->type())));
        out->interact.reset();
        return false;
      }
      else
        out->interact = std::make_unique<bool>(temp);
    }
  }

  return true;
}

std::unique_ptr<base::DictionaryValue> Automation::Object::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->desktop.get()) {
    to_value_result->SetWithoutPathExpansion("desktop", std::make_unique<base::Value>(*this->desktop));

  }
  if (this->matches.get()) {
    to_value_result->SetWithoutPathExpansion("matches", json_schema_compiler::util::CreateValueFromOptionalArray(this->matches));

  }
  if (this->interact.get()) {
    to_value_result->SetWithoutPathExpansion("interact", std::make_unique<base::Value>(*this->interact));

  }

  return to_value_result;
}



Automation::Automation()
 {}

Automation::~Automation() = default;
Automation::Automation(Automation&& rhs) = default;
Automation& Automation::operator=(Automation&& rhs) = default;
// static
bool Automation::Populate(
    const base::Value& value, Automation* out, base::string16* error) {
  DCHECK(error);
  if (value.type() == base::Value::Type::BOOLEAN) {
    {
      bool temp;
      if (!(&value)->GetAsBoolean(&temp)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'boolean': expected boolean, got " + std::string(base::Value::GetTypeName((&value)->type())));
        out->as_boolean.reset();
        return false;
      }
      else
        out->as_boolean = std::make_unique<bool>(temp);
    }
    return true;
  }
  if (value.type() == base::Value::Type::DICTIONARY) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!(&value)->GetAsDictionary(&dictionary)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'object': expected dictionary, got " + std::string(base::Value::GetTypeName((&value)->type())));
        return false;
      }
      else {
        auto temp = std::make_unique<Object>();
        if (!Object::Populate(*dictionary, temp.get(), error)) {
          return false;
        }
        else
          out->as_object = std::move(temp);
      }
    }
    return true;
  }
  DCHECK(error->empty());
  *error = UTF8ToUTF16("expected boolean or object, got " +  std::string(base::Value::GetTypeName(value.type())));
  return false;
}

// static
std::unique_ptr<Automation> Automation::FromValue(const base::Value& value, base::string16* error) {
  DCHECK(error);
  auto out = std::make_unique<Automation>();
  bool result = Populate(value, out.get(), error);
  DCHECK_EQ(result, error->empty());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::Value> Automation::ToValue() const {
  std::unique_ptr<base::Value> result;
  if (as_boolean) {
    DCHECK(!result) << "Cannot set multiple choices for automation";
    result = std::make_unique<base::Value>(*as_boolean);

  }
  if (as_object) {
    DCHECK(!result) << "Cannot set multiple choices for automation";
    result = (as_object)->ToValue();

  }
  DCHECK(result) << "Must set at least one choice for automation";
  return result;
}


ContentCapabilities::ContentCapabilities()
 {}

ContentCapabilities::~ContentCapabilities() = default;
ContentCapabilities::ContentCapabilities(ContentCapabilities&& rhs) = default;
ContentCapabilities& ContentCapabilities::operator=(ContentCapabilities&& rhs) = default;
// static
bool ContentCapabilities::Populate(
    const base::Value& value, ContentCapabilities* out, base::string16* error) {
  DCHECK(error);
  if (!value.is_dict()) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("expected dictionary, got " + std::string(base::Value::GetTypeName(value.type())));
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* matches_value = nullptr;
  if (!dict->GetWithoutPathExpansion("matches", &matches_value)) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("'matches' is required");
    return false;
  }
  {
    const base::ListValue* list = nullptr;
    if (!matches_value->GetAsList(&list)) {
      DCHECK(error->empty());
      *error = UTF8ToUTF16("'matches': expected list, got " + std::string(base::Value::GetTypeName(matches_value->type())));
      return false;
    }
    else {
      base::string16 array_parse_error;
      if (!json_schema_compiler::util::PopulateArrayFromList(*list, &out->matches, &array_parse_error)) {
        array_parse_error = base::UTF8ToUTF16("Error at key 'matches': ") + array_parse_error;
        DCHECK(error->empty());
        *error = array_parse_error;
        return false;
      }
    }
  }

  const base::Value* permissions_value = nullptr;
  if (!dict->GetWithoutPathExpansion("permissions", &permissions_value)) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("'permissions' is required");
    return false;
  }
  {
    const base::ListValue* list = nullptr;
    if (!permissions_value->GetAsList(&list)) {
      DCHECK(error->empty());
      *error = UTF8ToUTF16("'permissions': expected list, got " + std::string(base::Value::GetTypeName(permissions_value->type())));
      return false;
    }
    else {
      base::string16 array_parse_error;
      if (!json_schema_compiler::util::PopulateArrayFromList(*list, &out->permissions, &array_parse_error)) {
        array_parse_error = base::UTF8ToUTF16("Error at key 'permissions': ") + array_parse_error;
        DCHECK(error->empty());
        *error = array_parse_error;
        return false;
      }
    }
  }

  return true;
}

// static
std::unique_ptr<ContentCapabilities> ContentCapabilities::FromValue(const base::Value& value, base::string16* error) {
  DCHECK(error);
  auto out = std::make_unique<ContentCapabilities>();
  bool result = Populate(value, out.get(), error);
  DCHECK_EQ(result, error->empty());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> ContentCapabilities::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("matches", json_schema_compiler::util::CreateValueFromArray(this->matches));

  to_value_result->SetWithoutPathExpansion("permissions", json_schema_compiler::util::CreateValueFromArray(this->permissions));


  return to_value_result;
}


ExternallyConnectable::ExternallyConnectable()
 {}

ExternallyConnectable::~ExternallyConnectable() = default;
ExternallyConnectable::ExternallyConnectable(ExternallyConnectable&& rhs) = default;
ExternallyConnectable& ExternallyConnectable::operator=(ExternallyConnectable&& rhs) = default;
// static
bool ExternallyConnectable::Populate(
    const base::Value& value, ExternallyConnectable* out, base::string16* error) {
  DCHECK(error);
  if (!value.is_dict()) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("expected dictionary, got " + std::string(base::Value::GetTypeName(value.type())));
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* ids_value = nullptr;
  if (dict->GetWithoutPathExpansion("ids", &ids_value)) {
    {
      const base::ListValue* list = nullptr;
      if (!ids_value->GetAsList(&list)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'ids': expected list, got " + std::string(base::Value::GetTypeName(ids_value->type())));
        return false;
      }
      else {
        base::string16 array_parse_error;
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->ids, &array_parse_error)) {
          array_parse_error = base::UTF8ToUTF16("Error at key 'ids': ") + array_parse_error;
          DCHECK(error->empty());
          *error = array_parse_error;
          return false;
        }
      }
    }
  }

  const base::Value* matches_value = nullptr;
  if (dict->GetWithoutPathExpansion("matches", &matches_value)) {
    {
      const base::ListValue* list = nullptr;
      if (!matches_value->GetAsList(&list)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'matches': expected list, got " + std::string(base::Value::GetTypeName(matches_value->type())));
        return false;
      }
      else {
        base::string16 array_parse_error;
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->matches, &array_parse_error)) {
          array_parse_error = base::UTF8ToUTF16("Error at key 'matches': ") + array_parse_error;
          DCHECK(error->empty());
          *error = array_parse_error;
          return false;
        }
      }
    }
  }

  const base::Value* accepts_tls_channel_id_value = nullptr;
  if (dict->GetWithoutPathExpansion("accepts_tls_channel_id", &accepts_tls_channel_id_value)) {
    {
      bool temp;
      if (!accepts_tls_channel_id_value->GetAsBoolean(&temp)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'accepts_tls_channel_id': expected accepts_tls_channel_id, got " + std::string(base::Value::GetTypeName(accepts_tls_channel_id_value->type())));
        out->accepts_tls_channel_id.reset();
        return false;
      }
      else
        out->accepts_tls_channel_id = std::make_unique<bool>(temp);
    }
  }

  return true;
}

// static
std::unique_ptr<ExternallyConnectable> ExternallyConnectable::FromValue(const base::Value& value, base::string16* error) {
  DCHECK(error);
  auto out = std::make_unique<ExternallyConnectable>();
  bool result = Populate(value, out.get(), error);
  DCHECK_EQ(result, error->empty());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> ExternallyConnectable::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->ids.get()) {
    to_value_result->SetWithoutPathExpansion("ids", json_schema_compiler::util::CreateValueFromOptionalArray(this->ids));

  }
  if (this->matches.get()) {
    to_value_result->SetWithoutPathExpansion("matches", json_schema_compiler::util::CreateValueFromOptionalArray(this->matches));

  }
  if (this->accepts_tls_channel_id.get()) {
    to_value_result->SetWithoutPathExpansion("accepts_tls_channel_id", std::make_unique<base::Value>(*this->accepts_tls_channel_id));

  }

  return to_value_result;
}


OptionsUI::OptionsUI()
 {}

OptionsUI::~OptionsUI() = default;
OptionsUI::OptionsUI(OptionsUI&& rhs) = default;
OptionsUI& OptionsUI::operator=(OptionsUI&& rhs) = default;
// static
bool OptionsUI::Populate(
    const base::Value& value, OptionsUI* out, base::string16* error) {
  DCHECK(error);
  if (!value.is_dict()) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("expected dictionary, got " + std::string(base::Value::GetTypeName(value.type())));
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* page_value = nullptr;
  if (!dict->GetWithoutPathExpansion("page", &page_value)) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("'page' is required");
    return false;
  }
  {
    if (!page_value->GetAsString(&out->page)) {
      DCHECK(error->empty());
      *error = UTF8ToUTF16("'page': expected page, got " + std::string(base::Value::GetTypeName(page_value->type())));
      return false;
    }
  }

  const base::Value* chrome_style_value = nullptr;
  if (dict->GetWithoutPathExpansion("chrome_style", &chrome_style_value)) {
    {
      bool temp;
      if (!chrome_style_value->GetAsBoolean(&temp)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'chrome_style': expected chrome_style, got " + std::string(base::Value::GetTypeName(chrome_style_value->type())));
        out->chrome_style.reset();
        return false;
      }
      else
        out->chrome_style = std::make_unique<bool>(temp);
    }
  }

  const base::Value* open_in_tab_value = nullptr;
  if (dict->GetWithoutPathExpansion("open_in_tab", &open_in_tab_value)) {
    {
      bool temp;
      if (!open_in_tab_value->GetAsBoolean(&temp)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'open_in_tab': expected open_in_tab, got " + std::string(base::Value::GetTypeName(open_in_tab_value->type())));
        out->open_in_tab.reset();
        return false;
      }
      else
        out->open_in_tab = std::make_unique<bool>(temp);
    }
  }

  return true;
}

// static
std::unique_ptr<OptionsUI> OptionsUI::FromValue(const base::Value& value, base::string16* error) {
  DCHECK(error);
  auto out = std::make_unique<OptionsUI>();
  bool result = Populate(value, out.get(), error);
  DCHECK_EQ(result, error->empty());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> OptionsUI::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("page", std::make_unique<base::Value>(this->page));

  if (this->chrome_style.get()) {
    to_value_result->SetWithoutPathExpansion("chrome_style", std::make_unique<base::Value>(*this->chrome_style));

  }
  if (this->open_in_tab.get()) {
    to_value_result->SetWithoutPathExpansion("open_in_tab", std::make_unique<base::Value>(*this->open_in_tab));

  }

  return to_value_result;
}


SocketHostPatterns::SocketHostPatterns()
 {}

SocketHostPatterns::~SocketHostPatterns() = default;
SocketHostPatterns::SocketHostPatterns(SocketHostPatterns&& rhs) = default;
SocketHostPatterns& SocketHostPatterns::operator=(SocketHostPatterns&& rhs) = default;
// static
bool SocketHostPatterns::Populate(
    const base::Value& value, SocketHostPatterns* out, base::string16* error) {
  DCHECK(error);
  if (value.type() == base::Value::Type::STRING) {
    {
      std::string temp;
      if (!(&value)->GetAsString(&temp)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'string': expected string, got " + std::string(base::Value::GetTypeName((&value)->type())));
        out->as_string.reset();
        return false;
      }
      else
        out->as_string = std::make_unique<std::string>(temp);
    }
    return true;
  }
  if (value.type() == base::Value::Type::LIST) {
    {
      const base::ListValue* list = nullptr;
      if (!(&value)->GetAsList(&list)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'strings': expected list, got " + std::string(base::Value::GetTypeName((&value)->type())));
        return false;
      }
      else {
        base::string16 array_parse_error;
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->as_strings, &array_parse_error)) {
          array_parse_error = base::UTF8ToUTF16("Error at key 'strings': ") + array_parse_error;
          DCHECK(error->empty());
          *error = array_parse_error;
          return false;
        }
      }
    }
    return true;
  }
  DCHECK(error->empty());
  *error = UTF8ToUTF16("expected string or strings, got " +  std::string(base::Value::GetTypeName(value.type())));
  return false;
}

// static
std::unique_ptr<SocketHostPatterns> SocketHostPatterns::FromValue(const base::Value& value, base::string16* error) {
  DCHECK(error);
  auto out = std::make_unique<SocketHostPatterns>();
  bool result = Populate(value, out.get(), error);
  DCHECK_EQ(result, error->empty());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::Value> SocketHostPatterns::ToValue() const {
  std::unique_ptr<base::Value> result;
  if (as_string) {
    DCHECK(!result) << "Cannot set multiple choices for socket_host_patterns";
    result = std::make_unique<base::Value>(*as_string);

  }
  if (as_strings) {
    DCHECK(!result) << "Cannot set multiple choices for socket_host_patterns";
    result = json_schema_compiler::util::CreateValueFromOptionalArray(as_strings);

  }
  DCHECK(result) << "Must set at least one choice for socket_host_patterns";
  return result;
}


Sockets::Udp::Udp()
 {}

Sockets::Udp::~Udp() = default;
Sockets::Udp::Udp(Udp&& rhs) = default;
Sockets::Udp& Sockets::Udp::operator=(Udp&& rhs) = default;
// static
bool Sockets::Udp::Populate(
    const base::Value& value, Udp* out, base::string16* error) {
  DCHECK(error);
  if (!value.is_dict()) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("expected dictionary, got " + std::string(base::Value::GetTypeName(value.type())));
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* bind_value = nullptr;
  if (dict->GetWithoutPathExpansion("bind", &bind_value)) {
    {
      auto temp = std::make_unique<SocketHostPatterns>();
      if (!SocketHostPatterns::Populate(*bind_value, temp.get(), error))
        return false;
      out->bind = std::move(temp);
    }
  }

  const base::Value* send_value = nullptr;
  if (dict->GetWithoutPathExpansion("send", &send_value)) {
    {
      auto temp = std::make_unique<SocketHostPatterns>();
      if (!SocketHostPatterns::Populate(*send_value, temp.get(), error))
        return false;
      out->send = std::move(temp);
    }
  }

  const base::Value* multicast_membership_value = nullptr;
  if (dict->GetWithoutPathExpansion("multicastMembership", &multicast_membership_value)) {
    {
      auto temp = std::make_unique<SocketHostPatterns>();
      if (!SocketHostPatterns::Populate(*multicast_membership_value, temp.get(), error))
        return false;
      out->multicast_membership = std::move(temp);
    }
  }

  return true;
}

std::unique_ptr<base::DictionaryValue> Sockets::Udp::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->bind.get()) {
    to_value_result->SetWithoutPathExpansion("bind", (this->bind)->ToValue());

  }
  if (this->send.get()) {
    to_value_result->SetWithoutPathExpansion("send", (this->send)->ToValue());

  }
  if (this->multicast_membership.get()) {
    to_value_result->SetWithoutPathExpansion("multicastMembership", (this->multicast_membership)->ToValue());

  }

  return to_value_result;
}


Sockets::Tcp::Tcp()
 {}

Sockets::Tcp::~Tcp() = default;
Sockets::Tcp::Tcp(Tcp&& rhs) = default;
Sockets::Tcp& Sockets::Tcp::operator=(Tcp&& rhs) = default;
// static
bool Sockets::Tcp::Populate(
    const base::Value& value, Tcp* out, base::string16* error) {
  DCHECK(error);
  if (!value.is_dict()) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("expected dictionary, got " + std::string(base::Value::GetTypeName(value.type())));
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* connect_value = nullptr;
  if (dict->GetWithoutPathExpansion("connect", &connect_value)) {
    {
      auto temp = std::make_unique<SocketHostPatterns>();
      if (!SocketHostPatterns::Populate(*connect_value, temp.get(), error))
        return false;
      out->connect = std::move(temp);
    }
  }

  return true;
}

std::unique_ptr<base::DictionaryValue> Sockets::Tcp::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->connect.get()) {
    to_value_result->SetWithoutPathExpansion("connect", (this->connect)->ToValue());

  }

  return to_value_result;
}


Sockets::TcpServer::TcpServer()
 {}

Sockets::TcpServer::~TcpServer() = default;
Sockets::TcpServer::TcpServer(TcpServer&& rhs) = default;
Sockets::TcpServer& Sockets::TcpServer::operator=(TcpServer&& rhs) = default;
// static
bool Sockets::TcpServer::Populate(
    const base::Value& value, TcpServer* out, base::string16* error) {
  DCHECK(error);
  if (!value.is_dict()) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("expected dictionary, got " + std::string(base::Value::GetTypeName(value.type())));
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* listen_value = nullptr;
  if (dict->GetWithoutPathExpansion("listen", &listen_value)) {
    {
      auto temp = std::make_unique<SocketHostPatterns>();
      if (!SocketHostPatterns::Populate(*listen_value, temp.get(), error))
        return false;
      out->listen = std::move(temp);
    }
  }

  return true;
}

std::unique_ptr<base::DictionaryValue> Sockets::TcpServer::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->listen.get()) {
    to_value_result->SetWithoutPathExpansion("listen", (this->listen)->ToValue());

  }

  return to_value_result;
}



Sockets::Sockets()
 {}

Sockets::~Sockets() = default;
Sockets::Sockets(Sockets&& rhs) = default;
Sockets& Sockets::operator=(Sockets&& rhs) = default;
// static
bool Sockets::Populate(
    const base::Value& value, Sockets* out, base::string16* error) {
  DCHECK(error);
  if (!value.is_dict()) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("expected dictionary, got " + std::string(base::Value::GetTypeName(value.type())));
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* udp_value = nullptr;
  if (dict->GetWithoutPathExpansion("udp", &udp_value)) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!udp_value->GetAsDictionary(&dictionary)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'udp': expected dictionary, got " + std::string(base::Value::GetTypeName(udp_value->type())));
        return false;
      }
      else {
        auto temp = std::make_unique<Udp>();
        if (!Udp::Populate(*dictionary, temp.get(), error)) {
          return false;
        }
        else
          out->udp = std::move(temp);
      }
    }
  }

  const base::Value* tcp_value = nullptr;
  if (dict->GetWithoutPathExpansion("tcp", &tcp_value)) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!tcp_value->GetAsDictionary(&dictionary)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'tcp': expected dictionary, got " + std::string(base::Value::GetTypeName(tcp_value->type())));
        return false;
      }
      else {
        auto temp = std::make_unique<Tcp>();
        if (!Tcp::Populate(*dictionary, temp.get(), error)) {
          return false;
        }
        else
          out->tcp = std::move(temp);
      }
    }
  }

  const base::Value* tcp_server_value = nullptr;
  if (dict->GetWithoutPathExpansion("tcpServer", &tcp_server_value)) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!tcp_server_value->GetAsDictionary(&dictionary)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'tcpServer': expected dictionary, got " + std::string(base::Value::GetTypeName(tcp_server_value->type())));
        return false;
      }
      else {
        auto temp = std::make_unique<TcpServer>();
        if (!TcpServer::Populate(*dictionary, temp.get(), error)) {
          return false;
        }
        else
          out->tcp_server = std::move(temp);
      }
    }
  }

  return true;
}

// static
std::unique_ptr<Sockets> Sockets::FromValue(const base::Value& value, base::string16* error) {
  DCHECK(error);
  auto out = std::make_unique<Sockets>();
  bool result = Populate(value, out.get(), error);
  DCHECK_EQ(result, error->empty());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> Sockets::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->udp.get()) {
    to_value_result->SetWithoutPathExpansion("udp", (this->udp)->ToValue());

  }
  if (this->tcp.get()) {
    to_value_result->SetWithoutPathExpansion("tcp", (this->tcp)->ToValue());

  }
  if (this->tcp_server.get()) {
    to_value_result->SetWithoutPathExpansion("tcpServer", (this->tcp_server)->ToValue());

  }

  return to_value_result;
}


Bluetooth::Bluetooth()
 {}

Bluetooth::~Bluetooth() = default;
Bluetooth::Bluetooth(Bluetooth&& rhs) = default;
Bluetooth& Bluetooth::operator=(Bluetooth&& rhs) = default;
// static
bool Bluetooth::Populate(
    const base::Value& value, Bluetooth* out, base::string16* error) {
  DCHECK(error);
  if (!value.is_dict()) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("expected dictionary, got " + std::string(base::Value::GetTypeName(value.type())));
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* uuids_value = nullptr;
  if (dict->GetWithoutPathExpansion("uuids", &uuids_value)) {
    {
      const base::ListValue* list = nullptr;
      if (!uuids_value->GetAsList(&list)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'uuids': expected list, got " + std::string(base::Value::GetTypeName(uuids_value->type())));
        return false;
      }
      else {
        base::string16 array_parse_error;
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->uuids, &array_parse_error)) {
          array_parse_error = base::UTF8ToUTF16("Error at key 'uuids': ") + array_parse_error;
          DCHECK(error->empty());
          *error = array_parse_error;
          return false;
        }
      }
    }
  }

  const base::Value* socket_value = nullptr;
  if (dict->GetWithoutPathExpansion("socket", &socket_value)) {
    {
      bool temp;
      if (!socket_value->GetAsBoolean(&temp)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'socket': expected socket, got " + std::string(base::Value::GetTypeName(socket_value->type())));
        out->socket.reset();
        return false;
      }
      else
        out->socket = std::make_unique<bool>(temp);
    }
  }

  const base::Value* low_energy_value = nullptr;
  if (dict->GetWithoutPathExpansion("low_energy", &low_energy_value)) {
    {
      bool temp;
      if (!low_energy_value->GetAsBoolean(&temp)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'low_energy': expected low_energy, got " + std::string(base::Value::GetTypeName(low_energy_value->type())));
        out->low_energy.reset();
        return false;
      }
      else
        out->low_energy = std::make_unique<bool>(temp);
    }
  }

  const base::Value* peripheral_value = nullptr;
  if (dict->GetWithoutPathExpansion("peripheral", &peripheral_value)) {
    {
      bool temp;
      if (!peripheral_value->GetAsBoolean(&temp)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'peripheral': expected peripheral, got " + std::string(base::Value::GetTypeName(peripheral_value->type())));
        out->peripheral.reset();
        return false;
      }
      else
        out->peripheral = std::make_unique<bool>(temp);
    }
  }

  return true;
}

// static
std::unique_ptr<Bluetooth> Bluetooth::FromValue(const base::Value& value, base::string16* error) {
  DCHECK(error);
  auto out = std::make_unique<Bluetooth>();
  bool result = Populate(value, out.get(), error);
  DCHECK_EQ(result, error->empty());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> Bluetooth::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->uuids.get()) {
    to_value_result->SetWithoutPathExpansion("uuids", json_schema_compiler::util::CreateValueFromOptionalArray(this->uuids));

  }
  if (this->socket.get()) {
    to_value_result->SetWithoutPathExpansion("socket", std::make_unique<base::Value>(*this->socket));

  }
  if (this->low_energy.get()) {
    to_value_result->SetWithoutPathExpansion("low_energy", std::make_unique<base::Value>(*this->low_energy));

  }
  if (this->peripheral.get()) {
    to_value_result->SetWithoutPathExpansion("peripheral", std::make_unique<base::Value>(*this->peripheral));

  }

  return to_value_result;
}


UsbPrinters::FiltersType::FiltersType()
: vendor_id(0) {}

UsbPrinters::FiltersType::~FiltersType() = default;
UsbPrinters::FiltersType::FiltersType(FiltersType&& rhs) = default;
UsbPrinters::FiltersType& UsbPrinters::FiltersType::operator=(FiltersType&& rhs) = default;
// static
bool UsbPrinters::FiltersType::Populate(
    const base::Value& value, FiltersType* out, base::string16* error) {
  DCHECK(error);
  if (!value.is_dict()) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("expected dictionary, got " + std::string(base::Value::GetTypeName(value.type())));
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* vendor_id_value = nullptr;
  if (!dict->GetWithoutPathExpansion("vendorId", &vendor_id_value)) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("'vendorId' is required");
    return false;
  }
  {
    if (!vendor_id_value->GetAsInteger(&out->vendor_id)) {
      DCHECK(error->empty());
      *error = UTF8ToUTF16("'vendorId': expected vendorId, got " + std::string(base::Value::GetTypeName(vendor_id_value->type())));
      return false;
    }
  }

  const base::Value* product_id_value = nullptr;
  if (dict->GetWithoutPathExpansion("productId", &product_id_value)) {
    {
      int temp;
      if (!product_id_value->GetAsInteger(&temp)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'productId': expected productId, got " + std::string(base::Value::GetTypeName(product_id_value->type())));
        out->product_id.reset();
        return false;
      }
      else
        out->product_id = std::make_unique<int>(temp);
    }
  }

  const base::Value* interface_class_value = nullptr;
  if (dict->GetWithoutPathExpansion("interfaceClass", &interface_class_value)) {
    {
      int temp;
      if (!interface_class_value->GetAsInteger(&temp)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'interfaceClass': expected interfaceClass, got " + std::string(base::Value::GetTypeName(interface_class_value->type())));
        out->interface_class.reset();
        return false;
      }
      else
        out->interface_class = std::make_unique<int>(temp);
    }
  }

  const base::Value* interface_subclass_value = nullptr;
  if (dict->GetWithoutPathExpansion("interfaceSubclass", &interface_subclass_value)) {
    {
      int temp;
      if (!interface_subclass_value->GetAsInteger(&temp)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'interfaceSubclass': expected interfaceSubclass, got " + std::string(base::Value::GetTypeName(interface_subclass_value->type())));
        out->interface_subclass.reset();
        return false;
      }
      else
        out->interface_subclass = std::make_unique<int>(temp);
    }
  }

  const base::Value* interface_protocol_value = nullptr;
  if (dict->GetWithoutPathExpansion("interfaceProtocol", &interface_protocol_value)) {
    {
      int temp;
      if (!interface_protocol_value->GetAsInteger(&temp)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'interfaceProtocol': expected interfaceProtocol, got " + std::string(base::Value::GetTypeName(interface_protocol_value->type())));
        out->interface_protocol.reset();
        return false;
      }
      else
        out->interface_protocol = std::make_unique<int>(temp);
    }
  }

  return true;
}

std::unique_ptr<base::DictionaryValue> UsbPrinters::FiltersType::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("vendorId", std::make_unique<base::Value>(this->vendor_id));

  if (this->product_id.get()) {
    to_value_result->SetWithoutPathExpansion("productId", std::make_unique<base::Value>(*this->product_id));

  }
  if (this->interface_class.get()) {
    to_value_result->SetWithoutPathExpansion("interfaceClass", std::make_unique<base::Value>(*this->interface_class));

  }
  if (this->interface_subclass.get()) {
    to_value_result->SetWithoutPathExpansion("interfaceSubclass", std::make_unique<base::Value>(*this->interface_subclass));

  }
  if (this->interface_protocol.get()) {
    to_value_result->SetWithoutPathExpansion("interfaceProtocol", std::make_unique<base::Value>(*this->interface_protocol));

  }

  return to_value_result;
}




UsbPrinters::UsbPrinters()
 {}

UsbPrinters::~UsbPrinters() = default;
UsbPrinters::UsbPrinters(UsbPrinters&& rhs) = default;
UsbPrinters& UsbPrinters::operator=(UsbPrinters&& rhs) = default;
// static
bool UsbPrinters::Populate(
    const base::Value& value, UsbPrinters* out, base::string16* error) {
  DCHECK(error);
  if (!value.is_dict()) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("expected dictionary, got " + std::string(base::Value::GetTypeName(value.type())));
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* filters_value = nullptr;
  if (!dict->GetWithoutPathExpansion("filters", &filters_value)) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("'filters' is required");
    return false;
  }
  {
    const base::ListValue* list = nullptr;
    if (!filters_value->GetAsList(&list)) {
      DCHECK(error->empty());
      *error = UTF8ToUTF16("'filters': expected list, got " + std::string(base::Value::GetTypeName(filters_value->type())));
      return false;
    }
    else {
      base::string16 array_parse_error;
      if (!json_schema_compiler::util::PopulateArrayFromList(*list, &out->filters, &array_parse_error)) {
        array_parse_error = base::UTF8ToUTF16("Error at key 'filters': ") + array_parse_error;
        DCHECK(error->empty());
        *error = array_parse_error;
        return false;
      }
    }
  }

  return true;
}

// static
std::unique_ptr<UsbPrinters> UsbPrinters::FromValue(const base::Value& value, base::string16* error) {
  DCHECK(error);
  auto out = std::make_unique<UsbPrinters>();
  bool result = Populate(value, out.get(), error);
  DCHECK_EQ(result, error->empty());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> UsbPrinters::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("filters", json_schema_compiler::util::CreateValueFromArray(this->filters));


  return to_value_result;
}


KioskSecondaryAppsType::KioskSecondaryAppsType()
 {}

KioskSecondaryAppsType::~KioskSecondaryAppsType() = default;
KioskSecondaryAppsType::KioskSecondaryAppsType(KioskSecondaryAppsType&& rhs) = default;
KioskSecondaryAppsType& KioskSecondaryAppsType::operator=(KioskSecondaryAppsType&& rhs) = default;
// static
bool KioskSecondaryAppsType::Populate(
    const base::Value& value, KioskSecondaryAppsType* out, base::string16* error) {
  DCHECK(error);
  if (!value.is_dict()) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("expected dictionary, got " + std::string(base::Value::GetTypeName(value.type())));
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* id_value = nullptr;
  if (!dict->GetWithoutPathExpansion("id", &id_value)) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("'id' is required");
    return false;
  }
  {
    if (!id_value->GetAsString(&out->id)) {
      DCHECK(error->empty());
      *error = UTF8ToUTF16("'id': expected id, got " + std::string(base::Value::GetTypeName(id_value->type())));
      return false;
    }
  }

  const base::Value* enabled_on_launch_value = nullptr;
  if (dict->GetWithoutPathExpansion("enabled_on_launch", &enabled_on_launch_value)) {
    {
      bool temp;
      if (!enabled_on_launch_value->GetAsBoolean(&temp)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'enabled_on_launch': expected enabled_on_launch, got " + std::string(base::Value::GetTypeName(enabled_on_launch_value->type())));
        out->enabled_on_launch.reset();
        return false;
      }
      else
        out->enabled_on_launch = std::make_unique<bool>(temp);
    }
  }

  return true;
}

// static
std::unique_ptr<KioskSecondaryAppsType> KioskSecondaryAppsType::FromValue(const base::Value& value, base::string16* error) {
  DCHECK(error);
  auto out = std::make_unique<KioskSecondaryAppsType>();
  bool result = Populate(value, out.get(), error);
  DCHECK_EQ(result, error->empty());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> KioskSecondaryAppsType::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("id", std::make_unique<base::Value>(this->id));

  if (this->enabled_on_launch.get()) {
    to_value_result->SetWithoutPathExpansion("enabled_on_launch", std::make_unique<base::Value>(*this->enabled_on_launch));

  }

  return to_value_result;
}




}  // namespace extensions_manifest_types
}  // namespace api
}  // namespace extensions

