// Copyright 2022 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// GENERATED FROM THE API DEFINITION IN
//   extensions/common/api/management.json
// DO NOT EDIT.

#include "tools/json_schema_compiler/util.h"
#include "base/check.h"
#include "base/check_op.h"
#include "base/notreached.h"
#include "base/strings/string_number_conversions.h"
#include "base/strings/utf_string_conversions.h"
#include "base/values.h"
#include "extensions/common/api/management.h"
#include <set>
#include <utility>

using base::UTF8ToUTF16;

namespace extensions {
namespace api {
namespace management {
//
// Types
//

IconInfo::IconInfo()
: size(0) {}

IconInfo::~IconInfo() = default;
IconInfo::IconInfo(IconInfo&& rhs) = default;
IconInfo& IconInfo::operator=(IconInfo&& rhs) = default;
// static
bool IconInfo::Populate(
    const base::Value& value, IconInfo* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* size_value = nullptr;
  if (!dict->GetWithoutPathExpansion("size", &size_value)) {
    return false;
  }
  {
    if (!size_value->GetAsInteger(&out->size)) {
      return false;
    }
  }

  const base::Value* url_value = nullptr;
  if (!dict->GetWithoutPathExpansion("url", &url_value)) {
    return false;
  }
  {
    if (!url_value->GetAsString(&out->url)) {
      return false;
    }
  }

  return true;
}

// static
std::unique_ptr<IconInfo> IconInfo::FromValue(const base::Value& value) {
  auto out = std::make_unique<IconInfo>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> IconInfo::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("size", std::make_unique<base::Value>(this->size));

  to_value_result->SetWithoutPathExpansion("url", std::make_unique<base::Value>(this->url));


  return to_value_result;
}


const char* ToString(LaunchType enum_param) {
  switch (enum_param) {
    case LAUNCH_TYPE_OPEN_AS_REGULAR_TAB:
      return "OPEN_AS_REGULAR_TAB";
    case LAUNCH_TYPE_OPEN_AS_PINNED_TAB:
      return "OPEN_AS_PINNED_TAB";
    case LAUNCH_TYPE_OPEN_AS_WINDOW:
      return "OPEN_AS_WINDOW";
    case LAUNCH_TYPE_OPEN_FULL_SCREEN:
      return "OPEN_FULL_SCREEN";
    case LAUNCH_TYPE_NONE:
      return "";
  }
  NOTREACHED();
  return "";
}

LaunchType ParseLaunchType(const std::string& enum_string) {
  if (enum_string == "OPEN_AS_REGULAR_TAB")
    return LAUNCH_TYPE_OPEN_AS_REGULAR_TAB;
  if (enum_string == "OPEN_AS_PINNED_TAB")
    return LAUNCH_TYPE_OPEN_AS_PINNED_TAB;
  if (enum_string == "OPEN_AS_WINDOW")
    return LAUNCH_TYPE_OPEN_AS_WINDOW;
  if (enum_string == "OPEN_FULL_SCREEN")
    return LAUNCH_TYPE_OPEN_FULL_SCREEN;
  return LAUNCH_TYPE_NONE;
}


const char* ToString(ExtensionDisabledReason enum_param) {
  switch (enum_param) {
    case EXTENSION_DISABLED_REASON_UNKNOWN:
      return "unknown";
    case EXTENSION_DISABLED_REASON_PERMISSIONS_INCREASE:
      return "permissions_increase";
    case EXTENSION_DISABLED_REASON_NONE:
      return "";
  }
  NOTREACHED();
  return "";
}

ExtensionDisabledReason ParseExtensionDisabledReason(const std::string& enum_string) {
  if (enum_string == "unknown")
    return EXTENSION_DISABLED_REASON_UNKNOWN;
  if (enum_string == "permissions_increase")
    return EXTENSION_DISABLED_REASON_PERMISSIONS_INCREASE;
  return EXTENSION_DISABLED_REASON_NONE;
}


const char* ToString(ExtensionType enum_param) {
  switch (enum_param) {
    case EXTENSION_TYPE_EXTENSION:
      return "extension";
    case EXTENSION_TYPE_HOSTED_APP:
      return "hosted_app";
    case EXTENSION_TYPE_PACKAGED_APP:
      return "packaged_app";
    case EXTENSION_TYPE_LEGACY_PACKAGED_APP:
      return "legacy_packaged_app";
    case EXTENSION_TYPE_THEME:
      return "theme";
    case EXTENSION_TYPE_LOGIN_SCREEN_EXTENSION:
      return "login_screen_extension";
    case EXTENSION_TYPE_NONE:
      return "";
  }
  NOTREACHED();
  return "";
}

ExtensionType ParseExtensionType(const std::string& enum_string) {
  if (enum_string == "extension")
    return EXTENSION_TYPE_EXTENSION;
  if (enum_string == "hosted_app")
    return EXTENSION_TYPE_HOSTED_APP;
  if (enum_string == "packaged_app")
    return EXTENSION_TYPE_PACKAGED_APP;
  if (enum_string == "legacy_packaged_app")
    return EXTENSION_TYPE_LEGACY_PACKAGED_APP;
  if (enum_string == "theme")
    return EXTENSION_TYPE_THEME;
  if (enum_string == "login_screen_extension")
    return EXTENSION_TYPE_LOGIN_SCREEN_EXTENSION;
  return EXTENSION_TYPE_NONE;
}


const char* ToString(ExtensionInstallType enum_param) {
  switch (enum_param) {
    case EXTENSION_INSTALL_TYPE_ADMIN:
      return "admin";
    case EXTENSION_INSTALL_TYPE_DEVELOPMENT:
      return "development";
    case EXTENSION_INSTALL_TYPE_NORMAL:
      return "normal";
    case EXTENSION_INSTALL_TYPE_SIDELOAD:
      return "sideload";
    case EXTENSION_INSTALL_TYPE_OTHER:
      return "other";
    case EXTENSION_INSTALL_TYPE_NONE:
      return "";
  }
  NOTREACHED();
  return "";
}

ExtensionInstallType ParseExtensionInstallType(const std::string& enum_string) {
  if (enum_string == "admin")
    return EXTENSION_INSTALL_TYPE_ADMIN;
  if (enum_string == "development")
    return EXTENSION_INSTALL_TYPE_DEVELOPMENT;
  if (enum_string == "normal")
    return EXTENSION_INSTALL_TYPE_NORMAL;
  if (enum_string == "sideload")
    return EXTENSION_INSTALL_TYPE_SIDELOAD;
  if (enum_string == "other")
    return EXTENSION_INSTALL_TYPE_OTHER;
  return EXTENSION_INSTALL_TYPE_NONE;
}


ExtensionInfo::ExtensionInfo()
: may_disable(false),
enabled(false),
disabled_reason(EXTENSION_DISABLED_REASON_NONE),
is_app(false),
type(EXTENSION_TYPE_NONE),
offline_enabled(false),
install_type(EXTENSION_INSTALL_TYPE_NONE),
launch_type(LAUNCH_TYPE_NONE) {}

ExtensionInfo::~ExtensionInfo() = default;
ExtensionInfo::ExtensionInfo(ExtensionInfo&& rhs) = default;
ExtensionInfo& ExtensionInfo::operator=(ExtensionInfo&& rhs) = default;
// static
bool ExtensionInfo::Populate(
    const base::Value& value, ExtensionInfo* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  out->disabled_reason = EXTENSION_DISABLED_REASON_NONE;
  out->launch_type = LAUNCH_TYPE_NONE;
  const base::Value* id_value = nullptr;
  if (!dict->GetWithoutPathExpansion("id", &id_value)) {
    return false;
  }
  {
    if (!id_value->GetAsString(&out->id)) {
      return false;
    }
  }

  const base::Value* name_value = nullptr;
  if (!dict->GetWithoutPathExpansion("name", &name_value)) {
    return false;
  }
  {
    if (!name_value->GetAsString(&out->name)) {
      return false;
    }
  }

  const base::Value* short_name_value = nullptr;
  if (!dict->GetWithoutPathExpansion("shortName", &short_name_value)) {
    return false;
  }
  {
    if (!short_name_value->GetAsString(&out->short_name)) {
      return false;
    }
  }

  const base::Value* description_value = nullptr;
  if (!dict->GetWithoutPathExpansion("description", &description_value)) {
    return false;
  }
  {
    if (!description_value->GetAsString(&out->description)) {
      return false;
    }
  }

  const base::Value* version_value = nullptr;
  if (!dict->GetWithoutPathExpansion("version", &version_value)) {
    return false;
  }
  {
    if (!version_value->GetAsString(&out->version)) {
      return false;
    }
  }

  const base::Value* version_name_value = nullptr;
  if (dict->GetWithoutPathExpansion("versionName", &version_name_value)) {
    {
      std::string temp;
      if (!version_name_value->GetAsString(&temp)) {
        out->version_name.reset();
        return false;
      }
      else
        out->version_name = std::make_unique<std::string>(temp);
    }
  }

  const base::Value* may_disable_value = nullptr;
  if (!dict->GetWithoutPathExpansion("mayDisable", &may_disable_value)) {
    return false;
  }
  {
    if (!may_disable_value->GetAsBoolean(&out->may_disable)) {
      return false;
    }
  }

  const base::Value* may_enable_value = nullptr;
  if (dict->GetWithoutPathExpansion("mayEnable", &may_enable_value)) {
    {
      bool temp;
      if (!may_enable_value->GetAsBoolean(&temp)) {
        out->may_enable.reset();
        return false;
      }
      else
        out->may_enable = std::make_unique<bool>(temp);
    }
  }

  const base::Value* enabled_value = nullptr;
  if (!dict->GetWithoutPathExpansion("enabled", &enabled_value)) {
    return false;
  }
  {
    if (!enabled_value->GetAsBoolean(&out->enabled)) {
      return false;
    }
  }

  const base::Value* disabled_reason_value = nullptr;
  if (dict->GetWithoutPathExpansion("disabledReason", &disabled_reason_value)) {
    {
      std::string extension_disabled_reason_as_string;
      if (!disabled_reason_value->GetAsString(&extension_disabled_reason_as_string)) {
        return false;
      }
      out->disabled_reason = ParseExtensionDisabledReason(extension_disabled_reason_as_string);
      if (out->disabled_reason == EXTENSION_DISABLED_REASON_NONE) {
        return false;
      }
    }
    } else {
    out->disabled_reason = EXTENSION_DISABLED_REASON_NONE;
  }

  const base::Value* is_app_value = nullptr;
  if (!dict->GetWithoutPathExpansion("isApp", &is_app_value)) {
    return false;
  }
  {
    if (!is_app_value->GetAsBoolean(&out->is_app)) {
      return false;
    }
  }

  const base::Value* type_value = nullptr;
  if (!dict->GetWithoutPathExpansion("type", &type_value)) {
    return false;
  }
  {
    std::string extension_type_as_string;
    if (!type_value->GetAsString(&extension_type_as_string)) {
      return false;
    }
    out->type = ParseExtensionType(extension_type_as_string);
    if (out->type == EXTENSION_TYPE_NONE) {
      return false;
    }
  }

  const base::Value* app_launch_url_value = nullptr;
  if (dict->GetWithoutPathExpansion("appLaunchUrl", &app_launch_url_value)) {
    {
      std::string temp;
      if (!app_launch_url_value->GetAsString(&temp)) {
        out->app_launch_url.reset();
        return false;
      }
      else
        out->app_launch_url = std::make_unique<std::string>(temp);
    }
  }

  const base::Value* homepage_url_value = nullptr;
  if (dict->GetWithoutPathExpansion("homepageUrl", &homepage_url_value)) {
    {
      std::string temp;
      if (!homepage_url_value->GetAsString(&temp)) {
        out->homepage_url.reset();
        return false;
      }
      else
        out->homepage_url = std::make_unique<std::string>(temp);
    }
  }

  const base::Value* update_url_value = nullptr;
  if (dict->GetWithoutPathExpansion("updateUrl", &update_url_value)) {
    {
      std::string temp;
      if (!update_url_value->GetAsString(&temp)) {
        out->update_url.reset();
        return false;
      }
      else
        out->update_url = std::make_unique<std::string>(temp);
    }
  }

  const base::Value* offline_enabled_value = nullptr;
  if (!dict->GetWithoutPathExpansion("offlineEnabled", &offline_enabled_value)) {
    return false;
  }
  {
    if (!offline_enabled_value->GetAsBoolean(&out->offline_enabled)) {
      return false;
    }
  }

  const base::Value* options_url_value = nullptr;
  if (!dict->GetWithoutPathExpansion("optionsUrl", &options_url_value)) {
    return false;
  }
  {
    if (!options_url_value->GetAsString(&out->options_url)) {
      return false;
    }
  }

  const base::Value* icons_value = nullptr;
  if (dict->GetWithoutPathExpansion("icons", &icons_value)) {
    {
      const base::ListValue* list = nullptr;
      if (!icons_value->GetAsList(&list)) {
        return false;
      }
      else {
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->icons)) {
          return false;
        }
      }
    }
  }

  const base::Value* permissions_value = nullptr;
  if (!dict->GetWithoutPathExpansion("permissions", &permissions_value)) {
    return false;
  }
  {
    const base::ListValue* list = nullptr;
    if (!permissions_value->GetAsList(&list)) {
      return false;
    }
    else {
      if (!json_schema_compiler::util::PopulateArrayFromList(*list, &out->permissions)) {
        return false;
      }
    }
  }

  const base::Value* host_permissions_value = nullptr;
  if (!dict->GetWithoutPathExpansion("hostPermissions", &host_permissions_value)) {
    return false;
  }
  {
    const base::ListValue* list = nullptr;
    if (!host_permissions_value->GetAsList(&list)) {
      return false;
    }
    else {
      if (!json_schema_compiler::util::PopulateArrayFromList(*list, &out->host_permissions)) {
        return false;
      }
    }
  }

  const base::Value* install_type_value = nullptr;
  if (!dict->GetWithoutPathExpansion("installType", &install_type_value)) {
    return false;
  }
  {
    std::string extension_install_type_as_string;
    if (!install_type_value->GetAsString(&extension_install_type_as_string)) {
      return false;
    }
    out->install_type = ParseExtensionInstallType(extension_install_type_as_string);
    if (out->install_type == EXTENSION_INSTALL_TYPE_NONE) {
      return false;
    }
  }

  const base::Value* launch_type_value = nullptr;
  if (dict->GetWithoutPathExpansion("launchType", &launch_type_value)) {
    {
      std::string launch_type_as_string;
      if (!launch_type_value->GetAsString(&launch_type_as_string)) {
        return false;
      }
      out->launch_type = ParseLaunchType(launch_type_as_string);
      if (out->launch_type == LAUNCH_TYPE_NONE) {
        return false;
      }
    }
    } else {
    out->launch_type = LAUNCH_TYPE_NONE;
  }

  const base::Value* available_launch_types_value = nullptr;
  if (dict->GetWithoutPathExpansion("availableLaunchTypes", &available_launch_types_value)) {
    {
      const base::ListValue* list = nullptr;
      if (!available_launch_types_value->GetAsList(&list)) {
        return false;
      }
      else {
        out->available_launch_types = std::make_unique<std::vector<LaunchType>>();
        for (const auto& it : *(list)) {
          LaunchType tmp;
          std::string launch_type_as_string;
          if (!(it).GetAsString(&launch_type_as_string)) {
            return false;
          }
          tmp = ParseLaunchType(launch_type_as_string);
          if (tmp == LAUNCH_TYPE_NONE) {
            return false;
          }
          out->available_launch_types->push_back(tmp);
        }
      }
    }
  }

  return true;
}

// static
std::unique_ptr<ExtensionInfo> ExtensionInfo::FromValue(const base::Value& value) {
  auto out = std::make_unique<ExtensionInfo>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> ExtensionInfo::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("id", std::make_unique<base::Value>(this->id));

  to_value_result->SetWithoutPathExpansion("name", std::make_unique<base::Value>(this->name));

  to_value_result->SetWithoutPathExpansion("shortName", std::make_unique<base::Value>(this->short_name));

  to_value_result->SetWithoutPathExpansion("description", std::make_unique<base::Value>(this->description));

  to_value_result->SetWithoutPathExpansion("version", std::make_unique<base::Value>(this->version));

  if (this->version_name.get()) {
    to_value_result->SetWithoutPathExpansion("versionName", std::make_unique<base::Value>(*this->version_name));

  }
  to_value_result->SetWithoutPathExpansion("mayDisable", std::make_unique<base::Value>(this->may_disable));

  if (this->may_enable.get()) {
    to_value_result->SetWithoutPathExpansion("mayEnable", std::make_unique<base::Value>(*this->may_enable));

  }
  to_value_result->SetWithoutPathExpansion("enabled", std::make_unique<base::Value>(this->enabled));

  if (this->disabled_reason != EXTENSION_DISABLED_REASON_NONE) {
    to_value_result->SetWithoutPathExpansion("disabledReason", std::make_unique<base::Value>(management::ToString(this->disabled_reason)));

  }
  to_value_result->SetWithoutPathExpansion("isApp", std::make_unique<base::Value>(this->is_app));

  to_value_result->SetWithoutPathExpansion("type", std::make_unique<base::Value>(management::ToString(this->type)));

  if (this->app_launch_url.get()) {
    to_value_result->SetWithoutPathExpansion("appLaunchUrl", std::make_unique<base::Value>(*this->app_launch_url));

  }
  if (this->homepage_url.get()) {
    to_value_result->SetWithoutPathExpansion("homepageUrl", std::make_unique<base::Value>(*this->homepage_url));

  }
  if (this->update_url.get()) {
    to_value_result->SetWithoutPathExpansion("updateUrl", std::make_unique<base::Value>(*this->update_url));

  }
  to_value_result->SetWithoutPathExpansion("offlineEnabled", std::make_unique<base::Value>(this->offline_enabled));

  to_value_result->SetWithoutPathExpansion("optionsUrl", std::make_unique<base::Value>(this->options_url));

  if (this->icons.get()) {
    to_value_result->SetWithoutPathExpansion("icons", json_schema_compiler::util::CreateValueFromOptionalArray(this->icons));

  }
  to_value_result->SetWithoutPathExpansion("permissions", json_schema_compiler::util::CreateValueFromArray(this->permissions));

  to_value_result->SetWithoutPathExpansion("hostPermissions", json_schema_compiler::util::CreateValueFromArray(this->host_permissions));

  to_value_result->SetWithoutPathExpansion("installType", std::make_unique<base::Value>(management::ToString(this->install_type)));

  if (this->launch_type != LAUNCH_TYPE_NONE) {
    to_value_result->SetWithoutPathExpansion("launchType", std::make_unique<base::Value>(management::ToString(this->launch_type)));

  }
  if (this->available_launch_types.get()) {
    {
      std::vector<std::string> availableLaunchTypes_list;
      for (const auto& it : *(this->available_launch_types)) {
      availableLaunchTypes_list.push_back(management::ToString(it));
    }
    to_value_result->SetWithoutPathExpansion("availableLaunchTypes", json_schema_compiler::util::CreateValueFromArray(availableLaunchTypes_list));
    }

  }

  return to_value_result;
}


UninstallOptions::UninstallOptions()
 {}

UninstallOptions::~UninstallOptions() = default;
UninstallOptions::UninstallOptions(UninstallOptions&& rhs) = default;
UninstallOptions& UninstallOptions::operator=(UninstallOptions&& rhs) = default;
// static
bool UninstallOptions::Populate(
    const base::Value& value, UninstallOptions* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* show_confirm_dialog_value = nullptr;
  if (dict->GetWithoutPathExpansion("showConfirmDialog", &show_confirm_dialog_value)) {
    {
      bool temp;
      if (!show_confirm_dialog_value->GetAsBoolean(&temp)) {
        out->show_confirm_dialog.reset();
        return false;
      }
      else
        out->show_confirm_dialog = std::make_unique<bool>(temp);
    }
  }

  return true;
}

// static
std::unique_ptr<UninstallOptions> UninstallOptions::FromValue(const base::Value& value) {
  auto out = std::make_unique<UninstallOptions>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> UninstallOptions::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->show_confirm_dialog.get()) {
    to_value_result->SetWithoutPathExpansion("showConfirmDialog", std::make_unique<base::Value>(*this->show_confirm_dialog));

  }

  return to_value_result;
}



//
// Functions
//

namespace GetAll {

std::unique_ptr<base::ListValue> Results::Create(const std::vector<ExtensionInfo>& result) {
  auto create_results = std::make_unique<base::ListValue>();
  create_results->Append(json_schema_compiler::util::CreateValueFromArray(result));

  return create_results;
}
}  // namespace GetAll

namespace Get {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* id_value = nullptr;
  if (args.Get(0, &id_value) &&
      !id_value->is_none()) {
    {
      if (!id_value->GetAsString(&params->id)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::unique_ptr<base::ListValue> Results::Create(const ExtensionInfo& result) {
  auto create_results = std::make_unique<base::ListValue>();
  create_results->Append((result).ToValue());

  return create_results;
}
}  // namespace Get

namespace GetSelf {

std::unique_ptr<base::ListValue> Results::Create(const ExtensionInfo& result) {
  auto create_results = std::make_unique<base::ListValue>();
  create_results->Append((result).ToValue());

  return create_results;
}
}  // namespace GetSelf

namespace GetPermissionWarningsById {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* id_value = nullptr;
  if (args.Get(0, &id_value) &&
      !id_value->is_none()) {
    {
      if (!id_value->GetAsString(&params->id)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::unique_ptr<base::ListValue> Results::Create(const std::vector<std::string>& permission_warnings) {
  auto create_results = std::make_unique<base::ListValue>();
  create_results->Append(json_schema_compiler::util::CreateValueFromArray(permission_warnings));

  return create_results;
}
}  // namespace GetPermissionWarningsById

namespace GetPermissionWarningsByManifest {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* manifest_str_value = nullptr;
  if (args.Get(0, &manifest_str_value) &&
      !manifest_str_value->is_none()) {
    {
      if (!manifest_str_value->GetAsString(&params->manifest_str)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::unique_ptr<base::ListValue> Results::Create(const std::vector<std::string>& permission_warnings) {
  auto create_results = std::make_unique<base::ListValue>();
  create_results->Append(json_schema_compiler::util::CreateValueFromArray(permission_warnings));

  return create_results;
}
}  // namespace GetPermissionWarningsByManifest

namespace SetEnabled {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* id_value = nullptr;
  if (args.Get(0, &id_value) &&
      !id_value->is_none()) {
    {
      if (!id_value->GetAsString(&params->id)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* enabled_value = nullptr;
  if (args.Get(1, &enabled_value) &&
      !enabled_value->is_none()) {
    {
      if (!enabled_value->GetAsBoolean(&params->enabled)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::unique_ptr<base::ListValue> Results::Create() {
  auto create_results = std::make_unique<base::ListValue>();
  return create_results;
}
}  // namespace SetEnabled

namespace Uninstall {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() < 1 || args.GetSize() > 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* id_value = nullptr;
  if (args.Get(0, &id_value) &&
      !id_value->is_none()) {
    {
      if (!id_value->GetAsString(&params->id)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* options_value = nullptr;
  if (args.Get(1, &options_value) &&
      !options_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!options_value->GetAsDictionary(&dictionary)) {
        return std::unique_ptr<Params>();
      }
      else {
        auto temp = std::make_unique<UninstallOptions>();
        if (!UninstallOptions::Populate(*dictionary, temp.get())) {
          return std::unique_ptr<Params>();
        }
        else
          params->options = std::move(temp);
      }
    }
  }

  return params;
}


std::unique_ptr<base::ListValue> Results::Create() {
  auto create_results = std::make_unique<base::ListValue>();
  return create_results;
}
}  // namespace Uninstall

namespace UninstallSelf {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() > 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* options_value = nullptr;
  if (args.Get(0, &options_value) &&
      !options_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!options_value->GetAsDictionary(&dictionary)) {
        return std::unique_ptr<Params>();
      }
      else {
        auto temp = std::make_unique<UninstallOptions>();
        if (!UninstallOptions::Populate(*dictionary, temp.get())) {
          return std::unique_ptr<Params>();
        }
        else
          params->options = std::move(temp);
      }
    }
  }

  return params;
}


std::unique_ptr<base::ListValue> Results::Create() {
  auto create_results = std::make_unique<base::ListValue>();
  return create_results;
}
}  // namespace UninstallSelf

namespace LaunchApp {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* id_value = nullptr;
  if (args.Get(0, &id_value) &&
      !id_value->is_none()) {
    {
      if (!id_value->GetAsString(&params->id)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::unique_ptr<base::ListValue> Results::Create() {
  auto create_results = std::make_unique<base::ListValue>();
  return create_results;
}
}  // namespace LaunchApp

namespace CreateAppShortcut {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* id_value = nullptr;
  if (args.Get(0, &id_value) &&
      !id_value->is_none()) {
    {
      if (!id_value->GetAsString(&params->id)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::unique_ptr<base::ListValue> Results::Create() {
  auto create_results = std::make_unique<base::ListValue>();
  return create_results;
}
}  // namespace CreateAppShortcut

namespace SetLaunchType {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* id_value = nullptr;
  if (args.Get(0, &id_value) &&
      !id_value->is_none()) {
    {
      if (!id_value->GetAsString(&params->id)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* launch_type_value = nullptr;
  if (args.Get(1, &launch_type_value) &&
      !launch_type_value->is_none()) {
    {
      std::string launch_type_as_string;
      if (!launch_type_value->GetAsString(&launch_type_as_string)) {
        return std::unique_ptr<Params>();
      }
      params->launch_type = ParseLaunchType(launch_type_as_string);
      if (params->launch_type == LAUNCH_TYPE_NONE) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::unique_ptr<base::ListValue> Results::Create() {
  auto create_results = std::make_unique<base::ListValue>();
  return create_results;
}
}  // namespace SetLaunchType

namespace GenerateAppForLink {

Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* url_value = nullptr;
  if (args.Get(0, &url_value) &&
      !url_value->is_none()) {
    {
      if (!url_value->GetAsString(&params->url)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  const base::Value* title_value = nullptr;
  if (args.Get(1, &title_value) &&
      !title_value->is_none()) {
    {
      if (!title_value->GetAsString(&params->title)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::unique_ptr<base::ListValue> Results::Create(const ExtensionInfo& result) {
  auto create_results = std::make_unique<base::ListValue>();
  create_results->Append((result).ToValue());

  return create_results;
}
}  // namespace GenerateAppForLink

namespace CanInstallReplacementAndroidApp {

std::unique_ptr<base::ListValue> Results::Create(bool result) {
  auto create_results = std::make_unique<base::ListValue>();
  create_results->Append(std::make_unique<base::Value>(result));

  return create_results;
}
}  // namespace CanInstallReplacementAndroidApp

namespace InstallReplacementAndroidApp {

std::unique_ptr<base::ListValue> Results::Create() {
  auto create_results = std::make_unique<base::ListValue>();
  return create_results;
}
}  // namespace InstallReplacementAndroidApp

namespace InstallReplacementWebApp {

std::unique_ptr<base::ListValue> Results::Create() {
  auto create_results = std::make_unique<base::ListValue>();
  return create_results;
}
}  // namespace InstallReplacementWebApp

//
// Events
//

namespace OnInstalled {

const char kEventName[] = "management.onInstalled";

std::unique_ptr<base::ListValue> Create(const ExtensionInfo& info) {
  auto create_results = std::make_unique<base::ListValue>();
  create_results->Append((info).ToValue());

  return create_results;
}

}  // namespace OnInstalled

namespace OnUninstalled {

const char kEventName[] = "management.onUninstalled";

std::unique_ptr<base::ListValue> Create(const std::string& id) {
  auto create_results = std::make_unique<base::ListValue>();
  create_results->Append(std::make_unique<base::Value>(id));

  return create_results;
}

}  // namespace OnUninstalled

namespace OnEnabled {

const char kEventName[] = "management.onEnabled";

std::unique_ptr<base::ListValue> Create(const ExtensionInfo& info) {
  auto create_results = std::make_unique<base::ListValue>();
  create_results->Append((info).ToValue());

  return create_results;
}

}  // namespace OnEnabled

namespace OnDisabled {

const char kEventName[] = "management.onDisabled";

std::unique_ptr<base::ListValue> Create(const ExtensionInfo& info) {
  auto create_results = std::make_unique<base::ListValue>();
  create_results->Append((info).ToValue());

  return create_results;
}

}  // namespace OnDisabled

}  // namespace management
}  // namespace api
}  // namespace extensions

