// Copyright 2022 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// GENERATED FROM THE API DEFINITION IN
//   extensions/common/api/shared_module.idl
// DO NOT EDIT.

#include "tools/json_schema_compiler/util.h"
#include "base/check.h"
#include "base/check_op.h"
#include "base/notreached.h"
#include "base/strings/string_number_conversions.h"
#include "base/strings/utf_string_conversions.h"
#include "base/values.h"
#include "extensions/common/api/shared_module.h"
#include <set>
#include <utility>
#include "tools/json_schema_compiler/manifest_parse_util.h"

#include "base/strings/string_piece.h"


using base::UTF8ToUTF16;

namespace extensions {
namespace api {
namespace shared_module {
//
// Types
//

Import::Import()
 {}

Import::~Import() = default;
Import::Import(Import&& rhs) = default;
Import& Import::operator=(Import&& rhs) = default;
// static
constexpr char Import::kId[];
// static
constexpr char Import::kMinimumVersion[];

// static
bool Import::Populate(
    const base::Value& value, Import* out, base::string16* error) {
  DCHECK(error);
  if (!value.is_dict()) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("expected dictionary, got " + std::string(base::Value::GetTypeName(value.type())));
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* id_value = nullptr;
  if (!dict->GetWithoutPathExpansion("id", &id_value)) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("'id' is required");
    return false;
  }
  {
    if (!id_value->GetAsString(&out->id)) {
      DCHECK(error->empty());
      *error = UTF8ToUTF16("'id': expected id, got " + std::string(base::Value::GetTypeName(id_value->type())));
      return false;
    }
  }

  const base::Value* minimum_version_value = nullptr;
  if (dict->GetWithoutPathExpansion("minimum_version", &minimum_version_value)) {
    {
      std::string temp;
      if (!minimum_version_value->GetAsString(&temp)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'minimum_version': expected minimum_version, got " + std::string(base::Value::GetTypeName(minimum_version_value->type())));
        out->minimum_version.reset();
        return false;
      }
      else
        out->minimum_version = std::make_unique<std::string>(temp);
    }
  }

  return true;
}

// static
std::unique_ptr<Import> Import::FromValue(const base::Value& value, base::string16* error) {
  DCHECK(error);
  auto out = std::make_unique<Import>();
  bool result = Populate(value, out.get(), error);
  DCHECK_EQ(result, error->empty());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> Import::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("id", std::make_unique<base::Value>(this->id));

  if (this->minimum_version.get()) {
    to_value_result->SetWithoutPathExpansion("minimum_version", std::make_unique<base::Value>(*this->minimum_version));

  }

  return to_value_result;
}

//static
bool Import::ParseFromDictionary(
const base::DictionaryValue& root_dict, base::StringPiece key, Import* out, base::string16* error, std::vector<base::StringPiece>* error_path_reversed) {
  DCHECK(out);
  DCHECK(error);
  DCHECK(error_path_reversed);

  const base::Value* value = ::json_schema_compiler::manifest_parse_util::FindKeyOfType(root_dict, key, base::Value::Type::DICTIONARY, error, error_path_reversed);
  if (!value)
    return false;
  const base::DictionaryValue& dict = base::Value::AsDictionaryValue(*value);
  if (!::json_schema_compiler::manifest_parse_util::ParseFromDictionary(dict, kId, &out->id, error, error_path_reversed)) {
    error_path_reversed->push_back(key);
    return false;
  }

  if (!::json_schema_compiler::manifest_parse_util::ParseFromDictionary(dict, kMinimumVersion, &out->minimum_version, error, error_path_reversed)) {
    error_path_reversed->push_back(key);
    return false;
  }

  return true;
}


Export::Export()
 {}

Export::~Export() = default;
Export::Export(Export&& rhs) = default;
Export& Export::operator=(Export&& rhs) = default;
// static
constexpr char Export::kAllowlist[];

// static
bool Export::Populate(
    const base::Value& value, Export* out, base::string16* error) {
  DCHECK(error);
  if (!value.is_dict()) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("expected dictionary, got " + std::string(base::Value::GetTypeName(value.type())));
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* allowlist_value = nullptr;
  if (dict->GetWithoutPathExpansion("allowlist", &allowlist_value)) {
    {
      const base::ListValue* list = nullptr;
      if (!allowlist_value->GetAsList(&list)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'allowlist': expected list, got " + std::string(base::Value::GetTypeName(allowlist_value->type())));
        return false;
      }
      else {
        base::string16 array_parse_error;
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->allowlist, &array_parse_error)) {
          array_parse_error = base::UTF8ToUTF16("Error at key 'allowlist': ") + array_parse_error;
          DCHECK(error->empty());
          *error = array_parse_error;
          return false;
        }
      }
    }
  }

  return true;
}

// static
std::unique_ptr<Export> Export::FromValue(const base::Value& value, base::string16* error) {
  DCHECK(error);
  auto out = std::make_unique<Export>();
  bool result = Populate(value, out.get(), error);
  DCHECK_EQ(result, error->empty());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> Export::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->allowlist.get()) {
    to_value_result->SetWithoutPathExpansion("allowlist", json_schema_compiler::util::CreateValueFromOptionalArray(this->allowlist));

  }

  return to_value_result;
}

//static
bool Export::ParseFromDictionary(
const base::DictionaryValue& root_dict, base::StringPiece key, Export* out, base::string16* error, std::vector<base::StringPiece>* error_path_reversed) {
  DCHECK(out);
  DCHECK(error);
  DCHECK(error_path_reversed);

  const base::Value* value = ::json_schema_compiler::manifest_parse_util::FindKeyOfType(root_dict, key, base::Value::Type::DICTIONARY, error, error_path_reversed);
  if (!value)
    return false;
  const base::DictionaryValue& dict = base::Value::AsDictionaryValue(*value);
  if (!::json_schema_compiler::manifest_parse_util::ParseFromDictionary(dict, kAllowlist, &out->allowlist, error, error_path_reversed)) {
    error_path_reversed->push_back(key);
    return false;
  }

  return true;
}



//
// Manifest Keys
//

ManifestKeys::ManifestKeys()
 {}

ManifestKeys::~ManifestKeys() = default;
ManifestKeys::ManifestKeys(ManifestKeys&& rhs) = default;
ManifestKeys& ManifestKeys::operator=(ManifestKeys&& rhs) = default;
// static
constexpr char ManifestKeys::kImport[];
// static
constexpr char ManifestKeys::kExport[];

//static
bool ManifestKeys::ParseFromDictionary(
const base::DictionaryValue& root_dict, ManifestKeys* out, base::string16* error) {
  DCHECK(out);
  DCHECK(error);

  std::vector<base::StringPiece> error_path_reversed_vec;
  auto* error_path_reversed = &error_path_reversed_vec;
  const base::DictionaryValue& dict = root_dict;
  if (!::json_schema_compiler::manifest_parse_util::ParseFromDictionary(dict, kImport, &out->import, error, error_path_reversed)) {
    ::json_schema_compiler::manifest_parse_util::PopulateFinalError(error, error_path_reversed);
    return false;
  }

  if (!::json_schema_compiler::manifest_parse_util::ParseFromDictionary(dict, kExport, &out->export_, error, error_path_reversed)) {
    ::json_schema_compiler::manifest_parse_util::PopulateFinalError(error, error_path_reversed);
    return false;
  }

  return true;
}


}  // namespace shared_module
}  // namespace api
}  // namespace extensions

