// Copyright 2022 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// GENERATED FROM THE API DEFINITION IN
//   extensions/common/api/storage.json
// DO NOT EDIT.

#include "tools/json_schema_compiler/util.h"
#include "base/check.h"
#include "base/check_op.h"
#include "base/notreached.h"
#include "base/strings/string_number_conversions.h"
#include "base/strings/utf_string_conversions.h"
#include "base/values.h"
#include "extensions/common/api/storage.h"
#include <set>
#include <utility>

using base::UTF8ToUTF16;

namespace extensions {
namespace api {
namespace storage {
//
// Properties
//

namespace sync {
  const int QUOTA_BYTES = 102400;
  const int QUOTA_BYTES_PER_ITEM = 8192;
  const int MAX_ITEMS = 512;
  const int MAX_WRITE_OPERATIONS_PER_HOUR = 1800;
  const int MAX_WRITE_OPERATIONS_PER_MINUTE = 120;
  const int MAX_SUSTAINED_WRITE_OPERATIONS_PER_MINUTE = 1000000;
}  // namespace sync

namespace local {
  const int QUOTA_BYTES = 5242880;
}  // namespace local

//
// Types
//

StorageChange::StorageChange()
 {}

StorageChange::~StorageChange() = default;
StorageChange::StorageChange(StorageChange&& rhs) = default;
StorageChange& StorageChange::operator=(StorageChange&& rhs) = default;
// static
bool StorageChange::Populate(
    const base::Value& value, StorageChange* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* old_value_value = nullptr;
  if (dict->GetWithoutPathExpansion("oldValue", &old_value_value)) {
    {
      out->old_value = old_value_value->CreateDeepCopy();
    }
  }

  const base::Value* new_value_value = nullptr;
  if (dict->GetWithoutPathExpansion("newValue", &new_value_value)) {
    {
      out->new_value = new_value_value->CreateDeepCopy();
    }
  }

  return true;
}

// static
std::unique_ptr<StorageChange> StorageChange::FromValue(const base::Value& value) {
  auto out = std::make_unique<StorageChange>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> StorageChange::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  if (this->old_value.get()) {
    to_value_result->SetWithoutPathExpansion("oldValue", (this->old_value)->CreateDeepCopy());

  }
  if (this->new_value.get()) {
    to_value_result->SetWithoutPathExpansion("newValue", (this->new_value)->CreateDeepCopy());

  }

  return to_value_result;
}


namespace StorageArea {

namespace Get {

Params::Keys::Object::Object()
 {}

Params::Keys::Object::~Object() = default;
Params::Keys::Object::Object(Object&& rhs) = default;
Params::Keys::Object& Params::Keys::Object::operator=(Object&& rhs) = default;
// static
bool Params::Keys::Object::Populate(
    const base::Value& value, Object* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  out->additional_properties.MergeDictionary(dict);
  return true;
}



Params::Keys::Keys()
 {}

Params::Keys::~Keys() = default;
Params::Keys::Keys(Keys&& rhs) = default;
Params::Keys& Params::Keys::operator=(Keys&& rhs) = default;
// static
bool Params::Keys::Populate(
    const base::Value& value, Keys* out) {
  if (value.type() == base::Value::Type::STRING) {
    {
      std::string temp;
      if (!(&value)->GetAsString(&temp)) {
        out->as_string.reset();
        return false;
      }
      else
        out->as_string = std::make_unique<std::string>(temp);
    }
    return true;
  }
  if (value.type() == base::Value::Type::LIST) {
    {
      const base::ListValue* list = nullptr;
      if (!(&value)->GetAsList(&list)) {
        return false;
      }
      else {
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->as_strings)) {
          return false;
        }
      }
    }
    return true;
  }
  if (value.type() == base::Value::Type::DICTIONARY) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!(&value)->GetAsDictionary(&dictionary)) {
        return false;
      }
      else {
        auto temp = std::make_unique<Object>();
        if (!Object::Populate(*dictionary, temp.get())) {
          return false;
        }
        else
          out->as_object = std::move(temp);
      }
    }
    return true;
  }
  return false;
}


Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() > 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* keys_value = nullptr;
  if (args.Get(0, &keys_value) &&
      !keys_value->is_none()) {
    {
      auto temp = std::make_unique<Keys>();
      if (!Keys::Populate(*keys_value, temp.get()))
        return std::unique_ptr<Params>();
      params->keys = std::move(temp);
    }
  }

  return params;
}


Results::Items::Items()
 {}

Results::Items::~Items() = default;
Results::Items::Items(Items&& rhs) = default;
Results::Items& Results::Items::operator=(Items&& rhs) = default;
std::unique_ptr<base::DictionaryValue> Results::Items::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->MergeDictionary(&additional_properties);

  return to_value_result;
}


std::unique_ptr<base::ListValue> Results::Create(const Items& items) {
  auto create_results = std::make_unique<base::ListValue>();
  create_results->Append((items).ToValue());

  return create_results;
}
}  // namespace Get

namespace GetBytesInUse {

Params::Keys::Keys()
 {}

Params::Keys::~Keys() = default;
Params::Keys::Keys(Keys&& rhs) = default;
Params::Keys& Params::Keys::operator=(Keys&& rhs) = default;
// static
bool Params::Keys::Populate(
    const base::Value& value, Keys* out) {
  if (value.type() == base::Value::Type::STRING) {
    {
      std::string temp;
      if (!(&value)->GetAsString(&temp)) {
        out->as_string.reset();
        return false;
      }
      else
        out->as_string = std::make_unique<std::string>(temp);
    }
    return true;
  }
  if (value.type() == base::Value::Type::LIST) {
    {
      const base::ListValue* list = nullptr;
      if (!(&value)->GetAsList(&list)) {
        return false;
      }
      else {
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->as_strings)) {
          return false;
        }
      }
    }
    return true;
  }
  return false;
}


Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() > 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* keys_value = nullptr;
  if (args.Get(0, &keys_value) &&
      !keys_value->is_none()) {
    {
      auto temp = std::make_unique<Keys>();
      if (!Keys::Populate(*keys_value, temp.get()))
        return std::unique_ptr<Params>();
      params->keys = std::move(temp);
    }
  }

  return params;
}


std::unique_ptr<base::ListValue> Results::Create(int bytes_in_use) {
  auto create_results = std::make_unique<base::ListValue>();
  create_results->Append(std::make_unique<base::Value>(bytes_in_use));

  return create_results;
}
}  // namespace GetBytesInUse

namespace Set {

Params::Items::Items()
 {}

Params::Items::~Items() = default;
Params::Items::Items(Items&& rhs) = default;
Params::Items& Params::Items::operator=(Items&& rhs) = default;
// static
bool Params::Items::Populate(
    const base::Value& value, Items* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  out->additional_properties.MergeDictionary(dict);
  return true;
}


Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* items_value = nullptr;
  if (args.Get(0, &items_value) &&
      !items_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!items_value->GetAsDictionary(&dictionary)) {
        return std::unique_ptr<Params>();
      }
      if (!Items::Populate(*dictionary, &params->items)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::unique_ptr<base::ListValue> Results::Create() {
  auto create_results = std::make_unique<base::ListValue>();
  return create_results;
}
}  // namespace Set

namespace Remove {

Params::Keys::Keys()
 {}

Params::Keys::~Keys() = default;
Params::Keys::Keys(Keys&& rhs) = default;
Params::Keys& Params::Keys::operator=(Keys&& rhs) = default;
// static
bool Params::Keys::Populate(
    const base::Value& value, Keys* out) {
  if (value.type() == base::Value::Type::STRING) {
    {
      std::string temp;
      if (!(&value)->GetAsString(&temp)) {
        out->as_string.reset();
        return false;
      }
      else
        out->as_string = std::make_unique<std::string>(temp);
    }
    return true;
  }
  if (value.type() == base::Value::Type::LIST) {
    {
      const base::ListValue* list = nullptr;
      if (!(&value)->GetAsList(&list)) {
        return false;
      }
      else {
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->as_strings)) {
          return false;
        }
      }
    }
    return true;
  }
  return false;
}


Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* keys_value = nullptr;
  if (args.Get(0, &keys_value) &&
      !keys_value->is_none()) {
    {
      if (!Keys::Populate(*keys_value, &params->keys))
        return std::unique_ptr<Params>();
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::unique_ptr<base::ListValue> Results::Create() {
  auto create_results = std::make_unique<base::ListValue>();
  return create_results;
}
}  // namespace Remove

namespace Clear {

std::unique_ptr<base::ListValue> Results::Create() {
  auto create_results = std::make_unique<base::ListValue>();
  return create_results;
}
}  // namespace Clear

}  // namespace StorageArea


//
// Events
//

namespace OnChanged {

const char kEventName[] = "storage.onChanged";

Changes::Changes()
 {}

Changes::~Changes() = default;
Changes::Changes(Changes&& rhs) = default;
Changes& Changes::operator=(Changes&& rhs) = default;
std::unique_ptr<base::DictionaryValue> Changes::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  for (const auto& it : additional_properties) {
    to_value_result->SetWithoutPathExpansion(it.first, (it.second).ToValue());

  }

  return to_value_result;
}


std::unique_ptr<base::ListValue> Create(const Changes& changes, const std::string& area_name) {
  auto create_results = std::make_unique<base::ListValue>();
  create_results->Append((changes).ToValue());

  create_results->Append(std::make_unique<base::Value>(area_name));

  return create_results;
}

}  // namespace OnChanged

}  // namespace storage
}  // namespace api
}  // namespace extensions

