// Copyright 2022 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// GENERATED FROM THE API DEFINITION IN
//   extensions/common/api/system_cpu.idl
// DO NOT EDIT.

#include "tools/json_schema_compiler/util.h"
#include "base/check.h"
#include "base/check_op.h"
#include "base/notreached.h"
#include "base/strings/string_number_conversions.h"
#include "base/strings/utf_string_conversions.h"
#include "base/values.h"
#include "extensions/common/api/system_cpu.h"
#include <set>
#include <utility>

using base::UTF8ToUTF16;

namespace extensions {
namespace api {
namespace system_cpu {
//
// Types
//

CpuTime::CpuTime()
: user(0.0),
kernel(0.0),
idle(0.0),
total(0.0) {}

CpuTime::~CpuTime() = default;
CpuTime::CpuTime(CpuTime&& rhs) = default;
CpuTime& CpuTime::operator=(CpuTime&& rhs) = default;
// static
bool CpuTime::Populate(
    const base::Value& value, CpuTime* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* user_value = nullptr;
  if (!dict->GetWithoutPathExpansion("user", &user_value)) {
    return false;
  }
  {
    if (!user_value->GetAsDouble(&out->user)) {
      return false;
    }
  }

  const base::Value* kernel_value = nullptr;
  if (!dict->GetWithoutPathExpansion("kernel", &kernel_value)) {
    return false;
  }
  {
    if (!kernel_value->GetAsDouble(&out->kernel)) {
      return false;
    }
  }

  const base::Value* idle_value = nullptr;
  if (!dict->GetWithoutPathExpansion("idle", &idle_value)) {
    return false;
  }
  {
    if (!idle_value->GetAsDouble(&out->idle)) {
      return false;
    }
  }

  const base::Value* total_value = nullptr;
  if (!dict->GetWithoutPathExpansion("total", &total_value)) {
    return false;
  }
  {
    if (!total_value->GetAsDouble(&out->total)) {
      return false;
    }
  }

  return true;
}

// static
std::unique_ptr<CpuTime> CpuTime::FromValue(const base::Value& value) {
  auto out = std::make_unique<CpuTime>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> CpuTime::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("user", std::make_unique<base::Value>(this->user));

  to_value_result->SetWithoutPathExpansion("kernel", std::make_unique<base::Value>(this->kernel));

  to_value_result->SetWithoutPathExpansion("idle", std::make_unique<base::Value>(this->idle));

  to_value_result->SetWithoutPathExpansion("total", std::make_unique<base::Value>(this->total));


  return to_value_result;
}


ProcessorInfo::ProcessorInfo()
 {}

ProcessorInfo::~ProcessorInfo() = default;
ProcessorInfo::ProcessorInfo(ProcessorInfo&& rhs) = default;
ProcessorInfo& ProcessorInfo::operator=(ProcessorInfo&& rhs) = default;
// static
bool ProcessorInfo::Populate(
    const base::Value& value, ProcessorInfo* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* usage_value = nullptr;
  if (!dict->GetWithoutPathExpansion("usage", &usage_value)) {
    return false;
  }
  {
    const base::DictionaryValue* dictionary = nullptr;
    if (!usage_value->GetAsDictionary(&dictionary)) {
      return false;
    }
    if (!CpuTime::Populate(*dictionary, &out->usage)) {
      return false;
    }
  }

  return true;
}

// static
std::unique_ptr<ProcessorInfo> ProcessorInfo::FromValue(const base::Value& value) {
  auto out = std::make_unique<ProcessorInfo>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> ProcessorInfo::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("usage", (this->usage).ToValue());


  return to_value_result;
}


CpuInfo::CpuInfo()
: num_of_processors(0) {}

CpuInfo::~CpuInfo() = default;
CpuInfo::CpuInfo(CpuInfo&& rhs) = default;
CpuInfo& CpuInfo::operator=(CpuInfo&& rhs) = default;
// static
bool CpuInfo::Populate(
    const base::Value& value, CpuInfo* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* num_of_processors_value = nullptr;
  if (!dict->GetWithoutPathExpansion("numOfProcessors", &num_of_processors_value)) {
    return false;
  }
  {
    if (!num_of_processors_value->GetAsInteger(&out->num_of_processors)) {
      return false;
    }
  }

  const base::Value* arch_name_value = nullptr;
  if (!dict->GetWithoutPathExpansion("archName", &arch_name_value)) {
    return false;
  }
  {
    if (!arch_name_value->GetAsString(&out->arch_name)) {
      return false;
    }
  }

  const base::Value* model_name_value = nullptr;
  if (!dict->GetWithoutPathExpansion("modelName", &model_name_value)) {
    return false;
  }
  {
    if (!model_name_value->GetAsString(&out->model_name)) {
      return false;
    }
  }

  const base::Value* features_value = nullptr;
  if (!dict->GetWithoutPathExpansion("features", &features_value)) {
    return false;
  }
  {
    const base::ListValue* list = nullptr;
    if (!features_value->GetAsList(&list)) {
      return false;
    }
    else {
      if (!json_schema_compiler::util::PopulateArrayFromList(*list, &out->features)) {
        return false;
      }
    }
  }

  const base::Value* processors_value = nullptr;
  if (!dict->GetWithoutPathExpansion("processors", &processors_value)) {
    return false;
  }
  {
    const base::ListValue* list = nullptr;
    if (!processors_value->GetAsList(&list)) {
      return false;
    }
    else {
      if (!json_schema_compiler::util::PopulateArrayFromList(*list, &out->processors)) {
        return false;
      }
    }
  }

  const base::Value* temperatures_value = nullptr;
  if (!dict->GetWithoutPathExpansion("temperatures", &temperatures_value)) {
    return false;
  }
  {
    const base::ListValue* list = nullptr;
    if (!temperatures_value->GetAsList(&list)) {
      return false;
    }
    else {
      if (!json_schema_compiler::util::PopulateArrayFromList(*list, &out->temperatures)) {
        return false;
      }
    }
  }

  return true;
}

// static
std::unique_ptr<CpuInfo> CpuInfo::FromValue(const base::Value& value) {
  auto out = std::make_unique<CpuInfo>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> CpuInfo::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("numOfProcessors", std::make_unique<base::Value>(this->num_of_processors));

  to_value_result->SetWithoutPathExpansion("archName", std::make_unique<base::Value>(this->arch_name));

  to_value_result->SetWithoutPathExpansion("modelName", std::make_unique<base::Value>(this->model_name));

  to_value_result->SetWithoutPathExpansion("features", json_schema_compiler::util::CreateValueFromArray(this->features));

  to_value_result->SetWithoutPathExpansion("processors", json_schema_compiler::util::CreateValueFromArray(this->processors));

  to_value_result->SetWithoutPathExpansion("temperatures", json_schema_compiler::util::CreateValueFromArray(this->temperatures));


  return to_value_result;
}



//
// Functions
//

namespace GetInfo {

std::unique_ptr<base::ListValue> Results::Create(const CpuInfo& info) {
  auto create_results = std::make_unique<base::ListValue>();
  create_results->Append((info).ToValue());

  return create_results;
}
}  // namespace GetInfo

}  // namespace system_cpu
}  // namespace api
}  // namespace extensions

