// Copyright 2022 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// GENERATED FROM THE API DEFINITION IN
//   extensions/common/api/web_accessible_resources.idl
// DO NOT EDIT.

#include "tools/json_schema_compiler/util.h"
#include "base/check.h"
#include "base/check_op.h"
#include "base/notreached.h"
#include "base/strings/string_number_conversions.h"
#include "base/strings/utf_string_conversions.h"
#include "base/values.h"
#include "extensions/common/api/web_accessible_resources.h"
#include <set>
#include <utility>
#include "tools/json_schema_compiler/manifest_parse_util.h"

#include "base/strings/string_piece.h"


using base::UTF8ToUTF16;

namespace extensions {
namespace api {
namespace web_accessible_resources {
//
// Types
//

WebAccessibleResource::WebAccessibleResource()
 {}

WebAccessibleResource::~WebAccessibleResource() = default;
WebAccessibleResource::WebAccessibleResource(WebAccessibleResource&& rhs) = default;
WebAccessibleResource& WebAccessibleResource::operator=(WebAccessibleResource&& rhs) = default;
// static
constexpr char WebAccessibleResource::kResources[];
// static
constexpr char WebAccessibleResource::kMatches[];
// static
constexpr char WebAccessibleResource::kExtensionIds[];
// static
constexpr char WebAccessibleResource::kUseDynamicUrl[];

// static
bool WebAccessibleResource::Populate(
    const base::Value& value, WebAccessibleResource* out, base::string16* error) {
  DCHECK(error);
  if (!value.is_dict()) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("expected dictionary, got " + std::string(base::Value::GetTypeName(value.type())));
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* resources_value = nullptr;
  if (!dict->GetWithoutPathExpansion("resources", &resources_value)) {
    DCHECK(error->empty());
    *error = UTF8ToUTF16("'resources' is required");
    return false;
  }
  {
    const base::ListValue* list = nullptr;
    if (!resources_value->GetAsList(&list)) {
      DCHECK(error->empty());
      *error = UTF8ToUTF16("'resources': expected list, got " + std::string(base::Value::GetTypeName(resources_value->type())));
      return false;
    }
    else {
      base::string16 array_parse_error;
      if (!json_schema_compiler::util::PopulateArrayFromList(*list, &out->resources, &array_parse_error)) {
        array_parse_error = base::UTF8ToUTF16("Error at key 'resources': ") + array_parse_error;
        DCHECK(error->empty());
        *error = array_parse_error;
        return false;
      }
    }
  }

  const base::Value* matches_value = nullptr;
  if (dict->GetWithoutPathExpansion("matches", &matches_value)) {
    {
      const base::ListValue* list = nullptr;
      if (!matches_value->GetAsList(&list)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'matches': expected list, got " + std::string(base::Value::GetTypeName(matches_value->type())));
        return false;
      }
      else {
        base::string16 array_parse_error;
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->matches, &array_parse_error)) {
          array_parse_error = base::UTF8ToUTF16("Error at key 'matches': ") + array_parse_error;
          DCHECK(error->empty());
          *error = array_parse_error;
          return false;
        }
      }
    }
  }

  const base::Value* extension_ids_value = nullptr;
  if (dict->GetWithoutPathExpansion("extension_ids", &extension_ids_value)) {
    {
      const base::ListValue* list = nullptr;
      if (!extension_ids_value->GetAsList(&list)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'extension_ids': expected list, got " + std::string(base::Value::GetTypeName(extension_ids_value->type())));
        return false;
      }
      else {
        base::string16 array_parse_error;
        if (!json_schema_compiler::util::PopulateOptionalArrayFromList(*list, &out->extension_ids, &array_parse_error)) {
          array_parse_error = base::UTF8ToUTF16("Error at key 'extension_ids': ") + array_parse_error;
          DCHECK(error->empty());
          *error = array_parse_error;
          return false;
        }
      }
    }
  }

  const base::Value* use_dynamic_url_value = nullptr;
  if (dict->GetWithoutPathExpansion("use_dynamic_url", &use_dynamic_url_value)) {
    {
      bool temp;
      if (!use_dynamic_url_value->GetAsBoolean(&temp)) {
        DCHECK(error->empty());
        *error = UTF8ToUTF16("'use_dynamic_url': expected use_dynamic_url, got " + std::string(base::Value::GetTypeName(use_dynamic_url_value->type())));
        out->use_dynamic_url.reset();
        return false;
      }
      else
        out->use_dynamic_url = std::make_unique<bool>(temp);
    }
  }

  return true;
}

// static
std::unique_ptr<WebAccessibleResource> WebAccessibleResource::FromValue(const base::Value& value, base::string16* error) {
  DCHECK(error);
  auto out = std::make_unique<WebAccessibleResource>();
  bool result = Populate(value, out.get(), error);
  DCHECK_EQ(result, error->empty());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> WebAccessibleResource::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("resources", json_schema_compiler::util::CreateValueFromArray(this->resources));

  if (this->matches.get()) {
    to_value_result->SetWithoutPathExpansion("matches", json_schema_compiler::util::CreateValueFromOptionalArray(this->matches));

  }
  if (this->extension_ids.get()) {
    to_value_result->SetWithoutPathExpansion("extension_ids", json_schema_compiler::util::CreateValueFromOptionalArray(this->extension_ids));

  }
  if (this->use_dynamic_url.get()) {
    to_value_result->SetWithoutPathExpansion("use_dynamic_url", std::make_unique<base::Value>(*this->use_dynamic_url));

  }

  return to_value_result;
}

//static
bool WebAccessibleResource::ParseFromDictionary(
const base::DictionaryValue& root_dict, base::StringPiece key, WebAccessibleResource* out, base::string16* error, std::vector<base::StringPiece>* error_path_reversed) {
  DCHECK(out);
  DCHECK(error);
  DCHECK(error_path_reversed);

  const base::Value* value = ::json_schema_compiler::manifest_parse_util::FindKeyOfType(root_dict, key, base::Value::Type::DICTIONARY, error, error_path_reversed);
  if (!value)
    return false;
  const base::DictionaryValue& dict = base::Value::AsDictionaryValue(*value);
  if (!::json_schema_compiler::manifest_parse_util::ParseFromDictionary(dict, kResources, &out->resources, error, error_path_reversed)) {
    error_path_reversed->push_back(key);
    return false;
  }

  if (!::json_schema_compiler::manifest_parse_util::ParseFromDictionary(dict, kMatches, &out->matches, error, error_path_reversed)) {
    error_path_reversed->push_back(key);
    return false;
  }

  if (!::json_schema_compiler::manifest_parse_util::ParseFromDictionary(dict, kExtensionIds, &out->extension_ids, error, error_path_reversed)) {
    error_path_reversed->push_back(key);
    return false;
  }

  if (!::json_schema_compiler::manifest_parse_util::ParseFromDictionary(dict, kUseDynamicUrl, &out->use_dynamic_url, error, error_path_reversed)) {
    error_path_reversed->push_back(key);
    return false;
  }

  return true;
}



//
// Manifest Keys
//

ManifestKeys::ManifestKeys()
 {}

ManifestKeys::~ManifestKeys() = default;
ManifestKeys::ManifestKeys(ManifestKeys&& rhs) = default;
ManifestKeys& ManifestKeys::operator=(ManifestKeys&& rhs) = default;
// static
constexpr char ManifestKeys::kWebAccessibleResources[];

//static
bool ManifestKeys::ParseFromDictionary(
const base::DictionaryValue& root_dict, ManifestKeys* out, base::string16* error) {
  DCHECK(out);
  DCHECK(error);

  std::vector<base::StringPiece> error_path_reversed_vec;
  auto* error_path_reversed = &error_path_reversed_vec;
  const base::DictionaryValue& dict = root_dict;
  if (!::json_schema_compiler::manifest_parse_util::ParseFromDictionary(dict, kWebAccessibleResources, &out->web_accessible_resources, error, error_path_reversed)) {
    ::json_schema_compiler::manifest_parse_util::PopulateFinalError(error, error_path_reversed);
    return false;
  }

  return true;
}


}  // namespace web_accessible_resources
}  // namespace api
}  // namespace extensions

