// extensions/common/mojom/channel.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "extensions/common/mojom/channel.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "extensions/common/mojom/channel.mojom-params-data.h"
namespace extensions {
namespace mojom {

std::string ChannelToString(Channel value) {
  switch(value) {
    case Channel::kUnknown:
      return "Channel::kUnknown";
    case Channel::kCanary:
      return "Channel::kCanary";
    case Channel::kDev:
      return "Channel::kDev";
    case Channel::kBeta:
      return "Channel::kBeta";
    case Channel::kStable:
      return "Channel::kStable";
    default:
      return base::StringPrintf("Unknown Channel value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, Channel value) {
  return os << ChannelToString(value);
}

namespace internal {

}  // namespace internal
}  // namespace mojom
}  // namespace extensions

namespace perfetto {

// static
void TraceFormatTraits<::extensions::mojom::Channel>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::extensions::mojom::Channel value) {
  return std::move(context).WriteString(::extensions::mojom::ChannelToString(value));
}

} // namespace perfetto
