// extensions/common/mojom/frame.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "extensions/common/mojom/frame.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "extensions/common/mojom/frame.mojom-params-data.h"
#include "extensions/common/mojom/frame.mojom-shared-message-ids.h"

#include "extensions/common/mojom/frame.mojom-import-headers.h"


#ifndef EXTENSIONS_COMMON_MOJOM_FRAME_MOJOM_JUMBO_H_
#define EXTENSIONS_COMMON_MOJOM_FRAME_MOJOM_JUMBO_H_
#endif
namespace extensions {
namespace mojom {
const char LocalFrame::Name_[] = "extensions.mojom.LocalFrame";

LocalFrameProxy::LocalFrameProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void LocalFrameProxy::SetFrameName(
    const std::string& in_frame_name) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "extensions::mojom::LocalFrame::SetFrameName", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_name"), in_frame_name, 
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrame_SetFrameName_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::LocalFrame_SetFrameName_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->frame_name)::BaseType> frame_name_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_frame_name, frame_name_fragment);
  params->frame_name.Set(
      frame_name_fragment.is_null() ? nullptr : frame_name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->frame_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame_name in LocalFrame.SetFrameName request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("SetFrameName");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameProxy::SetSpatialNavigationEnabled(
    bool in_spatial_nav_enabled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "extensions::mojom::LocalFrame::SetSpatialNavigationEnabled", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("spatial_nav_enabled"), in_spatial_nav_enabled, 
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrame_SetSpatialNavigationEnabled_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::LocalFrame_SetSpatialNavigationEnabled_Params_Data> params(
          message);
  params.Allocate();
  params->spatial_nav_enabled = in_spatial_nav_enabled;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("SetSpatialNavigationEnabled");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameProxy::SetTabId(
    int32_t in_tab_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "extensions::mojom::LocalFrame::SetTabId", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tab_id"), in_tab_id, 
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrame_SetTabId_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::LocalFrame_SetTabId_Params_Data> params(
          message);
  params.Allocate();
  params->tab_id = in_tab_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("SetTabId");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameProxy::AppWindowClosed(
    bool in_send_onclosed) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "extensions::mojom::LocalFrame::AppWindowClosed", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("send_onclosed"), in_send_onclosed, 
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrame_AppWindowClosed_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::LocalFrame_AppWindowClosed_Params_Data> params(
          message);
  params.Allocate();
  params->send_onclosed = in_send_onclosed;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("AppWindowClosed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool LocalFrameStubDispatch::Accept(
    LocalFrame* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kLocalFrame_SetFrameName_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)extensions::mojom::LocalFrame::SetFrameName",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)extensions::mojom::LocalFrame::SetFrameName");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrame_SetFrameName_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_SetFrameName_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_frame_name{};
      LocalFrame_SetFrameName_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFrameName(&p_frame_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetFrameName(
std::move(p_frame_name));
      return true;
    }
    case internal::kLocalFrame_SetSpatialNavigationEnabled_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)extensions::mojom::LocalFrame::SetSpatialNavigationEnabled",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)extensions::mojom::LocalFrame::SetSpatialNavigationEnabled");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrame_SetSpatialNavigationEnabled_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_SetSpatialNavigationEnabled_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_spatial_nav_enabled{};
      LocalFrame_SetSpatialNavigationEnabled_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_spatial_nav_enabled = input_data_view.spatial_nav_enabled();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetSpatialNavigationEnabled(
std::move(p_spatial_nav_enabled));
      return true;
    }
    case internal::kLocalFrame_SetTabId_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)extensions::mojom::LocalFrame::SetTabId",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)extensions::mojom::LocalFrame::SetTabId");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrame_SetTabId_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_SetTabId_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_tab_id{};
      LocalFrame_SetTabId_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_tab_id = input_data_view.tab_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetTabId(
std::move(p_tab_id));
      return true;
    }
    case internal::kLocalFrame_AppWindowClosed_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)extensions::mojom::LocalFrame::AppWindowClosed",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)extensions::mojom::LocalFrame::AppWindowClosed");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrame_AppWindowClosed_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_AppWindowClosed_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_send_onclosed{};
      LocalFrame_AppWindowClosed_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_send_onclosed = input_data_view.send_onclosed();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AppWindowClosed(
std::move(p_send_onclosed));
      return true;
    }
  }
  return false;
}

// static
bool LocalFrameStubDispatch::AcceptWithResponder(
    LocalFrame* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kLocalFrame_SetFrameName_Name: {
      break;
    }
    case internal::kLocalFrame_SetSpatialNavigationEnabled_Name: {
      break;
    }
    case internal::kLocalFrame_SetTabId_Name: {
      break;
    }
    case internal::kLocalFrame_AppWindowClosed_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kLocalFrameValidationInfo[] = {
    {internal::kLocalFrame_SetFrameName_Name,
     {&internal::LocalFrame_SetFrameName_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrame_SetSpatialNavigationEnabled_Name,
     {&internal::LocalFrame_SetSpatialNavigationEnabled_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrame_SetTabId_Name,
     {&internal::LocalFrame_SetTabId_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrame_AppWindowClosed_Name,
     {&internal::LocalFrame_AppWindowClosed_Params_Data::Validate,
      nullptr /* no response */}},
};

bool LocalFrameRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::extensions::mojom::LocalFrame::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kLocalFrameValidationInfo);
}

}  // namespace mojom
}  // namespace extensions

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif