// extensions/common/mojom/renderer.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "extensions/common/mojom/renderer.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "extensions/common/mojom/renderer.mojom-params-data.h"
namespace extensions {
namespace mojom {

namespace internal {


// static
bool Renderer_ActivateExtension_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Renderer_ActivateExtension_Params_Data* object = static_cast<const Renderer_ActivateExtension_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->extension_id, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams extension_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->extension_id, validation_context,
                                         &extension_id_validate_params)) {
    return false;
  }

  return true;
}

Renderer_ActivateExtension_Params_Data::Renderer_ActivateExtension_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Renderer_SetActivityLoggingEnabled_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Renderer_SetActivityLoggingEnabled_Params_Data* object = static_cast<const Renderer_SetActivityLoggingEnabled_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

Renderer_SetActivityLoggingEnabled_Params_Data::Renderer_SetActivityLoggingEnabled_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Renderer_UnloadExtension_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Renderer_UnloadExtension_Params_Data* object = static_cast<const Renderer_UnloadExtension_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->extension_id, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams extension_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->extension_id, validation_context,
                                         &extension_id_validate_params)) {
    return false;
  }

  return true;
}

Renderer_UnloadExtension_Params_Data::Renderer_UnloadExtension_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Renderer_SetSessionInfo_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Renderer_SetSessionInfo_Params_Data* object = static_cast<const Renderer_SetSessionInfo_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::extensions::mojom::internal::Channel_Data
        ::Validate(object->channel, validation_context))
    return false;


  if (!::extensions::mojom::internal::FeatureSessionType_Data
        ::Validate(object->session, validation_context))
    return false;

  return true;
}

Renderer_SetSessionInfo_Params_Data::Renderer_SetSessionInfo_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Renderer_SetSystemFont_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Renderer_SetSystemFont_Params_Data* object = static_cast<const Renderer_SetSystemFont_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->font_family, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams font_family_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->font_family, validation_context,
                                         &font_family_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->font_size, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams font_size_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->font_size, validation_context,
                                         &font_size_validate_params)) {
    return false;
  }

  return true;
}

Renderer_SetSystemFont_Params_Data::Renderer_SetSystemFont_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Renderer_SetWebViewPartitionID_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Renderer_SetWebViewPartitionID_Params_Data* object = static_cast<const Renderer_SetWebViewPartitionID_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->partition_id, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams partition_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->partition_id, validation_context,
                                         &partition_id_validate_params)) {
    return false;
  }

  return true;
}

Renderer_SetWebViewPartitionID_Params_Data::Renderer_SetWebViewPartitionID_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Renderer_SetScriptingAllowlist_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Renderer_SetScriptingAllowlist_Params_Data* object = static_cast<const Renderer_SetScriptingAllowlist_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->extension_ids, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams extension_ids_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->extension_ids, validation_context,
                                         &extension_ids_validate_params)) {
    return false;
  }

  return true;
}

Renderer_SetScriptingAllowlist_Params_Data::Renderer_SetScriptingAllowlist_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Renderer_UpdateDefaultPolicyHostRestrictions_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Renderer_UpdateDefaultPolicyHostRestrictions_Params_Data* object = static_cast<const Renderer_UpdateDefaultPolicyHostRestrictions_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->default_policy_blocked_hosts, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->default_policy_blocked_hosts, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->default_policy_allowed_hosts, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->default_policy_allowed_hosts, validation_context))
    return false;

  return true;
}

Renderer_UpdateDefaultPolicyHostRestrictions_Params_Data::Renderer_UpdateDefaultPolicyHostRestrictions_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace extensions
