// extensions/common/mojom/renderer.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "extensions/common/mojom/renderer.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "extensions/common/mojom/renderer.mojom-params-data.h"
#include "extensions/common/mojom/renderer.mojom-shared-message-ids.h"

#include "extensions/common/mojom/renderer.mojom-import-headers.h"


#ifndef EXTENSIONS_COMMON_MOJOM_RENDERER_MOJOM_JUMBO_H_
#define EXTENSIONS_COMMON_MOJOM_RENDERER_MOJOM_JUMBO_H_
#endif
namespace extensions {
namespace mojom {
const char Renderer::Name_[] = "extensions.mojom.Renderer";

RendererProxy::RendererProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void RendererProxy::ActivateExtension(
    const std::string& in_extension_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "extensions::mojom::Renderer::ActivateExtension", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extension_id"), in_extension_id, 
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRenderer_ActivateExtension_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::Renderer_ActivateExtension_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->extension_id)::BaseType> extension_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_extension_id, extension_id_fragment);
  params->extension_id.Set(
      extension_id_fragment.is_null() ? nullptr : extension_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->extension_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null extension_id in Renderer.ActivateExtension request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("ActivateExtension");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RendererProxy::SetActivityLoggingEnabled(
    bool in_enabled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "extensions::mojom::Renderer::SetActivityLoggingEnabled", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enabled"), in_enabled, 
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRenderer_SetActivityLoggingEnabled_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::Renderer_SetActivityLoggingEnabled_Params_Data> params(
          message);
  params.Allocate();
  params->enabled = in_enabled;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("SetActivityLoggingEnabled");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RendererProxy::UnloadExtension(
    const std::string& in_extension_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "extensions::mojom::Renderer::UnloadExtension", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extension_id"), in_extension_id, 
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRenderer_UnloadExtension_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::Renderer_UnloadExtension_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->extension_id)::BaseType> extension_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_extension_id, extension_id_fragment);
  params->extension_id.Set(
      extension_id_fragment.is_null() ? nullptr : extension_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->extension_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null extension_id in Renderer.UnloadExtension request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("UnloadExtension");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RendererProxy::SetSessionInfo(
    version_info::Channel in_channel, ::extensions::mojom::FeatureSessionType in_session, bool in_is_lock_screen_context) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "extensions::mojom::Renderer::SetSessionInfo", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("channel"), in_channel, 
                        "<value of type version_info::Channel>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session"), in_session, 
                        "<value of type ::extensions::mojom::FeatureSessionType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_lock_screen_context"), in_is_lock_screen_context, 
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRenderer_SetSessionInfo_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::Renderer_SetSessionInfo_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::extensions::mojom::Channel>(
      in_channel, &params->channel);
  mojo::internal::Serialize<::extensions::mojom::FeatureSessionType>(
      in_session, &params->session);
  params->is_lock_screen_context = in_is_lock_screen_context;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("SetSessionInfo");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RendererProxy::SetSystemFont(
    const std::string& in_font_family, const std::string& in_font_size) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "extensions::mojom::Renderer::SetSystemFont", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("font_family"), in_font_family, 
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("font_size"), in_font_size, 
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRenderer_SetSystemFont_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::Renderer_SetSystemFont_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->font_family)::BaseType> font_family_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_font_family, font_family_fragment);
  params->font_family.Set(
      font_family_fragment.is_null() ? nullptr : font_family_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->font_family.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null font_family in Renderer.SetSystemFont request");
  mojo::internal::MessageFragment<
      typename decltype(params->font_size)::BaseType> font_size_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_font_size, font_size_fragment);
  params->font_size.Set(
      font_size_fragment.is_null() ? nullptr : font_size_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->font_size.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null font_size in Renderer.SetSystemFont request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("SetSystemFont");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RendererProxy::SetWebViewPartitionID(
    const std::string& in_partition_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "extensions::mojom::Renderer::SetWebViewPartitionID", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("partition_id"), in_partition_id, 
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRenderer_SetWebViewPartitionID_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::Renderer_SetWebViewPartitionID_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->partition_id)::BaseType> partition_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_partition_id, partition_id_fragment);
  params->partition_id.Set(
      partition_id_fragment.is_null() ? nullptr : partition_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->partition_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null partition_id in Renderer.SetWebViewPartitionID request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("SetWebViewPartitionID");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RendererProxy::SetScriptingAllowlist(
    const std::vector<std::string>& in_extension_ids) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "extensions::mojom::Renderer::SetScriptingAllowlist", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extension_ids"), in_extension_ids, 
                        "<value of type const std::vector<std::string>&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRenderer_SetScriptingAllowlist_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::Renderer_SetScriptingAllowlist_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->extension_ids)::BaseType>
      extension_ids_fragment(params.message());
  const mojo::internal::ContainerValidateParams extension_ids_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_extension_ids, extension_ids_fragment, &extension_ids_validate_params);
  params->extension_ids.Set(
      extension_ids_fragment.is_null() ? nullptr : extension_ids_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->extension_ids.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null extension_ids in Renderer.SetScriptingAllowlist request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("SetScriptingAllowlist");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RendererProxy::UpdateDefaultPolicyHostRestrictions(
    const ::extensions::URLPatternSet& in_default_policy_blocked_hosts, const ::extensions::URLPatternSet& in_default_policy_allowed_hosts) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "extensions::mojom::Renderer::UpdateDefaultPolicyHostRestrictions", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("default_policy_blocked_hosts"), in_default_policy_blocked_hosts, 
                        "<value of type const ::extensions::URLPatternSet&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("default_policy_allowed_hosts"), in_default_policy_allowed_hosts, 
                        "<value of type const ::extensions::URLPatternSet&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRenderer_UpdateDefaultPolicyHostRestrictions_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::Renderer_UpdateDefaultPolicyHostRestrictions_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->default_policy_blocked_hosts)::BaseType> default_policy_blocked_hosts_fragment(
          params.message());
  mojo::internal::Serialize<::extensions::mojom::URLPatternSetDataView>(
      in_default_policy_blocked_hosts, default_policy_blocked_hosts_fragment);
  params->default_policy_blocked_hosts.Set(
      default_policy_blocked_hosts_fragment.is_null() ? nullptr : default_policy_blocked_hosts_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->default_policy_blocked_hosts.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null default_policy_blocked_hosts in Renderer.UpdateDefaultPolicyHostRestrictions request");
  mojo::internal::MessageFragment<
      typename decltype(params->default_policy_allowed_hosts)::BaseType> default_policy_allowed_hosts_fragment(
          params.message());
  mojo::internal::Serialize<::extensions::mojom::URLPatternSetDataView>(
      in_default_policy_allowed_hosts, default_policy_allowed_hosts_fragment);
  params->default_policy_allowed_hosts.Set(
      default_policy_allowed_hosts_fragment.is_null() ? nullptr : default_policy_allowed_hosts_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->default_policy_allowed_hosts.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null default_policy_allowed_hosts in Renderer.UpdateDefaultPolicyHostRestrictions request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("UpdateDefaultPolicyHostRestrictions");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool RendererStubDispatch::Accept(
    Renderer* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kRenderer_ActivateExtension_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)extensions::mojom::Renderer::ActivateExtension",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)extensions::mojom::Renderer::ActivateExtension");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Renderer_ActivateExtension_Params_Data* params =
          reinterpret_cast<internal::Renderer_ActivateExtension_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_extension_id{};
      Renderer_ActivateExtension_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadExtensionId(&p_extension_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ActivateExtension(
std::move(p_extension_id));
      return true;
    }
    case internal::kRenderer_SetActivityLoggingEnabled_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)extensions::mojom::Renderer::SetActivityLoggingEnabled",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)extensions::mojom::Renderer::SetActivityLoggingEnabled");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Renderer_SetActivityLoggingEnabled_Params_Data* params =
          reinterpret_cast<internal::Renderer_SetActivityLoggingEnabled_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_enabled{};
      Renderer_SetActivityLoggingEnabled_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_enabled = input_data_view.enabled();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetActivityLoggingEnabled(
std::move(p_enabled));
      return true;
    }
    case internal::kRenderer_UnloadExtension_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)extensions::mojom::Renderer::UnloadExtension",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)extensions::mojom::Renderer::UnloadExtension");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Renderer_UnloadExtension_Params_Data* params =
          reinterpret_cast<internal::Renderer_UnloadExtension_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_extension_id{};
      Renderer_UnloadExtension_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadExtensionId(&p_extension_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UnloadExtension(
std::move(p_extension_id));
      return true;
    }
    case internal::kRenderer_SetSessionInfo_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)extensions::mojom::Renderer::SetSessionInfo",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)extensions::mojom::Renderer::SetSessionInfo");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Renderer_SetSessionInfo_Params_Data* params =
          reinterpret_cast<internal::Renderer_SetSessionInfo_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      version_info::Channel p_channel{};
      ::extensions::mojom::FeatureSessionType p_session{};
      bool p_is_lock_screen_context{};
      Renderer_SetSessionInfo_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadChannel(&p_channel))
        success = false;
      if (success && !input_data_view.ReadSession(&p_session))
        success = false;
      if (success)
        p_is_lock_screen_context = input_data_view.is_lock_screen_context();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetSessionInfo(
std::move(p_channel), 
std::move(p_session), 
std::move(p_is_lock_screen_context));
      return true;
    }
    case internal::kRenderer_SetSystemFont_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)extensions::mojom::Renderer::SetSystemFont",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)extensions::mojom::Renderer::SetSystemFont");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Renderer_SetSystemFont_Params_Data* params =
          reinterpret_cast<internal::Renderer_SetSystemFont_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_font_family{};
      std::string p_font_size{};
      Renderer_SetSystemFont_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFontFamily(&p_font_family))
        success = false;
      if (success && !input_data_view.ReadFontSize(&p_font_size))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetSystemFont(
std::move(p_font_family), 
std::move(p_font_size));
      return true;
    }
    case internal::kRenderer_SetWebViewPartitionID_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)extensions::mojom::Renderer::SetWebViewPartitionID",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)extensions::mojom::Renderer::SetWebViewPartitionID");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Renderer_SetWebViewPartitionID_Params_Data* params =
          reinterpret_cast<internal::Renderer_SetWebViewPartitionID_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_partition_id{};
      Renderer_SetWebViewPartitionID_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPartitionId(&p_partition_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetWebViewPartitionID(
std::move(p_partition_id));
      return true;
    }
    case internal::kRenderer_SetScriptingAllowlist_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)extensions::mojom::Renderer::SetScriptingAllowlist",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)extensions::mojom::Renderer::SetScriptingAllowlist");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Renderer_SetScriptingAllowlist_Params_Data* params =
          reinterpret_cast<internal::Renderer_SetScriptingAllowlist_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::vector<std::string> p_extension_ids{};
      Renderer_SetScriptingAllowlist_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadExtensionIds(&p_extension_ids))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetScriptingAllowlist(
std::move(p_extension_ids));
      return true;
    }
    case internal::kRenderer_UpdateDefaultPolicyHostRestrictions_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)extensions::mojom::Renderer::UpdateDefaultPolicyHostRestrictions",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)extensions::mojom::Renderer::UpdateDefaultPolicyHostRestrictions");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Renderer_UpdateDefaultPolicyHostRestrictions_Params_Data* params =
          reinterpret_cast<internal::Renderer_UpdateDefaultPolicyHostRestrictions_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::extensions::URLPatternSet p_default_policy_blocked_hosts{};
      ::extensions::URLPatternSet p_default_policy_allowed_hosts{};
      Renderer_UpdateDefaultPolicyHostRestrictions_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDefaultPolicyBlockedHosts(&p_default_policy_blocked_hosts))
        success = false;
      if (success && !input_data_view.ReadDefaultPolicyAllowedHosts(&p_default_policy_allowed_hosts))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateDefaultPolicyHostRestrictions(
std::move(p_default_policy_blocked_hosts), 
std::move(p_default_policy_allowed_hosts));
      return true;
    }
  }
  return false;
}

// static
bool RendererStubDispatch::AcceptWithResponder(
    Renderer* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kRenderer_ActivateExtension_Name: {
      break;
    }
    case internal::kRenderer_SetActivityLoggingEnabled_Name: {
      break;
    }
    case internal::kRenderer_UnloadExtension_Name: {
      break;
    }
    case internal::kRenderer_SetSessionInfo_Name: {
      break;
    }
    case internal::kRenderer_SetSystemFont_Name: {
      break;
    }
    case internal::kRenderer_SetWebViewPartitionID_Name: {
      break;
    }
    case internal::kRenderer_SetScriptingAllowlist_Name: {
      break;
    }
    case internal::kRenderer_UpdateDefaultPolicyHostRestrictions_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kRendererValidationInfo[] = {
    {internal::kRenderer_ActivateExtension_Name,
     {&internal::Renderer_ActivateExtension_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRenderer_SetActivityLoggingEnabled_Name,
     {&internal::Renderer_SetActivityLoggingEnabled_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRenderer_UnloadExtension_Name,
     {&internal::Renderer_UnloadExtension_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRenderer_SetSessionInfo_Name,
     {&internal::Renderer_SetSessionInfo_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRenderer_SetSystemFont_Name,
     {&internal::Renderer_SetSystemFont_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRenderer_SetWebViewPartitionID_Name,
     {&internal::Renderer_SetWebViewPartitionID_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRenderer_SetScriptingAllowlist_Name,
     {&internal::Renderer_SetScriptingAllowlist_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRenderer_UpdateDefaultPolicyHostRestrictions_Name,
     {&internal::Renderer_UpdateDefaultPolicyHostRestrictions_Params_Data::Validate,
      nullptr /* no response */}},
};

bool RendererRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::extensions::mojom::Renderer::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kRendererValidationInfo);
}

}  // namespace mojom
}  // namespace extensions

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif