// extensions/common/mojom/url_pattern_set.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "extensions/common/mojom/url_pattern_set.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "extensions/common/mojom/url_pattern_set.mojom-params-data.h"
namespace extensions {
namespace mojom {

namespace internal {


// static
bool URLPattern_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const URLPattern_Data* object = static_cast<const URLPattern_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->pattern, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams pattern_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->pattern, validation_context,
                                         &pattern_validate_params)) {
    return false;
  }

  return true;
}

URLPattern_Data::URLPattern_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool URLPatternSet_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const URLPatternSet_Data* object = static_cast<const URLPatternSet_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->patterns, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams patterns_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->patterns, validation_context,
                                         &patterns_validate_params)) {
    return false;
  }

  return true;
}

URLPatternSet_Data::URLPatternSet_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace extensions
