// gpu/ipc/common/context_result.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "gpu/ipc/common/context_result.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "gpu/ipc/common/context_result.mojom-params-data.h"
namespace gpu {
namespace mojom {

std::string ContextResultToString(ContextResult value) {
  switch(value) {
    case ContextResult::Success:
      return "ContextResult::Success";
    case ContextResult::TransientFailure:
      return "ContextResult::TransientFailure";
    case ContextResult::FatalFailure:
      return "ContextResult::FatalFailure";
    case ContextResult::SurfaceFailure:
      return "ContextResult::SurfaceFailure";
    default:
      return base::StringPrintf("Unknown ContextResult value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, ContextResult value) {
  return os << ContextResultToString(value);
}

namespace internal {

}  // namespace internal
}  // namespace mojom
}  // namespace gpu

namespace perfetto {

// static
void TraceFormatTraits<::gpu::mojom::ContextResult>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::gpu::mojom::ContextResult value) {
  return std::move(context).WriteString(::gpu::mojom::ContextResultToString(value));
}

} // namespace perfetto
