// gpu/ipc/common/device_perf_info.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "gpu/ipc/common/device_perf_info.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "gpu/ipc/common/device_perf_info.mojom-params-data.h"
#include "gpu/ipc/common/device_perf_info.mojom-shared-message-ids.h"

#include "gpu/ipc/common/device_perf_info.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef GPU_IPC_COMMON_DEVICE_PERF_INFO_MOJOM_BLINK_JUMBO_H_
#define GPU_IPC_COMMON_DEVICE_PERF_INFO_MOJOM_BLINK_JUMBO_H_
#endif
namespace gpu {
namespace mojom {
namespace blink {
DevicePerfInfo::DevicePerfInfo()
    : total_physical_memory_mb(),
      total_disk_space_mb(),
      hardware_concurrency() {}

DevicePerfInfo::DevicePerfInfo(
    uint32_t total_physical_memory_mb_in,
    uint32_t total_disk_space_mb_in,
    uint32_t hardware_concurrency_in)
    : total_physical_memory_mb(std::move(total_physical_memory_mb_in)),
      total_disk_space_mb(std::move(total_disk_space_mb_in)),
      hardware_concurrency(std::move(hardware_concurrency_in)) {}

DevicePerfInfo::~DevicePerfInfo() = default;
size_t DevicePerfInfo::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->total_physical_memory_mb);
  seed = mojo::internal::WTFHash(seed, this->total_disk_space_mb);
  seed = mojo::internal::WTFHash(seed, this->hardware_concurrency);
  return seed;
}

void DevicePerfInfo::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "total_physical_memory_mb"), this->total_physical_memory_mb, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "total_disk_space_mb"), this->total_disk_space_mb, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hardware_concurrency"), this->hardware_concurrency, 
      "<value of type uint32_t>");
}

bool DevicePerfInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace blink
}  // namespace mojom
}  // namespace gpu

namespace mojo {


// static
bool StructTraits<::gpu::mojom::blink::DevicePerfInfo::DataView, ::gpu::mojom::blink::DevicePerfInfoPtr>::Read(
    ::gpu::mojom::blink::DevicePerfInfo::DataView input,
    ::gpu::mojom::blink::DevicePerfInfoPtr* output) {
  bool success = true;
  ::gpu::mojom::blink::DevicePerfInfoPtr result(::gpu::mojom::blink::DevicePerfInfo::New());
  
      if (success)
        result->total_physical_memory_mb = input.total_physical_memory_mb();
      if (success)
        result->total_disk_space_mb = input.total_disk_space_mb();
      if (success)
        result->hardware_concurrency = input.hardware_concurrency();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif