// gpu/ipc/common/gpu_info.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "gpu/ipc/common/gpu_info.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "gpu/ipc/common/gpu_info.mojom-params-data.h"
#include "gpu/ipc/common/gpu_info.mojom-shared-message-ids.h"

#include "gpu/ipc/common/gpu_info.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef GPU_IPC_COMMON_GPU_INFO_MOJOM_BLINK_JUMBO_H_
#define GPU_IPC_COMMON_GPU_INFO_MOJOM_BLINK_JUMBO_H_
#endif
namespace gpu {
namespace mojom {
namespace blink {
GpuDevice::GpuDevice()
    : vendor_id(),
      device_id(),
      active(),
      vendor_string(),
      device_string(),
      driver_vendor(),
      driver_version(),
      cuda_compute_capability_major() {}

GpuDevice::GpuDevice(
    uint32_t vendor_id_in,
    uint32_t device_id_in,
    bool active_in,
    const WTF::String& vendor_string_in,
    const WTF::String& device_string_in,
    const WTF::String& driver_vendor_in,
    const WTF::String& driver_version_in,
    int32_t cuda_compute_capability_major_in)
    : vendor_id(std::move(vendor_id_in)),
      device_id(std::move(device_id_in)),
      active(std::move(active_in)),
      vendor_string(std::move(vendor_string_in)),
      device_string(std::move(device_string_in)),
      driver_vendor(std::move(driver_vendor_in)),
      driver_version(std::move(driver_version_in)),
      cuda_compute_capability_major(std::move(cuda_compute_capability_major_in)) {}

GpuDevice::~GpuDevice() = default;
size_t GpuDevice::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->vendor_id);
  seed = mojo::internal::WTFHash(seed, this->device_id);
  seed = mojo::internal::WTFHash(seed, this->active);
  seed = mojo::internal::WTFHash(seed, this->vendor_string);
  seed = mojo::internal::WTFHash(seed, this->device_string);
  seed = mojo::internal::WTFHash(seed, this->driver_vendor);
  seed = mojo::internal::WTFHash(seed, this->driver_version);
  seed = mojo::internal::WTFHash(seed, this->cuda_compute_capability_major);
  return seed;
}

void GpuDevice::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "vendor_id"), this->vendor_id, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "device_id"), this->device_id, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "active"), this->active, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "vendor_string"), this->vendor_string, 
      "<value of type const WTF::String&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "device_string"), this->device_string, 
      "<value of type const WTF::String&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "driver_vendor"), this->driver_vendor, 
      "<value of type const WTF::String&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "driver_version"), this->driver_version, 
      "<value of type const WTF::String&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cuda_compute_capability_major"), this->cuda_compute_capability_major, 
      "<value of type int32_t>");
}

bool GpuDevice::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VideoDecodeAcceleratorSupportedProfile::VideoDecodeAcceleratorSupportedProfile()
    : profile(),
      max_resolution(),
      min_resolution(),
      encrypted_only() {}

VideoDecodeAcceleratorSupportedProfile::VideoDecodeAcceleratorSupportedProfile(
    VideoCodecProfile profile_in,
    const ::gfx::Size& max_resolution_in,
    const ::gfx::Size& min_resolution_in,
    bool encrypted_only_in)
    : profile(std::move(profile_in)),
      max_resolution(std::move(max_resolution_in)),
      min_resolution(std::move(min_resolution_in)),
      encrypted_only(std::move(encrypted_only_in)) {}

VideoDecodeAcceleratorSupportedProfile::~VideoDecodeAcceleratorSupportedProfile() = default;

void VideoDecodeAcceleratorSupportedProfile::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "profile"), this->profile, 
      "<value of type VideoCodecProfile>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_resolution"), this->max_resolution, 
      "<value of type const ::gfx::Size&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "min_resolution"), this->min_resolution, 
      "<value of type const ::gfx::Size&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "encrypted_only"), this->encrypted_only, 
      "<value of type bool>");
}

bool VideoDecodeAcceleratorSupportedProfile::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VideoDecodeAcceleratorCapabilities::VideoDecodeAcceleratorCapabilities()
    : supported_profiles(),
      flags() {}

VideoDecodeAcceleratorCapabilities::VideoDecodeAcceleratorCapabilities(
    WTF::Vector<VideoDecodeAcceleratorSupportedProfilePtr> supported_profiles_in,
    uint32_t flags_in)
    : supported_profiles(std::move(supported_profiles_in)),
      flags(std::move(flags_in)) {}

VideoDecodeAcceleratorCapabilities::~VideoDecodeAcceleratorCapabilities() = default;

void VideoDecodeAcceleratorCapabilities::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "supported_profiles"), this->supported_profiles, 
      "<value of type WTF::Vector<VideoDecodeAcceleratorSupportedProfilePtr>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "flags"), this->flags, 
      "<value of type uint32_t>");
}

bool VideoDecodeAcceleratorCapabilities::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VideoEncodeAcceleratorSupportedProfile::VideoEncodeAcceleratorSupportedProfile()
    : profile(),
      min_resolution(),
      max_resolution(),
      max_framerate_numerator(),
      max_framerate_denominator() {}

VideoEncodeAcceleratorSupportedProfile::VideoEncodeAcceleratorSupportedProfile(
    VideoCodecProfile profile_in,
    const ::gfx::Size& min_resolution_in,
    const ::gfx::Size& max_resolution_in,
    uint32_t max_framerate_numerator_in,
    uint32_t max_framerate_denominator_in)
    : profile(std::move(profile_in)),
      min_resolution(std::move(min_resolution_in)),
      max_resolution(std::move(max_resolution_in)),
      max_framerate_numerator(std::move(max_framerate_numerator_in)),
      max_framerate_denominator(std::move(max_framerate_denominator_in)) {}

VideoEncodeAcceleratorSupportedProfile::~VideoEncodeAcceleratorSupportedProfile() = default;

void VideoEncodeAcceleratorSupportedProfile::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "profile"), this->profile, 
      "<value of type VideoCodecProfile>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "min_resolution"), this->min_resolution, 
      "<value of type const ::gfx::Size&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_resolution"), this->max_resolution, 
      "<value of type const ::gfx::Size&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_framerate_numerator"), this->max_framerate_numerator, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_framerate_denominator"), this->max_framerate_denominator, 
      "<value of type uint32_t>");
}

bool VideoEncodeAcceleratorSupportedProfile::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ImageDecodeAcceleratorSupportedProfile::ImageDecodeAcceleratorSupportedProfile()
    : image_type(),
      min_encoded_dimensions(),
      max_encoded_dimensions(),
      subsamplings() {}

ImageDecodeAcceleratorSupportedProfile::ImageDecodeAcceleratorSupportedProfile(
    ImageDecodeAcceleratorType image_type_in,
    const ::gfx::Size& min_encoded_dimensions_in,
    const ::gfx::Size& max_encoded_dimensions_in,
    WTF::Vector<ImageDecodeAcceleratorSubsampling> subsamplings_in)
    : image_type(std::move(image_type_in)),
      min_encoded_dimensions(std::move(min_encoded_dimensions_in)),
      max_encoded_dimensions(std::move(max_encoded_dimensions_in)),
      subsamplings(std::move(subsamplings_in)) {}

ImageDecodeAcceleratorSupportedProfile::~ImageDecodeAcceleratorSupportedProfile() = default;

void ImageDecodeAcceleratorSupportedProfile::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "image_type"), this->image_type, 
      "<value of type ImageDecodeAcceleratorType>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "min_encoded_dimensions"), this->min_encoded_dimensions, 
      "<value of type const ::gfx::Size&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_encoded_dimensions"), this->max_encoded_dimensions, 
      "<value of type const ::gfx::Size&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "subsamplings"), this->subsamplings, 
      "<value of type const WTF::Vector<ImageDecodeAcceleratorSubsampling>&>");
}

bool ImageDecodeAcceleratorSupportedProfile::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
GpuInfo::GpuInfo()
    : initialization_time(),
      optimus(),
      amd_switchable(),
      gpu(),
      secondary_gpus(),
      pixel_shader_version(),
      vertex_shader_version(),
      max_msaa_samples(),
      machine_model_name(),
      machine_model_version(),
      gl_version(),
      gl_vendor(),
      gl_renderer(),
      gl_extensions(),
      gl_ws_vendor(),
      gl_ws_version(),
      gl_ws_extensions(),
      gl_reset_notification_strategy(),
      software_rendering(),
      direct_rendering_version(),
      sandboxed(),
      in_process_gpu(),
      passthrough_cmd_decoder(),
      can_support_threaded_texture_mailbox(),
      video_decode_accelerator_capabilities(),
      video_encode_accelerator_supported_profiles(),
      jpeg_decode_accelerator_supported(),
      image_decode_accelerator_supported_profiles(),
      oop_rasterization_supported(),
      subpixel_font_rendering(),
      vulkan_info() {}

GpuInfo::GpuInfo(
    ::base::TimeDelta initialization_time_in,
    bool optimus_in,
    bool amd_switchable_in,
    GpuDevicePtr gpu_in,
    WTF::Vector<GpuDevicePtr> secondary_gpus_in,
    const WTF::String& pixel_shader_version_in,
    const WTF::String& vertex_shader_version_in,
    const WTF::String& max_msaa_samples_in,
    const WTF::String& machine_model_name_in,
    const WTF::String& machine_model_version_in,
    const WTF::String& gl_version_in,
    const WTF::String& gl_vendor_in,
    const WTF::String& gl_renderer_in,
    const WTF::String& gl_extensions_in,
    const WTF::String& gl_ws_vendor_in,
    const WTF::String& gl_ws_version_in,
    const WTF::String& gl_ws_extensions_in,
    uint32_t gl_reset_notification_strategy_in,
    bool software_rendering_in,
    const WTF::String& direct_rendering_version_in,
    bool sandboxed_in,
    bool in_process_gpu_in,
    bool passthrough_cmd_decoder_in,
    bool can_support_threaded_texture_mailbox_in,
    VideoDecodeAcceleratorCapabilitiesPtr video_decode_accelerator_capabilities_in,
    WTF::Vector<VideoEncodeAcceleratorSupportedProfilePtr> video_encode_accelerator_supported_profiles_in,
    bool jpeg_decode_accelerator_supported_in,
    WTF::Vector<ImageDecodeAcceleratorSupportedProfilePtr> image_decode_accelerator_supported_profiles_in,
    bool oop_rasterization_supported_in,
    bool subpixel_font_rendering_in,
    ::gpu::mojom::blink::VulkanInfoPtr vulkan_info_in)
    : initialization_time(std::move(initialization_time_in)),
      optimus(std::move(optimus_in)),
      amd_switchable(std::move(amd_switchable_in)),
      gpu(std::move(gpu_in)),
      secondary_gpus(std::move(secondary_gpus_in)),
      pixel_shader_version(std::move(pixel_shader_version_in)),
      vertex_shader_version(std::move(vertex_shader_version_in)),
      max_msaa_samples(std::move(max_msaa_samples_in)),
      machine_model_name(std::move(machine_model_name_in)),
      machine_model_version(std::move(machine_model_version_in)),
      gl_version(std::move(gl_version_in)),
      gl_vendor(std::move(gl_vendor_in)),
      gl_renderer(std::move(gl_renderer_in)),
      gl_extensions(std::move(gl_extensions_in)),
      gl_ws_vendor(std::move(gl_ws_vendor_in)),
      gl_ws_version(std::move(gl_ws_version_in)),
      gl_ws_extensions(std::move(gl_ws_extensions_in)),
      gl_reset_notification_strategy(std::move(gl_reset_notification_strategy_in)),
      software_rendering(std::move(software_rendering_in)),
      direct_rendering_version(std::move(direct_rendering_version_in)),
      sandboxed(std::move(sandboxed_in)),
      in_process_gpu(std::move(in_process_gpu_in)),
      passthrough_cmd_decoder(std::move(passthrough_cmd_decoder_in)),
      can_support_threaded_texture_mailbox(std::move(can_support_threaded_texture_mailbox_in)),
      video_decode_accelerator_capabilities(std::move(video_decode_accelerator_capabilities_in)),
      video_encode_accelerator_supported_profiles(std::move(video_encode_accelerator_supported_profiles_in)),
      jpeg_decode_accelerator_supported(std::move(jpeg_decode_accelerator_supported_in)),
      image_decode_accelerator_supported_profiles(std::move(image_decode_accelerator_supported_profiles_in)),
      oop_rasterization_supported(std::move(oop_rasterization_supported_in)),
      subpixel_font_rendering(std::move(subpixel_font_rendering_in)),
      vulkan_info(std::move(vulkan_info_in)) {}

GpuInfo::~GpuInfo() = default;

void GpuInfo::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "initialization_time"), this->initialization_time, 
      "<value of type ::base::TimeDelta>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "optimus"), this->optimus, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "amd_switchable"), this->amd_switchable, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "gpu"), this->gpu, 
      "<value of type GpuDevicePtr>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "secondary_gpus"), this->secondary_gpus, 
      "<value of type WTF::Vector<GpuDevicePtr>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pixel_shader_version"), this->pixel_shader_version, 
      "<value of type const WTF::String&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "vertex_shader_version"), this->vertex_shader_version, 
      "<value of type const WTF::String&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_msaa_samples"), this->max_msaa_samples, 
      "<value of type const WTF::String&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "machine_model_name"), this->machine_model_name, 
      "<value of type const WTF::String&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "machine_model_version"), this->machine_model_version, 
      "<value of type const WTF::String&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "gl_version"), this->gl_version, 
      "<value of type const WTF::String&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "gl_vendor"), this->gl_vendor, 
      "<value of type const WTF::String&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "gl_renderer"), this->gl_renderer, 
      "<value of type const WTF::String&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "gl_extensions"), this->gl_extensions, 
      "<value of type const WTF::String&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "gl_ws_vendor"), this->gl_ws_vendor, 
      "<value of type const WTF::String&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "gl_ws_version"), this->gl_ws_version, 
      "<value of type const WTF::String&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "gl_ws_extensions"), this->gl_ws_extensions, 
      "<value of type const WTF::String&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "gl_reset_notification_strategy"), this->gl_reset_notification_strategy, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "software_rendering"), this->software_rendering, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "direct_rendering_version"), this->direct_rendering_version, 
      "<value of type const WTF::String&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sandboxed"), this->sandboxed, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "in_process_gpu"), this->in_process_gpu, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "passthrough_cmd_decoder"), this->passthrough_cmd_decoder, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "can_support_threaded_texture_mailbox"), this->can_support_threaded_texture_mailbox, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "video_decode_accelerator_capabilities"), this->video_decode_accelerator_capabilities, 
      "<value of type VideoDecodeAcceleratorCapabilitiesPtr>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "video_encode_accelerator_supported_profiles"), this->video_encode_accelerator_supported_profiles, 
      "<value of type WTF::Vector<VideoEncodeAcceleratorSupportedProfilePtr>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "jpeg_decode_accelerator_supported"), this->jpeg_decode_accelerator_supported, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "image_decode_accelerator_supported_profiles"), this->image_decode_accelerator_supported_profiles, 
      "<value of type WTF::Vector<ImageDecodeAcceleratorSupportedProfilePtr>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "oop_rasterization_supported"), this->oop_rasterization_supported, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "subpixel_font_rendering"), this->subpixel_font_rendering, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "vulkan_info"), this->vulkan_info, 
      "<value of type ::gpu::mojom::blink::VulkanInfoPtr>");
}

bool GpuInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace blink
}  // namespace mojom
}  // namespace gpu

namespace mojo {


// static
bool StructTraits<::gpu::mojom::blink::GpuDevice::DataView, ::gpu::mojom::blink::GpuDevicePtr>::Read(
    ::gpu::mojom::blink::GpuDevice::DataView input,
    ::gpu::mojom::blink::GpuDevicePtr* output) {
  bool success = true;
  ::gpu::mojom::blink::GpuDevicePtr result(::gpu::mojom::blink::GpuDevice::New());
  
      if (success)
        result->vendor_id = input.vendor_id();
      if (success)
        result->device_id = input.device_id();
      if (success)
        result->active = input.active();
      if (success && !input.ReadVendorString(&result->vendor_string))
        success = false;
      if (success && !input.ReadDeviceString(&result->device_string))
        success = false;
      if (success && !input.ReadDriverVendor(&result->driver_vendor))
        success = false;
      if (success && !input.ReadDriverVersion(&result->driver_version))
        success = false;
      if (success)
        result->cuda_compute_capability_major = input.cuda_compute_capability_major();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::gpu::mojom::blink::VideoDecodeAcceleratorSupportedProfile::DataView, ::gpu::mojom::blink::VideoDecodeAcceleratorSupportedProfilePtr>::Read(
    ::gpu::mojom::blink::VideoDecodeAcceleratorSupportedProfile::DataView input,
    ::gpu::mojom::blink::VideoDecodeAcceleratorSupportedProfilePtr* output) {
  bool success = true;
  ::gpu::mojom::blink::VideoDecodeAcceleratorSupportedProfilePtr result(::gpu::mojom::blink::VideoDecodeAcceleratorSupportedProfile::New());
  
      if (success && !input.ReadProfile(&result->profile))
        success = false;
      if (success && !input.ReadMaxResolution(&result->max_resolution))
        success = false;
      if (success && !input.ReadMinResolution(&result->min_resolution))
        success = false;
      if (success)
        result->encrypted_only = input.encrypted_only();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::gpu::mojom::blink::VideoDecodeAcceleratorCapabilities::DataView, ::gpu::mojom::blink::VideoDecodeAcceleratorCapabilitiesPtr>::Read(
    ::gpu::mojom::blink::VideoDecodeAcceleratorCapabilities::DataView input,
    ::gpu::mojom::blink::VideoDecodeAcceleratorCapabilitiesPtr* output) {
  bool success = true;
  ::gpu::mojom::blink::VideoDecodeAcceleratorCapabilitiesPtr result(::gpu::mojom::blink::VideoDecodeAcceleratorCapabilities::New());
  
      if (success && !input.ReadSupportedProfiles(&result->supported_profiles))
        success = false;
      if (success)
        result->flags = input.flags();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::gpu::mojom::blink::VideoEncodeAcceleratorSupportedProfile::DataView, ::gpu::mojom::blink::VideoEncodeAcceleratorSupportedProfilePtr>::Read(
    ::gpu::mojom::blink::VideoEncodeAcceleratorSupportedProfile::DataView input,
    ::gpu::mojom::blink::VideoEncodeAcceleratorSupportedProfilePtr* output) {
  bool success = true;
  ::gpu::mojom::blink::VideoEncodeAcceleratorSupportedProfilePtr result(::gpu::mojom::blink::VideoEncodeAcceleratorSupportedProfile::New());
  
      if (success && !input.ReadProfile(&result->profile))
        success = false;
      if (success && !input.ReadMinResolution(&result->min_resolution))
        success = false;
      if (success && !input.ReadMaxResolution(&result->max_resolution))
        success = false;
      if (success)
        result->max_framerate_numerator = input.max_framerate_numerator();
      if (success)
        result->max_framerate_denominator = input.max_framerate_denominator();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::gpu::mojom::blink::ImageDecodeAcceleratorSupportedProfile::DataView, ::gpu::mojom::blink::ImageDecodeAcceleratorSupportedProfilePtr>::Read(
    ::gpu::mojom::blink::ImageDecodeAcceleratorSupportedProfile::DataView input,
    ::gpu::mojom::blink::ImageDecodeAcceleratorSupportedProfilePtr* output) {
  bool success = true;
  ::gpu::mojom::blink::ImageDecodeAcceleratorSupportedProfilePtr result(::gpu::mojom::blink::ImageDecodeAcceleratorSupportedProfile::New());
  
      if (success && !input.ReadImageType(&result->image_type))
        success = false;
      if (success && !input.ReadMinEncodedDimensions(&result->min_encoded_dimensions))
        success = false;
      if (success && !input.ReadMaxEncodedDimensions(&result->max_encoded_dimensions))
        success = false;
      if (success && !input.ReadSubsamplings(&result->subsamplings))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::gpu::mojom::blink::GpuInfo::DataView, ::gpu::mojom::blink::GpuInfoPtr>::Read(
    ::gpu::mojom::blink::GpuInfo::DataView input,
    ::gpu::mojom::blink::GpuInfoPtr* output) {
  bool success = true;
  ::gpu::mojom::blink::GpuInfoPtr result(::gpu::mojom::blink::GpuInfo::New());
  
      if (success && !input.ReadInitializationTime(&result->initialization_time))
        success = false;
      if (success)
        result->optimus = input.optimus();
      if (success)
        result->amd_switchable = input.amd_switchable();
      if (success && !input.ReadGpu(&result->gpu))
        success = false;
      if (success && !input.ReadSecondaryGpus(&result->secondary_gpus))
        success = false;
      if (success && !input.ReadPixelShaderVersion(&result->pixel_shader_version))
        success = false;
      if (success && !input.ReadVertexShaderVersion(&result->vertex_shader_version))
        success = false;
      if (success && !input.ReadMaxMsaaSamples(&result->max_msaa_samples))
        success = false;
      if (success && !input.ReadMachineModelName(&result->machine_model_name))
        success = false;
      if (success && !input.ReadMachineModelVersion(&result->machine_model_version))
        success = false;
      if (success && !input.ReadGlVersion(&result->gl_version))
        success = false;
      if (success && !input.ReadGlVendor(&result->gl_vendor))
        success = false;
      if (success && !input.ReadGlRenderer(&result->gl_renderer))
        success = false;
      if (success && !input.ReadGlExtensions(&result->gl_extensions))
        success = false;
      if (success && !input.ReadGlWsVendor(&result->gl_ws_vendor))
        success = false;
      if (success && !input.ReadGlWsVersion(&result->gl_ws_version))
        success = false;
      if (success && !input.ReadGlWsExtensions(&result->gl_ws_extensions))
        success = false;
      if (success)
        result->gl_reset_notification_strategy = input.gl_reset_notification_strategy();
      if (success)
        result->software_rendering = input.software_rendering();
      if (success && !input.ReadDirectRenderingVersion(&result->direct_rendering_version))
        success = false;
      if (success)
        result->sandboxed = input.sandboxed();
      if (success)
        result->in_process_gpu = input.in_process_gpu();
      if (success)
        result->passthrough_cmd_decoder = input.passthrough_cmd_decoder();
      if (success)
        result->can_support_threaded_texture_mailbox = input.can_support_threaded_texture_mailbox();
      if (success && !input.ReadVideoDecodeAcceleratorCapabilities(&result->video_decode_accelerator_capabilities))
        success = false;
      if (success && !input.ReadVideoEncodeAcceleratorSupportedProfiles(&result->video_encode_accelerator_supported_profiles))
        success = false;
      if (success)
        result->jpeg_decode_accelerator_supported = input.jpeg_decode_accelerator_supported();
      if (success && !input.ReadImageDecodeAcceleratorSupportedProfiles(&result->image_decode_accelerator_supported_profiles))
        success = false;
      if (success)
        result->oop_rasterization_supported = input.oop_rasterization_supported();
      if (success)
        result->subpixel_font_rendering = input.subpixel_font_rendering();
      if (success && !input.ReadVulkanInfo(&result->vulkan_info))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif