// gpu/ipc/common/gpu_preferences.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "gpu/ipc/common/gpu_preferences.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "gpu/ipc/common/gpu_preferences.mojom-params-data.h"
#include "gpu/ipc/common/gpu_preferences.mojom-shared-message-ids.h"

#include "gpu/ipc/common/gpu_preferences.mojom-import-headers.h"


#ifndef GPU_IPC_COMMON_GPU_PREFERENCES_MOJOM_JUMBO_H_
#define GPU_IPC_COMMON_GPU_PREFERENCES_MOJOM_JUMBO_H_
#endif
namespace gpu {
namespace mojom {
GpuPreferences::GpuPreferences()
    : disable_accelerated_video_decode(),
      disable_accelerated_video_encode(),
      gpu_startup_dialog(),
      disable_gpu_watchdog(),
      gpu_sandbox_start_early(),
      enable_low_latency_dxva(),
      enable_zero_copy_dxgi_video(),
      enable_nv12_dxgi_video(),
      enable_media_foundation_vea_on_windows7(),
      disable_software_rasterizer(),
      log_gpu_control_list_decisions(),
      compile_shader_always_succeeds(),
      disable_gl_error_limit(),
      disable_glsl_translator(),
      disable_shader_name_hashing(),
      enable_gpu_command_logging(),
      enable_gpu_debugging(),
      enable_gpu_service_logging_gpu(),
      enable_gpu_driver_debug_logging(),
      disable_gpu_program_cache(),
      enforce_gl_minimums(),
      force_gpu_mem_available_bytes(),
      force_gpu_mem_discardable_limit_bytes(),
      force_max_texture_size(),
      gpu_program_cache_size(),
      disable_gpu_shader_disk_cache(),
      enable_threaded_texture_mailboxes(),
      gl_shader_interm_output(),
      emulate_shader_precision(),
      enable_android_surface_control(),
      enable_gpu_service_logging(),
      enable_gpu_service_tracing(),
      use_passthrough_cmd_decoder(),
      disable_biplanar_gpu_memory_buffers_for_video_frames(),
      texture_target_exception_list(),
      ignore_gpu_blocklist(),
      enable_oop_rasterization(),
      disable_oop_rasterization(),
      enable_oop_rasterization_ddl(),
      watchdog_starts_backgrounded(),
      gr_context_type(),
      use_vulkan(),
      enable_vulkan_protected_memory(),
      enforce_vulkan_protected_memory(),
      disable_vulkan_surface(),
      disable_vulkan_fallback_to_gl_for_testing(),
      vulkan_heap_memory_limit(),
      vulkan_sync_cpu_memory_limit(),
      enable_metal(),
      enable_gpu_benchmarking_extension(),
      enable_webgpu(),
      enable_dawn_backend_validation(),
      enabled_dawn_features_list(),
      disabled_dawn_features_list(),
      enable_gpu_blocked_time_metric(),
      enable_perf_data_collection(),
      message_pump_type(),
      enable_native_gpu_memory_buffers() {}

GpuPreferences::GpuPreferences(
    bool disable_accelerated_video_decode_in,
    bool disable_accelerated_video_encode_in,
    bool gpu_startup_dialog_in,
    bool disable_gpu_watchdog_in,
    bool gpu_sandbox_start_early_in,
    bool enable_low_latency_dxva_in,
    bool enable_zero_copy_dxgi_video_in,
    bool enable_nv12_dxgi_video_in,
    bool enable_media_foundation_vea_on_windows7_in,
    bool disable_software_rasterizer_in,
    bool log_gpu_control_list_decisions_in,
    bool compile_shader_always_succeeds_in,
    bool disable_gl_error_limit_in,
    bool disable_glsl_translator_in,
    bool disable_shader_name_hashing_in,
    bool enable_gpu_command_logging_in,
    bool enable_gpu_debugging_in,
    bool enable_gpu_service_logging_gpu_in,
    bool enable_gpu_driver_debug_logging_in,
    bool disable_gpu_program_cache_in,
    bool enforce_gl_minimums_in,
    uint32_t force_gpu_mem_available_bytes_in,
    uint32_t force_gpu_mem_discardable_limit_bytes_in,
    uint32_t force_max_texture_size_in,
    uint32_t gpu_program_cache_size_in,
    bool disable_gpu_shader_disk_cache_in,
    bool enable_threaded_texture_mailboxes_in,
    bool gl_shader_interm_output_in,
    bool emulate_shader_precision_in,
    bool enable_android_surface_control_in,
    bool enable_gpu_service_logging_in,
    bool enable_gpu_service_tracing_in,
    bool use_passthrough_cmd_decoder_in,
    bool disable_biplanar_gpu_memory_buffers_for_video_frames_in,
    std::vector<::gfx::BufferUsageAndFormat> texture_target_exception_list_in,
    bool ignore_gpu_blocklist_in,
    bool enable_oop_rasterization_in,
    bool disable_oop_rasterization_in,
    bool enable_oop_rasterization_ddl_in,
    bool watchdog_starts_backgrounded_in,
    GrContextType gr_context_type_in,
    VulkanImplementationName use_vulkan_in,
    bool enable_vulkan_protected_memory_in,
    bool enforce_vulkan_protected_memory_in,
    bool disable_vulkan_surface_in,
    bool disable_vulkan_fallback_to_gl_for_testing_in,
    uint32_t vulkan_heap_memory_limit_in,
    uint32_t vulkan_sync_cpu_memory_limit_in,
    bool enable_metal_in,
    bool enable_gpu_benchmarking_extension_in,
    bool enable_webgpu_in,
    bool enable_dawn_backend_validation_in,
    std::vector<std::string> enabled_dawn_features_list_in,
    std::vector<std::string> disabled_dawn_features_list_in,
    bool enable_gpu_blocked_time_metric_in,
    bool enable_perf_data_collection_in,
    ::base::MessagePumpType message_pump_type_in,
    bool enable_native_gpu_memory_buffers_in)
    : disable_accelerated_video_decode(std::move(disable_accelerated_video_decode_in)),
      disable_accelerated_video_encode(std::move(disable_accelerated_video_encode_in)),
      gpu_startup_dialog(std::move(gpu_startup_dialog_in)),
      disable_gpu_watchdog(std::move(disable_gpu_watchdog_in)),
      gpu_sandbox_start_early(std::move(gpu_sandbox_start_early_in)),
      enable_low_latency_dxva(std::move(enable_low_latency_dxva_in)),
      enable_zero_copy_dxgi_video(std::move(enable_zero_copy_dxgi_video_in)),
      enable_nv12_dxgi_video(std::move(enable_nv12_dxgi_video_in)),
      enable_media_foundation_vea_on_windows7(std::move(enable_media_foundation_vea_on_windows7_in)),
      disable_software_rasterizer(std::move(disable_software_rasterizer_in)),
      log_gpu_control_list_decisions(std::move(log_gpu_control_list_decisions_in)),
      compile_shader_always_succeeds(std::move(compile_shader_always_succeeds_in)),
      disable_gl_error_limit(std::move(disable_gl_error_limit_in)),
      disable_glsl_translator(std::move(disable_glsl_translator_in)),
      disable_shader_name_hashing(std::move(disable_shader_name_hashing_in)),
      enable_gpu_command_logging(std::move(enable_gpu_command_logging_in)),
      enable_gpu_debugging(std::move(enable_gpu_debugging_in)),
      enable_gpu_service_logging_gpu(std::move(enable_gpu_service_logging_gpu_in)),
      enable_gpu_driver_debug_logging(std::move(enable_gpu_driver_debug_logging_in)),
      disable_gpu_program_cache(std::move(disable_gpu_program_cache_in)),
      enforce_gl_minimums(std::move(enforce_gl_minimums_in)),
      force_gpu_mem_available_bytes(std::move(force_gpu_mem_available_bytes_in)),
      force_gpu_mem_discardable_limit_bytes(std::move(force_gpu_mem_discardable_limit_bytes_in)),
      force_max_texture_size(std::move(force_max_texture_size_in)),
      gpu_program_cache_size(std::move(gpu_program_cache_size_in)),
      disable_gpu_shader_disk_cache(std::move(disable_gpu_shader_disk_cache_in)),
      enable_threaded_texture_mailboxes(std::move(enable_threaded_texture_mailboxes_in)),
      gl_shader_interm_output(std::move(gl_shader_interm_output_in)),
      emulate_shader_precision(std::move(emulate_shader_precision_in)),
      enable_android_surface_control(std::move(enable_android_surface_control_in)),
      enable_gpu_service_logging(std::move(enable_gpu_service_logging_in)),
      enable_gpu_service_tracing(std::move(enable_gpu_service_tracing_in)),
      use_passthrough_cmd_decoder(std::move(use_passthrough_cmd_decoder_in)),
      disable_biplanar_gpu_memory_buffers_for_video_frames(std::move(disable_biplanar_gpu_memory_buffers_for_video_frames_in)),
      texture_target_exception_list(std::move(texture_target_exception_list_in)),
      ignore_gpu_blocklist(std::move(ignore_gpu_blocklist_in)),
      enable_oop_rasterization(std::move(enable_oop_rasterization_in)),
      disable_oop_rasterization(std::move(disable_oop_rasterization_in)),
      enable_oop_rasterization_ddl(std::move(enable_oop_rasterization_ddl_in)),
      watchdog_starts_backgrounded(std::move(watchdog_starts_backgrounded_in)),
      gr_context_type(std::move(gr_context_type_in)),
      use_vulkan(std::move(use_vulkan_in)),
      enable_vulkan_protected_memory(std::move(enable_vulkan_protected_memory_in)),
      enforce_vulkan_protected_memory(std::move(enforce_vulkan_protected_memory_in)),
      disable_vulkan_surface(std::move(disable_vulkan_surface_in)),
      disable_vulkan_fallback_to_gl_for_testing(std::move(disable_vulkan_fallback_to_gl_for_testing_in)),
      vulkan_heap_memory_limit(std::move(vulkan_heap_memory_limit_in)),
      vulkan_sync_cpu_memory_limit(std::move(vulkan_sync_cpu_memory_limit_in)),
      enable_metal(std::move(enable_metal_in)),
      enable_gpu_benchmarking_extension(std::move(enable_gpu_benchmarking_extension_in)),
      enable_webgpu(std::move(enable_webgpu_in)),
      enable_dawn_backend_validation(std::move(enable_dawn_backend_validation_in)),
      enabled_dawn_features_list(std::move(enabled_dawn_features_list_in)),
      disabled_dawn_features_list(std::move(disabled_dawn_features_list_in)),
      enable_gpu_blocked_time_metric(std::move(enable_gpu_blocked_time_metric_in)),
      enable_perf_data_collection(std::move(enable_perf_data_collection_in)),
      message_pump_type(std::move(message_pump_type_in)),
      enable_native_gpu_memory_buffers(std::move(enable_native_gpu_memory_buffers_in)) {}

GpuPreferences::~GpuPreferences() = default;

void GpuPreferences::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "disable_accelerated_video_decode"), this->disable_accelerated_video_decode, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "disable_accelerated_video_encode"), this->disable_accelerated_video_encode, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "gpu_startup_dialog"), this->gpu_startup_dialog, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "disable_gpu_watchdog"), this->disable_gpu_watchdog, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "gpu_sandbox_start_early"), this->gpu_sandbox_start_early, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_low_latency_dxva"), this->enable_low_latency_dxva, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_zero_copy_dxgi_video"), this->enable_zero_copy_dxgi_video, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_nv12_dxgi_video"), this->enable_nv12_dxgi_video, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_media_foundation_vea_on_windows7"), this->enable_media_foundation_vea_on_windows7, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "disable_software_rasterizer"), this->disable_software_rasterizer, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "log_gpu_control_list_decisions"), this->log_gpu_control_list_decisions, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "compile_shader_always_succeeds"), this->compile_shader_always_succeeds, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "disable_gl_error_limit"), this->disable_gl_error_limit, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "disable_glsl_translator"), this->disable_glsl_translator, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "disable_shader_name_hashing"), this->disable_shader_name_hashing, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_gpu_command_logging"), this->enable_gpu_command_logging, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_gpu_debugging"), this->enable_gpu_debugging, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_gpu_service_logging_gpu"), this->enable_gpu_service_logging_gpu, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_gpu_driver_debug_logging"), this->enable_gpu_driver_debug_logging, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "disable_gpu_program_cache"), this->disable_gpu_program_cache, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enforce_gl_minimums"), this->enforce_gl_minimums, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "force_gpu_mem_available_bytes"), this->force_gpu_mem_available_bytes, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "force_gpu_mem_discardable_limit_bytes"), this->force_gpu_mem_discardable_limit_bytes, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "force_max_texture_size"), this->force_max_texture_size, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "gpu_program_cache_size"), this->gpu_program_cache_size, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "disable_gpu_shader_disk_cache"), this->disable_gpu_shader_disk_cache, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_threaded_texture_mailboxes"), this->enable_threaded_texture_mailboxes, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "gl_shader_interm_output"), this->gl_shader_interm_output, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "emulate_shader_precision"), this->emulate_shader_precision, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_android_surface_control"), this->enable_android_surface_control, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_gpu_service_logging"), this->enable_gpu_service_logging, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_gpu_service_tracing"), this->enable_gpu_service_tracing, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "use_passthrough_cmd_decoder"), this->use_passthrough_cmd_decoder, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "disable_biplanar_gpu_memory_buffers_for_video_frames"), this->disable_biplanar_gpu_memory_buffers_for_video_frames, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "texture_target_exception_list"), this->texture_target_exception_list, 
      "<value of type const std::vector<::gfx::BufferUsageAndFormat>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ignore_gpu_blocklist"), this->ignore_gpu_blocklist, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_oop_rasterization"), this->enable_oop_rasterization, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "disable_oop_rasterization"), this->disable_oop_rasterization, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_oop_rasterization_ddl"), this->enable_oop_rasterization_ddl, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "watchdog_starts_backgrounded"), this->watchdog_starts_backgrounded, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "gr_context_type"), this->gr_context_type, 
      "<value of type GrContextType>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "use_vulkan"), this->use_vulkan, 
      "<value of type VulkanImplementationName>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_vulkan_protected_memory"), this->enable_vulkan_protected_memory, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enforce_vulkan_protected_memory"), this->enforce_vulkan_protected_memory, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "disable_vulkan_surface"), this->disable_vulkan_surface, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "disable_vulkan_fallback_to_gl_for_testing"), this->disable_vulkan_fallback_to_gl_for_testing, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "vulkan_heap_memory_limit"), this->vulkan_heap_memory_limit, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "vulkan_sync_cpu_memory_limit"), this->vulkan_sync_cpu_memory_limit, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_metal"), this->enable_metal, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_gpu_benchmarking_extension"), this->enable_gpu_benchmarking_extension, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_webgpu"), this->enable_webgpu, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_dawn_backend_validation"), this->enable_dawn_backend_validation, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enabled_dawn_features_list"), this->enabled_dawn_features_list, 
      "<value of type const std::vector<std::string>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "disabled_dawn_features_list"), this->disabled_dawn_features_list, 
      "<value of type const std::vector<std::string>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_gpu_blocked_time_metric"), this->enable_gpu_blocked_time_metric, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_perf_data_collection"), this->enable_perf_data_collection, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "message_pump_type"), this->message_pump_type, 
      "<value of type ::base::MessagePumpType>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_native_gpu_memory_buffers"), this->enable_native_gpu_memory_buffers, 
      "<value of type bool>");
}

bool GpuPreferences::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace mojom
}  // namespace gpu

namespace mojo {


// static
bool StructTraits<::gpu::mojom::GpuPreferences::DataView, ::gpu::mojom::GpuPreferencesPtr>::Read(
    ::gpu::mojom::GpuPreferences::DataView input,
    ::gpu::mojom::GpuPreferencesPtr* output) {
  bool success = true;
  ::gpu::mojom::GpuPreferencesPtr result(::gpu::mojom::GpuPreferences::New());
  
      if (success)
        result->disable_accelerated_video_decode = input.disable_accelerated_video_decode();
      if (success)
        result->disable_accelerated_video_encode = input.disable_accelerated_video_encode();
      if (success)
        result->gpu_startup_dialog = input.gpu_startup_dialog();
      if (success)
        result->disable_gpu_watchdog = input.disable_gpu_watchdog();
      if (success)
        result->gpu_sandbox_start_early = input.gpu_sandbox_start_early();
      if (success)
        result->enable_low_latency_dxva = input.enable_low_latency_dxva();
      if (success)
        result->enable_zero_copy_dxgi_video = input.enable_zero_copy_dxgi_video();
      if (success)
        result->enable_nv12_dxgi_video = input.enable_nv12_dxgi_video();
      if (success)
        result->enable_media_foundation_vea_on_windows7 = input.enable_media_foundation_vea_on_windows7();
      if (success)
        result->disable_software_rasterizer = input.disable_software_rasterizer();
      if (success)
        result->log_gpu_control_list_decisions = input.log_gpu_control_list_decisions();
      if (success)
        result->compile_shader_always_succeeds = input.compile_shader_always_succeeds();
      if (success)
        result->disable_gl_error_limit = input.disable_gl_error_limit();
      if (success)
        result->disable_glsl_translator = input.disable_glsl_translator();
      if (success)
        result->disable_shader_name_hashing = input.disable_shader_name_hashing();
      if (success)
        result->enable_gpu_command_logging = input.enable_gpu_command_logging();
      if (success)
        result->enable_gpu_debugging = input.enable_gpu_debugging();
      if (success)
        result->enable_gpu_service_logging_gpu = input.enable_gpu_service_logging_gpu();
      if (success)
        result->enable_gpu_driver_debug_logging = input.enable_gpu_driver_debug_logging();
      if (success)
        result->disable_gpu_program_cache = input.disable_gpu_program_cache();
      if (success)
        result->enforce_gl_minimums = input.enforce_gl_minimums();
      if (success)
        result->force_gpu_mem_available_bytes = input.force_gpu_mem_available_bytes();
      if (success)
        result->force_gpu_mem_discardable_limit_bytes = input.force_gpu_mem_discardable_limit_bytes();
      if (success)
        result->force_max_texture_size = input.force_max_texture_size();
      if (success)
        result->gpu_program_cache_size = input.gpu_program_cache_size();
      if (success)
        result->disable_gpu_shader_disk_cache = input.disable_gpu_shader_disk_cache();
      if (success)
        result->enable_threaded_texture_mailboxes = input.enable_threaded_texture_mailboxes();
      if (success)
        result->gl_shader_interm_output = input.gl_shader_interm_output();
      if (success)
        result->emulate_shader_precision = input.emulate_shader_precision();
      if (success)
        result->enable_android_surface_control = input.enable_android_surface_control();
      if (success)
        result->enable_gpu_service_logging = input.enable_gpu_service_logging();
      if (success)
        result->enable_gpu_service_tracing = input.enable_gpu_service_tracing();
      if (success)
        result->use_passthrough_cmd_decoder = input.use_passthrough_cmd_decoder();
      if (success)
        result->disable_biplanar_gpu_memory_buffers_for_video_frames = input.disable_biplanar_gpu_memory_buffers_for_video_frames();
      if (success && !input.ReadTextureTargetExceptionList(&result->texture_target_exception_list))
        success = false;
      if (success)
        result->ignore_gpu_blocklist = input.ignore_gpu_blocklist();
      if (success)
        result->enable_oop_rasterization = input.enable_oop_rasterization();
      if (success)
        result->disable_oop_rasterization = input.disable_oop_rasterization();
      if (success)
        result->enable_oop_rasterization_ddl = input.enable_oop_rasterization_ddl();
      if (success)
        result->watchdog_starts_backgrounded = input.watchdog_starts_backgrounded();
      if (success && !input.ReadGrContextType(&result->gr_context_type))
        success = false;
      if (success && !input.ReadUseVulkan(&result->use_vulkan))
        success = false;
      if (success)
        result->enable_vulkan_protected_memory = input.enable_vulkan_protected_memory();
      if (success)
        result->enforce_vulkan_protected_memory = input.enforce_vulkan_protected_memory();
      if (success)
        result->disable_vulkan_surface = input.disable_vulkan_surface();
      if (success)
        result->disable_vulkan_fallback_to_gl_for_testing = input.disable_vulkan_fallback_to_gl_for_testing();
      if (success)
        result->vulkan_heap_memory_limit = input.vulkan_heap_memory_limit();
      if (success)
        result->vulkan_sync_cpu_memory_limit = input.vulkan_sync_cpu_memory_limit();
      if (success)
        result->enable_metal = input.enable_metal();
      if (success)
        result->enable_gpu_benchmarking_extension = input.enable_gpu_benchmarking_extension();
      if (success)
        result->enable_webgpu = input.enable_webgpu();
      if (success)
        result->enable_dawn_backend_validation = input.enable_dawn_backend_validation();
      if (success && !input.ReadEnabledDawnFeaturesList(&result->enabled_dawn_features_list))
        success = false;
      if (success && !input.ReadDisabledDawnFeaturesList(&result->disabled_dawn_features_list))
        success = false;
      if (success)
        result->enable_gpu_blocked_time_metric = input.enable_gpu_blocked_time_metric();
      if (success)
        result->enable_perf_data_collection = input.enable_perf_data_collection();
      if (success && !input.ReadMessagePumpType(&result->message_pump_type))
        success = false;
      if (success)
        result->enable_native_gpu_memory_buffers = input.enable_native_gpu_memory_buffers();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif