// gpu/ipc/common/memory_stats.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "gpu/ipc/common/memory_stats.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "gpu/ipc/common/memory_stats.mojom-params-data.h"
namespace gpu {
namespace mojom {

namespace internal {


// static
bool VideoMemoryProcessStats_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VideoMemoryProcessStats_Data* object = static_cast<const VideoMemoryProcessStats_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

VideoMemoryProcessStats_Data::VideoMemoryProcessStats_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoMemoryUsageStats_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VideoMemoryUsageStats_Data* object = static_cast<const VideoMemoryUsageStats_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->process_map, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams process_map_validate_params(
      new mojo::internal::ContainerValidateParams(0, false, nullptr), new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->process_map, validation_context,
                                         &process_map_validate_params)) {
    return false;
  }

  return true;
}

VideoMemoryUsageStats_Data::VideoMemoryUsageStats_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace gpu
