// gpu/ipc/common/sync_token.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "gpu/ipc/common/sync_token.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "gpu/ipc/common/sync_token.mojom-params-data.h"
namespace gpu {
namespace mojom {

std::string CommandBufferNamespaceToString(CommandBufferNamespace value) {
  switch(value) {
    case CommandBufferNamespace::INVALID:
      return "CommandBufferNamespace::INVALID";
    case CommandBufferNamespace::GPU_IO:
      return "CommandBufferNamespace::GPU_IO";
    case CommandBufferNamespace::IN_PROCESS:
      return "CommandBufferNamespace::IN_PROCESS";
    case CommandBufferNamespace::MOJO:
      return "CommandBufferNamespace::MOJO";
    case CommandBufferNamespace::MOJO_LOCAL:
      return "CommandBufferNamespace::MOJO_LOCAL";
    case CommandBufferNamespace::NUM_COMMAND_BUFFER_NAMESPACES:
      return "CommandBufferNamespace::NUM_COMMAND_BUFFER_NAMESPACES";
    default:
      return base::StringPrintf("Unknown CommandBufferNamespace value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, CommandBufferNamespace value) {
  return os << CommandBufferNamespaceToString(value);
}

namespace internal {


// static
bool SyncToken_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SyncToken_Data* object = static_cast<const SyncToken_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::gpu::mojom::internal::CommandBufferNamespace_Data
        ::Validate(object->namespace_id, validation_context))
    return false;

  return true;
}

SyncToken_Data::SyncToken_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace gpu

namespace perfetto {

// static
void TraceFormatTraits<::gpu::mojom::CommandBufferNamespace>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::gpu::mojom::CommandBufferNamespace value) {
  return std::move(context).WriteString(::gpu::mojom::CommandBufferNamespaceToString(value));
}

} // namespace perfetto
