// gpu/ipc/common/vulkan_info.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "gpu/ipc/common/vulkan_info.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "gpu/ipc/common/vulkan_info.mojom-params-data.h"
#include "gpu/ipc/common/vulkan_info.mojom-shared-message-ids.h"

#include "gpu/ipc/common/vulkan_info.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef GPU_IPC_COMMON_VULKAN_INFO_MOJOM_BLINK_JUMBO_H_
#define GPU_IPC_COMMON_VULKAN_INFO_MOJOM_BLINK_JUMBO_H_
#endif
namespace gpu {
namespace mojom {
namespace blink {
VulkanPhysicalDeviceInfo::VulkanPhysicalDeviceInfo()
    : properties(),
      extensions(),
      features(),
      feature_sampler_ycbcr_conversion(),
      feature_protected_memory(),
      queue_families() {}

VulkanPhysicalDeviceInfo::VulkanPhysicalDeviceInfo(
    ::gpu::mojom::blink::VkPhysicalDevicePropertiesPtr properties_in,
    WTF::Vector<::gpu::mojom::blink::VkExtensionPropertiesPtr> extensions_in,
    ::gpu::mojom::blink::VkPhysicalDeviceFeaturesPtr features_in,
    bool feature_sampler_ycbcr_conversion_in,
    bool feature_protected_memory_in,
    WTF::Vector<::gpu::mojom::blink::VkQueueFamilyPropertiesPtr> queue_families_in)
    : properties(std::move(properties_in)),
      extensions(std::move(extensions_in)),
      features(std::move(features_in)),
      feature_sampler_ycbcr_conversion(std::move(feature_sampler_ycbcr_conversion_in)),
      feature_protected_memory(std::move(feature_protected_memory_in)),
      queue_families(std::move(queue_families_in)) {}

VulkanPhysicalDeviceInfo::~VulkanPhysicalDeviceInfo() = default;

void VulkanPhysicalDeviceInfo::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "properties"), this->properties, 
      "<value of type ::gpu::mojom::blink::VkPhysicalDevicePropertiesPtr>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "extensions"), this->extensions, 
      "<value of type WTF::Vector<::gpu::mojom::blink::VkExtensionPropertiesPtr>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "features"), this->features, 
      "<value of type ::gpu::mojom::blink::VkPhysicalDeviceFeaturesPtr>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "feature_sampler_ycbcr_conversion"), this->feature_sampler_ycbcr_conversion, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "feature_protected_memory"), this->feature_protected_memory, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "queue_families"), this->queue_families, 
      "<value of type WTF::Vector<::gpu::mojom::blink::VkQueueFamilyPropertiesPtr>>");
}

bool VulkanPhysicalDeviceInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VulkanInfo::VulkanInfo()
    : api_version(),
      used_api_version(),
      instance_extensions(),
      enabled_instance_extensions(),
      instance_layers(),
      physical_devices() {}

VulkanInfo::VulkanInfo(
    uint32_t api_version_in,
    uint32_t used_api_version_in,
    WTF::Vector<::gpu::mojom::blink::VkExtensionPropertiesPtr> instance_extensions_in,
    WTF::Vector<WTF::String> enabled_instance_extensions_in,
    WTF::Vector<::gpu::mojom::blink::VkLayerPropertiesPtr> instance_layers_in,
    WTF::Vector<VulkanPhysicalDeviceInfoPtr> physical_devices_in)
    : api_version(std::move(api_version_in)),
      used_api_version(std::move(used_api_version_in)),
      instance_extensions(std::move(instance_extensions_in)),
      enabled_instance_extensions(std::move(enabled_instance_extensions_in)),
      instance_layers(std::move(instance_layers_in)),
      physical_devices(std::move(physical_devices_in)) {}

VulkanInfo::~VulkanInfo() = default;

void VulkanInfo::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "api_version"), this->api_version, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "used_api_version"), this->used_api_version, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "instance_extensions"), this->instance_extensions, 
      "<value of type WTF::Vector<::gpu::mojom::blink::VkExtensionPropertiesPtr>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enabled_instance_extensions"), this->enabled_instance_extensions, 
      "<value of type const WTF::Vector<WTF::String>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "instance_layers"), this->instance_layers, 
      "<value of type WTF::Vector<::gpu::mojom::blink::VkLayerPropertiesPtr>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "physical_devices"), this->physical_devices, 
      "<value of type WTF::Vector<VulkanPhysicalDeviceInfoPtr>>");
}

bool VulkanInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace blink
}  // namespace mojom
}  // namespace gpu

namespace mojo {


// static
bool StructTraits<::gpu::mojom::blink::VulkanPhysicalDeviceInfo::DataView, ::gpu::mojom::blink::VulkanPhysicalDeviceInfoPtr>::Read(
    ::gpu::mojom::blink::VulkanPhysicalDeviceInfo::DataView input,
    ::gpu::mojom::blink::VulkanPhysicalDeviceInfoPtr* output) {
  bool success = true;
  ::gpu::mojom::blink::VulkanPhysicalDeviceInfoPtr result(::gpu::mojom::blink::VulkanPhysicalDeviceInfo::New());
  
      if (success && !input.ReadProperties(&result->properties))
        success = false;
      if (success && !input.ReadExtensions(&result->extensions))
        success = false;
      if (success && !input.ReadFeatures(&result->features))
        success = false;
      if (success)
        result->feature_sampler_ycbcr_conversion = input.feature_sampler_ycbcr_conversion();
      if (success)
        result->feature_protected_memory = input.feature_protected_memory();
      if (success && !input.ReadQueueFamilies(&result->queue_families))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::gpu::mojom::blink::VulkanInfo::DataView, ::gpu::mojom::blink::VulkanInfoPtr>::Read(
    ::gpu::mojom::blink::VulkanInfo::DataView input,
    ::gpu::mojom::blink::VulkanInfoPtr* output) {
  bool success = true;
  ::gpu::mojom::blink::VulkanInfoPtr result(::gpu::mojom::blink::VulkanInfo::New());
  
      if (success)
        result->api_version = input.api_version();
      if (success)
        result->used_api_version = input.used_api_version();
      if (success && !input.ReadInstanceExtensions(&result->instance_extensions))
        success = false;
      if (success && !input.ReadEnabledInstanceExtensions(&result->enabled_instance_extensions))
        success = false;
      if (success && !input.ReadInstanceLayers(&result->instance_layers))
        success = false;
      if (success && !input.ReadPhysicalDevices(&result->physical_devices))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif