// gpu/ipc/common/vulkan_info.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "gpu/ipc/common/vulkan_info.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "gpu/ipc/common/vulkan_info.mojom-params-data.h"
namespace gpu {
namespace mojom {

namespace internal {


// static
bool VulkanPhysicalDeviceInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VulkanPhysicalDeviceInfo_Data* object = static_cast<const VulkanPhysicalDeviceInfo_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->properties, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->properties, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->extensions, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams extensions_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->extensions, validation_context,
                                         &extensions_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->features, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->features, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->queue_families, 6, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams queue_families_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->queue_families, validation_context,
                                         &queue_families_validate_params)) {
    return false;
  }

  return true;
}

VulkanPhysicalDeviceInfo_Data::VulkanPhysicalDeviceInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VulkanInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VulkanInfo_Data* object = static_cast<const VulkanInfo_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->instance_extensions, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams instance_extensions_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->instance_extensions, validation_context,
                                         &instance_extensions_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->enabled_instance_extensions, 4, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams enabled_instance_extensions_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->enabled_instance_extensions, validation_context,
                                         &enabled_instance_extensions_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->instance_layers, 5, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams instance_layers_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->instance_layers, validation_context,
                                         &instance_layers_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->physical_devices, 6, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams physical_devices_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->physical_devices, validation_context,
                                         &physical_devices_validate_params)) {
    return false;
  }

  return true;
}

VulkanInfo_Data::VulkanInfo_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace gpu
