// gpu/ipc/common/vulkan_types.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "gpu/ipc/common/vulkan_types.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "gpu/ipc/common/vulkan_types.mojom-params-data.h"
#include "gpu/ipc/common/vulkan_types.mojom-shared-message-ids.h"

#include "gpu/ipc/common/vulkan_types.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef GPU_IPC_COMMON_VULKAN_TYPES_MOJOM_BLINK_JUMBO_H_
#define GPU_IPC_COMMON_VULKAN_TYPES_MOJOM_BLINK_JUMBO_H_
#endif
namespace gpu {
namespace mojom {
namespace blink {
VkExtensionProperties::VkExtensionProperties()
    : extensionName(),
      specVersion() {}

VkExtensionProperties::VkExtensionProperties(
    const WTF::String& extensionName_in,
    uint32_t specVersion_in)
    : extensionName(std::move(extensionName_in)),
      specVersion(std::move(specVersion_in)) {}

VkExtensionProperties::~VkExtensionProperties() = default;
size_t VkExtensionProperties::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->extensionName);
  seed = mojo::internal::WTFHash(seed, this->specVersion);
  return seed;
}

void VkExtensionProperties::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "extensionName"), this->extensionName, 
      "<value of type const WTF::String&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "specVersion"), this->specVersion, 
      "<value of type uint32_t>");
}

bool VkExtensionProperties::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VkLayerProperties::VkLayerProperties()
    : layerName(),
      specVersion(),
      implementationVersion(),
      description() {}

VkLayerProperties::VkLayerProperties(
    const WTF::String& layerName_in,
    uint32_t specVersion_in,
    uint32_t implementationVersion_in,
    const WTF::String& description_in)
    : layerName(std::move(layerName_in)),
      specVersion(std::move(specVersion_in)),
      implementationVersion(std::move(implementationVersion_in)),
      description(std::move(description_in)) {}

VkLayerProperties::~VkLayerProperties() = default;
size_t VkLayerProperties::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->layerName);
  seed = mojo::internal::WTFHash(seed, this->specVersion);
  seed = mojo::internal::WTFHash(seed, this->implementationVersion);
  seed = mojo::internal::WTFHash(seed, this->description);
  return seed;
}

void VkLayerProperties::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "layerName"), this->layerName, 
      "<value of type const WTF::String&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "specVersion"), this->specVersion, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "implementationVersion"), this->implementationVersion, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "description"), this->description, 
      "<value of type const WTF::String&>");
}

bool VkLayerProperties::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VkPhysicalDeviceLimits::VkPhysicalDeviceLimits()
    : maxImageDimension1D(),
      maxImageDimension2D(),
      maxImageDimension3D(),
      maxImageDimensionCube(),
      maxImageArrayLayers(),
      maxTexelBufferElements(),
      maxUniformBufferRange(),
      maxStorageBufferRange(),
      maxPushConstantsSize(),
      maxMemoryAllocationCount(),
      maxSamplerAllocationCount(),
      bufferImageGranularity(),
      sparseAddressSpaceSize(),
      maxBoundDescriptorSets(),
      maxPerStageDescriptorSamplers(),
      maxPerStageDescriptorUniformBuffers(),
      maxPerStageDescriptorStorageBuffers(),
      maxPerStageDescriptorSampledImages(),
      maxPerStageDescriptorStorageImages(),
      maxPerStageDescriptorInputAttachments(),
      maxPerStageResources(),
      maxDescriptorSetSamplers(),
      maxDescriptorSetUniformBuffers(),
      maxDescriptorSetUniformBuffersDynamic(),
      maxDescriptorSetStorageBuffers(),
      maxDescriptorSetStorageBuffersDynamic(),
      maxDescriptorSetSampledImages(),
      maxDescriptorSetStorageImages(),
      maxDescriptorSetInputAttachments(),
      maxVertexInputAttributes(),
      maxVertexInputBindings(),
      maxVertexInputAttributeOffset(),
      maxVertexInputBindingStride(),
      maxVertexOutputComponents(),
      maxTessellationGenerationLevel(),
      maxTessellationPatchSize(),
      maxTessellationControlPerVertexInputComponents(),
      maxTessellationControlPerVertexOutputComponents(),
      maxTessellationControlPerPatchOutputComponents(),
      maxTessellationControlTotalOutputComponents(),
      maxTessellationEvaluationInputComponents(),
      maxTessellationEvaluationOutputComponents(),
      maxGeometryShaderInvocations(),
      maxGeometryInputComponents(),
      maxGeometryOutputComponents(),
      maxGeometryOutputVertices(),
      maxGeometryTotalOutputComponents(),
      maxFragmentInputComponents(),
      maxFragmentOutputAttachments(),
      maxFragmentDualSrcAttachments(),
      maxFragmentCombinedOutputResources(),
      maxComputeSharedMemorySize(),
      maxComputeWorkGroupCount(),
      maxComputeWorkGroupInvocations(),
      maxComputeWorkGroupSize(),
      subPixelPrecisionBits(),
      subTexelPrecisionBits(),
      mipmapPrecisionBits(),
      maxDrawIndexedIndexValue(),
      maxDrawIndirectCount(),
      maxSamplerLodBias(),
      maxSamplerAnisotropy(),
      maxViewports(),
      maxViewportDimensions(),
      viewportBoundsRange(),
      viewportSubPixelBits(),
      minMemoryMapAlignment(),
      minTexelBufferOffsetAlignment(),
      minUniformBufferOffsetAlignment(),
      minStorageBufferOffsetAlignment(),
      minTexelOffset(),
      maxTexelOffset(),
      minTexelGatherOffset(),
      maxTexelGatherOffset(),
      minInterpolationOffset(),
      maxInterpolationOffset(),
      subPixelInterpolationOffsetBits(),
      maxFramebufferWidth(),
      maxFramebufferHeight(),
      maxFramebufferLayers(),
      framebufferColorSampleCounts(),
      framebufferDepthSampleCounts(),
      framebufferStencilSampleCounts(),
      framebufferNoAttachmentsSampleCounts(),
      maxColorAttachments(),
      sampledImageColorSampleCounts(),
      sampledImageIntegerSampleCounts(),
      sampledImageDepthSampleCounts(),
      sampledImageStencilSampleCounts(),
      storageImageSampleCounts(),
      maxSampleMaskWords(),
      timestampComputeAndGraphics(),
      timestampPeriod(),
      maxClipDistances(),
      maxCullDistances(),
      maxCombinedClipAndCullDistances(),
      discreteQueuePriorities(),
      pointSizeRange(),
      lineWidthRange(),
      pointSizeGranularity(),
      lineWidthGranularity(),
      strictLines(),
      standardSampleLocations(),
      optimalBufferCopyOffsetAlignment(),
      optimalBufferCopyRowPitchAlignment(),
      nonCoherentAtomSize() {}

VkPhysicalDeviceLimits::VkPhysicalDeviceLimits(
    uint32_t maxImageDimension1D_in,
    uint32_t maxImageDimension2D_in,
    uint32_t maxImageDimension3D_in,
    uint32_t maxImageDimensionCube_in,
    uint32_t maxImageArrayLayers_in,
    uint32_t maxTexelBufferElements_in,
    uint32_t maxUniformBufferRange_in,
    uint32_t maxStorageBufferRange_in,
    uint32_t maxPushConstantsSize_in,
    uint32_t maxMemoryAllocationCount_in,
    uint32_t maxSamplerAllocationCount_in,
    uint64_t bufferImageGranularity_in,
    uint64_t sparseAddressSpaceSize_in,
    uint32_t maxBoundDescriptorSets_in,
    uint32_t maxPerStageDescriptorSamplers_in,
    uint32_t maxPerStageDescriptorUniformBuffers_in,
    uint32_t maxPerStageDescriptorStorageBuffers_in,
    uint32_t maxPerStageDescriptorSampledImages_in,
    uint32_t maxPerStageDescriptorStorageImages_in,
    uint32_t maxPerStageDescriptorInputAttachments_in,
    uint32_t maxPerStageResources_in,
    uint32_t maxDescriptorSetSamplers_in,
    uint32_t maxDescriptorSetUniformBuffers_in,
    uint32_t maxDescriptorSetUniformBuffersDynamic_in,
    uint32_t maxDescriptorSetStorageBuffers_in,
    uint32_t maxDescriptorSetStorageBuffersDynamic_in,
    uint32_t maxDescriptorSetSampledImages_in,
    uint32_t maxDescriptorSetStorageImages_in,
    uint32_t maxDescriptorSetInputAttachments_in,
    uint32_t maxVertexInputAttributes_in,
    uint32_t maxVertexInputBindings_in,
    uint32_t maxVertexInputAttributeOffset_in,
    uint32_t maxVertexInputBindingStride_in,
    uint32_t maxVertexOutputComponents_in,
    uint32_t maxTessellationGenerationLevel_in,
    uint32_t maxTessellationPatchSize_in,
    uint32_t maxTessellationControlPerVertexInputComponents_in,
    uint32_t maxTessellationControlPerVertexOutputComponents_in,
    uint32_t maxTessellationControlPerPatchOutputComponents_in,
    uint32_t maxTessellationControlTotalOutputComponents_in,
    uint32_t maxTessellationEvaluationInputComponents_in,
    uint32_t maxTessellationEvaluationOutputComponents_in,
    uint32_t maxGeometryShaderInvocations_in,
    uint32_t maxGeometryInputComponents_in,
    uint32_t maxGeometryOutputComponents_in,
    uint32_t maxGeometryOutputVertices_in,
    uint32_t maxGeometryTotalOutputComponents_in,
    uint32_t maxFragmentInputComponents_in,
    uint32_t maxFragmentOutputAttachments_in,
    uint32_t maxFragmentDualSrcAttachments_in,
    uint32_t maxFragmentCombinedOutputResources_in,
    uint32_t maxComputeSharedMemorySize_in,
    WTF::Vector<uint32_t> maxComputeWorkGroupCount_in,
    uint32_t maxComputeWorkGroupInvocations_in,
    WTF::Vector<uint32_t> maxComputeWorkGroupSize_in,
    uint32_t subPixelPrecisionBits_in,
    uint32_t subTexelPrecisionBits_in,
    uint32_t mipmapPrecisionBits_in,
    uint32_t maxDrawIndexedIndexValue_in,
    uint32_t maxDrawIndirectCount_in,
    float maxSamplerLodBias_in,
    float maxSamplerAnisotropy_in,
    uint32_t maxViewports_in,
    WTF::Vector<uint32_t> maxViewportDimensions_in,
    WTF::Vector<float> viewportBoundsRange_in,
    uint32_t viewportSubPixelBits_in,
    uint64_t minMemoryMapAlignment_in,
    uint64_t minTexelBufferOffsetAlignment_in,
    uint64_t minUniformBufferOffsetAlignment_in,
    uint64_t minStorageBufferOffsetAlignment_in,
    int32_t minTexelOffset_in,
    uint32_t maxTexelOffset_in,
    int32_t minTexelGatherOffset_in,
    uint32_t maxTexelGatherOffset_in,
    float minInterpolationOffset_in,
    float maxInterpolationOffset_in,
    uint32_t subPixelInterpolationOffsetBits_in,
    uint32_t maxFramebufferWidth_in,
    uint32_t maxFramebufferHeight_in,
    uint32_t maxFramebufferLayers_in,
    uint32_t framebufferColorSampleCounts_in,
    uint32_t framebufferDepthSampleCounts_in,
    uint32_t framebufferStencilSampleCounts_in,
    uint32_t framebufferNoAttachmentsSampleCounts_in,
    uint32_t maxColorAttachments_in,
    uint32_t sampledImageColorSampleCounts_in,
    uint32_t sampledImageIntegerSampleCounts_in,
    uint32_t sampledImageDepthSampleCounts_in,
    uint32_t sampledImageStencilSampleCounts_in,
    uint32_t storageImageSampleCounts_in,
    uint32_t maxSampleMaskWords_in,
    bool timestampComputeAndGraphics_in,
    float timestampPeriod_in,
    uint32_t maxClipDistances_in,
    uint32_t maxCullDistances_in,
    uint32_t maxCombinedClipAndCullDistances_in,
    uint32_t discreteQueuePriorities_in,
    WTF::Vector<float> pointSizeRange_in,
    WTF::Vector<float> lineWidthRange_in,
    float pointSizeGranularity_in,
    float lineWidthGranularity_in,
    bool strictLines_in,
    bool standardSampleLocations_in,
    uint64_t optimalBufferCopyOffsetAlignment_in,
    uint64_t optimalBufferCopyRowPitchAlignment_in,
    uint64_t nonCoherentAtomSize_in)
    : maxImageDimension1D(std::move(maxImageDimension1D_in)),
      maxImageDimension2D(std::move(maxImageDimension2D_in)),
      maxImageDimension3D(std::move(maxImageDimension3D_in)),
      maxImageDimensionCube(std::move(maxImageDimensionCube_in)),
      maxImageArrayLayers(std::move(maxImageArrayLayers_in)),
      maxTexelBufferElements(std::move(maxTexelBufferElements_in)),
      maxUniformBufferRange(std::move(maxUniformBufferRange_in)),
      maxStorageBufferRange(std::move(maxStorageBufferRange_in)),
      maxPushConstantsSize(std::move(maxPushConstantsSize_in)),
      maxMemoryAllocationCount(std::move(maxMemoryAllocationCount_in)),
      maxSamplerAllocationCount(std::move(maxSamplerAllocationCount_in)),
      bufferImageGranularity(std::move(bufferImageGranularity_in)),
      sparseAddressSpaceSize(std::move(sparseAddressSpaceSize_in)),
      maxBoundDescriptorSets(std::move(maxBoundDescriptorSets_in)),
      maxPerStageDescriptorSamplers(std::move(maxPerStageDescriptorSamplers_in)),
      maxPerStageDescriptorUniformBuffers(std::move(maxPerStageDescriptorUniformBuffers_in)),
      maxPerStageDescriptorStorageBuffers(std::move(maxPerStageDescriptorStorageBuffers_in)),
      maxPerStageDescriptorSampledImages(std::move(maxPerStageDescriptorSampledImages_in)),
      maxPerStageDescriptorStorageImages(std::move(maxPerStageDescriptorStorageImages_in)),
      maxPerStageDescriptorInputAttachments(std::move(maxPerStageDescriptorInputAttachments_in)),
      maxPerStageResources(std::move(maxPerStageResources_in)),
      maxDescriptorSetSamplers(std::move(maxDescriptorSetSamplers_in)),
      maxDescriptorSetUniformBuffers(std::move(maxDescriptorSetUniformBuffers_in)),
      maxDescriptorSetUniformBuffersDynamic(std::move(maxDescriptorSetUniformBuffersDynamic_in)),
      maxDescriptorSetStorageBuffers(std::move(maxDescriptorSetStorageBuffers_in)),
      maxDescriptorSetStorageBuffersDynamic(std::move(maxDescriptorSetStorageBuffersDynamic_in)),
      maxDescriptorSetSampledImages(std::move(maxDescriptorSetSampledImages_in)),
      maxDescriptorSetStorageImages(std::move(maxDescriptorSetStorageImages_in)),
      maxDescriptorSetInputAttachments(std::move(maxDescriptorSetInputAttachments_in)),
      maxVertexInputAttributes(std::move(maxVertexInputAttributes_in)),
      maxVertexInputBindings(std::move(maxVertexInputBindings_in)),
      maxVertexInputAttributeOffset(std::move(maxVertexInputAttributeOffset_in)),
      maxVertexInputBindingStride(std::move(maxVertexInputBindingStride_in)),
      maxVertexOutputComponents(std::move(maxVertexOutputComponents_in)),
      maxTessellationGenerationLevel(std::move(maxTessellationGenerationLevel_in)),
      maxTessellationPatchSize(std::move(maxTessellationPatchSize_in)),
      maxTessellationControlPerVertexInputComponents(std::move(maxTessellationControlPerVertexInputComponents_in)),
      maxTessellationControlPerVertexOutputComponents(std::move(maxTessellationControlPerVertexOutputComponents_in)),
      maxTessellationControlPerPatchOutputComponents(std::move(maxTessellationControlPerPatchOutputComponents_in)),
      maxTessellationControlTotalOutputComponents(std::move(maxTessellationControlTotalOutputComponents_in)),
      maxTessellationEvaluationInputComponents(std::move(maxTessellationEvaluationInputComponents_in)),
      maxTessellationEvaluationOutputComponents(std::move(maxTessellationEvaluationOutputComponents_in)),
      maxGeometryShaderInvocations(std::move(maxGeometryShaderInvocations_in)),
      maxGeometryInputComponents(std::move(maxGeometryInputComponents_in)),
      maxGeometryOutputComponents(std::move(maxGeometryOutputComponents_in)),
      maxGeometryOutputVertices(std::move(maxGeometryOutputVertices_in)),
      maxGeometryTotalOutputComponents(std::move(maxGeometryTotalOutputComponents_in)),
      maxFragmentInputComponents(std::move(maxFragmentInputComponents_in)),
      maxFragmentOutputAttachments(std::move(maxFragmentOutputAttachments_in)),
      maxFragmentDualSrcAttachments(std::move(maxFragmentDualSrcAttachments_in)),
      maxFragmentCombinedOutputResources(std::move(maxFragmentCombinedOutputResources_in)),
      maxComputeSharedMemorySize(std::move(maxComputeSharedMemorySize_in)),
      maxComputeWorkGroupCount(std::move(maxComputeWorkGroupCount_in)),
      maxComputeWorkGroupInvocations(std::move(maxComputeWorkGroupInvocations_in)),
      maxComputeWorkGroupSize(std::move(maxComputeWorkGroupSize_in)),
      subPixelPrecisionBits(std::move(subPixelPrecisionBits_in)),
      subTexelPrecisionBits(std::move(subTexelPrecisionBits_in)),
      mipmapPrecisionBits(std::move(mipmapPrecisionBits_in)),
      maxDrawIndexedIndexValue(std::move(maxDrawIndexedIndexValue_in)),
      maxDrawIndirectCount(std::move(maxDrawIndirectCount_in)),
      maxSamplerLodBias(std::move(maxSamplerLodBias_in)),
      maxSamplerAnisotropy(std::move(maxSamplerAnisotropy_in)),
      maxViewports(std::move(maxViewports_in)),
      maxViewportDimensions(std::move(maxViewportDimensions_in)),
      viewportBoundsRange(std::move(viewportBoundsRange_in)),
      viewportSubPixelBits(std::move(viewportSubPixelBits_in)),
      minMemoryMapAlignment(std::move(minMemoryMapAlignment_in)),
      minTexelBufferOffsetAlignment(std::move(minTexelBufferOffsetAlignment_in)),
      minUniformBufferOffsetAlignment(std::move(minUniformBufferOffsetAlignment_in)),
      minStorageBufferOffsetAlignment(std::move(minStorageBufferOffsetAlignment_in)),
      minTexelOffset(std::move(minTexelOffset_in)),
      maxTexelOffset(std::move(maxTexelOffset_in)),
      minTexelGatherOffset(std::move(minTexelGatherOffset_in)),
      maxTexelGatherOffset(std::move(maxTexelGatherOffset_in)),
      minInterpolationOffset(std::move(minInterpolationOffset_in)),
      maxInterpolationOffset(std::move(maxInterpolationOffset_in)),
      subPixelInterpolationOffsetBits(std::move(subPixelInterpolationOffsetBits_in)),
      maxFramebufferWidth(std::move(maxFramebufferWidth_in)),
      maxFramebufferHeight(std::move(maxFramebufferHeight_in)),
      maxFramebufferLayers(std::move(maxFramebufferLayers_in)),
      framebufferColorSampleCounts(std::move(framebufferColorSampleCounts_in)),
      framebufferDepthSampleCounts(std::move(framebufferDepthSampleCounts_in)),
      framebufferStencilSampleCounts(std::move(framebufferStencilSampleCounts_in)),
      framebufferNoAttachmentsSampleCounts(std::move(framebufferNoAttachmentsSampleCounts_in)),
      maxColorAttachments(std::move(maxColorAttachments_in)),
      sampledImageColorSampleCounts(std::move(sampledImageColorSampleCounts_in)),
      sampledImageIntegerSampleCounts(std::move(sampledImageIntegerSampleCounts_in)),
      sampledImageDepthSampleCounts(std::move(sampledImageDepthSampleCounts_in)),
      sampledImageStencilSampleCounts(std::move(sampledImageStencilSampleCounts_in)),
      storageImageSampleCounts(std::move(storageImageSampleCounts_in)),
      maxSampleMaskWords(std::move(maxSampleMaskWords_in)),
      timestampComputeAndGraphics(std::move(timestampComputeAndGraphics_in)),
      timestampPeriod(std::move(timestampPeriod_in)),
      maxClipDistances(std::move(maxClipDistances_in)),
      maxCullDistances(std::move(maxCullDistances_in)),
      maxCombinedClipAndCullDistances(std::move(maxCombinedClipAndCullDistances_in)),
      discreteQueuePriorities(std::move(discreteQueuePriorities_in)),
      pointSizeRange(std::move(pointSizeRange_in)),
      lineWidthRange(std::move(lineWidthRange_in)),
      pointSizeGranularity(std::move(pointSizeGranularity_in)),
      lineWidthGranularity(std::move(lineWidthGranularity_in)),
      strictLines(std::move(strictLines_in)),
      standardSampleLocations(std::move(standardSampleLocations_in)),
      optimalBufferCopyOffsetAlignment(std::move(optimalBufferCopyOffsetAlignment_in)),
      optimalBufferCopyRowPitchAlignment(std::move(optimalBufferCopyRowPitchAlignment_in)),
      nonCoherentAtomSize(std::move(nonCoherentAtomSize_in)) {}

VkPhysicalDeviceLimits::~VkPhysicalDeviceLimits() = default;

void VkPhysicalDeviceLimits::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maxImageDimension1D"), this->maxImageDimension1D, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maxImageDimension2D"), this->maxImageDimension2D, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maxImageDimension3D"), this->maxImageDimension3D, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maxImageDimensionCube"), this->maxImageDimensionCube, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maxImageArrayLayers"), this->maxImageArrayLayers, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maxTexelBufferElements"), this->maxTexelBufferElements, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maxUniformBufferRange"), this->maxUniformBufferRange, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maxStorageBufferRange"), this->maxStorageBufferRange, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maxPushConstantsSize"), this->maxPushConstantsSize, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maxMemoryAllocationCount"), this->maxMemoryAllocationCount, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maxSamplerAllocationCount"), this->maxSamplerAllocationCount, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bufferImageGranularity"), this->bufferImageGranularity, 
      "<value of type uint64_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sparseAddressSpaceSize"), this->sparseAddressSpaceSize, 
      "<value of type uint64_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maxBoundDescriptorSets"), this->maxBoundDescriptorSets, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maxPerStageDescriptorSamplers"), this->maxPerStageDescriptorSamplers, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maxPerStageDescriptorUniformBuffers"), this->maxPerStageDescriptorUniformBuffers, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maxPerStageDescriptorStorageBuffers"), this->maxPerStageDescriptorStorageBuffers, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maxPerStageDescriptorSampledImages"), this->maxPerStageDescriptorSampledImages, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maxPerStageDescriptorStorageImages"), this->maxPerStageDescriptorStorageImages, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maxPerStageDescriptorInputAttachments"), this->maxPerStageDescriptorInputAttachments, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maxPerStageResources"), this->maxPerStageResources, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maxDescriptorSetSamplers"), this->maxDescriptorSetSamplers, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maxDescriptorSetUniformBuffers"), this->maxDescriptorSetUniformBuffers, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maxDescriptorSetUniformBuffersDynamic"), this->maxDescriptorSetUniformBuffersDynamic, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maxDescriptorSetStorageBuffers"), this->maxDescriptorSetStorageBuffers, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maxDescriptorSetStorageBuffersDynamic"), this->maxDescriptorSetStorageBuffersDynamic, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maxDescriptorSetSampledImages"), this->maxDescriptorSetSampledImages, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maxDescriptorSetStorageImages"), this->maxDescriptorSetStorageImages, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maxDescriptorSetInputAttachments"), this->maxDescriptorSetInputAttachments, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maxVertexInputAttributes"), this->maxVertexInputAttributes, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maxVertexInputBindings"), this->maxVertexInputBindings, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maxVertexInputAttributeOffset"), this->maxVertexInputAttributeOffset, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maxVertexInputBindingStride"), this->maxVertexInputBindingStride, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maxVertexOutputComponents"), this->maxVertexOutputComponents, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maxTessellationGenerationLevel"), this->maxTessellationGenerationLevel, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maxTessellationPatchSize"), this->maxTessellationPatchSize, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maxTessellationControlPerVertexInputComponents"), this->maxTessellationControlPerVertexInputComponents, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maxTessellationControlPerVertexOutputComponents"), this->maxTessellationControlPerVertexOutputComponents, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maxTessellationControlPerPatchOutputComponents"), this->maxTessellationControlPerPatchOutputComponents, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maxTessellationControlTotalOutputComponents"), this->maxTessellationControlTotalOutputComponents, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maxTessellationEvaluationInputComponents"), this->maxTessellationEvaluationInputComponents, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maxTessellationEvaluationOutputComponents"), this->maxTessellationEvaluationOutputComponents, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maxGeometryShaderInvocations"), this->maxGeometryShaderInvocations, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maxGeometryInputComponents"), this->maxGeometryInputComponents, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maxGeometryOutputComponents"), this->maxGeometryOutputComponents, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maxGeometryOutputVertices"), this->maxGeometryOutputVertices, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maxGeometryTotalOutputComponents"), this->maxGeometryTotalOutputComponents, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maxFragmentInputComponents"), this->maxFragmentInputComponents, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maxFragmentOutputAttachments"), this->maxFragmentOutputAttachments, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maxFragmentDualSrcAttachments"), this->maxFragmentDualSrcAttachments, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maxFragmentCombinedOutputResources"), this->maxFragmentCombinedOutputResources, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maxComputeSharedMemorySize"), this->maxComputeSharedMemorySize, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maxComputeWorkGroupCount"), this->maxComputeWorkGroupCount, 
      "<value of type const WTF::Vector<uint32_t>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maxComputeWorkGroupInvocations"), this->maxComputeWorkGroupInvocations, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maxComputeWorkGroupSize"), this->maxComputeWorkGroupSize, 
      "<value of type const WTF::Vector<uint32_t>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "subPixelPrecisionBits"), this->subPixelPrecisionBits, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "subTexelPrecisionBits"), this->subTexelPrecisionBits, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mipmapPrecisionBits"), this->mipmapPrecisionBits, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maxDrawIndexedIndexValue"), this->maxDrawIndexedIndexValue, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maxDrawIndirectCount"), this->maxDrawIndirectCount, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maxSamplerLodBias"), this->maxSamplerLodBias, 
      "<value of type float>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maxSamplerAnisotropy"), this->maxSamplerAnisotropy, 
      "<value of type float>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maxViewports"), this->maxViewports, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maxViewportDimensions"), this->maxViewportDimensions, 
      "<value of type const WTF::Vector<uint32_t>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "viewportBoundsRange"), this->viewportBoundsRange, 
      "<value of type const WTF::Vector<float>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "viewportSubPixelBits"), this->viewportSubPixelBits, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "minMemoryMapAlignment"), this->minMemoryMapAlignment, 
      "<value of type uint64_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "minTexelBufferOffsetAlignment"), this->minTexelBufferOffsetAlignment, 
      "<value of type uint64_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "minUniformBufferOffsetAlignment"), this->minUniformBufferOffsetAlignment, 
      "<value of type uint64_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "minStorageBufferOffsetAlignment"), this->minStorageBufferOffsetAlignment, 
      "<value of type uint64_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "minTexelOffset"), this->minTexelOffset, 
      "<value of type int32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maxTexelOffset"), this->maxTexelOffset, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "minTexelGatherOffset"), this->minTexelGatherOffset, 
      "<value of type int32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maxTexelGatherOffset"), this->maxTexelGatherOffset, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "minInterpolationOffset"), this->minInterpolationOffset, 
      "<value of type float>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maxInterpolationOffset"), this->maxInterpolationOffset, 
      "<value of type float>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "subPixelInterpolationOffsetBits"), this->subPixelInterpolationOffsetBits, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maxFramebufferWidth"), this->maxFramebufferWidth, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maxFramebufferHeight"), this->maxFramebufferHeight, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maxFramebufferLayers"), this->maxFramebufferLayers, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "framebufferColorSampleCounts"), this->framebufferColorSampleCounts, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "framebufferDepthSampleCounts"), this->framebufferDepthSampleCounts, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "framebufferStencilSampleCounts"), this->framebufferStencilSampleCounts, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "framebufferNoAttachmentsSampleCounts"), this->framebufferNoAttachmentsSampleCounts, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maxColorAttachments"), this->maxColorAttachments, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sampledImageColorSampleCounts"), this->sampledImageColorSampleCounts, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sampledImageIntegerSampleCounts"), this->sampledImageIntegerSampleCounts, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sampledImageDepthSampleCounts"), this->sampledImageDepthSampleCounts, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sampledImageStencilSampleCounts"), this->sampledImageStencilSampleCounts, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "storageImageSampleCounts"), this->storageImageSampleCounts, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maxSampleMaskWords"), this->maxSampleMaskWords, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "timestampComputeAndGraphics"), this->timestampComputeAndGraphics, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "timestampPeriod"), this->timestampPeriod, 
      "<value of type float>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maxClipDistances"), this->maxClipDistances, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maxCullDistances"), this->maxCullDistances, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maxCombinedClipAndCullDistances"), this->maxCombinedClipAndCullDistances, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "discreteQueuePriorities"), this->discreteQueuePriorities, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pointSizeRange"), this->pointSizeRange, 
      "<value of type const WTF::Vector<float>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "lineWidthRange"), this->lineWidthRange, 
      "<value of type const WTF::Vector<float>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pointSizeGranularity"), this->pointSizeGranularity, 
      "<value of type float>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "lineWidthGranularity"), this->lineWidthGranularity, 
      "<value of type float>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "strictLines"), this->strictLines, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "standardSampleLocations"), this->standardSampleLocations, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "optimalBufferCopyOffsetAlignment"), this->optimalBufferCopyOffsetAlignment, 
      "<value of type uint64_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "optimalBufferCopyRowPitchAlignment"), this->optimalBufferCopyRowPitchAlignment, 
      "<value of type uint64_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "nonCoherentAtomSize"), this->nonCoherentAtomSize, 
      "<value of type uint64_t>");
}

bool VkPhysicalDeviceLimits::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VkPhysicalDeviceSparseProperties::VkPhysicalDeviceSparseProperties()
    : residencyStandard2DBlockShape(),
      residencyStandard2DMultisampleBlockShape(),
      residencyStandard3DBlockShape(),
      residencyAlignedMipSize(),
      residencyNonResidentStrict() {}

VkPhysicalDeviceSparseProperties::VkPhysicalDeviceSparseProperties(
    bool residencyStandard2DBlockShape_in,
    bool residencyStandard2DMultisampleBlockShape_in,
    bool residencyStandard3DBlockShape_in,
    bool residencyAlignedMipSize_in,
    bool residencyNonResidentStrict_in)
    : residencyStandard2DBlockShape(std::move(residencyStandard2DBlockShape_in)),
      residencyStandard2DMultisampleBlockShape(std::move(residencyStandard2DMultisampleBlockShape_in)),
      residencyStandard3DBlockShape(std::move(residencyStandard3DBlockShape_in)),
      residencyAlignedMipSize(std::move(residencyAlignedMipSize_in)),
      residencyNonResidentStrict(std::move(residencyNonResidentStrict_in)) {}

VkPhysicalDeviceSparseProperties::~VkPhysicalDeviceSparseProperties() = default;
size_t VkPhysicalDeviceSparseProperties::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->residencyStandard2DBlockShape);
  seed = mojo::internal::WTFHash(seed, this->residencyStandard2DMultisampleBlockShape);
  seed = mojo::internal::WTFHash(seed, this->residencyStandard3DBlockShape);
  seed = mojo::internal::WTFHash(seed, this->residencyAlignedMipSize);
  seed = mojo::internal::WTFHash(seed, this->residencyNonResidentStrict);
  return seed;
}

void VkPhysicalDeviceSparseProperties::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "residencyStandard2DBlockShape"), this->residencyStandard2DBlockShape, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "residencyStandard2DMultisampleBlockShape"), this->residencyStandard2DMultisampleBlockShape, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "residencyStandard3DBlockShape"), this->residencyStandard3DBlockShape, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "residencyAlignedMipSize"), this->residencyAlignedMipSize, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "residencyNonResidentStrict"), this->residencyNonResidentStrict, 
      "<value of type bool>");
}

bool VkPhysicalDeviceSparseProperties::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VkPhysicalDeviceProperties::VkPhysicalDeviceProperties()
    : apiVersion(),
      driverVersion(),
      vendorID(),
      deviceID(),
      deviceType(),
      deviceName(),
      pipelineCacheUUID(),
      limits(),
      sparseProperties() {}

VkPhysicalDeviceProperties::VkPhysicalDeviceProperties(
    uint32_t apiVersion_in,
    uint32_t driverVersion_in,
    uint32_t vendorID_in,
    uint32_t deviceID_in,
    VkPhysicalDeviceType deviceType_in,
    const WTF::String& deviceName_in,
    WTF::Vector<uint8_t> pipelineCacheUUID_in,
    VkPhysicalDeviceLimitsPtr limits_in,
    VkPhysicalDeviceSparsePropertiesPtr sparseProperties_in)
    : apiVersion(std::move(apiVersion_in)),
      driverVersion(std::move(driverVersion_in)),
      vendorID(std::move(vendorID_in)),
      deviceID(std::move(deviceID_in)),
      deviceType(std::move(deviceType_in)),
      deviceName(std::move(deviceName_in)),
      pipelineCacheUUID(std::move(pipelineCacheUUID_in)),
      limits(std::move(limits_in)),
      sparseProperties(std::move(sparseProperties_in)) {}

VkPhysicalDeviceProperties::~VkPhysicalDeviceProperties() = default;

void VkPhysicalDeviceProperties::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "apiVersion"), this->apiVersion, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "driverVersion"), this->driverVersion, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "vendorID"), this->vendorID, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "deviceID"), this->deviceID, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "deviceType"), this->deviceType, 
      "<value of type VkPhysicalDeviceType>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "deviceName"), this->deviceName, 
      "<value of type const WTF::String&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pipelineCacheUUID"), this->pipelineCacheUUID, 
      "<value of type const WTF::Vector<uint8_t>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "limits"), this->limits, 
      "<value of type VkPhysicalDeviceLimitsPtr>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sparseProperties"), this->sparseProperties, 
      "<value of type VkPhysicalDeviceSparsePropertiesPtr>");
}

bool VkPhysicalDeviceProperties::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VkPhysicalDeviceFeatures::VkPhysicalDeviceFeatures()
    : robustBufferAccess(),
      fullDrawIndexUint32(),
      imageCubeArray(),
      independentBlend(),
      geometryShader(),
      tessellationShader(),
      sampleRateShading(),
      dualSrcBlend(),
      logicOp(),
      multiDrawIndirect(),
      drawIndirectFirstInstance(),
      depthClamp(),
      depthBiasClamp(),
      fillModeNonSolid(),
      depthBounds(),
      wideLines(),
      largePoints(),
      alphaToOne(),
      multiViewport(),
      samplerAnisotropy(),
      textureCompressionETC2(),
      textureCompressionASTC_LDR(),
      textureCompressionBC(),
      occlusionQueryPrecise(),
      pipelineStatisticsQuery(),
      vertexPipelineStoresAndAtomics(),
      fragmentStoresAndAtomics(),
      shaderTessellationAndGeometryPointSize(),
      shaderImageGatherExtended(),
      shaderStorageImageExtendedFormats(),
      shaderStorageImageMultisample(),
      shaderStorageImageReadWithoutFormat(),
      shaderStorageImageWriteWithoutFormat(),
      shaderUniformBufferArrayDynamicIndexing(),
      shaderSampledImageArrayDynamicIndexing(),
      shaderStorageBufferArrayDynamicIndexing(),
      shaderStorageImageArrayDynamicIndexing(),
      shaderClipDistance(),
      shaderCullDistance(),
      shaderFloat64(),
      shaderInt64(),
      shaderInt16(),
      shaderResourceResidency(),
      shaderResourceMinLod(),
      sparseBinding(),
      sparseResidencyBuffer(),
      sparseResidencyImage2D(),
      sparseResidencyImage3D(),
      sparseResidency2Samples(),
      sparseResidency4Samples(),
      sparseResidency8Samples(),
      sparseResidency16Samples(),
      sparseResidencyAliased(),
      variableMultisampleRate(),
      inheritedQueries() {}

VkPhysicalDeviceFeatures::VkPhysicalDeviceFeatures(
    bool robustBufferAccess_in,
    bool fullDrawIndexUint32_in,
    bool imageCubeArray_in,
    bool independentBlend_in,
    bool geometryShader_in,
    bool tessellationShader_in,
    bool sampleRateShading_in,
    bool dualSrcBlend_in,
    bool logicOp_in,
    bool multiDrawIndirect_in,
    bool drawIndirectFirstInstance_in,
    bool depthClamp_in,
    bool depthBiasClamp_in,
    bool fillModeNonSolid_in,
    bool depthBounds_in,
    bool wideLines_in,
    bool largePoints_in,
    bool alphaToOne_in,
    bool multiViewport_in,
    bool samplerAnisotropy_in,
    bool textureCompressionETC2_in,
    bool textureCompressionASTC_LDR_in,
    bool textureCompressionBC_in,
    bool occlusionQueryPrecise_in,
    bool pipelineStatisticsQuery_in,
    bool vertexPipelineStoresAndAtomics_in,
    bool fragmentStoresAndAtomics_in,
    bool shaderTessellationAndGeometryPointSize_in,
    bool shaderImageGatherExtended_in,
    bool shaderStorageImageExtendedFormats_in,
    bool shaderStorageImageMultisample_in,
    bool shaderStorageImageReadWithoutFormat_in,
    bool shaderStorageImageWriteWithoutFormat_in,
    bool shaderUniformBufferArrayDynamicIndexing_in,
    bool shaderSampledImageArrayDynamicIndexing_in,
    bool shaderStorageBufferArrayDynamicIndexing_in,
    bool shaderStorageImageArrayDynamicIndexing_in,
    bool shaderClipDistance_in,
    bool shaderCullDistance_in,
    bool shaderFloat64_in,
    bool shaderInt64_in,
    bool shaderInt16_in,
    bool shaderResourceResidency_in,
    bool shaderResourceMinLod_in,
    bool sparseBinding_in,
    bool sparseResidencyBuffer_in,
    bool sparseResidencyImage2D_in,
    bool sparseResidencyImage3D_in,
    bool sparseResidency2Samples_in,
    bool sparseResidency4Samples_in,
    bool sparseResidency8Samples_in,
    bool sparseResidency16Samples_in,
    bool sparseResidencyAliased_in,
    bool variableMultisampleRate_in,
    bool inheritedQueries_in)
    : robustBufferAccess(std::move(robustBufferAccess_in)),
      fullDrawIndexUint32(std::move(fullDrawIndexUint32_in)),
      imageCubeArray(std::move(imageCubeArray_in)),
      independentBlend(std::move(independentBlend_in)),
      geometryShader(std::move(geometryShader_in)),
      tessellationShader(std::move(tessellationShader_in)),
      sampleRateShading(std::move(sampleRateShading_in)),
      dualSrcBlend(std::move(dualSrcBlend_in)),
      logicOp(std::move(logicOp_in)),
      multiDrawIndirect(std::move(multiDrawIndirect_in)),
      drawIndirectFirstInstance(std::move(drawIndirectFirstInstance_in)),
      depthClamp(std::move(depthClamp_in)),
      depthBiasClamp(std::move(depthBiasClamp_in)),
      fillModeNonSolid(std::move(fillModeNonSolid_in)),
      depthBounds(std::move(depthBounds_in)),
      wideLines(std::move(wideLines_in)),
      largePoints(std::move(largePoints_in)),
      alphaToOne(std::move(alphaToOne_in)),
      multiViewport(std::move(multiViewport_in)),
      samplerAnisotropy(std::move(samplerAnisotropy_in)),
      textureCompressionETC2(std::move(textureCompressionETC2_in)),
      textureCompressionASTC_LDR(std::move(textureCompressionASTC_LDR_in)),
      textureCompressionBC(std::move(textureCompressionBC_in)),
      occlusionQueryPrecise(std::move(occlusionQueryPrecise_in)),
      pipelineStatisticsQuery(std::move(pipelineStatisticsQuery_in)),
      vertexPipelineStoresAndAtomics(std::move(vertexPipelineStoresAndAtomics_in)),
      fragmentStoresAndAtomics(std::move(fragmentStoresAndAtomics_in)),
      shaderTessellationAndGeometryPointSize(std::move(shaderTessellationAndGeometryPointSize_in)),
      shaderImageGatherExtended(std::move(shaderImageGatherExtended_in)),
      shaderStorageImageExtendedFormats(std::move(shaderStorageImageExtendedFormats_in)),
      shaderStorageImageMultisample(std::move(shaderStorageImageMultisample_in)),
      shaderStorageImageReadWithoutFormat(std::move(shaderStorageImageReadWithoutFormat_in)),
      shaderStorageImageWriteWithoutFormat(std::move(shaderStorageImageWriteWithoutFormat_in)),
      shaderUniformBufferArrayDynamicIndexing(std::move(shaderUniformBufferArrayDynamicIndexing_in)),
      shaderSampledImageArrayDynamicIndexing(std::move(shaderSampledImageArrayDynamicIndexing_in)),
      shaderStorageBufferArrayDynamicIndexing(std::move(shaderStorageBufferArrayDynamicIndexing_in)),
      shaderStorageImageArrayDynamicIndexing(std::move(shaderStorageImageArrayDynamicIndexing_in)),
      shaderClipDistance(std::move(shaderClipDistance_in)),
      shaderCullDistance(std::move(shaderCullDistance_in)),
      shaderFloat64(std::move(shaderFloat64_in)),
      shaderInt64(std::move(shaderInt64_in)),
      shaderInt16(std::move(shaderInt16_in)),
      shaderResourceResidency(std::move(shaderResourceResidency_in)),
      shaderResourceMinLod(std::move(shaderResourceMinLod_in)),
      sparseBinding(std::move(sparseBinding_in)),
      sparseResidencyBuffer(std::move(sparseResidencyBuffer_in)),
      sparseResidencyImage2D(std::move(sparseResidencyImage2D_in)),
      sparseResidencyImage3D(std::move(sparseResidencyImage3D_in)),
      sparseResidency2Samples(std::move(sparseResidency2Samples_in)),
      sparseResidency4Samples(std::move(sparseResidency4Samples_in)),
      sparseResidency8Samples(std::move(sparseResidency8Samples_in)),
      sparseResidency16Samples(std::move(sparseResidency16Samples_in)),
      sparseResidencyAliased(std::move(sparseResidencyAliased_in)),
      variableMultisampleRate(std::move(variableMultisampleRate_in)),
      inheritedQueries(std::move(inheritedQueries_in)) {}

VkPhysicalDeviceFeatures::~VkPhysicalDeviceFeatures() = default;
size_t VkPhysicalDeviceFeatures::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->robustBufferAccess);
  seed = mojo::internal::WTFHash(seed, this->fullDrawIndexUint32);
  seed = mojo::internal::WTFHash(seed, this->imageCubeArray);
  seed = mojo::internal::WTFHash(seed, this->independentBlend);
  seed = mojo::internal::WTFHash(seed, this->geometryShader);
  seed = mojo::internal::WTFHash(seed, this->tessellationShader);
  seed = mojo::internal::WTFHash(seed, this->sampleRateShading);
  seed = mojo::internal::WTFHash(seed, this->dualSrcBlend);
  seed = mojo::internal::WTFHash(seed, this->logicOp);
  seed = mojo::internal::WTFHash(seed, this->multiDrawIndirect);
  seed = mojo::internal::WTFHash(seed, this->drawIndirectFirstInstance);
  seed = mojo::internal::WTFHash(seed, this->depthClamp);
  seed = mojo::internal::WTFHash(seed, this->depthBiasClamp);
  seed = mojo::internal::WTFHash(seed, this->fillModeNonSolid);
  seed = mojo::internal::WTFHash(seed, this->depthBounds);
  seed = mojo::internal::WTFHash(seed, this->wideLines);
  seed = mojo::internal::WTFHash(seed, this->largePoints);
  seed = mojo::internal::WTFHash(seed, this->alphaToOne);
  seed = mojo::internal::WTFHash(seed, this->multiViewport);
  seed = mojo::internal::WTFHash(seed, this->samplerAnisotropy);
  seed = mojo::internal::WTFHash(seed, this->textureCompressionETC2);
  seed = mojo::internal::WTFHash(seed, this->textureCompressionASTC_LDR);
  seed = mojo::internal::WTFHash(seed, this->textureCompressionBC);
  seed = mojo::internal::WTFHash(seed, this->occlusionQueryPrecise);
  seed = mojo::internal::WTFHash(seed, this->pipelineStatisticsQuery);
  seed = mojo::internal::WTFHash(seed, this->vertexPipelineStoresAndAtomics);
  seed = mojo::internal::WTFHash(seed, this->fragmentStoresAndAtomics);
  seed = mojo::internal::WTFHash(seed, this->shaderTessellationAndGeometryPointSize);
  seed = mojo::internal::WTFHash(seed, this->shaderImageGatherExtended);
  seed = mojo::internal::WTFHash(seed, this->shaderStorageImageExtendedFormats);
  seed = mojo::internal::WTFHash(seed, this->shaderStorageImageMultisample);
  seed = mojo::internal::WTFHash(seed, this->shaderStorageImageReadWithoutFormat);
  seed = mojo::internal::WTFHash(seed, this->shaderStorageImageWriteWithoutFormat);
  seed = mojo::internal::WTFHash(seed, this->shaderUniformBufferArrayDynamicIndexing);
  seed = mojo::internal::WTFHash(seed, this->shaderSampledImageArrayDynamicIndexing);
  seed = mojo::internal::WTFHash(seed, this->shaderStorageBufferArrayDynamicIndexing);
  seed = mojo::internal::WTFHash(seed, this->shaderStorageImageArrayDynamicIndexing);
  seed = mojo::internal::WTFHash(seed, this->shaderClipDistance);
  seed = mojo::internal::WTFHash(seed, this->shaderCullDistance);
  seed = mojo::internal::WTFHash(seed, this->shaderFloat64);
  seed = mojo::internal::WTFHash(seed, this->shaderInt64);
  seed = mojo::internal::WTFHash(seed, this->shaderInt16);
  seed = mojo::internal::WTFHash(seed, this->shaderResourceResidency);
  seed = mojo::internal::WTFHash(seed, this->shaderResourceMinLod);
  seed = mojo::internal::WTFHash(seed, this->sparseBinding);
  seed = mojo::internal::WTFHash(seed, this->sparseResidencyBuffer);
  seed = mojo::internal::WTFHash(seed, this->sparseResidencyImage2D);
  seed = mojo::internal::WTFHash(seed, this->sparseResidencyImage3D);
  seed = mojo::internal::WTFHash(seed, this->sparseResidency2Samples);
  seed = mojo::internal::WTFHash(seed, this->sparseResidency4Samples);
  seed = mojo::internal::WTFHash(seed, this->sparseResidency8Samples);
  seed = mojo::internal::WTFHash(seed, this->sparseResidency16Samples);
  seed = mojo::internal::WTFHash(seed, this->sparseResidencyAliased);
  seed = mojo::internal::WTFHash(seed, this->variableMultisampleRate);
  seed = mojo::internal::WTFHash(seed, this->inheritedQueries);
  return seed;
}

void VkPhysicalDeviceFeatures::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "robustBufferAccess"), this->robustBufferAccess, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "fullDrawIndexUint32"), this->fullDrawIndexUint32, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "imageCubeArray"), this->imageCubeArray, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "independentBlend"), this->independentBlend, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "geometryShader"), this->geometryShader, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tessellationShader"), this->tessellationShader, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sampleRateShading"), this->sampleRateShading, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "dualSrcBlend"), this->dualSrcBlend, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "logicOp"), this->logicOp, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "multiDrawIndirect"), this->multiDrawIndirect, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "drawIndirectFirstInstance"), this->drawIndirectFirstInstance, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "depthClamp"), this->depthClamp, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "depthBiasClamp"), this->depthBiasClamp, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "fillModeNonSolid"), this->fillModeNonSolid, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "depthBounds"), this->depthBounds, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "wideLines"), this->wideLines, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "largePoints"), this->largePoints, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "alphaToOne"), this->alphaToOne, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "multiViewport"), this->multiViewport, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "samplerAnisotropy"), this->samplerAnisotropy, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "textureCompressionETC2"), this->textureCompressionETC2, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "textureCompressionASTC_LDR"), this->textureCompressionASTC_LDR, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "textureCompressionBC"), this->textureCompressionBC, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "occlusionQueryPrecise"), this->occlusionQueryPrecise, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pipelineStatisticsQuery"), this->pipelineStatisticsQuery, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "vertexPipelineStoresAndAtomics"), this->vertexPipelineStoresAndAtomics, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "fragmentStoresAndAtomics"), this->fragmentStoresAndAtomics, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "shaderTessellationAndGeometryPointSize"), this->shaderTessellationAndGeometryPointSize, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "shaderImageGatherExtended"), this->shaderImageGatherExtended, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "shaderStorageImageExtendedFormats"), this->shaderStorageImageExtendedFormats, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "shaderStorageImageMultisample"), this->shaderStorageImageMultisample, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "shaderStorageImageReadWithoutFormat"), this->shaderStorageImageReadWithoutFormat, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "shaderStorageImageWriteWithoutFormat"), this->shaderStorageImageWriteWithoutFormat, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "shaderUniformBufferArrayDynamicIndexing"), this->shaderUniformBufferArrayDynamicIndexing, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "shaderSampledImageArrayDynamicIndexing"), this->shaderSampledImageArrayDynamicIndexing, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "shaderStorageBufferArrayDynamicIndexing"), this->shaderStorageBufferArrayDynamicIndexing, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "shaderStorageImageArrayDynamicIndexing"), this->shaderStorageImageArrayDynamicIndexing, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "shaderClipDistance"), this->shaderClipDistance, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "shaderCullDistance"), this->shaderCullDistance, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "shaderFloat64"), this->shaderFloat64, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "shaderInt64"), this->shaderInt64, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "shaderInt16"), this->shaderInt16, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "shaderResourceResidency"), this->shaderResourceResidency, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "shaderResourceMinLod"), this->shaderResourceMinLod, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sparseBinding"), this->sparseBinding, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sparseResidencyBuffer"), this->sparseResidencyBuffer, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sparseResidencyImage2D"), this->sparseResidencyImage2D, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sparseResidencyImage3D"), this->sparseResidencyImage3D, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sparseResidency2Samples"), this->sparseResidency2Samples, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sparseResidency4Samples"), this->sparseResidency4Samples, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sparseResidency8Samples"), this->sparseResidency8Samples, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sparseResidency16Samples"), this->sparseResidency16Samples, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sparseResidencyAliased"), this->sparseResidencyAliased, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "variableMultisampleRate"), this->variableMultisampleRate, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "inheritedQueries"), this->inheritedQueries, 
      "<value of type bool>");
}

bool VkPhysicalDeviceFeatures::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VkExtent3D::VkExtent3D()
    : width(),
      height(),
      depth() {}

VkExtent3D::VkExtent3D(
    uint32_t width_in,
    uint32_t height_in,
    uint32_t depth_in)
    : width(std::move(width_in)),
      height(std::move(height_in)),
      depth(std::move(depth_in)) {}

VkExtent3D::~VkExtent3D() = default;
size_t VkExtent3D::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->width);
  seed = mojo::internal::WTFHash(seed, this->height);
  seed = mojo::internal::WTFHash(seed, this->depth);
  return seed;
}

void VkExtent3D::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "width"), this->width, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "height"), this->height, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "depth"), this->depth, 
      "<value of type uint32_t>");
}

bool VkExtent3D::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VkQueueFamilyProperties::VkQueueFamilyProperties()
    : queueFlags(),
      queueCount(),
      timestampValidBits(),
      minImageTransferGranularity() {}

VkQueueFamilyProperties::VkQueueFamilyProperties(
    uint32_t queueFlags_in,
    uint32_t queueCount_in,
    uint32_t timestampValidBits_in,
    VkExtent3DPtr minImageTransferGranularity_in)
    : queueFlags(std::move(queueFlags_in)),
      queueCount(std::move(queueCount_in)),
      timestampValidBits(std::move(timestampValidBits_in)),
      minImageTransferGranularity(std::move(minImageTransferGranularity_in)) {}

VkQueueFamilyProperties::~VkQueueFamilyProperties() = default;
size_t VkQueueFamilyProperties::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->queueFlags);
  seed = mojo::internal::WTFHash(seed, this->queueCount);
  seed = mojo::internal::WTFHash(seed, this->timestampValidBits);
  seed = mojo::internal::WTFHash(seed, this->minImageTransferGranularity);
  return seed;
}

void VkQueueFamilyProperties::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "queueFlags"), this->queueFlags, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "queueCount"), this->queueCount, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "timestampValidBits"), this->timestampValidBits, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "minImageTransferGranularity"), this->minImageTransferGranularity, 
      "<value of type VkExtent3DPtr>");
}

bool VkQueueFamilyProperties::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace blink
}  // namespace mojom
}  // namespace gpu

namespace mojo {


// static
bool StructTraits<::gpu::mojom::blink::VkExtensionProperties::DataView, ::gpu::mojom::blink::VkExtensionPropertiesPtr>::Read(
    ::gpu::mojom::blink::VkExtensionProperties::DataView input,
    ::gpu::mojom::blink::VkExtensionPropertiesPtr* output) {
  bool success = true;
  ::gpu::mojom::blink::VkExtensionPropertiesPtr result(::gpu::mojom::blink::VkExtensionProperties::New());
  
      if (success && !input.ReadExtensionName(&result->extensionName))
        success = false;
      if (success)
        result->specVersion = input.specVersion();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::gpu::mojom::blink::VkLayerProperties::DataView, ::gpu::mojom::blink::VkLayerPropertiesPtr>::Read(
    ::gpu::mojom::blink::VkLayerProperties::DataView input,
    ::gpu::mojom::blink::VkLayerPropertiesPtr* output) {
  bool success = true;
  ::gpu::mojom::blink::VkLayerPropertiesPtr result(::gpu::mojom::blink::VkLayerProperties::New());
  
      if (success && !input.ReadLayerName(&result->layerName))
        success = false;
      if (success)
        result->specVersion = input.specVersion();
      if (success)
        result->implementationVersion = input.implementationVersion();
      if (success && !input.ReadDescription(&result->description))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::gpu::mojom::blink::VkPhysicalDeviceLimits::DataView, ::gpu::mojom::blink::VkPhysicalDeviceLimitsPtr>::Read(
    ::gpu::mojom::blink::VkPhysicalDeviceLimits::DataView input,
    ::gpu::mojom::blink::VkPhysicalDeviceLimitsPtr* output) {
  bool success = true;
  ::gpu::mojom::blink::VkPhysicalDeviceLimitsPtr result(::gpu::mojom::blink::VkPhysicalDeviceLimits::New());
  
      if (success)
        result->maxImageDimension1D = input.maxImageDimension1D();
      if (success)
        result->maxImageDimension2D = input.maxImageDimension2D();
      if (success)
        result->maxImageDimension3D = input.maxImageDimension3D();
      if (success)
        result->maxImageDimensionCube = input.maxImageDimensionCube();
      if (success)
        result->maxImageArrayLayers = input.maxImageArrayLayers();
      if (success)
        result->maxTexelBufferElements = input.maxTexelBufferElements();
      if (success)
        result->maxUniformBufferRange = input.maxUniformBufferRange();
      if (success)
        result->maxStorageBufferRange = input.maxStorageBufferRange();
      if (success)
        result->maxPushConstantsSize = input.maxPushConstantsSize();
      if (success)
        result->maxMemoryAllocationCount = input.maxMemoryAllocationCount();
      if (success)
        result->maxSamplerAllocationCount = input.maxSamplerAllocationCount();
      if (success)
        result->bufferImageGranularity = input.bufferImageGranularity();
      if (success)
        result->sparseAddressSpaceSize = input.sparseAddressSpaceSize();
      if (success)
        result->maxBoundDescriptorSets = input.maxBoundDescriptorSets();
      if (success)
        result->maxPerStageDescriptorSamplers = input.maxPerStageDescriptorSamplers();
      if (success)
        result->maxPerStageDescriptorUniformBuffers = input.maxPerStageDescriptorUniformBuffers();
      if (success)
        result->maxPerStageDescriptorStorageBuffers = input.maxPerStageDescriptorStorageBuffers();
      if (success)
        result->maxPerStageDescriptorSampledImages = input.maxPerStageDescriptorSampledImages();
      if (success)
        result->maxPerStageDescriptorStorageImages = input.maxPerStageDescriptorStorageImages();
      if (success)
        result->maxPerStageDescriptorInputAttachments = input.maxPerStageDescriptorInputAttachments();
      if (success)
        result->maxPerStageResources = input.maxPerStageResources();
      if (success)
        result->maxDescriptorSetSamplers = input.maxDescriptorSetSamplers();
      if (success)
        result->maxDescriptorSetUniformBuffers = input.maxDescriptorSetUniformBuffers();
      if (success)
        result->maxDescriptorSetUniformBuffersDynamic = input.maxDescriptorSetUniformBuffersDynamic();
      if (success)
        result->maxDescriptorSetStorageBuffers = input.maxDescriptorSetStorageBuffers();
      if (success)
        result->maxDescriptorSetStorageBuffersDynamic = input.maxDescriptorSetStorageBuffersDynamic();
      if (success)
        result->maxDescriptorSetSampledImages = input.maxDescriptorSetSampledImages();
      if (success)
        result->maxDescriptorSetStorageImages = input.maxDescriptorSetStorageImages();
      if (success)
        result->maxDescriptorSetInputAttachments = input.maxDescriptorSetInputAttachments();
      if (success)
        result->maxVertexInputAttributes = input.maxVertexInputAttributes();
      if (success)
        result->maxVertexInputBindings = input.maxVertexInputBindings();
      if (success)
        result->maxVertexInputAttributeOffset = input.maxVertexInputAttributeOffset();
      if (success)
        result->maxVertexInputBindingStride = input.maxVertexInputBindingStride();
      if (success)
        result->maxVertexOutputComponents = input.maxVertexOutputComponents();
      if (success)
        result->maxTessellationGenerationLevel = input.maxTessellationGenerationLevel();
      if (success)
        result->maxTessellationPatchSize = input.maxTessellationPatchSize();
      if (success)
        result->maxTessellationControlPerVertexInputComponents = input.maxTessellationControlPerVertexInputComponents();
      if (success)
        result->maxTessellationControlPerVertexOutputComponents = input.maxTessellationControlPerVertexOutputComponents();
      if (success)
        result->maxTessellationControlPerPatchOutputComponents = input.maxTessellationControlPerPatchOutputComponents();
      if (success)
        result->maxTessellationControlTotalOutputComponents = input.maxTessellationControlTotalOutputComponents();
      if (success)
        result->maxTessellationEvaluationInputComponents = input.maxTessellationEvaluationInputComponents();
      if (success)
        result->maxTessellationEvaluationOutputComponents = input.maxTessellationEvaluationOutputComponents();
      if (success)
        result->maxGeometryShaderInvocations = input.maxGeometryShaderInvocations();
      if (success)
        result->maxGeometryInputComponents = input.maxGeometryInputComponents();
      if (success)
        result->maxGeometryOutputComponents = input.maxGeometryOutputComponents();
      if (success)
        result->maxGeometryOutputVertices = input.maxGeometryOutputVertices();
      if (success)
        result->maxGeometryTotalOutputComponents = input.maxGeometryTotalOutputComponents();
      if (success)
        result->maxFragmentInputComponents = input.maxFragmentInputComponents();
      if (success)
        result->maxFragmentOutputAttachments = input.maxFragmentOutputAttachments();
      if (success)
        result->maxFragmentDualSrcAttachments = input.maxFragmentDualSrcAttachments();
      if (success)
        result->maxFragmentCombinedOutputResources = input.maxFragmentCombinedOutputResources();
      if (success)
        result->maxComputeSharedMemorySize = input.maxComputeSharedMemorySize();
      if (success && !input.ReadMaxComputeWorkGroupCount(&result->maxComputeWorkGroupCount))
        success = false;
      if (success)
        result->maxComputeWorkGroupInvocations = input.maxComputeWorkGroupInvocations();
      if (success && !input.ReadMaxComputeWorkGroupSize(&result->maxComputeWorkGroupSize))
        success = false;
      if (success)
        result->subPixelPrecisionBits = input.subPixelPrecisionBits();
      if (success)
        result->subTexelPrecisionBits = input.subTexelPrecisionBits();
      if (success)
        result->mipmapPrecisionBits = input.mipmapPrecisionBits();
      if (success)
        result->maxDrawIndexedIndexValue = input.maxDrawIndexedIndexValue();
      if (success)
        result->maxDrawIndirectCount = input.maxDrawIndirectCount();
      if (success)
        result->maxSamplerLodBias = input.maxSamplerLodBias();
      if (success)
        result->maxSamplerAnisotropy = input.maxSamplerAnisotropy();
      if (success)
        result->maxViewports = input.maxViewports();
      if (success && !input.ReadMaxViewportDimensions(&result->maxViewportDimensions))
        success = false;
      if (success && !input.ReadViewportBoundsRange(&result->viewportBoundsRange))
        success = false;
      if (success)
        result->viewportSubPixelBits = input.viewportSubPixelBits();
      if (success)
        result->minMemoryMapAlignment = input.minMemoryMapAlignment();
      if (success)
        result->minTexelBufferOffsetAlignment = input.minTexelBufferOffsetAlignment();
      if (success)
        result->minUniformBufferOffsetAlignment = input.minUniformBufferOffsetAlignment();
      if (success)
        result->minStorageBufferOffsetAlignment = input.minStorageBufferOffsetAlignment();
      if (success)
        result->minTexelOffset = input.minTexelOffset();
      if (success)
        result->maxTexelOffset = input.maxTexelOffset();
      if (success)
        result->minTexelGatherOffset = input.minTexelGatherOffset();
      if (success)
        result->maxTexelGatherOffset = input.maxTexelGatherOffset();
      if (success)
        result->minInterpolationOffset = input.minInterpolationOffset();
      if (success)
        result->maxInterpolationOffset = input.maxInterpolationOffset();
      if (success)
        result->subPixelInterpolationOffsetBits = input.subPixelInterpolationOffsetBits();
      if (success)
        result->maxFramebufferWidth = input.maxFramebufferWidth();
      if (success)
        result->maxFramebufferHeight = input.maxFramebufferHeight();
      if (success)
        result->maxFramebufferLayers = input.maxFramebufferLayers();
      if (success)
        result->framebufferColorSampleCounts = input.framebufferColorSampleCounts();
      if (success)
        result->framebufferDepthSampleCounts = input.framebufferDepthSampleCounts();
      if (success)
        result->framebufferStencilSampleCounts = input.framebufferStencilSampleCounts();
      if (success)
        result->framebufferNoAttachmentsSampleCounts = input.framebufferNoAttachmentsSampleCounts();
      if (success)
        result->maxColorAttachments = input.maxColorAttachments();
      if (success)
        result->sampledImageColorSampleCounts = input.sampledImageColorSampleCounts();
      if (success)
        result->sampledImageIntegerSampleCounts = input.sampledImageIntegerSampleCounts();
      if (success)
        result->sampledImageDepthSampleCounts = input.sampledImageDepthSampleCounts();
      if (success)
        result->sampledImageStencilSampleCounts = input.sampledImageStencilSampleCounts();
      if (success)
        result->storageImageSampleCounts = input.storageImageSampleCounts();
      if (success)
        result->maxSampleMaskWords = input.maxSampleMaskWords();
      if (success)
        result->timestampComputeAndGraphics = input.timestampComputeAndGraphics();
      if (success)
        result->timestampPeriod = input.timestampPeriod();
      if (success)
        result->maxClipDistances = input.maxClipDistances();
      if (success)
        result->maxCullDistances = input.maxCullDistances();
      if (success)
        result->maxCombinedClipAndCullDistances = input.maxCombinedClipAndCullDistances();
      if (success)
        result->discreteQueuePriorities = input.discreteQueuePriorities();
      if (success && !input.ReadPointSizeRange(&result->pointSizeRange))
        success = false;
      if (success && !input.ReadLineWidthRange(&result->lineWidthRange))
        success = false;
      if (success)
        result->pointSizeGranularity = input.pointSizeGranularity();
      if (success)
        result->lineWidthGranularity = input.lineWidthGranularity();
      if (success)
        result->strictLines = input.strictLines();
      if (success)
        result->standardSampleLocations = input.standardSampleLocations();
      if (success)
        result->optimalBufferCopyOffsetAlignment = input.optimalBufferCopyOffsetAlignment();
      if (success)
        result->optimalBufferCopyRowPitchAlignment = input.optimalBufferCopyRowPitchAlignment();
      if (success)
        result->nonCoherentAtomSize = input.nonCoherentAtomSize();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::gpu::mojom::blink::VkPhysicalDeviceSparseProperties::DataView, ::gpu::mojom::blink::VkPhysicalDeviceSparsePropertiesPtr>::Read(
    ::gpu::mojom::blink::VkPhysicalDeviceSparseProperties::DataView input,
    ::gpu::mojom::blink::VkPhysicalDeviceSparsePropertiesPtr* output) {
  bool success = true;
  ::gpu::mojom::blink::VkPhysicalDeviceSparsePropertiesPtr result(::gpu::mojom::blink::VkPhysicalDeviceSparseProperties::New());
  
      if (success)
        result->residencyStandard2DBlockShape = input.residencyStandard2DBlockShape();
      if (success)
        result->residencyStandard2DMultisampleBlockShape = input.residencyStandard2DMultisampleBlockShape();
      if (success)
        result->residencyStandard3DBlockShape = input.residencyStandard3DBlockShape();
      if (success)
        result->residencyAlignedMipSize = input.residencyAlignedMipSize();
      if (success)
        result->residencyNonResidentStrict = input.residencyNonResidentStrict();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::gpu::mojom::blink::VkPhysicalDeviceProperties::DataView, ::gpu::mojom::blink::VkPhysicalDevicePropertiesPtr>::Read(
    ::gpu::mojom::blink::VkPhysicalDeviceProperties::DataView input,
    ::gpu::mojom::blink::VkPhysicalDevicePropertiesPtr* output) {
  bool success = true;
  ::gpu::mojom::blink::VkPhysicalDevicePropertiesPtr result(::gpu::mojom::blink::VkPhysicalDeviceProperties::New());
  
      if (success)
        result->apiVersion = input.apiVersion();
      if (success)
        result->driverVersion = input.driverVersion();
      if (success)
        result->vendorID = input.vendorID();
      if (success)
        result->deviceID = input.deviceID();
      if (success && !input.ReadDeviceType(&result->deviceType))
        success = false;
      if (success && !input.ReadDeviceName(&result->deviceName))
        success = false;
      if (success && !input.ReadPipelineCacheUuid(&result->pipelineCacheUUID))
        success = false;
      if (success && !input.ReadLimits(&result->limits))
        success = false;
      if (success && !input.ReadSparseProperties(&result->sparseProperties))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::gpu::mojom::blink::VkPhysicalDeviceFeatures::DataView, ::gpu::mojom::blink::VkPhysicalDeviceFeaturesPtr>::Read(
    ::gpu::mojom::blink::VkPhysicalDeviceFeatures::DataView input,
    ::gpu::mojom::blink::VkPhysicalDeviceFeaturesPtr* output) {
  bool success = true;
  ::gpu::mojom::blink::VkPhysicalDeviceFeaturesPtr result(::gpu::mojom::blink::VkPhysicalDeviceFeatures::New());
  
      if (success)
        result->robustBufferAccess = input.robustBufferAccess();
      if (success)
        result->fullDrawIndexUint32 = input.fullDrawIndexUint32();
      if (success)
        result->imageCubeArray = input.imageCubeArray();
      if (success)
        result->independentBlend = input.independentBlend();
      if (success)
        result->geometryShader = input.geometryShader();
      if (success)
        result->tessellationShader = input.tessellationShader();
      if (success)
        result->sampleRateShading = input.sampleRateShading();
      if (success)
        result->dualSrcBlend = input.dualSrcBlend();
      if (success)
        result->logicOp = input.logicOp();
      if (success)
        result->multiDrawIndirect = input.multiDrawIndirect();
      if (success)
        result->drawIndirectFirstInstance = input.drawIndirectFirstInstance();
      if (success)
        result->depthClamp = input.depthClamp();
      if (success)
        result->depthBiasClamp = input.depthBiasClamp();
      if (success)
        result->fillModeNonSolid = input.fillModeNonSolid();
      if (success)
        result->depthBounds = input.depthBounds();
      if (success)
        result->wideLines = input.wideLines();
      if (success)
        result->largePoints = input.largePoints();
      if (success)
        result->alphaToOne = input.alphaToOne();
      if (success)
        result->multiViewport = input.multiViewport();
      if (success)
        result->samplerAnisotropy = input.samplerAnisotropy();
      if (success)
        result->textureCompressionETC2 = input.textureCompressionETC2();
      if (success)
        result->textureCompressionASTC_LDR = input.textureCompressionASTC_LDR();
      if (success)
        result->textureCompressionBC = input.textureCompressionBC();
      if (success)
        result->occlusionQueryPrecise = input.occlusionQueryPrecise();
      if (success)
        result->pipelineStatisticsQuery = input.pipelineStatisticsQuery();
      if (success)
        result->vertexPipelineStoresAndAtomics = input.vertexPipelineStoresAndAtomics();
      if (success)
        result->fragmentStoresAndAtomics = input.fragmentStoresAndAtomics();
      if (success)
        result->shaderTessellationAndGeometryPointSize = input.shaderTessellationAndGeometryPointSize();
      if (success)
        result->shaderImageGatherExtended = input.shaderImageGatherExtended();
      if (success)
        result->shaderStorageImageExtendedFormats = input.shaderStorageImageExtendedFormats();
      if (success)
        result->shaderStorageImageMultisample = input.shaderStorageImageMultisample();
      if (success)
        result->shaderStorageImageReadWithoutFormat = input.shaderStorageImageReadWithoutFormat();
      if (success)
        result->shaderStorageImageWriteWithoutFormat = input.shaderStorageImageWriteWithoutFormat();
      if (success)
        result->shaderUniformBufferArrayDynamicIndexing = input.shaderUniformBufferArrayDynamicIndexing();
      if (success)
        result->shaderSampledImageArrayDynamicIndexing = input.shaderSampledImageArrayDynamicIndexing();
      if (success)
        result->shaderStorageBufferArrayDynamicIndexing = input.shaderStorageBufferArrayDynamicIndexing();
      if (success)
        result->shaderStorageImageArrayDynamicIndexing = input.shaderStorageImageArrayDynamicIndexing();
      if (success)
        result->shaderClipDistance = input.shaderClipDistance();
      if (success)
        result->shaderCullDistance = input.shaderCullDistance();
      if (success)
        result->shaderFloat64 = input.shaderFloat64();
      if (success)
        result->shaderInt64 = input.shaderInt64();
      if (success)
        result->shaderInt16 = input.shaderInt16();
      if (success)
        result->shaderResourceResidency = input.shaderResourceResidency();
      if (success)
        result->shaderResourceMinLod = input.shaderResourceMinLod();
      if (success)
        result->sparseBinding = input.sparseBinding();
      if (success)
        result->sparseResidencyBuffer = input.sparseResidencyBuffer();
      if (success)
        result->sparseResidencyImage2D = input.sparseResidencyImage2D();
      if (success)
        result->sparseResidencyImage3D = input.sparseResidencyImage3D();
      if (success)
        result->sparseResidency2Samples = input.sparseResidency2Samples();
      if (success)
        result->sparseResidency4Samples = input.sparseResidency4Samples();
      if (success)
        result->sparseResidency8Samples = input.sparseResidency8Samples();
      if (success)
        result->sparseResidency16Samples = input.sparseResidency16Samples();
      if (success)
        result->sparseResidencyAliased = input.sparseResidencyAliased();
      if (success)
        result->variableMultisampleRate = input.variableMultisampleRate();
      if (success)
        result->inheritedQueries = input.inheritedQueries();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::gpu::mojom::blink::VkExtent3D::DataView, ::gpu::mojom::blink::VkExtent3DPtr>::Read(
    ::gpu::mojom::blink::VkExtent3D::DataView input,
    ::gpu::mojom::blink::VkExtent3DPtr* output) {
  bool success = true;
  ::gpu::mojom::blink::VkExtent3DPtr result(::gpu::mojom::blink::VkExtent3D::New());
  
      if (success)
        result->width = input.width();
      if (success)
        result->height = input.height();
      if (success)
        result->depth = input.depth();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::gpu::mojom::blink::VkQueueFamilyProperties::DataView, ::gpu::mojom::blink::VkQueueFamilyPropertiesPtr>::Read(
    ::gpu::mojom::blink::VkQueueFamilyProperties::DataView input,
    ::gpu::mojom::blink::VkQueueFamilyPropertiesPtr* output) {
  bool success = true;
  ::gpu::mojom::blink::VkQueueFamilyPropertiesPtr result(::gpu::mojom::blink::VkQueueFamilyProperties::New());
  
      if (success)
        result->queueFlags = input.queueFlags();
      if (success)
        result->queueCount = input.queueCount();
      if (success)
        result->timestampValidBits = input.timestampValidBits();
      if (success && !input.ReadMinImageTransferGranularity(&result->minImageTransferGranularity))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif