// media/capture/mojom/video_capture.mojom-blink-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "media/capture/mojom/video_capture.mojom-blink-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"
#include "media/capture/mojom/video_capture_types.mojom-blink.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-blink.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-blink.h"


#ifndef MEDIA_CAPTURE_MOJOM_VIDEO_CAPTURE_MOJOM_BLINK_JUMBO_H_
#define MEDIA_CAPTURE_MOJOM_VIDEO_CAPTURE_MOJOM_BLINK_JUMBO_H_
#endif


namespace media {
namespace mojom {
namespace blink {


void VideoCaptureObserverInterceptorForTesting::OnStateChanged(VideoCaptureState state) {
  GetForwardingInterface()->OnStateChanged(std::move(state));
}
void VideoCaptureObserverInterceptorForTesting::OnNewBuffer(int32_t buffer_id, ::media::mojom::blink::VideoBufferHandlePtr buffer_handle) {
  GetForwardingInterface()->OnNewBuffer(std::move(buffer_id), std::move(buffer_handle));
}
void VideoCaptureObserverInterceptorForTesting::OnBufferReady(::media::mojom::blink::ReadyBufferPtr buffer, WTF::Vector<::media::mojom::blink::ReadyBufferPtr> scaled_buffers) {
  GetForwardingInterface()->OnBufferReady(std::move(buffer), std::move(scaled_buffers));
}
void VideoCaptureObserverInterceptorForTesting::OnBufferDestroyed(int32_t buffer_id) {
  GetForwardingInterface()->OnBufferDestroyed(std::move(buffer_id));
}
VideoCaptureObserverAsyncWaiter::VideoCaptureObserverAsyncWaiter(
    VideoCaptureObserver* proxy) : proxy_(proxy) {}

VideoCaptureObserverAsyncWaiter::~VideoCaptureObserverAsyncWaiter() = default;




void VideoCaptureHostInterceptorForTesting::Start(const ::base::UnguessableToken& device_id, const ::base::UnguessableToken& session_id, const ::media::VideoCaptureParams& params, ::mojo::PendingRemote<VideoCaptureObserver> observer) {
  GetForwardingInterface()->Start(std::move(device_id), std::move(session_id), std::move(params), std::move(observer));
}
void VideoCaptureHostInterceptorForTesting::Stop(const ::base::UnguessableToken& device_id) {
  GetForwardingInterface()->Stop(std::move(device_id));
}
void VideoCaptureHostInterceptorForTesting::Pause(const ::base::UnguessableToken& device_id) {
  GetForwardingInterface()->Pause(std::move(device_id));
}
void VideoCaptureHostInterceptorForTesting::Resume(const ::base::UnguessableToken& device_id, const ::base::UnguessableToken& session_id, const ::media::VideoCaptureParams& params) {
  GetForwardingInterface()->Resume(std::move(device_id), std::move(session_id), std::move(params));
}
void VideoCaptureHostInterceptorForTesting::RequestRefreshFrame(const ::base::UnguessableToken& device_id) {
  GetForwardingInterface()->RequestRefreshFrame(std::move(device_id));
}
void VideoCaptureHostInterceptorForTesting::ReleaseBuffer(const ::base::UnguessableToken& device_id, int32_t buffer_id, const ::media::VideoFrameFeedback& feedback) {
  GetForwardingInterface()->ReleaseBuffer(std::move(device_id), std::move(buffer_id), std::move(feedback));
}
void VideoCaptureHostInterceptorForTesting::GetDeviceSupportedFormats(const ::base::UnguessableToken& device_id, const ::base::UnguessableToken& session_id, GetDeviceSupportedFormatsCallback callback) {
  GetForwardingInterface()->GetDeviceSupportedFormats(std::move(device_id), std::move(session_id), std::move(callback));
}
void VideoCaptureHostInterceptorForTesting::GetDeviceFormatsInUse(const ::base::UnguessableToken& device_id, const ::base::UnguessableToken& session_id, GetDeviceFormatsInUseCallback callback) {
  GetForwardingInterface()->GetDeviceFormatsInUse(std::move(device_id), std::move(session_id), std::move(callback));
}
void VideoCaptureHostInterceptorForTesting::OnFrameDropped(const ::base::UnguessableToken& device_id, ::media::VideoCaptureFrameDropReason reason) {
  GetForwardingInterface()->OnFrameDropped(std::move(device_id), std::move(reason));
}
void VideoCaptureHostInterceptorForTesting::OnLog(const ::base::UnguessableToken& device_id, const WTF::String& message) {
  GetForwardingInterface()->OnLog(std::move(device_id), std::move(message));
}
VideoCaptureHostAsyncWaiter::VideoCaptureHostAsyncWaiter(
    VideoCaptureHost* proxy) : proxy_(proxy) {}

VideoCaptureHostAsyncWaiter::~VideoCaptureHostAsyncWaiter() = default;

void VideoCaptureHostAsyncWaiter::GetDeviceSupportedFormats(
    const ::base::UnguessableToken& device_id, const ::base::UnguessableToken& session_id, WTF::Vector<::media::VideoCaptureFormat>* out_formats_supported) {
  base::RunLoop loop;
  proxy_->GetDeviceSupportedFormats(std::move(device_id),std::move(session_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             WTF::Vector<::media::VideoCaptureFormat>* out_formats_supported
,
             const WTF::Vector<::media::VideoCaptureFormat>& formats_supported) {*out_formats_supported = std::move(formats_supported);
            loop->Quit();
          },
          &loop,
          out_formats_supported));
  loop.Run();
}
void VideoCaptureHostAsyncWaiter::GetDeviceFormatsInUse(
    const ::base::UnguessableToken& device_id, const ::base::UnguessableToken& session_id, WTF::Vector<::media::VideoCaptureFormat>* out_formats_in_use) {
  base::RunLoop loop;
  proxy_->GetDeviceFormatsInUse(std::move(device_id),std::move(session_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             WTF::Vector<::media::VideoCaptureFormat>* out_formats_in_use
,
             const WTF::Vector<::media::VideoCaptureFormat>& formats_in_use) {*out_formats_in_use = std::move(formats_in_use);
            loop->Quit();
          },
          &loop,
          out_formats_in_use));
  loop.Run();
}





}  // namespace blink
}  // namespace mojom
}  // namespace media

#if defined(__clang__)
#pragma clang diagnostic pop
#endif