// media/capture/mojom/video_capture.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/capture/mojom/video_capture.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "media/capture/mojom/video_capture.mojom-params-data.h"
#include "media/capture/mojom/video_capture.mojom-shared-message-ids.h"

#include "media/capture/mojom/video_capture.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef MEDIA_CAPTURE_MOJOM_VIDEO_CAPTURE_MOJOM_BLINK_JUMBO_H_
#define MEDIA_CAPTURE_MOJOM_VIDEO_CAPTURE_MOJOM_BLINK_JUMBO_H_
#endif
namespace media {
namespace mojom {
namespace blink {
const char VideoCaptureObserver::Name_[] = "media.mojom.VideoCaptureObserver";

VideoCaptureObserverProxy::VideoCaptureObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void VideoCaptureObserverProxy::OnStateChanged(
    VideoCaptureState in_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::VideoCaptureObserver::OnStateChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("state"), in_state, 
                        "<value of type VideoCaptureState>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVideoCaptureObserver_OnStateChanged_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoCaptureObserver_OnStateChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::media::mojom::VideoCaptureState>(
      in_state, &params->state);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoCaptureObserver::Name_);
  message.set_method_name("OnStateChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void VideoCaptureObserverProxy::OnNewBuffer(
    int32_t in_buffer_id, ::media::mojom::blink::VideoBufferHandlePtr in_buffer_handle) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::VideoCaptureObserver::OnNewBuffer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer_id"), in_buffer_id, 
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer_handle"), in_buffer_handle, 
                        "<value of type ::media::mojom::blink::VideoBufferHandlePtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVideoCaptureObserver_OnNewBuffer_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoCaptureObserver_OnNewBuffer_Params_Data> params(
          message);
  params.Allocate();
  params->buffer_id = in_buffer_id;
  mojo::internal::MessageFragment<decltype(params->buffer_handle)>
      buffer_handle_fragment(params.message());
  buffer_handle_fragment.Claim(&params->buffer_handle);
  mojo::internal::Serialize<::media::mojom::VideoBufferHandleDataView>(
      in_buffer_handle, buffer_handle_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->buffer_handle.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null buffer_handle in VideoCaptureObserver.OnNewBuffer request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoCaptureObserver::Name_);
  message.set_method_name("OnNewBuffer");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void VideoCaptureObserverProxy::OnBufferReady(
    ::media::mojom::blink::ReadyBufferPtr in_buffer, WTF::Vector<::media::mojom::blink::ReadyBufferPtr> in_scaled_buffers) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::VideoCaptureObserver::OnBufferReady", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer"), in_buffer, 
                        "<value of type ::media::mojom::blink::ReadyBufferPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("scaled_buffers"), in_scaled_buffers, 
                        "<value of type WTF::Vector<::media::mojom::blink::ReadyBufferPtr>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVideoCaptureObserver_OnBufferReady_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoCaptureObserver_OnBufferReady_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->buffer)::BaseType> buffer_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::ReadyBufferDataView>(
      in_buffer, buffer_fragment);
  params->buffer.Set(
      buffer_fragment.is_null() ? nullptr : buffer_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->buffer.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null buffer in VideoCaptureObserver.OnBufferReady request");
  mojo::internal::MessageFragment<
      typename decltype(params->scaled_buffers)::BaseType>
      scaled_buffers_fragment(params.message());
  const mojo::internal::ContainerValidateParams scaled_buffers_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::ReadyBufferDataView>>(
      in_scaled_buffers, scaled_buffers_fragment, &scaled_buffers_validate_params);
  params->scaled_buffers.Set(
      scaled_buffers_fragment.is_null() ? nullptr : scaled_buffers_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->scaled_buffers.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null scaled_buffers in VideoCaptureObserver.OnBufferReady request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoCaptureObserver::Name_);
  message.set_method_name("OnBufferReady");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void VideoCaptureObserverProxy::OnBufferDestroyed(
    int32_t in_buffer_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::VideoCaptureObserver::OnBufferDestroyed", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer_id"), in_buffer_id, 
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVideoCaptureObserver_OnBufferDestroyed_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoCaptureObserver_OnBufferDestroyed_Params_Data> params(
          message);
  params.Allocate();
  params->buffer_id = in_buffer_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoCaptureObserver::Name_);
  message.set_method_name("OnBufferDestroyed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool VideoCaptureObserverStubDispatch::Accept(
    VideoCaptureObserver* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kVideoCaptureObserver_OnStateChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::VideoCaptureObserver::OnStateChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::VideoCaptureObserver::OnStateChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::VideoCaptureObserver_OnStateChanged_Params_Data* params =
          reinterpret_cast<internal::VideoCaptureObserver_OnStateChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      VideoCaptureState p_state{};
      VideoCaptureObserver_OnStateChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadState(&p_state))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoCaptureObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnStateChanged(
std::move(p_state));
      return true;
    }
    case internal::kVideoCaptureObserver_OnNewBuffer_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::VideoCaptureObserver::OnNewBuffer",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::VideoCaptureObserver::OnNewBuffer");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::VideoCaptureObserver_OnNewBuffer_Params_Data* params =
          reinterpret_cast<internal::VideoCaptureObserver_OnNewBuffer_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_buffer_id{};
      ::media::mojom::blink::VideoBufferHandlePtr p_buffer_handle{};
      VideoCaptureObserver_OnNewBuffer_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_buffer_id = input_data_view.buffer_id();
      if (success && !input_data_view.ReadBufferHandle(&p_buffer_handle))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoCaptureObserver::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnNewBuffer(
std::move(p_buffer_id), 
std::move(p_buffer_handle));
      return true;
    }
    case internal::kVideoCaptureObserver_OnBufferReady_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::VideoCaptureObserver::OnBufferReady",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::VideoCaptureObserver::OnBufferReady");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::VideoCaptureObserver_OnBufferReady_Params_Data* params =
          reinterpret_cast<internal::VideoCaptureObserver_OnBufferReady_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::media::mojom::blink::ReadyBufferPtr p_buffer{};
      WTF::Vector<::media::mojom::blink::ReadyBufferPtr> p_scaled_buffers{};
      VideoCaptureObserver_OnBufferReady_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBuffer(&p_buffer))
        success = false;
      if (success && !input_data_view.ReadScaledBuffers(&p_scaled_buffers))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoCaptureObserver::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnBufferReady(
std::move(p_buffer), 
std::move(p_scaled_buffers));
      return true;
    }
    case internal::kVideoCaptureObserver_OnBufferDestroyed_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::VideoCaptureObserver::OnBufferDestroyed",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::VideoCaptureObserver::OnBufferDestroyed");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::VideoCaptureObserver_OnBufferDestroyed_Params_Data* params =
          reinterpret_cast<internal::VideoCaptureObserver_OnBufferDestroyed_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_buffer_id{};
      VideoCaptureObserver_OnBufferDestroyed_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_buffer_id = input_data_view.buffer_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoCaptureObserver::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnBufferDestroyed(
std::move(p_buffer_id));
      return true;
    }
  }
  return false;
}

// static
bool VideoCaptureObserverStubDispatch::AcceptWithResponder(
    VideoCaptureObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kVideoCaptureObserver_OnStateChanged_Name: {
      break;
    }
    case internal::kVideoCaptureObserver_OnNewBuffer_Name: {
      break;
    }
    case internal::kVideoCaptureObserver_OnBufferReady_Name: {
      break;
    }
    case internal::kVideoCaptureObserver_OnBufferDestroyed_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kVideoCaptureObserverValidationInfo[] = {
    {internal::kVideoCaptureObserver_OnStateChanged_Name,
     {&internal::VideoCaptureObserver_OnStateChanged_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kVideoCaptureObserver_OnNewBuffer_Name,
     {&internal::VideoCaptureObserver_OnNewBuffer_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kVideoCaptureObserver_OnBufferReady_Name,
     {&internal::VideoCaptureObserver_OnBufferReady_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kVideoCaptureObserver_OnBufferDestroyed_Name,
     {&internal::VideoCaptureObserver_OnBufferDestroyed_Params_Data::Validate,
      nullptr /* no response */}},
};

bool VideoCaptureObserverRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::blink::VideoCaptureObserver::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kVideoCaptureObserverValidationInfo);
}

const char VideoCaptureHost::Name_[] = "media.mojom.VideoCaptureHost";

class VideoCaptureHost_GetDeviceSupportedFormats_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  VideoCaptureHost_GetDeviceSupportedFormats_ForwardToCallback(
      VideoCaptureHost::GetDeviceSupportedFormatsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  VideoCaptureHost::GetDeviceSupportedFormatsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(VideoCaptureHost_GetDeviceSupportedFormats_ForwardToCallback);
};

class VideoCaptureHost_GetDeviceFormatsInUse_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  VideoCaptureHost_GetDeviceFormatsInUse_ForwardToCallback(
      VideoCaptureHost::GetDeviceFormatsInUseCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  VideoCaptureHost::GetDeviceFormatsInUseCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(VideoCaptureHost_GetDeviceFormatsInUse_ForwardToCallback);
};

VideoCaptureHostProxy::VideoCaptureHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void VideoCaptureHostProxy::Start(
    const ::base::UnguessableToken& in_device_id, const ::base::UnguessableToken& in_session_id, const ::media::VideoCaptureParams& in_params, ::mojo::PendingRemote<VideoCaptureObserver> in_observer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::VideoCaptureHost::Start", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_id"), in_device_id, 
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session_id"), in_session_id, 
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params, 
                        "<value of type const ::media::VideoCaptureParams&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer, 
                        "<value of type ::mojo::PendingRemote<VideoCaptureObserver>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVideoCaptureHost_Start_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoCaptureHost_Start_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->device_id)::BaseType> device_id_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_device_id, device_id_fragment);
  params->device_id.Set(
      device_id_fragment.is_null() ? nullptr : device_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->device_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null device_id in VideoCaptureHost.Start request");
  mojo::internal::MessageFragment<
      typename decltype(params->session_id)::BaseType> session_id_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_session_id, session_id_fragment);
  params->session_id.Set(
      session_id_fragment.is_null() ? nullptr : session_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->session_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null session_id in VideoCaptureHost.Start request");
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::VideoCaptureParamsDataView>(
      in_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in VideoCaptureHost.Start request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media::mojom::VideoCaptureObserverInterfaceBase>>(
      in_observer, &params->observer, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->observer),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid observer in VideoCaptureHost.Start request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoCaptureHost::Name_);
  message.set_method_name("Start");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void VideoCaptureHostProxy::Stop(
    const ::base::UnguessableToken& in_device_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::VideoCaptureHost::Stop", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_id"), in_device_id, 
                        "<value of type const ::base::UnguessableToken&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVideoCaptureHost_Stop_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoCaptureHost_Stop_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->device_id)::BaseType> device_id_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_device_id, device_id_fragment);
  params->device_id.Set(
      device_id_fragment.is_null() ? nullptr : device_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->device_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null device_id in VideoCaptureHost.Stop request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoCaptureHost::Name_);
  message.set_method_name("Stop");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void VideoCaptureHostProxy::Pause(
    const ::base::UnguessableToken& in_device_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::VideoCaptureHost::Pause", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_id"), in_device_id, 
                        "<value of type const ::base::UnguessableToken&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVideoCaptureHost_Pause_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoCaptureHost_Pause_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->device_id)::BaseType> device_id_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_device_id, device_id_fragment);
  params->device_id.Set(
      device_id_fragment.is_null() ? nullptr : device_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->device_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null device_id in VideoCaptureHost.Pause request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoCaptureHost::Name_);
  message.set_method_name("Pause");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void VideoCaptureHostProxy::Resume(
    const ::base::UnguessableToken& in_device_id, const ::base::UnguessableToken& in_session_id, const ::media::VideoCaptureParams& in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::VideoCaptureHost::Resume", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_id"), in_device_id, 
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session_id"), in_session_id, 
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params, 
                        "<value of type const ::media::VideoCaptureParams&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVideoCaptureHost_Resume_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoCaptureHost_Resume_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->device_id)::BaseType> device_id_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_device_id, device_id_fragment);
  params->device_id.Set(
      device_id_fragment.is_null() ? nullptr : device_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->device_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null device_id in VideoCaptureHost.Resume request");
  mojo::internal::MessageFragment<
      typename decltype(params->session_id)::BaseType> session_id_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_session_id, session_id_fragment);
  params->session_id.Set(
      session_id_fragment.is_null() ? nullptr : session_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->session_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null session_id in VideoCaptureHost.Resume request");
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::VideoCaptureParamsDataView>(
      in_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in VideoCaptureHost.Resume request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoCaptureHost::Name_);
  message.set_method_name("Resume");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void VideoCaptureHostProxy::RequestRefreshFrame(
    const ::base::UnguessableToken& in_device_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::VideoCaptureHost::RequestRefreshFrame", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_id"), in_device_id, 
                        "<value of type const ::base::UnguessableToken&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVideoCaptureHost_RequestRefreshFrame_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoCaptureHost_RequestRefreshFrame_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->device_id)::BaseType> device_id_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_device_id, device_id_fragment);
  params->device_id.Set(
      device_id_fragment.is_null() ? nullptr : device_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->device_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null device_id in VideoCaptureHost.RequestRefreshFrame request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoCaptureHost::Name_);
  message.set_method_name("RequestRefreshFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void VideoCaptureHostProxy::ReleaseBuffer(
    const ::base::UnguessableToken& in_device_id, int32_t in_buffer_id, const ::media::VideoFrameFeedback& in_feedback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::VideoCaptureHost::ReleaseBuffer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_id"), in_device_id, 
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer_id"), in_buffer_id, 
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("feedback"), in_feedback, 
                        "<value of type const ::media::VideoFrameFeedback&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVideoCaptureHost_ReleaseBuffer_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoCaptureHost_ReleaseBuffer_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->device_id)::BaseType> device_id_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_device_id, device_id_fragment);
  params->device_id.Set(
      device_id_fragment.is_null() ? nullptr : device_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->device_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null device_id in VideoCaptureHost.ReleaseBuffer request");
  params->buffer_id = in_buffer_id;
  mojo::internal::MessageFragment<
      typename decltype(params->feedback)::BaseType> feedback_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::VideoFrameFeedbackDataView>(
      in_feedback, feedback_fragment);
  params->feedback.Set(
      feedback_fragment.is_null() ? nullptr : feedback_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->feedback.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null feedback in VideoCaptureHost.ReleaseBuffer request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoCaptureHost::Name_);
  message.set_method_name("ReleaseBuffer");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void VideoCaptureHostProxy::GetDeviceSupportedFormats(
    const ::base::UnguessableToken& in_device_id, const ::base::UnguessableToken& in_session_id, GetDeviceSupportedFormatsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::VideoCaptureHost::GetDeviceSupportedFormats", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_id"), in_device_id, 
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session_id"), in_session_id, 
                        "<value of type const ::base::UnguessableToken&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVideoCaptureHost_GetDeviceSupportedFormats_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoCaptureHost_GetDeviceSupportedFormats_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->device_id)::BaseType> device_id_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_device_id, device_id_fragment);
  params->device_id.Set(
      device_id_fragment.is_null() ? nullptr : device_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->device_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null device_id in VideoCaptureHost.GetDeviceSupportedFormats request");
  mojo::internal::MessageFragment<
      typename decltype(params->session_id)::BaseType> session_id_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_session_id, session_id_fragment);
  params->session_id.Set(
      session_id_fragment.is_null() ? nullptr : session_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->session_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null session_id in VideoCaptureHost.GetDeviceSupportedFormats request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoCaptureHost::Name_);
  message.set_method_name("GetDeviceSupportedFormats");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new VideoCaptureHost_GetDeviceSupportedFormats_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void VideoCaptureHostProxy::GetDeviceFormatsInUse(
    const ::base::UnguessableToken& in_device_id, const ::base::UnguessableToken& in_session_id, GetDeviceFormatsInUseCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::VideoCaptureHost::GetDeviceFormatsInUse", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_id"), in_device_id, 
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session_id"), in_session_id, 
                        "<value of type const ::base::UnguessableToken&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVideoCaptureHost_GetDeviceFormatsInUse_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoCaptureHost_GetDeviceFormatsInUse_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->device_id)::BaseType> device_id_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_device_id, device_id_fragment);
  params->device_id.Set(
      device_id_fragment.is_null() ? nullptr : device_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->device_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null device_id in VideoCaptureHost.GetDeviceFormatsInUse request");
  mojo::internal::MessageFragment<
      typename decltype(params->session_id)::BaseType> session_id_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_session_id, session_id_fragment);
  params->session_id.Set(
      session_id_fragment.is_null() ? nullptr : session_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->session_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null session_id in VideoCaptureHost.GetDeviceFormatsInUse request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoCaptureHost::Name_);
  message.set_method_name("GetDeviceFormatsInUse");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new VideoCaptureHost_GetDeviceFormatsInUse_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void VideoCaptureHostProxy::OnFrameDropped(
    const ::base::UnguessableToken& in_device_id, ::media::VideoCaptureFrameDropReason in_reason) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::VideoCaptureHost::OnFrameDropped", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_id"), in_device_id, 
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reason"), in_reason, 
                        "<value of type ::media::VideoCaptureFrameDropReason>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVideoCaptureHost_OnFrameDropped_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoCaptureHost_OnFrameDropped_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->device_id)::BaseType> device_id_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_device_id, device_id_fragment);
  params->device_id.Set(
      device_id_fragment.is_null() ? nullptr : device_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->device_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null device_id in VideoCaptureHost.OnFrameDropped request");
  mojo::internal::Serialize<::media::mojom::VideoCaptureFrameDropReason>(
      in_reason, &params->reason);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoCaptureHost::Name_);
  message.set_method_name("OnFrameDropped");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void VideoCaptureHostProxy::OnLog(
    const ::base::UnguessableToken& in_device_id, const WTF::String& in_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::VideoCaptureHost::OnLog", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_id"), in_device_id, 
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message, 
                        "<value of type const WTF::String&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVideoCaptureHost_OnLog_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoCaptureHost_OnLog_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->device_id)::BaseType> device_id_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_device_id, device_id_fragment);
  params->device_id.Set(
      device_id_fragment.is_null() ? nullptr : device_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->device_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null device_id in VideoCaptureHost.OnLog request");
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_message, message_fragment);
  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null message in VideoCaptureHost.OnLog request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoCaptureHost::Name_);
  message.set_method_name("OnLog");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class VideoCaptureHost_GetDeviceSupportedFormats_ProxyToResponder {
 public:
  static VideoCaptureHost::GetDeviceSupportedFormatsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<VideoCaptureHost_GetDeviceSupportedFormats_ProxyToResponder> proxy(
        new VideoCaptureHost_GetDeviceSupportedFormats_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&VideoCaptureHost_GetDeviceSupportedFormats_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~VideoCaptureHost_GetDeviceSupportedFormats_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  VideoCaptureHost_GetDeviceSupportedFormats_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "VideoCaptureHost::GetDeviceSupportedFormatsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const WTF::Vector<::media::VideoCaptureFormat>& in_formats_supported);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(VideoCaptureHost_GetDeviceSupportedFormats_ProxyToResponder);
};

bool VideoCaptureHost_GetDeviceSupportedFormats_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "media::mojom::VideoCaptureHost::GetDeviceSupportedFormatsCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::VideoCaptureHost_GetDeviceSupportedFormats_ResponseParams_Data* params =
      reinterpret_cast<
          internal::VideoCaptureHost_GetDeviceSupportedFormats_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  WTF::Vector<::media::VideoCaptureFormat> p_formats_supported{};
  VideoCaptureHost_GetDeviceSupportedFormats_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadFormatsSupported(&p_formats_supported))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        VideoCaptureHost::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_formats_supported));
  return true;
}

void VideoCaptureHost_GetDeviceSupportedFormats_ProxyToResponder::Run(
    const WTF::Vector<::media::VideoCaptureFormat>& in_formats_supported) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)media::mojom::VideoCaptureHost::GetDeviceSupportedFormatsCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("formats_supported"), in_formats_supported, 
                        "<value of type const WTF::Vector<::media::VideoCaptureFormat>&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVideoCaptureHost_GetDeviceSupportedFormats_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoCaptureHost_GetDeviceSupportedFormats_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->formats_supported)::BaseType>
      formats_supported_fragment(params.message());
  const mojo::internal::ContainerValidateParams formats_supported_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::VideoCaptureFormatDataView>>(
      in_formats_supported, formats_supported_fragment, &formats_supported_validate_params);
  params->formats_supported.Set(
      formats_supported_fragment.is_null() ? nullptr : formats_supported_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->formats_supported.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null formats_supported in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)media::mojom::VideoCaptureHost::GetDeviceSupportedFormatsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoCaptureHost::Name_);
  message.set_method_name("GetDeviceSupportedFormats");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class VideoCaptureHost_GetDeviceFormatsInUse_ProxyToResponder {
 public:
  static VideoCaptureHost::GetDeviceFormatsInUseCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<VideoCaptureHost_GetDeviceFormatsInUse_ProxyToResponder> proxy(
        new VideoCaptureHost_GetDeviceFormatsInUse_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&VideoCaptureHost_GetDeviceFormatsInUse_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~VideoCaptureHost_GetDeviceFormatsInUse_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  VideoCaptureHost_GetDeviceFormatsInUse_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "VideoCaptureHost::GetDeviceFormatsInUseCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const WTF::Vector<::media::VideoCaptureFormat>& in_formats_in_use);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(VideoCaptureHost_GetDeviceFormatsInUse_ProxyToResponder);
};

bool VideoCaptureHost_GetDeviceFormatsInUse_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "media::mojom::VideoCaptureHost::GetDeviceFormatsInUseCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::VideoCaptureHost_GetDeviceFormatsInUse_ResponseParams_Data* params =
      reinterpret_cast<
          internal::VideoCaptureHost_GetDeviceFormatsInUse_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  WTF::Vector<::media::VideoCaptureFormat> p_formats_in_use{};
  VideoCaptureHost_GetDeviceFormatsInUse_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadFormatsInUse(&p_formats_in_use))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        VideoCaptureHost::Name_, 7, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_formats_in_use));
  return true;
}

void VideoCaptureHost_GetDeviceFormatsInUse_ProxyToResponder::Run(
    const WTF::Vector<::media::VideoCaptureFormat>& in_formats_in_use) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)media::mojom::VideoCaptureHost::GetDeviceFormatsInUseCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("formats_in_use"), in_formats_in_use, 
                        "<value of type const WTF::Vector<::media::VideoCaptureFormat>&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kVideoCaptureHost_GetDeviceFormatsInUse_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoCaptureHost_GetDeviceFormatsInUse_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->formats_in_use)::BaseType>
      formats_in_use_fragment(params.message());
  const mojo::internal::ContainerValidateParams formats_in_use_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::VideoCaptureFormatDataView>>(
      in_formats_in_use, formats_in_use_fragment, &formats_in_use_validate_params);
  params->formats_in_use.Set(
      formats_in_use_fragment.is_null() ? nullptr : formats_in_use_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->formats_in_use.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null formats_in_use in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)media::mojom::VideoCaptureHost::GetDeviceFormatsInUseCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoCaptureHost::Name_);
  message.set_method_name("GetDeviceFormatsInUse");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool VideoCaptureHostStubDispatch::Accept(
    VideoCaptureHost* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kVideoCaptureHost_Start_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::VideoCaptureHost::Start",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::VideoCaptureHost::Start");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::VideoCaptureHost_Start_Params_Data* params =
          reinterpret_cast<internal::VideoCaptureHost_Start_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::UnguessableToken p_device_id{};
      ::base::UnguessableToken p_session_id{};
      ::media::VideoCaptureParams p_params{};
      ::mojo::PendingRemote<VideoCaptureObserver> p_observer{};
      VideoCaptureHost_Start_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDeviceId(&p_device_id))
        success = false;
      if (success && !input_data_view.ReadSessionId(&p_session_id))
        success = false;
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoCaptureHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Start(
std::move(p_device_id), 
std::move(p_session_id), 
std::move(p_params), 
std::move(p_observer));
      return true;
    }
    case internal::kVideoCaptureHost_Stop_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::VideoCaptureHost::Stop",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::VideoCaptureHost::Stop");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::VideoCaptureHost_Stop_Params_Data* params =
          reinterpret_cast<internal::VideoCaptureHost_Stop_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::UnguessableToken p_device_id{};
      VideoCaptureHost_Stop_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDeviceId(&p_device_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoCaptureHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Stop(
std::move(p_device_id));
      return true;
    }
    case internal::kVideoCaptureHost_Pause_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::VideoCaptureHost::Pause",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::VideoCaptureHost::Pause");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::VideoCaptureHost_Pause_Params_Data* params =
          reinterpret_cast<internal::VideoCaptureHost_Pause_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::UnguessableToken p_device_id{};
      VideoCaptureHost_Pause_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDeviceId(&p_device_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoCaptureHost::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Pause(
std::move(p_device_id));
      return true;
    }
    case internal::kVideoCaptureHost_Resume_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::VideoCaptureHost::Resume",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::VideoCaptureHost::Resume");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::VideoCaptureHost_Resume_Params_Data* params =
          reinterpret_cast<internal::VideoCaptureHost_Resume_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::UnguessableToken p_device_id{};
      ::base::UnguessableToken p_session_id{};
      ::media::VideoCaptureParams p_params{};
      VideoCaptureHost_Resume_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDeviceId(&p_device_id))
        success = false;
      if (success && !input_data_view.ReadSessionId(&p_session_id))
        success = false;
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoCaptureHost::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Resume(
std::move(p_device_id), 
std::move(p_session_id), 
std::move(p_params));
      return true;
    }
    case internal::kVideoCaptureHost_RequestRefreshFrame_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::VideoCaptureHost::RequestRefreshFrame",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::VideoCaptureHost::RequestRefreshFrame");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::VideoCaptureHost_RequestRefreshFrame_Params_Data* params =
          reinterpret_cast<internal::VideoCaptureHost_RequestRefreshFrame_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::UnguessableToken p_device_id{};
      VideoCaptureHost_RequestRefreshFrame_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDeviceId(&p_device_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoCaptureHost::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestRefreshFrame(
std::move(p_device_id));
      return true;
    }
    case internal::kVideoCaptureHost_ReleaseBuffer_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::VideoCaptureHost::ReleaseBuffer",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::VideoCaptureHost::ReleaseBuffer");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::VideoCaptureHost_ReleaseBuffer_Params_Data* params =
          reinterpret_cast<internal::VideoCaptureHost_ReleaseBuffer_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::UnguessableToken p_device_id{};
      int32_t p_buffer_id{};
      ::media::VideoFrameFeedback p_feedback{};
      VideoCaptureHost_ReleaseBuffer_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDeviceId(&p_device_id))
        success = false;
      if (success)
        p_buffer_id = input_data_view.buffer_id();
      if (success && !input_data_view.ReadFeedback(&p_feedback))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoCaptureHost::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReleaseBuffer(
std::move(p_device_id), 
std::move(p_buffer_id), 
std::move(p_feedback));
      return true;
    }
    case internal::kVideoCaptureHost_GetDeviceSupportedFormats_Name: {
      break;
    }
    case internal::kVideoCaptureHost_GetDeviceFormatsInUse_Name: {
      break;
    }
    case internal::kVideoCaptureHost_OnFrameDropped_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::VideoCaptureHost::OnFrameDropped",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::VideoCaptureHost::OnFrameDropped");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::VideoCaptureHost_OnFrameDropped_Params_Data* params =
          reinterpret_cast<internal::VideoCaptureHost_OnFrameDropped_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::UnguessableToken p_device_id{};
      ::media::VideoCaptureFrameDropReason p_reason{};
      VideoCaptureHost_OnFrameDropped_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDeviceId(&p_device_id))
        success = false;
      if (success && !input_data_view.ReadReason(&p_reason))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoCaptureHost::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnFrameDropped(
std::move(p_device_id), 
std::move(p_reason));
      return true;
    }
    case internal::kVideoCaptureHost_OnLog_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::VideoCaptureHost::OnLog",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::VideoCaptureHost::OnLog");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::VideoCaptureHost_OnLog_Params_Data* params =
          reinterpret_cast<internal::VideoCaptureHost_OnLog_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::UnguessableToken p_device_id{};
      WTF::String p_message{};
      VideoCaptureHost_OnLog_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDeviceId(&p_device_id))
        success = false;
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoCaptureHost::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnLog(
std::move(p_device_id), 
std::move(p_message));
      return true;
    }
  }
  return false;
}

// static
bool VideoCaptureHostStubDispatch::AcceptWithResponder(
    VideoCaptureHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kVideoCaptureHost_Start_Name: {
      break;
    }
    case internal::kVideoCaptureHost_Stop_Name: {
      break;
    }
    case internal::kVideoCaptureHost_Pause_Name: {
      break;
    }
    case internal::kVideoCaptureHost_Resume_Name: {
      break;
    }
    case internal::kVideoCaptureHost_RequestRefreshFrame_Name: {
      break;
    }
    case internal::kVideoCaptureHost_ReleaseBuffer_Name: {
      break;
    }
    case internal::kVideoCaptureHost_GetDeviceSupportedFormats_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::VideoCaptureHost::GetDeviceSupportedFormats",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::VideoCaptureHost::GetDeviceSupportedFormats");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::VideoCaptureHost_GetDeviceSupportedFormats_Params_Data* params =
          reinterpret_cast<
              internal::VideoCaptureHost_GetDeviceSupportedFormats_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::base::UnguessableToken p_device_id{};
      ::base::UnguessableToken p_session_id{};
      VideoCaptureHost_GetDeviceSupportedFormats_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDeviceId(&p_device_id))
        success = false;
      if (success && !input_data_view.ReadSessionId(&p_session_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoCaptureHost::Name_, 6, false);
        return false;
      }
      VideoCaptureHost::GetDeviceSupportedFormatsCallback callback =
          VideoCaptureHost_GetDeviceSupportedFormats_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDeviceSupportedFormats(
std::move(p_device_id), 
std::move(p_session_id), std::move(callback));
      return true;
    }
    case internal::kVideoCaptureHost_GetDeviceFormatsInUse_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::VideoCaptureHost::GetDeviceFormatsInUse",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::VideoCaptureHost::GetDeviceFormatsInUse");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::VideoCaptureHost_GetDeviceFormatsInUse_Params_Data* params =
          reinterpret_cast<
              internal::VideoCaptureHost_GetDeviceFormatsInUse_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::base::UnguessableToken p_device_id{};
      ::base::UnguessableToken p_session_id{};
      VideoCaptureHost_GetDeviceFormatsInUse_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDeviceId(&p_device_id))
        success = false;
      if (success && !input_data_view.ReadSessionId(&p_session_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoCaptureHost::Name_, 7, false);
        return false;
      }
      VideoCaptureHost::GetDeviceFormatsInUseCallback callback =
          VideoCaptureHost_GetDeviceFormatsInUse_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDeviceFormatsInUse(
std::move(p_device_id), 
std::move(p_session_id), std::move(callback));
      return true;
    }
    case internal::kVideoCaptureHost_OnFrameDropped_Name: {
      break;
    }
    case internal::kVideoCaptureHost_OnLog_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kVideoCaptureHostValidationInfo[] = {
    {internal::kVideoCaptureHost_Start_Name,
     {&internal::VideoCaptureHost_Start_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kVideoCaptureHost_Stop_Name,
     {&internal::VideoCaptureHost_Stop_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kVideoCaptureHost_Pause_Name,
     {&internal::VideoCaptureHost_Pause_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kVideoCaptureHost_Resume_Name,
     {&internal::VideoCaptureHost_Resume_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kVideoCaptureHost_RequestRefreshFrame_Name,
     {&internal::VideoCaptureHost_RequestRefreshFrame_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kVideoCaptureHost_ReleaseBuffer_Name,
     {&internal::VideoCaptureHost_ReleaseBuffer_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kVideoCaptureHost_GetDeviceSupportedFormats_Name,
     {&internal::VideoCaptureHost_GetDeviceSupportedFormats_Params_Data::Validate,
      &internal::VideoCaptureHost_GetDeviceSupportedFormats_ResponseParams_Data::Validate}},
    {internal::kVideoCaptureHost_GetDeviceFormatsInUse_Name,
     {&internal::VideoCaptureHost_GetDeviceFormatsInUse_Params_Data::Validate,
      &internal::VideoCaptureHost_GetDeviceFormatsInUse_ResponseParams_Data::Validate}},
    {internal::kVideoCaptureHost_OnFrameDropped_Name,
     {&internal::VideoCaptureHost_OnFrameDropped_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kVideoCaptureHost_OnLog_Name,
     {&internal::VideoCaptureHost_OnLog_Params_Data::Validate,
      nullptr /* no response */}},
};

bool VideoCaptureHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::blink::VideoCaptureHost::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kVideoCaptureHostValidationInfo);
}

bool VideoCaptureHostResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::blink::VideoCaptureHost::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kVideoCaptureHostValidationInfo);

}
}  // namespace blink
}  // namespace mojom
}  // namespace media

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif