// media/capture/mojom/video_capture_types.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/capture/mojom/video_capture_types.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "media/capture/mojom/video_capture_types.mojom-params-data.h"
#include "media/capture/mojom/video_capture_types.mojom-shared-message-ids.h"

#include "media/capture/mojom/video_capture_types.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef MEDIA_CAPTURE_MOJOM_VIDEO_CAPTURE_TYPES_MOJOM_BLINK_JUMBO_H_
#define MEDIA_CAPTURE_MOJOM_VIDEO_CAPTURE_TYPES_MOJOM_BLINK_JUMBO_H_
#endif
namespace media {
namespace mojom {
namespace blink {
VideoCaptureControlSupport::VideoCaptureControlSupport()
    : pan(),
      tilt(),
      zoom() {}

VideoCaptureControlSupport::VideoCaptureControlSupport(
    bool pan_in,
    bool tilt_in,
    bool zoom_in)
    : pan(std::move(pan_in)),
      tilt(std::move(tilt_in)),
      zoom(std::move(zoom_in)) {}

VideoCaptureControlSupport::~VideoCaptureControlSupport() = default;

void VideoCaptureControlSupport::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pan"), this->pan, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tilt"), this->tilt, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "zoom"), this->zoom, 
      "<value of type bool>");
}

bool VideoCaptureControlSupport::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VideoCaptureFormat::VideoCaptureFormat()
    : frame_size(),
      frame_rate(),
      pixel_format() {}

VideoCaptureFormat::VideoCaptureFormat(
    const ::gfx::Size& frame_size_in,
    float frame_rate_in,
    ::media::VideoPixelFormat pixel_format_in)
    : frame_size(std::move(frame_size_in)),
      frame_rate(std::move(frame_rate_in)),
      pixel_format(std::move(pixel_format_in)) {}

VideoCaptureFormat::~VideoCaptureFormat() = default;

void VideoCaptureFormat::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_size"), this->frame_size, 
      "<value of type const ::gfx::Size&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_rate"), this->frame_rate, 
      "<value of type float>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pixel_format"), this->pixel_format, 
      "<value of type ::media::VideoPixelFormat>");
}

bool VideoCaptureFormat::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VideoCaptureParams::VideoCaptureParams()
    : requested_format(),
      buffer_type(),
      resolution_change_policy(),
      power_line_frequency(),
      enable_face_detection() {}

VideoCaptureParams::VideoCaptureParams(
    const ::media::VideoCaptureFormat& requested_format_in,
    ::media::VideoCaptureBufferType buffer_type_in,
    ::media::ResolutionChangePolicy resolution_change_policy_in,
    ::media::PowerLineFrequency power_line_frequency_in,
    bool enable_face_detection_in)
    : requested_format(std::move(requested_format_in)),
      buffer_type(std::move(buffer_type_in)),
      resolution_change_policy(std::move(resolution_change_policy_in)),
      power_line_frequency(std::move(power_line_frequency_in)),
      enable_face_detection(std::move(enable_face_detection_in)) {}

VideoCaptureParams::~VideoCaptureParams() = default;

void VideoCaptureParams::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "requested_format"), this->requested_format, 
      "<value of type const ::media::VideoCaptureFormat&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "buffer_type"), this->buffer_type, 
      "<value of type ::media::VideoCaptureBufferType>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "resolution_change_policy"), this->resolution_change_policy, 
      "<value of type ::media::ResolutionChangePolicy>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "power_line_frequency"), this->power_line_frequency, 
      "<value of type ::media::PowerLineFrequency>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_face_detection"), this->enable_face_detection, 
      "<value of type bool>");
}

bool VideoCaptureParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VideoFrameFeedback::VideoFrameFeedback()
    : resource_utilization(),
      max_framerate_fps(),
      max_pixels() {}

VideoFrameFeedback::VideoFrameFeedback(
    double resource_utilization_in,
    float max_framerate_fps_in,
    int32_t max_pixels_in)
    : resource_utilization(std::move(resource_utilization_in)),
      max_framerate_fps(std::move(max_framerate_fps_in)),
      max_pixels(std::move(max_pixels_in)) {}

VideoFrameFeedback::~VideoFrameFeedback() = default;

void VideoFrameFeedback::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "resource_utilization"), this->resource_utilization, 
      "<value of type double>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_framerate_fps"), this->max_framerate_fps, 
      "<value of type float>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_pixels"), this->max_pixels, 
      "<value of type int32_t>");
}

bool VideoFrameFeedback::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PlaneStrides::PlaneStrides()
    : stride_by_plane() {}

PlaneStrides::PlaneStrides(
    WTF::Vector<uint32_t> stride_by_plane_in)
    : stride_by_plane(std::move(stride_by_plane_in)) {}

PlaneStrides::~PlaneStrides() = default;

void PlaneStrides::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "stride_by_plane"), this->stride_by_plane, 
      "<value of type const WTF::Vector<uint32_t>&>");
}

bool PlaneStrides::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VideoFrameInfo::VideoFrameInfo()
    : timestamp(),
      metadata(),
      pixel_format(),
      coded_size(),
      visible_rect(),
      color_space(),
      strides() {}

VideoFrameInfo::VideoFrameInfo(
    ::base::TimeDelta timestamp_in,
    const ::media::VideoFrameMetadata& metadata_in,
    ::media::VideoPixelFormat pixel_format_in,
    const ::gfx::Size& coded_size_in,
    const ::gfx::Rect& visible_rect_in,
    const base::Optional<::gfx::ColorSpace>& color_space_in,
    PlaneStridesPtr strides_in)
    : timestamp(std::move(timestamp_in)),
      metadata(std::move(metadata_in)),
      pixel_format(std::move(pixel_format_in)),
      coded_size(std::move(coded_size_in)),
      visible_rect(std::move(visible_rect_in)),
      color_space(std::move(color_space_in)),
      strides(std::move(strides_in)) {}

VideoFrameInfo::~VideoFrameInfo() = default;

void VideoFrameInfo::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "timestamp"), this->timestamp, 
      "<value of type ::base::TimeDelta>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "metadata"), this->metadata, 
      "<value of type const ::media::VideoFrameMetadata&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pixel_format"), this->pixel_format, 
      "<value of type ::media::VideoPixelFormat>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "coded_size"), this->coded_size, 
      "<value of type const ::gfx::Size&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "visible_rect"), this->visible_rect, 
      "<value of type const ::gfx::Rect&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "color_space"), this->color_space, 
      "<value of type const base::Optional<::gfx::ColorSpace>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "strides"), this->strides, 
      "<value of type PlaneStridesPtr>");
}

bool VideoFrameInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ReadyBuffer::ReadyBuffer()
    : buffer_id(),
      info() {}

ReadyBuffer::ReadyBuffer(
    int32_t buffer_id_in,
    VideoFrameInfoPtr info_in)
    : buffer_id(std::move(buffer_id_in)),
      info(std::move(info_in)) {}

ReadyBuffer::~ReadyBuffer() = default;

void ReadyBuffer::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "buffer_id"), this->buffer_id, 
      "<value of type int32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "info"), this->info, 
      "<value of type VideoFrameInfoPtr>");
}

bool ReadyBuffer::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VideoCaptureDeviceDescriptor::VideoCaptureDeviceDescriptor()
    : display_name(),
      device_id(),
      model_id(),
      facing_mode(),
      capture_api(),
      control_support(),
      transport_type() {}

VideoCaptureDeviceDescriptor::VideoCaptureDeviceDescriptor(
    const WTF::String& display_name_in,
    const WTF::String& device_id_in,
    const WTF::String& model_id_in,
    ::media::VideoFacingMode facing_mode_in,
    VideoCaptureApi capture_api_in,
    const ::media::VideoCaptureControlSupport& control_support_in,
    VideoCaptureTransportType transport_type_in)
    : display_name(std::move(display_name_in)),
      device_id(std::move(device_id_in)),
      model_id(std::move(model_id_in)),
      facing_mode(std::move(facing_mode_in)),
      capture_api(std::move(capture_api_in)),
      control_support(std::move(control_support_in)),
      transport_type(std::move(transport_type_in)) {}

VideoCaptureDeviceDescriptor::~VideoCaptureDeviceDescriptor() = default;

void VideoCaptureDeviceDescriptor::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "display_name"), this->display_name, 
      "<value of type const WTF::String&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "device_id"), this->device_id, 
      "<value of type const WTF::String&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "model_id"), this->model_id, 
      "<value of type const WTF::String&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "facing_mode"), this->facing_mode, 
      "<value of type ::media::VideoFacingMode>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "capture_api"), this->capture_api, 
      "<value of type VideoCaptureApi>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "control_support"), this->control_support, 
      "<value of type const ::media::VideoCaptureControlSupport&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "transport_type"), this->transport_type, 
      "<value of type VideoCaptureTransportType>");
}

bool VideoCaptureDeviceDescriptor::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VideoCaptureDeviceInfo::VideoCaptureDeviceInfo()
    : descriptor(),
      supported_formats() {}

VideoCaptureDeviceInfo::VideoCaptureDeviceInfo(
    const ::media::VideoCaptureDeviceDescriptor& descriptor_in,
    WTF::Vector<::media::VideoCaptureFormat> supported_formats_in)
    : descriptor(std::move(descriptor_in)),
      supported_formats(std::move(supported_formats_in)) {}

VideoCaptureDeviceInfo::~VideoCaptureDeviceInfo() = default;

void VideoCaptureDeviceInfo::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "descriptor"), this->descriptor, 
      "<value of type const ::media::VideoCaptureDeviceDescriptor&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "supported_formats"), this->supported_formats, 
      "<value of type const WTF::Vector<::media::VideoCaptureFormat>&>");
}

bool VideoCaptureDeviceInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
MailboxBufferHandleSet::MailboxBufferHandleSet()
    : mailbox_holder() {}

MailboxBufferHandleSet::MailboxBufferHandleSet(
    WTF::Vector<::gpu::MailboxHolder> mailbox_holder_in)
    : mailbox_holder(std::move(mailbox_holder_in)) {}

MailboxBufferHandleSet::~MailboxBufferHandleSet() = default;

void MailboxBufferHandleSet::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mailbox_holder"), this->mailbox_holder, 
      "<value of type const WTF::Vector<::gpu::MailboxHolder>&>");
}

bool MailboxBufferHandleSet::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SharedMemoryViaRawFileDescriptor::SharedMemoryViaRawFileDescriptor()
    : file_descriptor_handle(),
      shared_memory_size_in_bytes() {}

SharedMemoryViaRawFileDescriptor::SharedMemoryViaRawFileDescriptor(
    ::mojo::PlatformHandle file_descriptor_handle_in,
    uint32_t shared_memory_size_in_bytes_in)
    : file_descriptor_handle(std::move(file_descriptor_handle_in)),
      shared_memory_size_in_bytes(std::move(shared_memory_size_in_bytes_in)) {}

SharedMemoryViaRawFileDescriptor::~SharedMemoryViaRawFileDescriptor() = default;

void SharedMemoryViaRawFileDescriptor::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "file_descriptor_handle"), this->file_descriptor_handle, 
      "<value of type ::mojo::PlatformHandle>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "shared_memory_size_in_bytes"), this->shared_memory_size_in_bytes, 
      "<value of type uint32_t>");
}

bool SharedMemoryViaRawFileDescriptor::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VideoBufferHandle::VideoBufferHandle() : tag_(Tag::SHARED_BUFFER_HANDLE) {
  data_.shared_buffer_handle = new ::mojo::ScopedSharedBufferHandle;
}

VideoBufferHandle::~VideoBufferHandle() {
  DestroyActive();
}


void VideoBufferHandle::set_shared_buffer_handle(
    ::mojo::ScopedSharedBufferHandle shared_buffer_handle) {
  if (tag_ == Tag::SHARED_BUFFER_HANDLE) {
    *(data_.shared_buffer_handle) = std::move(shared_buffer_handle);
  } else {
    DestroyActive();
    tag_ = Tag::SHARED_BUFFER_HANDLE;
    data_.shared_buffer_handle = new ::mojo::ScopedSharedBufferHandle(
        std::move(shared_buffer_handle));
  }
}
void VideoBufferHandle::set_read_only_shmem_region(
    ::base::ReadOnlySharedMemoryRegion read_only_shmem_region) {
  if (tag_ == Tag::READ_ONLY_SHMEM_REGION) {
    *(data_.read_only_shmem_region) = std::move(read_only_shmem_region);
  } else {
    DestroyActive();
    tag_ = Tag::READ_ONLY_SHMEM_REGION;
    data_.read_only_shmem_region = new ::base::ReadOnlySharedMemoryRegion(
        std::move(read_only_shmem_region));
  }
}
void VideoBufferHandle::set_shared_memory_via_raw_file_descriptor(
    SharedMemoryViaRawFileDescriptorPtr shared_memory_via_raw_file_descriptor) {
  if (tag_ == Tag::SHARED_MEMORY_VIA_RAW_FILE_DESCRIPTOR) {
    *(data_.shared_memory_via_raw_file_descriptor) = std::move(shared_memory_via_raw_file_descriptor);
  } else {
    DestroyActive();
    tag_ = Tag::SHARED_MEMORY_VIA_RAW_FILE_DESCRIPTOR;
    data_.shared_memory_via_raw_file_descriptor = new SharedMemoryViaRawFileDescriptorPtr(
        std::move(shared_memory_via_raw_file_descriptor));
  }
}
void VideoBufferHandle::set_mailbox_handles(
    MailboxBufferHandleSetPtr mailbox_handles) {
  if (tag_ == Tag::MAILBOX_HANDLES) {
    *(data_.mailbox_handles) = std::move(mailbox_handles);
  } else {
    DestroyActive();
    tag_ = Tag::MAILBOX_HANDLES;
    data_.mailbox_handles = new MailboxBufferHandleSetPtr(
        std::move(mailbox_handles));
  }
}
void VideoBufferHandle::set_gpu_memory_buffer_handle(
    ::gfx::GpuMemoryBufferHandle gpu_memory_buffer_handle) {
  if (tag_ == Tag::GPU_MEMORY_BUFFER_HANDLE) {
    *(data_.gpu_memory_buffer_handle) = std::move(gpu_memory_buffer_handle);
  } else {
    DestroyActive();
    tag_ = Tag::GPU_MEMORY_BUFFER_HANDLE;
    data_.gpu_memory_buffer_handle = new ::gfx::GpuMemoryBufferHandle(
        std::move(gpu_memory_buffer_handle));
  }
}

void VideoBufferHandle::DestroyActive() {
  switch (tag_) {

    case Tag::SHARED_BUFFER_HANDLE:

      delete data_.shared_buffer_handle;
      break;
    case Tag::READ_ONLY_SHMEM_REGION:

      delete data_.read_only_shmem_region;
      break;
    case Tag::SHARED_MEMORY_VIA_RAW_FILE_DESCRIPTOR:

      delete data_.shared_memory_via_raw_file_descriptor;
      break;
    case Tag::MAILBOX_HANDLES:

      delete data_.mailbox_handles;
      break;
    case Tag::GPU_MEMORY_BUFFER_HANDLE:

      delete data_.gpu_memory_buffer_handle;
      break;
  }
}

bool VideoBufferHandle::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
}  // namespace blink
}  // namespace mojom
}  // namespace media

namespace mojo {


// static
bool StructTraits<::media::mojom::blink::VideoCaptureControlSupport::DataView, ::media::mojom::blink::VideoCaptureControlSupportPtr>::Read(
    ::media::mojom::blink::VideoCaptureControlSupport::DataView input,
    ::media::mojom::blink::VideoCaptureControlSupportPtr* output) {
  bool success = true;
  ::media::mojom::blink::VideoCaptureControlSupportPtr result(::media::mojom::blink::VideoCaptureControlSupport::New());
  
      if (success)
        result->pan = input.pan();
      if (success)
        result->tilt = input.tilt();
      if (success)
        result->zoom = input.zoom();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::blink::VideoCaptureFormat::DataView, ::media::mojom::blink::VideoCaptureFormatPtr>::Read(
    ::media::mojom::blink::VideoCaptureFormat::DataView input,
    ::media::mojom::blink::VideoCaptureFormatPtr* output) {
  bool success = true;
  ::media::mojom::blink::VideoCaptureFormatPtr result(::media::mojom::blink::VideoCaptureFormat::New());
  
      if (success && !input.ReadFrameSize(&result->frame_size))
        success = false;
      if (success)
        result->frame_rate = input.frame_rate();
      if (success && !input.ReadPixelFormat(&result->pixel_format))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::blink::VideoCaptureParams::DataView, ::media::mojom::blink::VideoCaptureParamsPtr>::Read(
    ::media::mojom::blink::VideoCaptureParams::DataView input,
    ::media::mojom::blink::VideoCaptureParamsPtr* output) {
  bool success = true;
  ::media::mojom::blink::VideoCaptureParamsPtr result(::media::mojom::blink::VideoCaptureParams::New());
  
      if (success && !input.ReadRequestedFormat(&result->requested_format))
        success = false;
      if (success && !input.ReadBufferType(&result->buffer_type))
        success = false;
      if (success && !input.ReadResolutionChangePolicy(&result->resolution_change_policy))
        success = false;
      if (success && !input.ReadPowerLineFrequency(&result->power_line_frequency))
        success = false;
      if (success)
        result->enable_face_detection = input.enable_face_detection();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::blink::VideoFrameFeedback::DataView, ::media::mojom::blink::VideoFrameFeedbackPtr>::Read(
    ::media::mojom::blink::VideoFrameFeedback::DataView input,
    ::media::mojom::blink::VideoFrameFeedbackPtr* output) {
  bool success = true;
  ::media::mojom::blink::VideoFrameFeedbackPtr result(::media::mojom::blink::VideoFrameFeedback::New());
  
      if (success)
        result->resource_utilization = input.resource_utilization();
      if (success)
        result->max_framerate_fps = input.max_framerate_fps();
      if (success)
        result->max_pixels = input.max_pixels();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::blink::PlaneStrides::DataView, ::media::mojom::blink::PlaneStridesPtr>::Read(
    ::media::mojom::blink::PlaneStrides::DataView input,
    ::media::mojom::blink::PlaneStridesPtr* output) {
  bool success = true;
  ::media::mojom::blink::PlaneStridesPtr result(::media::mojom::blink::PlaneStrides::New());
  
      if (success && !input.ReadStrideByPlane(&result->stride_by_plane))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::blink::VideoFrameInfo::DataView, ::media::mojom::blink::VideoFrameInfoPtr>::Read(
    ::media::mojom::blink::VideoFrameInfo::DataView input,
    ::media::mojom::blink::VideoFrameInfoPtr* output) {
  bool success = true;
  ::media::mojom::blink::VideoFrameInfoPtr result(::media::mojom::blink::VideoFrameInfo::New());
  
      if (success && !input.ReadTimestamp(&result->timestamp))
        success = false;
      if (success && !input.ReadMetadata(&result->metadata))
        success = false;
      if (success && !input.ReadPixelFormat(&result->pixel_format))
        success = false;
      if (success && !input.ReadCodedSize(&result->coded_size))
        success = false;
      if (success && !input.ReadVisibleRect(&result->visible_rect))
        success = false;
      if (success && !input.ReadColorSpace(&result->color_space))
        success = false;
      if (success && !input.ReadStrides(&result->strides))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::blink::ReadyBuffer::DataView, ::media::mojom::blink::ReadyBufferPtr>::Read(
    ::media::mojom::blink::ReadyBuffer::DataView input,
    ::media::mojom::blink::ReadyBufferPtr* output) {
  bool success = true;
  ::media::mojom::blink::ReadyBufferPtr result(::media::mojom::blink::ReadyBuffer::New());
  
      if (success)
        result->buffer_id = input.buffer_id();
      if (success && !input.ReadInfo(&result->info))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::blink::VideoCaptureDeviceDescriptor::DataView, ::media::mojom::blink::VideoCaptureDeviceDescriptorPtr>::Read(
    ::media::mojom::blink::VideoCaptureDeviceDescriptor::DataView input,
    ::media::mojom::blink::VideoCaptureDeviceDescriptorPtr* output) {
  bool success = true;
  ::media::mojom::blink::VideoCaptureDeviceDescriptorPtr result(::media::mojom::blink::VideoCaptureDeviceDescriptor::New());
  
      if (success && !input.ReadDisplayName(&result->display_name))
        success = false;
      if (success && !input.ReadDeviceId(&result->device_id))
        success = false;
      if (success && !input.ReadModelId(&result->model_id))
        success = false;
      if (success && !input.ReadFacingMode(&result->facing_mode))
        success = false;
      if (success && !input.ReadCaptureApi(&result->capture_api))
        success = false;
      if (success && !input.ReadControlSupport(&result->control_support))
        success = false;
      if (success && !input.ReadTransportType(&result->transport_type))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::blink::VideoCaptureDeviceInfo::DataView, ::media::mojom::blink::VideoCaptureDeviceInfoPtr>::Read(
    ::media::mojom::blink::VideoCaptureDeviceInfo::DataView input,
    ::media::mojom::blink::VideoCaptureDeviceInfoPtr* output) {
  bool success = true;
  ::media::mojom::blink::VideoCaptureDeviceInfoPtr result(::media::mojom::blink::VideoCaptureDeviceInfo::New());
  
      if (success && !input.ReadDescriptor(&result->descriptor))
        success = false;
      if (success && !input.ReadSupportedFormats(&result->supported_formats))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::blink::MailboxBufferHandleSet::DataView, ::media::mojom::blink::MailboxBufferHandleSetPtr>::Read(
    ::media::mojom::blink::MailboxBufferHandleSet::DataView input,
    ::media::mojom::blink::MailboxBufferHandleSetPtr* output) {
  bool success = true;
  ::media::mojom::blink::MailboxBufferHandleSetPtr result(::media::mojom::blink::MailboxBufferHandleSet::New());
  
      if (success && !input.ReadMailboxHolder(&result->mailbox_holder))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::blink::SharedMemoryViaRawFileDescriptor::DataView, ::media::mojom::blink::SharedMemoryViaRawFileDescriptorPtr>::Read(
    ::media::mojom::blink::SharedMemoryViaRawFileDescriptor::DataView input,
    ::media::mojom::blink::SharedMemoryViaRawFileDescriptorPtr* output) {
  bool success = true;
  ::media::mojom::blink::SharedMemoryViaRawFileDescriptorPtr result(::media::mojom::blink::SharedMemoryViaRawFileDescriptor::New());
  
      if (success)
        result->file_descriptor_handle = input.TakeFileDescriptorHandle();
      if (success)
        result->shared_memory_size_in_bytes = input.shared_memory_size_in_bytes();
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::media::mojom::blink::VideoBufferHandle::DataView, ::media::mojom::blink::VideoBufferHandlePtr>::Read(
    ::media::mojom::blink::VideoBufferHandle::DataView input,
    ::media::mojom::blink::VideoBufferHandlePtr* output) {
  using UnionType = ::media::mojom::blink::VideoBufferHandle;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::SHARED_BUFFER_HANDLE: {
      *output = UnionType::NewSharedBufferHandle(
          input.TakeSharedBufferHandle());
      break;
    }
    case Tag::READ_ONLY_SHMEM_REGION: {
      ::base::ReadOnlySharedMemoryRegion result_read_only_shmem_region;
      if (!input.ReadReadOnlyShmemRegion(&result_read_only_shmem_region))
        return false;

      *output = UnionType::NewReadOnlyShmemRegion(
          std::move(result_read_only_shmem_region));
      break;
    }
    case Tag::SHARED_MEMORY_VIA_RAW_FILE_DESCRIPTOR: {
      ::media::mojom::blink::SharedMemoryViaRawFileDescriptorPtr result_shared_memory_via_raw_file_descriptor;
      if (!input.ReadSharedMemoryViaRawFileDescriptor(&result_shared_memory_via_raw_file_descriptor))
        return false;

      *output = UnionType::NewSharedMemoryViaRawFileDescriptor(
          std::move(result_shared_memory_via_raw_file_descriptor));
      break;
    }
    case Tag::MAILBOX_HANDLES: {
      ::media::mojom::blink::MailboxBufferHandleSetPtr result_mailbox_handles;
      if (!input.ReadMailboxHandles(&result_mailbox_handles))
        return false;

      *output = UnionType::NewMailboxHandles(
          std::move(result_mailbox_handles));
      break;
    }
    case Tag::GPU_MEMORY_BUFFER_HANDLE: {
      ::gfx::GpuMemoryBufferHandle result_gpu_memory_buffer_handle;
      if (!input.ReadGpuMemoryBufferHandle(&result_gpu_memory_buffer_handle))
        return false;

      *output = UnionType::NewGpuMemoryBufferHandle(
          std::move(result_gpu_memory_buffer_handle));
      break;
    }
    default:
      return false;
  }
  return true;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif