// media/capture/mojom/video_capture_types.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "media/capture/mojom/video_capture_types.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/capture/mojom/video_capture_types.mojom-params-data.h"
namespace media {
namespace mojom {

std::string VideoCapturePixelFormatToString(VideoCapturePixelFormat value) {
  switch(value) {
    case VideoCapturePixelFormat::UNKNOWN:
      return "VideoCapturePixelFormat::UNKNOWN";
    case VideoCapturePixelFormat::I420:
      return "VideoCapturePixelFormat::I420";
    case VideoCapturePixelFormat::YV12:
      return "VideoCapturePixelFormat::YV12";
    case VideoCapturePixelFormat::I422:
      return "VideoCapturePixelFormat::I422";
    case VideoCapturePixelFormat::I420A:
      return "VideoCapturePixelFormat::I420A";
    case VideoCapturePixelFormat::I444:
      return "VideoCapturePixelFormat::I444";
    case VideoCapturePixelFormat::NV12:
      return "VideoCapturePixelFormat::NV12";
    case VideoCapturePixelFormat::NV21:
      return "VideoCapturePixelFormat::NV21";
    case VideoCapturePixelFormat::UYVY:
      return "VideoCapturePixelFormat::UYVY";
    case VideoCapturePixelFormat::YUY2:
      return "VideoCapturePixelFormat::YUY2";
    case VideoCapturePixelFormat::ARGB:
      return "VideoCapturePixelFormat::ARGB";
    case VideoCapturePixelFormat::XRGB:
      return "VideoCapturePixelFormat::XRGB";
    case VideoCapturePixelFormat::RGB24:
      return "VideoCapturePixelFormat::RGB24";
    case VideoCapturePixelFormat::MJPEG:
      return "VideoCapturePixelFormat::MJPEG";
    case VideoCapturePixelFormat::YUV420P9:
      return "VideoCapturePixelFormat::YUV420P9";
    case VideoCapturePixelFormat::YUV420P10:
      return "VideoCapturePixelFormat::YUV420P10";
    case VideoCapturePixelFormat::YUV422P9:
      return "VideoCapturePixelFormat::YUV422P9";
    case VideoCapturePixelFormat::YUV422P10:
      return "VideoCapturePixelFormat::YUV422P10";
    case VideoCapturePixelFormat::YUV444P9:
      return "VideoCapturePixelFormat::YUV444P9";
    case VideoCapturePixelFormat::YUV444P10:
      return "VideoCapturePixelFormat::YUV444P10";
    case VideoCapturePixelFormat::YUV420P12:
      return "VideoCapturePixelFormat::YUV420P12";
    case VideoCapturePixelFormat::YUV422P12:
      return "VideoCapturePixelFormat::YUV422P12";
    case VideoCapturePixelFormat::YUV444P12:
      return "VideoCapturePixelFormat::YUV444P12";
    case VideoCapturePixelFormat::Y16:
      return "VideoCapturePixelFormat::Y16";
    case VideoCapturePixelFormat::ABGR:
      return "VideoCapturePixelFormat::ABGR";
    case VideoCapturePixelFormat::XBGR:
      return "VideoCapturePixelFormat::XBGR";
    case VideoCapturePixelFormat::P016LE:
      return "VideoCapturePixelFormat::P016LE";
    case VideoCapturePixelFormat::XR30:
      return "VideoCapturePixelFormat::XR30";
    case VideoCapturePixelFormat::XB30:
      return "VideoCapturePixelFormat::XB30";
    case VideoCapturePixelFormat::BGRA:
      return "VideoCapturePixelFormat::BGRA";
    case VideoCapturePixelFormat::RGBAF16:
      return "VideoCapturePixelFormat::RGBAF16";
    default:
      return base::StringPrintf("Unknown VideoCapturePixelFormat value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, VideoCapturePixelFormat value) {
  return os << VideoCapturePixelFormatToString(value);
}

std::string ResolutionChangePolicyToString(ResolutionChangePolicy value) {
  switch(value) {
    case ResolutionChangePolicy::FIXED_RESOLUTION:
      return "ResolutionChangePolicy::FIXED_RESOLUTION";
    case ResolutionChangePolicy::FIXED_ASPECT_RATIO:
      return "ResolutionChangePolicy::FIXED_ASPECT_RATIO";
    case ResolutionChangePolicy::ANY_WITHIN_LIMIT:
      return "ResolutionChangePolicy::ANY_WITHIN_LIMIT";
    default:
      return base::StringPrintf("Unknown ResolutionChangePolicy value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, ResolutionChangePolicy value) {
  return os << ResolutionChangePolicyToString(value);
}

std::string PowerLineFrequencyToString(PowerLineFrequency value) {
  switch(value) {
    case PowerLineFrequency::DEFAULT:
      return "PowerLineFrequency::DEFAULT";
    case PowerLineFrequency::HZ_50:
      return "PowerLineFrequency::HZ_50";
    case PowerLineFrequency::HZ_60:
      return "PowerLineFrequency::HZ_60";
    default:
      return base::StringPrintf("Unknown PowerLineFrequency value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, PowerLineFrequency value) {
  return os << PowerLineFrequencyToString(value);
}

std::string VideoFacingModeToString(VideoFacingMode value) {
  switch(value) {
    case VideoFacingMode::NONE:
      return "VideoFacingMode::NONE";
    case VideoFacingMode::USER:
      return "VideoFacingMode::USER";
    case VideoFacingMode::ENVIRONMENT:
      return "VideoFacingMode::ENVIRONMENT";
    default:
      return base::StringPrintf("Unknown VideoFacingMode value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, VideoFacingMode value) {
  return os << VideoFacingModeToString(value);
}

std::string VideoCaptureApiToString(VideoCaptureApi value) {
  switch(value) {
    case VideoCaptureApi::LINUX_V4L2_SINGLE_PLANE:
      return "VideoCaptureApi::LINUX_V4L2_SINGLE_PLANE";
    case VideoCaptureApi::WIN_MEDIA_FOUNDATION:
      return "VideoCaptureApi::WIN_MEDIA_FOUNDATION";
    case VideoCaptureApi::WIN_MEDIA_FOUNDATION_SENSOR:
      return "VideoCaptureApi::WIN_MEDIA_FOUNDATION_SENSOR";
    case VideoCaptureApi::WIN_DIRECT_SHOW:
      return "VideoCaptureApi::WIN_DIRECT_SHOW";
    case VideoCaptureApi::MACOSX_AVFOUNDATION:
      return "VideoCaptureApi::MACOSX_AVFOUNDATION";
    case VideoCaptureApi::MACOSX_DECKLINK:
      return "VideoCaptureApi::MACOSX_DECKLINK";
    case VideoCaptureApi::ANDROID_API1:
      return "VideoCaptureApi::ANDROID_API1";
    case VideoCaptureApi::ANDROID_API2_LEGACY:
      return "VideoCaptureApi::ANDROID_API2_LEGACY";
    case VideoCaptureApi::ANDROID_API2_FULL:
      return "VideoCaptureApi::ANDROID_API2_FULL";
    case VideoCaptureApi::ANDROID_API2_LIMITED:
      return "VideoCaptureApi::ANDROID_API2_LIMITED";
    case VideoCaptureApi::FUCHSIA_CAMERA3:
      return "VideoCaptureApi::FUCHSIA_CAMERA3";
    case VideoCaptureApi::VIRTUAL_DEVICE:
      return "VideoCaptureApi::VIRTUAL_DEVICE";
    case VideoCaptureApi::UNKNOWN:
      return "VideoCaptureApi::UNKNOWN";
    default:
      return base::StringPrintf("Unknown VideoCaptureApi value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, VideoCaptureApi value) {
  return os << VideoCaptureApiToString(value);
}

std::string VideoCaptureTransportTypeToString(VideoCaptureTransportType value) {
  switch(value) {
    case VideoCaptureTransportType::MACOSX_USB_OR_BUILT_IN:
      return "VideoCaptureTransportType::MACOSX_USB_OR_BUILT_IN";
    case VideoCaptureTransportType::OTHER_TRANSPORT:
      return "VideoCaptureTransportType::OTHER_TRANSPORT";
    default:
      return base::StringPrintf("Unknown VideoCaptureTransportType value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, VideoCaptureTransportType value) {
  return os << VideoCaptureTransportTypeToString(value);
}

std::string VideoCaptureBufferTypeToString(VideoCaptureBufferType value) {
  switch(value) {
    case VideoCaptureBufferType::kSharedMemory:
      return "VideoCaptureBufferType::kSharedMemory";
    case VideoCaptureBufferType::kSharedMemoryViaRawFileDescriptor:
      return "VideoCaptureBufferType::kSharedMemoryViaRawFileDescriptor";
    case VideoCaptureBufferType::kMailboxHolder:
      return "VideoCaptureBufferType::kMailboxHolder";
    case VideoCaptureBufferType::kGpuMemoryBuffer:
      return "VideoCaptureBufferType::kGpuMemoryBuffer";
    default:
      return base::StringPrintf("Unknown VideoCaptureBufferType value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, VideoCaptureBufferType value) {
  return os << VideoCaptureBufferTypeToString(value);
}

std::string VideoCaptureErrorToString(VideoCaptureError value) {
  switch(value) {
    case VideoCaptureError::kNone:
      return "VideoCaptureError::kNone";
    case VideoCaptureError::kVideoCaptureControllerInvalidOrUnsupportedVideoCaptureParametersRequested:
      return "VideoCaptureError::kVideoCaptureControllerInvalidOrUnsupportedVideoCaptureParametersRequested";
    case VideoCaptureError::kVideoCaptureControllerIsAlreadyInErrorState:
      return "VideoCaptureError::kVideoCaptureControllerIsAlreadyInErrorState";
    case VideoCaptureError::kVideoCaptureManagerDeviceConnectionLost:
      return "VideoCaptureError::kVideoCaptureManagerDeviceConnectionLost";
    case VideoCaptureError::kFrameSinkVideoCaptureDeviceAleradyEndedOnFatalError:
      return "VideoCaptureError::kFrameSinkVideoCaptureDeviceAleradyEndedOnFatalError";
    case VideoCaptureError::kFrameSinkVideoCaptureDeviceEncounteredFatalError:
      return "VideoCaptureError::kFrameSinkVideoCaptureDeviceEncounteredFatalError";
    case VideoCaptureError::kV4L2FailedToOpenV4L2DeviceDriverFile:
      return "VideoCaptureError::kV4L2FailedToOpenV4L2DeviceDriverFile";
    case VideoCaptureError::kV4L2ThisIsNotAV4L2VideoCaptureDevice:
      return "VideoCaptureError::kV4L2ThisIsNotAV4L2VideoCaptureDevice";
    case VideoCaptureError::kV4L2FailedToFindASupportedCameraFormat:
      return "VideoCaptureError::kV4L2FailedToFindASupportedCameraFormat";
    case VideoCaptureError::kV4L2FailedToSetVideoCaptureFormat:
      return "VideoCaptureError::kV4L2FailedToSetVideoCaptureFormat";
    case VideoCaptureError::kV4L2UnsupportedPixelFormat:
      return "VideoCaptureError::kV4L2UnsupportedPixelFormat";
    case VideoCaptureError::kV4L2FailedToSetCameraFramerate:
      return "VideoCaptureError::kV4L2FailedToSetCameraFramerate";
    case VideoCaptureError::kV4L2ErrorRequestingMmapBuffers:
      return "VideoCaptureError::kV4L2ErrorRequestingMmapBuffers";
    case VideoCaptureError::kV4L2AllocateBufferFailed:
      return "VideoCaptureError::kV4L2AllocateBufferFailed";
    case VideoCaptureError::kV4L2VidiocStreamonFailed:
      return "VideoCaptureError::kV4L2VidiocStreamonFailed";
    case VideoCaptureError::kV4L2VidiocStreamoffFailed:
      return "VideoCaptureError::kV4L2VidiocStreamoffFailed";
    case VideoCaptureError::kV4L2FailedToVidiocReqbufsWithCount0:
      return "VideoCaptureError::kV4L2FailedToVidiocReqbufsWithCount0";
    case VideoCaptureError::kV4L2PollFailed:
      return "VideoCaptureError::kV4L2PollFailed";
    case VideoCaptureError::kV4L2MultipleContinuousTimeoutsWhileReadPolling:
      return "VideoCaptureError::kV4L2MultipleContinuousTimeoutsWhileReadPolling";
    case VideoCaptureError::kV4L2FailedToDequeueCaptureBuffer:
      return "VideoCaptureError::kV4L2FailedToDequeueCaptureBuffer";
    case VideoCaptureError::kV4L2FailedToEnqueueCaptureBuffer:
      return "VideoCaptureError::kV4L2FailedToEnqueueCaptureBuffer";
    case VideoCaptureError::kSingleClientVideoCaptureHostLostConnectionToDevice:
      return "VideoCaptureError::kSingleClientVideoCaptureHostLostConnectionToDevice";
    case VideoCaptureError::kSingleClientVideoCaptureDeviceLaunchAborted:
      return "VideoCaptureError::kSingleClientVideoCaptureDeviceLaunchAborted";
    case VideoCaptureError::kDesktopCaptureDeviceWebrtcDesktopCapturerHasFailed:
      return "VideoCaptureError::kDesktopCaptureDeviceWebrtcDesktopCapturerHasFailed";
    case VideoCaptureError::kFileVideoCaptureDeviceCouldNotOpenVideoFile:
      return "VideoCaptureError::kFileVideoCaptureDeviceCouldNotOpenVideoFile";
    case VideoCaptureError::kDeviceCaptureLinuxFailedToCreateVideoCaptureDelegate:
      return "VideoCaptureError::kDeviceCaptureLinuxFailedToCreateVideoCaptureDelegate";
    case VideoCaptureError::kErrorFakeDeviceIntentionallyEmittingErrorEvent:
      return "VideoCaptureError::kErrorFakeDeviceIntentionallyEmittingErrorEvent";
    case VideoCaptureError::kDeviceClientTooManyFramesDroppedY16:
      return "VideoCaptureError::kDeviceClientTooManyFramesDroppedY16";
    case VideoCaptureError::kDeviceMediaToMojoAdapterEncounteredUnsupportedBufferType:
      return "VideoCaptureError::kDeviceMediaToMojoAdapterEncounteredUnsupportedBufferType";
    case VideoCaptureError::kVideoCaptureManagerProcessDeviceStartQueueDeviceInfoNotFound:
      return "VideoCaptureError::kVideoCaptureManagerProcessDeviceStartQueueDeviceInfoNotFound";
    case VideoCaptureError::kInProcessDeviceLauncherFailedToCreateDeviceInstance:
      return "VideoCaptureError::kInProcessDeviceLauncherFailedToCreateDeviceInstance";
    case VideoCaptureError::kServiceDeviceLauncherLostConnectionToDeviceFactoryDuringDeviceStart:
      return "VideoCaptureError::kServiceDeviceLauncherLostConnectionToDeviceFactoryDuringDeviceStart";
    case VideoCaptureError::kServiceDeviceLauncherServiceRespondedWithDeviceNotFound:
      return "VideoCaptureError::kServiceDeviceLauncherServiceRespondedWithDeviceNotFound";
    case VideoCaptureError::kServiceDeviceLauncherConnectionLostWhileWaitingForCallback:
      return "VideoCaptureError::kServiceDeviceLauncherConnectionLostWhileWaitingForCallback";
    case VideoCaptureError::kIntentionalErrorRaisedByUnitTest:
      return "VideoCaptureError::kIntentionalErrorRaisedByUnitTest";
    case VideoCaptureError::kCrosHalV3FailedToStartDeviceThread:
      return "VideoCaptureError::kCrosHalV3FailedToStartDeviceThread";
    case VideoCaptureError::kCrosHalV3DeviceDelegateMojoConnectionError:
      return "VideoCaptureError::kCrosHalV3DeviceDelegateMojoConnectionError";
    case VideoCaptureError::kCrosHalV3DeviceDelegateFailedToGetCameraInfo:
      return "VideoCaptureError::kCrosHalV3DeviceDelegateFailedToGetCameraInfo";
    case VideoCaptureError::kCrosHalV3DeviceDelegateMissingSensorOrientationInfo:
      return "VideoCaptureError::kCrosHalV3DeviceDelegateMissingSensorOrientationInfo";
    case VideoCaptureError::kCrosHalV3DeviceDelegateFailedToOpenCameraDevice:
      return "VideoCaptureError::kCrosHalV3DeviceDelegateFailedToOpenCameraDevice";
    case VideoCaptureError::kCrosHalV3DeviceDelegateFailedToInitializeCameraDevice:
      return "VideoCaptureError::kCrosHalV3DeviceDelegateFailedToInitializeCameraDevice";
    case VideoCaptureError::kCrosHalV3DeviceDelegateFailedToConfigureStreams:
      return "VideoCaptureError::kCrosHalV3DeviceDelegateFailedToConfigureStreams";
    case VideoCaptureError::kCrosHalV3DeviceDelegateWrongNumberOfStreamsConfigured:
      return "VideoCaptureError::kCrosHalV3DeviceDelegateWrongNumberOfStreamsConfigured";
    case VideoCaptureError::kCrosHalV3DeviceDelegateFailedToGetDefaultRequestSettings:
      return "VideoCaptureError::kCrosHalV3DeviceDelegateFailedToGetDefaultRequestSettings";
    case VideoCaptureError::kCrosHalV3BufferManagerHalRequestedTooManyBuffers:
      return "VideoCaptureError::kCrosHalV3BufferManagerHalRequestedTooManyBuffers";
    case VideoCaptureError::kCrosHalV3BufferManagerFailedToCreateGpuMemoryBuffer:
      return "VideoCaptureError::kCrosHalV3BufferManagerFailedToCreateGpuMemoryBuffer";
    case VideoCaptureError::kCrosHalV3BufferManagerFailedToMapGpuMemoryBuffer:
      return "VideoCaptureError::kCrosHalV3BufferManagerFailedToMapGpuMemoryBuffer";
    case VideoCaptureError::kCrosHalV3BufferManagerUnsupportedVideoPixelFormat:
      return "VideoCaptureError::kCrosHalV3BufferManagerUnsupportedVideoPixelFormat";
    case VideoCaptureError::kCrosHalV3BufferManagerFailedToDupFd:
      return "VideoCaptureError::kCrosHalV3BufferManagerFailedToDupFd";
    case VideoCaptureError::kCrosHalV3BufferManagerFailedToWrapGpuMemoryHandle:
      return "VideoCaptureError::kCrosHalV3BufferManagerFailedToWrapGpuMemoryHandle";
    case VideoCaptureError::kCrosHalV3BufferManagerFailedToRegisterBuffer:
      return "VideoCaptureError::kCrosHalV3BufferManagerFailedToRegisterBuffer";
    case VideoCaptureError::kCrosHalV3BufferManagerProcessCaptureRequestFailed:
      return "VideoCaptureError::kCrosHalV3BufferManagerProcessCaptureRequestFailed";
    case VideoCaptureError::kCrosHalV3BufferManagerInvalidPendingResultId:
      return "VideoCaptureError::kCrosHalV3BufferManagerInvalidPendingResultId";
    case VideoCaptureError::kCrosHalV3BufferManagerReceivedDuplicatedPartialMetadata:
      return "VideoCaptureError::kCrosHalV3BufferManagerReceivedDuplicatedPartialMetadata";
    case VideoCaptureError::kCrosHalV3BufferManagerIncorrectNumberOfOutputBuffersReceived:
      return "VideoCaptureError::kCrosHalV3BufferManagerIncorrectNumberOfOutputBuffersReceived";
    case VideoCaptureError::kCrosHalV3BufferManagerInvalidTypeOfOutputBuffersReceived:
      return "VideoCaptureError::kCrosHalV3BufferManagerInvalidTypeOfOutputBuffersReceived";
    case VideoCaptureError::kCrosHalV3BufferManagerReceivedMultipleResultBuffersForFrame:
      return "VideoCaptureError::kCrosHalV3BufferManagerReceivedMultipleResultBuffersForFrame";
    case VideoCaptureError::kCrosHalV3BufferManagerUnknownStreamInCamera3NotifyMsg:
      return "VideoCaptureError::kCrosHalV3BufferManagerUnknownStreamInCamera3NotifyMsg";
    case VideoCaptureError::kCrosHalV3BufferManagerReceivedInvalidShutterTime:
      return "VideoCaptureError::kCrosHalV3BufferManagerReceivedInvalidShutterTime";
    case VideoCaptureError::kCrosHalV3BufferManagerFatalDeviceError:
      return "VideoCaptureError::kCrosHalV3BufferManagerFatalDeviceError";
    case VideoCaptureError::kCrosHalV3BufferManagerReceivedFrameIsOutOfOrder:
      return "VideoCaptureError::kCrosHalV3BufferManagerReceivedFrameIsOutOfOrder";
    case VideoCaptureError::kCrosHalV3BufferManagerFailedToUnwrapReleaseFenceFd:
      return "VideoCaptureError::kCrosHalV3BufferManagerFailedToUnwrapReleaseFenceFd";
    case VideoCaptureError::kCrosHalV3BufferManagerSyncWaitOnReleaseFenceTimedOut:
      return "VideoCaptureError::kCrosHalV3BufferManagerSyncWaitOnReleaseFenceTimedOut";
    case VideoCaptureError::kCrosHalV3BufferManagerInvalidJpegBlob:
      return "VideoCaptureError::kCrosHalV3BufferManagerInvalidJpegBlob";
    case VideoCaptureError::kAndroidFailedToAllocate:
      return "VideoCaptureError::kAndroidFailedToAllocate";
    case VideoCaptureError::kAndroidFailedToStartCapture:
      return "VideoCaptureError::kAndroidFailedToStartCapture";
    case VideoCaptureError::kAndroidFailedToStopCapture:
      return "VideoCaptureError::kAndroidFailedToStopCapture";
    case VideoCaptureError::kAndroidApi1CameraErrorCallbackReceived:
      return "VideoCaptureError::kAndroidApi1CameraErrorCallbackReceived";
    case VideoCaptureError::kAndroidApi2CameraDeviceErrorReceived:
      return "VideoCaptureError::kAndroidApi2CameraDeviceErrorReceived";
    case VideoCaptureError::kAndroidApi2CaptureSessionConfigureFailed:
      return "VideoCaptureError::kAndroidApi2CaptureSessionConfigureFailed";
    case VideoCaptureError::kAndroidApi2ImageReaderUnexpectedImageFormat:
      return "VideoCaptureError::kAndroidApi2ImageReaderUnexpectedImageFormat";
    case VideoCaptureError::kAndroidApi2ImageReaderSizeDidNotMatchImageSize:
      return "VideoCaptureError::kAndroidApi2ImageReaderSizeDidNotMatchImageSize";
    case VideoCaptureError::kAndroidApi2ErrorRestartingPreview:
      return "VideoCaptureError::kAndroidApi2ErrorRestartingPreview";
    case VideoCaptureError::kAndroidScreenCaptureUnsupportedFormat:
      return "VideoCaptureError::kAndroidScreenCaptureUnsupportedFormat";
    case VideoCaptureError::kAndroidScreenCaptureFailedToStartCaptureMachine:
      return "VideoCaptureError::kAndroidScreenCaptureFailedToStartCaptureMachine";
    case VideoCaptureError::kAndroidScreenCaptureTheUserDeniedScreenCapture:
      return "VideoCaptureError::kAndroidScreenCaptureTheUserDeniedScreenCapture";
    case VideoCaptureError::kAndroidScreenCaptureFailedToStartScreenCapture:
      return "VideoCaptureError::kAndroidScreenCaptureFailedToStartScreenCapture";
    case VideoCaptureError::kWinDirectShowCantGetCaptureFormatSettings:
      return "VideoCaptureError::kWinDirectShowCantGetCaptureFormatSettings";
    case VideoCaptureError::kWinDirectShowFailedToGetNumberOfCapabilities:
      return "VideoCaptureError::kWinDirectShowFailedToGetNumberOfCapabilities";
    case VideoCaptureError::kWinDirectShowFailedToGetCaptureDeviceCapabilities:
      return "VideoCaptureError::kWinDirectShowFailedToGetCaptureDeviceCapabilities";
    case VideoCaptureError::kWinDirectShowFailedToSetCaptureDeviceOutputFormat:
      return "VideoCaptureError::kWinDirectShowFailedToSetCaptureDeviceOutputFormat";
    case VideoCaptureError::kWinDirectShowFailedToConnectTheCaptureGraph:
      return "VideoCaptureError::kWinDirectShowFailedToConnectTheCaptureGraph";
    case VideoCaptureError::kWinDirectShowFailedToPauseTheCaptureDevice:
      return "VideoCaptureError::kWinDirectShowFailedToPauseTheCaptureDevice";
    case VideoCaptureError::kWinDirectShowFailedToStartTheCaptureDevice:
      return "VideoCaptureError::kWinDirectShowFailedToStartTheCaptureDevice";
    case VideoCaptureError::kWinDirectShowFailedToStopTheCaptureGraph:
      return "VideoCaptureError::kWinDirectShowFailedToStopTheCaptureGraph";
    case VideoCaptureError::kWinMediaFoundationEngineIsNull:
      return "VideoCaptureError::kWinMediaFoundationEngineIsNull";
    case VideoCaptureError::kWinMediaFoundationEngineGetSourceFailed:
      return "VideoCaptureError::kWinMediaFoundationEngineGetSourceFailed";
    case VideoCaptureError::kWinMediaFoundationFillPhotoCapabilitiesFailed:
      return "VideoCaptureError::kWinMediaFoundationFillPhotoCapabilitiesFailed";
    case VideoCaptureError::kWinMediaFoundationFillVideoCapabilitiesFailed:
      return "VideoCaptureError::kWinMediaFoundationFillVideoCapabilitiesFailed";
    case VideoCaptureError::kWinMediaFoundationNoVideoCapabilityFound:
      return "VideoCaptureError::kWinMediaFoundationNoVideoCapabilityFound";
    case VideoCaptureError::kWinMediaFoundationGetAvailableDeviceMediaTypeFailed:
      return "VideoCaptureError::kWinMediaFoundationGetAvailableDeviceMediaTypeFailed";
    case VideoCaptureError::kWinMediaFoundationSetCurrentDeviceMediaTypeFailed:
      return "VideoCaptureError::kWinMediaFoundationSetCurrentDeviceMediaTypeFailed";
    case VideoCaptureError::kWinMediaFoundationEngineGetSinkFailed:
      return "VideoCaptureError::kWinMediaFoundationEngineGetSinkFailed";
    case VideoCaptureError::kWinMediaFoundationSinkQueryCapturePreviewInterfaceFailed:
      return "VideoCaptureError::kWinMediaFoundationSinkQueryCapturePreviewInterfaceFailed";
    case VideoCaptureError::kWinMediaFoundationSinkRemoveAllStreamsFailed:
      return "VideoCaptureError::kWinMediaFoundationSinkRemoveAllStreamsFailed";
    case VideoCaptureError::kWinMediaFoundationCreateSinkVideoMediaTypeFailed:
      return "VideoCaptureError::kWinMediaFoundationCreateSinkVideoMediaTypeFailed";
    case VideoCaptureError::kWinMediaFoundationConvertToVideoSinkMediaTypeFailed:
      return "VideoCaptureError::kWinMediaFoundationConvertToVideoSinkMediaTypeFailed";
    case VideoCaptureError::kWinMediaFoundationSinkAddStreamFailed:
      return "VideoCaptureError::kWinMediaFoundationSinkAddStreamFailed";
    case VideoCaptureError::kWinMediaFoundationSinkSetSampleCallbackFailed:
      return "VideoCaptureError::kWinMediaFoundationSinkSetSampleCallbackFailed";
    case VideoCaptureError::kWinMediaFoundationEngineStartPreviewFailed:
      return "VideoCaptureError::kWinMediaFoundationEngineStartPreviewFailed";
    case VideoCaptureError::kWinMediaFoundationGetMediaEventStatusFailed:
      return "VideoCaptureError::kWinMediaFoundationGetMediaEventStatusFailed";
    case VideoCaptureError::kMacSetCaptureDeviceFailed:
      return "VideoCaptureError::kMacSetCaptureDeviceFailed";
    case VideoCaptureError::kMacCouldNotStartCaptureDevice:
      return "VideoCaptureError::kMacCouldNotStartCaptureDevice";
    case VideoCaptureError::kMacReceivedFrameWithUnexpectedResolution:
      return "VideoCaptureError::kMacReceivedFrameWithUnexpectedResolution";
    case VideoCaptureError::kMacUpdateCaptureResolutionFailed:
      return "VideoCaptureError::kMacUpdateCaptureResolutionFailed";
    case VideoCaptureError::kMacDeckLinkDeviceIdNotFoundInTheSystem:
      return "VideoCaptureError::kMacDeckLinkDeviceIdNotFoundInTheSystem";
    case VideoCaptureError::kMacDeckLinkErrorQueryingInputInterface:
      return "VideoCaptureError::kMacDeckLinkErrorQueryingInputInterface";
    case VideoCaptureError::kMacDeckLinkErrorCreatingDisplayModeIterator:
      return "VideoCaptureError::kMacDeckLinkErrorCreatingDisplayModeIterator";
    case VideoCaptureError::kMacDeckLinkCouldNotFindADisplayMode:
      return "VideoCaptureError::kMacDeckLinkCouldNotFindADisplayMode";
    case VideoCaptureError::kMacDeckLinkCouldNotSelectTheVideoFormatWeLike:
      return "VideoCaptureError::kMacDeckLinkCouldNotSelectTheVideoFormatWeLike";
    case VideoCaptureError::kMacDeckLinkCouldNotStartCapturing:
      return "VideoCaptureError::kMacDeckLinkCouldNotStartCapturing";
    case VideoCaptureError::kMacDeckLinkUnsupportedPixelFormat:
      return "VideoCaptureError::kMacDeckLinkUnsupportedPixelFormat";
    case VideoCaptureError::kMacAvFoundationReceivedAVCaptureSessionRuntimeErrorNotification:
      return "VideoCaptureError::kMacAvFoundationReceivedAVCaptureSessionRuntimeErrorNotification";
    case VideoCaptureError::kAndroidApi2ErrorConfiguringCamera:
      return "VideoCaptureError::kAndroidApi2ErrorConfiguringCamera";
    case VideoCaptureError::kCrosHalV3DeviceDelegateFailedToFlush:
      return "VideoCaptureError::kCrosHalV3DeviceDelegateFailedToFlush";
    case VideoCaptureError::kFuchsiaCameraDeviceDisconnected:
      return "VideoCaptureError::kFuchsiaCameraDeviceDisconnected";
    case VideoCaptureError::kFuchsiaCameraStreamDisconnected:
      return "VideoCaptureError::kFuchsiaCameraStreamDisconnected";
    case VideoCaptureError::kFuchsiaSysmemDidNotSetImageFormat:
      return "VideoCaptureError::kFuchsiaSysmemDidNotSetImageFormat";
    case VideoCaptureError::kFuchsiaSysmemInvalidBufferIndex:
      return "VideoCaptureError::kFuchsiaSysmemInvalidBufferIndex";
    case VideoCaptureError::kFuchsiaSysmemInvalidBufferSize:
      return "VideoCaptureError::kFuchsiaSysmemInvalidBufferSize";
    case VideoCaptureError::kFuchsiaUnsupportedPixelFormat:
      return "VideoCaptureError::kFuchsiaUnsupportedPixelFormat";
    case VideoCaptureError::kFuchsiaFailedToMapSysmemBuffer:
      return "VideoCaptureError::kFuchsiaFailedToMapSysmemBuffer";
    case VideoCaptureError::kCrosHalV3DeviceContextDuplicatedClient:
      return "VideoCaptureError::kCrosHalV3DeviceContextDuplicatedClient";
    case VideoCaptureError::kDesktopCaptureDeviceMacFailedStreamCreate:
      return "VideoCaptureError::kDesktopCaptureDeviceMacFailedStreamCreate";
    case VideoCaptureError::kDesktopCaptureDeviceMacFailedStreamStart:
      return "VideoCaptureError::kDesktopCaptureDeviceMacFailedStreamStart";
    default:
      return base::StringPrintf("Unknown VideoCaptureError value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, VideoCaptureError value) {
  return os << VideoCaptureErrorToString(value);
}

std::string VideoCaptureFrameDropReasonToString(VideoCaptureFrameDropReason value) {
  switch(value) {
    case VideoCaptureFrameDropReason::kNone:
      return "VideoCaptureFrameDropReason::kNone";
    case VideoCaptureFrameDropReason::kDeviceClientFrameHasInvalidFormat:
      return "VideoCaptureFrameDropReason::kDeviceClientFrameHasInvalidFormat";
    case VideoCaptureFrameDropReason::kDeviceClientLibyuvConvertToI420Failed:
      return "VideoCaptureFrameDropReason::kDeviceClientLibyuvConvertToI420Failed";
    case VideoCaptureFrameDropReason::kV4L2BufferErrorFlagWasSet:
      return "VideoCaptureFrameDropReason::kV4L2BufferErrorFlagWasSet";
    case VideoCaptureFrameDropReason::kV4L2InvalidNumberOfBytesInBuffer:
      return "VideoCaptureFrameDropReason::kV4L2InvalidNumberOfBytesInBuffer";
    case VideoCaptureFrameDropReason::kAndroidThrottling:
      return "VideoCaptureFrameDropReason::kAndroidThrottling";
    case VideoCaptureFrameDropReason::kAndroidGetByteArrayElementsFailed:
      return "VideoCaptureFrameDropReason::kAndroidGetByteArrayElementsFailed";
    case VideoCaptureFrameDropReason::kAndroidApi1UnexpectedDataLength:
      return "VideoCaptureFrameDropReason::kAndroidApi1UnexpectedDataLength";
    case VideoCaptureFrameDropReason::kAndroidApi2AcquiredImageIsNull:
      return "VideoCaptureFrameDropReason::kAndroidApi2AcquiredImageIsNull";
    case VideoCaptureFrameDropReason::kWinDirectShowUnexpectedSampleLength:
      return "VideoCaptureFrameDropReason::kWinDirectShowUnexpectedSampleLength";
    case VideoCaptureFrameDropReason::kWinDirectShowFailedToGetMemoryPointerFromMediaSample:
      return "VideoCaptureFrameDropReason::kWinDirectShowFailedToGetMemoryPointerFromMediaSample";
    case VideoCaptureFrameDropReason::kWinMediaFoundationReceivedSampleIsNull:
      return "VideoCaptureFrameDropReason::kWinMediaFoundationReceivedSampleIsNull";
    case VideoCaptureFrameDropReason::kWinMediaFoundationLockingBufferDelieveredNullptr:
      return "VideoCaptureFrameDropReason::kWinMediaFoundationLockingBufferDelieveredNullptr";
    case VideoCaptureFrameDropReason::kWinMediaFoundationGetBufferByIndexReturnedNull:
      return "VideoCaptureFrameDropReason::kWinMediaFoundationGetBufferByIndexReturnedNull";
    case VideoCaptureFrameDropReason::kBufferPoolMaxBufferCountExceeded:
      return "VideoCaptureFrameDropReason::kBufferPoolMaxBufferCountExceeded";
    case VideoCaptureFrameDropReason::kBufferPoolBufferAllocationFailed:
      return "VideoCaptureFrameDropReason::kBufferPoolBufferAllocationFailed";
    case VideoCaptureFrameDropReason::kVideoCaptureImplNotInStartedState:
      return "VideoCaptureFrameDropReason::kVideoCaptureImplNotInStartedState";
    case VideoCaptureFrameDropReason::kVideoCaptureImplFailedToWrapDataAsMediaVideoFrame:
      return "VideoCaptureFrameDropReason::kVideoCaptureImplFailedToWrapDataAsMediaVideoFrame";
    case VideoCaptureFrameDropReason::kVideoTrackAdapterHasNoResolutionAdapters:
      return "VideoCaptureFrameDropReason::kVideoTrackAdapterHasNoResolutionAdapters";
    case VideoCaptureFrameDropReason::kResolutionAdapterFrameIsNotValid:
      return "VideoCaptureFrameDropReason::kResolutionAdapterFrameIsNotValid";
    case VideoCaptureFrameDropReason::kResolutionAdapterWrappingFrameForCroppingFailed:
      return "VideoCaptureFrameDropReason::kResolutionAdapterWrappingFrameForCroppingFailed";
    case VideoCaptureFrameDropReason::kResolutionAdapterTimestampTooCloseToPrevious:
      return "VideoCaptureFrameDropReason::kResolutionAdapterTimestampTooCloseToPrevious";
    case VideoCaptureFrameDropReason::kResolutionAdapterFrameRateIsHigherThanRequested:
      return "VideoCaptureFrameDropReason::kResolutionAdapterFrameRateIsHigherThanRequested";
    case VideoCaptureFrameDropReason::kResolutionAdapterHasNoCallbacks:
      return "VideoCaptureFrameDropReason::kResolutionAdapterHasNoCallbacks";
    case VideoCaptureFrameDropReason::kVideoTrackFrameDelivererNotEnabledReplacingWithBlackFrame:
      return "VideoCaptureFrameDropReason::kVideoTrackFrameDelivererNotEnabledReplacingWithBlackFrame";
    case VideoCaptureFrameDropReason::kRendererSinkFrameDelivererIsNotStarted:
      return "VideoCaptureFrameDropReason::kRendererSinkFrameDelivererIsNotStarted";
    default:
      return base::StringPrintf("Unknown VideoCaptureFrameDropReason value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, VideoCaptureFrameDropReason value) {
  return os << VideoCaptureFrameDropReasonToString(value);
}

namespace internal {
// static
bool VideoBufferHandle_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const VideoBufferHandle_Data* object = static_cast<const VideoBufferHandle_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case VideoBufferHandle_Tag::SHARED_BUFFER_HANDLE: {

      if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
              object->data.f_shared_buffer_handle, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateHandleOrInterface(object->data.f_shared_buffer_handle,
                                                     validation_context)) {
        return false;
      }
      return true;
    }
    case VideoBufferHandle_Tag::READ_ONLY_SHMEM_REGION: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_read_only_shmem_region, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_read_only_shmem_region, validation_context))
        return false;
      return true;
    }
    case VideoBufferHandle_Tag::SHARED_MEMORY_VIA_RAW_FILE_DESCRIPTOR: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_shared_memory_via_raw_file_descriptor, 3, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_shared_memory_via_raw_file_descriptor, validation_context))
        return false;
      return true;
    }
    case VideoBufferHandle_Tag::MAILBOX_HANDLES: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_mailbox_handles, 4, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_mailbox_handles, validation_context))
        return false;
      return true;
    }
    case VideoBufferHandle_Tag::GPU_MEMORY_BUFFER_HANDLE: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_gpu_memory_buffer_handle, 5, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_gpu_memory_buffer_handle, validation_context))
        return false;
      return true;
    }
    default: {
      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in VideoBufferHandle");
      return false;
    }
  }
}


// static
bool VideoCaptureControlSupport_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VideoCaptureControlSupport_Data* object = static_cast<const VideoCaptureControlSupport_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

VideoCaptureControlSupport_Data::VideoCaptureControlSupport_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoCaptureFormat_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VideoCaptureFormat_Data* object = static_cast<const VideoCaptureFormat_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_size, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame_size, validation_context))
    return false;


  if (!::media::mojom::internal::VideoCapturePixelFormat_Data
        ::Validate(object->pixel_format, validation_context))
    return false;

  return true;
}

VideoCaptureFormat_Data::VideoCaptureFormat_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoCaptureParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VideoCaptureParams_Data* object = static_cast<const VideoCaptureParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->requested_format, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->requested_format, validation_context))
    return false;


  if (!::media::mojom::internal::VideoCaptureBufferType_Data
        ::Validate(object->buffer_type, validation_context))
    return false;


  if (!::media::mojom::internal::ResolutionChangePolicy_Data
        ::Validate(object->resolution_change_policy, validation_context))
    return false;


  if (!::media::mojom::internal::PowerLineFrequency_Data
        ::Validate(object->power_line_frequency, validation_context))
    return false;

  return true;
}

VideoCaptureParams_Data::VideoCaptureParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoFrameFeedback_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VideoFrameFeedback_Data* object = static_cast<const VideoFrameFeedback_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

VideoFrameFeedback_Data::VideoFrameFeedback_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PlaneStrides_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PlaneStrides_Data* object = static_cast<const PlaneStrides_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->stride_by_plane, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams stride_by_plane_validate_params(
      4, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->stride_by_plane, validation_context,
                                         &stride_by_plane_validate_params)) {
    return false;
  }

  return true;
}

PlaneStrides_Data::PlaneStrides_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoFrameInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VideoFrameInfo_Data* object = static_cast<const VideoFrameInfo_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->timestamp, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->timestamp, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->metadata, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->metadata, validation_context))
    return false;


  if (!::media::mojom::internal::VideoCapturePixelFormat_Data
        ::Validate(object->pixel_format, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->coded_size, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->coded_size, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->visible_rect, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->visible_rect, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->color_space, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->strides, validation_context))
    return false;

  return true;
}

VideoFrameInfo_Data::VideoFrameInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ReadyBuffer_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ReadyBuffer_Data* object = static_cast<const ReadyBuffer_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->info, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->info, validation_context))
    return false;

  return true;
}

ReadyBuffer_Data::ReadyBuffer_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoCaptureDeviceDescriptor_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VideoCaptureDeviceDescriptor_Data* object = static_cast<const VideoCaptureDeviceDescriptor_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->display_name, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams display_name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->display_name, validation_context,
                                         &display_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->device_id, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams device_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->device_id, validation_context,
                                         &device_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->model_id, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams model_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->model_id, validation_context,
                                         &model_id_validate_params)) {
    return false;
  }


  if (!::media::mojom::internal::VideoFacingMode_Data
        ::Validate(object->facing_mode, validation_context))
    return false;


  if (!::media::mojom::internal::VideoCaptureApi_Data
        ::Validate(object->capture_api, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->control_support, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->control_support, validation_context))
    return false;


  if (!::media::mojom::internal::VideoCaptureTransportType_Data
        ::Validate(object->transport_type, validation_context))
    return false;

  return true;
}

VideoCaptureDeviceDescriptor_Data::VideoCaptureDeviceDescriptor_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoCaptureDeviceInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VideoCaptureDeviceInfo_Data* object = static_cast<const VideoCaptureDeviceInfo_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->descriptor, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->descriptor, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->supported_formats, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams supported_formats_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->supported_formats, validation_context,
                                         &supported_formats_validate_params)) {
    return false;
  }

  return true;
}

VideoCaptureDeviceInfo_Data::VideoCaptureDeviceInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MailboxBufferHandleSet_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MailboxBufferHandleSet_Data* object = static_cast<const MailboxBufferHandleSet_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->mailbox_holder, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams mailbox_holder_validate_params(
      4, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->mailbox_holder, validation_context,
                                         &mailbox_holder_validate_params)) {
    return false;
  }

  return true;
}

MailboxBufferHandleSet_Data::MailboxBufferHandleSet_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SharedMemoryViaRawFileDescriptor_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SharedMemoryViaRawFileDescriptor_Data* object = static_cast<const SharedMemoryViaRawFileDescriptor_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->file_descriptor_handle, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->file_descriptor_handle,
                                                 validation_context)) {
    return false;
  }

  return true;
}

SharedMemoryViaRawFileDescriptor_Data::SharedMemoryViaRawFileDescriptor_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace media

namespace perfetto {

// static
void TraceFormatTraits<::media::mojom::VideoCapturePixelFormat>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::media::mojom::VideoCapturePixelFormat value) {
  return std::move(context).WriteString(::media::mojom::VideoCapturePixelFormatToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media::mojom::ResolutionChangePolicy>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::media::mojom::ResolutionChangePolicy value) {
  return std::move(context).WriteString(::media::mojom::ResolutionChangePolicyToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media::mojom::PowerLineFrequency>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::media::mojom::PowerLineFrequency value) {
  return std::move(context).WriteString(::media::mojom::PowerLineFrequencyToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media::mojom::VideoFacingMode>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::media::mojom::VideoFacingMode value) {
  return std::move(context).WriteString(::media::mojom::VideoFacingModeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media::mojom::VideoCaptureApi>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::media::mojom::VideoCaptureApi value) {
  return std::move(context).WriteString(::media::mojom::VideoCaptureApiToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media::mojom::VideoCaptureTransportType>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::media::mojom::VideoCaptureTransportType value) {
  return std::move(context).WriteString(::media::mojom::VideoCaptureTransportTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media::mojom::VideoCaptureBufferType>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::media::mojom::VideoCaptureBufferType value) {
  return std::move(context).WriteString(::media::mojom::VideoCaptureBufferTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media::mojom::VideoCaptureError>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::media::mojom::VideoCaptureError value) {
  return std::move(context).WriteString(::media::mojom::VideoCaptureErrorToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media::mojom::VideoCaptureFrameDropReason>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::media::mojom::VideoCaptureFrameDropReason value) {
  return std::move(context).WriteString(::media::mojom::VideoCaptureFrameDropReasonToString(value));
}

} // namespace perfetto
