// media/learning/mojo/public/mojom/learning_task_controller.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/learning/mojo/public/mojom/learning_task_controller.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "media/learning/mojo/public/mojom/learning_task_controller.mojom-params-data.h"
#include "media/learning/mojo/public/mojom/learning_task_controller.mojom-shared-message-ids.h"

#include "media/learning/mojo/public/mojom/learning_task_controller.mojom-import-headers.h"


#ifndef MEDIA_LEARNING_MOJO_PUBLIC_MOJOM_LEARNING_TASK_CONTROLLER_MOJOM_JUMBO_H_
#define MEDIA_LEARNING_MOJO_PUBLIC_MOJOM_LEARNING_TASK_CONTROLLER_MOJOM_JUMBO_H_
#endif
namespace media {
namespace learning {
namespace mojom {
const char LearningTaskController::Name_[] = "media.learning.mojom.LearningTaskController";

class LearningTaskController_PredictDistribution_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LearningTaskController_PredictDistribution_ForwardToCallback(
      LearningTaskController::PredictDistributionCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  LearningTaskController::PredictDistributionCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(LearningTaskController_PredictDistribution_ForwardToCallback);
};

LearningTaskControllerProxy::LearningTaskControllerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void LearningTaskControllerProxy::BeginObservation(
    const ::base::UnguessableToken& in_id, const std::vector<::media::learning::FeatureValue>& in_features, const base::Optional<::media::learning::TargetValue>& in_default_target) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::learning::mojom::LearningTaskController::BeginObservation", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id, 
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("features"), in_features, 
                        "<value of type const std::vector<::media::learning::FeatureValue>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("default_target"), in_default_target, 
                        "<value of type const base::Optional<::media::learning::TargetValue>&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLearningTaskController_BeginObservation_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::learning::mojom::internal::LearningTaskController_BeginObservation_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_id, id_fragment);
  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in LearningTaskController.BeginObservation request");
  mojo::internal::MessageFragment<
      typename decltype(params->features)::BaseType>
      features_fragment(params.message());
  const mojo::internal::ContainerValidateParams features_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::media::learning::mojom::FeatureValueDataView>>(
      in_features, features_fragment, &features_validate_params);
  params->features.Set(
      features_fragment.is_null() ? nullptr : features_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->features.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null features in LearningTaskController.BeginObservation request");
  mojo::internal::MessageFragment<
      typename decltype(params->default_target)::BaseType> default_target_fragment(
          params.message());
  mojo::internal::Serialize<::media::learning::mojom::TargetValueDataView>(
      in_default_target, default_target_fragment);
  params->default_target.Set(
      default_target_fragment.is_null() ? nullptr : default_target_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LearningTaskController::Name_);
  message.set_method_name("BeginObservation");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LearningTaskControllerProxy::CompleteObservation(
    const ::base::UnguessableToken& in_id, const ::media::learning::ObservationCompletion& in_completion) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::learning::mojom::LearningTaskController::CompleteObservation", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id, 
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("completion"), in_completion, 
                        "<value of type const ::media::learning::ObservationCompletion&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLearningTaskController_CompleteObservation_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::learning::mojom::internal::LearningTaskController_CompleteObservation_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_id, id_fragment);
  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in LearningTaskController.CompleteObservation request");
  mojo::internal::MessageFragment<
      typename decltype(params->completion)::BaseType> completion_fragment(
          params.message());
  mojo::internal::Serialize<::media::learning::mojom::ObservationCompletionDataView>(
      in_completion, completion_fragment);
  params->completion.Set(
      completion_fragment.is_null() ? nullptr : completion_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->completion.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null completion in LearningTaskController.CompleteObservation request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LearningTaskController::Name_);
  message.set_method_name("CompleteObservation");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LearningTaskControllerProxy::CancelObservation(
    const ::base::UnguessableToken& in_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::learning::mojom::LearningTaskController::CancelObservation", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id, 
                        "<value of type const ::base::UnguessableToken&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLearningTaskController_CancelObservation_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::learning::mojom::internal::LearningTaskController_CancelObservation_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_id, id_fragment);
  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in LearningTaskController.CancelObservation request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LearningTaskController::Name_);
  message.set_method_name("CancelObservation");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LearningTaskControllerProxy::UpdateDefaultTarget(
    const ::base::UnguessableToken& in_id, const base::Optional<::media::learning::TargetValue>& in_default_target) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::learning::mojom::LearningTaskController::UpdateDefaultTarget", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id, 
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("default_target"), in_default_target, 
                        "<value of type const base::Optional<::media::learning::TargetValue>&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLearningTaskController_UpdateDefaultTarget_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::learning::mojom::internal::LearningTaskController_UpdateDefaultTarget_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_id, id_fragment);
  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in LearningTaskController.UpdateDefaultTarget request");
  mojo::internal::MessageFragment<
      typename decltype(params->default_target)::BaseType> default_target_fragment(
          params.message());
  mojo::internal::Serialize<::media::learning::mojom::TargetValueDataView>(
      in_default_target, default_target_fragment);
  params->default_target.Set(
      default_target_fragment.is_null() ? nullptr : default_target_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LearningTaskController::Name_);
  message.set_method_name("UpdateDefaultTarget");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LearningTaskControllerProxy::PredictDistribution(
    const std::vector<::media::learning::FeatureValue>& in_features, PredictDistributionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::learning::mojom::LearningTaskController::PredictDistribution", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("features"), in_features, 
                        "<value of type const std::vector<::media::learning::FeatureValue>&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLearningTaskController_PredictDistribution_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::learning::mojom::internal::LearningTaskController_PredictDistribution_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->features)::BaseType>
      features_fragment(params.message());
  const mojo::internal::ContainerValidateParams features_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::media::learning::mojom::FeatureValueDataView>>(
      in_features, features_fragment, &features_validate_params);
  params->features.Set(
      features_fragment.is_null() ? nullptr : features_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->features.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null features in LearningTaskController.PredictDistribution request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LearningTaskController::Name_);
  message.set_method_name("PredictDistribution");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LearningTaskController_PredictDistribution_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class LearningTaskController_PredictDistribution_ProxyToResponder {
 public:
  static LearningTaskController::PredictDistributionCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<LearningTaskController_PredictDistribution_ProxyToResponder> proxy(
        new LearningTaskController_PredictDistribution_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&LearningTaskController_PredictDistribution_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LearningTaskController_PredictDistribution_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  LearningTaskController_PredictDistribution_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "LearningTaskController::PredictDistributionCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const base::Optional<::media::learning::TargetHistogram>& in_predicted);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(LearningTaskController_PredictDistribution_ProxyToResponder);
};

bool LearningTaskController_PredictDistribution_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "media::learning::mojom::LearningTaskController::PredictDistributionCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::LearningTaskController_PredictDistribution_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LearningTaskController_PredictDistribution_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  base::Optional<::media::learning::TargetHistogram> p_predicted{};
  LearningTaskController_PredictDistribution_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadPredicted(&p_predicted))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LearningTaskController::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_predicted));
  return true;
}

void LearningTaskController_PredictDistribution_ProxyToResponder::Run(
    const base::Optional<::media::learning::TargetHistogram>& in_predicted) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)media::learning::mojom::LearningTaskController::PredictDistributionCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("predicted"), in_predicted, 
                        "<value of type const base::Optional<::media::learning::TargetHistogram>&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLearningTaskController_PredictDistribution_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::learning::mojom::internal::LearningTaskController_PredictDistribution_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->predicted)::BaseType> predicted_fragment(
          params.message());
  mojo::internal::Serialize<::media::learning::mojom::TargetHistogramDataView>(
      in_predicted, predicted_fragment);
  params->predicted.Set(
      predicted_fragment.is_null() ? nullptr : predicted_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)media::learning::mojom::LearningTaskController::PredictDistributionCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LearningTaskController::Name_);
  message.set_method_name("PredictDistribution");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool LearningTaskControllerStubDispatch::Accept(
    LearningTaskController* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kLearningTaskController_BeginObservation_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::learning::mojom::LearningTaskController::BeginObservation",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::learning::mojom::LearningTaskController::BeginObservation");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LearningTaskController_BeginObservation_Params_Data* params =
          reinterpret_cast<internal::LearningTaskController_BeginObservation_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::UnguessableToken p_id{};
      std::vector<::media::learning::FeatureValue> p_features{};
      base::Optional<::media::learning::TargetValue> p_default_target{};
      LearningTaskController_BeginObservation_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (success && !input_data_view.ReadFeatures(&p_features))
        success = false;
      if (success && !input_data_view.ReadDefaultTarget(&p_default_target))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LearningTaskController::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BeginObservation(
std::move(p_id), 
std::move(p_features), 
std::move(p_default_target));
      return true;
    }
    case internal::kLearningTaskController_CompleteObservation_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::learning::mojom::LearningTaskController::CompleteObservation",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::learning::mojom::LearningTaskController::CompleteObservation");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LearningTaskController_CompleteObservation_Params_Data* params =
          reinterpret_cast<internal::LearningTaskController_CompleteObservation_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::UnguessableToken p_id{};
      ::media::learning::ObservationCompletion p_completion{};
      LearningTaskController_CompleteObservation_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (success && !input_data_view.ReadCompletion(&p_completion))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LearningTaskController::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CompleteObservation(
std::move(p_id), 
std::move(p_completion));
      return true;
    }
    case internal::kLearningTaskController_CancelObservation_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::learning::mojom::LearningTaskController::CancelObservation",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::learning::mojom::LearningTaskController::CancelObservation");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LearningTaskController_CancelObservation_Params_Data* params =
          reinterpret_cast<internal::LearningTaskController_CancelObservation_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::UnguessableToken p_id{};
      LearningTaskController_CancelObservation_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LearningTaskController::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CancelObservation(
std::move(p_id));
      return true;
    }
    case internal::kLearningTaskController_UpdateDefaultTarget_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::learning::mojom::LearningTaskController::UpdateDefaultTarget",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::learning::mojom::LearningTaskController::UpdateDefaultTarget");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LearningTaskController_UpdateDefaultTarget_Params_Data* params =
          reinterpret_cast<internal::LearningTaskController_UpdateDefaultTarget_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::UnguessableToken p_id{};
      base::Optional<::media::learning::TargetValue> p_default_target{};
      LearningTaskController_UpdateDefaultTarget_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (success && !input_data_view.ReadDefaultTarget(&p_default_target))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LearningTaskController::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateDefaultTarget(
std::move(p_id), 
std::move(p_default_target));
      return true;
    }
    case internal::kLearningTaskController_PredictDistribution_Name: {
      break;
    }
  }
  return false;
}

// static
bool LearningTaskControllerStubDispatch::AcceptWithResponder(
    LearningTaskController* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kLearningTaskController_BeginObservation_Name: {
      break;
    }
    case internal::kLearningTaskController_CompleteObservation_Name: {
      break;
    }
    case internal::kLearningTaskController_CancelObservation_Name: {
      break;
    }
    case internal::kLearningTaskController_UpdateDefaultTarget_Name: {
      break;
    }
    case internal::kLearningTaskController_PredictDistribution_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::learning::mojom::LearningTaskController::PredictDistribution",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::learning::mojom::LearningTaskController::PredictDistribution");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::LearningTaskController_PredictDistribution_Params_Data* params =
          reinterpret_cast<
              internal::LearningTaskController_PredictDistribution_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::vector<::media::learning::FeatureValue> p_features{};
      LearningTaskController_PredictDistribution_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFeatures(&p_features))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LearningTaskController::Name_, 4, false);
        return false;
      }
      LearningTaskController::PredictDistributionCallback callback =
          LearningTaskController_PredictDistribution_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PredictDistribution(
std::move(p_features), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kLearningTaskControllerValidationInfo[] = {
    {internal::kLearningTaskController_BeginObservation_Name,
     {&internal::LearningTaskController_BeginObservation_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLearningTaskController_CompleteObservation_Name,
     {&internal::LearningTaskController_CompleteObservation_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLearningTaskController_CancelObservation_Name,
     {&internal::LearningTaskController_CancelObservation_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLearningTaskController_UpdateDefaultTarget_Name,
     {&internal::LearningTaskController_UpdateDefaultTarget_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLearningTaskController_PredictDistribution_Name,
     {&internal::LearningTaskController_PredictDistribution_Params_Data::Validate,
      &internal::LearningTaskController_PredictDistribution_ResponseParams_Data::Validate}},
};

bool LearningTaskControllerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::learning::mojom::LearningTaskController::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kLearningTaskControllerValidationInfo);
}

bool LearningTaskControllerResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::media::learning::mojom::LearningTaskController::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kLearningTaskControllerValidationInfo);

}
}  // namespace mojom
}  // namespace learning
}  // namespace media

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif