// media/mojo/mojom/audio_output_stream.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/mojo/mojom/audio_output_stream.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "media/mojo/mojom/audio_output_stream.mojom-params-data.h"
#include "media/mojo/mojom/audio_output_stream.mojom-shared-message-ids.h"

#include "media/mojo/mojom/audio_output_stream.mojom-import-headers.h"


#ifndef MEDIA_MOJO_MOJOM_AUDIO_OUTPUT_STREAM_MOJOM_JUMBO_H_
#define MEDIA_MOJO_MOJOM_AUDIO_OUTPUT_STREAM_MOJOM_JUMBO_H_
#endif
namespace media {
namespace mojom {
const char AudioOutputStream::Name_[] = "media.mojom.AudioOutputStream";

AudioOutputStreamProxy::AudioOutputStreamProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AudioOutputStreamProxy::Play(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "media::mojom::AudioOutputStream::Play");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kAudioOutputStream_Play_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioOutputStream_Play_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioOutputStream::Name_);
  message.set_method_name("Play");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void AudioOutputStreamProxy::Pause(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "media::mojom::AudioOutputStream::Pause");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kAudioOutputStream_Pause_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioOutputStream_Pause_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioOutputStream::Name_);
  message.set_method_name("Pause");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void AudioOutputStreamProxy::Flush(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "media::mojom::AudioOutputStream::Flush");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kAudioOutputStream_Flush_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioOutputStream_Flush_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioOutputStream::Name_);
  message.set_method_name("Flush");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void AudioOutputStreamProxy::SetVolume(
    double in_volume) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::AudioOutputStream::SetVolume", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("volume"), in_volume, 
                        "<value of type double>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kAudioOutputStream_SetVolume_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioOutputStream_SetVolume_Params_Data> params(
          message);
  params.Allocate();
  params->volume = in_volume;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioOutputStream::Name_);
  message.set_method_name("SetVolume");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool AudioOutputStreamStubDispatch::Accept(
    AudioOutputStream* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kAudioOutputStream_Play_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::AudioOutputStream::Play",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::AudioOutputStream::Play");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::AudioOutputStream_Play_Params_Data* params =
          reinterpret_cast<internal::AudioOutputStream_Play_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      AudioOutputStream_Play_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioOutputStream::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Play();
      return true;
    }
    case internal::kAudioOutputStream_Pause_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::AudioOutputStream::Pause",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::AudioOutputStream::Pause");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::AudioOutputStream_Pause_Params_Data* params =
          reinterpret_cast<internal::AudioOutputStream_Pause_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      AudioOutputStream_Pause_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioOutputStream::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Pause();
      return true;
    }
    case internal::kAudioOutputStream_Flush_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::AudioOutputStream::Flush",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::AudioOutputStream::Flush");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::AudioOutputStream_Flush_Params_Data* params =
          reinterpret_cast<internal::AudioOutputStream_Flush_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      AudioOutputStream_Flush_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioOutputStream::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Flush();
      return true;
    }
    case internal::kAudioOutputStream_SetVolume_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::AudioOutputStream::SetVolume",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::AudioOutputStream::SetVolume");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::AudioOutputStream_SetVolume_Params_Data* params =
          reinterpret_cast<internal::AudioOutputStream_SetVolume_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      double p_volume{};
      AudioOutputStream_SetVolume_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_volume = input_data_view.volume();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioOutputStream::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetVolume(
std::move(p_volume));
      return true;
    }
  }
  return false;
}

// static
bool AudioOutputStreamStubDispatch::AcceptWithResponder(
    AudioOutputStream* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kAudioOutputStream_Play_Name: {
      break;
    }
    case internal::kAudioOutputStream_Pause_Name: {
      break;
    }
    case internal::kAudioOutputStream_Flush_Name: {
      break;
    }
    case internal::kAudioOutputStream_SetVolume_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kAudioOutputStreamValidationInfo[] = {
    {internal::kAudioOutputStream_Play_Name,
     {&internal::AudioOutputStream_Play_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kAudioOutputStream_Pause_Name,
     {&internal::AudioOutputStream_Pause_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kAudioOutputStream_Flush_Name,
     {&internal::AudioOutputStream_Flush_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kAudioOutputStream_SetVolume_Name,
     {&internal::AudioOutputStream_SetVolume_Params_Data::Validate,
      nullptr /* no response */}},
};

bool AudioOutputStreamRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::AudioOutputStream::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kAudioOutputStreamValidationInfo);
}

const char AudioOutputStreamObserver::Name_[] = "media.mojom.AudioOutputStreamObserver";

AudioOutputStreamObserverProxy::AudioOutputStreamObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AudioOutputStreamObserverProxy::DidStartPlaying(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "media::mojom::AudioOutputStreamObserver::DidStartPlaying");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kAudioOutputStreamObserver_DidStartPlaying_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioOutputStreamObserver_DidStartPlaying_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioOutputStreamObserver::Name_);
  message.set_method_name("DidStartPlaying");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void AudioOutputStreamObserverProxy::DidStopPlaying(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "media::mojom::AudioOutputStreamObserver::DidStopPlaying");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kAudioOutputStreamObserver_DidStopPlaying_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioOutputStreamObserver_DidStopPlaying_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioOutputStreamObserver::Name_);
  message.set_method_name("DidStopPlaying");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void AudioOutputStreamObserverProxy::DidChangeAudibleState(
    bool in_is_audible) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::AudioOutputStreamObserver::DidChangeAudibleState", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_audible"), in_is_audible, 
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kAudioOutputStreamObserver_DidChangeAudibleState_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioOutputStreamObserver_DidChangeAudibleState_Params_Data> params(
          message);
  params.Allocate();
  params->is_audible = in_is_audible;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioOutputStreamObserver::Name_);
  message.set_method_name("DidChangeAudibleState");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool AudioOutputStreamObserverStubDispatch::Accept(
    AudioOutputStreamObserver* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kAudioOutputStreamObserver_DidStartPlaying_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::AudioOutputStreamObserver::DidStartPlaying",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::AudioOutputStreamObserver::DidStartPlaying");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::AudioOutputStreamObserver_DidStartPlaying_Params_Data* params =
          reinterpret_cast<internal::AudioOutputStreamObserver_DidStartPlaying_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      AudioOutputStreamObserver_DidStartPlaying_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioOutputStreamObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidStartPlaying();
      return true;
    }
    case internal::kAudioOutputStreamObserver_DidStopPlaying_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::AudioOutputStreamObserver::DidStopPlaying",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::AudioOutputStreamObserver::DidStopPlaying");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::AudioOutputStreamObserver_DidStopPlaying_Params_Data* params =
          reinterpret_cast<internal::AudioOutputStreamObserver_DidStopPlaying_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      AudioOutputStreamObserver_DidStopPlaying_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioOutputStreamObserver::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidStopPlaying();
      return true;
    }
    case internal::kAudioOutputStreamObserver_DidChangeAudibleState_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::AudioOutputStreamObserver::DidChangeAudibleState",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::AudioOutputStreamObserver::DidChangeAudibleState");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::AudioOutputStreamObserver_DidChangeAudibleState_Params_Data* params =
          reinterpret_cast<internal::AudioOutputStreamObserver_DidChangeAudibleState_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_is_audible{};
      AudioOutputStreamObserver_DidChangeAudibleState_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_is_audible = input_data_view.is_audible();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioOutputStreamObserver::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidChangeAudibleState(
std::move(p_is_audible));
      return true;
    }
  }
  return false;
}

// static
bool AudioOutputStreamObserverStubDispatch::AcceptWithResponder(
    AudioOutputStreamObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kAudioOutputStreamObserver_DidStartPlaying_Name: {
      break;
    }
    case internal::kAudioOutputStreamObserver_DidStopPlaying_Name: {
      break;
    }
    case internal::kAudioOutputStreamObserver_DidChangeAudibleState_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kAudioOutputStreamObserverValidationInfo[] = {
    {internal::kAudioOutputStreamObserver_DidStartPlaying_Name,
     {&internal::AudioOutputStreamObserver_DidStartPlaying_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kAudioOutputStreamObserver_DidStopPlaying_Name,
     {&internal::AudioOutputStreamObserver_DidStopPlaying_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kAudioOutputStreamObserver_DidChangeAudibleState_Name,
     {&internal::AudioOutputStreamObserver_DidChangeAudibleState_Params_Data::Validate,
      nullptr /* no response */}},
};

bool AudioOutputStreamObserverRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::AudioOutputStreamObserver::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kAudioOutputStreamObserverValidationInfo);
}

const char AudioOutputStreamProvider::Name_[] = "media.mojom.AudioOutputStreamProvider";

AudioOutputStreamProviderProxy::AudioOutputStreamProviderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AudioOutputStreamProviderProxy::Acquire(
    const ::media::AudioParameters& in_params, ::mojo::PendingRemote<AudioOutputStreamProviderClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::AudioOutputStreamProvider::Acquire", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params, 
                        "<value of type const ::media::AudioParameters&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client, 
                        "<value of type ::mojo::PendingRemote<AudioOutputStreamProviderClient>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kAudioOutputStreamProvider_Acquire_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioOutputStreamProvider_Acquire_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::AudioParametersDataView>(
      in_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in AudioOutputStreamProvider.Acquire request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media::mojom::AudioOutputStreamProviderClientInterfaceBase>>(
      in_client, &params->client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid client in AudioOutputStreamProvider.Acquire request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioOutputStreamProvider::Name_);
  message.set_method_name("Acquire");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool AudioOutputStreamProviderStubDispatch::Accept(
    AudioOutputStreamProvider* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kAudioOutputStreamProvider_Acquire_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::AudioOutputStreamProvider::Acquire",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::AudioOutputStreamProvider::Acquire");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::AudioOutputStreamProvider_Acquire_Params_Data* params =
          reinterpret_cast<internal::AudioOutputStreamProvider_Acquire_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::media::AudioParameters p_params{};
      ::mojo::PendingRemote<AudioOutputStreamProviderClient> p_client{};
      AudioOutputStreamProvider_Acquire_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioOutputStreamProvider::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Acquire(
std::move(p_params), 
std::move(p_client));
      return true;
    }
  }
  return false;
}

// static
bool AudioOutputStreamProviderStubDispatch::AcceptWithResponder(
    AudioOutputStreamProvider* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kAudioOutputStreamProvider_Acquire_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kAudioOutputStreamProviderValidationInfo[] = {
    {internal::kAudioOutputStreamProvider_Acquire_Name,
     {&internal::AudioOutputStreamProvider_Acquire_Params_Data::Validate,
      nullptr /* no response */}},
};

bool AudioOutputStreamProviderRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::AudioOutputStreamProvider::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kAudioOutputStreamProviderValidationInfo);
}

const char AudioOutputStreamProviderClient::Name_[] = "media.mojom.AudioOutputStreamProviderClient";

AudioOutputStreamProviderClientProxy::AudioOutputStreamProviderClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AudioOutputStreamProviderClientProxy::Created(
    ::mojo::PendingRemote<AudioOutputStream> in_stream, ::media::mojom::ReadWriteAudioDataPipePtr in_data_pipe) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::AudioOutputStreamProviderClient::Created", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("stream"), in_stream, 
                        "<value of type ::mojo::PendingRemote<AudioOutputStream>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data_pipe"), in_data_pipe, 
                        "<value of type ::media::mojom::ReadWriteAudioDataPipePtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kAudioOutputStreamProviderClient_Created_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioOutputStreamProviderClient_Created_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media::mojom::AudioOutputStreamInterfaceBase>>(
      in_stream, &params->stream, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->stream),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid stream in AudioOutputStreamProviderClient.Created request");
  mojo::internal::MessageFragment<
      typename decltype(params->data_pipe)::BaseType> data_pipe_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::ReadWriteAudioDataPipeDataView>(
      in_data_pipe, data_pipe_fragment);
  params->data_pipe.Set(
      data_pipe_fragment.is_null() ? nullptr : data_pipe_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->data_pipe.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data_pipe in AudioOutputStreamProviderClient.Created request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioOutputStreamProviderClient::Name_);
  message.set_method_name("Created");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool AudioOutputStreamProviderClientStubDispatch::Accept(
    AudioOutputStreamProviderClient* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kAudioOutputStreamProviderClient_Created_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::AudioOutputStreamProviderClient::Created",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::AudioOutputStreamProviderClient::Created");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::AudioOutputStreamProviderClient_Created_Params_Data* params =
          reinterpret_cast<internal::AudioOutputStreamProviderClient_Created_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<AudioOutputStream> p_stream{};
      ::media::mojom::ReadWriteAudioDataPipePtr p_data_pipe{};
      AudioOutputStreamProviderClient_Created_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_stream =
            input_data_view.TakeStream<decltype(p_stream)>();
      }
      if (success && !input_data_view.ReadDataPipe(&p_data_pipe))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioOutputStreamProviderClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Created(
std::move(p_stream), 
std::move(p_data_pipe));
      return true;
    }
  }
  return false;
}

// static
bool AudioOutputStreamProviderClientStubDispatch::AcceptWithResponder(
    AudioOutputStreamProviderClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kAudioOutputStreamProviderClient_Created_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kAudioOutputStreamProviderClientValidationInfo[] = {
    {internal::kAudioOutputStreamProviderClient_Created_Name,
     {&internal::AudioOutputStreamProviderClient_Created_Params_Data::Validate,
      nullptr /* no response */}},
};

bool AudioOutputStreamProviderClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::AudioOutputStreamProviderClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kAudioOutputStreamProviderClientValidationInfo);
}

}  // namespace mojom
}  // namespace media

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif