// media/mojo/mojom/cdm_service.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "media/mojo/mojom/cdm_service.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/cdm_service.mojom-params-data.h"
namespace media {
namespace mojom {

namespace internal {


// static
bool CdmService_LoadCdm_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CdmService_LoadCdm_Params_Data* object = static_cast<const CdmService_LoadCdm_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cdm_path, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->cdm_path, validation_context))
    return false;

  return true;
}

CdmService_LoadCdm_Params_Data::CdmService_LoadCdm_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CdmService_CreateCdmFactory_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CdmService_CreateCdmFactory_Params_Data* object = static_cast<const CdmService_CreateCdmFactory_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->factory, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->factory,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->frame_interfaces, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->frame_interfaces,
                                                 validation_context)) {
    return false;
  }

  return true;
}

CdmService_CreateCdmFactory_Params_Data::CdmService_CreateCdmFactory_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace media
