// media/mojo/mojom/cdm_storage.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "media/mojo/mojom/cdm_storage.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/cdm_storage.mojom-params-data.h"
namespace media {
namespace mojom {

std::string CdmStorage_StatusToString(CdmStorage_Status value) {
  switch(value) {
    case CdmStorage_Status::kSuccess:
      return "CdmStorage_Status::kSuccess";
    case CdmStorage_Status::kInUse:
      return "CdmStorage_Status::kInUse";
    case CdmStorage_Status::kFailure:
      return "CdmStorage_Status::kFailure";
    default:
      return base::StringPrintf("Unknown CdmStorage_Status value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, CdmStorage_Status value) {
  return os << CdmStorage_StatusToString(value);
}

std::string CdmFile_StatusToString(CdmFile_Status value) {
  switch(value) {
    case CdmFile_Status::kSuccess:
      return "CdmFile_Status::kSuccess";
    case CdmFile_Status::kFailure:
      return "CdmFile_Status::kFailure";
    default:
      return base::StringPrintf("Unknown CdmFile_Status value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, CdmFile_Status value) {
  return os << CdmFile_StatusToString(value);
}

namespace internal {


// static
bool CdmStorage_Open_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CdmStorage_Open_Params_Data* object = static_cast<const CdmStorage_Open_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->file_name, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams file_name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->file_name, validation_context,
                                         &file_name_validate_params)) {
    return false;
  }

  return true;
}

CdmStorage_Open_Params_Data::CdmStorage_Open_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CdmStorage_Open_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CdmStorage_Open_ResponseParams_Data* object = static_cast<const CdmStorage_Open_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::media::mojom::internal::CdmStorage_Status_Data
        ::Validate(object->status, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterface(object->cdm_file,
                                                 validation_context)) {
    return false;
  }

  return true;
}

CdmStorage_Open_ResponseParams_Data::CdmStorage_Open_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CdmFile_Read_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CdmFile_Read_Params_Data* object = static_cast<const CdmFile_Read_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

CdmFile_Read_Params_Data::CdmFile_Read_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CdmFile_Read_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CdmFile_Read_ResponseParams_Data* object = static_cast<const CdmFile_Read_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::media::mojom::internal::CdmFile_Status_Data
        ::Validate(object->status, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams data_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->data, validation_context,
                                         &data_validate_params)) {
    return false;
  }

  return true;
}

CdmFile_Read_ResponseParams_Data::CdmFile_Read_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CdmFile_Write_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CdmFile_Write_Params_Data* object = static_cast<const CdmFile_Write_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams data_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->data, validation_context,
                                         &data_validate_params)) {
    return false;
  }

  return true;
}

CdmFile_Write_Params_Data::CdmFile_Write_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CdmFile_Write_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CdmFile_Write_ResponseParams_Data* object = static_cast<const CdmFile_Write_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::media::mojom::internal::CdmFile_Status_Data
        ::Validate(object->status, validation_context))
    return false;

  return true;
}

CdmFile_Write_ResponseParams_Data::CdmFile_Write_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace media

namespace perfetto {

// static
void TraceFormatTraits<::media::mojom::CdmStorage_Status>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::media::mojom::CdmStorage_Status value) {
  return std::move(context).WriteString(::media::mojom::CdmStorage_StatusToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media::mojom::CdmFile_Status>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::media::mojom::CdmFile_Status value) {
  return std::move(context).WriteString(::media::mojom::CdmFile_StatusToString(value));
}

} // namespace perfetto
