// media/mojo/mojom/display_media_information.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/mojo/mojom/display_media_information.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "media/mojo/mojom/display_media_information.mojom-params-data.h"
#include "media/mojo/mojom/display_media_information.mojom-shared-message-ids.h"

#include "media/mojo/mojom/display_media_information.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef MEDIA_MOJO_MOJOM_DISPLAY_MEDIA_INFORMATION_MOJOM_BLINK_JUMBO_H_
#define MEDIA_MOJO_MOJOM_DISPLAY_MEDIA_INFORMATION_MOJOM_BLINK_JUMBO_H_
#endif
namespace media {
namespace mojom {
namespace blink {
DisplayMediaInformation::DisplayMediaInformation()
    : display_surface(),
      logical_surface(),
      cursor() {}

DisplayMediaInformation::DisplayMediaInformation(
    DisplayCaptureSurfaceType display_surface_in,
    bool logical_surface_in,
    CursorCaptureType cursor_in)
    : display_surface(std::move(display_surface_in)),
      logical_surface(std::move(logical_surface_in)),
      cursor(std::move(cursor_in)) {}

DisplayMediaInformation::~DisplayMediaInformation() = default;
size_t DisplayMediaInformation::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->display_surface);
  seed = mojo::internal::WTFHash(seed, this->logical_surface);
  seed = mojo::internal::WTFHash(seed, this->cursor);
  return seed;
}

void DisplayMediaInformation::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "display_surface"), this->display_surface, 
      "<value of type DisplayCaptureSurfaceType>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "logical_surface"), this->logical_surface, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cursor"), this->cursor, 
      "<value of type CursorCaptureType>");
}

bool DisplayMediaInformation::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace blink
}  // namespace mojom
}  // namespace media

namespace mojo {


// static
bool StructTraits<::media::mojom::blink::DisplayMediaInformation::DataView, ::media::mojom::blink::DisplayMediaInformationPtr>::Read(
    ::media::mojom::blink::DisplayMediaInformation::DataView input,
    ::media::mojom::blink::DisplayMediaInformationPtr* output) {
  bool success = true;
  ::media::mojom::blink::DisplayMediaInformationPtr result(::media::mojom::blink::DisplayMediaInformation::New());
  
      if (success && !input.ReadDisplaySurface(&result->display_surface))
        success = false;
      if (success)
        result->logical_surface = input.logical_surface();
      if (success && !input.ReadCursor(&result->cursor))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif