// media/mojo/mojom/display_media_information.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "media/mojo/mojom/display_media_information.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/display_media_information.mojom-params-data.h"
namespace media {
namespace mojom {

std::string DisplayCaptureSurfaceTypeToString(DisplayCaptureSurfaceType value) {
  switch(value) {
    case DisplayCaptureSurfaceType::MONITOR:
      return "DisplayCaptureSurfaceType::MONITOR";
    case DisplayCaptureSurfaceType::WINDOW:
      return "DisplayCaptureSurfaceType::WINDOW";
    case DisplayCaptureSurfaceType::APPLICATION:
      return "DisplayCaptureSurfaceType::APPLICATION";
    case DisplayCaptureSurfaceType::BROWSER:
      return "DisplayCaptureSurfaceType::BROWSER";
    default:
      return base::StringPrintf("Unknown DisplayCaptureSurfaceType value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, DisplayCaptureSurfaceType value) {
  return os << DisplayCaptureSurfaceTypeToString(value);
}

std::string CursorCaptureTypeToString(CursorCaptureType value) {
  switch(value) {
    case CursorCaptureType::NEVER:
      return "CursorCaptureType::NEVER";
    case CursorCaptureType::ALWAYS:
      return "CursorCaptureType::ALWAYS";
    case CursorCaptureType::MOTION:
      return "CursorCaptureType::MOTION";
    default:
      return base::StringPrintf("Unknown CursorCaptureType value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, CursorCaptureType value) {
  return os << CursorCaptureTypeToString(value);
}

namespace internal {


// static
bool DisplayMediaInformation_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DisplayMediaInformation_Data* object = static_cast<const DisplayMediaInformation_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::media::mojom::internal::DisplayCaptureSurfaceType_Data
        ::Validate(object->display_surface, validation_context))
    return false;


  if (!::media::mojom::internal::CursorCaptureType_Data
        ::Validate(object->cursor, validation_context))
    return false;

  return true;
}

DisplayMediaInformation_Data::DisplayMediaInformation_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace media

namespace perfetto {

// static
void TraceFormatTraits<::media::mojom::DisplayCaptureSurfaceType>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::media::mojom::DisplayCaptureSurfaceType value) {
  return std::move(context).WriteString(::media::mojom::DisplayCaptureSurfaceTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media::mojom::CursorCaptureType>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::media::mojom::CursorCaptureType value) {
  return std::move(context).WriteString(::media::mojom::CursorCaptureTypeToString(value));
}

} // namespace perfetto
