// media/mojo/mojom/interface_factory.mojom-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "media/mojo/mojom/interface_factory.mojom-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "media/mojo/mojom/audio_decoder.mojom.h"
#include "media/mojo/mojom/decryptor.mojom.h"
#include "media/mojo/mojom/content_decryption_module.mojom.h"
#include "media/mojo/mojom/renderer.mojom.h"
#include "media/mojo/mojom/renderer_extensions.mojom.h"
#include "media/mojo/mojom/video_decoder.mojom.h"
#include "mojo/public/mojom/base/token.mojom.h"
#include "mojo/public/mojom/base/unguessable_token.mojom.h"


#ifndef MEDIA_MOJO_MOJOM_INTERFACE_FACTORY_MOJOM_JUMBO_H_
#define MEDIA_MOJO_MOJOM_INTERFACE_FACTORY_MOJOM_JUMBO_H_
#endif


namespace media {
namespace mojom {


void InterfaceFactoryInterceptorForTesting::CreateAudioDecoder(::mojo::PendingReceiver<::media::mojom::AudioDecoder> audio_decoder) {
  GetForwardingInterface()->CreateAudioDecoder(std::move(audio_decoder));
}
void InterfaceFactoryInterceptorForTesting::CreateVideoDecoder(::mojo::PendingReceiver<::media::mojom::VideoDecoder> video_decoder) {
  GetForwardingInterface()->CreateVideoDecoder(std::move(video_decoder));
}
void InterfaceFactoryInterceptorForTesting::CreateDefaultRenderer(const std::string& audio_device_id, ::mojo::PendingReceiver<::media::mojom::Renderer> renderer) {
  GetForwardingInterface()->CreateDefaultRenderer(std::move(audio_device_id), std::move(renderer));
}
void InterfaceFactoryInterceptorForTesting::CreateCdm(const std::string& key_system, const ::media::CdmConfig& cdm_config, CreateCdmCallback callback) {
  GetForwardingInterface()->CreateCdm(std::move(key_system), std::move(cdm_config), std::move(callback));
}
InterfaceFactoryAsyncWaiter::InterfaceFactoryAsyncWaiter(
    InterfaceFactory* proxy) : proxy_(proxy) {}

InterfaceFactoryAsyncWaiter::~InterfaceFactoryAsyncWaiter() = default;

void InterfaceFactoryAsyncWaiter::CreateCdm(
    const std::string& key_system, const ::media::CdmConfig& cdm_config, ::mojo::PendingRemote<::media::mojom::ContentDecryptionModule>* out_cdm, base::Optional<::base::UnguessableToken>* out_cdm_id, ::mojo::PendingRemote<::media::mojom::Decryptor>* out_decryptor, std::string* out_error_message) {
  base::RunLoop loop;
  proxy_->CreateCdm(std::move(key_system),std::move(cdm_config),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::mojo::PendingRemote<::media::mojom::ContentDecryptionModule>* out_cdm
,
             base::Optional<::base::UnguessableToken>* out_cdm_id
,
             ::mojo::PendingRemote<::media::mojom::Decryptor>* out_decryptor
,
             std::string* out_error_message
,
             ::mojo::PendingRemote<::media::mojom::ContentDecryptionModule> cdm,
             const base::Optional<::base::UnguessableToken>& cdm_id,
             ::mojo::PendingRemote<::media::mojom::Decryptor> decryptor,
             const std::string& error_message) {*out_cdm = std::move(cdm);*out_cdm_id = std::move(cdm_id);*out_decryptor = std::move(decryptor);*out_error_message = std::move(error_message);
            loop->Quit();
          },
          &loop,
          out_cdm,
          out_cdm_id,
          out_decryptor,
          out_error_message));
  loop.Run();
}





}  // namespace mojom
}  // namespace media

#if defined(__clang__)
#pragma clang diagnostic pop
#endif