// media/mojo/mojom/media_player.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/mojo/mojom/media_player.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "media/mojo/mojom/media_player.mojom-params-data.h"
#include "media/mojo/mojom/media_player.mojom-shared-message-ids.h"

#include "media/mojo/mojom/media_player.mojom-import-headers.h"


#ifndef MEDIA_MOJO_MOJOM_MEDIA_PLAYER_MOJOM_JUMBO_H_
#define MEDIA_MOJO_MOJOM_MEDIA_PLAYER_MOJOM_JUMBO_H_
#endif
namespace media {
namespace mojom {
const char MediaPlayer::Name_[] = "media.mojom.MediaPlayer";

MediaPlayerProxy::MediaPlayerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MediaPlayerProxy::AddMediaPlayerObserver(
    ::mojo::PendingAssociatedRemote<MediaPlayerObserver> in_observer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::MediaPlayer::AddMediaPlayerObserver", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer, 
                        "<value of type ::mojo::PendingAssociatedRemote<MediaPlayerObserver>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMediaPlayer_AddMediaPlayerObserver_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaPlayer_AddMediaPlayerObserver_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::media::mojom::MediaPlayerObserverAssociatedPtrInfoDataView>(
      in_observer, &params->observer, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->observer),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid observer in MediaPlayer.AddMediaPlayerObserver request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaPlayer::Name_);
  message.set_method_name("AddMediaPlayerObserver");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaPlayerProxy::RequestPlay(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "media::mojom::MediaPlayer::RequestPlay");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMediaPlayer_RequestPlay_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaPlayer_RequestPlay_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaPlayer::Name_);
  message.set_method_name("RequestPlay");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaPlayerProxy::RequestPause(
    bool in_triggered_by_user) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::MediaPlayer::RequestPause", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("triggered_by_user"), in_triggered_by_user, 
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMediaPlayer_RequestPause_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaPlayer_RequestPause_Params_Data> params(
          message);
  params.Allocate();
  params->triggered_by_user = in_triggered_by_user;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaPlayer::Name_);
  message.set_method_name("RequestPause");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaPlayerProxy::RequestSeekForward(
    ::base::TimeDelta in_seek_time) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::MediaPlayer::RequestSeekForward", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("seek_time"), in_seek_time, 
                        "<value of type ::base::TimeDelta>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMediaPlayer_RequestSeekForward_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaPlayer_RequestSeekForward_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->seek_time)::BaseType> seek_time_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_seek_time, seek_time_fragment);
  params->seek_time.Set(
      seek_time_fragment.is_null() ? nullptr : seek_time_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->seek_time.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null seek_time in MediaPlayer.RequestSeekForward request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaPlayer::Name_);
  message.set_method_name("RequestSeekForward");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaPlayerProxy::RequestSeekBackward(
    ::base::TimeDelta in_seek_time) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::MediaPlayer::RequestSeekBackward", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("seek_time"), in_seek_time, 
                        "<value of type ::base::TimeDelta>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMediaPlayer_RequestSeekBackward_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaPlayer_RequestSeekBackward_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->seek_time)::BaseType> seek_time_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_seek_time, seek_time_fragment);
  params->seek_time.Set(
      seek_time_fragment.is_null() ? nullptr : seek_time_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->seek_time.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null seek_time in MediaPlayer.RequestSeekBackward request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaPlayer::Name_);
  message.set_method_name("RequestSeekBackward");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaPlayerProxy::RequestEnterPictureInPicture(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "media::mojom::MediaPlayer::RequestEnterPictureInPicture");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMediaPlayer_RequestEnterPictureInPicture_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaPlayer_RequestEnterPictureInPicture_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaPlayer::Name_);
  message.set_method_name("RequestEnterPictureInPicture");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaPlayerProxy::RequestExitPictureInPicture(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "media::mojom::MediaPlayer::RequestExitPictureInPicture");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMediaPlayer_RequestExitPictureInPicture_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaPlayer_RequestExitPictureInPicture_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaPlayer::Name_);
  message.set_method_name("RequestExitPictureInPicture");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaPlayerProxy::SetAudioSinkId(
    const std::string& in_sink_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::MediaPlayer::SetAudioSinkId", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sink_id"), in_sink_id, 
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMediaPlayer_SetAudioSinkId_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaPlayer_SetAudioSinkId_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->sink_id)::BaseType> sink_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_sink_id, sink_id_fragment);
  params->sink_id.Set(
      sink_id_fragment.is_null() ? nullptr : sink_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->sink_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null sink_id in MediaPlayer.SetAudioSinkId request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaPlayer::Name_);
  message.set_method_name("SetAudioSinkId");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool MediaPlayerStubDispatch::Accept(
    MediaPlayer* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kMediaPlayer_AddMediaPlayerObserver_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::MediaPlayer::AddMediaPlayerObserver",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::MediaPlayer::AddMediaPlayerObserver");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaPlayer_AddMediaPlayerObserver_Params_Data* params =
          reinterpret_cast<internal::MediaPlayer_AddMediaPlayerObserver_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingAssociatedRemote<MediaPlayerObserver> p_observer{};
      MediaPlayer_AddMediaPlayerObserver_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaPlayer::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddMediaPlayerObserver(
std::move(p_observer));
      return true;
    }
    case internal::kMediaPlayer_RequestPlay_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::MediaPlayer::RequestPlay",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::MediaPlayer::RequestPlay");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaPlayer_RequestPlay_Params_Data* params =
          reinterpret_cast<internal::MediaPlayer_RequestPlay_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      MediaPlayer_RequestPlay_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaPlayer::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestPlay();
      return true;
    }
    case internal::kMediaPlayer_RequestPause_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::MediaPlayer::RequestPause",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::MediaPlayer::RequestPause");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaPlayer_RequestPause_Params_Data* params =
          reinterpret_cast<internal::MediaPlayer_RequestPause_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_triggered_by_user{};
      MediaPlayer_RequestPause_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_triggered_by_user = input_data_view.triggered_by_user();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaPlayer::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestPause(
std::move(p_triggered_by_user));
      return true;
    }
    case internal::kMediaPlayer_RequestSeekForward_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::MediaPlayer::RequestSeekForward",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::MediaPlayer::RequestSeekForward");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaPlayer_RequestSeekForward_Params_Data* params =
          reinterpret_cast<internal::MediaPlayer_RequestSeekForward_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::TimeDelta p_seek_time{};
      MediaPlayer_RequestSeekForward_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSeekTime(&p_seek_time))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaPlayer::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestSeekForward(
std::move(p_seek_time));
      return true;
    }
    case internal::kMediaPlayer_RequestSeekBackward_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::MediaPlayer::RequestSeekBackward",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::MediaPlayer::RequestSeekBackward");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaPlayer_RequestSeekBackward_Params_Data* params =
          reinterpret_cast<internal::MediaPlayer_RequestSeekBackward_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::TimeDelta p_seek_time{};
      MediaPlayer_RequestSeekBackward_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSeekTime(&p_seek_time))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaPlayer::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestSeekBackward(
std::move(p_seek_time));
      return true;
    }
    case internal::kMediaPlayer_RequestEnterPictureInPicture_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::MediaPlayer::RequestEnterPictureInPicture",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::MediaPlayer::RequestEnterPictureInPicture");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaPlayer_RequestEnterPictureInPicture_Params_Data* params =
          reinterpret_cast<internal::MediaPlayer_RequestEnterPictureInPicture_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      MediaPlayer_RequestEnterPictureInPicture_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaPlayer::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestEnterPictureInPicture();
      return true;
    }
    case internal::kMediaPlayer_RequestExitPictureInPicture_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::MediaPlayer::RequestExitPictureInPicture",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::MediaPlayer::RequestExitPictureInPicture");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaPlayer_RequestExitPictureInPicture_Params_Data* params =
          reinterpret_cast<internal::MediaPlayer_RequestExitPictureInPicture_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      MediaPlayer_RequestExitPictureInPicture_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaPlayer::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestExitPictureInPicture();
      return true;
    }
    case internal::kMediaPlayer_SetAudioSinkId_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::MediaPlayer::SetAudioSinkId",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::MediaPlayer::SetAudioSinkId");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaPlayer_SetAudioSinkId_Params_Data* params =
          reinterpret_cast<internal::MediaPlayer_SetAudioSinkId_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_sink_id{};
      MediaPlayer_SetAudioSinkId_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSinkId(&p_sink_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaPlayer::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetAudioSinkId(
std::move(p_sink_id));
      return true;
    }
  }
  return false;
}

// static
bool MediaPlayerStubDispatch::AcceptWithResponder(
    MediaPlayer* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kMediaPlayer_AddMediaPlayerObserver_Name: {
      break;
    }
    case internal::kMediaPlayer_RequestPlay_Name: {
      break;
    }
    case internal::kMediaPlayer_RequestPause_Name: {
      break;
    }
    case internal::kMediaPlayer_RequestSeekForward_Name: {
      break;
    }
    case internal::kMediaPlayer_RequestSeekBackward_Name: {
      break;
    }
    case internal::kMediaPlayer_RequestEnterPictureInPicture_Name: {
      break;
    }
    case internal::kMediaPlayer_RequestExitPictureInPicture_Name: {
      break;
    }
    case internal::kMediaPlayer_SetAudioSinkId_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kMediaPlayerValidationInfo[] = {
    {internal::kMediaPlayer_AddMediaPlayerObserver_Name,
     {&internal::MediaPlayer_AddMediaPlayerObserver_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kMediaPlayer_RequestPlay_Name,
     {&internal::MediaPlayer_RequestPlay_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kMediaPlayer_RequestPause_Name,
     {&internal::MediaPlayer_RequestPause_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kMediaPlayer_RequestSeekForward_Name,
     {&internal::MediaPlayer_RequestSeekForward_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kMediaPlayer_RequestSeekBackward_Name,
     {&internal::MediaPlayer_RequestSeekBackward_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kMediaPlayer_RequestEnterPictureInPicture_Name,
     {&internal::MediaPlayer_RequestEnterPictureInPicture_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kMediaPlayer_RequestExitPictureInPicture_Name,
     {&internal::MediaPlayer_RequestExitPictureInPicture_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kMediaPlayer_SetAudioSinkId_Name,
     {&internal::MediaPlayer_SetAudioSinkId_Params_Data::Validate,
      nullptr /* no response */}},
};

bool MediaPlayerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::MediaPlayer::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kMediaPlayerValidationInfo);
}

const char MediaPlayerObserver::Name_[] = "media.mojom.MediaPlayerObserver";

MediaPlayerObserverProxy::MediaPlayerObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MediaPlayerObserverProxy::OnMediaPlaying(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "media::mojom::MediaPlayerObserver::OnMediaPlaying");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMediaPlayerObserver_OnMediaPlaying_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaPlayerObserver_OnMediaPlaying_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaPlayerObserver::Name_);
  message.set_method_name("OnMediaPlaying");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaPlayerObserverProxy::OnMediaPaused(
    bool in_stream_ended) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::MediaPlayerObserver::OnMediaPaused", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("stream_ended"), in_stream_ended, 
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMediaPlayerObserver_OnMediaPaused_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaPlayerObserver_OnMediaPaused_Params_Data> params(
          message);
  params.Allocate();
  params->stream_ended = in_stream_ended;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaPlayerObserver::Name_);
  message.set_method_name("OnMediaPaused");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaPlayerObserverProxy::OnMutedStatusChanged(
    bool in_muted) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::MediaPlayerObserver::OnMutedStatusChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("muted"), in_muted, 
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMediaPlayerObserver_OnMutedStatusChanged_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaPlayerObserver_OnMutedStatusChanged_Params_Data> params(
          message);
  params.Allocate();
  params->muted = in_muted;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaPlayerObserver::Name_);
  message.set_method_name("OnMutedStatusChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaPlayerObserverProxy::OnMediaMetadataChanged(
    bool in_has_audio, bool in_has_video, ::media::MediaContentType in_content_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::MediaPlayerObserver::OnMediaMetadataChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("has_audio"), in_has_audio, 
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("has_video"), in_has_video, 
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("content_type"), in_content_type, 
                        "<value of type ::media::MediaContentType>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMediaPlayerObserver_OnMediaMetadataChanged_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaPlayerObserver_OnMediaMetadataChanged_Params_Data> params(
          message);
  params.Allocate();
  params->has_audio = in_has_audio;
  params->has_video = in_has_video;
  mojo::internal::Serialize<::media::mojom::MediaContentType>(
      in_content_type, &params->content_type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaPlayerObserver::Name_);
  message.set_method_name("OnMediaMetadataChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaPlayerObserverProxy::OnMediaPositionStateChanged(
    const ::media_session::MediaPosition& in_media_position) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::MediaPlayerObserver::OnMediaPositionStateChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("media_position"), in_media_position, 
                        "<value of type const ::media_session::MediaPosition&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMediaPlayerObserver_OnMediaPositionStateChanged_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaPlayerObserver_OnMediaPositionStateChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->media_position)::BaseType> media_position_fragment(
          params.message());
  mojo::internal::Serialize<::media_session::mojom::MediaPositionDataView>(
      in_media_position, media_position_fragment);
  params->media_position.Set(
      media_position_fragment.is_null() ? nullptr : media_position_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->media_position.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null media_position in MediaPlayerObserver.OnMediaPositionStateChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaPlayerObserver::Name_);
  message.set_method_name("OnMediaPositionStateChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaPlayerObserverProxy::OnMediaEffectivelyFullscreenChanged(
    ::blink::WebFullscreenVideoStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::MediaPlayerObserver::OnMediaEffectivelyFullscreenChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status, 
                        "<value of type ::blink::WebFullscreenVideoStatus>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMediaPlayerObserver_OnMediaEffectivelyFullscreenChanged_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaPlayerObserver_OnMediaEffectivelyFullscreenChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::media::mojom::FullscreenVideoStatus>(
      in_status, &params->status);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaPlayerObserver::Name_);
  message.set_method_name("OnMediaEffectivelyFullscreenChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaPlayerObserverProxy::OnMediaSizeChanged(
    const ::gfx::Size& in_size) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::MediaPlayerObserver::OnMediaSizeChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("size"), in_size, 
                        "<value of type const ::gfx::Size&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMediaPlayerObserver_OnMediaSizeChanged_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaPlayerObserver_OnMediaSizeChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->size)::BaseType> size_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_size, size_fragment);
  params->size.Set(
      size_fragment.is_null() ? nullptr : size_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->size.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null size in MediaPlayerObserver.OnMediaSizeChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaPlayerObserver::Name_);
  message.set_method_name("OnMediaSizeChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaPlayerObserverProxy::OnPictureInPictureAvailabilityChanged(
    bool in_available) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::MediaPlayerObserver::OnPictureInPictureAvailabilityChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("available"), in_available, 
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMediaPlayerObserver_OnPictureInPictureAvailabilityChanged_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaPlayerObserver_OnPictureInPictureAvailabilityChanged_Params_Data> params(
          message);
  params.Allocate();
  params->available = in_available;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaPlayerObserver::Name_);
  message.set_method_name("OnPictureInPictureAvailabilityChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaPlayerObserverProxy::OnAudioOutputSinkChanged(
    const std::string& in_hashed_device_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::MediaPlayerObserver::OnAudioOutputSinkChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("hashed_device_id"), in_hashed_device_id, 
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMediaPlayerObserver_OnAudioOutputSinkChanged_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaPlayerObserver_OnAudioOutputSinkChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->hashed_device_id)::BaseType> hashed_device_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_hashed_device_id, hashed_device_id_fragment);
  params->hashed_device_id.Set(
      hashed_device_id_fragment.is_null() ? nullptr : hashed_device_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->hashed_device_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null hashed_device_id in MediaPlayerObserver.OnAudioOutputSinkChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaPlayerObserver::Name_);
  message.set_method_name("OnAudioOutputSinkChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaPlayerObserverProxy::OnAudioOutputSinkChangingDisabled(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "media::mojom::MediaPlayerObserver::OnAudioOutputSinkChangingDisabled");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMediaPlayerObserver_OnAudioOutputSinkChangingDisabled_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaPlayerObserver_OnAudioOutputSinkChangingDisabled_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaPlayerObserver::Name_);
  message.set_method_name("OnAudioOutputSinkChangingDisabled");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaPlayerObserverProxy::OnBufferUnderflow(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "media::mojom::MediaPlayerObserver::OnBufferUnderflow");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMediaPlayerObserver_OnBufferUnderflow_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaPlayerObserver_OnBufferUnderflow_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaPlayerObserver::Name_);
  message.set_method_name("OnBufferUnderflow");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaPlayerObserverProxy::OnSeek(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "media::mojom::MediaPlayerObserver::OnSeek");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMediaPlayerObserver_OnSeek_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaPlayerObserver_OnSeek_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaPlayerObserver::Name_);
  message.set_method_name("OnSeek");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool MediaPlayerObserverStubDispatch::Accept(
    MediaPlayerObserver* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kMediaPlayerObserver_OnMediaPlaying_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::MediaPlayerObserver::OnMediaPlaying",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::MediaPlayerObserver::OnMediaPlaying");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaPlayerObserver_OnMediaPlaying_Params_Data* params =
          reinterpret_cast<internal::MediaPlayerObserver_OnMediaPlaying_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      MediaPlayerObserver_OnMediaPlaying_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaPlayerObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnMediaPlaying();
      return true;
    }
    case internal::kMediaPlayerObserver_OnMediaPaused_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::MediaPlayerObserver::OnMediaPaused",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::MediaPlayerObserver::OnMediaPaused");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaPlayerObserver_OnMediaPaused_Params_Data* params =
          reinterpret_cast<internal::MediaPlayerObserver_OnMediaPaused_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_stream_ended{};
      MediaPlayerObserver_OnMediaPaused_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_stream_ended = input_data_view.stream_ended();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaPlayerObserver::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnMediaPaused(
std::move(p_stream_ended));
      return true;
    }
    case internal::kMediaPlayerObserver_OnMutedStatusChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::MediaPlayerObserver::OnMutedStatusChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::MediaPlayerObserver::OnMutedStatusChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaPlayerObserver_OnMutedStatusChanged_Params_Data* params =
          reinterpret_cast<internal::MediaPlayerObserver_OnMutedStatusChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_muted{};
      MediaPlayerObserver_OnMutedStatusChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_muted = input_data_view.muted();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaPlayerObserver::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnMutedStatusChanged(
std::move(p_muted));
      return true;
    }
    case internal::kMediaPlayerObserver_OnMediaMetadataChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::MediaPlayerObserver::OnMediaMetadataChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::MediaPlayerObserver::OnMediaMetadataChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaPlayerObserver_OnMediaMetadataChanged_Params_Data* params =
          reinterpret_cast<internal::MediaPlayerObserver_OnMediaMetadataChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_has_audio{};
      bool p_has_video{};
      ::media::MediaContentType p_content_type{};
      MediaPlayerObserver_OnMediaMetadataChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_has_audio = input_data_view.has_audio();
      if (success)
        p_has_video = input_data_view.has_video();
      if (success && !input_data_view.ReadContentType(&p_content_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaPlayerObserver::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnMediaMetadataChanged(
std::move(p_has_audio), 
std::move(p_has_video), 
std::move(p_content_type));
      return true;
    }
    case internal::kMediaPlayerObserver_OnMediaPositionStateChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::MediaPlayerObserver::OnMediaPositionStateChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::MediaPlayerObserver::OnMediaPositionStateChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaPlayerObserver_OnMediaPositionStateChanged_Params_Data* params =
          reinterpret_cast<internal::MediaPlayerObserver_OnMediaPositionStateChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::media_session::MediaPosition p_media_position{};
      MediaPlayerObserver_OnMediaPositionStateChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMediaPosition(&p_media_position))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaPlayerObserver::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnMediaPositionStateChanged(
std::move(p_media_position));
      return true;
    }
    case internal::kMediaPlayerObserver_OnMediaEffectivelyFullscreenChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::MediaPlayerObserver::OnMediaEffectivelyFullscreenChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::MediaPlayerObserver::OnMediaEffectivelyFullscreenChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaPlayerObserver_OnMediaEffectivelyFullscreenChanged_Params_Data* params =
          reinterpret_cast<internal::MediaPlayerObserver_OnMediaEffectivelyFullscreenChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::WebFullscreenVideoStatus p_status{};
      MediaPlayerObserver_OnMediaEffectivelyFullscreenChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStatus(&p_status))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaPlayerObserver::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnMediaEffectivelyFullscreenChanged(
std::move(p_status));
      return true;
    }
    case internal::kMediaPlayerObserver_OnMediaSizeChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::MediaPlayerObserver::OnMediaSizeChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::MediaPlayerObserver::OnMediaSizeChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaPlayerObserver_OnMediaSizeChanged_Params_Data* params =
          reinterpret_cast<internal::MediaPlayerObserver_OnMediaSizeChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gfx::Size p_size{};
      MediaPlayerObserver_OnMediaSizeChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSize(&p_size))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaPlayerObserver::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnMediaSizeChanged(
std::move(p_size));
      return true;
    }
    case internal::kMediaPlayerObserver_OnPictureInPictureAvailabilityChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::MediaPlayerObserver::OnPictureInPictureAvailabilityChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::MediaPlayerObserver::OnPictureInPictureAvailabilityChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaPlayerObserver_OnPictureInPictureAvailabilityChanged_Params_Data* params =
          reinterpret_cast<internal::MediaPlayerObserver_OnPictureInPictureAvailabilityChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_available{};
      MediaPlayerObserver_OnPictureInPictureAvailabilityChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_available = input_data_view.available();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaPlayerObserver::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnPictureInPictureAvailabilityChanged(
std::move(p_available));
      return true;
    }
    case internal::kMediaPlayerObserver_OnAudioOutputSinkChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::MediaPlayerObserver::OnAudioOutputSinkChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::MediaPlayerObserver::OnAudioOutputSinkChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaPlayerObserver_OnAudioOutputSinkChanged_Params_Data* params =
          reinterpret_cast<internal::MediaPlayerObserver_OnAudioOutputSinkChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_hashed_device_id{};
      MediaPlayerObserver_OnAudioOutputSinkChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadHashedDeviceId(&p_hashed_device_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaPlayerObserver::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnAudioOutputSinkChanged(
std::move(p_hashed_device_id));
      return true;
    }
    case internal::kMediaPlayerObserver_OnAudioOutputSinkChangingDisabled_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::MediaPlayerObserver::OnAudioOutputSinkChangingDisabled",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::MediaPlayerObserver::OnAudioOutputSinkChangingDisabled");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaPlayerObserver_OnAudioOutputSinkChangingDisabled_Params_Data* params =
          reinterpret_cast<internal::MediaPlayerObserver_OnAudioOutputSinkChangingDisabled_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      MediaPlayerObserver_OnAudioOutputSinkChangingDisabled_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaPlayerObserver::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnAudioOutputSinkChangingDisabled();
      return true;
    }
    case internal::kMediaPlayerObserver_OnBufferUnderflow_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::MediaPlayerObserver::OnBufferUnderflow",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::MediaPlayerObserver::OnBufferUnderflow");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaPlayerObserver_OnBufferUnderflow_Params_Data* params =
          reinterpret_cast<internal::MediaPlayerObserver_OnBufferUnderflow_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      MediaPlayerObserver_OnBufferUnderflow_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaPlayerObserver::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnBufferUnderflow();
      return true;
    }
    case internal::kMediaPlayerObserver_OnSeek_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::MediaPlayerObserver::OnSeek",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::MediaPlayerObserver::OnSeek");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaPlayerObserver_OnSeek_Params_Data* params =
          reinterpret_cast<internal::MediaPlayerObserver_OnSeek_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      MediaPlayerObserver_OnSeek_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaPlayerObserver::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSeek();
      return true;
    }
  }
  return false;
}

// static
bool MediaPlayerObserverStubDispatch::AcceptWithResponder(
    MediaPlayerObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kMediaPlayerObserver_OnMediaPlaying_Name: {
      break;
    }
    case internal::kMediaPlayerObserver_OnMediaPaused_Name: {
      break;
    }
    case internal::kMediaPlayerObserver_OnMutedStatusChanged_Name: {
      break;
    }
    case internal::kMediaPlayerObserver_OnMediaMetadataChanged_Name: {
      break;
    }
    case internal::kMediaPlayerObserver_OnMediaPositionStateChanged_Name: {
      break;
    }
    case internal::kMediaPlayerObserver_OnMediaEffectivelyFullscreenChanged_Name: {
      break;
    }
    case internal::kMediaPlayerObserver_OnMediaSizeChanged_Name: {
      break;
    }
    case internal::kMediaPlayerObserver_OnPictureInPictureAvailabilityChanged_Name: {
      break;
    }
    case internal::kMediaPlayerObserver_OnAudioOutputSinkChanged_Name: {
      break;
    }
    case internal::kMediaPlayerObserver_OnAudioOutputSinkChangingDisabled_Name: {
      break;
    }
    case internal::kMediaPlayerObserver_OnBufferUnderflow_Name: {
      break;
    }
    case internal::kMediaPlayerObserver_OnSeek_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kMediaPlayerObserverValidationInfo[] = {
    {internal::kMediaPlayerObserver_OnMediaPlaying_Name,
     {&internal::MediaPlayerObserver_OnMediaPlaying_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kMediaPlayerObserver_OnMediaPaused_Name,
     {&internal::MediaPlayerObserver_OnMediaPaused_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kMediaPlayerObserver_OnMutedStatusChanged_Name,
     {&internal::MediaPlayerObserver_OnMutedStatusChanged_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kMediaPlayerObserver_OnMediaMetadataChanged_Name,
     {&internal::MediaPlayerObserver_OnMediaMetadataChanged_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kMediaPlayerObserver_OnMediaPositionStateChanged_Name,
     {&internal::MediaPlayerObserver_OnMediaPositionStateChanged_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kMediaPlayerObserver_OnMediaEffectivelyFullscreenChanged_Name,
     {&internal::MediaPlayerObserver_OnMediaEffectivelyFullscreenChanged_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kMediaPlayerObserver_OnMediaSizeChanged_Name,
     {&internal::MediaPlayerObserver_OnMediaSizeChanged_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kMediaPlayerObserver_OnPictureInPictureAvailabilityChanged_Name,
     {&internal::MediaPlayerObserver_OnPictureInPictureAvailabilityChanged_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kMediaPlayerObserver_OnAudioOutputSinkChanged_Name,
     {&internal::MediaPlayerObserver_OnAudioOutputSinkChanged_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kMediaPlayerObserver_OnAudioOutputSinkChangingDisabled_Name,
     {&internal::MediaPlayerObserver_OnAudioOutputSinkChangingDisabled_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kMediaPlayerObserver_OnBufferUnderflow_Name,
     {&internal::MediaPlayerObserver_OnBufferUnderflow_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kMediaPlayerObserver_OnSeek_Name,
     {&internal::MediaPlayerObserver_OnSeek_Params_Data::Validate,
      nullptr /* no response */}},
};

bool MediaPlayerObserverRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::MediaPlayerObserver::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kMediaPlayerObserverValidationInfo);
}

const char MediaPlayerHost::Name_[] = "media.mojom.MediaPlayerHost";

MediaPlayerHostProxy::MediaPlayerHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MediaPlayerHostProxy::OnMediaPlayerAdded(
    ::mojo::PendingAssociatedRemote<MediaPlayer> in_player_remote, int32_t in_player_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::MediaPlayerHost::OnMediaPlayerAdded", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("player_remote"), in_player_remote, 
                        "<value of type ::mojo::PendingAssociatedRemote<MediaPlayer>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("player_id"), in_player_id, 
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMediaPlayerHost_OnMediaPlayerAdded_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaPlayerHost_OnMediaPlayerAdded_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::media::mojom::MediaPlayerAssociatedPtrInfoDataView>(
      in_player_remote, &params->player_remote, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->player_remote),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid player_remote in MediaPlayerHost.OnMediaPlayerAdded request");
  params->player_id = in_player_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaPlayerHost::Name_);
  message.set_method_name("OnMediaPlayerAdded");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool MediaPlayerHostStubDispatch::Accept(
    MediaPlayerHost* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kMediaPlayerHost_OnMediaPlayerAdded_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::MediaPlayerHost::OnMediaPlayerAdded",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::MediaPlayerHost::OnMediaPlayerAdded");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaPlayerHost_OnMediaPlayerAdded_Params_Data* params =
          reinterpret_cast<internal::MediaPlayerHost_OnMediaPlayerAdded_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingAssociatedRemote<MediaPlayer> p_player_remote{};
      int32_t p_player_id{};
      MediaPlayerHost_OnMediaPlayerAdded_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_player_remote =
            input_data_view.TakePlayerRemote<decltype(p_player_remote)>();
      }
      if (success)
        p_player_id = input_data_view.player_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaPlayerHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnMediaPlayerAdded(
std::move(p_player_remote), 
std::move(p_player_id));
      return true;
    }
  }
  return false;
}

// static
bool MediaPlayerHostStubDispatch::AcceptWithResponder(
    MediaPlayerHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kMediaPlayerHost_OnMediaPlayerAdded_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kMediaPlayerHostValidationInfo[] = {
    {internal::kMediaPlayerHost_OnMediaPlayerAdded_Name,
     {&internal::MediaPlayerHost_OnMediaPlayerAdded_Params_Data::Validate,
      nullptr /* no response */}},
};

bool MediaPlayerHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::MediaPlayerHost::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kMediaPlayerHostValidationInfo);
}

}  // namespace mojom
}  // namespace media

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif