// media/mojo/mojom/media_types.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/mojo/mojom/media_types.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "media/mojo/mojom/media_types.mojom-params-data.h"
#include "media/mojo/mojom/media_types.mojom-shared-message-ids.h"

#include "media/mojo/mojom/media_types.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef MEDIA_MOJO_MOJOM_MEDIA_TYPES_MOJOM_BLINK_JUMBO_H_
#define MEDIA_MOJO_MOJOM_MEDIA_TYPES_MOJOM_BLINK_JUMBO_H_
#endif
namespace media {
namespace mojom {
namespace blink {
VideoTransformation::VideoTransformation()
    : rotation(),
      mirrored() {}

VideoTransformation::VideoTransformation(
    VideoRotation rotation_in,
    bool mirrored_in)
    : rotation(std::move(rotation_in)),
      mirrored(std::move(mirrored_in)) {}

VideoTransformation::~VideoTransformation() = default;
size_t VideoTransformation::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->rotation);
  seed = mojo::internal::WTFHash(seed, this->mirrored);
  return seed;
}

void VideoTransformation::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rotation"), this->rotation, 
      "<value of type VideoRotation>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mirrored"), this->mirrored, 
      "<value of type bool>");
}

bool VideoTransformation::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
EncryptionPattern::EncryptionPattern()
    : crypt_byte_block(),
      skip_byte_block() {}

EncryptionPattern::EncryptionPattern(
    uint32_t crypt_byte_block_in,
    uint32_t skip_byte_block_in)
    : crypt_byte_block(std::move(crypt_byte_block_in)),
      skip_byte_block(std::move(skip_byte_block_in)) {}

EncryptionPattern::~EncryptionPattern() = default;
size_t EncryptionPattern::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->crypt_byte_block);
  seed = mojo::internal::WTFHash(seed, this->skip_byte_block);
  return seed;
}

void EncryptionPattern::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "crypt_byte_block"), this->crypt_byte_block, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "skip_byte_block"), this->skip_byte_block, 
      "<value of type uint32_t>");
}

bool EncryptionPattern::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VideoColorSpace::VideoColorSpace()
    : primaries(),
      transfer(),
      matrix(),
      range() {}

VideoColorSpace::VideoColorSpace(
    VideoColorSpace::PrimaryID primaries_in,
    VideoColorSpace::TransferID transfer_in,
    VideoColorSpace::MatrixID matrix_in,
    VideoColorSpace::RangeID range_in)
    : primaries(std::move(primaries_in)),
      transfer(std::move(transfer_in)),
      matrix(std::move(matrix_in)),
      range(std::move(range_in)) {}

VideoColorSpace::~VideoColorSpace() = default;
size_t VideoColorSpace::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->primaries);
  seed = mojo::internal::WTFHash(seed, this->transfer);
  seed = mojo::internal::WTFHash(seed, this->matrix);
  seed = mojo::internal::WTFHash(seed, this->range);
  return seed;
}

void VideoColorSpace::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "primaries"), this->primaries, 
      "<value of type VideoColorSpace::PrimaryID>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "transfer"), this->transfer, 
      "<value of type VideoColorSpace::TransferID>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "matrix"), this->matrix, 
      "<value of type VideoColorSpace::MatrixID>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "range"), this->range, 
      "<value of type VideoColorSpace::RangeID>");
}

bool VideoColorSpace::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AudioDecoderConfig::AudioDecoderConfig()
    : codec(),
      profile(),
      sample_format(),
      channel_layout(),
      samples_per_second(),
      extra_data(),
      seek_preroll(),
      codec_delay(),
      encryption_scheme() {}

AudioDecoderConfig::AudioDecoderConfig(
    AudioCodec codec_in,
    AudioCodecProfile profile_in,
    SampleFormat sample_format_in,
    ChannelLayout channel_layout_in,
    int32_t samples_per_second_in,
    WTF::Vector<uint8_t> extra_data_in,
    ::base::TimeDelta seek_preroll_in,
    int32_t codec_delay_in,
    EncryptionScheme encryption_scheme_in)
    : codec(std::move(codec_in)),
      profile(std::move(profile_in)),
      sample_format(std::move(sample_format_in)),
      channel_layout(std::move(channel_layout_in)),
      samples_per_second(std::move(samples_per_second_in)),
      extra_data(std::move(extra_data_in)),
      seek_preroll(std::move(seek_preroll_in)),
      codec_delay(std::move(codec_delay_in)),
      encryption_scheme(std::move(encryption_scheme_in)) {}

AudioDecoderConfig::~AudioDecoderConfig() = default;

void AudioDecoderConfig::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "codec"), this->codec, 
      "<value of type AudioCodec>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "profile"), this->profile, 
      "<value of type AudioCodecProfile>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sample_format"), this->sample_format, 
      "<value of type SampleFormat>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "channel_layout"), this->channel_layout, 
      "<value of type ChannelLayout>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "samples_per_second"), this->samples_per_second, 
      "<value of type int32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "extra_data"), this->extra_data, 
      "<value of type const WTF::Vector<uint8_t>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "seek_preroll"), this->seek_preroll, 
      "<value of type ::base::TimeDelta>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "codec_delay"), this->codec_delay, 
      "<value of type int32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "encryption_scheme"), this->encryption_scheme, 
      "<value of type EncryptionScheme>");
}

bool AudioDecoderConfig::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VideoDecoderConfig::VideoDecoderConfig()
    : codec(),
      profile(),
      level(),
      has_alpha(),
      transformation(),
      coded_size(),
      visible_rect(),
      natural_size(),
      extra_data(),
      encryption_scheme(),
      color_space_info(),
      hdr_metadata() {}

VideoDecoderConfig::VideoDecoderConfig(
    VideoCodec codec_in,
    VideoCodecProfile profile_in,
    uint32_t level_in,
    bool has_alpha_in,
    VideoTransformationPtr transformation_in,
    const ::gfx::Size& coded_size_in,
    const ::gfx::Rect& visible_rect_in,
    const ::gfx::Size& natural_size_in,
    WTF::Vector<uint8_t> extra_data_in,
    EncryptionScheme encryption_scheme_in,
    VideoColorSpacePtr color_space_info_in,
    ::gfx::mojom::blink::HDRMetadataPtr hdr_metadata_in)
    : codec(std::move(codec_in)),
      profile(std::move(profile_in)),
      level(std::move(level_in)),
      has_alpha(std::move(has_alpha_in)),
      transformation(std::move(transformation_in)),
      coded_size(std::move(coded_size_in)),
      visible_rect(std::move(visible_rect_in)),
      natural_size(std::move(natural_size_in)),
      extra_data(std::move(extra_data_in)),
      encryption_scheme(std::move(encryption_scheme_in)),
      color_space_info(std::move(color_space_info_in)),
      hdr_metadata(std::move(hdr_metadata_in)) {}

VideoDecoderConfig::~VideoDecoderConfig() = default;

void VideoDecoderConfig::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "codec"), this->codec, 
      "<value of type VideoCodec>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "profile"), this->profile, 
      "<value of type VideoCodecProfile>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "level"), this->level, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_alpha"), this->has_alpha, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "transformation"), this->transformation, 
      "<value of type VideoTransformationPtr>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "coded_size"), this->coded_size, 
      "<value of type const ::gfx::Size&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "visible_rect"), this->visible_rect, 
      "<value of type const ::gfx::Rect&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "natural_size"), this->natural_size, 
      "<value of type const ::gfx::Size&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "extra_data"), this->extra_data, 
      "<value of type const WTF::Vector<uint8_t>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "encryption_scheme"), this->encryption_scheme, 
      "<value of type EncryptionScheme>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "color_space_info"), this->color_space_info, 
      "<value of type VideoColorSpacePtr>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hdr_metadata"), this->hdr_metadata, 
      "<value of type ::gfx::mojom::blink::HDRMetadataPtr>");
}

bool VideoDecoderConfig::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DecryptConfig::DecryptConfig()
    : encryption_scheme(),
      key_id(),
      iv(),
      subsamples(),
      encryption_pattern() {}

DecryptConfig::DecryptConfig(
    EncryptionScheme encryption_scheme_in,
    const WTF::String& key_id_in,
    const WTF::String& iv_in,
    WTF::Vector<SubsampleEntryPtr> subsamples_in,
    EncryptionPatternPtr encryption_pattern_in)
    : encryption_scheme(std::move(encryption_scheme_in)),
      key_id(std::move(key_id_in)),
      iv(std::move(iv_in)),
      subsamples(std::move(subsamples_in)),
      encryption_pattern(std::move(encryption_pattern_in)) {}

DecryptConfig::~DecryptConfig() = default;

void DecryptConfig::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "encryption_scheme"), this->encryption_scheme, 
      "<value of type EncryptionScheme>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "key_id"), this->key_id, 
      "<value of type const WTF::String&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "iv"), this->iv, 
      "<value of type const WTF::String&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "subsamples"), this->subsamples, 
      "<value of type WTF::Vector<SubsampleEntryPtr>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "encryption_pattern"), this->encryption_pattern, 
      "<value of type EncryptionPatternPtr>");
}

bool DecryptConfig::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DecoderBuffer::DecoderBuffer()
    : timestamp(),
      duration(),
      is_end_of_stream(),
      data_size(),
      is_key_frame(),
      side_data(),
      decrypt_config(),
      front_discard(),
      back_discard() {}

DecoderBuffer::DecoderBuffer(
    ::base::TimeDelta timestamp_in,
    ::base::TimeDelta duration_in,
    bool is_end_of_stream_in,
    uint32_t data_size_in,
    bool is_key_frame_in,
    WTF::Vector<uint8_t> side_data_in,
    DecryptConfigPtr decrypt_config_in,
    ::base::TimeDelta front_discard_in,
    ::base::TimeDelta back_discard_in)
    : timestamp(std::move(timestamp_in)),
      duration(std::move(duration_in)),
      is_end_of_stream(std::move(is_end_of_stream_in)),
      data_size(std::move(data_size_in)),
      is_key_frame(std::move(is_key_frame_in)),
      side_data(std::move(side_data_in)),
      decrypt_config(std::move(decrypt_config_in)),
      front_discard(std::move(front_discard_in)),
      back_discard(std::move(back_discard_in)) {}

DecoderBuffer::~DecoderBuffer() = default;

void DecoderBuffer::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "timestamp"), this->timestamp, 
      "<value of type ::base::TimeDelta>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "duration"), this->duration, 
      "<value of type ::base::TimeDelta>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_end_of_stream"), this->is_end_of_stream, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data_size"), this->data_size, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_key_frame"), this->is_key_frame, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "side_data"), this->side_data, 
      "<value of type const WTF::Vector<uint8_t>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "decrypt_config"), this->decrypt_config, 
      "<value of type DecryptConfigPtr>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "front_discard"), this->front_discard, 
      "<value of type ::base::TimeDelta>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "back_discard"), this->back_discard, 
      "<value of type ::base::TimeDelta>");
}

bool DecoderBuffer::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AudioBuffer::AudioBuffer()
    : sample_format(),
      channel_layout(),
      channel_count(),
      sample_rate(),
      frame_count(),
      end_of_stream(),
      timestamp(),
      data() {}

AudioBuffer::AudioBuffer(
    SampleFormat sample_format_in,
    ChannelLayout channel_layout_in,
    int32_t channel_count_in,
    int32_t sample_rate_in,
    int32_t frame_count_in,
    bool end_of_stream_in,
    ::base::TimeDelta timestamp_in,
    WTF::Vector<uint8_t> data_in)
    : sample_format(std::move(sample_format_in)),
      channel_layout(std::move(channel_layout_in)),
      channel_count(std::move(channel_count_in)),
      sample_rate(std::move(sample_rate_in)),
      frame_count(std::move(frame_count_in)),
      end_of_stream(std::move(end_of_stream_in)),
      timestamp(std::move(timestamp_in)),
      data(std::move(data_in)) {}

AudioBuffer::~AudioBuffer() = default;

void AudioBuffer::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sample_format"), this->sample_format, 
      "<value of type SampleFormat>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "channel_layout"), this->channel_layout, 
      "<value of type ChannelLayout>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "channel_count"), this->channel_count, 
      "<value of type int32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sample_rate"), this->sample_rate, 
      "<value of type int32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_count"), this->frame_count, 
      "<value of type int32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "end_of_stream"), this->end_of_stream, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "timestamp"), this->timestamp, 
      "<value of type ::base::TimeDelta>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data"), this->data, 
      "<value of type const WTF::Vector<uint8_t>&>");
}

bool AudioBuffer::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AudioDataS16::AudioDataS16()
    : channel_count(),
      sample_rate(),
      frame_count(),
      data() {}

AudioDataS16::AudioDataS16(
    int32_t channel_count_in,
    int32_t sample_rate_in,
    int32_t frame_count_in,
    WTF::Vector<int16_t> data_in)
    : channel_count(std::move(channel_count_in)),
      sample_rate(std::move(sample_rate_in)),
      frame_count(std::move(frame_count_in)),
      data(std::move(data_in)) {}

AudioDataS16::~AudioDataS16() = default;

void AudioDataS16::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "channel_count"), this->channel_count, 
      "<value of type int32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sample_rate"), this->sample_rate, 
      "<value of type int32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_count"), this->frame_count, 
      "<value of type int32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data"), this->data, 
      "<value of type const WTF::Vector<int16_t>&>");
}

bool AudioDataS16::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VideoFrameMetadata::VideoFrameMetadata()
    : allow_overlay(),
      capture_begin_time(),
      capture_end_time(),
      has_capture_counter(),
      capture_counter(),
      capture_update_rect(),
      has_copy_mode(),
      copy_mode(),
      end_of_stream(),
      frame_duration(),
      has_frame_rate(),
      frame_rate(),
      interactive_content(),
      reference_time(),
      read_lock_fences_enabled(),
      transformation(),
      texture_owner(),
      wants_promotion_hint(),
      protected_video(),
      hw_protected(),
      overlay_plane_id(),
      power_efficient(),
      has_device_scale_factor(),
      device_scale_factor(),
      has_page_scale_factor(),
      page_scale_factor(),
      has_root_scroll_offset_x(),
      root_scroll_offset_x(),
      has_root_scroll_offset_y(),
      root_scroll_offset_y(),
      has_top_controls_visible_height(),
      top_controls_visible_height(),
      decode_begin_time(),
      decode_end_time(),
      processing_time(),
      has_rtp_timestamp(),
      rtp_timestamp(),
      receive_time(),
      wallclock_frame_duration(),
      hw_protected_validation_id() {}

VideoFrameMetadata::VideoFrameMetadata(
    bool allow_overlay_in,
    base::Optional<::base::TimeTicks> capture_begin_time_in,
    base::Optional<::base::TimeTicks> capture_end_time_in,
    bool has_capture_counter_in,
    int32_t capture_counter_in,
    const base::Optional<::gfx::Rect>& capture_update_rect_in,
    bool has_copy_mode_in,
    CopyMode copy_mode_in,
    bool end_of_stream_in,
    base::Optional<::base::TimeDelta> frame_duration_in,
    bool has_frame_rate_in,
    double frame_rate_in,
    bool interactive_content_in,
    base::Optional<::base::TimeTicks> reference_time_in,
    bool read_lock_fences_enabled_in,
    VideoTransformationPtr transformation_in,
    bool texture_owner_in,
    bool wants_promotion_hint_in,
    bool protected_video_in,
    bool hw_protected_in,
    const base::Optional<::base::UnguessableToken>& overlay_plane_id_in,
    bool power_efficient_in,
    bool has_device_scale_factor_in,
    double device_scale_factor_in,
    bool has_page_scale_factor_in,
    double page_scale_factor_in,
    bool has_root_scroll_offset_x_in,
    double root_scroll_offset_x_in,
    bool has_root_scroll_offset_y_in,
    double root_scroll_offset_y_in,
    bool has_top_controls_visible_height_in,
    double top_controls_visible_height_in,
    base::Optional<::base::TimeTicks> decode_begin_time_in,
    base::Optional<::base::TimeTicks> decode_end_time_in,
    base::Optional<::base::TimeDelta> processing_time_in,
    bool has_rtp_timestamp_in,
    double rtp_timestamp_in,
    base::Optional<::base::TimeTicks> receive_time_in,
    base::Optional<::base::TimeDelta> wallclock_frame_duration_in,
    uint32_t hw_protected_validation_id_in)
    : allow_overlay(std::move(allow_overlay_in)),
      capture_begin_time(std::move(capture_begin_time_in)),
      capture_end_time(std::move(capture_end_time_in)),
      has_capture_counter(std::move(has_capture_counter_in)),
      capture_counter(std::move(capture_counter_in)),
      capture_update_rect(std::move(capture_update_rect_in)),
      has_copy_mode(std::move(has_copy_mode_in)),
      copy_mode(std::move(copy_mode_in)),
      end_of_stream(std::move(end_of_stream_in)),
      frame_duration(std::move(frame_duration_in)),
      has_frame_rate(std::move(has_frame_rate_in)),
      frame_rate(std::move(frame_rate_in)),
      interactive_content(std::move(interactive_content_in)),
      reference_time(std::move(reference_time_in)),
      read_lock_fences_enabled(std::move(read_lock_fences_enabled_in)),
      transformation(std::move(transformation_in)),
      texture_owner(std::move(texture_owner_in)),
      wants_promotion_hint(std::move(wants_promotion_hint_in)),
      protected_video(std::move(protected_video_in)),
      hw_protected(std::move(hw_protected_in)),
      overlay_plane_id(std::move(overlay_plane_id_in)),
      power_efficient(std::move(power_efficient_in)),
      has_device_scale_factor(std::move(has_device_scale_factor_in)),
      device_scale_factor(std::move(device_scale_factor_in)),
      has_page_scale_factor(std::move(has_page_scale_factor_in)),
      page_scale_factor(std::move(page_scale_factor_in)),
      has_root_scroll_offset_x(std::move(has_root_scroll_offset_x_in)),
      root_scroll_offset_x(std::move(root_scroll_offset_x_in)),
      has_root_scroll_offset_y(std::move(has_root_scroll_offset_y_in)),
      root_scroll_offset_y(std::move(root_scroll_offset_y_in)),
      has_top_controls_visible_height(std::move(has_top_controls_visible_height_in)),
      top_controls_visible_height(std::move(top_controls_visible_height_in)),
      decode_begin_time(std::move(decode_begin_time_in)),
      decode_end_time(std::move(decode_end_time_in)),
      processing_time(std::move(processing_time_in)),
      has_rtp_timestamp(std::move(has_rtp_timestamp_in)),
      rtp_timestamp(std::move(rtp_timestamp_in)),
      receive_time(std::move(receive_time_in)),
      wallclock_frame_duration(std::move(wallclock_frame_duration_in)),
      hw_protected_validation_id(std::move(hw_protected_validation_id_in)) {}

VideoFrameMetadata::~VideoFrameMetadata() = default;

void VideoFrameMetadata::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_overlay"), this->allow_overlay, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "capture_begin_time"), this->capture_begin_time, 
      "<value of type base::Optional<::base::TimeTicks>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "capture_end_time"), this->capture_end_time, 
      "<value of type base::Optional<::base::TimeTicks>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_capture_counter"), this->has_capture_counter, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "capture_counter"), this->capture_counter, 
      "<value of type int32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "capture_update_rect"), this->capture_update_rect, 
      "<value of type const base::Optional<::gfx::Rect>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_copy_mode"), this->has_copy_mode, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "copy_mode"), this->copy_mode, 
      "<value of type CopyMode>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "end_of_stream"), this->end_of_stream, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_duration"), this->frame_duration, 
      "<value of type base::Optional<::base::TimeDelta>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_frame_rate"), this->has_frame_rate, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_rate"), this->frame_rate, 
      "<value of type double>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "interactive_content"), this->interactive_content, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reference_time"), this->reference_time, 
      "<value of type base::Optional<::base::TimeTicks>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "read_lock_fences_enabled"), this->read_lock_fences_enabled, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "transformation"), this->transformation, 
      "<value of type VideoTransformationPtr>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "texture_owner"), this->texture_owner, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "wants_promotion_hint"), this->wants_promotion_hint, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "protected_video"), this->protected_video, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hw_protected"), this->hw_protected, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "overlay_plane_id"), this->overlay_plane_id, 
      "<value of type const base::Optional<::base::UnguessableToken>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "power_efficient"), this->power_efficient, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_device_scale_factor"), this->has_device_scale_factor, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "device_scale_factor"), this->device_scale_factor, 
      "<value of type double>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_page_scale_factor"), this->has_page_scale_factor, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "page_scale_factor"), this->page_scale_factor, 
      "<value of type double>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_root_scroll_offset_x"), this->has_root_scroll_offset_x, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "root_scroll_offset_x"), this->root_scroll_offset_x, 
      "<value of type double>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_root_scroll_offset_y"), this->has_root_scroll_offset_y, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "root_scroll_offset_y"), this->root_scroll_offset_y, 
      "<value of type double>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_top_controls_visible_height"), this->has_top_controls_visible_height, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "top_controls_visible_height"), this->top_controls_visible_height, 
      "<value of type double>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "decode_begin_time"), this->decode_begin_time, 
      "<value of type base::Optional<::base::TimeTicks>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "decode_end_time"), this->decode_end_time, 
      "<value of type base::Optional<::base::TimeTicks>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "processing_time"), this->processing_time, 
      "<value of type base::Optional<::base::TimeDelta>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_rtp_timestamp"), this->has_rtp_timestamp, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rtp_timestamp"), this->rtp_timestamp, 
      "<value of type double>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "receive_time"), this->receive_time, 
      "<value of type base::Optional<::base::TimeTicks>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "wallclock_frame_duration"), this->wallclock_frame_duration, 
      "<value of type base::Optional<::base::TimeDelta>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hw_protected_validation_id"), this->hw_protected_validation_id, 
      "<value of type uint32_t>");
}

bool VideoFrameMetadata::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VideoFrame::VideoFrame()
    : format(),
      coded_size(),
      visible_rect(),
      natural_size(),
      timestamp(),
      data(),
      metadata(),
      color_space(),
      hdr_metadata() {}

VideoFrame::VideoFrame(
    VideoPixelFormat format_in,
    const ::gfx::Size& coded_size_in,
    const ::gfx::Rect& visible_rect_in,
    const ::gfx::Size& natural_size_in,
    ::base::TimeDelta timestamp_in,
    VideoFrameDataPtr data_in,
    const ::media::VideoFrameMetadata& metadata_in,
    const ::gfx::ColorSpace& color_space_in,
    ::gfx::mojom::blink::HDRMetadataPtr hdr_metadata_in)
    : format(std::move(format_in)),
      coded_size(std::move(coded_size_in)),
      visible_rect(std::move(visible_rect_in)),
      natural_size(std::move(natural_size_in)),
      timestamp(std::move(timestamp_in)),
      data(std::move(data_in)),
      metadata(std::move(metadata_in)),
      color_space(std::move(color_space_in)),
      hdr_metadata(std::move(hdr_metadata_in)) {}

VideoFrame::~VideoFrame() = default;

void VideoFrame::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "format"), this->format, 
      "<value of type VideoPixelFormat>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "coded_size"), this->coded_size, 
      "<value of type const ::gfx::Size&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "visible_rect"), this->visible_rect, 
      "<value of type const ::gfx::Rect&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "natural_size"), this->natural_size, 
      "<value of type const ::gfx::Size&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "timestamp"), this->timestamp, 
      "<value of type ::base::TimeDelta>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data"), this->data, 
      "<value of type VideoFrameDataPtr>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "metadata"), this->metadata, 
      "<value of type const ::media::VideoFrameMetadata&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "color_space"), this->color_space, 
      "<value of type const ::gfx::ColorSpace&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hdr_metadata"), this->hdr_metadata, 
      "<value of type ::gfx::mojom::blink::HDRMetadataPtr>");
}

bool VideoFrame::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
EosVideoFrameData::EosVideoFrameData() {}

EosVideoFrameData::~EosVideoFrameData() = default;
size_t EosVideoFrameData::Hash(size_t seed) const {
  return seed;
}

void EosVideoFrameData::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
}

bool EosVideoFrameData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SharedBufferVideoFrameData::SharedBufferVideoFrameData()
    : frame_data(),
      frame_data_size(),
      strides(),
      offsets() {}

SharedBufferVideoFrameData::SharedBufferVideoFrameData(
    ::mojo::ScopedSharedBufferHandle frame_data_in,
    uint64_t frame_data_size_in,
    WTF::Vector<int32_t> strides_in,
    WTF::Vector<uint32_t> offsets_in)
    : frame_data(std::move(frame_data_in)),
      frame_data_size(std::move(frame_data_size_in)),
      strides(std::move(strides_in)),
      offsets(std::move(offsets_in)) {}

SharedBufferVideoFrameData::~SharedBufferVideoFrameData() = default;

void SharedBufferVideoFrameData::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_data"), this->frame_data, 
      "<value of type ::mojo::ScopedSharedBufferHandle>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_data_size"), this->frame_data_size, 
      "<value of type uint64_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "strides"), this->strides, 
      "<value of type const WTF::Vector<int32_t>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "offsets"), this->offsets, 
      "<value of type const WTF::Vector<uint32_t>&>");
}

bool SharedBufferVideoFrameData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DmabufVideoFrameData::DmabufVideoFrameData()
    : dmabuf_fds() {}

DmabufVideoFrameData::DmabufVideoFrameData(
    WTF::Vector<::mojo::PlatformHandle> dmabuf_fds_in)
    : dmabuf_fds(std::move(dmabuf_fds_in)) {}

DmabufVideoFrameData::~DmabufVideoFrameData() = default;

void DmabufVideoFrameData::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "dmabuf_fds"), this->dmabuf_fds, 
      "<value of type WTF::Vector<::mojo::PlatformHandle>>");
}

bool DmabufVideoFrameData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
GpuMemoryBufferVideoFrameData::GpuMemoryBufferVideoFrameData()
    : gpu_memory_buffer_handle(),
      mailbox_holder() {}

GpuMemoryBufferVideoFrameData::GpuMemoryBufferVideoFrameData(
    ::gfx::GpuMemoryBufferHandle gpu_memory_buffer_handle_in,
    WTF::Vector<::gpu::MailboxHolder> mailbox_holder_in)
    : gpu_memory_buffer_handle(std::move(gpu_memory_buffer_handle_in)),
      mailbox_holder(std::move(mailbox_holder_in)) {}

GpuMemoryBufferVideoFrameData::~GpuMemoryBufferVideoFrameData() = default;

void GpuMemoryBufferVideoFrameData::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "gpu_memory_buffer_handle"), this->gpu_memory_buffer_handle, 
      "<value of type ::gfx::GpuMemoryBufferHandle>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mailbox_holder"), this->mailbox_holder, 
      "<value of type const WTF::Vector<::gpu::MailboxHolder>&>");
}

bool GpuMemoryBufferVideoFrameData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
MailboxVideoFrameData::MailboxVideoFrameData()
    : mailbox_holder(),
      ycbcr_data() {}

MailboxVideoFrameData::MailboxVideoFrameData(
    WTF::Vector<::gpu::MailboxHolder> mailbox_holder_in,
    ::gpu::mojom::blink::VulkanYCbCrInfoPtr ycbcr_data_in)
    : mailbox_holder(std::move(mailbox_holder_in)),
      ycbcr_data(std::move(ycbcr_data_in)) {}

MailboxVideoFrameData::~MailboxVideoFrameData() = default;

void MailboxVideoFrameData::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mailbox_holder"), this->mailbox_holder, 
      "<value of type const WTF::Vector<::gpu::MailboxHolder>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ycbcr_data"), this->ycbcr_data, 
      "<value of type ::gpu::mojom::blink::VulkanYCbCrInfoPtr>");
}

bool MailboxVideoFrameData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PipelineStatistics::PipelineStatistics()
    : audio_bytes_decoded(),
      video_bytes_decoded(),
      video_frames_decoded(),
      video_frames_dropped(),
      audio_memory_usage(),
      video_memory_usage() {}

PipelineStatistics::PipelineStatistics(
    uint64_t audio_bytes_decoded_in,
    uint64_t video_bytes_decoded_in,
    uint32_t video_frames_decoded_in,
    uint32_t video_frames_dropped_in,
    int64_t audio_memory_usage_in,
    int64_t video_memory_usage_in)
    : audio_bytes_decoded(std::move(audio_bytes_decoded_in)),
      video_bytes_decoded(std::move(video_bytes_decoded_in)),
      video_frames_decoded(std::move(video_frames_decoded_in)),
      video_frames_dropped(std::move(video_frames_dropped_in)),
      audio_memory_usage(std::move(audio_memory_usage_in)),
      video_memory_usage(std::move(video_memory_usage_in)) {}

PipelineStatistics::~PipelineStatistics() = default;
size_t PipelineStatistics::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->audio_bytes_decoded);
  seed = mojo::internal::WTFHash(seed, this->video_bytes_decoded);
  seed = mojo::internal::WTFHash(seed, this->video_frames_decoded);
  seed = mojo::internal::WTFHash(seed, this->video_frames_dropped);
  seed = mojo::internal::WTFHash(seed, this->audio_memory_usage);
  seed = mojo::internal::WTFHash(seed, this->video_memory_usage);
  return seed;
}

void PipelineStatistics::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "audio_bytes_decoded"), this->audio_bytes_decoded, 
      "<value of type uint64_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "video_bytes_decoded"), this->video_bytes_decoded, 
      "<value of type uint64_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "video_frames_decoded"), this->video_frames_decoded, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "video_frames_dropped"), this->video_frames_dropped, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "audio_memory_usage"), this->audio_memory_usage, 
      "<value of type int64_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "video_memory_usage"), this->video_memory_usage, 
      "<value of type int64_t>");
}

bool PipelineStatistics::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PredictionFeatures::PredictionFeatures()
    : profile(),
      video_size(),
      frames_per_sec(0),
      key_system(),
      use_hw_secure_codecs(false) {}

PredictionFeatures::PredictionFeatures(
    VideoCodecProfile profile_in,
    const ::gfx::Size& video_size_in,
    double frames_per_sec_in,
    const WTF::String& key_system_in,
    bool use_hw_secure_codecs_in)
    : profile(std::move(profile_in)),
      video_size(std::move(video_size_in)),
      frames_per_sec(std::move(frames_per_sec_in)),
      key_system(std::move(key_system_in)),
      use_hw_secure_codecs(std::move(use_hw_secure_codecs_in)) {}

PredictionFeatures::~PredictionFeatures() = default;

void PredictionFeatures::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "profile"), this->profile, 
      "<value of type VideoCodecProfile>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "video_size"), this->video_size, 
      "<value of type const ::gfx::Size&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frames_per_sec"), this->frames_per_sec, 
      "<value of type double>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "key_system"), this->key_system, 
      "<value of type const WTF::String&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "use_hw_secure_codecs"), this->use_hw_secure_codecs, 
      "<value of type bool>");
}

bool PredictionFeatures::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PredictionTargets::PredictionTargets()
    : frames_decoded(0U),
      frames_dropped(0U),
      frames_power_efficient(0U) {}

PredictionTargets::PredictionTargets(
    uint32_t frames_decoded_in,
    uint32_t frames_dropped_in,
    uint32_t frames_power_efficient_in)
    : frames_decoded(std::move(frames_decoded_in)),
      frames_dropped(std::move(frames_dropped_in)),
      frames_power_efficient(std::move(frames_power_efficient_in)) {}

PredictionTargets::~PredictionTargets() = default;
size_t PredictionTargets::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->frames_decoded);
  seed = mojo::internal::WTFHash(seed, this->frames_dropped);
  seed = mojo::internal::WTFHash(seed, this->frames_power_efficient);
  return seed;
}

void PredictionTargets::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frames_decoded"), this->frames_decoded, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frames_dropped"), this->frames_dropped, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frames_power_efficient"), this->frames_power_efficient, 
      "<value of type uint32_t>");
}

bool PredictionTargets::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AudioDecoderInfo::AudioDecoderInfo()
    : decoder_type(),
      is_platform_decoder(false),
      has_decrypting_demuxer_stream(false) {}

AudioDecoderInfo::AudioDecoderInfo(
    AudioDecoderType decoder_type_in,
    bool is_platform_decoder_in,
    bool has_decrypting_demuxer_stream_in)
    : decoder_type(std::move(decoder_type_in)),
      is_platform_decoder(std::move(is_platform_decoder_in)),
      has_decrypting_demuxer_stream(std::move(has_decrypting_demuxer_stream_in)) {}

AudioDecoderInfo::~AudioDecoderInfo() = default;
size_t AudioDecoderInfo::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->decoder_type);
  seed = mojo::internal::WTFHash(seed, this->is_platform_decoder);
  seed = mojo::internal::WTFHash(seed, this->has_decrypting_demuxer_stream);
  return seed;
}

void AudioDecoderInfo::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "decoder_type"), this->decoder_type, 
      "<value of type AudioDecoderType>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_platform_decoder"), this->is_platform_decoder, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_decrypting_demuxer_stream"), this->has_decrypting_demuxer_stream, 
      "<value of type bool>");
}

bool AudioDecoderInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VideoDecoderInfo::VideoDecoderInfo()
    : decoder_type(),
      is_platform_decoder(false),
      has_decrypting_demuxer_stream(false) {}

VideoDecoderInfo::VideoDecoderInfo(
    VideoDecoderType decoder_type_in,
    bool is_platform_decoder_in,
    bool has_decrypting_demuxer_stream_in)
    : decoder_type(std::move(decoder_type_in)),
      is_platform_decoder(std::move(is_platform_decoder_in)),
      has_decrypting_demuxer_stream(std::move(has_decrypting_demuxer_stream_in)) {}

VideoDecoderInfo::~VideoDecoderInfo() = default;
size_t VideoDecoderInfo::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->decoder_type);
  seed = mojo::internal::WTFHash(seed, this->is_platform_decoder);
  seed = mojo::internal::WTFHash(seed, this->has_decrypting_demuxer_stream);
  return seed;
}

void VideoDecoderInfo::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "decoder_type"), this->decoder_type, 
      "<value of type VideoDecoderType>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_platform_decoder"), this->is_platform_decoder, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_decrypting_demuxer_stream"), this->has_decrypting_demuxer_stream, 
      "<value of type bool>");
}

bool VideoDecoderInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Status::Status()
    : code(),
      message(),
      frames(),
      causes(),
      data() {}

Status::Status(
    StatusCode code_in,
    const WTF::String& message_in,
    WTF::Vector<::base::Value> frames_in,
    WTF::Vector<StatusPtr> causes_in,
    base::Optional<::base::Value> data_in)
    : code(std::move(code_in)),
      message(std::move(message_in)),
      frames(std::move(frames_in)),
      causes(std::move(causes_in)),
      data(std::move(data_in)) {}

Status::~Status() = default;

void Status::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "code"), this->code, 
      "<value of type StatusCode>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "message"), this->message, 
      "<value of type const WTF::String&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frames"), this->frames, 
      "<value of type WTF::Vector<::base::Value>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "causes"), this->causes, 
      "<value of type WTF::Vector<StatusPtr>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data"), this->data, 
      "<value of type base::Optional<::base::Value>>");
}

bool Status::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VideoFrameData::VideoFrameData() : tag_(Tag::EOS_DATA) {
  data_.eos_data = new EosVideoFrameDataPtr;
}

VideoFrameData::~VideoFrameData() {
  DestroyActive();
}


void VideoFrameData::set_eos_data(
    EosVideoFrameDataPtr eos_data) {
  if (tag_ == Tag::EOS_DATA) {
    *(data_.eos_data) = std::move(eos_data);
  } else {
    DestroyActive();
    tag_ = Tag::EOS_DATA;
    data_.eos_data = new EosVideoFrameDataPtr(
        std::move(eos_data));
  }
}
void VideoFrameData::set_shared_buffer_data(
    SharedBufferVideoFrameDataPtr shared_buffer_data) {
  if (tag_ == Tag::SHARED_BUFFER_DATA) {
    *(data_.shared_buffer_data) = std::move(shared_buffer_data);
  } else {
    DestroyActive();
    tag_ = Tag::SHARED_BUFFER_DATA;
    data_.shared_buffer_data = new SharedBufferVideoFrameDataPtr(
        std::move(shared_buffer_data));
  }
}
void VideoFrameData::set_dmabuf_data(
    DmabufVideoFrameDataPtr dmabuf_data) {
  if (tag_ == Tag::DMABUF_DATA) {
    *(data_.dmabuf_data) = std::move(dmabuf_data);
  } else {
    DestroyActive();
    tag_ = Tag::DMABUF_DATA;
    data_.dmabuf_data = new DmabufVideoFrameDataPtr(
        std::move(dmabuf_data));
  }
}
void VideoFrameData::set_gpu_memory_buffer_data(
    GpuMemoryBufferVideoFrameDataPtr gpu_memory_buffer_data) {
  if (tag_ == Tag::GPU_MEMORY_BUFFER_DATA) {
    *(data_.gpu_memory_buffer_data) = std::move(gpu_memory_buffer_data);
  } else {
    DestroyActive();
    tag_ = Tag::GPU_MEMORY_BUFFER_DATA;
    data_.gpu_memory_buffer_data = new GpuMemoryBufferVideoFrameDataPtr(
        std::move(gpu_memory_buffer_data));
  }
}
void VideoFrameData::set_mailbox_data(
    MailboxVideoFrameDataPtr mailbox_data) {
  if (tag_ == Tag::MAILBOX_DATA) {
    *(data_.mailbox_data) = std::move(mailbox_data);
  } else {
    DestroyActive();
    tag_ = Tag::MAILBOX_DATA;
    data_.mailbox_data = new MailboxVideoFrameDataPtr(
        std::move(mailbox_data));
  }
}

void VideoFrameData::DestroyActive() {
  switch (tag_) {

    case Tag::EOS_DATA:

      delete data_.eos_data;
      break;
    case Tag::SHARED_BUFFER_DATA:

      delete data_.shared_buffer_data;
      break;
    case Tag::DMABUF_DATA:

      delete data_.dmabuf_data;
      break;
    case Tag::GPU_MEMORY_BUFFER_DATA:

      delete data_.gpu_memory_buffer_data;
      break;
    case Tag::MAILBOX_DATA:

      delete data_.mailbox_data;
      break;
  }
}

bool VideoFrameData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
}  // namespace blink
}  // namespace mojom
}  // namespace media

namespace mojo {


// static
bool StructTraits<::media::mojom::blink::VideoTransformation::DataView, ::media::mojom::blink::VideoTransformationPtr>::Read(
    ::media::mojom::blink::VideoTransformation::DataView input,
    ::media::mojom::blink::VideoTransformationPtr* output) {
  bool success = true;
  ::media::mojom::blink::VideoTransformationPtr result(::media::mojom::blink::VideoTransformation::New());
  
      if (success && !input.ReadRotation(&result->rotation))
        success = false;
      if (success)
        result->mirrored = input.mirrored();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::blink::EncryptionPattern::DataView, ::media::mojom::blink::EncryptionPatternPtr>::Read(
    ::media::mojom::blink::EncryptionPattern::DataView input,
    ::media::mojom::blink::EncryptionPatternPtr* output) {
  bool success = true;
  ::media::mojom::blink::EncryptionPatternPtr result(::media::mojom::blink::EncryptionPattern::New());
  
      if (success)
        result->crypt_byte_block = input.crypt_byte_block();
      if (success)
        result->skip_byte_block = input.skip_byte_block();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::blink::VideoColorSpace::DataView, ::media::mojom::blink::VideoColorSpacePtr>::Read(
    ::media::mojom::blink::VideoColorSpace::DataView input,
    ::media::mojom::blink::VideoColorSpacePtr* output) {
  bool success = true;
  ::media::mojom::blink::VideoColorSpacePtr result(::media::mojom::blink::VideoColorSpace::New());
  
      if (success && !input.ReadPrimaries(&result->primaries))
        success = false;
      if (success && !input.ReadTransfer(&result->transfer))
        success = false;
      if (success && !input.ReadMatrix(&result->matrix))
        success = false;
      if (success && !input.ReadRange(&result->range))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::blink::AudioDecoderConfig::DataView, ::media::mojom::blink::AudioDecoderConfigPtr>::Read(
    ::media::mojom::blink::AudioDecoderConfig::DataView input,
    ::media::mojom::blink::AudioDecoderConfigPtr* output) {
  bool success = true;
  ::media::mojom::blink::AudioDecoderConfigPtr result(::media::mojom::blink::AudioDecoderConfig::New());
  
      if (success && !input.ReadCodec(&result->codec))
        success = false;
      if (success && !input.ReadProfile(&result->profile))
        success = false;
      if (success && !input.ReadSampleFormat(&result->sample_format))
        success = false;
      if (success && !input.ReadChannelLayout(&result->channel_layout))
        success = false;
      if (success)
        result->samples_per_second = input.samples_per_second();
      if (success && !input.ReadExtraData(&result->extra_data))
        success = false;
      if (success && !input.ReadSeekPreroll(&result->seek_preroll))
        success = false;
      if (success)
        result->codec_delay = input.codec_delay();
      if (success && !input.ReadEncryptionScheme(&result->encryption_scheme))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::blink::VideoDecoderConfig::DataView, ::media::mojom::blink::VideoDecoderConfigPtr>::Read(
    ::media::mojom::blink::VideoDecoderConfig::DataView input,
    ::media::mojom::blink::VideoDecoderConfigPtr* output) {
  bool success = true;
  ::media::mojom::blink::VideoDecoderConfigPtr result(::media::mojom::blink::VideoDecoderConfig::New());
  
      if (success && !input.ReadCodec(&result->codec))
        success = false;
      if (success && !input.ReadProfile(&result->profile))
        success = false;
      if (success)
        result->level = input.level();
      if (success)
        result->has_alpha = input.has_alpha();
      if (success && !input.ReadTransformation(&result->transformation))
        success = false;
      if (success && !input.ReadCodedSize(&result->coded_size))
        success = false;
      if (success && !input.ReadVisibleRect(&result->visible_rect))
        success = false;
      if (success && !input.ReadNaturalSize(&result->natural_size))
        success = false;
      if (success && !input.ReadExtraData(&result->extra_data))
        success = false;
      if (success && !input.ReadEncryptionScheme(&result->encryption_scheme))
        success = false;
      if (success && !input.ReadColorSpaceInfo(&result->color_space_info))
        success = false;
      if (success && !input.ReadHdrMetadata(&result->hdr_metadata))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::blink::DecryptConfig::DataView, ::media::mojom::blink::DecryptConfigPtr>::Read(
    ::media::mojom::blink::DecryptConfig::DataView input,
    ::media::mojom::blink::DecryptConfigPtr* output) {
  bool success = true;
  ::media::mojom::blink::DecryptConfigPtr result(::media::mojom::blink::DecryptConfig::New());
  
      if (success && !input.ReadEncryptionScheme(&result->encryption_scheme))
        success = false;
      if (success && !input.ReadKeyId(&result->key_id))
        success = false;
      if (success && !input.ReadIv(&result->iv))
        success = false;
      if (success && !input.ReadSubsamples(&result->subsamples))
        success = false;
      if (success && !input.ReadEncryptionPattern(&result->encryption_pattern))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::blink::DecoderBuffer::DataView, ::media::mojom::blink::DecoderBufferPtr>::Read(
    ::media::mojom::blink::DecoderBuffer::DataView input,
    ::media::mojom::blink::DecoderBufferPtr* output) {
  bool success = true;
  ::media::mojom::blink::DecoderBufferPtr result(::media::mojom::blink::DecoderBuffer::New());
  
      if (success && !input.ReadTimestamp(&result->timestamp))
        success = false;
      if (success && !input.ReadDuration(&result->duration))
        success = false;
      if (success)
        result->is_end_of_stream = input.is_end_of_stream();
      if (success)
        result->data_size = input.data_size();
      if (success)
        result->is_key_frame = input.is_key_frame();
      if (success && !input.ReadSideData(&result->side_data))
        success = false;
      if (success && !input.ReadDecryptConfig(&result->decrypt_config))
        success = false;
      if (success && !input.ReadFrontDiscard(&result->front_discard))
        success = false;
      if (success && !input.ReadBackDiscard(&result->back_discard))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::blink::AudioBuffer::DataView, ::media::mojom::blink::AudioBufferPtr>::Read(
    ::media::mojom::blink::AudioBuffer::DataView input,
    ::media::mojom::blink::AudioBufferPtr* output) {
  bool success = true;
  ::media::mojom::blink::AudioBufferPtr result(::media::mojom::blink::AudioBuffer::New());
  
      if (success && !input.ReadSampleFormat(&result->sample_format))
        success = false;
      if (success && !input.ReadChannelLayout(&result->channel_layout))
        success = false;
      if (success)
        result->channel_count = input.channel_count();
      if (success)
        result->sample_rate = input.sample_rate();
      if (success)
        result->frame_count = input.frame_count();
      if (success)
        result->end_of_stream = input.end_of_stream();
      if (success && !input.ReadTimestamp(&result->timestamp))
        success = false;
      if (success && !input.ReadData(&result->data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::blink::AudioDataS16::DataView, ::media::mojom::blink::AudioDataS16Ptr>::Read(
    ::media::mojom::blink::AudioDataS16::DataView input,
    ::media::mojom::blink::AudioDataS16Ptr* output) {
  bool success = true;
  ::media::mojom::blink::AudioDataS16Ptr result(::media::mojom::blink::AudioDataS16::New());
  
      if (success)
        result->channel_count = input.channel_count();
      if (success)
        result->sample_rate = input.sample_rate();
      if (success)
        result->frame_count = input.frame_count();
      if (success && !input.ReadData(&result->data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::blink::VideoFrameMetadata::DataView, ::media::mojom::blink::VideoFrameMetadataPtr>::Read(
    ::media::mojom::blink::VideoFrameMetadata::DataView input,
    ::media::mojom::blink::VideoFrameMetadataPtr* output) {
  bool success = true;
  ::media::mojom::blink::VideoFrameMetadataPtr result(::media::mojom::blink::VideoFrameMetadata::New());
  
      if (success)
        result->allow_overlay = input.allow_overlay();
      if (success && !input.ReadCaptureBeginTime(&result->capture_begin_time))
        success = false;
      if (success && !input.ReadCaptureEndTime(&result->capture_end_time))
        success = false;
      if (success)
        result->has_capture_counter = input.has_capture_counter();
      if (success)
        result->capture_counter = input.capture_counter();
      if (success && !input.ReadCaptureUpdateRect(&result->capture_update_rect))
        success = false;
      if (success)
        result->has_copy_mode = input.has_copy_mode();
      if (success && !input.ReadCopyMode(&result->copy_mode))
        success = false;
      if (success)
        result->end_of_stream = input.end_of_stream();
      if (success && !input.ReadFrameDuration(&result->frame_duration))
        success = false;
      if (success)
        result->has_frame_rate = input.has_frame_rate();
      if (success)
        result->frame_rate = input.frame_rate();
      if (success)
        result->interactive_content = input.interactive_content();
      if (success && !input.ReadReferenceTime(&result->reference_time))
        success = false;
      if (success)
        result->read_lock_fences_enabled = input.read_lock_fences_enabled();
      if (success && !input.ReadTransformation(&result->transformation))
        success = false;
      if (success)
        result->texture_owner = input.texture_owner();
      if (success)
        result->wants_promotion_hint = input.wants_promotion_hint();
      if (success)
        result->protected_video = input.protected_video();
      if (success)
        result->hw_protected = input.hw_protected();
      if (success && !input.ReadOverlayPlaneId(&result->overlay_plane_id))
        success = false;
      if (success)
        result->power_efficient = input.power_efficient();
      if (success)
        result->has_device_scale_factor = input.has_device_scale_factor();
      if (success)
        result->device_scale_factor = input.device_scale_factor();
      if (success)
        result->has_page_scale_factor = input.has_page_scale_factor();
      if (success)
        result->page_scale_factor = input.page_scale_factor();
      if (success)
        result->has_root_scroll_offset_x = input.has_root_scroll_offset_x();
      if (success)
        result->root_scroll_offset_x = input.root_scroll_offset_x();
      if (success)
        result->has_root_scroll_offset_y = input.has_root_scroll_offset_y();
      if (success)
        result->root_scroll_offset_y = input.root_scroll_offset_y();
      if (success)
        result->has_top_controls_visible_height = input.has_top_controls_visible_height();
      if (success)
        result->top_controls_visible_height = input.top_controls_visible_height();
      if (success && !input.ReadDecodeBeginTime(&result->decode_begin_time))
        success = false;
      if (success && !input.ReadDecodeEndTime(&result->decode_end_time))
        success = false;
      if (success && !input.ReadProcessingTime(&result->processing_time))
        success = false;
      if (success)
        result->has_rtp_timestamp = input.has_rtp_timestamp();
      if (success)
        result->rtp_timestamp = input.rtp_timestamp();
      if (success && !input.ReadReceiveTime(&result->receive_time))
        success = false;
      if (success && !input.ReadWallclockFrameDuration(&result->wallclock_frame_duration))
        success = false;
      if (success)
        result->hw_protected_validation_id = input.hw_protected_validation_id();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::blink::VideoFrame::DataView, ::media::mojom::blink::VideoFramePtr>::Read(
    ::media::mojom::blink::VideoFrame::DataView input,
    ::media::mojom::blink::VideoFramePtr* output) {
  bool success = true;
  ::media::mojom::blink::VideoFramePtr result(::media::mojom::blink::VideoFrame::New());
  
      if (success && !input.ReadFormat(&result->format))
        success = false;
      if (success && !input.ReadCodedSize(&result->coded_size))
        success = false;
      if (success && !input.ReadVisibleRect(&result->visible_rect))
        success = false;
      if (success && !input.ReadNaturalSize(&result->natural_size))
        success = false;
      if (success && !input.ReadTimestamp(&result->timestamp))
        success = false;
      if (success && !input.ReadData(&result->data))
        success = false;
      if (success && !input.ReadMetadata(&result->metadata))
        success = false;
      if (success && !input.ReadColorSpace(&result->color_space))
        success = false;
      if (success && !input.ReadHdrMetadata(&result->hdr_metadata))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::blink::EosVideoFrameData::DataView, ::media::mojom::blink::EosVideoFrameDataPtr>::Read(
    ::media::mojom::blink::EosVideoFrameData::DataView input,
    ::media::mojom::blink::EosVideoFrameDataPtr* output) {
  bool success = true;
  ::media::mojom::blink::EosVideoFrameDataPtr result(::media::mojom::blink::EosVideoFrameData::New());
  
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::blink::SharedBufferVideoFrameData::DataView, ::media::mojom::blink::SharedBufferVideoFrameDataPtr>::Read(
    ::media::mojom::blink::SharedBufferVideoFrameData::DataView input,
    ::media::mojom::blink::SharedBufferVideoFrameDataPtr* output) {
  bool success = true;
  ::media::mojom::blink::SharedBufferVideoFrameDataPtr result(::media::mojom::blink::SharedBufferVideoFrameData::New());
  
      if (success)
        result->frame_data = input.TakeFrameData();
      if (success)
        result->frame_data_size = input.frame_data_size();
      if (success && !input.ReadStrides(&result->strides))
        success = false;
      if (success && !input.ReadOffsets(&result->offsets))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::blink::DmabufVideoFrameData::DataView, ::media::mojom::blink::DmabufVideoFrameDataPtr>::Read(
    ::media::mojom::blink::DmabufVideoFrameData::DataView input,
    ::media::mojom::blink::DmabufVideoFrameDataPtr* output) {
  bool success = true;
  ::media::mojom::blink::DmabufVideoFrameDataPtr result(::media::mojom::blink::DmabufVideoFrameData::New());
  
      if (success && !input.ReadDmabufFds(&result->dmabuf_fds))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::blink::GpuMemoryBufferVideoFrameData::DataView, ::media::mojom::blink::GpuMemoryBufferVideoFrameDataPtr>::Read(
    ::media::mojom::blink::GpuMemoryBufferVideoFrameData::DataView input,
    ::media::mojom::blink::GpuMemoryBufferVideoFrameDataPtr* output) {
  bool success = true;
  ::media::mojom::blink::GpuMemoryBufferVideoFrameDataPtr result(::media::mojom::blink::GpuMemoryBufferVideoFrameData::New());
  
      if (success && !input.ReadGpuMemoryBufferHandle(&result->gpu_memory_buffer_handle))
        success = false;
      if (success && !input.ReadMailboxHolder(&result->mailbox_holder))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::blink::MailboxVideoFrameData::DataView, ::media::mojom::blink::MailboxVideoFrameDataPtr>::Read(
    ::media::mojom::blink::MailboxVideoFrameData::DataView input,
    ::media::mojom::blink::MailboxVideoFrameDataPtr* output) {
  bool success = true;
  ::media::mojom::blink::MailboxVideoFrameDataPtr result(::media::mojom::blink::MailboxVideoFrameData::New());
  
      if (success && !input.ReadMailboxHolder(&result->mailbox_holder))
        success = false;
      if (success && !input.ReadYcbcrData(&result->ycbcr_data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::blink::PipelineStatistics::DataView, ::media::mojom::blink::PipelineStatisticsPtr>::Read(
    ::media::mojom::blink::PipelineStatistics::DataView input,
    ::media::mojom::blink::PipelineStatisticsPtr* output) {
  bool success = true;
  ::media::mojom::blink::PipelineStatisticsPtr result(::media::mojom::blink::PipelineStatistics::New());
  
      if (success)
        result->audio_bytes_decoded = input.audio_bytes_decoded();
      if (success)
        result->video_bytes_decoded = input.video_bytes_decoded();
      if (success)
        result->video_frames_decoded = input.video_frames_decoded();
      if (success)
        result->video_frames_dropped = input.video_frames_dropped();
      if (success)
        result->audio_memory_usage = input.audio_memory_usage();
      if (success)
        result->video_memory_usage = input.video_memory_usage();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::blink::PredictionFeatures::DataView, ::media::mojom::blink::PredictionFeaturesPtr>::Read(
    ::media::mojom::blink::PredictionFeatures::DataView input,
    ::media::mojom::blink::PredictionFeaturesPtr* output) {
  bool success = true;
  ::media::mojom::blink::PredictionFeaturesPtr result(::media::mojom::blink::PredictionFeatures::New());
  
      if (success && !input.ReadProfile(&result->profile))
        success = false;
      if (success && !input.ReadVideoSize(&result->video_size))
        success = false;
      if (success)
        result->frames_per_sec = input.frames_per_sec();
      if (success && !input.ReadKeySystem(&result->key_system))
        success = false;
      if (success)
        result->use_hw_secure_codecs = input.use_hw_secure_codecs();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::blink::PredictionTargets::DataView, ::media::mojom::blink::PredictionTargetsPtr>::Read(
    ::media::mojom::blink::PredictionTargets::DataView input,
    ::media::mojom::blink::PredictionTargetsPtr* output) {
  bool success = true;
  ::media::mojom::blink::PredictionTargetsPtr result(::media::mojom::blink::PredictionTargets::New());
  
      if (success)
        result->frames_decoded = input.frames_decoded();
      if (success)
        result->frames_dropped = input.frames_dropped();
      if (success)
        result->frames_power_efficient = input.frames_power_efficient();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::blink::AudioDecoderInfo::DataView, ::media::mojom::blink::AudioDecoderInfoPtr>::Read(
    ::media::mojom::blink::AudioDecoderInfo::DataView input,
    ::media::mojom::blink::AudioDecoderInfoPtr* output) {
  bool success = true;
  ::media::mojom::blink::AudioDecoderInfoPtr result(::media::mojom::blink::AudioDecoderInfo::New());
  
      if (success && !input.ReadDecoderType(&result->decoder_type))
        success = false;
      if (success)
        result->is_platform_decoder = input.is_platform_decoder();
      if (success)
        result->has_decrypting_demuxer_stream = input.has_decrypting_demuxer_stream();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::blink::VideoDecoderInfo::DataView, ::media::mojom::blink::VideoDecoderInfoPtr>::Read(
    ::media::mojom::blink::VideoDecoderInfo::DataView input,
    ::media::mojom::blink::VideoDecoderInfoPtr* output) {
  bool success = true;
  ::media::mojom::blink::VideoDecoderInfoPtr result(::media::mojom::blink::VideoDecoderInfo::New());
  
      if (success && !input.ReadDecoderType(&result->decoder_type))
        success = false;
      if (success)
        result->is_platform_decoder = input.is_platform_decoder();
      if (success)
        result->has_decrypting_demuxer_stream = input.has_decrypting_demuxer_stream();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::blink::Status::DataView, ::media::mojom::blink::StatusPtr>::Read(
    ::media::mojom::blink::Status::DataView input,
    ::media::mojom::blink::StatusPtr* output) {
  bool success = true;
  ::media::mojom::blink::StatusPtr result(::media::mojom::blink::Status::New());
  
      if (success && !input.ReadCode(&result->code))
        success = false;
      if (success && !input.ReadMessage(&result->message))
        success = false;
      if (success && !input.ReadFrames(&result->frames))
        success = false;
      if (success && !input.ReadCauses(&result->causes))
        success = false;
      if (success && !input.ReadData(&result->data))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::media::mojom::blink::VideoFrameData::DataView, ::media::mojom::blink::VideoFrameDataPtr>::Read(
    ::media::mojom::blink::VideoFrameData::DataView input,
    ::media::mojom::blink::VideoFrameDataPtr* output) {
  using UnionType = ::media::mojom::blink::VideoFrameData;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::EOS_DATA: {
      ::media::mojom::blink::EosVideoFrameDataPtr result_eos_data;
      if (!input.ReadEosData(&result_eos_data))
        return false;

      *output = UnionType::NewEosData(
          std::move(result_eos_data));
      break;
    }
    case Tag::SHARED_BUFFER_DATA: {
      ::media::mojom::blink::SharedBufferVideoFrameDataPtr result_shared_buffer_data;
      if (!input.ReadSharedBufferData(&result_shared_buffer_data))
        return false;

      *output = UnionType::NewSharedBufferData(
          std::move(result_shared_buffer_data));
      break;
    }
    case Tag::DMABUF_DATA: {
      ::media::mojom::blink::DmabufVideoFrameDataPtr result_dmabuf_data;
      if (!input.ReadDmabufData(&result_dmabuf_data))
        return false;

      *output = UnionType::NewDmabufData(
          std::move(result_dmabuf_data));
      break;
    }
    case Tag::GPU_MEMORY_BUFFER_DATA: {
      ::media::mojom::blink::GpuMemoryBufferVideoFrameDataPtr result_gpu_memory_buffer_data;
      if (!input.ReadGpuMemoryBufferData(&result_gpu_memory_buffer_data))
        return false;

      *output = UnionType::NewGpuMemoryBufferData(
          std::move(result_gpu_memory_buffer_data));
      break;
    }
    case Tag::MAILBOX_DATA: {
      ::media::mojom::blink::MailboxVideoFrameDataPtr result_mailbox_data;
      if (!input.ReadMailboxData(&result_mailbox_data))
        return false;

      *output = UnionType::NewMailboxData(
          std::move(result_mailbox_data));
      break;
    }
    default:
      return false;
  }
  return true;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif