// media/mojo/mojom/output_protection.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/mojo/mojom/output_protection.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "media/mojo/mojom/output_protection.mojom-params-data.h"
#include "media/mojo/mojom/output_protection.mojom-shared-message-ids.h"

#include "media/mojo/mojom/output_protection.mojom-import-headers.h"


#ifndef MEDIA_MOJO_MOJOM_OUTPUT_PROTECTION_MOJOM_JUMBO_H_
#define MEDIA_MOJO_MOJOM_OUTPUT_PROTECTION_MOJOM_JUMBO_H_
#endif
namespace media {
namespace mojom {
const char OutputProtection::Name_[] = "media.mojom.OutputProtection";

class OutputProtection_QueryStatus_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  OutputProtection_QueryStatus_ForwardToCallback(
      OutputProtection::QueryStatusCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  OutputProtection::QueryStatusCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(OutputProtection_QueryStatus_ForwardToCallback);
};

class OutputProtection_EnableProtection_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  OutputProtection_EnableProtection_ForwardToCallback(
      OutputProtection::EnableProtectionCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  OutputProtection::EnableProtectionCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(OutputProtection_EnableProtection_ForwardToCallback);
};

OutputProtectionProxy::OutputProtectionProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void OutputProtectionProxy::QueryStatus(
    QueryStatusCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "media::mojom::OutputProtection::QueryStatus");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kOutputProtection_QueryStatus_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::OutputProtection_QueryStatus_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(OutputProtection::Name_);
  message.set_method_name("QueryStatus");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new OutputProtection_QueryStatus_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void OutputProtectionProxy::EnableProtection(
    uint32_t in_desired_protection_mask, EnableProtectionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::OutputProtection::EnableProtection", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("desired_protection_mask"), in_desired_protection_mask, 
                        "<value of type uint32_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kOutputProtection_EnableProtection_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::OutputProtection_EnableProtection_Params_Data> params(
          message);
  params.Allocate();
  params->desired_protection_mask = in_desired_protection_mask;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(OutputProtection::Name_);
  message.set_method_name("EnableProtection");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new OutputProtection_EnableProtection_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class OutputProtection_QueryStatus_ProxyToResponder {
 public:
  static OutputProtection::QueryStatusCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<OutputProtection_QueryStatus_ProxyToResponder> proxy(
        new OutputProtection_QueryStatus_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&OutputProtection_QueryStatus_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~OutputProtection_QueryStatus_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  OutputProtection_QueryStatus_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "OutputProtection::QueryStatusCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success, uint32_t in_link_mask, uint32_t in_protection_mask);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(OutputProtection_QueryStatus_ProxyToResponder);
};

bool OutputProtection_QueryStatus_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "media::mojom::OutputProtection::QueryStatusCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::OutputProtection_QueryStatus_ResponseParams_Data* params =
      reinterpret_cast<
          internal::OutputProtection_QueryStatus_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_success{};
  uint32_t p_link_mask{};
  uint32_t p_protection_mask{};
  OutputProtection_QueryStatus_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (success)
    p_link_mask = input_data_view.link_mask();
  if (success)
    p_protection_mask = input_data_view.protection_mask();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        OutputProtection::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success), 
std::move(p_link_mask), 
std::move(p_protection_mask));
  return true;
}

void OutputProtection_QueryStatus_ProxyToResponder::Run(
    bool in_success, uint32_t in_link_mask, uint32_t in_protection_mask) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)media::mojom::OutputProtection::QueryStatusCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success, 
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("link_mask"), in_link_mask, 
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("protection_mask"), in_protection_mask, 
                        "<value of type uint32_t>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kOutputProtection_QueryStatus_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::OutputProtection_QueryStatus_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->success = in_success;
  params->link_mask = in_link_mask;
  params->protection_mask = in_protection_mask;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)media::mojom::OutputProtection::QueryStatusCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(OutputProtection::Name_);
  message.set_method_name("QueryStatus");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class OutputProtection_EnableProtection_ProxyToResponder {
 public:
  static OutputProtection::EnableProtectionCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<OutputProtection_EnableProtection_ProxyToResponder> proxy(
        new OutputProtection_EnableProtection_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&OutputProtection_EnableProtection_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~OutputProtection_EnableProtection_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  OutputProtection_EnableProtection_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "OutputProtection::EnableProtectionCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(OutputProtection_EnableProtection_ProxyToResponder);
};

bool OutputProtection_EnableProtection_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "media::mojom::OutputProtection::EnableProtectionCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::OutputProtection_EnableProtection_ResponseParams_Data* params =
      reinterpret_cast<
          internal::OutputProtection_EnableProtection_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_success{};
  OutputProtection_EnableProtection_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        OutputProtection::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success));
  return true;
}

void OutputProtection_EnableProtection_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)media::mojom::OutputProtection::EnableProtectionCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success, 
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kOutputProtection_EnableProtection_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::OutputProtection_EnableProtection_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->success = in_success;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)media::mojom::OutputProtection::EnableProtectionCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(OutputProtection::Name_);
  message.set_method_name("EnableProtection");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool OutputProtectionStubDispatch::Accept(
    OutputProtection* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kOutputProtection_QueryStatus_Name: {
      break;
    }
    case internal::kOutputProtection_EnableProtection_Name: {
      break;
    }
  }
  return false;
}

// static
bool OutputProtectionStubDispatch::AcceptWithResponder(
    OutputProtection* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kOutputProtection_QueryStatus_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::OutputProtection::QueryStatus",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::OutputProtection::QueryStatus");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::OutputProtection_QueryStatus_Params_Data* params =
          reinterpret_cast<
              internal::OutputProtection_QueryStatus_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      OutputProtection_QueryStatus_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            OutputProtection::Name_, 0, false);
        return false;
      }
      OutputProtection::QueryStatusCallback callback =
          OutputProtection_QueryStatus_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->QueryStatus(std::move(callback));
      return true;
    }
    case internal::kOutputProtection_EnableProtection_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::OutputProtection::EnableProtection",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::OutputProtection::EnableProtection");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::OutputProtection_EnableProtection_Params_Data* params =
          reinterpret_cast<
              internal::OutputProtection_EnableProtection_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      uint32_t p_desired_protection_mask{};
      OutputProtection_EnableProtection_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_desired_protection_mask = input_data_view.desired_protection_mask();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            OutputProtection::Name_, 1, false);
        return false;
      }
      OutputProtection::EnableProtectionCallback callback =
          OutputProtection_EnableProtection_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnableProtection(
std::move(p_desired_protection_mask), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kOutputProtectionValidationInfo[] = {
    {internal::kOutputProtection_QueryStatus_Name,
     {&internal::OutputProtection_QueryStatus_Params_Data::Validate,
      &internal::OutputProtection_QueryStatus_ResponseParams_Data::Validate}},
    {internal::kOutputProtection_EnableProtection_Name,
     {&internal::OutputProtection_EnableProtection_Params_Data::Validate,
      &internal::OutputProtection_EnableProtection_ResponseParams_Data::Validate}},
};

bool OutputProtectionRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::OutputProtection::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kOutputProtectionValidationInfo);
}

bool OutputProtectionResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::OutputProtection::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kOutputProtectionValidationInfo);

}
}  // namespace mojom
}  // namespace media

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif