// media/mojo/mojom/playback_events_recorder.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/mojo/mojom/playback_events_recorder.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "media/mojo/mojom/playback_events_recorder.mojom-params-data.h"
#include "media/mojo/mojom/playback_events_recorder.mojom-shared-message-ids.h"

#include "media/mojo/mojom/playback_events_recorder.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef MEDIA_MOJO_MOJOM_PLAYBACK_EVENTS_RECORDER_MOJOM_BLINK_JUMBO_H_
#define MEDIA_MOJO_MOJOM_PLAYBACK_EVENTS_RECORDER_MOJOM_BLINK_JUMBO_H_
#endif
namespace media {
namespace mojom {
namespace blink {
const char PlaybackEventsRecorder::Name_[] = "media.mojom.PlaybackEventsRecorder";

PlaybackEventsRecorderProxy::PlaybackEventsRecorderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PlaybackEventsRecorderProxy::OnPlaying(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "media::mojom::PlaybackEventsRecorder::OnPlaying");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPlaybackEventsRecorder_OnPlaying_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::PlaybackEventsRecorder_OnPlaying_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PlaybackEventsRecorder::Name_);
  message.set_method_name("OnPlaying");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PlaybackEventsRecorderProxy::OnPaused(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "media::mojom::PlaybackEventsRecorder::OnPaused");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPlaybackEventsRecorder_OnPaused_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::PlaybackEventsRecorder_OnPaused_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PlaybackEventsRecorder::Name_);
  message.set_method_name("OnPaused");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PlaybackEventsRecorderProxy::OnSeeking(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "media::mojom::PlaybackEventsRecorder::OnSeeking");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPlaybackEventsRecorder_OnSeeking_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::PlaybackEventsRecorder_OnSeeking_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PlaybackEventsRecorder::Name_);
  message.set_method_name("OnSeeking");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PlaybackEventsRecorderProxy::OnEnded(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "media::mojom::PlaybackEventsRecorder::OnEnded");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPlaybackEventsRecorder_OnEnded_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::PlaybackEventsRecorder_OnEnded_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PlaybackEventsRecorder::Name_);
  message.set_method_name("OnEnded");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PlaybackEventsRecorderProxy::OnError(
    ::media::mojom::blink::PipelineStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::PlaybackEventsRecorder::OnError", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status, 
                        "<value of type ::media::mojom::blink::PipelineStatus>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPlaybackEventsRecorder_OnError_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::PlaybackEventsRecorder_OnError_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::media::mojom::PipelineStatus>(
      in_status, &params->status);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PlaybackEventsRecorder::Name_);
  message.set_method_name("OnError");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PlaybackEventsRecorderProxy::OnBuffering(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "media::mojom::PlaybackEventsRecorder::OnBuffering");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPlaybackEventsRecorder_OnBuffering_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::PlaybackEventsRecorder_OnBuffering_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PlaybackEventsRecorder::Name_);
  message.set_method_name("OnBuffering");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PlaybackEventsRecorderProxy::OnBufferingComplete(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "media::mojom::PlaybackEventsRecorder::OnBufferingComplete");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPlaybackEventsRecorder_OnBufferingComplete_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::PlaybackEventsRecorder_OnBufferingComplete_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PlaybackEventsRecorder::Name_);
  message.set_method_name("OnBufferingComplete");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PlaybackEventsRecorderProxy::OnNaturalSizeChanged(
    const ::gfx::Size& in_size) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::PlaybackEventsRecorder::OnNaturalSizeChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("size"), in_size, 
                        "<value of type const ::gfx::Size&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPlaybackEventsRecorder_OnNaturalSizeChanged_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::PlaybackEventsRecorder_OnNaturalSizeChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->size)::BaseType> size_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_size, size_fragment);
  params->size.Set(
      size_fragment.is_null() ? nullptr : size_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->size.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null size in PlaybackEventsRecorder.OnNaturalSizeChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PlaybackEventsRecorder::Name_);
  message.set_method_name("OnNaturalSizeChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PlaybackEventsRecorderProxy::OnPipelineStatistics(
    ::media::mojom::blink::PipelineStatisticsPtr in_stats) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::PlaybackEventsRecorder::OnPipelineStatistics", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("stats"), in_stats, 
                        "<value of type ::media::mojom::blink::PipelineStatisticsPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPlaybackEventsRecorder_OnPipelineStatistics_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::PlaybackEventsRecorder_OnPipelineStatistics_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->stats)::BaseType> stats_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::PipelineStatisticsDataView>(
      in_stats, stats_fragment);
  params->stats.Set(
      stats_fragment.is_null() ? nullptr : stats_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->stats.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null stats in PlaybackEventsRecorder.OnPipelineStatistics request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PlaybackEventsRecorder::Name_);
  message.set_method_name("OnPipelineStatistics");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool PlaybackEventsRecorderStubDispatch::Accept(
    PlaybackEventsRecorder* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kPlaybackEventsRecorder_OnPlaying_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::PlaybackEventsRecorder::OnPlaying",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::PlaybackEventsRecorder::OnPlaying");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PlaybackEventsRecorder_OnPlaying_Params_Data* params =
          reinterpret_cast<internal::PlaybackEventsRecorder_OnPlaying_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      PlaybackEventsRecorder_OnPlaying_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PlaybackEventsRecorder::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnPlaying();
      return true;
    }
    case internal::kPlaybackEventsRecorder_OnPaused_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::PlaybackEventsRecorder::OnPaused",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::PlaybackEventsRecorder::OnPaused");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PlaybackEventsRecorder_OnPaused_Params_Data* params =
          reinterpret_cast<internal::PlaybackEventsRecorder_OnPaused_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      PlaybackEventsRecorder_OnPaused_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PlaybackEventsRecorder::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnPaused();
      return true;
    }
    case internal::kPlaybackEventsRecorder_OnSeeking_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::PlaybackEventsRecorder::OnSeeking",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::PlaybackEventsRecorder::OnSeeking");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PlaybackEventsRecorder_OnSeeking_Params_Data* params =
          reinterpret_cast<internal::PlaybackEventsRecorder_OnSeeking_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      PlaybackEventsRecorder_OnSeeking_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PlaybackEventsRecorder::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSeeking();
      return true;
    }
    case internal::kPlaybackEventsRecorder_OnEnded_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::PlaybackEventsRecorder::OnEnded",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::PlaybackEventsRecorder::OnEnded");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PlaybackEventsRecorder_OnEnded_Params_Data* params =
          reinterpret_cast<internal::PlaybackEventsRecorder_OnEnded_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      PlaybackEventsRecorder_OnEnded_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PlaybackEventsRecorder::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnEnded();
      return true;
    }
    case internal::kPlaybackEventsRecorder_OnError_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::PlaybackEventsRecorder::OnError",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::PlaybackEventsRecorder::OnError");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PlaybackEventsRecorder_OnError_Params_Data* params =
          reinterpret_cast<internal::PlaybackEventsRecorder_OnError_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::media::mojom::blink::PipelineStatus p_status{};
      PlaybackEventsRecorder_OnError_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStatus(&p_status))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PlaybackEventsRecorder::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnError(
std::move(p_status));
      return true;
    }
    case internal::kPlaybackEventsRecorder_OnBuffering_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::PlaybackEventsRecorder::OnBuffering",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::PlaybackEventsRecorder::OnBuffering");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PlaybackEventsRecorder_OnBuffering_Params_Data* params =
          reinterpret_cast<internal::PlaybackEventsRecorder_OnBuffering_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      PlaybackEventsRecorder_OnBuffering_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PlaybackEventsRecorder::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnBuffering();
      return true;
    }
    case internal::kPlaybackEventsRecorder_OnBufferingComplete_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::PlaybackEventsRecorder::OnBufferingComplete",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::PlaybackEventsRecorder::OnBufferingComplete");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PlaybackEventsRecorder_OnBufferingComplete_Params_Data* params =
          reinterpret_cast<internal::PlaybackEventsRecorder_OnBufferingComplete_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      PlaybackEventsRecorder_OnBufferingComplete_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PlaybackEventsRecorder::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnBufferingComplete();
      return true;
    }
    case internal::kPlaybackEventsRecorder_OnNaturalSizeChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::PlaybackEventsRecorder::OnNaturalSizeChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::PlaybackEventsRecorder::OnNaturalSizeChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PlaybackEventsRecorder_OnNaturalSizeChanged_Params_Data* params =
          reinterpret_cast<internal::PlaybackEventsRecorder_OnNaturalSizeChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gfx::Size p_size{};
      PlaybackEventsRecorder_OnNaturalSizeChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSize(&p_size))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PlaybackEventsRecorder::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnNaturalSizeChanged(
std::move(p_size));
      return true;
    }
    case internal::kPlaybackEventsRecorder_OnPipelineStatistics_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::PlaybackEventsRecorder::OnPipelineStatistics",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::PlaybackEventsRecorder::OnPipelineStatistics");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PlaybackEventsRecorder_OnPipelineStatistics_Params_Data* params =
          reinterpret_cast<internal::PlaybackEventsRecorder_OnPipelineStatistics_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::media::mojom::blink::PipelineStatisticsPtr p_stats{};
      PlaybackEventsRecorder_OnPipelineStatistics_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStats(&p_stats))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PlaybackEventsRecorder::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnPipelineStatistics(
std::move(p_stats));
      return true;
    }
  }
  return false;
}

// static
bool PlaybackEventsRecorderStubDispatch::AcceptWithResponder(
    PlaybackEventsRecorder* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kPlaybackEventsRecorder_OnPlaying_Name: {
      break;
    }
    case internal::kPlaybackEventsRecorder_OnPaused_Name: {
      break;
    }
    case internal::kPlaybackEventsRecorder_OnSeeking_Name: {
      break;
    }
    case internal::kPlaybackEventsRecorder_OnEnded_Name: {
      break;
    }
    case internal::kPlaybackEventsRecorder_OnError_Name: {
      break;
    }
    case internal::kPlaybackEventsRecorder_OnBuffering_Name: {
      break;
    }
    case internal::kPlaybackEventsRecorder_OnBufferingComplete_Name: {
      break;
    }
    case internal::kPlaybackEventsRecorder_OnNaturalSizeChanged_Name: {
      break;
    }
    case internal::kPlaybackEventsRecorder_OnPipelineStatistics_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kPlaybackEventsRecorderValidationInfo[] = {
    {internal::kPlaybackEventsRecorder_OnPlaying_Name,
     {&internal::PlaybackEventsRecorder_OnPlaying_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kPlaybackEventsRecorder_OnPaused_Name,
     {&internal::PlaybackEventsRecorder_OnPaused_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kPlaybackEventsRecorder_OnSeeking_Name,
     {&internal::PlaybackEventsRecorder_OnSeeking_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kPlaybackEventsRecorder_OnEnded_Name,
     {&internal::PlaybackEventsRecorder_OnEnded_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kPlaybackEventsRecorder_OnError_Name,
     {&internal::PlaybackEventsRecorder_OnError_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kPlaybackEventsRecorder_OnBuffering_Name,
     {&internal::PlaybackEventsRecorder_OnBuffering_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kPlaybackEventsRecorder_OnBufferingComplete_Name,
     {&internal::PlaybackEventsRecorder_OnBufferingComplete_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kPlaybackEventsRecorder_OnNaturalSizeChanged_Name,
     {&internal::PlaybackEventsRecorder_OnNaturalSizeChanged_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kPlaybackEventsRecorder_OnPipelineStatistics_Name,
     {&internal::PlaybackEventsRecorder_OnPipelineStatistics_Params_Data::Validate,
      nullptr /* no response */}},
};

bool PlaybackEventsRecorderRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::blink::PlaybackEventsRecorder::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kPlaybackEventsRecorderValidationInfo);
}

}  // namespace blink
}  // namespace mojom
}  // namespace media

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif