// media/mojo/mojom/renderer.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/mojo/mojom/renderer.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "media/mojo/mojom/renderer.mojom-params-data.h"
#include "media/mojo/mojom/renderer.mojom-shared-message-ids.h"

#include "media/mojo/mojom/renderer.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef MEDIA_MOJO_MOJOM_RENDERER_MOJOM_BLINK_JUMBO_H_
#define MEDIA_MOJO_MOJOM_RENDERER_MOJOM_BLINK_JUMBO_H_
#endif
namespace media {
namespace mojom {
namespace blink {
MediaUrlParams::MediaUrlParams()
    : media_url(),
      site_for_cookies(),
      top_frame_origin(),
      allow_credentials(),
      is_hls() {}

MediaUrlParams::MediaUrlParams(
    const ::blink::KURL& media_url_in,
    const ::blink::KURL& site_for_cookies_in,
    const ::scoped_refptr<const ::blink::SecurityOrigin>& top_frame_origin_in,
    bool allow_credentials_in,
    bool is_hls_in)
    : media_url(std::move(media_url_in)),
      site_for_cookies(std::move(site_for_cookies_in)),
      top_frame_origin(std::move(top_frame_origin_in)),
      allow_credentials(std::move(allow_credentials_in)),
      is_hls(std::move(is_hls_in)) {}

MediaUrlParams::~MediaUrlParams() = default;

void MediaUrlParams::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "media_url"), this->media_url, 
      "<value of type const ::blink::KURL&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "site_for_cookies"), this->site_for_cookies, 
      "<value of type const ::blink::KURL&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "top_frame_origin"), this->top_frame_origin, 
      "<value of type const ::scoped_refptr<const ::blink::SecurityOrigin>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_credentials"), this->allow_credentials, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_hls"), this->is_hls, 
      "<value of type bool>");
}

bool MediaUrlParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char Renderer::Name_[] = "media.mojom.Renderer";

class Renderer_Initialize_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Renderer_Initialize_ForwardToCallback(
      Renderer::InitializeCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  Renderer::InitializeCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(Renderer_Initialize_ForwardToCallback);
};

class Renderer_Flush_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Renderer_Flush_ForwardToCallback(
      Renderer::FlushCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  Renderer::FlushCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(Renderer_Flush_ForwardToCallback);
};

class Renderer_SetCdm_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Renderer_SetCdm_ForwardToCallback(
      Renderer::SetCdmCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  Renderer::SetCdmCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(Renderer_SetCdm_ForwardToCallback);
};

RendererProxy::RendererProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void RendererProxy::Initialize(
    ::mojo::PendingAssociatedRemote<RendererClient> in_client, base::Optional<WTF::Vector<::mojo::PendingRemote<::media::mojom::blink::DemuxerStream>>> in_streams, MediaUrlParamsPtr in_media_url_params, InitializeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::Renderer::Initialize", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client, 
                        "<value of type ::mojo::PendingAssociatedRemote<RendererClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("streams"), in_streams, 
                        "<value of type base::Optional<WTF::Vector<::mojo::PendingRemote<::media::mojom::blink::DemuxerStream>>>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("media_url_params"), in_media_url_params, 
                        "<value of type MediaUrlParamsPtr>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRenderer_Initialize_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::Renderer_Initialize_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::media::mojom::RendererClientAssociatedPtrInfoDataView>(
      in_client, &params->client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid client in Renderer.Initialize request");
  mojo::internal::MessageFragment<
      typename decltype(params->streams)::BaseType>
      streams_fragment(params.message());
  const mojo::internal::ContainerValidateParams streams_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::InterfacePtrDataView<::media::mojom::DemuxerStreamInterfaceBase>>>(
      in_streams, streams_fragment, &streams_validate_params);
  params->streams.Set(
      streams_fragment.is_null() ? nullptr : streams_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->media_url_params)::BaseType> media_url_params_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::MediaUrlParamsDataView>(
      in_media_url_params, media_url_params_fragment);
  params->media_url_params.Set(
      media_url_params_fragment.is_null() ? nullptr : media_url_params_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("Initialize");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Renderer_Initialize_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void RendererProxy::Flush(
    FlushCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "media::mojom::Renderer::Flush");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRenderer_Flush_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::Renderer_Flush_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("Flush");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Renderer_Flush_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void RendererProxy::StartPlayingFrom(
    ::base::TimeDelta in_time) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::Renderer::StartPlayingFrom", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("time"), in_time, 
                        "<value of type ::base::TimeDelta>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRenderer_StartPlayingFrom_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::Renderer_StartPlayingFrom_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->time)::BaseType> time_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_time, time_fragment);
  params->time.Set(
      time_fragment.is_null() ? nullptr : time_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->time.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null time in Renderer.StartPlayingFrom request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("StartPlayingFrom");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RendererProxy::SetPlaybackRate(
    double in_playback_rate) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::Renderer::SetPlaybackRate", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("playback_rate"), in_playback_rate, 
                        "<value of type double>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRenderer_SetPlaybackRate_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::Renderer_SetPlaybackRate_Params_Data> params(
          message);
  params.Allocate();
  params->playback_rate = in_playback_rate;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("SetPlaybackRate");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RendererProxy::SetVolume(
    float in_volume) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::Renderer::SetVolume", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("volume"), in_volume, 
                        "<value of type float>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRenderer_SetVolume_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::Renderer_SetVolume_Params_Data> params(
          message);
  params.Allocate();
  params->volume = in_volume;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("SetVolume");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RendererProxy::SetCdm(
    const base::Optional<::base::UnguessableToken>& in_cdm_id, SetCdmCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::Renderer::SetCdm", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cdm_id"), in_cdm_id, 
                        "<value of type const base::Optional<::base::UnguessableToken>&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRenderer_SetCdm_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::Renderer_SetCdm_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->cdm_id)::BaseType> cdm_id_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_cdm_id, cdm_id_fragment);
  params->cdm_id.Set(
      cdm_id_fragment.is_null() ? nullptr : cdm_id_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("SetCdm");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Renderer_SetCdm_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class Renderer_Initialize_ProxyToResponder {
 public:
  static Renderer::InitializeCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<Renderer_Initialize_ProxyToResponder> proxy(
        new Renderer_Initialize_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&Renderer_Initialize_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Renderer_Initialize_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  Renderer_Initialize_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Renderer::InitializeCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(Renderer_Initialize_ProxyToResponder);
};

bool Renderer_Initialize_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "media::mojom::Renderer::InitializeCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::Renderer_Initialize_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Renderer_Initialize_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_success{};
  Renderer_Initialize_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Renderer::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success));
  return true;
}

void Renderer_Initialize_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)media::mojom::Renderer::InitializeCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success, 
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRenderer_Initialize_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::Renderer_Initialize_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->success = in_success;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)media::mojom::Renderer::InitializeCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("Initialize");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Renderer_Flush_ProxyToResponder {
 public:
  static Renderer::FlushCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<Renderer_Flush_ProxyToResponder> proxy(
        new Renderer_Flush_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&Renderer_Flush_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Renderer_Flush_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  Renderer_Flush_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Renderer::FlushCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(Renderer_Flush_ProxyToResponder);
};

bool Renderer_Flush_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "media::mojom::Renderer::FlushCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::Renderer_Flush_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Renderer_Flush_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  Renderer_Flush_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Renderer::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void Renderer_Flush_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)media::mojom::Renderer::FlushCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRenderer_Flush_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::Renderer_Flush_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)media::mojom::Renderer::FlushCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("Flush");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Renderer_SetCdm_ProxyToResponder {
 public:
  static Renderer::SetCdmCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<Renderer_SetCdm_ProxyToResponder> proxy(
        new Renderer_SetCdm_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&Renderer_SetCdm_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Renderer_SetCdm_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  Renderer_SetCdm_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Renderer::SetCdmCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(Renderer_SetCdm_ProxyToResponder);
};

bool Renderer_SetCdm_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "media::mojom::Renderer::SetCdmCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::Renderer_SetCdm_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Renderer_SetCdm_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_success{};
  Renderer_SetCdm_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Renderer::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success));
  return true;
}

void Renderer_SetCdm_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)media::mojom::Renderer::SetCdmCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success, 
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRenderer_SetCdm_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::Renderer_SetCdm_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->success = in_success;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)media::mojom::Renderer::SetCdmCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("SetCdm");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool RendererStubDispatch::Accept(
    Renderer* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kRenderer_Initialize_Name: {
      break;
    }
    case internal::kRenderer_Flush_Name: {
      break;
    }
    case internal::kRenderer_StartPlayingFrom_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::Renderer::StartPlayingFrom",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::Renderer::StartPlayingFrom");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Renderer_StartPlayingFrom_Params_Data* params =
          reinterpret_cast<internal::Renderer_StartPlayingFrom_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::TimeDelta p_time{};
      Renderer_StartPlayingFrom_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTime(&p_time))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartPlayingFrom(
std::move(p_time));
      return true;
    }
    case internal::kRenderer_SetPlaybackRate_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::Renderer::SetPlaybackRate",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::Renderer::SetPlaybackRate");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Renderer_SetPlaybackRate_Params_Data* params =
          reinterpret_cast<internal::Renderer_SetPlaybackRate_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      double p_playback_rate{};
      Renderer_SetPlaybackRate_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_playback_rate = input_data_view.playback_rate();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetPlaybackRate(
std::move(p_playback_rate));
      return true;
    }
    case internal::kRenderer_SetVolume_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::Renderer::SetVolume",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::Renderer::SetVolume");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Renderer_SetVolume_Params_Data* params =
          reinterpret_cast<internal::Renderer_SetVolume_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      float p_volume{};
      Renderer_SetVolume_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_volume = input_data_view.volume();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetVolume(
std::move(p_volume));
      return true;
    }
    case internal::kRenderer_SetCdm_Name: {
      break;
    }
  }
  return false;
}

// static
bool RendererStubDispatch::AcceptWithResponder(
    Renderer* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kRenderer_Initialize_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::Renderer::Initialize",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::Renderer::Initialize");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::Renderer_Initialize_Params_Data* params =
          reinterpret_cast<
              internal::Renderer_Initialize_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingAssociatedRemote<RendererClient> p_client{};
      base::Optional<WTF::Vector<::mojo::PendingRemote<::media::mojom::blink::DemuxerStream>>> p_streams{};
      MediaUrlParamsPtr p_media_url_params{};
      Renderer_Initialize_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (success && !input_data_view.ReadStreams(&p_streams))
        success = false;
      if (success && !input_data_view.ReadMediaUrlParams(&p_media_url_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 0, false);
        return false;
      }
      Renderer::InitializeCallback callback =
          Renderer_Initialize_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Initialize(
std::move(p_client), 
std::move(p_streams), 
std::move(p_media_url_params), std::move(callback));
      return true;
    }
    case internal::kRenderer_Flush_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::Renderer::Flush",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::Renderer::Flush");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::Renderer_Flush_Params_Data* params =
          reinterpret_cast<
              internal::Renderer_Flush_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      Renderer_Flush_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 1, false);
        return false;
      }
      Renderer::FlushCallback callback =
          Renderer_Flush_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Flush(std::move(callback));
      return true;
    }
    case internal::kRenderer_StartPlayingFrom_Name: {
      break;
    }
    case internal::kRenderer_SetPlaybackRate_Name: {
      break;
    }
    case internal::kRenderer_SetVolume_Name: {
      break;
    }
    case internal::kRenderer_SetCdm_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::Renderer::SetCdm",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::Renderer::SetCdm");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::Renderer_SetCdm_Params_Data* params =
          reinterpret_cast<
              internal::Renderer_SetCdm_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      base::Optional<::base::UnguessableToken> p_cdm_id{};
      Renderer_SetCdm_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCdmId(&p_cdm_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 5, false);
        return false;
      }
      Renderer::SetCdmCallback callback =
          Renderer_SetCdm_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetCdm(
std::move(p_cdm_id), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kRendererValidationInfo[] = {
    {internal::kRenderer_Initialize_Name,
     {&internal::Renderer_Initialize_Params_Data::Validate,
      &internal::Renderer_Initialize_ResponseParams_Data::Validate}},
    {internal::kRenderer_Flush_Name,
     {&internal::Renderer_Flush_Params_Data::Validate,
      &internal::Renderer_Flush_ResponseParams_Data::Validate}},
    {internal::kRenderer_StartPlayingFrom_Name,
     {&internal::Renderer_StartPlayingFrom_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRenderer_SetPlaybackRate_Name,
     {&internal::Renderer_SetPlaybackRate_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRenderer_SetVolume_Name,
     {&internal::Renderer_SetVolume_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRenderer_SetCdm_Name,
     {&internal::Renderer_SetCdm_Params_Data::Validate,
      &internal::Renderer_SetCdm_ResponseParams_Data::Validate}},
};

bool RendererRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::blink::Renderer::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kRendererValidationInfo);
}

bool RendererResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::blink::Renderer::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kRendererValidationInfo);

}
const char RendererClient::Name_[] = "media.mojom.RendererClient";

RendererClientProxy::RendererClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void RendererClientProxy::OnTimeUpdate(
    ::base::TimeDelta in_time, ::base::TimeDelta in_max_time, ::base::TimeTicks in_capture_time) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::RendererClient::OnTimeUpdate", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("time"), in_time, 
                        "<value of type ::base::TimeDelta>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("max_time"), in_max_time, 
                        "<value of type ::base::TimeDelta>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("capture_time"), in_capture_time, 
                        "<value of type ::base::TimeTicks>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRendererClient_OnTimeUpdate_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::RendererClient_OnTimeUpdate_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->time)::BaseType> time_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_time, time_fragment);
  params->time.Set(
      time_fragment.is_null() ? nullptr : time_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->time.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null time in RendererClient.OnTimeUpdate request");
  mojo::internal::MessageFragment<
      typename decltype(params->max_time)::BaseType> max_time_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_max_time, max_time_fragment);
  params->max_time.Set(
      max_time_fragment.is_null() ? nullptr : max_time_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->max_time.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null max_time in RendererClient.OnTimeUpdate request");
  mojo::internal::MessageFragment<
      typename decltype(params->capture_time)::BaseType> capture_time_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
      in_capture_time, capture_time_fragment);
  params->capture_time.Set(
      capture_time_fragment.is_null() ? nullptr : capture_time_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->capture_time.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null capture_time in RendererClient.OnTimeUpdate request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RendererClient::Name_);
  message.set_method_name("OnTimeUpdate");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RendererClientProxy::OnBufferingStateChange(
    ::media::mojom::blink::BufferingState in_state, ::media::mojom::blink::BufferingStateChangeReason in_reason) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::RendererClient::OnBufferingStateChange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("state"), in_state, 
                        "<value of type ::media::mojom::blink::BufferingState>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reason"), in_reason, 
                        "<value of type ::media::mojom::blink::BufferingStateChangeReason>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRendererClient_OnBufferingStateChange_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::RendererClient_OnBufferingStateChange_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::media::mojom::BufferingState>(
      in_state, &params->state);
  mojo::internal::Serialize<::media::mojom::BufferingStateChangeReason>(
      in_reason, &params->reason);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RendererClient::Name_);
  message.set_method_name("OnBufferingStateChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RendererClientProxy::OnEnded(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "media::mojom::RendererClient::OnEnded");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRendererClient_OnEnded_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::RendererClient_OnEnded_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RendererClient::Name_);
  message.set_method_name("OnEnded");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RendererClientProxy::OnError(
    ::media::mojom::blink::StatusPtr in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::RendererClient::OnError", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status, 
                        "<value of type ::media::mojom::blink::StatusPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRendererClient_OnError_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::RendererClient_OnError_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->status)::BaseType> status_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::StatusDataView>(
      in_status, status_fragment);
  params->status.Set(
      status_fragment.is_null() ? nullptr : status_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->status.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null status in RendererClient.OnError request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RendererClient::Name_);
  message.set_method_name("OnError");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RendererClientProxy::OnAudioConfigChange(
    ::media::mojom::blink::AudioDecoderConfigPtr in_config) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::RendererClient::OnAudioConfigChange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("config"), in_config, 
                        "<value of type ::media::mojom::blink::AudioDecoderConfigPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRendererClient_OnAudioConfigChange_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::RendererClient_OnAudioConfigChange_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->config)::BaseType> config_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::AudioDecoderConfigDataView>(
      in_config, config_fragment);
  params->config.Set(
      config_fragment.is_null() ? nullptr : config_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->config.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null config in RendererClient.OnAudioConfigChange request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RendererClient::Name_);
  message.set_method_name("OnAudioConfigChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RendererClientProxy::OnVideoConfigChange(
    ::media::mojom::blink::VideoDecoderConfigPtr in_config) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::RendererClient::OnVideoConfigChange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("config"), in_config, 
                        "<value of type ::media::mojom::blink::VideoDecoderConfigPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRendererClient_OnVideoConfigChange_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::RendererClient_OnVideoConfigChange_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->config)::BaseType> config_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::VideoDecoderConfigDataView>(
      in_config, config_fragment);
  params->config.Set(
      config_fragment.is_null() ? nullptr : config_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->config.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null config in RendererClient.OnVideoConfigChange request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RendererClient::Name_);
  message.set_method_name("OnVideoConfigChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RendererClientProxy::OnVideoNaturalSizeChange(
    const ::gfx::Size& in_size) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::RendererClient::OnVideoNaturalSizeChange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("size"), in_size, 
                        "<value of type const ::gfx::Size&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRendererClient_OnVideoNaturalSizeChange_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::RendererClient_OnVideoNaturalSizeChange_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->size)::BaseType> size_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_size, size_fragment);
  params->size.Set(
      size_fragment.is_null() ? nullptr : size_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->size.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null size in RendererClient.OnVideoNaturalSizeChange request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RendererClient::Name_);
  message.set_method_name("OnVideoNaturalSizeChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RendererClientProxy::OnVideoOpacityChange(
    bool in_opaque) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::RendererClient::OnVideoOpacityChange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("opaque"), in_opaque, 
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRendererClient_OnVideoOpacityChange_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::RendererClient_OnVideoOpacityChange_Params_Data> params(
          message);
  params.Allocate();
  params->opaque = in_opaque;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RendererClient::Name_);
  message.set_method_name("OnVideoOpacityChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RendererClientProxy::OnStatisticsUpdate(
    ::media::mojom::blink::PipelineStatisticsPtr in_stats) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::RendererClient::OnStatisticsUpdate", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("stats"), in_stats, 
                        "<value of type ::media::mojom::blink::PipelineStatisticsPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRendererClient_OnStatisticsUpdate_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::RendererClient_OnStatisticsUpdate_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->stats)::BaseType> stats_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::PipelineStatisticsDataView>(
      in_stats, stats_fragment);
  params->stats.Set(
      stats_fragment.is_null() ? nullptr : stats_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->stats.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null stats in RendererClient.OnStatisticsUpdate request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RendererClient::Name_);
  message.set_method_name("OnStatisticsUpdate");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RendererClientProxy::OnWaiting(
    ::media::mojom::blink::WaitingReason in_reason) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::RendererClient::OnWaiting", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reason"), in_reason, 
                        "<value of type ::media::mojom::blink::WaitingReason>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRendererClient_OnWaiting_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::RendererClient_OnWaiting_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::media::mojom::WaitingReason>(
      in_reason, &params->reason);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RendererClient::Name_);
  message.set_method_name("OnWaiting");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool RendererClientStubDispatch::Accept(
    RendererClient* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kRendererClient_OnTimeUpdate_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::RendererClient::OnTimeUpdate",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::RendererClient::OnTimeUpdate");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RendererClient_OnTimeUpdate_Params_Data* params =
          reinterpret_cast<internal::RendererClient_OnTimeUpdate_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::TimeDelta p_time{};
      ::base::TimeDelta p_max_time{};
      ::base::TimeTicks p_capture_time{};
      RendererClient_OnTimeUpdate_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTime(&p_time))
        success = false;
      if (success && !input_data_view.ReadMaxTime(&p_max_time))
        success = false;
      if (success && !input_data_view.ReadCaptureTime(&p_capture_time))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RendererClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnTimeUpdate(
std::move(p_time), 
std::move(p_max_time), 
std::move(p_capture_time));
      return true;
    }
    case internal::kRendererClient_OnBufferingStateChange_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::RendererClient::OnBufferingStateChange",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::RendererClient::OnBufferingStateChange");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RendererClient_OnBufferingStateChange_Params_Data* params =
          reinterpret_cast<internal::RendererClient_OnBufferingStateChange_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::media::mojom::blink::BufferingState p_state{};
      ::media::mojom::blink::BufferingStateChangeReason p_reason{};
      RendererClient_OnBufferingStateChange_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadState(&p_state))
        success = false;
      if (success && !input_data_view.ReadReason(&p_reason))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RendererClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnBufferingStateChange(
std::move(p_state), 
std::move(p_reason));
      return true;
    }
    case internal::kRendererClient_OnEnded_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::RendererClient::OnEnded",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::RendererClient::OnEnded");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RendererClient_OnEnded_Params_Data* params =
          reinterpret_cast<internal::RendererClient_OnEnded_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      RendererClient_OnEnded_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RendererClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnEnded();
      return true;
    }
    case internal::kRendererClient_OnError_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::RendererClient::OnError",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::RendererClient::OnError");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RendererClient_OnError_Params_Data* params =
          reinterpret_cast<internal::RendererClient_OnError_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::media::mojom::blink::StatusPtr p_status{};
      RendererClient_OnError_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStatus(&p_status))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RendererClient::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnError(
std::move(p_status));
      return true;
    }
    case internal::kRendererClient_OnAudioConfigChange_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::RendererClient::OnAudioConfigChange",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::RendererClient::OnAudioConfigChange");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RendererClient_OnAudioConfigChange_Params_Data* params =
          reinterpret_cast<internal::RendererClient_OnAudioConfigChange_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::media::mojom::blink::AudioDecoderConfigPtr p_config{};
      RendererClient_OnAudioConfigChange_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadConfig(&p_config))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RendererClient::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnAudioConfigChange(
std::move(p_config));
      return true;
    }
    case internal::kRendererClient_OnVideoConfigChange_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::RendererClient::OnVideoConfigChange",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::RendererClient::OnVideoConfigChange");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RendererClient_OnVideoConfigChange_Params_Data* params =
          reinterpret_cast<internal::RendererClient_OnVideoConfigChange_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::media::mojom::blink::VideoDecoderConfigPtr p_config{};
      RendererClient_OnVideoConfigChange_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadConfig(&p_config))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RendererClient::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnVideoConfigChange(
std::move(p_config));
      return true;
    }
    case internal::kRendererClient_OnVideoNaturalSizeChange_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::RendererClient::OnVideoNaturalSizeChange",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::RendererClient::OnVideoNaturalSizeChange");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RendererClient_OnVideoNaturalSizeChange_Params_Data* params =
          reinterpret_cast<internal::RendererClient_OnVideoNaturalSizeChange_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gfx::Size p_size{};
      RendererClient_OnVideoNaturalSizeChange_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSize(&p_size))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RendererClient::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnVideoNaturalSizeChange(
std::move(p_size));
      return true;
    }
    case internal::kRendererClient_OnVideoOpacityChange_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::RendererClient::OnVideoOpacityChange",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::RendererClient::OnVideoOpacityChange");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RendererClient_OnVideoOpacityChange_Params_Data* params =
          reinterpret_cast<internal::RendererClient_OnVideoOpacityChange_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_opaque{};
      RendererClient_OnVideoOpacityChange_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_opaque = input_data_view.opaque();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RendererClient::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnVideoOpacityChange(
std::move(p_opaque));
      return true;
    }
    case internal::kRendererClient_OnStatisticsUpdate_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::RendererClient::OnStatisticsUpdate",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::RendererClient::OnStatisticsUpdate");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RendererClient_OnStatisticsUpdate_Params_Data* params =
          reinterpret_cast<internal::RendererClient_OnStatisticsUpdate_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::media::mojom::blink::PipelineStatisticsPtr p_stats{};
      RendererClient_OnStatisticsUpdate_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStats(&p_stats))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RendererClient::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnStatisticsUpdate(
std::move(p_stats));
      return true;
    }
    case internal::kRendererClient_OnWaiting_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::RendererClient::OnWaiting",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::RendererClient::OnWaiting");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RendererClient_OnWaiting_Params_Data* params =
          reinterpret_cast<internal::RendererClient_OnWaiting_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::media::mojom::blink::WaitingReason p_reason{};
      RendererClient_OnWaiting_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadReason(&p_reason))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RendererClient::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnWaiting(
std::move(p_reason));
      return true;
    }
  }
  return false;
}

// static
bool RendererClientStubDispatch::AcceptWithResponder(
    RendererClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kRendererClient_OnTimeUpdate_Name: {
      break;
    }
    case internal::kRendererClient_OnBufferingStateChange_Name: {
      break;
    }
    case internal::kRendererClient_OnEnded_Name: {
      break;
    }
    case internal::kRendererClient_OnError_Name: {
      break;
    }
    case internal::kRendererClient_OnAudioConfigChange_Name: {
      break;
    }
    case internal::kRendererClient_OnVideoConfigChange_Name: {
      break;
    }
    case internal::kRendererClient_OnVideoNaturalSizeChange_Name: {
      break;
    }
    case internal::kRendererClient_OnVideoOpacityChange_Name: {
      break;
    }
    case internal::kRendererClient_OnStatisticsUpdate_Name: {
      break;
    }
    case internal::kRendererClient_OnWaiting_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kRendererClientValidationInfo[] = {
    {internal::kRendererClient_OnTimeUpdate_Name,
     {&internal::RendererClient_OnTimeUpdate_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRendererClient_OnBufferingStateChange_Name,
     {&internal::RendererClient_OnBufferingStateChange_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRendererClient_OnEnded_Name,
     {&internal::RendererClient_OnEnded_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRendererClient_OnError_Name,
     {&internal::RendererClient_OnError_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRendererClient_OnAudioConfigChange_Name,
     {&internal::RendererClient_OnAudioConfigChange_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRendererClient_OnVideoConfigChange_Name,
     {&internal::RendererClient_OnVideoConfigChange_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRendererClient_OnVideoNaturalSizeChange_Name,
     {&internal::RendererClient_OnVideoNaturalSizeChange_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRendererClient_OnVideoOpacityChange_Name,
     {&internal::RendererClient_OnVideoOpacityChange_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRendererClient_OnStatisticsUpdate_Name,
     {&internal::RendererClient_OnStatisticsUpdate_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRendererClient_OnWaiting_Name,
     {&internal::RendererClient_OnWaiting_Params_Data::Validate,
      nullptr /* no response */}},
};

bool RendererClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::blink::RendererClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kRendererClientValidationInfo);
}

}  // namespace blink
}  // namespace mojom
}  // namespace media

namespace mojo {


// static
bool StructTraits<::media::mojom::blink::MediaUrlParams::DataView, ::media::mojom::blink::MediaUrlParamsPtr>::Read(
    ::media::mojom::blink::MediaUrlParams::DataView input,
    ::media::mojom::blink::MediaUrlParamsPtr* output) {
  bool success = true;
  ::media::mojom::blink::MediaUrlParamsPtr result(::media::mojom::blink::MediaUrlParams::New());
  
      if (success && !input.ReadMediaUrl(&result->media_url))
        success = false;
      if (success && !input.ReadSiteForCookies(&result->site_for_cookies))
        success = false;
      if (success && !input.ReadTopFrameOrigin(&result->top_frame_origin))
        success = false;
      if (success)
        result->allow_credentials = input.allow_credentials();
      if (success)
        result->is_hls = input.is_hls();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif