// media/mojo/mojom/renderer.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "media/mojo/mojom/renderer.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/renderer.mojom-params-data.h"
namespace media {
namespace mojom {

namespace internal {


// static
bool MediaUrlParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MediaUrlParams_Data* object = static_cast<const MediaUrlParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->media_url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->media_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->site_for_cookies, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->site_for_cookies, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->top_frame_origin, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->top_frame_origin, validation_context))
    return false;

  return true;
}

MediaUrlParams_Data::MediaUrlParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Renderer_Initialize_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Renderer_Initialize_Params_Data* object = static_cast<const Renderer_Initialize_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  const mojo::internal::ContainerValidateParams streams_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->streams, validation_context,
                                         &streams_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->media_url_params, validation_context))
    return false;

  return true;
}

Renderer_Initialize_Params_Data::Renderer_Initialize_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Renderer_Initialize_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Renderer_Initialize_ResponseParams_Data* object = static_cast<const Renderer_Initialize_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

Renderer_Initialize_ResponseParams_Data::Renderer_Initialize_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Renderer_Flush_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Renderer_Flush_Params_Data* object = static_cast<const Renderer_Flush_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

Renderer_Flush_Params_Data::Renderer_Flush_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Renderer_Flush_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Renderer_Flush_ResponseParams_Data* object = static_cast<const Renderer_Flush_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

Renderer_Flush_ResponseParams_Data::Renderer_Flush_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Renderer_StartPlayingFrom_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Renderer_StartPlayingFrom_Params_Data* object = static_cast<const Renderer_StartPlayingFrom_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->time, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->time, validation_context))
    return false;

  return true;
}

Renderer_StartPlayingFrom_Params_Data::Renderer_StartPlayingFrom_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Renderer_SetPlaybackRate_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Renderer_SetPlaybackRate_Params_Data* object = static_cast<const Renderer_SetPlaybackRate_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

Renderer_SetPlaybackRate_Params_Data::Renderer_SetPlaybackRate_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Renderer_SetVolume_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Renderer_SetVolume_Params_Data* object = static_cast<const Renderer_SetVolume_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

Renderer_SetVolume_Params_Data::Renderer_SetVolume_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Renderer_SetCdm_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Renderer_SetCdm_Params_Data* object = static_cast<const Renderer_SetCdm_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->cdm_id, validation_context))
    return false;

  return true;
}

Renderer_SetCdm_Params_Data::Renderer_SetCdm_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Renderer_SetCdm_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Renderer_SetCdm_ResponseParams_Data* object = static_cast<const Renderer_SetCdm_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

Renderer_SetCdm_ResponseParams_Data::Renderer_SetCdm_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RendererClient_OnTimeUpdate_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RendererClient_OnTimeUpdate_Params_Data* object = static_cast<const RendererClient_OnTimeUpdate_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->time, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->time, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->max_time, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->max_time, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->capture_time, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->capture_time, validation_context))
    return false;

  return true;
}

RendererClient_OnTimeUpdate_Params_Data::RendererClient_OnTimeUpdate_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RendererClient_OnBufferingStateChange_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RendererClient_OnBufferingStateChange_Params_Data* object = static_cast<const RendererClient_OnBufferingStateChange_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::media::mojom::internal::BufferingState_Data
        ::Validate(object->state, validation_context))
    return false;


  if (!::media::mojom::internal::BufferingStateChangeReason_Data
        ::Validate(object->reason, validation_context))
    return false;

  return true;
}

RendererClient_OnBufferingStateChange_Params_Data::RendererClient_OnBufferingStateChange_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RendererClient_OnEnded_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RendererClient_OnEnded_Params_Data* object = static_cast<const RendererClient_OnEnded_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

RendererClient_OnEnded_Params_Data::RendererClient_OnEnded_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RendererClient_OnError_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RendererClient_OnError_Params_Data* object = static_cast<const RendererClient_OnError_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->status, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->status, validation_context))
    return false;

  return true;
}

RendererClient_OnError_Params_Data::RendererClient_OnError_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RendererClient_OnAudioConfigChange_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RendererClient_OnAudioConfigChange_Params_Data* object = static_cast<const RendererClient_OnAudioConfigChange_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->config, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->config, validation_context))
    return false;

  return true;
}

RendererClient_OnAudioConfigChange_Params_Data::RendererClient_OnAudioConfigChange_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RendererClient_OnVideoConfigChange_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RendererClient_OnVideoConfigChange_Params_Data* object = static_cast<const RendererClient_OnVideoConfigChange_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->config, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->config, validation_context))
    return false;

  return true;
}

RendererClient_OnVideoConfigChange_Params_Data::RendererClient_OnVideoConfigChange_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RendererClient_OnVideoNaturalSizeChange_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RendererClient_OnVideoNaturalSizeChange_Params_Data* object = static_cast<const RendererClient_OnVideoNaturalSizeChange_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->size, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->size, validation_context))
    return false;

  return true;
}

RendererClient_OnVideoNaturalSizeChange_Params_Data::RendererClient_OnVideoNaturalSizeChange_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RendererClient_OnVideoOpacityChange_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RendererClient_OnVideoOpacityChange_Params_Data* object = static_cast<const RendererClient_OnVideoOpacityChange_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

RendererClient_OnVideoOpacityChange_Params_Data::RendererClient_OnVideoOpacityChange_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RendererClient_OnStatisticsUpdate_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RendererClient_OnStatisticsUpdate_Params_Data* object = static_cast<const RendererClient_OnStatisticsUpdate_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->stats, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->stats, validation_context))
    return false;

  return true;
}

RendererClient_OnStatisticsUpdate_Params_Data::RendererClient_OnStatisticsUpdate_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RendererClient_OnWaiting_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RendererClient_OnWaiting_Params_Data* object = static_cast<const RendererClient_OnWaiting_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::media::mojom::internal::WaitingReason_Data
        ::Validate(object->reason, validation_context))
    return false;

  return true;
}

RendererClient_OnWaiting_Params_Data::RendererClient_OnWaiting_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace media
