// media/mojo/mojom/speech_recognition_service.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "media/mojo/mojom/speech_recognition_service.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/speech_recognition_service.mojom-params-data.h"
namespace media {
namespace mojom {

namespace internal {


// static
bool SpeechRecognitionResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SpeechRecognitionResult_Data* object = static_cast<const SpeechRecognitionResult_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->transcription, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams transcription_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->transcription, validation_context,
                                         &transcription_validate_params)) {
    return false;
  }

  return true;
}

SpeechRecognitionResult_Data::SpeechRecognitionResult_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SpeechRecognitionContext_BindRecognizer_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SpeechRecognitionContext_BindRecognizer_Params_Data* object = static_cast<const SpeechRecognitionContext_BindRecognizer_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

SpeechRecognitionContext_BindRecognizer_Params_Data::SpeechRecognitionContext_BindRecognizer_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SpeechRecognitionContext_BindRecognizer_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SpeechRecognitionContext_BindRecognizer_ResponseParams_Data* object = static_cast<const SpeechRecognitionContext_BindRecognizer_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

SpeechRecognitionContext_BindRecognizer_ResponseParams_Data::SpeechRecognitionContext_BindRecognizer_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SpeechRecognitionService_BindContext_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SpeechRecognitionService_BindContext_Params_Data* object = static_cast<const SpeechRecognitionService_BindContext_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->context, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->context,
                                                 validation_context)) {
    return false;
  }

  return true;
}

SpeechRecognitionService_BindContext_Params_Data::SpeechRecognitionService_BindContext_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SpeechRecognitionService_SetUrlLoaderFactory_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SpeechRecognitionService_SetUrlLoaderFactory_Params_Data* object = static_cast<const SpeechRecognitionService_SetUrlLoaderFactory_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->url_loader_factory, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->url_loader_factory,
                                                 validation_context)) {
    return false;
  }

  return true;
}

SpeechRecognitionService_SetUrlLoaderFactory_Params_Data::SpeechRecognitionService_SetUrlLoaderFactory_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SpeechRecognitionService_SetSodaPath_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SpeechRecognitionService_SetSodaPath_Params_Data* object = static_cast<const SpeechRecognitionService_SetSodaPath_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->binary_path, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->binary_path, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->config_path, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->config_path, validation_context))
    return false;

  return true;
}

SpeechRecognitionService_SetSodaPath_Params_Data::SpeechRecognitionService_SetSodaPath_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SpeechRecognitionService_BindSpeechRecognitionServiceClient_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SpeechRecognitionService_BindSpeechRecognitionServiceClient_Params_Data* object = static_cast<const SpeechRecognitionService_BindSpeechRecognitionServiceClient_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

SpeechRecognitionService_BindSpeechRecognitionServiceClient_Params_Data::SpeechRecognitionService_BindSpeechRecognitionServiceClient_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SpeechRecognitionServiceClient_OnNetworkServiceDisconnect_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SpeechRecognitionServiceClient_OnNetworkServiceDisconnect_Params_Data* object = static_cast<const SpeechRecognitionServiceClient_OnNetworkServiceDisconnect_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

SpeechRecognitionServiceClient_OnNetworkServiceDisconnect_Params_Data::SpeechRecognitionServiceClient_OnNetworkServiceDisconnect_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SpeechRecognitionRecognizer_SendAudioToSpeechRecognitionService_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SpeechRecognitionRecognizer_SendAudioToSpeechRecognitionService_Params_Data* object = static_cast<const SpeechRecognitionRecognizer_SendAudioToSpeechRecognitionService_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->buffer, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->buffer, validation_context))
    return false;

  return true;
}

SpeechRecognitionRecognizer_SendAudioToSpeechRecognitionService_Params_Data::SpeechRecognitionRecognizer_SendAudioToSpeechRecognitionService_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SpeechRecognitionRecognizer_OnCaptionBubbleClosed_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SpeechRecognitionRecognizer_OnCaptionBubbleClosed_Params_Data* object = static_cast<const SpeechRecognitionRecognizer_OnCaptionBubbleClosed_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

SpeechRecognitionRecognizer_OnCaptionBubbleClosed_Params_Data::SpeechRecognitionRecognizer_OnCaptionBubbleClosed_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SpeechRecognitionRecognizer_AudioReceivedAfterBubbleClosed_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SpeechRecognitionRecognizer_AudioReceivedAfterBubbleClosed_Params_Data* object = static_cast<const SpeechRecognitionRecognizer_AudioReceivedAfterBubbleClosed_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->duration, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->duration, validation_context))
    return false;

  return true;
}

SpeechRecognitionRecognizer_AudioReceivedAfterBubbleClosed_Params_Data::SpeechRecognitionRecognizer_AudioReceivedAfterBubbleClosed_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_Params_Data* object = static_cast<const SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  return true;
}

SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_Params_Data::SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SpeechRecognitionAvailabilityObserver_SpeechRecognitionAvailabilityChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SpeechRecognitionAvailabilityObserver_SpeechRecognitionAvailabilityChanged_Params_Data* object = static_cast<const SpeechRecognitionAvailabilityObserver_SpeechRecognitionAvailabilityChanged_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

SpeechRecognitionAvailabilityObserver_SpeechRecognitionAvailabilityChanged_Params_Data::SpeechRecognitionAvailabilityObserver_SpeechRecognitionAvailabilityChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SpeechRecognitionClientBrowserInterface_BindSpeechRecognitionAvailabilityObserver_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SpeechRecognitionClientBrowserInterface_BindSpeechRecognitionAvailabilityObserver_Params_Data* object = static_cast<const SpeechRecognitionClientBrowserInterface_BindSpeechRecognitionAvailabilityObserver_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->observer, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->observer,
                                                 validation_context)) {
    return false;
  }

  return true;
}

SpeechRecognitionClientBrowserInterface_BindSpeechRecognitionAvailabilityObserver_Params_Data::SpeechRecognitionClientBrowserInterface_BindSpeechRecognitionAvailabilityObserver_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace media
