// media/mojo/mojom/speech_recognition_service.mojom-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "media/mojo/mojom/speech_recognition_service.mojom-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "media/mojo/mojom/media_types.mojom.h"
#include "mojo/public/mojom/base/file_path.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "services/network/public/mojom/url_loader_factory.mojom.h"


#ifndef MEDIA_MOJO_MOJOM_SPEECH_RECOGNITION_SERVICE_MOJOM_JUMBO_H_
#define MEDIA_MOJO_MOJOM_SPEECH_RECOGNITION_SERVICE_MOJOM_JUMBO_H_
#endif


namespace media {
namespace mojom {


void SpeechRecognitionContextInterceptorForTesting::BindRecognizer(::mojo::PendingReceiver<SpeechRecognitionRecognizer> receiver, ::mojo::PendingRemote<SpeechRecognitionRecognizerClient> client, BindRecognizerCallback callback) {
  GetForwardingInterface()->BindRecognizer(std::move(receiver), std::move(client), std::move(callback));
}
SpeechRecognitionContextAsyncWaiter::SpeechRecognitionContextAsyncWaiter(
    SpeechRecognitionContext* proxy) : proxy_(proxy) {}

SpeechRecognitionContextAsyncWaiter::~SpeechRecognitionContextAsyncWaiter() = default;

void SpeechRecognitionContextAsyncWaiter::BindRecognizer(
    ::mojo::PendingReceiver<SpeechRecognitionRecognizer> receiver, ::mojo::PendingRemote<SpeechRecognitionRecognizerClient> client, bool* out_is_multichannel_supported) {
  base::RunLoop loop;
  proxy_->BindRecognizer(std::move(receiver),std::move(client),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_is_multichannel_supported
,
             bool is_multichannel_supported) {*out_is_multichannel_supported = std::move(is_multichannel_supported);
            loop->Quit();
          },
          &loop,
          out_is_multichannel_supported));
  loop.Run();
}



void SpeechRecognitionServiceInterceptorForTesting::BindContext(::mojo::PendingReceiver<SpeechRecognitionContext> context) {
  GetForwardingInterface()->BindContext(std::move(context));
}
void SpeechRecognitionServiceInterceptorForTesting::SetUrlLoaderFactory(::mojo::PendingRemote<::network::mojom::URLLoaderFactory> url_loader_factory) {
  GetForwardingInterface()->SetUrlLoaderFactory(std::move(url_loader_factory));
}
void SpeechRecognitionServiceInterceptorForTesting::SetSodaPath(const ::base::FilePath& binary_path, const ::base::FilePath& config_path) {
  GetForwardingInterface()->SetSodaPath(std::move(binary_path), std::move(config_path));
}
void SpeechRecognitionServiceInterceptorForTesting::BindSpeechRecognitionServiceClient(::mojo::PendingRemote<SpeechRecognitionServiceClient> client) {
  GetForwardingInterface()->BindSpeechRecognitionServiceClient(std::move(client));
}
SpeechRecognitionServiceAsyncWaiter::SpeechRecognitionServiceAsyncWaiter(
    SpeechRecognitionService* proxy) : proxy_(proxy) {}

SpeechRecognitionServiceAsyncWaiter::~SpeechRecognitionServiceAsyncWaiter() = default;




void SpeechRecognitionServiceClientInterceptorForTesting::OnNetworkServiceDisconnect() {
  GetForwardingInterface()->OnNetworkServiceDisconnect();
}
SpeechRecognitionServiceClientAsyncWaiter::SpeechRecognitionServiceClientAsyncWaiter(
    SpeechRecognitionServiceClient* proxy) : proxy_(proxy) {}

SpeechRecognitionServiceClientAsyncWaiter::~SpeechRecognitionServiceClientAsyncWaiter() = default;




void SpeechRecognitionRecognizerInterceptorForTesting::SendAudioToSpeechRecognitionService(::media::mojom::AudioDataS16Ptr buffer) {
  GetForwardingInterface()->SendAudioToSpeechRecognitionService(std::move(buffer));
}
void SpeechRecognitionRecognizerInterceptorForTesting::OnCaptionBubbleClosed() {
  GetForwardingInterface()->OnCaptionBubbleClosed();
}
void SpeechRecognitionRecognizerInterceptorForTesting::AudioReceivedAfterBubbleClosed(::base::TimeDelta duration) {
  GetForwardingInterface()->AudioReceivedAfterBubbleClosed(std::move(duration));
}
SpeechRecognitionRecognizerAsyncWaiter::SpeechRecognitionRecognizerAsyncWaiter(
    SpeechRecognitionRecognizer* proxy) : proxy_(proxy) {}

SpeechRecognitionRecognizerAsyncWaiter::~SpeechRecognitionRecognizerAsyncWaiter() = default;




void SpeechRecognitionRecognizerClientInterceptorForTesting::OnSpeechRecognitionRecognitionEvent(SpeechRecognitionResultPtr result) {
  GetForwardingInterface()->OnSpeechRecognitionRecognitionEvent(std::move(result));
}
SpeechRecognitionRecognizerClientAsyncWaiter::SpeechRecognitionRecognizerClientAsyncWaiter(
    SpeechRecognitionRecognizerClient* proxy) : proxy_(proxy) {}

SpeechRecognitionRecognizerClientAsyncWaiter::~SpeechRecognitionRecognizerClientAsyncWaiter() = default;




void SpeechRecognitionAvailabilityObserverInterceptorForTesting::SpeechRecognitionAvailabilityChanged(bool is_speech_recognition_available) {
  GetForwardingInterface()->SpeechRecognitionAvailabilityChanged(std::move(is_speech_recognition_available));
}
SpeechRecognitionAvailabilityObserverAsyncWaiter::SpeechRecognitionAvailabilityObserverAsyncWaiter(
    SpeechRecognitionAvailabilityObserver* proxy) : proxy_(proxy) {}

SpeechRecognitionAvailabilityObserverAsyncWaiter::~SpeechRecognitionAvailabilityObserverAsyncWaiter() = default;




void SpeechRecognitionClientBrowserInterfaceInterceptorForTesting::BindSpeechRecognitionAvailabilityObserver(::mojo::PendingRemote<SpeechRecognitionAvailabilityObserver> observer) {
  GetForwardingInterface()->BindSpeechRecognitionAvailabilityObserver(std::move(observer));
}
SpeechRecognitionClientBrowserInterfaceAsyncWaiter::SpeechRecognitionClientBrowserInterfaceAsyncWaiter(
    SpeechRecognitionClientBrowserInterface* proxy) : proxy_(proxy) {}

SpeechRecognitionClientBrowserInterfaceAsyncWaiter::~SpeechRecognitionClientBrowserInterfaceAsyncWaiter() = default;






}  // namespace mojom
}  // namespace media

#if defined(__clang__)
#pragma clang diagnostic pop
#endif