// media/mojo/mojom/video_decoder.mojom-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "media/mojo/mojom/video_decoder.mojom-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "gpu/ipc/common/sync_token.mojom.h"
#include "media/mojo/mojom/media_log.mojom.h"
#include "media/mojo/mojom/media_types.mojom.h"
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "ui/gfx/mojom/color_space.mojom.h"


#ifndef MEDIA_MOJO_MOJOM_VIDEO_DECODER_MOJOM_JUMBO_H_
#define MEDIA_MOJO_MOJOM_VIDEO_DECODER_MOJOM_JUMBO_H_
#include "media/mojo/mojom/video_decoder_config_mojom_traits.h"
#endif


namespace media {
namespace mojom {


void VideoFrameHandleReleaserInterceptorForTesting::ReleaseVideoFrame(const ::base::UnguessableToken& release_token, const ::gpu::SyncToken& release_sync_token) {
  GetForwardingInterface()->ReleaseVideoFrame(std::move(release_token), std::move(release_sync_token));
}
VideoFrameHandleReleaserAsyncWaiter::VideoFrameHandleReleaserAsyncWaiter(
    VideoFrameHandleReleaser* proxy) : proxy_(proxy) {}

VideoFrameHandleReleaserAsyncWaiter::~VideoFrameHandleReleaserAsyncWaiter() = default;




void VideoDecoderInterceptorForTesting::GetSupportedConfigs(GetSupportedConfigsCallback callback) {
  GetForwardingInterface()->GetSupportedConfigs(std::move(callback));
}
void VideoDecoderInterceptorForTesting::Construct(::mojo::PendingAssociatedRemote<VideoDecoderClient> client, ::mojo::PendingAssociatedRemote<::media::mojom::MediaLog> media_log, ::mojo::PendingReceiver<VideoFrameHandleReleaser> video_frame_handle_releaser, ::mojo::ScopedDataPipeConsumerHandle decoder_buffer_pipe, CommandBufferIdPtr command_buffer_id, ::media::VideoDecoderImplementation implementation, const ::gfx::ColorSpace& target_color_space) {
  GetForwardingInterface()->Construct(std::move(client), std::move(media_log), std::move(video_frame_handle_releaser), std::move(decoder_buffer_pipe), std::move(command_buffer_id), std::move(implementation), std::move(target_color_space));
}
void VideoDecoderInterceptorForTesting::Initialize(const ::media::VideoDecoderConfig& config, bool low_delay, const base::Optional<::base::UnguessableToken>& cdm_id, InitializeCallback callback) {
  GetForwardingInterface()->Initialize(std::move(config), std::move(low_delay), std::move(cdm_id), std::move(callback));
}
void VideoDecoderInterceptorForTesting::Decode(::media::mojom::DecoderBufferPtr buffer, DecodeCallback callback) {
  GetForwardingInterface()->Decode(std::move(buffer), std::move(callback));
}
void VideoDecoderInterceptorForTesting::Reset(ResetCallback callback) {
  GetForwardingInterface()->Reset(std::move(callback));
}
void VideoDecoderInterceptorForTesting::OnOverlayInfoChanged(const ::media::OverlayInfo& overlay_info) {
  GetForwardingInterface()->OnOverlayInfoChanged(std::move(overlay_info));
}
VideoDecoderAsyncWaiter::VideoDecoderAsyncWaiter(
    VideoDecoder* proxy) : proxy_(proxy) {}

VideoDecoderAsyncWaiter::~VideoDecoderAsyncWaiter() = default;

void VideoDecoderAsyncWaiter::GetSupportedConfigs(
    base::flat_map<::media::VideoDecoderImplementation, std::vector<::media::SupportedVideoDecoderConfig>>* out_supported_configs) {
  base::RunLoop loop;
  proxy_->GetSupportedConfigs(
      base::BindOnce(
          [](base::RunLoop* loop,
             base::flat_map<::media::VideoDecoderImplementation, std::vector<::media::SupportedVideoDecoderConfig>>* out_supported_configs
,
             const base::flat_map<::media::VideoDecoderImplementation, std::vector<::media::SupportedVideoDecoderConfig>>& supported_configs) {*out_supported_configs = std::move(supported_configs);
            loop->Quit();
          },
          &loop,
          out_supported_configs));
  loop.Run();
}
void VideoDecoderAsyncWaiter::Initialize(
    const ::media::VideoDecoderConfig& config, bool low_delay, const base::Optional<::base::UnguessableToken>& cdm_id, ::media::Status* out_status, bool* out_needs_bitstream_conversion, int32_t* out_max_decode_requests, ::media::VideoDecoderType* out_decoder_type) {
  base::RunLoop loop;
  proxy_->Initialize(std::move(config),std::move(low_delay),std::move(cdm_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::media::Status* out_status
,
             bool* out_needs_bitstream_conversion
,
             int32_t* out_max_decode_requests
,
             ::media::VideoDecoderType* out_decoder_type
,
             const ::media::Status& status,
             bool needs_bitstream_conversion,
             int32_t max_decode_requests,
             ::media::VideoDecoderType decoder_type) {*out_status = std::move(status);*out_needs_bitstream_conversion = std::move(needs_bitstream_conversion);*out_max_decode_requests = std::move(max_decode_requests);*out_decoder_type = std::move(decoder_type);
            loop->Quit();
          },
          &loop,
          out_status,
          out_needs_bitstream_conversion,
          out_max_decode_requests,
          out_decoder_type));
  loop.Run();
}
void VideoDecoderAsyncWaiter::Decode(
    ::media::mojom::DecoderBufferPtr buffer, ::media::Status* out_status) {
  base::RunLoop loop;
  proxy_->Decode(std::move(buffer),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::media::Status* out_status
,
             const ::media::Status& status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}
void VideoDecoderAsyncWaiter::Reset(
    ) {
  base::RunLoop loop;
  proxy_->Reset(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void VideoDecoderClientInterceptorForTesting::OnVideoFrameDecoded(const ::scoped_refptr<::media::VideoFrame>& frame, bool can_read_without_stalling, const base::Optional<::base::UnguessableToken>& release_token) {
  GetForwardingInterface()->OnVideoFrameDecoded(std::move(frame), std::move(can_read_without_stalling), std::move(release_token));
}
void VideoDecoderClientInterceptorForTesting::OnWaiting(::media::WaitingReason reason) {
  GetForwardingInterface()->OnWaiting(std::move(reason));
}
void VideoDecoderClientInterceptorForTesting::RequestOverlayInfo(bool restart_for_transitions) {
  GetForwardingInterface()->RequestOverlayInfo(std::move(restart_for_transitions));
}
VideoDecoderClientAsyncWaiter::VideoDecoderClientAsyncWaiter(
    VideoDecoderClient* proxy) : proxy_(proxy) {}

VideoDecoderClientAsyncWaiter::~VideoDecoderClientAsyncWaiter() = default;






}  // namespace mojom
}  // namespace media

#if defined(__clang__)
#pragma clang diagnostic pop
#endif