// media/mojo/mojom/video_encoder_info.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "media/mojo/mojom/video_encoder_info.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/video_encoder_info.mojom-params-data.h"
namespace media {
namespace mojom {

namespace internal {


// static
bool ScalingSettings_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ScalingSettings_Data* object = static_cast<const ScalingSettings_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

ScalingSettings_Data::ScalingSettings_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ResolutionBitrateLimit_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ResolutionBitrateLimit_Data* object = static_cast<const ResolutionBitrateLimit_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_size, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame_size, validation_context))
    return false;

  return true;
}

ResolutionBitrateLimit_Data::ResolutionBitrateLimit_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoEncoderInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VideoEncoderInfo_Data* object = static_cast<const VideoEncoderInfo_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->implementation_name, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams implementation_name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->implementation_name, validation_context,
                                         &implementation_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->scaling_settings, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->fps_allocation, 7, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams fps_allocation_validate_params(
      5, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->fps_allocation, validation_context,
                                         &fps_allocation_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->resolution_bitrate_limits, 8, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams resolution_bitrate_limits_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->resolution_bitrate_limits, validation_context,
                                         &resolution_bitrate_limits_validate_params)) {
    return false;
  }

  return true;
}

VideoEncoderInfo_Data::VideoEncoderInfo_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace media
