// mojo/public/mojom/base/file_error.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "mojo/public/mojom/base/file_error.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "mojo/public/mojom/base/file_error.mojom-params-data.h"
namespace mojo_base {
namespace mojom {

std::string FileErrorToString(FileError value) {
  switch(value) {
    case FileError::IO:
      return "FileError::IO";
    case FileError::INVALID_URL:
      return "FileError::INVALID_URL";
    case FileError::NOT_EMPTY:
      return "FileError::NOT_EMPTY";
    case FileError::NOT_A_FILE:
      return "FileError::NOT_A_FILE";
    case FileError::ABORT:
      return "FileError::ABORT";
    case FileError::SECURITY:
      return "FileError::SECURITY";
    case FileError::INVALID_OPERATION:
      return "FileError::INVALID_OPERATION";
    case FileError::NOT_A_DIRECTORY:
      return "FileError::NOT_A_DIRECTORY";
    case FileError::NO_SPACE:
      return "FileError::NO_SPACE";
    case FileError::NO_MEMORY:
      return "FileError::NO_MEMORY";
    case FileError::TOO_MANY_OPENED:
      return "FileError::TOO_MANY_OPENED";
    case FileError::ACCESS_DENIED:
      return "FileError::ACCESS_DENIED";
    case FileError::NOT_FOUND:
      return "FileError::NOT_FOUND";
    case FileError::EXISTS:
      return "FileError::EXISTS";
    case FileError::IN_USE:
      return "FileError::IN_USE";
    case FileError::FAILED:
      return "FileError::FAILED";
    case FileError::OK:
      return "FileError::OK";
    default:
      return base::StringPrintf("Unknown FileError value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, FileError value) {
  return os << FileErrorToString(value);
}

namespace internal {

}  // namespace internal
}  // namespace mojom
}  // namespace mojo_base

namespace perfetto {

// static
void TraceFormatTraits<::mojo_base::mojom::FileError>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::mojo_base::mojom::FileError value) {
  return std::move(context).WriteString(::mojo_base::mojom::FileErrorToString(value));
}

} // namespace perfetto
