// printing/mojom/print.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "printing/mojom/print.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "printing/mojom/print.mojom-params-data.h"
namespace printing {
namespace mojom {

std::string ColorModelToString(ColorModel value) {
  switch(value) {
    case ColorModel::kUnknownColorModel:
      return "ColorModel::kUnknownColorModel";
    case ColorModel::kGray:
      return "ColorModel::kGray";
    case ColorModel::kColor:
      return "ColorModel::kColor";
    case ColorModel::kCMYK:
      return "ColorModel::kCMYK";
    case ColorModel::kCMY:
      return "ColorModel::kCMY";
    case ColorModel::kKCMY:
      return "ColorModel::kKCMY";
    case ColorModel::kCMYPlusK:
      return "ColorModel::kCMYPlusK";
    case ColorModel::kBlack:
      return "ColorModel::kBlack";
    case ColorModel::kGrayscale:
      return "ColorModel::kGrayscale";
    case ColorModel::kRGB:
      return "ColorModel::kRGB";
    case ColorModel::kRGB16:
      return "ColorModel::kRGB16";
    case ColorModel::kRGBA:
      return "ColorModel::kRGBA";
    case ColorModel::kColorModeColor:
      return "ColorModel::kColorModeColor";
    case ColorModel::kColorModeMonochrome:
      return "ColorModel::kColorModeMonochrome";
    case ColorModel::kHPColorColor:
      return "ColorModel::kHPColorColor";
    case ColorModel::kHPColorBlack:
      return "ColorModel::kHPColorBlack";
    case ColorModel::kPrintoutModeNormal:
      return "ColorModel::kPrintoutModeNormal";
    case ColorModel::kPrintoutModeNormalGray:
      return "ColorModel::kPrintoutModeNormalGray";
    case ColorModel::kProcessColorModelCMYK:
      return "ColorModel::kProcessColorModelCMYK";
    case ColorModel::kProcessColorModelGreyscale:
      return "ColorModel::kProcessColorModelGreyscale";
    case ColorModel::kProcessColorModelRGB:
      return "ColorModel::kProcessColorModelRGB";
    case ColorModel::kBrotherCUPSColor:
      return "ColorModel::kBrotherCUPSColor";
    case ColorModel::kBrotherCUPSMono:
      return "ColorModel::kBrotherCUPSMono";
    case ColorModel::kBrotherBRScript3Color:
      return "ColorModel::kBrotherBRScript3Color";
    case ColorModel::kBrotherBRScript3Black:
      return "ColorModel::kBrotherBRScript3Black";
    case ColorModel::kEpsonInkColor:
      return "ColorModel::kEpsonInkColor";
    case ColorModel::kEpsonInkMono:
      return "ColorModel::kEpsonInkMono";
    case ColorModel::kSharpARCModeCMColor:
      return "ColorModel::kSharpARCModeCMColor";
    case ColorModel::kSharpARCModeCMBW:
      return "ColorModel::kSharpARCModeCMBW";
    case ColorModel::kXeroxXRXColorAutomatic:
      return "ColorModel::kXeroxXRXColorAutomatic";
    case ColorModel::kXeroxXRXColorBW:
      return "ColorModel::{kXeroxXRXColorBW, kColorModelLast}";
    default:
      return base::StringPrintf("Unknown ColorModel value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, ColorModel value) {
  return os << ColorModelToString(value);
}

std::string DuplexModeToString(DuplexMode value) {
  switch(value) {
    case DuplexMode::kUnknownDuplexMode:
      return "DuplexMode::kUnknownDuplexMode";
    case DuplexMode::kSimplex:
      return "DuplexMode::kSimplex";
    case DuplexMode::kLongEdge:
      return "DuplexMode::kLongEdge";
    case DuplexMode::kShortEdge:
      return "DuplexMode::kShortEdge";
    default:
      return base::StringPrintf("Unknown DuplexMode value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, DuplexMode value) {
  return os << DuplexModeToString(value);
}

std::string PageOrientationToString(PageOrientation value) {
  switch(value) {
    case PageOrientation::kUpright:
      return "PageOrientation::kUpright";
    case PageOrientation::kRotateLeft:
      return "PageOrientation::kRotateLeft";
    case PageOrientation::kRotateRight:
      return "PageOrientation::kRotateRight";
    default:
      return base::StringPrintf("Unknown PageOrientation value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, PageOrientation value) {
  return os << PageOrientationToString(value);
}

std::string PrintScalingOptionToString(PrintScalingOption value) {
  switch(value) {
    case PrintScalingOption::kNone:
      return "PrintScalingOption::kNone";
    case PrintScalingOption::kFitToPrintableArea:
      return "PrintScalingOption::kFitToPrintableArea";
    case PrintScalingOption::kSourceSize:
      return "PrintScalingOption::kSourceSize";
    case PrintScalingOption::kFitToPaper:
      return "PrintScalingOption::kFitToPaper";
    default:
      return base::StringPrintf("Unknown PrintScalingOption value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, PrintScalingOption value) {
  return os << PrintScalingOptionToString(value);
}

std::string SkiaDocumentTypeToString(SkiaDocumentType value) {
  switch(value) {
    case SkiaDocumentType::kPDF:
      return "SkiaDocumentType::kPDF";
    case SkiaDocumentType::kMSKP:
      return "SkiaDocumentType::kMSKP";
    default:
      return base::StringPrintf("Unknown SkiaDocumentType value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, SkiaDocumentType value) {
  return os << SkiaDocumentTypeToString(value);
}

std::string MarginTypeToString(MarginType value) {
  switch(value) {
    case MarginType::kDefaultMargins:
      return "MarginType::kDefaultMargins";
    case MarginType::kNoMargins:
      return "MarginType::kNoMargins";
    case MarginType::kPrintableAreaMargins:
      return "MarginType::kPrintableAreaMargins";
    case MarginType::kCustomMargins:
      return "MarginType::kCustomMargins";
    default:
      return base::StringPrintf("Unknown MarginType value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, MarginType value) {
  return os << MarginTypeToString(value);
}

namespace internal {


// static
bool PageSizeMargins_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PageSizeMargins_Data* object = static_cast<const PageSizeMargins_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

PageSizeMargins_Data::PageSizeMargins_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace printing

namespace perfetto {

// static
void TraceFormatTraits<::printing::mojom::ColorModel>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::printing::mojom::ColorModel value) {
  return std::move(context).WriteString(::printing::mojom::ColorModelToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::printing::mojom::DuplexMode>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::printing::mojom::DuplexMode value) {
  return std::move(context).WriteString(::printing::mojom::DuplexModeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::printing::mojom::PageOrientation>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::printing::mojom::PageOrientation value) {
  return std::move(context).WriteString(::printing::mojom::PageOrientationToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::printing::mojom::PrintScalingOption>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::printing::mojom::PrintScalingOption value) {
  return std::move(context).WriteString(::printing::mojom::PrintScalingOptionToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::printing::mojom::SkiaDocumentType>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::printing::mojom::SkiaDocumentType value) {
  return std::move(context).WriteString(::printing::mojom::SkiaDocumentTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::printing::mojom::MarginType>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::printing::mojom::MarginType value) {
  return std::move(context).WriteString(::printing::mojom::MarginTypeToString(value));
}

} // namespace perfetto
